<?php

function validateSignUpInput ($arr){
    $errors = array();
    $charLimit = 3;

    if($arr['username'] === ''){
        $errors->username = 'Username must be specified';
    }
    if(count($arr['username']) < $charLimit){
        $errors->username = 'Username must be more than ' . $charLimit . ' characters';
    }

    if($arr['email'] === ''){
        $errors->email = 'Email must be Specified';
    }
    if(!filter_var($arr['email'], FILTER_VALIDATE_EMAIL)){
        $errors->email = 'Invalid Email format';
    }

    
    if($arr['password'] === ''){
        $errors->password = 'Password must be Specified';
    }
    if($arr['password'] < $charLimit){
        $errors->password = 'Password not strong enough!';
    }

    return $errors;
}

function replace_dashes($string, $encode = false) {
    if($encode){
        $string = str_replace(" ", "-", $string);
    }else{
        $string = str_replace("-", " ", $string);
    }

    return $string;
}

function hashPassword($val){
    return $val;
    // return md5($val);
}

function redirect($location){
    header('location: ' . $location);
}