<?php

    require 'db.connect.php';
    require 'helpers/func/helper.php';
    
    $message = '';
    $charLimit = 3;
    $errors = array('username' => '', 'email' => '', 'password' => '');

    if(isset($_SESSION['username'])){
        redirect('/eduask');
    }

    if(isset($_POST['submit'])){
        if($_POST['username'] === ''){
            $errors['username'] = 'Username must be specified';
        }
        if(count($_POST['username']) < $charLimit){
            $errors['username'] = 'Username must be more than ' . $charLimit . ' characters';
        }
    
        if($_POST['email'] === ''){
            $errors['email'] = 'Email must be Specified';
        }
        if(!filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)){
            $errors['email'] = 'Invalid Email format';
        }
    
        
        if($_POST['password'] === ''){
            $errors['password'] = 'Password must be Specified';
        }
        if($_POST['password'] < $charLimit){
            $errors['password'] = 'Password not strong enough!';
        }

        $username = $_POST['username'];
        $email = $_POST['email'];
        $password = $_POST['password'];
        $role = $_POST['role'];

        $sql = 'INSERT INTO users (username, email, password, role) VALUES ("'.$username.'", "'.$email.'", "'.hashPassword($password).'", "'.$role.'")';

        if ($conn->query($sql) === TRUE) {
            $sql = "SELECT * FROM users WHERE email = '".$email."'";

            $result = $conn->query($sql);

            if ($result->num_rows > 0) {
                // output data of each row
                $row = $result->fetch_assoc();
                $id = $row['id'];
                $username = $row['username'];
                $email = $row['email'];
                $result_password = $row['password'];
                $role = $row['role'];
                $avatar = $row['avatar'];

                if (hashPassword($password) !== $result_password){
                    $errors['password'] = "Incorrect password.";
                }else{
                    // require_once "mail-confirm.php"
                    $_SESSION['id'] = $id;
                    $_SESSION['username'] = $username;
                    $_SESSION['avatar'] = $avatar;
                    $_SESSION['signed_in'] = true;

                    redirect("/eduask");
                }
            } else {
                $errorMessage = 'User do not exist. Please sign in';
            }
        } else {
            print "Error: " . $sql . "<br>" . $conn->error;
        }
    }

?>

<form class="col s12" method="post" action="">
    <?php print $message;?>
    <div class="row">
        <div class="input-field col s12">
            <input id="username" type="text" name="username" class="validate">
            <label for="username" data-error="wrong" data-success="right">Username</label>
            <?php print $errors['username'];?>
        </div>
    </div>
    <div class="row">
        <div class="input-field col s12">
            <input id="email" type="email" name="email" class="validate">
            <label for="email" data-error="wrong" data-success="right">Email</label>
            <?php print $errors['email'];?>
        </div>
    </div>
    <div class="row">
        <div class="input-field col s12">
            <input id="password" type="password" name="password" class="validate">
            <label for="password" data-error="wrong" data-success="right">Password</label>
            <?php print $errors['password'];?>
        </div>
    </div>
    <div class="row">
        <div class="input-field col s12">
            <select name="role">
                <option value="" disabled selected>Choose your Role</option>
                <option value="teacher">Teacher</option>
                <option value="student">Student</option
            </select>
            <label>Role</label>
        </div>
    </div>
    <div class="row">
        <div class="input-field">
            <input id="submitBtn" name="submit" type="submit" class="waves-effect waves-light btn black col s12" />
        </div>
    </div>
</form>