<?php

if ( !function_exists( 'learn_press_woo_is_active' ) ) {
	/**
	 * Check WooCommerce is active
	 *
	 * @return bool
	 */
	function learn_press_woo_is_active() {
		if ( !function_exists( 'is_plugin_active' ) ) {
			include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		}
		return class_exists( 'WC_Install' ) && is_plugin_active( 'woocommerce/woocommerce.php' );
	}

}
add_action( 'plugins_loaded', 'learn_press_woocommerce_course' );
function learn_press_woocommerce_course() {

	if( !learn_press_woo_is_active() ){
		return;
	}
	/**
	 * Class WC_Product_LPR_Course
	 */
	class WC_Product_LPR_Course extends WC_Product_Simple {

		/**
		 * Get Price Description
		 */
		function get_price() {
			return learn_press_get_course_price( $this->post->ID );
		}

		/**
		 * Check if a product is purchasable
		 */
		function is_purchasable() {
			return learn_press_get_user_course_status() == '';
		}
	}
}

/**
 * Class LPR_Payment_Gateway_Woo
 */
class LPR_Payment_Gateway_Woo {

	/**
	 * Construct function
	 */
	function __construct() {
		add_filter( 'learn_press_payment_method', array( $this, 'add_payment_woo' ) );
		add_filter( 'woocommerce_add_to_cart_handler', array( $this, 'add_to_cart_handler' ), 10, 2 );
		add_filter( 'learn_press_take_course_woo', array( $this, 'take_course' ) );
		add_filter( 'woocommerce_product_class', array( $this, 'product_class' ), 10, 4 );
		add_filter( 'learn_press_payment_gateway_available_woo', array( $this, 'woo_available' ), 10, 2 );
		add_filter( 'learn_press_payment_method_from_slug_woocommerce-payment', array( $this, 'payment_name' ) );
		add_filter( 'learn_press_print_payment_woo', array( $this, 'print_form' ) );

		add_action( 'learn_press_section_payment_woo', array( $this, 'payment_woo_output' ) );
		add_action( 'learn_press_save_payment_woo', array( $this, 'save_payment_woo' ) );
		add_action( 'learn_press_payment_gateway_form_woo', array( $this, 'woo_payment_form' ) );
		add_action( 'woocommerce_add_to_cart_handler_WC_Product_LPR_Course', array( $this, 'add_to_cart_handler_course' ) );
		//add_action( 'woocommerce_new_order', array( $this, 'add_order' ) );
		add_action( 'woocommerce_checkout_order_processed', array( $this, 'add_order' ) );
		add_action( 'woocommerce_order_status_changed', array( $this, 'order_status_changed' ), 10, 3 );
		add_action( 'learn_press_before_payment_loop', array( $this, 'print_payment_methods' ) );

		learn_press_enqueue_script( $this->get_script() );
	}

	/**
	 * Get Script
	 */
	function get_script() {
		ob_start();
		?>
		<script>
			;
			(function () {
				var $form = $('#learn_press_payment_form');
				$form.on('learn_press_place_order', function () {
					var chosen = $('input[type="radio"]:checked', $form);
					if (chosen.val() == 'woo') {
						$form.append('<input type="hidden" name="woo_chosen_method" value="' + chosen.data('method') + '"/>');
					}
				});
			})();
		</script>
		<?php
		$script = ob_get_clean();
		return preg_replace( '!</?script>!', '', $script );
	}

	/**
	 * Print form
	 */
	function print_form() {
		$payment_gateways = WC()->payment_gateways()->get_available_payment_gateways();
		if ( $payment_gateways ) foreach ( $payment_gateways as $payment_gateway ) {
			$slug    = "woo";
			$checked = checked( WC()->session->get( 'chosen_payment_method' ) == $payment_gateway->id ? true : false, true, false );
			?>
			<li class="learn_press_woo_payment_methods">

				<label><input type="radio" name="payment_method" value="<?php echo $slug; ?>" data-method="<?php echo $payment_gateway->id; ?>" <?php echo $checked; ?> /> <?php echo $payment_gateway->title; ?>
				</label>

				<div class="learn_press_payment_form" id="learn_press_payment_form_<?php echo $slug; ?>">
					<?php echo $payment_gateway->description; ?>
				</div>
			</li>
			<?php
		}
		return false;
	}

	function print_payment_methods() {

	}

	/**
	 * Payment Name
	 */
	function payment_name( $slug ) {
		return 'WooCommerce Payment';
	}

	/**
	 * Add Woo payment
	 */
	function add_payment_woo( $methods ) {
		$methods['woo'] = 'WooCommerce';
		return $methods;
	}

	/**
	 * Enable Woo Payment
	 */
	function woo_available( $available, $gateway ) {
		return LPR_Settings::instance( 'payment' )->get( 'woo.enable' );
	}

	/**
	 * Woo Payment output
	 */
	function payment_woo_output() {
		$settings = LPR_Admin_Settings::instance( 'payment' );
		?>
		<tr>
			<th scope="row"><label><?php _e( 'Enable', 'learnpress_woo_payment' ); ?></label></th>
			<td>
				<input type="checkbox" name="lpr_settings[woo][enable]" <?php checked( $settings->get( 'woo.enable' ) ? 1 : 0, 1 ); ?> />
			</td>
		</tr>
		<?php
	}

	/**
	 * Save payment
	 */
	function save_payment_woo() {
		$settings = LPR_Admin_Settings::instance( 'payment' );

		$post_data = !empty( $_POST['lpr_settings'] ) ? $_POST['lpr_settings']['woo'] : array();
		$settings->set( 'woo', $post_data );
		$settings->update();
	}

	/**
	 * Add to cart
	 *
	 * @param string - product type
	 * @param object - product object
	 *
	 * @return string
	 */
	function add_to_cart_handler( $type, $product ) {
		if ( get_post_type( $product->id ) == 'lpr_course' ) {
			return 'WC_Product_LPR_Course';
		}
		return $type;
	}

	/**
	 * Woo Payment Form
	 */
	function woo_payment_form() {
		_e( 'Pay with WooCommerce payment system', 'learnpress_woo_payment' );
	}

	/**
	 * Take course
	 */
	function take_course( $order ) {

		$method = !empty( $_REQUEST['woo_chosen_method'] ) ? $_REQUEST['woo_chosen_method'] : '';
		if ( $method ) {
			WC()->session->set( 'chosen_payment_method', $method );
		}

		$this->add_to_cart_handler_course();

		$url = false;
		$url = apply_filters( 'woocommerce_add_to_cart_redirect', $url );

		// If has custom URL redirect there
		if ( !$url ) {
			$url = WC()->cart->get_checkout_url();
		}
		if ( $url ) {
			$json = array(
				'result'   => 'Success',
				'redirect' => $url
			);
		} else {
			$json = array(
				'result'  => 'fail',
				'message' => __( 'WooCommerce checkout page is not setting up!', 'learnpress_woo_payment' )
			);
		}

		return $json;
	}

	/**
	 * Add course cart handler
	 */
	function add_to_cart_handler_course() {
		$add_to_cart = $_REQUEST['course_id'];
		$product_id  = absint( $add_to_cart );

		if ( $product_id && get_post_type( $product_id ) == 'lpr_course' ) {
			WC()->cart->empty_cart( true );

			if ( WC()->cart->add_to_cart( $product_id, 1 ) ) {
			}
		}
	}

	/**
	 * Check if a course is purchasable
	 *
	 * @param  bool   $is_purchasable
	 * @param  string $product
	 *
	 * @return bool
	 */
	function is_purchasable_course( $is_purchasable, $product ) {
		if ( 'lpr_course' == get_post_type( $product->post->ID ) ) {
			$is_purchasable = true;
		}
		return $is_purchasable;
	}

	/**
	 * Change product class
	 *
	 * @param  string $classname
	 * @param  string $product_type
	 * @param  string $post_type
	 * @param  string $product_id
	 *
	 * @return string
	 */
	function product_class( $classname, $product_type, $post_type, $product_id ) {
		if ( 'lpr_course' == $post_type ) {
			$classname = 'WC_Product_LPR_Course';
		}
		return $classname;
	}

	/**
	 * Add new order
	 *
	 * @param int $order_id
	 */
	function add_order( $order_id ) {
		$order          = wc_get_order( $order_id );
		$transaction_id = $order->get_transaction_id();
		$user_id        = $order->customer_user;
		$status         = $order->get_status();
		$items = $this->get_wc_items( $order_id );

		$lpr_order_id   = get_post_meta( $order_id, '_learn_press_order_id', true );
		$lpr_order_id   = learn_press_add_transaction(
			array(
				'order_id'           => $lpr_order_id,
				'method'             => 'woocommerce-payment',
				'method_id'          => $transaction_id,
				'status'             => 'lp-' . $status,
				'user_id'            => $user_id,
				'transaction_object' => learn_press_generate_transaction_object()
			)
		);

		if ( $lpr_order_id ) {
			update_post_meta( $order_id, '_learn_press_order_id', $lpr_order_id );
			update_post_meta( $lpr_order_id, '_wc_order_id', $order_id );
		}
	}

	function get_wc_items( $order_id ){
		global $wpdb;
		$query = $wpdb->prepare("
			SELECT *
			FROM {$wpdb->prefix}woocommerce_order_items oi
			WHERE oi.order_id = %d
		", $order_id );
		$items = $wpdb->get_results( $query );
		return $items;
	}

	function generate_transaction_object(){

	}

	/**
	 * Update order status
	 *
	 * @param  int  $order_id
	 * @param  char $old_status
	 * @param  char $new_status
	 */
	function order_status_changed( $order_id, $old_status, $new_status ) {
		$wc_order = wc_get_order( $order_id );
		if ( $lpr_order_id = get_post_meta( $order_id, '_learn_press_order_id', true ) ) {
			learn_press_add_transaction(
				array(
					'order_id'           => $lpr_order_id,
					'method'             => 'woocommerce-payment',
					'method_id'          => $wc_order->get_transaction_id(),
					'status'             => $new_status,
					'user_id'            => $wc_order->user_id,
					'transaction_object' => ''
				)
			);
			learn_press_update_order_status( $lpr_order_id, $new_status );
		}
	}
}

// Starts
new LPR_Payment_Gateway_Woo();

