<?php
/*
Plugin Name: LearnPress WooCommerce Payment methods
Plugin URI: http://thimpress.com/learnpress
Description: Using the payment system provided by WooCommerce
Author: thimpress
Version: 0.9.4
Author URI: http://thimpress.com
Tags: learnpress,woocommerce
Requires at least: 3.8  
Tested up to: 4.1
Last updated: 2015-12-01 3:29pm GMT
*/
if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

define( "LPR_WOO_PAYMENT_ADDON", dirname( __FILE__ ) );

/**
 * Register WooCommerce addon
 */
function learn_press_register_woocommerce_payment() {
	require_once( LPR_WOO_PAYMENT_ADDON . '/init.php' );
}

add_action( 'learn_press_loaded', 'learn_press_register_woocommerce_payment' );

function learnpress_woo_payment_translations() {
	$textdomain    = 'learnpress_woo_payment';
	$locale        = apply_filters( "plugin_locale", get_locale(), $textdomain );
	$lang_dir      = dirname( __FILE__ ) . '/lang/';
	$mofile        = sprintf( '%s.mo', $locale );
	$mofile_local  = $lang_dir . $mofile;
	$mofile_global = WP_LANG_DIR . '/plugins/' . $mofile;
	if ( file_exists( $mofile_global ) ) {
		load_textdomain( $textdomain, $mofile_global );
	} else {
		load_textdomain( $textdomain, $mofile_local );
	}
}

add_action( 'plugins_loaded', 'learnpress_woo_payment_translations' );