var sowEmitters = {

	/**
	 * Find the group/state and an extra match part.
	 *
	 * @param arg
	 * @param matchPart
	 * @return {*}
	 */
	'_match': function (arg, matchPart) {
		if (typeof matchPart === 'undefined') {
			matchPart = '.*';
		}

		// Create the regular expression to match the group/state and extra match
		var exp = new RegExp('^([a-zA-Z0-9_-]+)(\\[([a-zA-Z0-9_-]+)\\])? *: *(' + matchPart + ') *$');
		var m = exp.exec(arg);

		if (m === null) {
			return false;
		}

		var state = '';
		var group = 'default';

		if (m[3] !== undefined) {
			group = m[1];
			state = m[3];
		}
		else {
			state = m[1];
		}

		return {
			'match': m[4].trim(),
			'group': group,
			'state': state
		};
	},

	'_checker': function (val, args, matchPart, callback) {
		var returnStates = {};
		if (typeof args.length === 'undefined') {
			args = [args];
		}

		var m;
		for (var i = 0; i < args.length; i++) {
			m = sowEmitters._match(args[i], matchPart);
			if (m === false) {
				continue;
			}

			if (m.match === '_true' || callback(val, args, m.match)) {
				returnStates[m.group] = m.state;
			}
		}

		return returnStates;
	},

	/**
	 * A very simple state emitter that simply sets the given group the value
	 *
	 *
	 * @param val
	 * @param args
	 * @returns {{}}
	 */
	'select': function (val, args) {
		if (typeof args.length === 'undefined') {
			args = [args];
		}

		var returnGroups = {};
		for (var i = 0; i < args.length; i++) {
			if (args[i] === '') {
				args[i] = 'default';
			}
			returnGroups[args[i]] = val;
		}

		return returnGroups;
	},

	/**
	 * The conditional state emitter uses eval to check a given conditional argument.
	 *
	 * @param val
	 * @param args
	 * @return {{}}
	 */
	'conditional': function (val, args) {
		return sowEmitters._checker(val, args, '[^;{}]*', function (val, args, match) {
			return eval(match);
		});
	},

	/**
	 * The in state emitter checks if the value is in an array of functions
	 *
	 * @param val
	 * @param args
	 * @return {{}}
	 */
	'in': function (val, args) {
		return sowEmitters._checker(val, args, '[^;{}]*', function (val, args, match) {
			return match.split(',').map(function (s) {
					return s.trim();
				}).indexOf(val) !== -1;
		});
	}
};
(function ($) {

	$.fn.obSetupForm = function () {
		return $(this).each(function (i, el) {
			var $el = $(el), $mainForm, formInitializing = true;

			// Skip this if we've already set up the form
			if ($el.is('.thim-widget-form-main')) {
				if ($el.data('sow-form-setup') == true)
					return true;
				if ($('body').hasClass('widgets-php') && !$el.is(':visible'))
					return true;
				// Listen for a state change event if this is the main form wrapper
				$el.on('sowstatechange', function (e, incomingGroup, incomingState) {

					// Find all wrappers that have state handlers on them
					$el.find('[data-state-handler]').each(function () {
						var $$ = $(this);

						// Create a copy of the current state handlers. Add in initial handlers if the form is initializing.
						var handler = $.extend({}, $$.data('state-handler'), formInitializing ? $$.data('state-handler-initial') : {});
						if (Object.keys(handler).length === 0) {
							return true;
						}

						// We need to figure out what the incoming state is
						var handlerStateParts, handlerState, thisHandler, $$f, runHandler;

						// Indicates if the handler has run
						var handlerRun = {};

						// Go through all the handlers
						for (var state in handler) {
							runHandler = false;

							// Parse the handler state parts
							handlerStateParts = state.match(/^([a-zA-Z0-9_-]+)(\[([a-zA-Z0-9_-]+)\])?(\[\])?$/);
							if (handlerStateParts === null) {
								// Skip this if there's a problem with the state parts
								continue;
							}

							handlerState = {
								'group': 'default',
								'name' : '',
								'multi': false
							};

							// Assign the handlerState attributes based on the parsed state
							if (handlerStateParts[2] !== undefined) {
								handlerState.group = handlerStateParts[1];
								handlerState.name = handlerStateParts[3];
							}
							else {
								handlerState.name = handlerStateParts[0];
							}
							handlerState.multi = (handlerStateParts[4] !== undefined);

							if (handlerState.group === '_else') {
								// This is the special case of an group else handler
								// Always run if no handlers from the current group have been run yet
								handlerState.group = handlerState.name;
								handlerState.name = '';

								// We will run this handler because none have run for it yet
								runHandler = ( typeof handlerRun[handlerState.group] === 'undefined' );
							}
							else {
								// Evaluate if we're in the current state
								runHandler = (handlerState.group === incomingGroup && handlerState.name === incomingState);
							}


							// Run the handler if previous checks have determined we should
							if (runHandler) {
								thisHandler = handler[state];

								// Now we can handle the the handler
								if (!handlerState.multi) {
									thisHandler = [thisHandler];
								}

								for (var i = 0; i < thisHandler.length; i++) {
									// Choose the item we'll be acting on here
									if (typeof thisHandler[i][1] !== 'undefined' && Boolean(thisHandler[i][1])) {
										// thisHandler[i][1] is the sub selector
										$$f = $$.find(thisHandler[i][1]);
									}
									else {
										$$f = $$;
									}

									// Call the function on the wrapper we've selected
									$$f[thisHandler[i][0]].apply($$f, typeof thisHandler[i][2] !== 'undefined' ? thisHandler[i][2] : []);

								}

								// Store that we've run a handler
								handlerRun[handlerState.group] = true;
							}
						}

					});
				});

				// Lets set up the preview
				$el.obSetupPreview();
				$mainForm = $el;
				// Lets set up the preview

			}
			else {
				$mainForm = $el.closest('.thim-widget-form-main');
			}
			// Find any field or sub widget fields.
			var $fields = $el.find('> .thim-widget-field');

			// Process any sub sections
			$fields.find('> .thim-widget-section').obSetupForm();

			// Store the field names
			$fields.find('.thim-widget-input').each(function (i, input) {
				if ($(input).data('original-name') == null) {
					$(input).data('original-name', $(input).attr('name'));
				}
			});

			// Setup all the repeaters
			$fields.find('> .thim-widget-field-repeater').obSetupRepeater();

			// For any repeater items currently in existence
			$el.find('.thim-widget-field-repeater-item').obSetupRepeaterActions();

			//// Set up any color fields
			//$fields.find('> .tp-colorpicker').wpColorPicker()
			// Set up any color fields
			$fields.find('> .thim-widget-input-color').wpColorPicker()
				.closest('.thim-widget-field').find('a').click(function () {
					if (typeof $.fn.dialog != 'undefined') {
						$(this).closest('.panel-dialog').dialog("option", "position", "center");
					}
				});

			// handle the media field. Check that this is working
			$fields.find('> .media-field-wrapper').each(function () {
				var $media = $(this);
				// Handle the media uploader
				$media.find('a.media-upload-button').click(function (event) {
					if (typeof wp.media == 'undefined')
						return;

					var $$ = $(this);
					var $c = $(this).closest('.thim-widget-field');
					var frame = $(this).data('frame');

					// If the media frame already exists, reopen it.
					if (frame) {
						frame.open();
						return false;
					}

					// Create the media frame.
					frame = wp.media({
						// Set the title of the modal.
						title  : $$.data('choose'),
						// Tell the modal to show only images.
						library: {
							type: $$.data('library').split(',').map(function (v) {
								return v.trim()
							})
						},
						// Customize the submit button.
						button : {
							// Set the text of the button.
							text : $$.data('update'),
							// Tell the button not to close the modal, since we're
							// going to refresh the page when the image is selected.
							close: false
						},
						//multiple : true
					});

					// Store the frame
					$$.data('frame', frame);

					// When an image is selected, run a callback.
					frame.on('select', function () {
						// Grab the selected attachment.
						var attachment = frame.state().get('selection').first().attributes;

						$c.find('.current .title').html(attachment.title);
						$c.find('input[type=hidden]').val(attachment.id);

						if (typeof attachment.sizes != 'undefined') {
							if (typeof attachment.sizes.thumbnail != 'undefined')
								$c.find('.current .thumbnail').attr('src', attachment.sizes.thumbnail.url).fadeIn();
							else
								$c.find('.current .thumbnail').attr('src', attachment.sizes.full.url).fadeIn();
						}
						else {
							$c.find('.current .thumbnail').attr('src', attachment.icon).fadeIn();
						}

						frame.close();
					});

					// Finally, open the modal.
					frame.open();

					return false;
				});

				// Show/hide the remove button when hovering over the media select button.
				$media
					.mouseenter(function () {
						if ($(this).closest('.thim-widget-field').find('input[type=hidden]').val() != '')
							$(this).find('.media-remove-button').fadeIn('fast');
					})
					.mouseleave(function () {
						$(this).find('.media-remove-button').fadeOut('fast');
					})

				$media.find('.current')
					.mouseenter(function () {
						var t = $(this).find('.title');
						if (t.html() != '') {
							t.fadeIn('fast');
						}
					})
					.mouseleave(function () {
						$(this).find('.title').clearQueue().fadeOut('fast');
					})

				$media.find('a.media-remove-button')
					.click(function () {
						var $$ = $(this).closest('.thim-widget-field');
						$$.find('.current .title').html('');
						$$.find('input[type=hidden]').val('');
						$$.find('.current .thumbnail').fadeOut('fast');
						$(this).fadeOut('fast');
					});

			})

			/* Multi Media */
			// handle the media field. Check that this is working
			$fields.find('> .multi-media-field-wrapper').each(function () {
				var $media = $(this);
				var $ulist = $media.find(".media-content");
				$ulist.sortable({
					items : 'li',
					update: function () {
						var $vl = $ulist.sortable('toArray').toString();
						$media.closest('.thim-widget-field').find('input[type=hidden]').val($vl);
					}
				});

				// Handle the media uploader
				$media.find('a.media-upload-button').click(function (event) {
					if (typeof wp.media == 'undefined')
						return;

					var $$ = $(this);
					var $c = $(this).closest('.thim-widget-field');
					var frame = $(this).data('frame');

					// If the media frame already exists, reopen it.
					if (frame) {
						frame.open();
						return false;
					}

					// Create the media frame.
					frame = wp.media({
						// Set the title of the modal.
						title   : $$.data('choose'),
						// Tell the modal to show only images.
						library : {
							type: $$.data('library').split(',').map(function (v) {
								return v.trim()
							})
						},
						// Customize the submit button.
						button  : {
							// Set the text of the button.
							text : $$.data('update'),
							// Tell the button not to close the modal, since we're
							// going to refresh the page when the image is selected.
							close: false
						},
						multiple: true
					});

					// Store the frame
					$$.data('frame', frame);

					// When an image is selected, run a callback.
					frame.on('select', function () {
						// Grab the selected attachment.
						var selection = frame.state().get('selection');
						$val = "";
						selection.map(function (attachment) {
							attachment = attachment.toJSON();
							if (!$val)
								$val += attachment.id;
							else $val += "," + attachment.id;
							$media.find(".media-content").append('<li id="' + attachment.id + '" class="current"><div class="thumbnail-wrapper"><img src="' + attachment.sizes.full.url + '" class="thumbnail"><a href="#" class="media-remove-button">Remove></a></div></li');
						});
						var $vl = $ulist.sortable('toArray').toString();
						$media.closest('.thim-widget-field').find('input[type=hidden]').val($vl);

						frame.close();
					});

					// Finally, open the modal.
					frame.open();

					return false;
				});

				// Show/hide the remove button when hovering over the media select button.
				$media
					.mouseenter(function () {
						if ($(this).closest('.thim-widget-field').find('input[type=hidden]').val() != '')
							$(this).find('.multimedia-remove-button').fadeIn('fast');
					})
					.mouseleave(function () {
						$(this).find('.multimedia-remove-button').fadeOut('fast');
					})

				$media.find('.current')
					.mouseenter(function () {
						var t = $(this).find('.title');
						if (t.html() != '') {
							t.fadeIn('fast');
						}
					})
					.mouseleave(function () {
						$(this).find('.title').clearQueue().fadeOut('fast');
					})

				$media.find('a.multimedia-remove-button')
					.click(function () {
						$(this).closest('li').remove();
						var $vl = $ulist.sortable('toArray').toString();
						$media.closest('.thim-widget-field').find('input[type=hidden]').val($vl);
					});

			});

			// Handle toggling of the sub widget form
			$fields.filter('.thim-widget-field-type-widget, .thim-widget-field-type-section').find('> label').click(function () {
				var $$ = $(this);
				$(this).toggleClass('thim-widget-section-visible');
//				console.log("abc");
				$(this).siblings('.thim-widget-section').slideToggle();
//				$(this).siblings('.thim-widget-section').slideToggle(function () {
//					console.log("xyz");
//					// Center the PB dialog
//					if (typeof $.fn.dialog != 'undefined') {
//						$(this).closest('.panel-dialog').dialog("option", "position", "center");
//					}
//				});
			});

			$('body').on('change', '.tp-radio-image input', function () {
				var $this = $(this),
					type = $this.attr('type'),
					selected = $this.is(':checked'),
					$parent = $this.parent(),
					$others = $parent.siblings();
				if (selected) {
					$parent.addClass('tp-radio-active');
					type == 'radio' && $others.removeClass('tp-radio-active');
				}
				else {
					$parent.removeClass('tp-radio-active');
				}
			});
			$('.tp-radio-image input').trigger('change');

			$fields.filter('.thim-widget-field-type-slider').each(function () {
				var $$ = $(this);
				var $input = $$.find('input[type="number"]');
				var $c = $$.find('.thim-widget-value-slider');

				$c.slider({
					max  : parseInt($input.attr('max')),
					min  : parseInt($input.attr('min')),
					value: parseInt($input.val()),
					step : 1,
					slide: function (event, ui) {
						$input.val(parseInt(ui.value));
						$$.find('.thim-widget-slider-value').html(ui.value);
					}
				});
			});
			///////////////////////////////////////
			// Now lets handle the state emitters

			var stateEmitterChangeHandler = function () {
				var $$ = $(this);

				// These emitters can either be an array or a
				var emitters = $$.closest('[data-state-emitter]').data('state-emitter');

				if (typeof emitters !== 'undefined') {
					var handleStateEmitter = function (emitter, currentStates) {
						if (typeof sowEmitters[emitter.callback] === 'undefined' || emitter.callback.substr(0, 1) === '_') {
							// Skip if the function doesn't exist, or it starts with an underscore.
							return currentStates;
						}

						// Return an array that has the new states added to the array
						return $.extend(currentStates, sowEmitters[emitter.callback]($$.val(), emitter.args));
					};

					// Run the states through the state emitters
					var states = {'default': ''};

					// Go through the array of emitters
					if (typeof emitters.length === 'undefined') {
						emitters = [emitters];
					}
					for (var i = 0; i < emitters.length; i++) {
						states = handleStateEmitter(emitters[i], states);
					}

					// Check which states have changed and trigger appropriate sowstatechange
					var formStates = $mainForm.data('states');
					if (typeof formStates === 'undefined') {
						formStates = {'default': ''};
					}
					for (var k in states) {
						if (typeof formStates[k] === 'undefined' || states[k] !== formStates[k]) {
							// If the state is different from the original formStates, then trigger a state change
							formStates[k] = states[k];
							$mainForm.trigger('sowstatechange', [k, states[k]]);
						}
					}

					// Store the form states back in the form
					$mainForm.data('states', formStates);
				}
			};

			$fields.filter('[data-state-emitter]').each(function () {

				// Listen for any change events on an emitter field
				$(this).find('.ob-widget-input').on('keyup change', stateEmitterChangeHandler);

				// Trigger changes on all necessary fields
				$(this).find('.ob-widget-input').each(function () {
					var $$ = $(this);
					if ($$.is(':radio')) {
						// Only checked radio inputs must have change events
						if ($$.is(':checked')) {
							stateEmitterChangeHandler.call($$[0]);
						}
					} else {
						stateEmitterChangeHandler.call($$[0]);
					}
				});

			});


			// Give plugins a chance to influence the form
			$el.trigger('sowsetupform').data('sow-form-setup', true);
			$el.find('.thim-widget-field-repeater-item').trigger('updateFieldPositions');

			/********
			 * The end of the form setup.
			 *******/
		});
	};

	$.fn.obSetupPreview = function () {
		var $el = $(this);
		var previewButton = $el.siblings('.thim-widget-preview');

		previewButton.find('> a').click(function (e) {
			e.preventDefault();
			var data = {};

			$el.find('*[name]').each(function () {
				var $$ = $(this);
				var name = /[a-zA-Z\-]+\[[0-9]+\]\[(.*)\]/.exec($$.attr('name'));

				name = name[1];
				parts = name.split('][');

				// Make sure we either have numbers or strings
				parts = parts.map(function (e) {
					if (!isNaN(parseFloat(e)) && isFinite(e))
						return parseInt(e);
					else
						return e;
				});

				var sub = data;
				for (var i = 0; i < parts.length; i++) {
					if (i == parts.length - 1) {
						// This is the end, so we need to store the actual field value here
						if ($$.attr('type') == 'checkbox') {
							if ($$.is(':checked'))
								sub[parts[i]] = $$.val() != '' ? $$.val() : true;
						}
						else
							sub[parts[i]] = $$.val();
					}
					else {
						if (typeof sub[parts[i]] == 'undefined') {
							sub[parts[i]] = {};
						}
						// Go deeper into the data and continue
						sub = sub[parts[i]];
					}
				}
			});

			// Create the modal
			var overlay = $('<div class="thim-widgets-preview-modal-overlay"></div>').appendTo('body');
			var modal = $('<div class="thim-widgets-preview-modal"></div>').appendTo('body');
			var close = $('<div class="thim-widgets-preview-close dashicons dashicons-no"></div>').appendTo(modal);
			var iframe = $('<iframe class="thim-widgets-preview-iframe" scrolling="no"></iframe>').appendTo(modal);

			$.post(
				ajaxurl,
				{
					'action': 'so_widgets_preview',
					'data'  : JSON.stringify(data),
					'class' : $el.data('class')
				},
				function (html) {
					iframe.contents().find('body').html(html);
				}
			);

			close.add(overlay).click(function () {
				overlay.remove();
				modal.remove();
			});
		});
	}

	$.fn.obSetupRepeater = function () {

		return $(this).each(function (i, el) {
			var $el = $(el);
			var $items = $el.find('.thim-widget-field-repeater-items');
			var name = $el.data('repeater-name');

			$items.bind('updateFieldPositions', function () {
				var $$ = $(this);

				// Set the position for the repeater items
				$$.find('> .thim-widget-field-repeater-item').each(function (i, el) {
					$(el).find('.thim-widget-input').each(function (j, input) {
						var pos = $(input).data('repeater-positions');
						if (typeof pos == 'undefined') {
							pos = {};
						}

						pos[name] = i;
						$(input).data('repeater-positions', pos);
					});
				});

				// Update the field names for all the input items
				$$.find('.thim-widget-input').each(function (i, input) {
					var pos = $(input).data('repeater-positions');
					var $in = $(input);

					if (typeof pos != 'undefined') {
						var newName = $in.data('original-name');

						if (typeof newName == 'undefined') {
							$in.data('original-name', $in.attr('name'));
							newName = $in.attr('name');
						}

						for (var k in pos) {
							newName = newName.replace('#' + k + '#', pos[k]);
						}
						$(input).attr('name', newName);
					}
				});

			});

			$items.sortable({
				handle: '.thim-widget-field-repeater-item-top',
				items : '> .thim-widget-field-repeater-item',
				update: function () {
					$items.trigger('updateFieldPositions');
				}
			});
			$items.trigger('updateFieldPositions');

			$el.find('> .thim-widget-field-repeater-add').disableSelection().click(function (e) {
				e.preventDefault();
				$el.closest('.thim-widget-field-repeater')
					.obAddRepeaterItem()
					.find('> .thim-widget-field-repeater-items').slideDown('fast');

				// Center the PB dialog
				if (typeof $.fn.dialog != 'undefined') {
					$(this).closest('.panel-dialog').dialog("option", "position", "center");
				}

			});

			$el.find('> .thim-widget-field-repeater-top > .thim-widget-field-repeater-expend').click(function (e) {
				e.preventDefault();
				$el.closest('.thim-widget-field-repeater').find('> .thim-widget-field-repeater-items').slideToggle('fast');
			});
		});
	};

	$.fn.obAddRepeaterItem = function () {
		return $(this).each(function (i, el) {

			var $el = $(el);
			var theClass = $el.closest('.thim-widget-form').data('class');

			var formClass = $el.closest('.thim-widget-form').data('class');

			var item = $('<div class="thim-widget-field-repeater-item" />')
				.append(
				$('<div class="thim-widget-field-repeater-item-top" />')
					.append(
					$('<div class="thim-widget-field-expand" />')
				)
					.append(
					$('<div class="thim-widget-field-remove" />')
				)
					.append($('<h4 />').html($el.data('item-name')))
			)
				.append(
				$('<div class="thim-widget-field-repeater-item-form" />')
					.html(window.ob_repeater_html[formClass][$el.data('repeater-name')])
			)
				.obSetupRepeaterActions();

			// Add the item and refresh
			$el.find('> .thim-widget-field-repeater-items').append(item).sortable("refresh").trigger('updateFieldPositions');
			item.hide().slideDown('fast');

		});
	};

	$.fn.obSetupRepeaterActions = function () {
		return $(this).each(function (i, el) {
			var $el = $(el);

			if (typeof $el.data('sowrepeater-actions-setup') == 'undefined') {
				var top = $el.find('> .thim-widget-field-repeater-item-top');

				top.find('.thim-widget-field-expand')
					.click(function (e) {
						e.preventDefault();
						$(this).closest('.thim-widget-field-repeater-item').find('.thim-widget-field-repeater-item-form').eq(0).slideToggle('fast');
					});

				top.find('.thim-widget-field-remove')
					.click(function (e) {
						e.preventDefault();
						if (confirm(soWidgets.sure)) {
							var $s = $(this).closest('.thim-widget-field-repeater-items');
							$(this).closest('.thim-widget-field-repeater-item').slideUp('fast', function () {
								$(this).remove();
								$s.sortable("refresh").trigger('updateFieldPositions');
							});
						}
					});

				$el.find('> .thim-widget-field-repeater-item-form').obSetupForm();

				$el.data('sowrepeater-actions-setup', true);
			}
		});
	}

	// When we click on a widget top
	$('.widgets-holder-wrap').on('click', '.widget:has(.thim-widget-form-main) .widget-top', function () {
		var $$ = $(this).closest('.widget').find('.thim-widget-form-main');
		setTimeout(function () {
			$$.obSetupForm();
		}, 200);
	});

	// When we open a Page Builder widget dialog
	$(document).on('dialogopen', function (e) {
		$(e.target).find('.thim-widget-form-main').obSetupForm();
	});
})(jQuery);