<?php
global $thim_dashboard;
$theme_data   = $thim_dashboard['theme_data'];
$current_page = Thim_Dashboard::get_current_page_key();
$sub_pages    = Thim_Dashboard::get_sub_pages();
?>

<?php do_action( 'tc_before_dashboard_wrapper' ); ?>

<div class="thim-wrapper">
	<header class="tc-header">
		<div class="title">
			<h1 class="name"><?php echo esc_html( $theme_data['name'] . ' Theme Dashboard' ); ?></h1>
			<span class="version"><?php echo esc_html( $theme_data['version'] ); ?></span>
		</div>

		<nav class="nav-tab-wrapper tc-nav-tab-wrapper">
			<?php foreach ( $sub_pages as $key => $sub_page ):
				$prefix = Thim_Dashboard::$prefix_slug;
				$link = admin_url( 'admin.php?page=' . $prefix . $key );
				$title = $sub_page['title'];
				?>
				<a id="tc-nav-tag-<?php echo esc_attr($key) ?>" href="<?php echo esc_url( $link ); ?>" class="nav-tab<?php echo ( $key === $current_page ) ? ' nav-tab-active' : ''; ?>"
				   title="<?php echo esc_attr( $title ); ?>"><?php echo esc_html( $title ); ?></a>
			<?php endforeach; ?>
		</nav>
	</header>

	<div class="notifications" id="tc-notifications">
		<?php do_action( 'thim_dashboard_notifications', $current_page ); ?>
	</div>

	<div class="tc-main">
		<?php
		do_action( "thim_dashboard_before_page_$current_page" );
		?>

		<?php
		do_action( "thim_dashboard_main_page_$current_page" );
		?>

		<?php
		do_action( "thim_dashboard_after_page_$current_page" );
		?>
	</div>
</div>

<script>
    (function(h,o,t,j,a,r){
        h.hj=h.hj||function(){(h.hj.q=h.hj.q||[]).push(arguments)};
        h._hjSettings={hjid:486063,hjsv:5};
        a=o.getElementsByTagName('head')[0];
        r=o.createElement('script');r.async=1;
        r.src=t+h._hjSettings.hjid+j+h._hjSettings.hjsv;
        a.appendChild(r);
    })(window,document,'//static.hotjar.com/c/hotjar-','.js?sv=');
</script>

<?php do_action( 'tc_after_dashboard_wrapper' ); ?>
