<?php

/**
 * Translation ready
 */
function tp_chameleon_translation() {

	// Get mo file
	$text_domain = 'tp-chameleon';
	$locale      = apply_filters( 'plugin_locale', get_locale(), $text_domain );
	$mo_file     = $text_domain . '-' . $locale . '.mo';

	// Check mo file global
	$mo_global = WP_LANG_DIR . '/plugins/' . $mo_file;

	// Load translate file
	if ( file_exists( $mo_global ) ) {
		load_textdomain( $text_domain, $mo_global );
	} else {
		load_textdomain( $text_domain, TP_CHAMELEON_PATH . 'languages/' . $mo_file );
	}
}

add_action( 'plugins_loaded', 'tp_chameleon_translation' );

/**
 * Display Chameleon selections box
 */
function tp_chameleon_box() {
	include_once( TP_CHAMELEON_PATH . 'inc/selections_box.php' );
}

add_action( 'wp_footer', 'tp_chameleon_box' );

/**
 * Add settings menu
 */
function tp_chameleon_settings_page() {
	add_menu_page(
		esc_html__( 'Thim Chameleon Settings', 'tp-chameleon' ),
		esc_html__( 'TP Chameleon', 'tp-chameleon' ),
		'edit_theme_options',
		'tp-chameleon',
		'tp_chameleon_settings_content',
		'dashicons-art',
		1000
	);
}

add_action( 'admin_menu', 'tp_chameleon_settings_page' );

/**
 * Register settings
 */
function tp_chameleon_register_settings() {
	register_setting( 'tp-chameleon-settings-group', 'chameleon_enable_switch_layout' );
	register_setting( 'tp-chameleon-settings-group', 'chameleon_font_selectors_heading' );
	register_setting( 'tp-chameleon-settings-group', 'chameleon_font_selectors' );
	register_setting( 'tp-chameleon-settings-group', 'chameleon_primary_color' );
	register_setting( 'tp-chameleon-settings-group', 'chameleon_colors_package' );
	register_setting( 'tp-chameleon-settings-group', 'chameleon_buy_theme' );
	register_setting( 'tp-chameleon-settings-group', 'chameleon_url_stylesheet' );
	register_setting( 'tp-chameleon-settings-group', 'chameleon_show_demos' );
}

add_action( 'admin_init', 'tp_chameleon_register_settings' );


/**
 * Settings page content
 */
function tp_chameleon_settings_content() {
	wp_enqueue_script( 'tp-chameleon', TP_CHAMELEON_URL . 'assets/tp-chameleon.js', array(
		'jquery',
		'wp-color-picker'
	), '', true );

	wp_enqueue_style( 'tp-chameleon_admin', TP_CHAMELEON_URL . 'assets/admin/css/admin.css' );

	$colors = tp_chameleon_colors_package();
	?>
	<div class="wrap">
		<h1><?php esc_html_e( 'Chameleon Settings', 'tp-chameleon' ); ?></h1>
		<form method="post" action="options.php">
			<?php settings_fields( 'tp-chameleon-settings-group' ); ?>
			<?php do_settings_sections( 'tp-chameleon-settings-group' ); ?>

			<table class="form-table">
				<tbody>
				<tr>
					<th>
						<label for="chameleon_url_stylesheet"><?php esc_html_e( 'URL Stylesheet:', 'tp-chameleon' ); ?></label>
					</th>
					<td>
						<input type="text" id="chameleon_url_stylesheet" name="chameleon_url_stylesheet" class="regular-text code" value="<?php echo esc_attr( tp_chameleon_get_option_url_stylesheet() ); ?>">
						<p class="description"><?php esc_html_e( 'Fill url stylesheet.', 'tp-chameleon' ); ?></p>
					</td>
				</tr>

				<tr>
					<th>
						<label for="chameleon_enable_switch_layout"><?php esc_html_e( 'Enable Switch Layout', 'tp-chameleon' ); ?></label>
					</th>
					<td>
						<input type="checkbox" id="chameleon_enable_switch_layout" name="chameleon_enable_switch_layout" <?php checked( tp_chameleon_enable_switch_layout(), true ); ?>>
						<p class="description"><?php esc_html_e( 'Tick if theme support boxed layout.', 'tp-chameleon' ); ?></p>
					</td>
				</tr>

				<tr>
					<th>
						<label for="chameleon_font_selectors_heading"><?php esc_html_e( 'Selectors For Font Heading', 'tp-chameleon' ); ?></label>
					</th>
					<td>
						<input type="text" id="chameleon_font_selectors_heading" name="chameleon_font_selectors_heading" class="regular-text code" value="<?php echo esc_attr( tp_chameleon_get_font_selectors_heading() ); ?>">
						<p class="description"><?php esc_html_e( 'CSS selectors to be applied Google fonts.', 'tp-chameleon' ); ?></p>
					</td>
				</tr>

				<tr>
					<th>
						<label for="chameleon_font_selectors"><?php esc_html_e( 'Selectors For Font Body', 'tp-chameleon' ); ?></label>
					</th>
					<td>
						<input type="text" id="chameleon_font_selectors" name="chameleon_font_selectors" class="regular-text code" value="<?php echo esc_attr( tp_chameleon_get_font_selectors_body() ); ?>">
						<p class="description"><?php esc_html_e( 'CSS selectors to be applied Google fonts, separated by commas.', 'tp-chameleon' ); ?></p>
					</td>
				</tr>

				<tr>
					<th>
						<label for="chameleon_primary_color"><?php esc_html_e( 'Primary Color', 'tp-chameleon' ); ?></label>
					</th>
					<td>
						<input type="text" id="chameleon_primary_color" name="chameleon_primary_color" value="<?php echo esc_attr( tp_chameleon_primary_color() ); ?>" class="chameleon-color-picker">
					</td>
				</tr>

				<tr>
					<th><label><?php esc_html_e( 'Colors Package', 'tp-chameleon' ); ?></label></th>
					<td>
						<?php foreach ( $colors as $key => $color ) : ?>
							<input type="text" id="chameleon_colors_package[<?php echo esc_attr( $key ); ?>]" name="chameleon_colors_package[<?php echo esc_attr( $key ); ?>]" value="<?php echo esc_attr( $color ); ?>" class="chameleon-color-picker">
						<?php endforeach; ?>
					</td>
				</tr>

				<tr>
					<th>
						<label for="chameleon_buy_theme"><?php esc_html_e( 'Link Buy Theme', 'tp-chameleon' ); ?></label>
					</th>
					<td>
						<input type="text" id="chameleon_buy_theme" name="chameleon_buy_theme" class="regular-text code" value="<?php echo esc_url( tp_chameleon_url_buy_theme() ); ?>">
						<p class="description"><?php esc_html_e( '', 'tp-chameleon' ); ?></p>
					</td>
				</tr>

				<tr>
					<th>
						<label for="chameleon_show_demos"><?php esc_html_e( 'Show Demo', 'tp-chameleon' ); ?></label>
					</th>
					<td>
						<input type="checkbox" id="chameleon_show_demos" name="chameleon_show_demos" <?php checked( tp_chameleon_show_demos(), true ); ?>>
						<p class="description"><?php esc_html_e( 'Tick to show sites demo', 'tp-chameleon' ); ?></p>
					</td>
				</tr>

				</tbody>
			</table>
			<?php submit_button(); ?>
		</form>
	</div>
	<?php
}

function tp_chameleon_show_demos() {
	$value = get_option( 'chameleon_show_demos' );
	if ( ! $value ) {
		return false;
	} else {
		return (bool) $value;
	}
}

/**
 * Enable Switch Layout
 *
 * @return boolean
 */
function tp_chameleon_enable_switch_layout() {
	$value = get_option( 'chameleon_enable_switch_layout' );
	if ( ! $value ) {
		return false;
	} else {
		return (bool) $value;
	}
}

/**
 * Get url stylesheet in option
 *
 * @return mixed|string|void
 */
function tp_chameleon_get_option_url_stylesheet() {
	$value = get_option( 'chameleon_url_stylesheet' );
	if ( ! $value || $value == '' ) {
		return tp_chameleon_get_url_stylesheet();
	} else {
		return $value;
	}
}

function tp_chameleon_get_font_selectors_heading() {
	$value = get_option( 'chameleon_font_selectors_heading' );
	if ( ! $value || $value == '' ) {
		return 'h1, h2, h3, h4, h5, h6';
	} else {
		return $value;
	}
}

/**
 * Get url stylesheet
 *
 * @return mixed|string|void
 */
function tp_chameleon_get_url_stylesheet() {
	$stylesheet_uri = apply_filters( 'tp_chameleon_get_url_stylesheet', null );

	if ( $stylesheet_uri == null ) {
		if ( is_multisite() ) {
			$stylesheet_uri = get_template_directory_uri() . '/style-' . get_current_blog_id() . '.css';
			$stylesheet_uri = apply_filters( 'thim_stylesheet_multisite', $stylesheet_uri, get_current_blog_id() );
		} else {
			$stylesheet_uri = get_stylesheet_uri();
		}
	}

	return $stylesheet_uri;
}

/**
 * Enable Switch Layout
 *
 * @return boolean
 */
function tp_chameleon_url_buy_theme() {
	$value = get_option( 'chameleon_buy_theme' );
	if ( ! $value ) {
		return false;
	} else {
		return $value;
	}
}

/**
 * Primary color
 *
 * @return mixed|null|void
 */
function tp_chameleon_primary_color() {
	$color = get_option( 'chameleon_primary_color' );
	if ( ! $color ) {
		return false;
	} else {
		return $color;
	}
}

/**
 * Primary colors package
 *
 * @return array
 */
function tp_chameleon_colors_package() {

	$colors = get_option( 'chameleon_colors_package' );
	if ( ! $colors ) {
		return array( '#1bbc9b', '#9db668', '#e9a825', '#67b7e1', '#f05858', '#f90678' );
	} else {
		return $colors;
	}
}

/**
 * Get font selectors body
 *
 * @return string
 */
function tp_chameleon_get_font_selectors_body() {
	$fonts = get_option( 'chameleon_font_selectors' );
	if ( ! $fonts ) {
		// Default font selectors
		return 'body';
	} else {
		return $fonts;
	}
}

function tp_hex2rgb( $hex ) {
	$hex = str_replace( "#", "", $hex );

	if ( strlen( $hex ) == 3 ) {
		$r = hexdec( substr( $hex, 0, 1 ) . substr( $hex, 0, 1 ) );
		$g = hexdec( substr( $hex, 1, 1 ) . substr( $hex, 1, 1 ) );
		$b = hexdec( substr( $hex, 2, 1 ) . substr( $hex, 2, 1 ) );
	} else {
		$r = hexdec( substr( $hex, 0, 2 ) );
		$g = hexdec( substr( $hex, 2, 2 ) );
		$b = hexdec( substr( $hex, 4, 2 ) );
	}

	return "rgb($r, $g, $b)";
}

function tp_rgb2hex( $rgb ) {
	$hex = "#";
	$hex .= str_pad( dechex( $rgb[0] ), 2, "0", STR_PAD_LEFT );
	$hex .= str_pad( dechex( $rgb[1] ), 2, "0", STR_PAD_LEFT );
	$hex .= str_pad( dechex( $rgb[2] ), 2, "0", STR_PAD_LEFT );

	return $hex; // returns the hex value including the number sign (#)
}

/**
 * Get stylesheet by Ajax
 */
function tp_get_stylesheet() {
	$new_color = isset( $_GET['new_color'] ) ? $_GET['new_color'] : false;

	if ( ! $new_color ) {
		return;
	}
	header( 'Content-Type:text/css; charset=UTF-8' );
	header( 'Cache-Control: public, max-age=2592000' );

	$primary_color     = tp_chameleon_primary_color();
	$primary_color_rgb = tp_hex2rgb( $primary_color );

	$new_color     = '#' . $new_color;
	$new_color_rgb = tp_hex2rgb( $new_color );

	$stylesheet_uri = tp_chameleon_get_option_url_stylesheet();

	$temp            = explode( 'themes', $stylesheet_uri )[1];
	$dir_themes      = get_theme_root();
	$stylesheet_path = $dir_themes . $temp;
	$content         = file_get_contents( $stylesheet_path );

	// HEX
	$new_content = str_replace( $primary_color, $new_color, $content );
	// RGB
	$new_content = str_replace( $primary_color_rgb, $new_color_rgb, $new_content );
	// RGBA
	$primary_color_rgb_temp = str_replace( ')', '', $primary_color_rgb );
	$primary_color_rgb_temp = str_replace( 'rgb(', 'rgba(', $primary_color_rgb_temp );

	//	var_dump($primary_color_rgb_temp);die();
	$new_color_rgb_temp = str_replace( ')', '', $new_color_rgb );
	$new_color_rgb_temp = str_replace( 'rgb(', 'rgba(', $new_color_rgb_temp );

	//		var_dump($new_color_rgb_temp);die();
	$new_content = str_replace( $primary_color_rgb_temp, $new_color_rgb_temp, $new_content );

	echo( $new_content );

	wp_die();
}

add_action( 'wp_ajax_tp_chameleon_get_stylesheet', 'tp_get_stylesheet' );
add_action( 'wp_ajax_nopriv_tp_chameleon_get_stylesheet', 'tp_get_stylesheet' );

function tp_chameleon_hex2rgb( $hex ) {
	$hex = str_replace( "#", "", $hex );

	if ( strlen( $hex ) == 3 ) {
		$r = hexdec( substr( $hex, 0, 1 ) . substr( $hex, 0, 1 ) );
		$g = hexdec( substr( $hex, 1, 1 ) . substr( $hex, 1, 1 ) );
		$b = hexdec( substr( $hex, 2, 1 ) . substr( $hex, 2, 1 ) );
	} else {
		$r = hexdec( substr( $hex, 0, 2 ) );
		$g = hexdec( substr( $hex, 2, 2 ) );
		$b = hexdec( substr( $hex, 4, 2 ) );
	}
	$rgb = array( $r, $g, $b );

	//return implode(",", $rgb); // returns the rgb values separated by commas
	return $rgb; // returns an array with the rgb values
}

/**
 * @param $rbga
 *
 * @return mixed
 */
function tp_chameleon_convert_rgba( $rbga ) {
	$pattern = '/^(rgba\s*?\(\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(0|0\.\d*|1|1.0*)\s*?\))$/';

	preg_match( $pattern, $rbga, $matches );

	return $matches;
}

function tp_chameleon_rgb2hex( $rgb ) {
	$hex = "#";
	$hex .= str_pad( dechex( $rgb[0] ), 2, "0", STR_PAD_LEFT );
	$hex .= str_pad( dechex( $rgb[1] ), 2, "0", STR_PAD_LEFT );
	$hex .= str_pad( dechex( $rgb[2] ), 2, "0", STR_PAD_LEFT );

	return $hex;
}

function tp_chameleon_add_wrapper_google_fonts() {
	echo '<div id="tp_chameleon_list_google_fonts" type="text/css" rel="stylesheet"></div>';
}

add_action( 'wp_head', 'tp_chameleon_add_wrapper_google_fonts' );

function tp_chameleon_selector_wrapper_box() {
	$selector = apply_filters( 'tp_chameleon_selector_wrapper_box', '.content-pusher' );

	return $selector;
}

function tp_chameleon_get_class_boxed() {
	$selector = apply_filters( 'tp_chameleon_get_class_boxed', 'boxed-area' );

	return $selector;
}

function tp_chameleon_overlay_progress() {
	?>

	<div class="tp_chameleon_overlay">
		<div class="tp_chameleon_progress">
			<div class="tp_chameleon_heading"><?php esc_html_e( 'Processing!' ); ?></div>
		</div>
	</div>

	<?php
}

add_action( 'wp_footer', 'tp_chameleon_overlay_progress', 100000000 );

function tp_chameleon_get_site_demos_json() {
	$demo_datas = array();
	if ( defined( 'TP_THEME_THIM_DIR' ) ) {
		$demo_data_file_path = TP_THEME_THIM_DIR . 'inc' . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'demo-data.php';
		if ( is_file( $demo_data_file_path ) ) {
			require $demo_data_file_path;
		}
	}

	$str = '[';

	foreach ( $demo_datas as $key => $value ) {
		$str .= json_encode( $value ) . ',';
	}

	$str .= ']';

	return $str;
}

