<?php wp_enqueue_style( 'tp-chameleon', TP_CHAMELEON_URL . 'assets/tp-chameleon.css' ); ?>
<?php $colors = tp_chameleon_colors_package(); ?>
<?php $fonts = tp_chameleon_fonts(); ?>

<div id="tp_style_selector">
	<div class="tp_style_selector_container">

		<?php if ( tp_chameleon_url_buy_theme() != false ) : ?>
			<div class="tp-buy-theme">
				<a href="<?php echo esc_url( tp_chameleon_url_buy_theme() ); ?>" title="<?php esc_attr_e( 'Buy Now', 'tp-chameleon' ); ?>"><?php esc_html_e( 'Buy Now!', 'tp-chameleon' ); ?></a>
			</div>
		<?php endif; ?>

		<?php if ( tp_chameleon_enable_switch_layout() ) : ?>
			<div class="box-title"><?php esc_html_e( 'Layout', 'tp-chameleon' ); ?></div>
			<div class="input-box">
				<a href="#" class="tp-btn tp-change-layout layout-wide active">Wide</a>
				<a href="#" class="tp-btn tp-change-layout layout-boxed">Boxed</a>
				<br class="clear_fix">
			</div>

			<div class="box-title boxed-mode"><?php esc_html_e( 'Patterns for Boxed Version', 'tp-chameleon' ); ?></div>
			<div class="images patterns boxed-mode">
				<a href="#" class="tp_pattern pattern1" data-src="pattern1.png"></a>
				<a href="#" class="tp_pattern pattern2" data-src="pattern2.png"></a>
				<a href="#" class="tp_pattern pattern3" data-src="pattern3.png"></a>
				<a href="#" class="tp_pattern pattern4" data-src="pattern4.png"></a>
				<a href="#" class="tp_pattern pattern5" data-src="pattern5.png"></a>
				<a href="#" class="tp_pattern pattern6" data-src="pattern6.png"></a>
				<a href="#" class="tp_pattern pattern7" data-src="pattern7.png"></a>
				<a href="#" class="tp_pattern pattern8" data-src="pattern8.png"></a>
				<a href="#" class="tp_pattern pattern9" data-src="pattern9.png"></a>
				<a href="#" class="tp_pattern pattern10" data-src="pattern10.png"></a>
			</div>
			<div class="box-title boxed-mode"><?php esc_html_e( 'Images for Boxed Version', 'tp-chameleon' ); ?></div>
			<div class="images patterns boxed-mode">
				<a href="#" class="tp_image bgfix1" data-src="bgfix1.jpg"></a>
				<a href="#" class="tp_image bgfix2" data-src="bgfix2.jpg"></a>
				<a href="#" class="tp_image bgfix3" data-src="bgfix3.jpg"></a>
				<a href="#" class="tp_image bgfix4" data-src="bgfix4.jpg"></a>
				<a href="#" class="tp_image bgfix5" data-src="bgfix5.jpg"></a>
			</div>

		<?php endif; ?>

		<div class="box-title"><?php esc_html_e( 'Choose Primary Color', 'tp-chameleon' ); ?></div>
		<div class="predefined primary_color">
			<?php foreach ( $colors as $key => $color ) : ?>
				<a href="#" style="background-color: <?php echo esc_attr( $color ) ?>" name="color<?php echo esc_attr( $key + 1 ); ?>" data-color="<?php echo esc_attr( str_replace( '#', '', $color ) ) ?>"></a>
			<?php endforeach; ?>
		</div>
		<div class="box-title"><?php esc_html_e( 'Body Font', 'tp-chameleon' ); ?></div>
		<div class="input-box">
			<div class="input">
				<select name="body_font">
					<?php foreach ( $fonts as $font ) : ?>
						<option value="<?php echo esc_attr( $font ); ?>" data-id="<?php echo esc_attr( str_replace( ' ', '_', $font ) ); ?>"><?php echo esc_html( $font ); ?></option>
					<?php endforeach; ?>
				</select>
			</div>
		</div>

		<div class="box-title"><?php esc_html_e( 'Heading Font', 'tp-chameleon' ); ?></div>
		<div class="input-box">
			<div class="input">
				<select name="heading_font">
					<?php foreach ( $fonts as $font ) : ?>
						<option value="<?php echo esc_attr( $font ); ?>" data-id="<?php echo esc_attr( str_replace( ' ', '_', $font ) ); ?>"><?php echo esc_html( $font ); ?></option>
					<?php endforeach; ?>
				</select>
			</div>
		</div>

		<div class="input-box">
			<a href="#" class="tp-btn tp-chameleon-clear"><?php esc_html_e( 'Clear', 'tp-chameleon' ); ?></a>
			<br class="clear_fix">
		</div>

		<?php if ( tp_chameleon_show_demos() ): ?>
			<div class="input-box">
				<button class="tp-btn tp-chameleon-more-demo"><?php esc_html_e( 'More Demo', 'tp-chameleon' ); ?></button>
				<br class="clear_fix">
			</div>
		<?php endif; ?>

		<div class="tp_chameleon_demos">
		</div>
	</div>
	<div class="style-toggle close"></div>
	<div class="style-toggle open"></div>
</div>

<script type="text/javascript">
	var tp_chameleon_str_all_demo = '<?php esc_html_e( 'All Demo', 'tp-chameleon' ); ?>';
	var tp_chameleon_url_stylesheet = '<?php echo tp_chameleon_get_option_url_stylesheet(); ?>';
	var tp_chameleon_url_admin_ajax = '<?php echo admin_url( 'admin-ajax.php' ); ?>';
	var tp_chameleon_wp_nonce = '<?php echo wp_create_nonce( 'tp_chameleon_get_stylesheet' ); ?>';
	var tp_chameleon_primary_color = '<?php echo tp_hex2rgb( tp_chameleon_primary_color() ); ?>';
	var tp_chameleon_selector_wrapper_box = '<?php echo tp_chameleon_selector_wrapper_box(); ?>';
	var tp_chameleon_class_boxed = '<?php echo tp_chameleon_get_class_boxed(); ?>';
	var tp_chameleon_src_patterns = '<?php echo TP_CHAMELEON_URL . 'images/patterns/'; ?>';
	var tp_tp_chameleon_selectors_body_fonts = '<?php echo tp_chameleon_get_font_selectors_body(); ?>';
	var tp_tp_chameleon_selectors_heading_fonts = '<?php echo tp_chameleon_get_font_selectors_heading(); ?>';
	var tp_chameleon_setting = {
		layout           : tp_chameleon_getCookie('tp_chameleon_layout'),
		pattern_type     : tp_chameleon_getCookie('tp_chameleon_pattern_type'),
		pattern_src      : tp_chameleon_getCookie('tp_chameleon_pattern_src'),
		primary_color    : tp_chameleon_getCookie('tp_chameleon_primary_color'),
		primary_color_rgb: tp_chameleon_getCookie('tp_chameleon_primary_color_rgb'),
		body_font        : tp_chameleon_getCookie('tp_chameleon_body_font'),
		body_font_code   : tp_chameleon_getCookie('tp_chameleon_body_font_code'),
		heading_font     : tp_chameleon_getCookie('tp_chameleon_heading_font'),
		heading_font_code: tp_chameleon_getCookie('tp_chameleon_heading_font_code')
	};

	var tp_chameleon_demos = <?php echo tp_chameleon_get_site_demos_json(); ?>;

	function tp_chameleon_setCookie(cname, cvalue, exdays) {
		var d = new Date();
		d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
		var expires = "expires=" + d.toUTCString();
		document.cookie = cname + "=" + cvalue + "; " + expires;
	}

	function tp_chameleon_deleteCookie(cname) {
		var d = new Date();
		d.setTime(d.getTime() + (24 * 60 * 60 * 1000));
		var expires = "expires=" + d.toUTCString();
		document.cookie = cname + "=; " + expires;
	}

	function tp_chameleon_deleteAllCookie() {
		var all_cookie = [
			'tp_chameleon_layout',
			'tp_chameleon_pattern_type',
			'tp_chameleon_pattern_src',
			'tp_chameleon_primary_color',
			'tp_chameleon_primary_color_rgb',
			'tp_chameleon_body_font',
			'tp_chameleon_body_font_code',
			'tp_chameleon_heading_font',
			'tp_chameleon_heading_font_code'
		];

		for (var i = 0; i < all_cookie.length; i++) {
			tp_chameleon_deleteCookie(all_cookie[i]);
		}
	}

	function tp_chameleon_getCookie(cname) {
		var name = cname + "=";
		var ca = document.cookie.split(';');
		for (var i = 0; i < ca.length; i++) {
			var c = ca[i];
			while (c.charAt(0) == ' ') c = c.substring(1);
			if (c.indexOf(name) == 0) return c.substring(name.length, c.length);
		}

		return '';
	}

	function tp_chameleon_set_first_visit() {
		tp_chameleon_setCookie('tp_chameleon_first_visit', 1, 1);
	}

	function tp_chameleon_check_first_visit() {
		return !(tp_chameleon_getCookie('tp_chameleon_first_visit') == '1' );
	}

	function color2rgba(rgb) {
		var pattern_rgb = /^(rgb\s*?\(\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?\))$/i;
		var check_rgb = pattern_rgb.test(rgb);

		var pattern_rgba = /^(rgba\s*?\(\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(0|0\.\d*|1|1.0*)\s*?\))$/i;

		var opacity = 1;
		if (check_rgb == true) {
			rgb = rgb.match(pattern_rgb);
		} else {
			rgb = rgb.match(pattern_rgba);
			opacity = parseFloat(rgb[5]);
		}

		var red = parseInt(rgb[2]);
		var green = parseInt(rgb[3]);
		var blue = parseInt(rgb[4]);

		return 'rgba(' + red + ', ' + green + ', ' + blue + ', ' + opacity + ')';
	}

	function color2rgb(rgb) {
		var pattern_rgb = /^(rgb\s*?\(\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?\))$/i;
		var check_rgb = pattern_rgb.test(rgb);

		var pattern_rgba = /^(rgba\s*?\(\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(0|0\.\d*|1|1.0*)\s*?\))$/i;

		if (check_rgb == true) {
			rgb = rgb.match(pattern_rgb);
		} else {
			rgb = rgb.match(pattern_rgba);
		}

		var red = parseInt(rgb[2]);
		var green = parseInt(rgb[3]);
		var blue = parseInt(rgb[4]);

		return 'rgb(' + red + ', ' + green + ', ' + blue + ')';
	}

	function get_opacity_color(rgb) {
		var pattern_rgb = /^(rgb\s*?\(\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?\))$/i;
		var check_rgb = pattern_rgb.test(rgb);

		var pattern_rgba = /^(rgba\s*?\(\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(0|0\.\d*|1|1.0*)\s*?\))$/i;

		var opacity = 1;
		if (check_rgb == true) {
			rgb = rgb.match(pattern_rgb);
		} else {
			rgb = rgb.match(pattern_rgba);
			opacity = parseFloat(rgb[5]);
		}

		return opacity;
	}

	function rgb2rgba(rgb, opacity) {
		var pattern_rgb = /^(rgb\s*?\(\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?\))$/i;
		var check_rgb = pattern_rgb.test(rgb);

		var pattern_rgba = /^(rgba\s*?\(\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(000|0?\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\s*?,\s*?(0|0\.\d*|1|1.0*)\s*?\))$/i;

		if (check_rgb == true) {
			rgb = rgb.match(pattern_rgb);
		} else {
			rgb = rgb.match(pattern_rgba);
			opacity = parseFloat(rgb[5]);
		}

		var red = parseInt(rgb[2]);
		var green = parseInt(rgb[3]);
		var blue = parseInt(rgb[4]);

		return 'rgba(' + red + ', ' + green + ', ' + blue + ', ' + opacity + ')';
	}

	jQuery(document).ready(function ($) {
		function tp_chameleon_show_demos() {
			var $demos = $('.tp_chameleon_demos');

			var html = '';

			for (var i = 0; i < tp_chameleon_demos.length; i++) {
				var img_src = tp_chameleon_demos[i].thumbnail_url;
				var demo_url = tp_chameleon_demos[i].demo_url;
				var demo_title = tp_chameleon_demos[i].title;

				var e = '';
				e += '<div class="tp_demo">' +
					'<a href="' + demo_url + '" title="' + demo_title + '" target="_blank">' +
					'<img src="' + img_src + '">' +
					'<div class="sub_title">' + demo_title + '</div>' +
					'</a>' +
					'</div>';
				html += e;
			}

			$demos.html(html);
			$demos.slideDown("slow", function () {
				$('.tp-chameleon-more-demo').text(tp_chameleon_str_all_demo);
				$('#tp_style_selector').focus();
			});
		}

		function tp_chameleon_open() {
			tp_chameleon_set_first_visit();
			$('#tp_style_selector').animate({right: '0px'}, 'medium');
			$('#tp_style_selector .open').hide();
			$('#tp_style_selector .close').show();
		}

		function tp_chameleon_close() {
			$('#tp_style_selector').animate({right: '-300px'}, 'medium');
			$('#tp_style_selector .close').hide();
			$('#tp_style_selector .open').show();
		}


		function tp_change_background_pattern(url_pattern) {
			var $body = $('body');
			$body.removeClass('tp_background_image');
			$body.addClass('tp_background_pattern');
			$body.css('background-image', 'url("' + url_pattern + '")')
		}

		function tp_change_background_image(url_image) {
			var $body = $('body');
			$body.removeClass('tp_background_pattern');
			$body.addClass('tp_background_image');
			$body.css('background-image', 'url("' + url_image + '")')
		}

		function tp_chameleon_change_layout_wide() {
			tp_chameleon_setCookie('tp_chameleon_layout', 'wide', 1);

			var $body = $('body');
			$('.tp-change-layout').removeClass('active');
			$('.tp-change-layout.layout-wide').addClass('active');
			$('#tp_style_selector .boxed-mode').slideUp(300);
			$(tp_chameleon_selector_wrapper_box).removeClass(tp_chameleon_class_boxed);
			$body.css('background-image', 'none');
		}

		function tp_chameleon_change_layout_boxed() {
			tp_chameleon_setCookie('tp_chameleon_layout', 'boxed', 1);
			$('.tp-change-layout').removeClass('active');
			$('.tp-change-layout.layout-boxed').addClass('active');
			$('#tp_style_selector .boxed-mode').slideDown(300);
			$(tp_chameleon_selector_wrapper_box).addClass(tp_chameleon_class_boxed);
		}

		function tp_chameleon_change_primary_color(hex_color, rgb_color) {
			var new_color = hex_color;
			var x_new_color = rgb_color;

			tp_chameleon_setCookie('tp_chameleon_primary_color', new_color, 1);
			tp_chameleon_setCookie('tp_chameleon_primary_color_rgb', x_new_color, 1);

			$('body .wrapper-container *').each(function (index) {
				var color = $(this).css('color');
				var opacity_color = get_opacity_color(color);
				var color_rgba = rgb2rgba(x_new_color, opacity_color);

				var background_color = $(this).css('background-color');
				var opacity_background_color = get_opacity_color(background_color);
				var background_color_rgba = rgb2rgba(x_new_color, opacity_background_color);

				if ($(this).hasClass('tp_primary_background_color')) {
					$(this).css('background-color', background_color_rgba);
				} else if (color2rgb(background_color) == tp_chameleon_primary_color) {
					$(this).css('background-color', background_color_rgba);
					$(this).addClass('tp_primary_background_color');
				}

				if ($(this).hasClass('tp_primary_color')) {
					$(this).css('color', color_rgba);
				} else if (color2rgb(color) == tp_chameleon_primary_color) {
					$(this).css('color', color_rgba);
					$(this).addClass('tp_primary_color');
				}
			});

			var $tp_stylesheet = $('#tp_chameleon_stylesheet');
			var tp_new_url_stylesheet = tp_chameleon_url_admin_ajax + '?action=tp_chameleon_get_stylesheet&new_color=' + new_color;
			$tp_stylesheet.attr('href', tp_new_url_stylesheet);
		}

		function tp_chameleon_change_body_font(current, current_code) {
			tp_chameleon_setCookie('tp_chameleon_body_font', current, 1);
			tp_chameleon_setCookie('tp_chameleon_body_font_code', current_code, 1);
			var style = tp_tp_chameleon_selectors_body_fonts + '{font-family:' + current + '}';

			var $font = $('#tp_chameleon_list_google_fonts #' + current_code);
			if ($font.length == 0) {
				$('#tp_chameleon_list_google_fonts').append('<link id="' + current_code + '" href="//fonts.googleapis.com/css?family=' + current + '" type="text/css" rel="stylesheet">');
			}

			$('#tp_chameleon_body_font').html(style);
		}

		function tp_chameleon_change_heading_font(current, current_code) {
			tp_chameleon_setCookie('tp_chameleon_heading_font', current, 1);
			tp_chameleon_setCookie('tp_chameleon_heading_font_code', current_code, 1);
			var style = tp_tp_chameleon_selectors_heading_fonts + '{font-family:' + current + '!important}';

			var $font = $('#tp_chameleon_list_google_fonts #' + current_code);
			if ($font.length == 0) {
				$('#tp_chameleon_list_google_fonts').append('<link id="' + current_code + '" href="//fonts.googleapis.com/css?family=' + current + '" type="text/css" rel="stylesheet">');
			}

			$('#tp_chameleon_heading_font').html(style);
		}

		function tp_chameleon_change_background_pattern(pattern_src) {
			tp_chameleon_setCookie('tp_chameleon_pattern_src', pattern_src, 1);
			tp_chameleon_setCookie('tp_chameleon_pattern_type', 'pattern', 1);
			var pattern_url = tp_chameleon_src_patterns + pattern_src;
			tp_change_background_pattern(pattern_url);
		}

		function tp_chameleon_change_background_image(pattern_src) {
			tp_chameleon_setCookie('tp_chameleon_pattern_src', pattern_src, 1);
			tp_chameleon_setCookie('tp_chameleon_pattern_type', 'image', 1);
			var pattern_url = tp_chameleon_src_patterns + pattern_src;
			tp_change_background_image(pattern_url);
		}

		var $body_font = '<style id="tp_chameleon_body_font" type="text/css"></style>';
		var $heading_font = '<style id="tp_chameleon_heading_font" type="text/css"></style>';
		var $stylesheet = '<link id="tp_chameleon_stylesheet" type="text/css" rel="stylesheet">';

		var $tp_head = $('head');
		$tp_head.append($stylesheet);

		var $tp_body = $('body');
		$tp_body.append($body_font);
		$tp_body.append($heading_font);

		if (tp_chameleon_setting.layout == 'wide') {
			tp_chameleon_change_layout_wide();
		}
		if (tp_chameleon_setting.layout == 'boxed') {
			tp_chameleon_change_layout_boxed();

			if (tp_chameleon_setting.pattern_type == 'pattern' && tp_chameleon_setting.pattern_src != '') {
				tp_chameleon_change_background_pattern(tp_chameleon_setting.pattern_src);
				$('.tp_pattern[data-src="' + tp_chameleon_setting.pattern_src + '"]').addClass('active');
			}

			if (tp_chameleon_setting.pattern_type == 'image' && tp_chameleon_setting.pattern_src != '') {
				tp_chameleon_change_background_image(tp_chameleon_setting.pattern_src);
				$('.tp_image[data-src="' + tp_chameleon_setting.pattern_src + '"]').addClass('active');
			}
		}

		if (tp_chameleon_setting.primary_color != '' && tp_chameleon_setting.primary_color_rgb != '') {
			tp_chameleon_change_primary_color(tp_chameleon_setting.primary_color, tp_chameleon_setting.primary_color_rgb);
		}

		if (tp_chameleon_setting.body_font != '') {
			tp_chameleon_change_body_font(tp_chameleon_setting.body_font, tp_chameleon_setting.body_font_code);
			$font = $('#tp_style_selector select[name=body_font] option[value="' + tp_chameleon_setting.body_font + '"]');
			$font.attr('selected', 'selected');
		}

		if (tp_chameleon_setting.heading_font != '') {
			tp_chameleon_change_heading_font(tp_chameleon_setting.heading_font, tp_chameleon_setting.heading_font_code);
			$font = $('#tp_style_selector select[name=heading_font] option[value="' + tp_chameleon_setting.heading_font + '"]');
			$font.attr('selected', 'selected');
		}

		$('.tp-chameleon-more-demo').on('click', function (event) {
			event.preventDefault();
			tp_chameleon_show_demos();
		});

		$('.tp-chameleon-clear').click(function (event) {
			event.preventDefault();
			tp_chameleon_deleteAllCookie();
			document.location.reload();
		});

		$('.tp-btn.tp-change-layout').click(function (event) {
			event.preventDefault();

			if ($(this).hasClass('layout-wide')) {
				tp_chameleon_change_layout_wide();
			} else {
				tp_chameleon_change_layout_boxed();
			}
		});

		$('.tp_pattern').click(function (event) {
			event.preventDefault();
			$('.tp_pattern').removeClass('active');
			$('.tp_image').removeClass('active');
			$(this).addClass('active');
			var pattern_src = $(this).attr('data-src');
			tp_chameleon_change_background_pattern(pattern_src);
		});

		$('.tp_image').click(function (event) {
			event.preventDefault();
			$('.tp_pattern').removeClass('active');
			$('.tp_image').removeClass('active');
			$(this).addClass('active');
			var pattern_src = $(this).attr('data-src');
			tp_chameleon_change_background_image(pattern_src);
		});

		/**
		 * Select body font
		 */
		$('#tp_style_selector select[name=body_font]').change(function () {
			var current = $(this).find('option:selected').val();
			var current_code = $(this).find('option:selected').attr('data-id');
			tp_chameleon_change_body_font(current, current_code);
		});

		/**
		 * Select heading font
		 */
		$('#tp_style_selector select[name=heading_font]').change(function () {
			var current = $(this).find('option:selected').val();
			var current_code = $(this).find('option:selected').attr('data-id');
			tp_chameleon_change_heading_font(current, current_code);
		});

		/**
		 * Open/Close box
		 */
		$('#tp_style_selector .close').click(function (e) {
			e.preventDefault();
			tp_chameleon_close();
		});

		$('#tp_style_selector .open').click(function (e) {
			e.preventDefault();
			tp_chameleon_open();
		});

		/**
		 * Primary color
		 */
		<?php if ( tp_chameleon_primary_color() !== false ): ?>
		$('.primary_color a').click(function (event) {
			event.preventDefault();

			var x_new_color = $(this).css('background-color');
			var new_color = $(this).attr('data-color');
			tp_chameleon_change_primary_color(new_color, x_new_color);
		});
		<?php endif; ?>

		/**
		 * Check firt visit
		 */
		if (tp_chameleon_check_first_visit()) {
			setTimeout(tp_chameleon_open, 10000);
		} else {
			$('#tp_style_selector').click(function (event) {
				tp_chameleon_set_first_visit();
			});
		}
	});

</script>