<?php
/**
 * GetTaxonomyByName.
 * php version 5.6
 *
 * @category GetTaxonomyByName
 * @package  SureTriggers
 * @author   BSF <username@example.com>
 * @license  https://www.gnu.org/licenses/gpl-3.0.html GPLv3
 * @link     https://www.brainstormforce.com/
 * @since    1.0.0
 */

namespace SureTriggers\Integrations\Wordpress\Actions;

use SureTriggers\Integrations\AutomateAction;
use SureTriggers\Traits\SingletonLoader;
use WP_User;
use Exception;

/**
 * GetTaxonomyByName
 *
 * @category GetTaxonomyByName
 * @package  SureTriggers
 * @author   BSF <username@example.com>
 * @license  https://www.gnu.org/licenses/gpl-3.0.html GPLv3
 * @link     https://www.brainstormforce.com/
 * @since    1.0.0
 */
class GetTaxonomyByName extends AutomateAction {

	/**
	 * Integration type.
	 *
	 * @var string
	 */
	public $integration = 'WordPress';

	/**
	 * Action name.
	 *
	 * @var string
	 */
	public $action = 'get_taxonomy_by_name';

	use SingletonLoader;

	/**
	 * Register action.
	 *
	 * @param array $actions action data.
	 * @return array
	 */
	public function register( $actions ) {
		$actions[ $this->integration ][ $this->action ] = [
			'label'    => __( 'Get Taxonomy By Name', 'suretriggers' ),
			'action'   => 'get_taxonomy_by_name',
			'function' => [ $this, 'action_listener' ],
		];

		return $actions;
	}

	/**
	 * Action listener.
	 *
	 * @param int   $user_id user_id.
	 * @param int   $automation_id automation_id.
	 * @param array $fields fields.
	 * @param array $selected_options selectedOptions.
	 * @return array|bool
	 * @throws Exception Exception.
	 */
	public function _action_listener( $user_id, $automation_id, $fields, $selected_options ) {
		$taxonomy_name = $selected_options['taxonomy_name'];
		$taxonomy_term = $selected_options['taxonomy_term'];

		$data = get_term_by( 'name', $taxonomy_term, $taxonomy_name );

		if ( ! $data ) {
			throw new Exception( 'No taxonomy is found.' );
		}
		return [
			$data,
		];
	}
}

GetTaxonomyByName::get_instance();
