<?php
/**
 * Common events helper functions
 *
**/

function bearsthemes_addons_event_addres( $venue_id ) {

  if ( ! $venue_id ) {
    return;
  }

  $full_region = tribe_get_full_region( $venue_id );

  ?>
  <span class="tribe-address">

  <?php
  // This location's street address.
  if ( tribe_get_address( $venue_id ) ) : ?>
  <span class="tribe-street-address"><?php echo tribe_get_address( $venue_id ); ?></span>
    <?php if ( ! tribe_is_venue() ) : ?>
      <br>
    <?php endif; ?>
  <?php endif; ?>

  <?php
  // This locations's city.
  if ( tribe_get_city( $venue_id ) ) :
    if ( tribe_get_address( $venue_id ) ) : ?>
      <br>
    <?php endif; ?>
    <span class="tribe-locality"><?php echo tribe_get_city( $venue_id ); ?></span><span class="tribe-delimiter">,</span>
  <?php endif; ?>

  <?php
  // This location's abbreviated region. Full region name in the element title.
  if ( tribe_get_region( $venue_id ) ) : ?>
    <abbr class="tribe-region tribe-events-abbr" title="<?php esc_attr_e( $full_region ); ?>"><?php echo tribe_get_region( $venue_id ); ?></abbr>
  <?php endif; ?>

  <?php
  // This location's postal code.
  if ( tribe_get_zip( $venue_id ) ) : ?>
    <span class="tribe-postal-code"><?php echo tribe_get_zip( $venue_id ); ?></span>
  <?php endif; ?>

  <?php
  // This location's country.
  if ( tribe_get_country( $venue_id ) ) : ?>
    <span class="tribe-country-name"><?php echo tribe_get_country( $venue_id ); ?></span>
  <?php endif; ?>

  </span>
  <?php
}

function bearsthemes_addons_events_list( $atts ) {
  extract( shortcode_atts( array(
		'posts_per_page' => 6,
    'coming_soon' => true,
	), $atts ) );

  $args = [
    'post_type' => 'tribe_events',
    'posts_per_page' => $posts_per_page,
    'orderby' => 'post_date',
    'order' => 'DESC',
  ];

  if( '' !== $coming_soon ) {
    $meta_query[] = array(
      'key' => '_EventStartDate',
      'value' => date('Y-m-d h:i:s'),
      'compare' => '>=',
    );
  }

  $query = new WP_Query( $args );

  ob_start();

  if ( $query->have_posts() ) {
    ?>
    <div class="sc-event-list">
      <?php
        while ( $query->have_posts() ) {
          $query->the_post();
          ?>
          <article id="post-<?php the_ID(); ?>" <?php post_class( 'sc-event' ); ?>>
  					<?php
              echo '<div class="sc-event__date">
                      <span class="date">' . tribe_get_start_date( get_the_ID(), false, 'd' ) . '</span>
                      <span class="month-year">' . tribe_get_start_date( get_the_ID(), false, 'M, Y' ) . '</span>
                    </div>';
            ?>

      			<div class="sc-event__content">
              <div class="sc-event__inner">
        				<?php
                  $organizer_id = get_post_meta( get_the_ID(), '_EventOrganizerID', true);
                  if( $organizer_id ) {
                    echo '<div class="sc-event__organizer">' .
                            bearsthemes_addons_get_icon_svg( 'user', 14 ) .
                            tribe_get_organizer($organizer_id) .
                         '</div>';
                  }

                  the_title( '<h3 class="sc-event__title"><a href="' . get_the_permalink() . '">', '</a></h3>' );

    							$venue_id = get_post_meta( get_the_ID(), '_EventVenueID', true);
    							if( $venue_id ) {
    								echo '<div class="sc-event__location">' . bearsthemes_addons_get_icon_svg( 'map-marker', 14 );
    									bearsthemes_addons_event_addres( $venue_id );
    								echo '</div>';
    							}
                  ?>
                </div>

                <?php echo '<a class="sc-event__read-more" href="' . get_the_permalink() . '">' . esc_html__( 'Read More', 'bearsthemes-addons' ) . '</a>'; ?>

      			</div>
      		</article>
          <?php
        }

      } else {
          // no posts found
      }
    ?>
  </div>
  <?php

  wp_reset_query();
  return ob_get_clean();

}

add_shortcode('bt_events_list', 'bearsthemes_addons_events_list');
