-- Created at 13.10.2021 10:53 using David Grudl MySQL Dump Utility
-- Host: safeplace.ghapo.org
-- MySQL Server: 10.3.31
-- Database: ghappzjw_sg469

SET NAMES utf8;
SET SQL_MODE='NO_AUTO_VALUE_ON_ZERO';
SET FOREIGN_KEY_CHECKS=0;
-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_actionscheduler_actions`;

CREATE TABLE `sgkf_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `sgkf_actionscheduler_actions` (`action_id`, `hook`, `status`, `scheduled_date_gmt`, `scheduled_date_local`, `args`, `schedule`, `group_id`, `attempts`, `last_attempt_gmt`, `last_attempt_local`, `claim_id`, `extended_args`) VALUES
(26,	'action_scheduler/migration_hook',	'complete',	'2021-10-13 09:03:44',	'2021-10-13 09:03:44',	'[]',	'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1634115824;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1634115824;}',	1,	1,	'2021-10-13 09:04:12',	'2021-10-13 09:04:12',	0,	NULL);


-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_actionscheduler_claims`;

CREATE TABLE `sgkf_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_actionscheduler_groups`;

CREATE TABLE `sgkf_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `sgkf_actionscheduler_groups` (`group_id`, `slug`) VALUES
(1,	'action-scheduler-migration');


-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_actionscheduler_logs`;

CREATE TABLE `sgkf_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `sgkf_actionscheduler_logs` (`log_id`, `action_id`, `message`, `log_date_gmt`, `log_date_local`) VALUES
(1,	26,	'action created',	'2021-10-13 09:02:44',	'2021-10-13 09:02:44'),
(2,	26,	'action started via WP Cron',	'2021-10-13 09:04:12',	'2021-10-13 09:04:12'),
(3,	26,	'action complete via WP Cron',	'2021-10-13 09:04:12',	'2021-10-13 09:04:12');


-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_cff_facebook_feed_locator`;

CREATE TABLE `sgkf_cff_facebook_feed_locator` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `feed_id` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_id` bigint(20) unsigned NOT NULL,
  `html_location` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'unknown',
  `shortcode_atts` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `feed_id` (`feed_id`),
  KEY `post_id` (`post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_cff_feed_caches`;

CREATE TABLE `sgkf_cff_feed_caches` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `feed_id` bigint(20) unsigned NOT NULL DEFAULT 1,
  `cache_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cache_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cron_update` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  `last_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `feed_id` (`feed_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_cff_feeds`;

CREATE TABLE `sgkf_cff_feeds` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `feed_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `feed_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `settings` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `author` bigint(20) unsigned NOT NULL DEFAULT 1,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `author` (`author`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_cff_sources`;

CREATE TABLE `sgkf_cff_sources` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `account_type` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `privilege` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `access_token` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `username` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `info` text COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `error` text COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `author` bigint(20) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `account_type` (`account_type`(191)),
  KEY `author` (`author`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_commentmeta`;

CREATE TABLE `sgkf_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_comments`;

CREATE TABLE `sgkf_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `sgkf_comments` (`comment_ID`, `comment_post_ID`, `comment_author`, `comment_author_email`, `comment_author_url`, `comment_author_IP`, `comment_date`, `comment_date_gmt`, `comment_content`, `comment_karma`, `comment_approved`, `comment_agent`, `comment_type`, `comment_parent`, `user_id`) VALUES
(1,	1,	'A WordPress Commenter',	'wapuu@wordpress.example',	'https://wordpress.org/',	'',	'2021-10-13 08:48:53',	'2021-10-13 08:48:53',	'Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.',	0,	'1',	'',	'comment',	0,	0);


-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_ctf_feed_locator`;

CREATE TABLE `sgkf_ctf_feed_locator` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `feed_id` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_id` bigint(20) unsigned NOT NULL,
  `html_location` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'unknown',
  `shortcode_atts` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `feed_id` (`feed_id`),
  KEY `post_id` (`post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_e_submissions`;

CREATE TABLE `sgkf_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `hash_id` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referer_title` varchar(300) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `element_id` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_e_submissions_actions_log`;

CREATE TABLE `sgkf_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_label` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log` text COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_e_submissions_values`;

CREATE TABLE `sgkf_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_give_commentmeta`;

CREATE TABLE `sgkf_give_commentmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `give_comment_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `give_comment_id` (`give_comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_give_comments`;

CREATE TABLE `sgkf_give_comments` (
  `comment_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `comment_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_parent` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_type` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_date` datetime NOT NULL,
  `comment_date_gmt` datetime NOT NULL,
  PRIMARY KEY (`comment_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_give_donationmeta`;

CREATE TABLE `sgkf_give_donationmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `donation_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `donation_id` (`donation_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_give_donormeta`;

CREATE TABLE `sgkf_give_donormeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `donor_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `donor_id` (`donor_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_give_donors`;

CREATE TABLE `sgkf_give_donors` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `email` varchar(255) NOT NULL,
  `name` mediumtext NOT NULL,
  `purchase_value` mediumtext NOT NULL,
  `purchase_count` bigint(20) NOT NULL,
  `payment_ids` longtext NOT NULL,
  `date_created` datetime NOT NULL,
  `token` varchar(255) NOT NULL,
  `verify_key` varchar(255) NOT NULL,
  `verify_throttle` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `user` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_give_formmeta`;

CREATE TABLE `sgkf_give_formmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `form_id` (`form_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_give_log`;

CREATE TABLE `sgkf_give_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_type` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `log_type` (`log_type`),
  KEY `category` (`category`),
  KEY `source` (`source`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_give_migrations`;

CREATE TABLE `sgkf_give_migrations` (
  `id` varchar(180) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `error` text COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `last_run` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `sgkf_give_migrations` (`id`, `status`, `error`, `last_run`) VALUES
('create_migrations_table',	'success',	'',	'2021-10-13 05:01:57'),
('create_revenue_table',	'success',	'',	'2021-10-13 05:01:57'),
('remove_revenue_foreign_keys',	'success',	'',	'2021-10-13 05:01:58'),
('set-form-donation-levels-to-strings',	'success',	'',	'2021-10-13 05:01:58'),
('set_paypal_standard_id_to_paypal_from_paypal_standard',	'success',	'',	'2021-10-13 05:01:58'),
('create_new_log_table',	'success',	'',	'2021-10-13 05:01:58'),
('delete_old_log_tables',	'success',	'',	'2021-10-13 05:01:58'),
('remove-paypal-ipn-verification-setting',	'success',	'',	'2021-10-13 05:01:58'),
('migrate_completed_migrations',	'success',	'',	'2021-10-13 05:01:58');


-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_give_revenue`;

CREATE TABLE `sgkf_give_revenue` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `donation_id` bigint(20) unsigned NOT NULL,
  `form_id` bigint(20) unsigned NOT NULL,
  `amount` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_give_sequential_ordering`;

CREATE TABLE `sgkf_give_sequential_ordering` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `payment_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_give_sessions`;

CREATE TABLE `sgkf_give_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_key`),
  UNIQUE KEY `session_id` (`session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_links`;

CREATE TABLE `sgkf_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_newsletter`;

CREATE TABLE `sgkf_newsletter` (
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `token` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `language` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` varchar(1) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'S',
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `profile` mediumtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated` int(11) NOT NULL DEFAULT 0,
  `last_activity` int(11) NOT NULL DEFAULT 0,
  `followup_step` tinyint(4) NOT NULL DEFAULT 0,
  `followup_time` bigint(20) NOT NULL DEFAULT 0,
  `followup` tinyint(4) NOT NULL DEFAULT 0,
  `surname` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `sex` char(1) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'n',
  `feed_time` bigint(20) NOT NULL DEFAULT 0,
  `feed` tinyint(4) NOT NULL DEFAULT 0,
  `referrer` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `ip` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `wp_user_id` int(11) NOT NULL DEFAULT 0,
  `http_referer` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `geo` tinyint(4) NOT NULL DEFAULT 0,
  `country` varchar(4) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `region` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `bounce_type` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `bounce_time` int(11) NOT NULL DEFAULT 0,
  `unsub_email_id` int(11) NOT NULL DEFAULT 0,
  `unsub_time` int(11) NOT NULL DEFAULT 0,
  `list_1` tinyint(4) NOT NULL DEFAULT 0,
  `list_2` tinyint(4) NOT NULL DEFAULT 0,
  `list_3` tinyint(4) NOT NULL DEFAULT 0,
  `list_4` tinyint(4) NOT NULL DEFAULT 0,
  `list_5` tinyint(4) NOT NULL DEFAULT 0,
  `list_6` tinyint(4) NOT NULL DEFAULT 0,
  `list_7` tinyint(4) NOT NULL DEFAULT 0,
  `list_8` tinyint(4) NOT NULL DEFAULT 0,
  `list_9` tinyint(4) NOT NULL DEFAULT 0,
  `list_10` tinyint(4) NOT NULL DEFAULT 0,
  `list_11` tinyint(4) NOT NULL DEFAULT 0,
  `list_12` tinyint(4) NOT NULL DEFAULT 0,
  `list_13` tinyint(4) NOT NULL DEFAULT 0,
  `list_14` tinyint(4) NOT NULL DEFAULT 0,
  `list_15` tinyint(4) NOT NULL DEFAULT 0,
  `list_16` tinyint(4) NOT NULL DEFAULT 0,
  `list_17` tinyint(4) NOT NULL DEFAULT 0,
  `list_18` tinyint(4) NOT NULL DEFAULT 0,
  `list_19` tinyint(4) NOT NULL DEFAULT 0,
  `list_20` tinyint(4) NOT NULL DEFAULT 0,
  `list_21` tinyint(4) NOT NULL DEFAULT 0,
  `list_22` tinyint(4) NOT NULL DEFAULT 0,
  `list_23` tinyint(4) NOT NULL DEFAULT 0,
  `list_24` tinyint(4) NOT NULL DEFAULT 0,
  `list_25` tinyint(4) NOT NULL DEFAULT 0,
  `list_26` tinyint(4) NOT NULL DEFAULT 0,
  `list_27` tinyint(4) NOT NULL DEFAULT 0,
  `list_28` tinyint(4) NOT NULL DEFAULT 0,
  `list_29` tinyint(4) NOT NULL DEFAULT 0,
  `list_30` tinyint(4) NOT NULL DEFAULT 0,
  `list_31` tinyint(4) NOT NULL DEFAULT 0,
  `list_32` tinyint(4) NOT NULL DEFAULT 0,
  `list_33` tinyint(4) NOT NULL DEFAULT 0,
  `list_34` tinyint(4) NOT NULL DEFAULT 0,
  `list_35` tinyint(4) NOT NULL DEFAULT 0,
  `list_36` tinyint(4) NOT NULL DEFAULT 0,
  `list_37` tinyint(4) NOT NULL DEFAULT 0,
  `list_38` tinyint(4) NOT NULL DEFAULT 0,
  `list_39` tinyint(4) NOT NULL DEFAULT 0,
  `list_40` tinyint(4) NOT NULL DEFAULT 0,
  `profile_1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_3` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_4` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_5` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_6` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_7` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_8` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_9` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_10` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_11` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_12` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_13` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_14` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_15` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_16` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_17` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_18` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_19` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_20` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `test` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `wp_user_id` (`wp_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_newsletter_emails`;

CREATE TABLE `sgkf_newsletter_emails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subject` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `message` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp(),
  `status` enum('new','sending','sent','paused','error') COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'new',
  `total` int(11) NOT NULL DEFAULT 0,
  `last_id` int(11) NOT NULL DEFAULT 0,
  `sent` int(11) NOT NULL DEFAULT 0,
  `track` int(11) NOT NULL DEFAULT 1,
  `list` int(11) NOT NULL DEFAULT 0,
  `type` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `query` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `editor` tinyint(4) NOT NULL DEFAULT 0,
  `sex` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `theme` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `message_text` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `preferences` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `send_on` int(11) NOT NULL DEFAULT 0,
  `token` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `options` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `private` tinyint(1) NOT NULL DEFAULT 0,
  `click_count` int(10) unsigned NOT NULL DEFAULT 0,
  `version` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `open_count` int(10) unsigned NOT NULL DEFAULT 0,
  `unsub_count` int(10) unsigned NOT NULL DEFAULT 0,
  `error_count` int(10) unsigned NOT NULL DEFAULT 0,
  `stats_time` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_newsletter_sent`;

CREATE TABLE `sgkf_newsletter_sent` (
  `email_id` int(10) unsigned NOT NULL DEFAULT 0,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `status` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `open` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `time` int(10) unsigned NOT NULL DEFAULT 0,
  `error` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`email_id`,`user_id`),
  KEY `user_id` (`user_id`),
  KEY `email_id` (`email_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_newsletter_stats`;

CREATE TABLE `sgkf_newsletter_stats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL DEFAULT current_timestamp(),
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT 0,
  `email_id` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '0',
  `ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `email_id` (`email_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_newsletter_user_logs`;

CREATE TABLE `sgkf_newsletter_user_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT 0,
  `ip` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `source` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `data` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



-- --------------------------------------------------------

DROP TABLE IF EXISTS `sgkf_options`;

CREATE TABLE `sgkf_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=647 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `sgkf_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(1,	'siteurl',	'https://safeplace.ghapo.org',	'yes'),
(2,	'home',	'https://safeplace.ghapo.org',	'yes'),
(3,	'blogname',	'Safeplace @GHAPO',	'yes'),
(4,	'blogdescription',	'Grassroot Health Aid Promotion Organization',	'yes'),
(5,	'users_can_register',	'0',	'yes'),
(6,	'admin_email',	'bimbome.ojo@gmail.com',	'yes'),
(7,	'start_of_week',	'1',	'yes'),
(8,	'use_balanceTags',	'0',	'yes'),
(9,	'use_smilies',	'1',	'yes'),
(10,	'require_name_email',	'1',	'yes'),
(11,	'comments_notify',	'1',	'yes'),
(12,	'posts_per_rss',	'10',	'yes'),
(13,	'rss_use_excerpt',	'0',	'yes'),
(14,	'mailserver_url',	'mail.example.com',	'yes'),
(15,	'mailserver_login',	'login@example.com',	'yes'),
(16,	'mailserver_pass',	'password',	'yes'),
(17,	'mailserver_port',	'110',	'yes'),
(18,	'default_category',	'1',	'yes'),
(19,	'default_comment_status',	'open',	'yes'),
(20,	'default_ping_status',	'open',	'yes'),
(21,	'default_pingback_flag',	'1',	'yes'),
(22,	'posts_per_page',	'10',	'yes'),
(23,	'date_format',	'F j, Y',	'yes'),
(24,	'time_format',	'g:i a',	'yes'),
(25,	'links_updated_date_format',	'F j, Y g:i a',	'yes'),
(26,	'comment_moderation',	'0',	'yes'),
(27,	'moderation_notify',	'1',	'yes'),
(28,	'permalink_structure',	'',	'yes'),
(30,	'hack_file',	'0',	'yes'),
(31,	'blog_charset',	'UTF-8',	'yes'),
(32,	'moderation_keys',	'',	'no'),
(33,	'active_plugins',	'a:21:{i:0;s:56:\"advanced-custom-fields-font-awesome/acf-font-awesome.php\";i:1;s:34:\"advanced-custom-fields-pro/acf.php\";i:2;s:30:\"advanced-custom-fields/acf.php\";i:3;s:29:\"bears-backup/bears-backup.php\";i:4;s:41:\"bearsthemes-addons/bearsthemes-addons.php\";i:5;s:45:\"custom-facebook-feed/custom-facebook-feed.php\";i:6;s:44:\"custom-twitter-feeds/custom-twitter-feed.php\";i:7;s:31:\"elementor-pro/elementor-pro.php\";i:8;s:23:\"elementor/elementor.php\";i:9;s:13:\"give/give.php\";i:10;s:33:\"instagram-feed/instagram-feed.php\";i:11;s:15:\"kirki/kirki.php\";i:12;s:21:\"newsletter/plugin.php\";i:13;s:23:\"revslider/revslider.php\";i:14;s:19:\"sermone/sermone.php\";i:15;s:43:\"the-events-calendar/the-events-calendar.php\";i:16;s:21:\"ubermenu/ubermenu.php\";i:17;s:46:\"under-construction-page/under-construction.php\";i:18;s:27:\"woocommerce/woocommerce.php\";i:19;s:24:\"wordpress-seo/wp-seo.php\";i:20;s:21:\"wp-reset/wp-reset.php\";}',	'yes'),
(34,	'category_base',	'',	'yes'),
(35,	'ping_sites',	'http://rpc.pingomatic.com/',	'yes'),
(36,	'comment_max_links',	'2',	'yes'),
(37,	'gmt_offset',	'0',	'yes'),
(38,	'default_email_category',	'1',	'yes'),
(39,	'recently_edited',	'a:3:{i:0;s:72:\"/home/ghappzjw/safeplace.ghapo.org/wp-content/themes/alone/functions.php\";i:2;s:68:\"/home/ghappzjw/safeplace.ghapo.org/wp-content/themes/alone/style.css\";i:3;s:0:\"\";}',	'no'),
(40,	'template',	'alone',	'yes'),
(41,	'stylesheet',	'alone',	'yes'),
(42,	'comment_registration',	'0',	'yes'),
(43,	'html_type',	'text/html',	'yes'),
(44,	'use_trackback',	'0',	'yes'),
(45,	'default_role',	'subscriber',	'yes'),
(46,	'db_version',	'49752',	'yes'),
(47,	'uploads_use_yearmonth_folders',	'1',	'yes'),
(48,	'upload_path',	'',	'yes'),
(49,	'blog_public',	'1',	'yes'),
(50,	'default_link_category',	'2',	'yes'),
(51,	'show_on_front',	'page',	'yes'),
(52,	'tag_base',	'',	'yes'),
(53,	'show_avatars',	'1',	'yes'),
(54,	'avatar_rating',	'G',	'yes'),
(55,	'upload_url_path',	'',	'yes'),
(56,	'thumbnail_size_w',	'150',	'yes'),
(57,	'thumbnail_size_h',	'150',	'yes'),
(58,	'thumbnail_crop',	'1',	'yes'),
(59,	'medium_size_w',	'300',	'yes'),
(60,	'medium_size_h',	'300',	'yes'),
(61,	'avatar_default',	'mystery',	'yes'),
(62,	'large_size_w',	'1024',	'yes'),
(63,	'large_size_h',	'1024',	'yes'),
(64,	'image_default_link_type',	'none',	'yes'),
(65,	'image_default_size',	'',	'yes'),
(66,	'image_default_align',	'',	'yes'),
(67,	'close_comments_for_old_posts',	'0',	'yes'),
(68,	'close_comments_days_old',	'14',	'yes'),
(69,	'thread_comments',	'1',	'yes'),
(70,	'thread_comments_depth',	'5',	'yes'),
(71,	'page_comments',	'0',	'yes'),
(72,	'comments_per_page',	'50',	'yes'),
(73,	'default_comments_page',	'newest',	'yes'),
(74,	'comment_order',	'asc',	'yes'),
(75,	'sticky_posts',	'a:0:{}',	'yes'),
(76,	'widget_categories',	'a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}',	'yes'),
(77,	'widget_text',	'a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}',	'yes'),
(78,	'widget_rss',	'a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}',	'yes'),
(79,	'uninstall_plugins',	'a:5:{s:21:\"wp-reset/wp-reset.php\";a:2:{i:0;s:8:\"WP_Reset\";i:1;s:9:\"uninstall\";}s:46:\"under-construction-page/under-construction.php\";a:2:{i:0;s:3:\"UCP\";i:1;s:9:\"uninstall\";}s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:45:\"custom-facebook-feed/custom-facebook-feed.php\";a:2:{i:0;s:39:\"CustomFacebookFeed\\Custom_Facebook_Feed\";i:1;s:13:\"cff_uninstall\";}s:33:\"instagram-feed/instagram-feed.php\";s:22:\"sb_instagram_uninstall\";}',	'no'),
(80,	'timezone_string',	'',	'yes'),
(81,	'page_for_posts',	'8',	'yes'),
(82,	'page_on_front',	'5',	'yes'),
(83,	'default_post_format',	'0',	'yes'),
(84,	'link_manager_enabled',	'0',	'yes'),
(85,	'finished_splitting_shared_terms',	'1',	'yes'),
(86,	'site_icon',	'0',	'yes'),
(87,	'medium_large_size_w',	'768',	'yes'),
(88,	'medium_large_size_h',	'0',	'yes'),
(89,	'wp_page_for_privacy_policy',	'3',	'yes'),
(90,	'show_comments_cookies_opt_in',	'1',	'yes'),
(91,	'admin_email_lifespan',	'1649666933',	'yes'),
(92,	'disallowed_keys',	'',	'no'),
(93,	'comment_previously_approved',	'1',	'yes'),
(94,	'auto_plugin_theme_update_emails',	'a:0:{}',	'no'),
(95,	'auto_update_core_dev',	'enabled',	'yes'),
(96,	'auto_update_core_minor',	'enabled',	'yes'),
(97,	'auto_update_core_major',	'enabled',	'yes'),
(98,	'wp_force_deactivated_plugins',	'a:0:{}',	'yes'),
(99,	'initial_db_version',	'49752',	'yes'),
(100,	'sgkf_user_roles',	'a:13:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:196:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"bcn_manage_options\";b:1;s:17:\"view_give_reports\";b:1;s:24:\"view_give_sensitive_data\";b:1;s:19:\"export_give_reports\";b:1;s:20:\"manage_give_settings\";b:1;s:18:\"view_give_payments\";b:1;s:15:\"edit_give_forms\";b:1;s:22:\"edit_others_give_forms\";b:1;s:18:\"publish_give_forms\";b:1;s:23:\"read_private_give_forms\";b:1;s:17:\"delete_give_forms\";b:1;s:25:\"delete_private_give_forms\";b:1;s:27:\"delete_published_give_forms\";b:1;s:24:\"delete_others_give_forms\";b:1;s:23:\"edit_private_give_forms\";b:1;s:25:\"edit_published_give_forms\";b:1;s:22:\"manage_give_form_terms\";b:1;s:20:\"edit_give_form_terms\";b:1;s:22:\"delete_give_form_terms\";b:1;s:22:\"assign_give_form_terms\";b:1;s:20:\"view_give_form_stats\";b:1;s:17:\"import_give_forms\";b:1;s:18:\"edit_give_payments\";b:1;s:25:\"edit_others_give_payments\";b:1;s:21:\"publish_give_payments\";b:1;s:26:\"read_private_give_payments\";b:1;s:20:\"delete_give_payments\";b:1;s:28:\"delete_private_give_payments\";b:1;s:30:\"delete_published_give_payments\";b:1;s:27:\"delete_others_give_payments\";b:1;s:26:\"edit_private_give_payments\";b:1;s:28:\"edit_published_give_payments\";b:1;s:25:\"manage_give_payment_terms\";b:1;s:23:\"edit_give_payment_terms\";b:1;s:25:\"delete_give_payment_terms\";b:1;s:25:\"assign_give_payment_terms\";b:1;s:23:\"view_give_payment_stats\";b:1;s:20:\"import_give_payments\";b:1;s:20:\"wpseo_manage_options\";b:1;s:35:\"manage_custom_twitter_feeds_options\";b:1;s:29:\"manage_instagram_feed_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:35:\"manage_custom_facebook_feed_options\";b:1;s:25:\"read_private_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:23:\"edit_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:76:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:25:\"read_private_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:23:\"edit_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:30:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:17:\"edit_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:13:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:17:\"edit_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:17:\"edit_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:23:\"edit_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:12:\"give_manager\";a:2:{s:4:\"name\";s:14:\"GiveWP Manager\";s:12:\"capabilities\";a:65:{s:4:\"read\";b:1;s:10:\"edit_posts\";b:1;s:12:\"delete_posts\";b:1;s:15:\"unfiltered_html\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:0;s:6:\"import\";b:0;s:19:\"delete_others_pages\";b:0;s:19:\"delete_others_posts\";b:0;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:17:\"edit_others_pages\";b:0;s:17:\"edit_others_posts\";b:0;s:10:\"edit_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:17:\"manage_categories\";b:0;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:13:\"publish_pages\";b:1;s:13:\"publish_posts\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:17:\"view_give_reports\";b:1;s:24:\"view_give_sensitive_data\";b:1;s:19:\"export_give_reports\";b:1;s:20:\"manage_give_settings\";b:1;s:18:\"view_give_payments\";b:1;s:15:\"edit_give_forms\";b:1;s:22:\"edit_others_give_forms\";b:1;s:18:\"publish_give_forms\";b:1;s:23:\"read_private_give_forms\";b:1;s:17:\"delete_give_forms\";b:1;s:25:\"delete_private_give_forms\";b:1;s:27:\"delete_published_give_forms\";b:1;s:24:\"delete_others_give_forms\";b:1;s:23:\"edit_private_give_forms\";b:1;s:25:\"edit_published_give_forms\";b:1;s:22:\"manage_give_form_terms\";b:1;s:20:\"edit_give_form_terms\";b:1;s:22:\"delete_give_form_terms\";b:1;s:22:\"assign_give_form_terms\";b:1;s:20:\"view_give_form_stats\";b:1;s:17:\"import_give_forms\";b:1;s:18:\"edit_give_payments\";b:1;s:25:\"edit_others_give_payments\";b:1;s:21:\"publish_give_payments\";b:1;s:26:\"read_private_give_payments\";b:1;s:20:\"delete_give_payments\";b:1;s:28:\"delete_private_give_payments\";b:1;s:30:\"delete_published_give_payments\";b:1;s:27:\"delete_others_give_payments\";b:1;s:26:\"edit_private_give_payments\";b:1;s:28:\"edit_published_give_payments\";b:1;s:25:\"manage_give_payment_terms\";b:1;s:23:\"edit_give_payment_terms\";b:1;s:25:\"delete_give_payment_terms\";b:1;s:25:\"assign_give_payment_terms\";b:1;s:23:\"view_give_payment_stats\";b:1;s:20:\"import_give_payments\";b:1;}}s:15:\"give_accountant\";a:2:{s:4:\"name\";s:17:\"GiveWP Accountant\";s:12:\"capabilities\";a:9:{s:4:\"read\";b:1;s:10:\"edit_posts\";b:0;s:12:\"delete_posts\";b:0;s:15:\"edit_give_forms\";b:1;s:23:\"read_private_give_forms\";b:1;s:17:\"view_give_reports\";b:1;s:19:\"export_give_reports\";b:1;s:18:\"edit_give_payments\";b:1;s:18:\"view_give_payments\";b:1;}}s:11:\"give_worker\";a:2:{s:4:\"name\";s:13:\"GiveWP Worker\";s:12:\"capabilities\";a:16:{s:4:\"read\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:12:\"upload_files\";b:1;s:12:\"delete_posts\";b:0;s:18:\"edit_give_payments\";b:1;s:17:\"delete_give_forms\";b:1;s:24:\"delete_others_give_forms\";b:1;s:25:\"delete_private_give_forms\";b:1;s:27:\"delete_published_give_forms\";b:1;s:15:\"edit_give_forms\";b:1;s:22:\"edit_others_give_forms\";b:1;s:23:\"edit_private_give_forms\";b:1;s:25:\"edit_published_give_forms\";b:1;s:18:\"publish_give_forms\";b:1;s:23:\"read_private_give_forms\";b:1;}}s:10:\"give_donor\";a:2:{s:4:\"name\";s:12:\"GiveWP Donor\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}',	'yes'),
(101,	'fresh_site',	'0',	'yes'),
(102,	'widget_block',	'a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}',	'yes'),
(103,	'sidebars_widgets',	'a:8:{s:19:\"wp_inactive_widgets\";a:0:{}s:12:\"blog-sidebar\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:14:\"topbar-sidebar\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:14:\"footer-sidebar\";a:0:{}s:12:\"shop-sidebar\";a:0:{}s:12:\"give-sidebar\";a:0:{}s:18:\"give-forms-sidebar\";a:0:{}s:13:\"array_version\";i:3;}',	'yes'),
(157,	'ucp_notices',	'a:1:{s:19:\"dismiss_whitelisted\";b:1;}',	'yes'),
(184,	'newsletter_logger_secret',	'd72fb97a',	'yes'),
(464,	'ubermenu_main',	'',	'yes'),
(186,	'newsletter_main_first_install_time',	'1634115720',	'no'),
(187,	'newsletter_main',	'a:32:{s:11:\"return_path\";s:0:\"\";s:8:\"reply_to\";s:0:\"\";s:12:\"sender_email\";s:30:\"newsletter@safeplace.ghapo.org\";s:11:\"sender_name\";s:16:\"Safeplace @GHAPO\";s:6:\"editor\";i:0;s:13:\"scheduler_max\";i:100;s:9:\"phpmailer\";i:0;s:5:\"debug\";i:0;s:5:\"track\";i:1;s:3:\"css\";s:0:\"\";s:12:\"css_disabled\";i:0;s:2:\"ip\";s:0:\"\";s:4:\"page\";i:0;s:19:\"disable_cron_notice\";i:0;s:13:\"do_shortcodes\";i:0;s:11:\"header_logo\";s:0:\"\";s:12:\"header_title\";s:16:\"Safeplace @GHAPO\";s:10:\"header_sub\";s:43:\"Grassroot Health Aid Promotion Organization\";s:12:\"footer_title\";s:0:\"\";s:14:\"footer_contact\";s:0:\"\";s:12:\"footer_legal\";s:0:\"\";s:12:\"facebook_url\";s:0:\"\";s:11:\"twitter_url\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:13:\"pinterest_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:10:\"tumblr_url\";s:0:\"\";s:11:\"youtube_url\";s:0:\"\";s:9:\"vimeo_url\";s:0:\"\";s:14:\"soundcloud_url\";s:0:\"\";s:12:\"telegram_url\";s:0:\"\";s:6:\"vk_url\";s:0:\"\";}',	'yes'),
(188,	'newsletter_main_info',	'a:17:{s:11:\"header_logo\";a:1:{s:2:\"id\";i:0;}s:12:\"header_title\";s:16:\"Safeplace @GHAPO\";s:10:\"header_sub\";s:43:\"Grassroot Health Aid Promotion Organization\";s:12:\"footer_title\";s:0:\"\";s:14:\"footer_contact\";s:0:\"\";s:12:\"footer_legal\";s:0:\"\";s:12:\"facebook_url\";s:0:\"\";s:11:\"twitter_url\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:13:\"pinterest_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:10:\"tumblr_url\";s:0:\"\";s:11:\"youtube_url\";s:0:\"\";s:9:\"vimeo_url\";s:0:\"\";s:14:\"soundcloud_url\";s:0:\"\";s:12:\"telegram_url\";s:0:\"\";s:6:\"vk_url\";s:0:\"\";}',	'yes'),
(189,	'newsletter_main_smtp',	'a:7:{s:7:\"enabled\";i:0;s:4:\"host\";s:0:\"\";s:4:\"user\";s:0:\"\";s:4:\"pass\";s:0:\"\";s:4:\"port\";i:25;s:6:\"secure\";s:0:\"\";s:12:\"ssl_insecure\";i:0;}',	'yes'),
(190,	'newsletter_main_version',	'1.6.6',	'yes'),
(191,	'newsletter_subscription_first_install_time',	'1634115720',	'no'),
(192,	'newsletter',	'a:14:{s:14:\"noconfirmation\";i:1;s:12:\"notify_email\";s:21:\"bimbome.ojo@gmail.com\";s:8:\"multiple\";i:1;s:6:\"notify\";i:0;s:10:\"error_text\";s:87:\"<p>This email address is already subscribed, please contact the site administrator.</p>\";s:17:\"subscription_text\";s:19:\"{subscription_form}\";s:17:\"confirmation_text\";s:104:\"<p>A confirmation email is on the way. Follow the instructions and check the spam folder. Thank you.</p>\";s:20:\"confirmation_subject\";s:32:\"Please confirm your subscription\";s:21:\"confirmation_tracking\";s:0:\"\";s:20:\"confirmation_message\";s:94:\"<p>Please confirm your subscription <a href=\"{subscription_confirm_url}\">clicking here</a></p>\";s:14:\"confirmed_text\";s:43:\"<p>Your subscription has been confirmed</p>\";s:17:\"confirmed_subject\";s:7:\"Welcome\";s:17:\"confirmed_message\";s:130:\"<p>This message confirms your subscription to our newsletter. Thank you!</p><hr><p><a href=\"{profile_url}\">Change your profile</p>\";s:18:\"confirmed_tracking\";s:0:\"\";}',	'yes'),
(181,	'give_completed_upgrades',	'a:41:{i:0;b:0;i:1;s:25:\"v18_upgrades_core_setting\";i:2;s:30:\"v220_rename_donation_meta_type\";i:3;s:38:\"v270_store_stripe_account_for_donation\";i:4;s:30:\"upgrade_give_user_caps_cleanup\";i:5;s:32:\"upgrade_give_payment_customer_id\";i:6;s:27:\"upgrade_give_offline_status\";i:7;s:26:\"v18_upgrades_form_metadata\";i:8;s:30:\"v189_upgrades_levels_post_meta\";i:9;s:26:\"v1812_update_amount_values\";i:10;s:34:\"v1812_update_donor_purchase_values\";i:11;s:23:\"v1813_update_user_roles\";i:12;s:29:\"v1813_update_donor_user_roles\";i:13;s:43:\"v1817_update_donation_iranian_currency_code\";i:14;s:24:\"v1817_cleanup_user_roles\";i:15;s:39:\"v1818_assign_custom_amount_set_donation\";i:16;s:30:\"v1818_give_worker_role_cleanup\";i:17;s:26:\"v20_upgrades_form_metadata\";i:18;s:17:\"v20_logs_upgrades\";i:19;s:32:\"v20_move_metadata_into_new_table\";i:20;s:23:\"v20_rename_donor_tables\";i:21;s:23:\"v20_upgrades_donor_name\";i:22;s:25:\"v20_upgrades_user_address\";i:23;s:29:\"v20_upgrades_payment_metadata\";i:24;s:30:\"v201_upgrades_payment_metadata\";i:25;s:23:\"v201_add_missing_donors\";i:26;s:33:\"v201_move_metadata_into_new_table\";i:27;s:18:\"v201_logs_upgrades\";i:28;s:32:\"v210_verify_form_status_upgrades\";i:29;s:25:\"v213_delete_donation_meta\";i:30;s:28:\"v215_update_donor_user_roles\";i:31;s:22:\"v224_update_donor_meta\";i:32;s:31:\"v224_update_donor_meta_forms_id\";i:33;s:20:\"v230_move_donor_note\";i:34;s:23:\"v230_move_donation_note\";i:35;s:41:\"v230_delete_donor_wall_related_donor_data\";i:36;s:43:\"v230_delete_donor_wall_related_comment_data\";i:37;s:30:\"v240_update_form_goal_progress\";i:38;s:21:\"v241_remove_sale_logs\";i:39;s:39:\"add-past-donation-data-to-revenue-table\";i:40;s:21:\"migrate_existing_logs\";}',	'no'),
(182,	'give_version',	'2.15.0',	'no'),
(197,	'newsletter_subscription_version',	'2.2.7',	'yes'),
(198,	'newsletter_unsubscription_first_install_time',	'1634115720',	'no'),
(199,	'newsletter_unsubscription',	'a:6:{s:16:\"unsubscribe_text\";s:103:\"<p>Please confirm you want to unsubscribe <a href=\"{unsubscription_confirm_url}\">clicking here</a>.</p>\";s:10:\"error_text\";s:99:\"<p>Subscriber not found, it probably has already been removed. No further actions are required.</p>\";s:17:\"unsubscribed_text\";s:124:\"<p>Your subscription has been deleted. If that was an error you can <a href=\"{reactivate_url}\">subscribe again here</a>.</p>\";s:20:\"unsubscribed_subject\";s:7:\"Goodbye\";s:20:\"unsubscribed_message\";s:87:\"<p>This message confirms that you have unsubscribed from our newsletter. Thank you.</p>\";s:16:\"reactivated_text\";s:46:\"<p>Your subscription has been reactivated.</p>\";}',	'yes'),
(193,	'newsletter_subscription_lists',	'a:240:{s:6:\"list_1\";s:0:\"\";s:13:\"list_1_status\";i:0;s:14:\"list_1_checked\";i:0;s:13:\"list_1_forced\";i:0;s:19:\"list_1_subscription\";i:0;s:14:\"list_1_profile\";i:0;s:6:\"list_2\";s:0:\"\";s:13:\"list_2_status\";i:0;s:14:\"list_2_checked\";i:0;s:13:\"list_2_forced\";i:0;s:19:\"list_2_subscription\";i:0;s:14:\"list_2_profile\";i:0;s:6:\"list_3\";s:0:\"\";s:13:\"list_3_status\";i:0;s:14:\"list_3_checked\";i:0;s:13:\"list_3_forced\";i:0;s:19:\"list_3_subscription\";i:0;s:14:\"list_3_profile\";i:0;s:6:\"list_4\";s:0:\"\";s:13:\"list_4_status\";i:0;s:14:\"list_4_checked\";i:0;s:13:\"list_4_forced\";i:0;s:19:\"list_4_subscription\";i:0;s:14:\"list_4_profile\";i:0;s:6:\"list_5\";s:0:\"\";s:13:\"list_5_status\";i:0;s:14:\"list_5_checked\";i:0;s:13:\"list_5_forced\";i:0;s:19:\"list_5_subscription\";i:0;s:14:\"list_5_profile\";i:0;s:6:\"list_6\";s:0:\"\";s:13:\"list_6_status\";i:0;s:14:\"list_6_checked\";i:0;s:13:\"list_6_forced\";i:0;s:19:\"list_6_subscription\";i:0;s:14:\"list_6_profile\";i:0;s:6:\"list_7\";s:0:\"\";s:13:\"list_7_status\";i:0;s:14:\"list_7_checked\";i:0;s:13:\"list_7_forced\";i:0;s:19:\"list_7_subscription\";i:0;s:14:\"list_7_profile\";i:0;s:6:\"list_8\";s:0:\"\";s:13:\"list_8_status\";i:0;s:14:\"list_8_checked\";i:0;s:13:\"list_8_forced\";i:0;s:19:\"list_8_subscription\";i:0;s:14:\"list_8_profile\";i:0;s:6:\"list_9\";s:0:\"\";s:13:\"list_9_status\";i:0;s:14:\"list_9_checked\";i:0;s:13:\"list_9_forced\";i:0;s:19:\"list_9_subscription\";i:0;s:14:\"list_9_profile\";i:0;s:7:\"list_10\";s:0:\"\";s:14:\"list_10_status\";i:0;s:15:\"list_10_checked\";i:0;s:14:\"list_10_forced\";i:0;s:20:\"list_10_subscription\";i:0;s:15:\"list_10_profile\";i:0;s:7:\"list_11\";s:0:\"\";s:14:\"list_11_status\";i:0;s:15:\"list_11_checked\";i:0;s:14:\"list_11_forced\";i:0;s:20:\"list_11_subscription\";i:0;s:15:\"list_11_profile\";i:0;s:7:\"list_12\";s:0:\"\";s:14:\"list_12_status\";i:0;s:15:\"list_12_checked\";i:0;s:14:\"list_12_forced\";i:0;s:20:\"list_12_subscription\";i:0;s:15:\"list_12_profile\";i:0;s:7:\"list_13\";s:0:\"\";s:14:\"list_13_status\";i:0;s:15:\"list_13_checked\";i:0;s:14:\"list_13_forced\";i:0;s:20:\"list_13_subscription\";i:0;s:15:\"list_13_profile\";i:0;s:7:\"list_14\";s:0:\"\";s:14:\"list_14_status\";i:0;s:15:\"list_14_checked\";i:0;s:14:\"list_14_forced\";i:0;s:20:\"list_14_subscription\";i:0;s:15:\"list_14_profile\";i:0;s:7:\"list_15\";s:0:\"\";s:14:\"list_15_status\";i:0;s:15:\"list_15_checked\";i:0;s:14:\"list_15_forced\";i:0;s:20:\"list_15_subscription\";i:0;s:15:\"list_15_profile\";i:0;s:7:\"list_16\";s:0:\"\";s:14:\"list_16_status\";i:0;s:15:\"list_16_checked\";i:0;s:14:\"list_16_forced\";i:0;s:20:\"list_16_subscription\";i:0;s:15:\"list_16_profile\";i:0;s:7:\"list_17\";s:0:\"\";s:14:\"list_17_status\";i:0;s:15:\"list_17_checked\";i:0;s:14:\"list_17_forced\";i:0;s:20:\"list_17_subscription\";i:0;s:15:\"list_17_profile\";i:0;s:7:\"list_18\";s:0:\"\";s:14:\"list_18_status\";i:0;s:15:\"list_18_checked\";i:0;s:14:\"list_18_forced\";i:0;s:20:\"list_18_subscription\";i:0;s:15:\"list_18_profile\";i:0;s:7:\"list_19\";s:0:\"\";s:14:\"list_19_status\";i:0;s:15:\"list_19_checked\";i:0;s:14:\"list_19_forced\";i:0;s:20:\"list_19_subscription\";i:0;s:15:\"list_19_profile\";i:0;s:7:\"list_20\";s:0:\"\";s:14:\"list_20_status\";i:0;s:15:\"list_20_checked\";i:0;s:14:\"list_20_forced\";i:0;s:20:\"list_20_subscription\";i:0;s:15:\"list_20_profile\";i:0;s:7:\"list_21\";s:0:\"\";s:14:\"list_21_status\";i:0;s:15:\"list_21_checked\";i:0;s:14:\"list_21_forced\";i:0;s:20:\"list_21_subscription\";i:0;s:15:\"list_21_profile\";i:0;s:7:\"list_22\";s:0:\"\";s:14:\"list_22_status\";i:0;s:15:\"list_22_checked\";i:0;s:14:\"list_22_forced\";i:0;s:20:\"list_22_subscription\";i:0;s:15:\"list_22_profile\";i:0;s:7:\"list_23\";s:0:\"\";s:14:\"list_23_status\";i:0;s:15:\"list_23_checked\";i:0;s:14:\"list_23_forced\";i:0;s:20:\"list_23_subscription\";i:0;s:15:\"list_23_profile\";i:0;s:7:\"list_24\";s:0:\"\";s:14:\"list_24_status\";i:0;s:15:\"list_24_checked\";i:0;s:14:\"list_24_forced\";i:0;s:20:\"list_24_subscription\";i:0;s:15:\"list_24_profile\";i:0;s:7:\"list_25\";s:0:\"\";s:14:\"list_25_status\";i:0;s:15:\"list_25_checked\";i:0;s:14:\"list_25_forced\";i:0;s:20:\"list_25_subscription\";i:0;s:15:\"list_25_profile\";i:0;s:7:\"list_26\";s:0:\"\";s:14:\"list_26_status\";i:0;s:15:\"list_26_checked\";i:0;s:14:\"list_26_forced\";i:0;s:20:\"list_26_subscription\";i:0;s:15:\"list_26_profile\";i:0;s:7:\"list_27\";s:0:\"\";s:14:\"list_27_status\";i:0;s:15:\"list_27_checked\";i:0;s:14:\"list_27_forced\";i:0;s:20:\"list_27_subscription\";i:0;s:15:\"list_27_profile\";i:0;s:7:\"list_28\";s:0:\"\";s:14:\"list_28_status\";i:0;s:15:\"list_28_checked\";i:0;s:14:\"list_28_forced\";i:0;s:20:\"list_28_subscription\";i:0;s:15:\"list_28_profile\";i:0;s:7:\"list_29\";s:0:\"\";s:14:\"list_29_status\";i:0;s:15:\"list_29_checked\";i:0;s:14:\"list_29_forced\";i:0;s:20:\"list_29_subscription\";i:0;s:15:\"list_29_profile\";i:0;s:7:\"list_30\";s:0:\"\";s:14:\"list_30_status\";i:0;s:15:\"list_30_checked\";i:0;s:14:\"list_30_forced\";i:0;s:20:\"list_30_subscription\";i:0;s:15:\"list_30_profile\";i:0;s:7:\"list_31\";s:0:\"\";s:14:\"list_31_status\";i:0;s:15:\"list_31_checked\";i:0;s:14:\"list_31_forced\";i:0;s:20:\"list_31_subscription\";i:0;s:15:\"list_31_profile\";i:0;s:7:\"list_32\";s:0:\"\";s:14:\"list_32_status\";i:0;s:15:\"list_32_checked\";i:0;s:14:\"list_32_forced\";i:0;s:20:\"list_32_subscription\";i:0;s:15:\"list_32_profile\";i:0;s:7:\"list_33\";s:0:\"\";s:14:\"list_33_status\";i:0;s:15:\"list_33_checked\";i:0;s:14:\"list_33_forced\";i:0;s:20:\"list_33_subscription\";i:0;s:15:\"list_33_profile\";i:0;s:7:\"list_34\";s:0:\"\";s:14:\"list_34_status\";i:0;s:15:\"list_34_checked\";i:0;s:14:\"list_34_forced\";i:0;s:20:\"list_34_subscription\";i:0;s:15:\"list_34_profile\";i:0;s:7:\"list_35\";s:0:\"\";s:14:\"list_35_status\";i:0;s:15:\"list_35_checked\";i:0;s:14:\"list_35_forced\";i:0;s:20:\"list_35_subscription\";i:0;s:15:\"list_35_profile\";i:0;s:7:\"list_36\";s:0:\"\";s:14:\"list_36_status\";i:0;s:15:\"list_36_checked\";i:0;s:14:\"list_36_forced\";i:0;s:20:\"list_36_subscription\";i:0;s:15:\"list_36_profile\";i:0;s:7:\"list_37\";s:0:\"\";s:14:\"list_37_status\";i:0;s:15:\"list_37_checked\";i:0;s:14:\"list_37_forced\";i:0;s:20:\"list_37_subscription\";i:0;s:15:\"list_37_profile\";i:0;s:7:\"list_38\";s:0:\"\";s:14:\"list_38_status\";i:0;s:15:\"list_38_checked\";i:0;s:14:\"list_38_forced\";i:0;s:20:\"list_38_subscription\";i:0;s:15:\"list_38_profile\";i:0;s:7:\"list_39\";s:0:\"\";s:14:\"list_39_status\";i:0;s:15:\"list_39_checked\";i:0;s:14:\"list_39_forced\";i:0;s:20:\"list_39_subscription\";i:0;s:15:\"list_39_profile\";i:0;s:7:\"list_40\";s:0:\"\";s:14:\"list_40_status\";i:0;s:15:\"list_40_checked\";i:0;s:14:\"list_40_forced\";i:0;s:20:\"list_40_subscription\";i:0;s:15:\"list_40_profile\";i:0;}',	'yes'),
(104,	'cron',	'a:34:{i:1634122466;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1634122650;a:1:{s:10:\"newsletter\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"newsletter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1634122738;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"26e9e6ff95b3d23cf3d0202a8d7dfd36\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:22;}}}}i:1634122781;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"24daa8f49584a6f1b1395d475758a1de\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:23;}}}}i:1634122963;a:1:{s:25:\"group_post_scheduler_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1634122964;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1634122970;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1634123173;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1634125733;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1634126546;a:1:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1634137346;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1634158133;a:4:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1634158939;a:1:{s:12:\"cff_cron_job\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1634158941;a:2:{s:21:\"sb_instagram_cron_job\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:23:\"sb_instagram_twicedaily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1634158963;a:1:{s:30:\"tribe_schedule_transient_purge\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1634169600;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1634201333;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1634201335;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1634202112;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1634202134;a:2:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1634202156;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1634202163;a:2:{s:24:\"tribe_common_log_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:16:\"tribe_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1634202164;a:2:{s:26:\"ACFFA_refresh_latest_icons\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1634208676;a:1:{s:27:\"give_daily_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1634302793;a:1:{s:23:\"cff_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1634381476;a:1:{s:30:\"give_thricely_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:8:\"thricely\";s:4:\"args\";a:0:{}s:8:\"interval\";i:259200;}}}i:1634480975;a:1:{s:23:\"ctf_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1634531135;a:1:{s:23:\"sbi_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1634720534;a:1:{s:16:\"wpseo_ryte_fetch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1634727076;a:1:{s:28:\"give_weekly_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1635141600;a:4:{s:20:\"cff_feed_issue_email\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:9:\"cffweekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:23:\"cff_notification_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:9:\"cffweekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:29:\"sb_instagram_feed_issue_email\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:9:\"sbiweekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:23:\"sbi_notification_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:9:\"sbiweekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1635411806;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}i:1636714276;a:1:{s:29:\"give_monthly_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}s:7:\"version\";i:2;}',	'yes'),
(105,	'widget_pages',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(106,	'widget_calendar',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(107,	'widget_archives',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(108,	'widget_media_audio',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(109,	'widget_media_image',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(110,	'widget_media_gallery',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(111,	'widget_media_video',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(112,	'widget_meta',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(113,	'widget_search',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(114,	'widget_tag_cloud',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(115,	'widget_nav_menu',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(116,	'widget_custom_html',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(127,	'wp-reset',	'a:4:{s:4:\"meta\";a:3:{s:13:\"first_version\";s:4:\"1.93\";s:13:\"first_install\";i:1634114880;s:11:\"reset_count\";i:1;}s:17:\"dismissed_notices\";a:1:{s:7:\"welcome\";b:1;}s:8:\"last_run\";a:0:{}s:7:\"options\";a:0:{}}',	'yes'),
(118,	'recovery_keys',	'a:0:{}',	'yes'),
(120,	'https_detection_errors',	'a:0:{}',	'yes'),
(119,	'theme_mods_twentytwentyone',	'a:3:{s:18:\"custom_css_post_id\";i:-1;s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:2;s:6:\"footer\";i:3;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1634115601;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}',	'yes'),
(121,	'_site_transient_update_core',	'O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.8.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.8.1.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.8.1-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.8.1-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"5.8.1\";s:7:\"version\";s:5:\"5.8.1\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.6\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1634115747;s:15:\"version_checked\";s:5:\"5.8.1\";s:12:\"translations\";a:0:{}}',	'no'),
(170,	'give_settings',	'a:53:{s:12:\"base_country\";s:2:\"US\";s:9:\"test_mode\";s:7:\"enabled\";s:8:\"currency\";s:3:\"USD\";s:17:\"currency_position\";s:6:\"before\";s:16:\"session_lifetime\";s:6:\"604800\";s:12:\"email_access\";s:7:\"enabled\";s:19:\"thousands_separator\";s:1:\",\";s:17:\"decimal_separator\";s:1:\".\";s:15:\"number_decimals\";i:2;s:26:\"sequential-ordering_status\";s:7:\"enabled\";s:3:\"css\";s:7:\"enabled\";s:11:\"floatlabels\";s:8:\"disabled\";s:13:\"company_field\";s:8:\"disabled\";s:17:\"name_title_prefix\";s:8:\"disabled\";s:14:\"forms_singular\";s:7:\"enabled\";s:14:\"forms_archives\";s:7:\"enabled\";s:13:\"forms_excerpt\";s:7:\"enabled\";s:17:\"form_featured_img\";s:7:\"enabled\";s:12:\"form_sidebar\";s:7:\"enabled\";s:10:\"categories\";s:8:\"disabled\";s:4:\"tags\";s:8:\"disabled\";s:5:\"terms\";s:8:\"disabled\";s:13:\"admin_notices\";s:7:\"enabled\";s:5:\"cache\";s:7:\"enabled\";s:19:\"uninstall_on_delete\";s:8:\"disabled\";s:18:\"the_content_filter\";s:7:\"enabled\";s:14:\"scripts_footer\";s:8:\"disabled\";s:20:\"agree_to_terms_label\";s:15:\"Agree to Terms?\";s:14:\"agreement_text\";s:2016:\"<p>Acceptance of any contribution, gift or grant is at the discretion of the Safeplace @GHAPO. The  Safeplace @GHAPO will not accept any gift unless it can be used or expended consistently with the purpose and mission of the  Safeplace @GHAPO.</p>\n				<p>No irrevocable gift, whether outright or life-income in character, will be accepted if under any reasonable set of circumstances the gift would jeopardize the donor’s financial security.</p>\n				<p>The Safeplace @GHAPO will refrain from providing advice about the tax or other treatment of gifts and will encourage donors to seek guidance from their own professional advisers to assist them in the process of making their donation.</p>\n				<p>The Safeplace @GHAPO will accept donations of cash or publicly traded securities. Gifts of in-kind services will be accepted at the discretion of the Safeplace @GHAPO.</p>\n				<p>Certain other gifts, real property, personal property, in-kind gifts, non-liquid securities, and contributions whose sources are not transparent or whose use is restricted in some manner, must be reviewed prior to acceptance due to the special obligations raised or liabilities they may pose for Safeplace @GHAPO.</p>\n				<p>The Safeplace @GHAPO will provide acknowledgments to donors meeting tax requirements for property received by the charity as a gift. However, except for gifts of cash and publicly traded securities, no value shall be ascribed to any receipt or other form of substantiation of a gift received by Safeplace @GHAPO.</p>\n				<p>The Safeplace @GHAPO will respect the intent of the donor relating to gifts for restricted purposes and those relating to the desire to remain anonymous. With respect to anonymous gifts, the Safeplace @GHAPO will restrict information about the donor to only those staff members with a need to know.</p>\n				<p>The Safeplace @GHAPO will not compensate, whether through commissions, finders\' fees, or other means, any third party for directing a gift or a donor to the Safeplace @GHAPO.</p>\";s:21:\"babel_polyfill_script\";s:7:\"enabled\";s:8:\"gateways\";a:2:{s:6:\"manual\";i:1;s:7:\"offline\";i:1;}s:15:\"default_gateway\";s:6:\"manual\";s:31:\"global_offline_donation_content\";s:331:\"<p>To make an offline donation toward this cause, follow these steps: </p><ol><li>Write a check payable to \"{sitename}\"</li><li>On the memo line of the check, indicate that the donation is for \"{sitename}\"</li><li>Mail your check to:</li></ol>{offline_mailing_address}<br><p>Your tax-deductible donation is greatly appreciated!</p>\";s:43:\"give_offline_donation_enable_billing_fields\";s:8:\"disabled\";s:23:\"donor_default_user_role\";s:10:\"give_donor\";s:20:\"form_page_url_prefix\";s:4:\"give\";s:29:\"_give_stripe_get_all_accounts\";a:0:{}s:18:\"setup_page_enabled\";s:7:\"enabled\";s:14:\"usage_tracking\";s:8:\"disabled\";s:26:\"sequential-ordering_number\";i:1;s:42:\"offline-donation-instruction_email_message\";s:331:\"<p>To make an offline donation toward this cause, follow these steps: </p><ol><li>Write a check payable to \"{sitename}\"</li><li>On the memo line of the check, indicate that the donation is for \"{sitename}\"</li><li>Mail your check to:</li></ol>{offline_mailing_address}<br><p>Your tax-deductible donation is greatly appreciated!</p>\";s:30:\"donation-receipt_email_message\";s:394:\"Dear {name},\n\nThank you for your donation. Your generosity is appreciated! Here are the details of your donation:\n\n<strong>Donor:</strong> {fullname}\n<strong>Donation:</strong> {donation}\n<strong>Donation Date:</strong> {date}\n<strong>Amount:</strong> {amount}\n<strong>Payment Method:</strong> {payment_method}\n<strong>Payment ID:</strong> {payment_id}\n\n{receipt_link}\n\n\n\nSincerely,\n{sitename}\n\";s:26:\"new-donation_email_message\";s:280:\"Hi there,\n\nThis email is to inform you that a new donation has been made on your website: {site_url}.\n\n<strong>Donor:</strong> {name}\n<strong>Donation:</strong> {donation}\n<strong>Amount:</strong> {amount}\n<strong>Payment Method:</strong> {payment_method}\n\nThank you,\n\n{sitename}\n\";s:22:\"new-donation_recipient\";a:1:{i:0;s:21:\"bimbome.ojo@gmail.com\";}s:30:\"new-offline-donation_recipient\";a:1:{i:0;s:21:\"bimbome.ojo@gmail.com\";}s:28:\"new-donor-register_recipient\";a:1:{i:0;s:21:\"bimbome.ojo@gmail.com\";}s:25:\"new-donation_notification\";s:7:\"enabled\";s:12:\"success_page\";i:33;s:12:\"failure_page\";i:34;s:20:\"donor_dashboard_page\";i:35;s:41:\"override_legacy_donation_management_pages\";s:7:\"enabled\";s:12:\"history_page\";i:35;s:18:\"subscriptions_page\";i:35;}',	'no'),
(171,	'give_default_api_version',	'v1',	'no'),
(172,	'sgkf_give_donors_db_version',	'1.0',	'no'),
(173,	'sgkf_give_donormeta_db_version',	'1.0',	'no'),
(174,	'sgkf_give_comments_db_version',	'1.0',	'no'),
(175,	'sgkf_give_commentmeta_db_version',	'1.0',	'no'),
(176,	'sgkf_give_sessions_db_version',	'1.0',	'no'),
(177,	'sgkf_give_formmeta_db_version',	'1.0',	'no'),
(178,	'sgkf_give_sequential_ordering_db_version',	'1.0',	'no'),
(621,	'_site_transient_timeout_theme_roots',	'1634123554',	'no'),
(622,	'_site_transient_theme_roots',	'a:5:{s:11:\"alone-child\";s:7:\"/themes\";s:5:\"alone\";s:7:\"/themes\";s:14:\"twentynineteen\";s:7:\"/themes\";s:12:\"twentytwenty\";s:7:\"/themes\";s:15:\"twentytwentyone\";s:7:\"/themes\";}',	'no'),
(162,	'_site_transient_update_themes',	'O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1634122340;s:7:\"checked\";a:5:{s:11:\"alone-child\";s:3:\"7.0\";s:5:\"alone\";s:5:\"7.2.1\";s:14:\"twentynineteen\";s:3:\"2.1\";s:12:\"twentytwenty\";s:3:\"1.8\";s:15:\"twentytwentyone\";s:3:\"1.4\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:3:{s:14:\"twentynineteen\";a:6:{s:5:\"theme\";s:14:\"twentynineteen\";s:11:\"new_version\";s:3:\"2.1\";s:3:\"url\";s:44:\"https://wordpress.org/themes/twentynineteen/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentynineteen.2.1.zip\";s:8:\"requires\";s:5:\"4.9.6\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:12:\"twentytwenty\";a:6:{s:5:\"theme\";s:12:\"twentytwenty\";s:11:\"new_version\";s:3:\"1.8\";s:3:\"url\";s:42:\"https://wordpress.org/themes/twentytwenty/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/twentytwenty.1.8.zip\";s:8:\"requires\";s:3:\"4.7\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:15:\"twentytwentyone\";a:6:{s:5:\"theme\";s:15:\"twentytwentyone\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentyone/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentyone.1.4.zip\";s:8:\"requires\";s:3:\"5.3\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}',	'no'),
(167,	'elementor_active_kit',	'24',	'yes'),
(179,	'sgkf_give_donationmeta_db_version',	'1.0',	'no'),
(164,	'current_theme',	'Alone',	'yes'),
(165,	'theme_mods_alone-child',	'a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:2;s:6:\"footer\";i:3;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1634116013;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:12:\"blog-sidebar\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:14:\"topbar-sidebar\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:14:\"footer-sidebar\";a:0:{}}}}',	'yes'),
(166,	'theme_switched',	'',	'yes'),
(128,	'wp-reset-snapshots',	'a:0:{}',	'yes'),
(129,	'_site_transient_timeout_browser_a44e7ab8cc69f9e2b9db9430df373653',	'1634719735',	'no'),
(130,	'_site_transient_browser_a44e7ab8cc69f9e2b9db9430df373653',	'a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"94.0.4606.71\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}',	'no'),
(131,	'_site_transient_timeout_php_check_d4508776add2ac959ef9a5d5285e77c3',	'1634719735',	'no'),
(132,	'_site_transient_php_check_d4508776add2ac959ef9a5d5285e77c3',	'a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}',	'no'),
(154,	'widget_recent-comments',	'a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}',	'yes'),
(153,	'finished_updating_comment_type',	'1',	'yes'),
(134,	'_site_transient_timeout_community-events-02063974de236614478743327be7e1a5',	'1634158144',	'no'),
(135,	'_site_transient_community-events-02063974de236614478743327be7e1a5',	'a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"105.112.62.0\";}s:6:\"events\";a:3:{i:0;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:46:\"Discussion Group: Organizing WordPress Meetups\";s:3:\"url\";s:68:\"https://www.meetup.com/learn-wordpress-discussions/events/281256448/\";s:6:\"meetup\";s:27:\"Learn WordPress Discussions\";s:10:\"meetup_url\";s:51:\"https://www.meetup.com/learn-wordpress-discussions/\";s:4:\"date\";s:19:\"2021-10-13 16:00:00\";s:8:\"end_date\";s:19:\"2021-10-13 17:00:00\";s:20:\"start_unix_timestamp\";i:1634166000;s:18:\"end_unix_timestamp\";i:1634169600;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"US\";s:8:\"latitude\";d:37.779998779297;s:9:\"longitude\";d:-122.41999816895;}}i:1;a:10:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:27:\"WordCamp Italia Online 2021\";s:3:\"url\";s:33:\"https://italia.wordcamp.org/2021/\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2021-10-22 14:00:00\";s:8:\"end_date\";s:19:\"2021-10-23 00:00:00\";s:20:\"start_unix_timestamp\";i:1634904000;s:18:\"end_unix_timestamp\";i:1634940000;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"IT\";s:8:\"latitude\";d:41.8725553;s:9:\"longitude\";d:12.516448;}}i:2;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:57:\"How to use your voice to create change during a pandemic!\";s:3:\"url\";s:63:\"https://www.meetup.com/Ijebu-WordPress-Meetup/events/281077839/\";s:6:\"meetup\";s:22:\"Ijebu WordPress Meetup\";s:10:\"meetup_url\";s:46:\"https://www.meetup.com/Ijebu-WordPress-Meetup/\";s:4:\"date\";s:19:\"2021-10-17 15:00:00\";s:8:\"end_date\";s:19:\"2021-10-17 16:00:00\";s:20:\"start_unix_timestamp\";i:1634479200;s:18:\"end_unix_timestamp\";i:1634482800;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"NG\";s:8:\"latitude\";d:6.8099999427795;s:9:\"longitude\";d:3.9200000762939;}}}}',	'no'),
(136,	'_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3',	'1634158144',	'no'),
(137,	'_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3',	'a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:79:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"News –  – WordPress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 05 Oct 2021 20:05:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.9-alpha-51904\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:20:{i:0;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"The Month in WordPress: September 2021\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wordpress.org/news/2021/10/the-month-in-wordpress-september-2021/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 05 Oct 2021 20:01:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11327\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:351:\"There’s a lot of tolerance in open source software for shipping slightly imperfect work. And that’s good. When we ship software that’s a little bit imperfect, it makes it clear how everyone can participate, how everyone could participate, if they could find this WordPress community that supports the CMS. That was Josepha Haden on the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Hari Shanker R\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:16575:\"\n<blockquote class=\"wp-block-quote\"><p>There’s a lot of tolerance in open source software for shipping slightly imperfect work. And that’s good. When we ship software that’s a little bit imperfect, it makes it clear how everyone can participate, how everyone could participate, if they could find this WordPress community that supports the CMS.</p></blockquote>\n\n\n\n<p class=\"has-drop-cap\">That was <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden</a> on the “<a href=\"https://wordpress.org/news/2021/09/episode-16-a-sneak-peek-at-wordpress-5-9/\">A Sneak Peek at WordPress 5.9</a>” episode of the <a href=\"https://wordpress.org/news/podcast/\">WP Briefing Podcast</a>, talking about what goes into a WordPress release like version 5.9. Read on to find out more about updates on the latest release and the latest WordPress news from September 2021.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>WordPress Translation Day 2021 Celebrations ran for 30 days</h2>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" width=\"632\" height=\"332\" src=\"https://i2.wp.com/wordpress.org/news/files/2021/10/image.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C332&#038;ssl=1\" alt=\"WP Translation Day Matt Mullenweg Quote. Quote text: “Translation is so magical because it multiplies the work of all the other contributors of WordPress. If you care about freedom and the future of the internet, translating WordPress is one of the best things you can do for people who speak your language.”\" class=\"wp-image-11328\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2021/10/image.png?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C538&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2021/10/image.png?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C158&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2021/10/image.png?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C403&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2021/10/image.png?w=1200&amp;ssl=1 1200w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>WordPress Contributor teams, led by the Polyglots and Marketing teams, organized <a href=\"https://wptranslationday.org/\">WordPress Translation Day celebrations</a> for the entire month of September. Contributors from across the world joined the celebrations by translating WordPress into their own languages. Additionally, the team organized a host of <a href=\"https://wptranslationday.org/wptd-2021/global-events/\">global</a> and <a href=\"https://wptranslationday.org/wptd-2021/local-events/\">local events</a>. Translation sprints were organized by the <a href=\"https://make.wordpress.org/community/2021/09/20/kicking-off-the-community-documentation-translation-sprint-from-september-20-to-24/\">Community</a> and <a href=\"https://make.wordpress.org/training/2021/09/30/wptranslationday-subtitling-videos-on-learn/\">Training</a> teams, as well as local groups.</p>\n\n\n\n<p>As part of the celebrations, nominations were invited for contributors who had made a significant impact on the translation of WordPress and its availability in so many languages worldwide. <a href=\"https://wptranslationday.org/blog/call-for-nominations-polyglots-appreciation/\">More than 30 notable polyglot contributors were nominated for their contributions</a>. They will be featured in the coming month on the <a href=\"https://wptranslationday.org/\">WP Translation Day website, together with event recaps and more news.</a></p>\n\n\n\n<p>Read the latest <a href=\"https://wordpress.org/news/2021/09/people-of-wordpress-yordan-soares/\">People of WordPress feature on polyglots contributor Yordan Soares</a>, from South America.</p>\n\n\n\n<h2>WordPress Release updates</h2>\n\n\n\n<ul><li>WordPress security and maintenance release – <a href=\"https://wordpress.org/news/2021/09/wordpress-5-8-1-security-and-maintenance-release/\">Version 5.8.1</a> came out on September 9, 2021. The release fixes three major issues and includes 60 bug fixes. You can update to the latest version directly from your WordPress dashboard or by <a href=\"https://wordpress.org/download/\">downloading</a> it from WordPress.org. The <a href=\"https://make.wordpress.org/core/2021/10/04/wordpress-5-8-2-deferred/\">5.8.2 release has been deferred</a> and if needed a minor release will be added before 5.9.&nbsp;</li><li>Work is progressing towards WordPress 5.9, and the team released a <a href=\"https://make.wordpress.org/core/2021/09/03/wordpress-5-9-planning-roundup/\">planning round-up</a> along with a <a href=\"https://make.wordpress.org/core/2021/09/03/wordpress-5-9-planning-roundup/\">call for release leads</a>. October 14 is the go/no-go date of the release, which is planned to be <a href=\"https://make.wordpress.org/core/2021/09/03/wordpress-5-9-planning-roundup/\">launched on December 14, 2021</a>.</li></ul>\n\n\n\n<p>Want to contribute to WordPress core? Join the <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> channel, follow the <a href=\"https://make.wordpress.org/core/\">Core Team blog</a>, and check out the <a href=\"https://make.wordpress.org/core/handbook/\">team handbook</a>. Don’t miss the Core Team chats on Wednesdays at <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?hour=5&amp;min=00&amp;sec=0\">5 AM</a> and <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?hour=20&amp;min=00&amp;sec=0\">8 PM</a> UTC.&nbsp;</p>\n\n\n\n<h2>Say hi to Gutenberg Versions 11.4 and 11.5</h2>\n\n\n\n<p>We launched Gutenberg <a href=\"https://make.wordpress.org/core/2021/09/01/whats-new-in-gutenberg-11-4-1-september/\">version 11.4</a> and <a href=\"https://make.wordpress.org/core/2021/09/17/whats-new-in-gutenberg-11-5-16-september/\">version 11.5</a> this month. <a href=\"https://make.wordpress.org/core/2021/09/01/whats-new-in-gutenberg-11-4-1-september/\">Version 11.4</a> adds image blocks to the gallery block, duotone filters for featured images, and padding support for Button Blocks. <a href=\"https://make.wordpress.org/core/2021/09/17/whats-new-in-gutenberg-11-5-16-september/\">Version 11.5</a> adds flex layout support to the group and social icon blocks along with <a href=\"https://make.wordpress.org/core/2021/09/22/core-editor-improvement-introducing-the-widget-group-block/\">widget group blocks</a>. It will support the addition of a site logo or title directly into menus.</p>\n\n\n\n<p>Want to get involved in developing Gutenberg? Follow <a href=\"https://make.wordpress.org/core/\">the Core Team blog</a>, contribute to <a href=\"https://github.com/WordPress/gutenberg/\">Gutenberg on GitHub</a>, and join the <a href=\"https://wordpress.slack.com/archives/C02QB2JS7\">#core-editor</a> channel in the <a href=\"https://make.wordpress.org/chat/\">Make WordPress Slack</a>. The <a href=\"https://make.wordpress.org/core/2021/09/17/whats-next-in-gutenberg-mid-september-2021/\">What’s next in Gutenberg</a> post gives details on the latest updates.</p>\n\n\n\n<h2>New Guidelines for in-person WordCamps</h2>\n\n\n\n<p>The Community Team <a href=\"https://make.wordpress.org/community/2021/09/13/announcement-updated-guidelines-for-in-person-wordcamps/\">published new guidelines</a> for returning to in-person WordCamps in regions where in-person events are allowed by the local public health authorities.&nbsp;</p>\n\n\n\n<p>Community members can now organize in-person WordCamps for fully vaccinated, recently tested negative, or recently recovered folks (in the last three months) — provided their region passes the in-person <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/2021-returning-to-in-person-meetups/in-person-meetup-decision-checklist/\">safety checklist</a> OR if vaccines and/or COVID testing are accessible to all. Organizers can continue to plan online WordCamps if their region does not meet the guideline.&nbsp;</p>\n\n\n\n<p>New guidelines are also available on the <a href=\"https://make.wordpress.org/community/2021/09/27/announcement-returning-to-in-person-do_action-charity-hackathons/\">return of in-person do_action hackathons</a>.</p>\n\n\n\n<p>Want to get involved in the Community Team and help bring back in-person WordPress events? <a href=\"https://make.wordpress.org/community/\">Follow the Community Team blog</a> and join the <a href=\"https://wordpress.slack.com/archives/C02RQC7RN\">#community-events</a> channel in <a href=\"https://make.wordpress.org/chat/\">the Make WordPress Slack</a>! Check out the following <a href=\"https://central.wordcamp.org/\">upcoming WordCamps</a> and <a href=\"https://make.wordpress.org/community/events/\">meetups</a>.</p>\n\n\n\n<h2>Important Team announcements/updates</h2>\n\n\n\n<ul><li>The Polyglots Team <a href=\"https://make.wordpress.org/polyglots/2021/09/27/sign-up-for-the-new-polyglots-monthly-newsletter/\">opened sign-ups</a> for their new monthly newsletter. The first edition goes out on October 15!</li><li>The<a href=\"https://make.wordpress.org/project/2021/09/10/suggested-iterations-for-the-five-for-the-future-program-and-tool/\"> Five for the Future program is being revisited</a> to identify opportunities for growth.&nbsp;</li><li>The Docs Team formally <a href=\"https://make.wordpress.org/docs/2021/09/15/announcement-new-workflow-for-reporting-documentation-issues/\">launched a new repository</a> for tracking issues with WordPress documentation: <a href=\"https://github.com/WordPress/Documentation-Issue-Tracker\">https://github.com/WordPress/Documentation-Issue-Tracker</a></li><li>The Plugins Team <a href=\"https://make.wordpress.org/plugins/2021/09/20/change-to-how-long-active-reviews-remain-open/\">reduced the time period to complete active review requests for plugins</a> from six to three months.</li><li>The Community Team started work on the <a href=\"https://make.wordpress.org/community/2021/09/10/2022-global-sponsorship-working-group/\">2022 Global Sponsorship program</a>.</li><li>The Design Team is <a href=\"https://make.wordpress.org/design/2021/09/16/document-status-and-visibility/\">working on a redesign proposal of the Inspector sidebar</a> in the WordPress post/page editor.</li><li>The Themes Team announced the results of the <a href=\"https://make.wordpress.org/themes/2021/09/13/theme-upload-survey-results-next-steps/\">six-week Theme author survey</a>.</li><li>The Training Team also shared <a href=\"https://make.wordpress.org/training/2021/09/14/learn-wordpress-needs-assessment-results/\">results of a third-party needs assessment exercise for Learn WordPress</a> which offers some excellent insights.&nbsp;</li></ul>\n\n\n\n<h2>Feedback/Testing requests from Contributor Teams</h2>\n\n\n\n<ul><li>Version 18.3 of WordPress for <a href=\"https://make.wordpress.org/mobile/2021/09/20/call-for-testing-wordpress-for-ios-18-3/\">iOS</a> and <a href=\"https://make.wordpress.org/mobile/2021/09/21/call-for-testing-wordpress-for-android-18-3/\">Android</a> are now available for testing!</li><li>Join the <a href=\"https://make.wordpress.org/test/2021/09/29/fse-program-testing-call-10-pattern-party/\">10th challenge</a> of the <a href=\"https://make.wordpress.org/core/2020/12/11/the-fse-outreach-program-is-officially-starting/\">Full Site Editing (FSE) Outreach program</a> &#8211; “<a href=\"https://make.wordpress.org/test/2021/09/29/fse-program-testing-call-10-pattern-party/\">Pattern Party</a>”. Check out the <a href=\"https://make.wordpress.org/test/2021/09/29/fse-program-testing-call-10-pattern-party/\">announcement post</a> for testing instructions and join the fun in the <a href=\"https://wordpress.slack.com/archives/C015GUFFC00\">#fse-outreach-experiment</a> Slack channel. Deadline: October 13, 2021</li><li>The Training Team is requesting feedback on:<ul><li><a href=\"https://make.wordpress.org/training/2021/09/27/proposal-ensuring-high-quality-video-contributions-to-learn-wordpress/\">Strategies to ensure high-quality video contributions for Learn WordPress</a>. Deadline: October 6, 2021</li><li><a href=\"https://make.wordpress.org/training/2021/08/10/proposal-learner-achievements-on-profiles/\">Learner achievements on profiles</a>: no current deadline</li></ul></li><li>Help the Test Team <a href=\"https://make.wordpress.org/test/2021/10/01/test-team-chat-summary-28-september-2021/\">reach out to extenders to check if their test suites are compatible with the modernization of the WordPress Core PHP Test Suites</a>. Information on what the changes mean and step-by-step instructions are available over in the following post: <a href=\"https://make.wordpress.org/core/2021/09/27/changes-to-the-wordpress-core-php-test-suite/\">Changes to the WordPress Core PHP Test Suite</a>.</li><li>The Polyglots Team is <a href=\"https://make.wordpress.org/polyglots/2021/09/19/how-to-handle-block-pattern-translations/\">exploring two different mechanisms on translating user-submitted block patterns</a>: GlotPress v/s forking patterns to locales and is requesting feedback from community members.</li></ul>\n\n\n\n<h2>WordPress Events updates</h2>\n\n\n\n<ul><li><a href=\"https://galicia.wordcamp.org/2021/\">WordCamp Galicia 2021</a> was held from September 30 &#8211; October 2, 2021 and <a href=\"https://us.wordcamp.org/2021/\">WordCamp US 2021</a> ran on October 1.</li><li>Don’t miss these upcoming WordCamps: <a href=\"https://nicaragua.wordcamp.org/2021/\">WordCamp Nicaragua 2021</a> (October 8-9, 2021) and <a href=\"https://italia.wordcamp.org/2021/\">WordCamp Italia 2021</a> (October 22-23, 2021) </li><li>The Diverse Speakers Training group (<a href=\"https://make.wordpress.org/community/tag/wpdiversity/\">#WPDiversity</a>) of the Community Team organized an <a href=\"https://make.wordpress.org/community/2021/09/15/wpdiversity-events-in-september-attention-india/\">allyship workshop, along with dedicated workshops focused on India in September</a>.</li><li>The Test Team organized a <a href=\"https://make.wordpress.org/test/2021/09/17/hallway-hangout-discussion-on-adoption-pathways-for-full-site-editing-16-september/\">Hallway Hangout on adoption pathways for Full Site Editing</a> where attendees mentioned how they use FSE and shared ideas for improvement. </li></ul>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further reading</h2>\n\n\n\n<ul><li>The Hosting Team recommended that all web hosts <a href=\"https://make.wordpress.org/hosting/2021/09/15/wordpress-5-8-1-security-release-is-time-sensitive/\">test and push the WordPress 5.8.1 security update through to their users</a> as soon as possible.</li><li>The Training Team <a href=\"https://make.wordpress.org/training/2021/09/21/should-learn-wordpress-contributors-be-gpl-compliant/\">clarified GPL compliance guidelines</a> for Learn WordPress contributions, and the <a href=\"https://learn.wordpress.org/meta/handbook/workshops/eligibility-of-workshop-presenters/\">guidelines for workshop presenters are available in the handbook</a>.</li><li>The codebase for Openverse, a search engine for openly-licensed media,&nbsp; i<a href=\"https://make.wordpress.org/openverse/2021/09/03/call-for-translations-i18n-in-openverse/\">s now available for translation</a>.</li><li>The Core Team implemented a <a href=\"https://make.wordpress.org/core/2021/09/28/implementing-a-webfonts-api-in-wordpress-core/\">Webfonts API in WordPress core</a> for simplifying the process of enqueuing external fonts on WordPress sites.&nbsp;</li><li>The Test Team rescheduled <a href=\"https://make.wordpress.org/test/2021/09/23/5-9-end-to-end-e2e-working-strategy-session-agenda-for-29-sep-2021/\">the End-to-End (e2e) Test working strategy session</a> to October 6. More details <a href=\"https://make.wordpress.org/test/2021/09/23/5-9-end-to-end-e2e-working-strategy-session-agenda-for-29-sep-2021/\">in the announcement post</a>.</li></ul>\n\n\n\n<p><em>Have a story that we could include in the next ‘Month in WordPress’ post? Please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it using this form</em></a><em>.&nbsp;</em></p>\n\n\n\n<p><em>The following folks contributed to September’s Month in WordPress: <a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>, <a href=\'https://profiles.wordpress.org/chaion07/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chaion07</a>, <a href=\'https://profiles.wordpress.org/dansoschin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>dansoschin</a>, <a href=\'https://profiles.wordpress.org/harishanker/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>harishanker</a>, <a href=\'https://profiles.wordpress.org/meher/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meher</a>, and <a href=\'https://profiles.wordpress.org/tobifjellner/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>tobifjellner</a></em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"11327\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:55:\"\n		\n		\n		\n		\n		\n				\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WP Briefing: Episode 17: WordPressing Your Way to Digital Literacy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://wordpress.org/news/2021/10/episode-17-wordpressing-your-way-to-digital-literacy/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 04 Oct 2021 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=11316\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:400:\"In episode 17 of the WordPress Briefing, Josepha Haden Chomphosy reflects on her WordCamp US keynote and digs into how participating in open source projects can help you learn 21st Century Skills.&#160; Have a question you&#8217;d like answered? You can submit them to wpbriefing@wordpress.org, either written or as a voice recording. Credits Editor:&#160;Dustin Hartzler Logo:&#160;Beatriz [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2021/09/WP-Briefing-017.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chloe Bringmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:29421:\"\n<p>In episode 17 of the WordPress Briefing, Josepha Haden Chomphosy reflects on her WordCamp US keynote and digs into how participating in open source projects can help you learn 21st Century Skills.&nbsp;</p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2>Credits</h2>\n\n\n\n<ul><li>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a></li><li>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li><li>Production:&nbsp;<a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a></li><li>Song: Fearless First by Kevin MacLeod</li></ul>\n\n\n\n<h2>References </h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2021/09/03/wordpress-5-9-planning-roundup/\">WordPress 5.9 Planning</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2021/08/13/preliminary-road-to-5-9/\">5.9 Target Features</a></p>\n\n\n\n<p><a href=\"https://us.wordcamp.org/2021/\">WordCamp US 2021</a></p>\n\n\n\n<h2>Transcript</h2>\n\n\n\n<span id=\"more-11316\"></span>\n\n\n\n<p>Hello, everyone, and welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. See, here we go!</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>00:42</p>\n\n\n\n<p>Today I want to talk to you a little bit about the digital divide, where it is, maybe a bit of where it&#8217;s headed, and which parts of the WordPress open source project and CMS can help. This is a focused look, though, so I won&#8217;t touch on some of the hurdles that everyone is aware of when you get outside of in-person environments, things like parental modeling or supervision, education on the relevance of technology, etc. This is a follow-up to the conversation that I had at WordCamp US last week—and so doing a little bit of a deeper dive here. And we&#8217;re gonna start with what exactly is the digital divide.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>01:23</p>\n\n\n\n<p>So the digital divide is considered those who benefit from the digital age versus those who don&#8217;t; that feels like a really big concept. And the current discussion is primarily about access, or for years that has been about access anyway, especially physical access. So those who have computers versus those who do not have internet in their homes versus those who do not. But I don&#8217;t necessarily agree with that particular, really focused definition of the problem.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>01:59</p>\n\n\n\n<p>If the only problem we see is access, then the solution becomes to get cheap devices and internet to everyone, which certainly has led to more people being connected than ever before.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>02:12</p>\n\n\n\n<p>With this proliferation of devices that are considered both smart and mobile (mobile in this context, meaning handheld or pocket-sized), the discussion over the last few years has been shifting. It’s been shifting into more of a discussion around the education around the relevance of internet access, discussions around the quality of access to the Internet, and also discussions around Wi-Fi and dial-up and the surprising cost of data.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>02:42</p>\n\n\n\n<p>But from my perspective, there are a number of really dangerous assumptions that we make when we boil it all the way down to who has access and the quality of that kind of access.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>02:54</p>\n\n\n\n<p>The first dangerous assumption is that we run the risk of conflating being tech-savvy with being digitally literate, and they&#8217;re not really the same things. The second assumption that we run the risk of is assuming that access to cellular data equals access to the internet through any other means. And also assuming that cost is always the determining factor.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>03:19</p>\n\n\n\n<p>And the final fairly dangerous assumption that we&#8217;re making there is that we allow ourselves the ability to mark the digital divide is fixed in our minds. Once we get enough access to everyone, we&#8217;re just done. There is no more divide. But as a way of illustration, if you think about access, not in the context of technology, like high technology, digital technology, and in the context of like writing, you probably own a writing utensil, and you probably have access to paper of some sort, which is great. But just because you have like a pencil and a piece of paper doesn&#8217;t mean that I can send you home right now &#8211; I guess most of you are listening at home.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>04:07</p>\n\n\n\n<p>It doesn&#8217;t mean that I can send you to your desk right now. And consider you prepared to write a best-selling novel, right? Because giving you physical tools no more makes you a novelist than handing me a computer when I was a teen made me digitally literate.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>04:24</p>\n\n\n\n<p>So let&#8217;s talk about what it takes to be digitally literate. I&#8217;ve lumped the following skills into three groups. It&#8217;s broadly defined as 21st-century skills, but the groups that I have them in is not a comprehensive list of those 21st-century skills.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>04:41</p>\n\n\n\n<p>The first group that is a large component of digital literacy is critical thinking skills. So computational thinking and problem-solving. That particular one is not new, exactly. But the computational thinking part certainly is. Not all problems are solved with code, but the basis for thinking through things procedurally is increasingly important.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>05:04</p>\n\n\n\n<p>The second one in that set is communication through multiple media, consuming communications or content through Twitter, Instagram, Snapchat, or any other format, but also creating the things that communicate—writing blogs, creating videos, both calls and standalone, and forums, things like that.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>05:27</p>\n\n\n\n<p>The third set in that group of critical thinking skills is around collaboration, which some people will say is more about communication. But I find that collaboration both online and in-person is a skill set all to its own. Communication only gets you so far when you&#8217;re learning to cook to collaborate with people that you don&#8217;t normally work with. And so, I have lumped that into critical thinking skills.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>05:54</p>\n\n\n\n<p>The second big bucket for digital literacy is actually literally digital literacy. So I have three, three things in here as well. Evaluating information is obviously incredibly important in the environment that we&#8217;re in right now, for just information’s sake. But then things like understanding the differences between copyright versus copyleft licenses, understanding the difference between an .org ending URL and a .com ending URL, and evaluating the general veracity of sources that you&#8217;re finding on the web.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>06:32</p>\n\n\n\n<p>The second part of that group is media use and creation, understanding the difference between folks who consume and folks who create the content we have, how to find information online, and the most sensible places to keep information online. And the third area of digital literacy that I find to be vitally important is the ethics of licenses both around use and access. So again, things like copyright vs. Copy, copyleft. And specifically for WordPress, that means understanding things like the Creative Commons licenses, GPL, MIT, but then also copyright is its own complicated question unto itself. But the other things that show up for us for WordPress that show up for us with technology are also things like open access versus proprietary information and sources. And things like plagiarism versus sampling.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>07:33</p>\n\n\n\n<p>And our third big bucket, which has become increasingly complex, but the third big bucket for digital literacy to my mind is actually considered something that I call life skills. So things like self-direction, knowing what you want to do next, and how to get it done. Time management is also in there, knowing how much time something will take and being able to make sure that you are getting things done over time, as opposed to trying to accomplish everything at the last second.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>08:03</p>\n\n\n\n<p>A big part of these life skills is cross-cultural and social communication. The internet is tricky, right? Because it&#8217;s simultaneously incredibly insular and increasingly global. Like you can if you wanted only ever read things that already confirm your existing biases. But the very nature of the internet, the very nature of the web, means that the world is much smaller. We have more ready access faster to everyone everywhere in the world than we used to have. This means, of course, that cultural awareness is an absolute must now more than ever. This is for what it&#8217;s worth the time of year when I give this talk. And that&#8217;s because of this last part of the life skills section, which is digital citizenship.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>08:54</p>\n\n\n\n<p>Digital citizenship generally is the second week of October 2 or the third week of October. And it&#8217;s one of my favorite weeks because it is something that comes up all the time in our ecosystem. It comes up all the time and open source in general, but certainly for WordPress. So those are our three big buckets of digital literacy, a subset of 21st-century skills as a whole.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>09:22</p>\n\n\n\n<p>That&#8217;s a lot of stuff, I know. And it&#8217;s also really hard to figure out how you can learn any of those skills, and from my experience, I really believe that WordPress as an open source project can help people learn those things.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>09:43</p>\n\n\n\n<p>Once upon a time, ages and ages ago, my mother told me that in order for me to become a better writer, I would have to read and in order to become a better communicator, it would probably help if I spent a little bit more time writing, and I have always felt that the same must be true for all the things that we learn, you find a positive example and study it to become better. Or, depending on what you&#8217;re learning and how you&#8217;re trying to learn it, you find a passive example of something that you want to be able to do better from an active standpoint and participate in that so that your active production of the other part is better.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>10:24</p>\n\n\n\n<p>Here are a few parts of the WordPress project and WordPress itself that can help with this.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>10:31</p>\n\n\n\n<p>So there are first a few really specific teams; if you&#8217;re contributing to a team like Themes, or Plugins, or Core, the three areas of those digital literacy skills that you have an opportunity to learn there. For critical thinking, you&#8217;re going to run into problem-solving and computational thinking. You’re also going to run into distributed collaboration, which was really important as just a concept when I first wrote this talk. And now it is currently really important as a reality because we have a bunch of companies that are going to either remote work or partially distributed or fully distributed. And that&#8217;s the way that WordPress has worked for a pretty long time.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>11:19</p>\n\n\n\n<p>So I&#8217;ve always felt like it was important because it was important to WordPress, but it&#8217;s also becoming increasingly an important part of just how to exist in the world at the moment. For those three teams, the things that you can really tap into and practice for the life skill section are digital literacy, nope, digital citizenship, self-direction, and time management obviously comes up in any open source project because you are volunteering your time and it is up to you to kind of decide how much you can commit or not various other parts of time management and directing one&#8217;s own project. Now, but you also get the opportunity to test and practice your cross-cultural communication, social communication and learning what it means to collaborate across cultures in that way.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>12:15</p>\n\n\n\n<p>On the digital literacy side, you also get a little bit of that information evaluation and synthesis for what it&#8217;s worth. And then obviously get to learn more about the ethics of various types of licenses and how use and access relate to those things.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>12:35</p>\n\n\n\n<p>We also have a team or two; these are not really teams or twos. These are things that you can do that are either solo activities or group activities. One is working or checking out the support forums, and the other is blogging. We’ll start with support forums.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>12:52</p>\n\n\n\n<p>If you&#8217;re doing this as a group activity, there are a couple of extra things that that you can practice here. But suppose you&#8217;re doing it as a solo, just way to give back to the project sort of thing or way to learn some of these skills sort of thing. In that case, you can get almost all of these digital literacy skills woven into working in the support forums, depending on what&#8217;s happening in the moment and the questions people have brought up. But for critical thinking, obviously, you get some problem solving in there, not as much the computational thinking as the procedural thinking part. But you certainly also get to tap into communication with multiple types of media, collaboration in person and online, depending on whether you&#8217;re doing this as a solo effort or a group effort. And then, of course, research, which I didn&#8217;t really bring up in any of those groupings for digital literacy, is certainly a very important part of it.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>13:49</p>\n\n\n\n<p>For the digital literacy grouping of skills related to digital literacy, you get to work on evaluating information and, depending on how complicated an answer might be. You can also get that opportunity to practice synthesizing complex information and research, a digital literacy skill. And then, once people have responded to a topic you&#8217;ve answered, you also get to tap into that life skill section. You get to be you get the opportunity to practice digital citizenship related to synchronous or asynchronous conversation. You also get to see more about how cross-cultural communication and collaboration works and social communication across those various boundaries that naturally show up when we&#8217;re working across cultures that way. And as I mentioned previously, information synthesis, as well.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>14:53</p>\n\n\n\n<p>The second one that I have mentioned can be like a solo effort or a group effort, depending on what you do. Blogging, for most people who use WordPress, is probably the most common application of how WordPress can help you do stuff. So I often see it as the most relevant and the most immediately accessible to anyone. But you know, you got to meet people where they are. So, I would strongly believe that this is our best way to help people learn these things.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>15:30</p>\n\n\n\n<p>So blogging for the critical thinking sorts of things, you have an opportunity to practice communication across mediums. You will probably get an opportunity to practice your research skills, chances are, you&#8217;re going to get the opportunity to practice some problem solving, and honestly, like if you&#8217;re hosting your site, problem-solving is going to come up when using WordPress as soon as you add in plugins and themes, because you sometimes kind of have to figure out what&#8217;s working and what&#8217;s not, and what&#8217;s playing nicely with other things and what&#8217;s not. It&#8217;s possible that with blogging, you&#8217;re also going to have an opportunity to get to practice some distributed collaboration. But that&#8217;s probably going to depend on what you&#8217;re doing with your site as well.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>16:30</p>\n\n\n\n<p>Licenses and how they apply to the thing that you&#8217;re using feel a bit different when you are the one who&#8217;s creating. And so learning about how those things work and don&#8217;t work and how they can best suit what you&#8217;re trying to do. Blogging is absolutely an excellent opportunity to dig into that a bit and learn a bit more about that. As far as your life skills go,</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>16:56</p>\n\n\n\n<p>that&#8217;s where you, again, get to practice some digital citizenship by figuring out who your audiences are and also when you have to communicate with them via the comments or any other way that you have built up a feedback mechanism there.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>17:11</p>\n\n\n\n<p>Self-direction obviously will come into this, maybe time management if you are blogging on, I was gonna say on a paid basis, but that&#8217;s not really I don&#8217;t know, on a project basis, like some of us are students and have to write things based on deadlines. And so, you know, self-direction, potentially time management, always cross-cultural communication, social communication, research, all of these things show up in there.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>17:41</p>\n\n\n\n<p>And, you know, I really believe in this concept of how blogging and bringing people into maintaining a website can teach you all of these skills. Because when I was younger, I was a bad communicator. And now, I am across the board known for my effective communication and my ability to work across cultures. And so the defining moment, which was like a four-year moment, and so not necessarily a moment, but the thing that really made all the difference was when my mom challenged me to write every single day. She had noted that I was not necessarily great at getting from one point to the next. I wasn&#8217;t necessarily great at building my arguments when I had to explain something to people. And she suggested that writing every day would help me tap into this big thing about communication and working with other people collaboration, all of that. And as an adult on the other side of it. Like, I thought she was super wrong when I was younger, because don&#8217;t we all think our parents are wrong when we&#8217;re younger. But as an adult on the other side of it, not only was that an opportunity for me to literally learn how to communicate better. But it also, when I look at it, gave me access to opportunities to practice all sorts of 21st-century skills and digital literacy skills in an environment that was relatively safe. And so, I am a big proponent of this particular one.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>19:26</p>\n\n\n\n<p>Another team that helps us tap into and practice a lot of our digital literacy skills is the Documentation team. I recommend that you let this be a supervised activity if you&#8217;re doing this with students because, you know, it&#8217;s a wiki. You can put weird things in there on accident or just inaccurate things. So for critical thinking, the primary skill that you&#8217;re going to be able to practice if you&#8217;re working on documentation is collaboration. You would think that it was also like information synthesis and information evaluation. But for a lot of the work that we&#8217;re doing, the documentation exists. And what we&#8217;re looking at is trying to figure out where it no longer matches what is currently in the CMS, or currently in the project or currently in the team, whatever it is that you&#8217;re working on at that moment. And so, it&#8217;s a strong collaborative effort in the WordPress project. You have to have done the general work to figure out what needs to be changed in the documentation. But a lot of times, you need to figure out who has access to make the changes, what has prevented us from making changes in the past, and things like that. And so I say, collaboration is the only one to learn and critical thinking, but it&#8217;s actually a really big one and can take a fair amount of effort in this particular context.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>20:49</p>\n\n\n\n<p>From the digital literacy aspect, of course, there is evaluating information. But this particular type of information evaluation is a little different for documentation. And this actually is true for the Documentation team, for the Training team, and also for the new Learn team. This question is true for all of them. There is a huge difference between presentation versus application of information. The way you present information for people who already know it and just need confirmation of something or are using it for reference material is really different from when people are looking at a piece of documentation that should be telling them how to accomplish something. And they try to apply it either to their own processes at the moment or apply it to teaching other people. And so evaluating information to make sure that what is presented can be applied, and all of the ways that that very complicated journey with managing information can kind of work or not, depending on how things are going in your section of the open source project at the moment.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>21:59</p>\n\n\n\n<p>The third group of skills that you can really dig into in those teams, again, is digital citizenship, basically, everything is digital citizenship in WordPress because we&#8217;re just people online.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>22:24</p>\n\n\n\n<p>And this final grouping that we have this final team and group of skills. So the Community team is a substantial and far-ranging team; they have many things that fall into their area of expertise. And so this has traditionally kind of functioned as a linchpin around education and ensuring that that was all relevant for users and attendees of events. The Community team will remain pivotal to so many things that we do now. But now that we have really awakened the Learn team and re-enlivened that Training team, this will shift a little over time. But yes, so that grain of salt that depending on when you listen to this, if you listen to it in 2050, maybe it&#8217;s not accurate anymore. Hopefully, most of what I say is not accurate in 2050. But you know, still.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>23:27</p>\n\n\n\n<p>&nbsp;Anyway! Critical thinking that&#8217;s where we were. So the critical thinking group of skills inside the Community team, you are going to have an opportunity to practice problem-solving. And frequently also procedural thinking, depending on what you&#8217;re working on in that team. Multimedia communication is absolutely true. And that&#8217;s true, whether you contribute to the team itself and make sure that the team is functioning and doing their basic tasks. Or if you are organizing an entire event, whether it&#8217;s online or offline or however that is being accomplished.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>24:07</p>\n\n\n\n<p>Multimedia communication for this particular team is constant for all of their work and something that everyone who works on there gets to practice all the time. For digital literacy, this comes up a lot if what you&#8217;re doing is working through any sort of like programming plans, making sure that what we have in place for events is really excellent. It&#8217;s a really excellent opportunity for practicing the evaluation of information, learning more about media use and creation, and then naturally, everything to do with licenses copyright copyleft, not only for everything that we produce but then also for everyone in the ecosystem.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>24:55</p>\n\n\n\n<p>This team helps so many plugins, authors and theme developers, and other groups who participate in the ecosystem understand the nuances of the GPL and why it matters so much to WordPress. And then in the life skill section, there&#8217;s the obvious life skill section, life skills that have come up for all of them—so digital citizenship, cross-cultural and social communication. But also you have the opportunity to tap into that self-direction and time management practice, which probably should also be considered in all of these teams. But, you know, things change as we go.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>25:45</p>\n\n\n\n<p>Those are the most likely digital literacy skills that you would end up practicing in the Community team, depending on how you are participating in the Community team at that moment.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>25:59</p>\n\n\n\n<p>So I said that we would talk a little bit about where this is all headed and what to do next. And like I just said, when I got lost in my own reverie, they&#8217;re like, hopefully, everything that I&#8217;ve shared here is out of date by 2050. Like, if we can come back to this particular podcast, or this presentation, or anything I&#8217;ve ever said, about digital literacy over my time with WordPress. And if we could come back to that in 2050, or, you know, I was going to say, 20 years from now, 2041 feels really close. But, you know, come back to it in the future, and say, that was all really excellent information to know at the moment. And we did do those things. And now, WordPress has proven that open source contribution and collaboration can teach all of the necessary 21st-century skills that anyone would need to survive in the world. And we did do it, that would be really cool. But I don&#8217;t think that that&#8217;s where we&#8217;re headed. Not because I don&#8217;t think people believe in what I&#8217;m saying or care about what I&#8217;m saying. But because it&#8217;s very easy to kind of let these things go at some point.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>27:20</p>\n\n\n\n<p>Even if you at some point, were proficient in all of what is considered 21st-century skills, sometimes our skills don&#8217;t get used very much. And so we lose track of them. And we don&#8217;t know, or we don&#8217;t know how to teach them to other people and various ways to do that. So I hope that when we revisit this in the time capsule of the internet 20 years from now, we can say that was a great explanation. And we learned so much. And we made so many changes in such progress that now we need a new version of this. That&#8217;s really all we can do, always striving to leave the world in a better position than when we found it.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>28:07</p>\n\n\n\n<p>All right, that brings us to our small list of big things. I don&#8217;t have a ton to share with you today. But what I do have to share with you is a really big deal. So we are about a week away from the Go/No-Go point of WordPress 5.9. That is the final release of the year. And as soon as we know what is a go or a no go from that meeting on October 12th,&nbsp; everyone is going just to hit the ground running. And so, if you are interested in contributing to that release, either by being a participant in the release squad or leading some part of the release squad. Absolutely. Drop by and let me know because I am interested to know who wants to learn more about doing that. And this is actually something that has gone by. I mentioned at the top that I spoke at WordCamp US.&nbsp; That is still true; I did do it. And so did a bunch of other really excellent presenters. If you missed WordCamp US on Friday, for whatever reason, because you know, life is complicated. Pretty soon, we will have the videos. We&#8217;ll have all the videos up with captions quickly and have those available for everyone to watch and learn more from as their schedule allows and as their attention allows. And that is your small list of big things. Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphos, and I&#8217;ll see you again in a couple of weeks.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"11316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"People of WordPress: Yordan Soares\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2021/09/people-of-wordpress-yordan-soares/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Sep 2021 13:14:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:10:\"Interviews\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:16:\"wptranslationday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11279\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"To coincide with International Translation Day, we feature the story of a developer and translator Yordan Soares from South America.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"webcommsat AbhaNonStopNewsUK\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:14138:\"\n<p><strong>WordPress is open source software, maintained by a global network of contributors. There are many examples of how WordPress has changed people’s lives for the better. In this monthly series, we share some of the amazing stories.</strong> </p>\n\n\n\n<p><strong>To coincide with International Translation Day and the final day of the <a href=\"https://wptranslationday.org/\">2021 WordPress Translation celebration</a>, we feature the story of a WordPresser who has made a major impact in the polyglots team. </strong></p>\n\n\n\n<h2>Beyond software, meeting the WordPress community</h2>\n\n\n\n<figure class=\"wp-block-image size-full\"><img loading=\"lazy\" width=\"600\" height=\"600\" src=\"https://i2.wp.com/wordpress.org/news/files/2021/09/yordan-min-300x300@2x.jpg?resize=600{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C600&#038;ssl=1\" alt=\"\" class=\"wp-image-11299\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2021/09/yordan-min-300x300@2x.jpg?w=600&amp;ssl=1 600w, https://i2.wp.com/wordpress.org/news/files/2021/09/yordan-min-300x300@2x.jpg?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C300&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2021/09/yordan-min-300x300@2x.jpg?resize=150{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C150&amp;ssl=1 150w\" sizes=\"(max-width: 600px) 100vw, 600px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>For Yordan Soares from South America, finding WordPress also meant discovering friends, community, and opportunities. He had not expected to find a whole global movement behind the web development software.</p>\n\n\n\n<p>Yordan, who is from Venezuela, South America, said: “The first time I used WordPress, I had no idea what was going on behind the software or beyond it. I knew there was someone making it all work, but I couldn’t even remotely imagine all the people who were making WordPress not just a tool for developing websites, but a whole movement that comes together to share, build, and help make the world better.”<br></p>\n\n\n\n<h2>Turning your hobby into your job</h2>\n\n\n\n<p>Initially, Yordan earned his income from computer technical support and installing networks for small and medium-sized businesses. Back in 2005, web development and code-writing was just a hobby. When he discovered the concept of CSS and how it could make everything dynamic. This opened up a whole new career pathway for him.</p>\n\n\n\n<p>In 2010, an introduction to WordPress through a friend opened up a future he had not imagined. He stopped using any other content management system (CMS) and wanted to explore how much he could do with the platform.</p>\n\n\n\n<p>Three years later in 2013, he was able to take his WordPress journey further by starting a small advertising agency with some of his friends. During this time, they crafted commercials for local radio and TV stations. Through WordPress, they found it easy to build more than 15 websites for businesses in a market that previously had not valued the importance of having an online presence.</p>\n\n\n\n<p>He said: “We were working for almost four years until at the end of 2017 the economic crisis in Venezuela became too acute, and we decided to close the agency when we stopped making profits. Taking stock of that period, I think we changed the way merchants saw the Internet business in the city.”</p>\n\n\n\n<h2>Working full time as a freelancer</h2>\n\n\n\n<p>One year on in 2018, Yordan began to freelance full-time as a web developer. His first clients were primarily agencies and friends who had emigrated to other countries. Later, he expanded into freelance marketplaces.</p>\n\n\n\n<p>At that time, getting started as a freelancer was quite a challenging task in Venezuela. The first hindrance was getting a fair level of recompense. Additionally, the deteriorating conditions in the country with constant blackouts and internet connection failures complicated matters.</p>\n\n\n\n<p>At the time, Yordan was living in Guarenas, where the situation was relatively better. He managed to get a reasonably uninterrupted electricity supply with adequate internet speed, which was just good enough to complete his projects.</p>\n\n\n\n<h2>Meeting the WordPress community</h2>\n\n\n\n<p>“Surely if I hadn’t met the community, I would have continued to work on my own, like a lone wolf, doing the ordinary work of solving problems for occasional customers and paying my bills,” he said.</p>\n\n\n\n<p>Living in Guarenas, Yordan began to experience stability in his career and made new friends and contacts. He began looking for co-working spaces or technology communities nearby, and that’s when he met the WordPress community in Caracas.</p>\n\n\n\n<p>He quickly signed up for the first face-to-face event. As soon as the event concluded, he went to talk to the co-organizer and offered his help. He was inspired to help with designing promotional pieces, managing social networks, and organizing events.</p>\n\n\n\n<p>Through such events, he met and connected with several people living in nearby cities.</p>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\" style=\"grid-template-columns:32{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9} auto\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" width=\"120\" height=\"300\" src=\"https://i0.wp.com/wordpress.org/news/files/2021/09/WP_Guarenas-Guatire-120x300-1-120x300.png?resize=120{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C300&#038;ssl=1\" alt=\"\" class=\"wp-image-11300 size-medium\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2021/09/WP_Guarenas-Guatire-120x300-1.png?resize=120{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C300&amp;ssl=1 120w, https://i0.wp.com/wordpress.org/news/files/2021/09/WP_Guarenas-Guatire-120x300-1.png?w=240&amp;ssl=1 240w\" sizes=\"(max-width: 120px) 100vw, 120px\" data-recalc-dims=\"1\" /></figure><div class=\"wp-block-media-text__content\">\n<p class=\"has-normal-font-size\"> A few months later, with other WordPress users in the area, the idea emerged to start a new Guarenas-Guatire meetup group. The idea became a reality by December 2019, when they applied to the WordPress community team. </p>\n\n\n\n<p>Once the final approvals came in, the team started scheduling the activities. The <a href=\"https://www.meetup.com/wordpress-meetup-guarenas-guatire/\">WordPress Guarenas-Guatire Meetup</a> was officially recognized!</p>\n\n\n\n<p>During the first quarter of 2020, just before the pandemic, Yordan and colleagues organized five face-to-face events. With the worldwide lockdown, in-person community engagements came to a halt. However, the Guarenas-Guatire community was eager to continue meeting.</p>\n</div></div>\n\n\n\n<p>To keep the community active and motivated, and with the support of sponsors, they started organizing online events under a format called “WordPress a la medianoche” (WordPress at midnight).</p>\n\n\n\n<p>The format of these events was inspired by Alexis Arnal, who suggested meeting at midnight to make the most of the internet speed that would usually improve somewhat after that time!</p>\n\n\n\n<p>At the time of writing, Yordan and the team have organized 16 WordPress a la medianoche events with an attendance of up to 50 people per online gathering. An impressive audience which enabled a comparatively small meetup to keep communications flowing at a difficult and unprecedented time.</p>\n\n\n\n<p>One positive of such events, is an opportunity to invite people from other countries and run sessions in partnership with others. An example was a special translation event with Javier Esteban, a member of the translation team from Spain. The meetup also invited contributors from Mexico, Costa Rica, Peru, and Colombia who were happy to participate.</p>\n\n\n\n<h2>Strengthened by the community</h2>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" width=\"632\" height=\"241\" src=\"https://i1.wp.com/wordpress.org/news/files/2021/09/wp-translation-2020.jpg?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C241&#038;ssl=1\" alt=\"\" class=\"wp-image-11307\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2021/09/wp-translation-2020.jpg?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C390&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2021/09/wp-translation-2020.jpg?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C114&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2021/09/wp-translation-2020.jpg?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C292&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2021/09/wp-translation-2020.jpg?resize=1536{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C585&amp;ssl=1 1536w, https://i1.wp.com/wordpress.org/news/files/2021/09/wp-translation-2020.jpg?w=1889&amp;ssl=1 1889w, https://i1.wp.com/wordpress.org/news/files/2021/09/wp-translation-2020.jpg?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /><figcaption>Yordan (pictured bottom left) speaking at the WordPress Translation Day 2020 events</figcaption></figure>\n\n\n\n<p>Yordan believes that he would have continued to work on his own had he not met the WordPress community.</p>\n\n\n\n<p>He said: &#8220;Fortunately, this was not the case and I have been able to live a lot of transforming experiences that have shown me the meaning of the words &#8216;community&#8217; and &#8216;volunteerism&#8217;.&#8221;</p>\n\n\n\n<p>Yordan felt empowered by the community and it led him to volunteer for many other roles and activities, including Locale Manager for <a href=\"https://translate.wordpress.org/locale/es-ve/\">Spanish Venezuela</a>, a moderator for <a href=\"https://make.wordpress.org/tv/\">WordPress.tv</a>, and as a <a href=\"https://make.wordpress.org/support/\">support</a> contributor in the forums helping people with technical issues. He has also developed free plugins for the official WordPress directory and <a href=\"https://wordpress.tv/speakers/yordan-soares/\">spoken at community events</a> including <a href=\"https://spain.wordcamp.org/2020/session/actualizaciones-automaticas-para-tus-plugins-y-temas-personalizados/\">WordCamp Spain 2020</a>.  </p>\n\n\n\n<p>All this has a boomerang effect, Yordan explains. These experiences helped him grow personally and professionally, as it’s always rewarding to know that you’ve helped improve the WordPress ecosystem.</p>\n\n\n\n<p>He also likes being able to directly help people when they need it and feels it is a two-way learning process.</p>\n\n\n\n<p>&#8220;At first, when I told my family and friends about the community and the work I was doing, they would ask me &#8216;what do you get in return?&#8217; Perhaps they expected me to tell them a specific amount of money, but the answer is more complex,&#8221; he said.</p>\n\n\n\n<p>&#8220;It’s rewarding to know that you’ve helped improve the WordPress ecosystem, the tool you use to work and put food on the table.&#8221;</p>\n\n\n\n<p>During his journey, Yordan has met many wonderful people with common interests and values, and the best part is that many of these people are now his friends, business partners, or customers.</p>\n\n\n\n<p>At the same time, he has learned new skills and gained experience, which have given him a significant confidence boost in facing difficult situations that may come in life.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" width=\"632\" height=\"332\" src=\"https://i1.wp.com/wordpress.org/news/files/2021/10/special-acknowledgement-yordansoares.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C332&#038;ssl=1\" alt=\"Polyglots special appreciation. Yordan Soares. \" class=\"wp-image-11320\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2021/10/special-acknowledgement-yordansoares.png?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C538&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2021/10/special-acknowledgement-yordansoares.png?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C158&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2021/10/special-acknowledgement-yordansoares.png?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C403&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2021/10/special-acknowledgement-yordansoares.png?w=1200&amp;ssl=1 1200w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>As part of the <a href=\"https://wordpress.org/news/2021/09/join-us-for-wordpress-translation-day-global-events-in-september-2021/\">WordPress Translation Day 2021</a> celebrations, Yordan was nominated for his contribution to the work of the Polyglots Team translating WordPress. The full nominations list and stories will be published in October and November on the <a href=\"https://wptranslationday.org/\">WordPress Translation Day website</a>. Check out the <a href=\"https://make.wordpress.org/polyglots/2021/09/30/30-days-of-translation-celebration/\">final events for International Translation Day</a>.</p>\n\n\n\n<h2>Contributors</h2>\n\n\n\n<p>Thanks to Abha Thakor (<a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>), Larissa Murillo (<a href=\'https://profiles.wordpress.org/lmurillom/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>lmurillom</a>), Maedah Batool (<a href=\'https://profiles.wordpress.org/maedahbatool/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>maedahbatool</a>), Chloé Bringmann (<a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a>), and Nalini (<a href=\'https://profiles.wordpress.org/nalininonstopnewsuk/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nalininonstopnewsuk</a>) for work on this story. Thank you to Yordan Soares (<a href=\'https://profiles.wordpress.org/yordansoares/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>yordansoares</a>) for sharing his Contributor Story, and to Josepha Haden (<a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>) and Topher DeRosia (<a href=\'https://profiles.wordpress.org/topher1kenobe/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>topher1kenobe</a>) for their support of the series. The WordPress Guarenas-Guatire logo on this page was designed by <a href=\"https://profiles.wordpress.org/bragnieljimenez/\">Bragniel Jimenez</a> </p>\n\n\n\n<p>This People of WordPress feature is inspired by an article originally published on HeroPress.com, a community initiative created by Topher DeRosia. The initiative highlights people in the WordPress community who have overcome barriers and whose stories would otherwise go unheard. Meet more WordPressers in our <a href=\"https://wordpress.org/news/category/newsletter/interviews/\">People of WordPress series.</a></p>\n\n\n\n<p>#ContributorStory #HeroPress</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"11279\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:65:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Upcoming Gallery Block improvements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2021/09/upcoming-gallery-block-improvements/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Sep 2021 15:36:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:6:\"Design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"Features\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11258\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"Thanks to @javiarce &#38; @annezazu for design and copy contributions. An exciting update to the Gallery Block gives you more ways to show off images in your posts and pages. While this change won’t be available for most folks until WordPress 5.9’s launch in December, we wanted to share some of what’s to come to [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:49:\"https://wordpress.org/news/files/2021/09/Main.mp4\";s:6:\"length\";s:8:\"16081214\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:56:\"https://wordpress.org/news/files/2021/09/Drag-_-Drop.mp4\";s:6:\"length\";s:7:\"1557447\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Kelly Hoffman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2589:\"\n<p><em>Thanks to <a href=\'https://profiles.wordpress.org/javiarce/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>javiarce</a> &amp; <a href=\'https://profiles.wordpress.org/annezazu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>annezazu</a> for design and copy contributions.</em></p>\n\n\n\n<figure class=\"wp-block-video\"><video autoplay controls loop src=\"https://wordpress.org/news/files/2021/09/Main.mp4\"></video></figure>\n\n\n\n<p>An exciting update to the Gallery Block gives you more ways to show off images in your posts and pages. While this change won’t be available for most folks until WordPress 5.9’s launch in December, we wanted to share some of what’s to come to get you excited about the future.</p>\n\n\n\n<h2>Style individual images</h2>\n\n\n\n<p>You can now use the same tools that are available for individual image blocks on <em>each</em> image in the Gallery Block! This added flexibility means you can do more customization &#8211; from adding links to each individual image, inline cropping to edit on the fly, apply unique styles for more visually compelling images, and apply an array of duotone filters.</p>\n\n\n\n<h2>Add custom styles</h2>\n\n\n\n<p>For more advanced folks who like to go a bit deeper in their customizations, you now have the option to add custom CSS styles per image. This is thanks to the ability to assign CSS classes to each image.</p>\n\n\n\n<h2>More accessible and intuitive&nbsp;</h2>\n\n\n\n<p>With this change comes the benefit of improved keyboard navigation and the ability to add alt text right within the block sidebar. You can also drag and drop to rearrange images.</p>\n\n\n\n<figure class=\"wp-block-video\"><video autoplay controls loop src=\"https://wordpress.org/news/files/2021/09/Drag-_-Drop.mp4\"></video></figure>\n\n\n\n<h2>Next steps</h2>\n\n\n\n<p>This will be available in December with the release of WordPress 5.9. You can check it out now if you’re using the Gutenberg plugin on any of your sites. Read more about <a href=\"https://wordpress.org/news/2021/04/become-an-early-adopter-with-the-gutenberg-plugin/\">becoming an early adopter</a> if you’d like to get ahead.</p>\n\n\n\n<p>If you’re a plugin or theme author who has built upon the Gallery Block functionality,<a href=\"https://make.wordpress.org/core/2021/08/20/gallery-block-refactor-dev-note/\"> be sure to check out this Dev Note detailing what steps need to be taken for compatibility</a> since this is a breaking change.</p>\n\n\n\n<p>We’re excited to see the new galleries that these options open up and what ideas you have to make creating galleries even better.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"11258\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:58:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"WP Briefing: Episode 16: A Sneak Peek at WordPress 5.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wordpress.org/news/2021/09/episode-16-a-sneak-peek-at-wordpress-5-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 20 Sep 2021 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=11248\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:423:\"In addition to this episode’s small list of big things, Josepha Haden Chomphosy reviews the upcoming 5.9 WordPress release and its Full Site Editing features. Have a question you&#8217;d like answered? You can submit them to wpbriefing@wordpress.org, either written or as a voice recording. Credits Editor:&#160;Dustin Hartzler Logo:&#160;Beatriz Fialho Production:&#160;Chloé Bringmann Song: Fearless First by [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2021/09/WP-Briefing-016.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chloe Bringmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11753:\"\n<p>In addition to this episode’s small list of big things, Josepha Haden Chomphosy reviews the upcoming 5.9 WordPress release and its Full Site Editing features.</p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2>Credits</h2>\n\n\n\n<ul><li>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a></li><li>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li><li>Production:&nbsp;<a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a></li><li>Song: Fearless First by Kevin MacLeod</li></ul>\n\n\n\n<h2>References </h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2021/09/03/wordpress-5-9-planning-roundup/\">WordPress 5.9 Planning&nbsp;</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2021/08/13/preliminary-road-to-5-9/\">5.9 Target Features</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2021/08/20/gallery-block-refactor-dev-note/\">Gallery Block Refactor Dev Notes</a></p>\n\n\n\n<p><a href=\"https://en.wikipedia.org/wiki/The_Cathedral_and_the_Bazaar\">The Cathedral and the Bazaar, 19 Lessons of Open Source</a></p>\n\n\n\n<p><a href=\"https://wptranslationday.org/\">WordPress Translation Day</a></p>\n\n\n\n<p><a href=\"https://us.wordcamp.org/2021/\">WordCamp US 2021</a></p>\n\n\n\n<p><a href=\"https://andreamiddleton.blog/2021/09/07/letters-to-an-open-source-contributor/\">Letters to an open source contributor, by Andrea Middleton</a></p>\n\n\n\n<h2>Transcript</h2>\n\n\n\n<span id=\"more-11248\"></span>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>00:10</p>\n\n\n\n<p>Hello, everyone, and welcome to the WordPress Briefing. The podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks. I&#8217;m your host, Joseph Haden Chomphosy. Here we go.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>00:40</p>\n\n\n\n<p>Today I&#8217;m going to take you through a quick look at the final WordPress release of 2021. It will be WordPress 5.9. And there will be a ton of things in it, including a fresh new default theme. And there are a few things that you need to know about it right now. The target release date is December 14, 2021, which means some of our milestones happen around Thanksgiving in the US. And a few significant commercial dates globally, days, like Giving Tuesday and Black Friday, etc. I&#8217;ll include a link to the post with all the target dates in the show notes so that you can plan with those in mind. And also in the show notes. I&#8217;ll include a link to Matías Ventura&#8217;s post that includes the target features for the release. When you look at that post, you&#8217;ll notice that you can sort of group things into two big buckets. The two buckets that I grouped them into are themes plus tools, and also better tools.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>01:31</p>\n\n\n\n<p>So bucket number one themes and all their tools. Three things were important for me as I was reading through them. Number one is that there is a default theme. As of the time of this recording, I&#8217;ve seen the early concepts for the theme, and I love them. Hopefully, by the time this podcast is published, the post that showcases the look and feel will also be up on make.wordpress.org/design. If it is, I&#8217;ll include a link in the show notes to make it easy for everyone to reference.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>02:04</p>\n\n\n\n<p>The second thing is block themes in general. So WordPress 5.8 brought to core WordPress a lot of the infrastructure needed to create block themes. And in this release in WordPress 5.9, much of that infrastructure will be made available for folks who don&#8217;t always feel comfortable working in the code. That&#8217;s mostly UX and UI changes. So user experience and user interface changes are based on user feedback that we&#8217;ve gathered over the last six to eight months. But it also will include the long-awaited navigation block.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>02:37</p>\n\n\n\n<p>The third thing that shows up for me in this first bucket, in the themes and all their tools bucket, is the UX and interface for theme.json. The user interface that we&#8217;re making available for theme.json is a major step forward in this project has been referred to as global styles for a few years. And it kind of is what it sounds like on the box, a way for users to tap into that powerful management tool that we have built through theme.JSON.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>03:09</p>\n\n\n\n<p>Bucket number two, which I am calling publicly &#8220;tools for days.&#8221; But also, I refer to it as design tools, block tools, and pattern tools. I had this whole vision of a Wizard of Oz, “lions and tigers and bears. Oh my!” moment, but I couldn’t make it work. So “design tools and block tools and pattern tools Hoorah!” That&#8217;s as close as we&#8217;re getting. So that&#8217;s my first big number two bucket for you.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>03:37</p>\n\n\n\n<p>For most of these tools, the best way to describe it is quality of life improvements, lots of streamlining of what&#8217;s there, lots of building what&#8217;s not. But there&#8217;s one that&#8217;s substantial and worth digging into a bit more. And that&#8217;s the gallery block refactor. The dev note for this already exists. Like before we had the planning round-up post, the dev note was created. And so I will put a link to that in the show notes. But the headline is that this refactor will make the creation and maintenance of image blocks and the gallery block work the same way. If you are a theme or plugin developer, head on over to the dev notes that I have linked below and take some time to get familiar with it.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>04:20</p>\n\n\n\n<p>And then the final thing, which has a bunch of small things in it, but will make a huge impact for all of our users overall, is that we&#8217;re working on more intuitive and responsive tools on blocks. That has come up frequently in our user testing again over the last six to eight months. And we are going to chip away at that long list of needs that we have in those particular toolsets. And that&#8217;s it. So that&#8217;s a really big broad look at what we&#8217;re trying to get into the final release of the year.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>04:58</p>\n\n\n\n<p>I&nbsp; know that when I say like this is our hoped for stuff. This is our best guess at the moment. Sometimes it can feel like we should know that already &#8212; I should know already what&#8217;s going into the release. And on the one hand, yes, I believe in this list of things that we&#8217;re going to put into the release, I think they&#8217;re going to be good. But I always refer to it as like the hoped-for things, the things that are on the roadmap, our best targets, because I know that I don&#8217;t ever want to ship something that is going to be a worse experience for users. And so I always like to save the space to be able to remove a feature or remove an enhancement, a little bit closer to the time of the release, just to make sure that what we are offering is the best that we can offer. However, as it says right there in the 19 learnings of open source, “if there&#8217;s a bug, there&#8217;s a job,” right? There&#8217;s a lot of tolerance in open source software for shipping, slightly imperfect work. And that&#8217;s good. When we ship software that&#8217;s a little bit imperfect, it makes it clear how everyone can participate, how everyone could participate, if they could find this WordPress community that supports the CMS.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>06:20</p>\n\n\n\n<p>If you&#8217;ve never participated in a release and are interested in learning how it goes, you can always follow along on make.wordpress.org/core. And of course, we do a lot of our meetings in the making WordPress, community Slack, which you can find at chat.wordpress.org if you are not already in that particular instance.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>06:49</p>\n\n\n\n<p>That brings us now to our small list of big things. I have three things on my list for you. The first one is WP Translation day slash month. For folks who&#8217;ve been following along for a bit, you probably noticed that Translation Day has been going on all month long all of September so that we can have small individual local events and bring people into the process of translating WordPress and making WordPress more usable for more people, especially when they don&#8217;t necessarily speak English as their first language. It&#8217;s a wonderful event. There&#8217;s been Translation Day at the end of September for years. And this Translation Month is working its way up to that Translation Day; I will leave a link to the event page in the notes below. And I really encourage you to drop by.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>07:38</p>\n\n\n\n<p>The second thing is that WordCamp US is coming up on October 1. It is going to be a virtual event, as so many of our events are right now. Tickets are open. The schedule just got published last week. And so we have a good concept of who is talking about what while we&#8217;re there. I suggest you wander over to the schedule. Take a look at anything that might be inspirational to you or anyone who looks like they&#8217;re answering questions that you&#8217;ve had as you have been trying to build your WordPress business.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>08:08</p>\n\n\n\n<p>And then the third thing on my smallest of big things. Some of you may already be aware that <a href=\"https://profiles.wordpress.org/andreamiddleton/\">Andrea Middleton</a> has left the WordPress project. She has been an absolute fixture in the WordPress open source project for the last ten years. And while we will all miss her terribly, her work has been so influential and so foundational that we actually won&#8217;t really feel much like she&#8217;s gone. We will see the evidence of her work in everything she does and everything she has done while we build a better and more inclusive WordPress after her.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>08:47</p>\n\n\n\n<p>As a final love letter to the community, she published a series of things that she learned about contributing to open source and especially how to contribute to WordPress as an open source project. I&#8217;m going to link those in the show notes as well. For anyone who has worked with Andrea for a long time, when you read it, it will just remind you of her voice and will be like a nice warm, comforting hug as she heads on to her next endeavors. And for folks who have never worked with her before. It&#8217;s still really excellent information that I think translates into all areas of our work, especially right now as people are moving to distributed work and remote work a bit more. Now I encourage everyone to at least give one or two of them a read.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>09:38</p>\n\n\n\n<p>That, my friends, is your small list of big things. Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphosy, and I&#8217;ll see you again in a couple of weeks.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"11248\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"Join us for WordPress Translation Day Global Events in September 2021\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://wordpress.org/news/2021/09/join-us-for-wordpress-translation-day-global-events-in-september-2021/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 16 Sep 2021 21:51:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:9:\"polyglots\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"translation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:16:\"wptranslationday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11215\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"WordPress contributors around the world are celebrating the sixth Global WordPress Translation Day throughout September 2021! \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"webcommsat AbhaNonStopNewsUK\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8447:\"\n<p>WordPress contributors around the world are <a href=\"https://wptranslationday.org/\">celebrating the sixth Global WordPress Translation Day</a> throughout the entire month of September! That&#8217;s 30 days dedicated to help and encourage the volunteers that translate the software and its related resources. One of the highlights will be a <a href=\"https://wptranslationday.org/wptd-2021/global-events/\">series of exciting global events</a>, starting on September 17 2021 and finishing on the United Nations&#8217; International Translation Day itself on September 30, 2021.</p>\n\n\n\n<p>Everyone is welcome to watch these events live on <a href=\"https://www.youtube.com/c/WordPressMarketingTeam\">YouTube</a> and to share their translation stories which will be featured during the celebrations and beyond. The global events will be in English and include presentations on how and why to you should join the thousands of translators in the project, tips and tools, interviews, and much more. </p>\n\n\n\n<p>There are now 205 locales translating in what is a remarkable open source effort, bringing the opportunities of the software and its community to people in their own native languages.   </p>\n\n\n\n<h2>Inaugural session: Introduction and latest news on WordPress Translation</h2>\n\n\n\n<h3><strong>Friday, September 17, 2021 at </strong><a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?iso=20210917T1000\"><strong>10:00 UTC</strong></a></h3>\n\n\n\n<p>We will start the <a href=\"https://wptranslationday.org/wptd-2021/global-events/\">global events</a> with a panel featuring the latest update on what is happening in the world of WordPress polyglots. Panellists will include translators and polyglot supporters <a href=\"https://profiles.wordpress.org/petya/\">Petya Raykovska</a> and <a href=\"https://profiles.wordpress.org/evarlese/\">Erica Varlese</a>. There will be a video demonstration on how to translate WordPress, a short presentation on translation statistics, a run down of upcoming events, and more. <br><br>Watch the <a rel=\"noreferrer noopener\" href=\"https://www.youtube.com/watch?v=3HSBB5F_ag0\" target=\"_blank\">event live on YouTube</a> (or click on the play button below) &#8211; sign-up for notifications in the video stream right now so you don&#8217;t miss it when it goes live!&nbsp;</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" class=\"youtube-player\" width=\"632\" height=\"356\" src=\"https://www.youtube.com/embed/3HSBB5F_ag0?version=3&#038;rel=1&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;fs=1&#038;hl=en-US&#038;autohide=2&#038;wmode=transparent\" allowfullscreen=\"true\" style=\"border:0;\" sandbox=\"allow-scripts allow-same-origin allow-popups allow-presentation\"></iframe>\n</div></figure>\n\n\n\n<h3><strong>Friday, September 17, 2021 at 11:00 UTC</strong> </h3>\n\n\n\n<p>Right after the livestream, there will be a &#8216;drop-in&#8217; translation sprint on Zoom video-conferencing, open to all. You can join and hang out virtually with your Polyglots friends from all around the world and translate WordPress in your own language! <a href=\"https://www.meetup.com/Portsmouth-WordPress-Meetup/events/280823032/\">RSVP for the session now and get joining links!</a> </p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://lh4.googleusercontent.com/r2rVEDkb39h02LiBg2GdayDk1LpZi6kxZnv1MRzT9h6pgSQE9FMBmyx_kJUA-Pjyy1KD__YlzLYvd1P53o1UIxTEfb0fmQnHm40UU23Wb1slXm-ajdGNP5qOyzHyTI07NBCM-mwY=s0\" alt=\"\" /></figure>\n\n\n\n<h2>Check out the other exciting global events</h2>\n\n\n\n<h3><strong>Sunday, September 19, 2021 <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?iso=20210919T1200\">12:00 UTC</a></strong></h3>\n\n\n\n<p><a rel=\"noreferrer noopener\" href=\"https://www.youtube.com/watch?v=M7UtEKIp2FY\" target=\"_blank\"><strong>Panel on Polyglots Tools</strong></a><a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?iso=20210919T1200\"> <br></a>Join <a href=\"https://profiles.wordpress.org/amieiro/\">Jesús Amieiro</a>, <a href=\"https://profiles.wordpress.org/psmits1567/\">Peter Smits</a>, <a href=\"https://profiles.wordpress.org/vladytimy/\">Vlad Timotei</a>, and <a href=\"https://profiles.wordpress.org/vibgyj/\">Vibgy Joseph</a> to talk about the tools they’ve contributed to or developed to help translators and translation editors.</p>\n\n\n\n<h3><strong>Tuesday, September 21, 2021 <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?iso=20210921T1100\">11:00 UTC</a></strong></h3>\n\n\n\n<p><a href=\"https://www.youtube.com/watch?v=0Ps8byYIwLs\"><strong>Panel on Open Source Translation Communities</strong></a> (YouTube link &#8211; opens in a new tab)<a rel=\"noreferrer noopener\" href=\"https://www.timeanddate.com/worldclock/fixedtime.html?iso=20210921T1100\" target=\"_blank\"><br></a>Join <a href=\"https://profiles.wordpress.org/vanillalounge/\">Zé Fontainhas</a> (WordPress), <a href=\"https://profiles.wordpress.org/tokyobiyori/\">Ali Darwich</a> (WordPress), <a href=\"https://www.linkedin.com/in/mstanke?originalSubdomain=cz\">Michal Stanke</a> (Mozilla), and <a href=\"https://www.linkedin.com/in/satomi-tsujita/?originalSubdomain=jp\">Satomi Tsujita</a> (Hyperledger Fabric) to learn about nurturing translation communities.</p>\n\n\n\n<h3><strong>Thursday, September 30, 2021 <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?iso=20210930T1600\">16:00 UTC</a></strong></h3>\n\n\n\n<p><a href=\"https://www.youtube.com/watch?v=qyQUaiK19js\"><strong>Finale Event – Why do you translate?</strong></a> <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?iso=20210930T1600\"><br></a>Our finale event for 2021 with emcee <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> and a panel from the WordPress Translation Day Team. It will feature highlights from some of the local and global events during the month and a selection of results. Some of the nominees for this year&#8217;s polyglots appreciation will join the livestream to share their stories.</p>\n\n\n\n<p>The livestream will be followed by an after party celebration for anyone who has taken part in the event or is a WordPress polyglot. <a href=\"https://www.meetup.com/Portsmouth-WordPress-Meetup/events/280823393/\">Book now</a> for the session on Zoom.</p>\n\n\n\n<h2>Ideas on how to get involved this September</h2>\n\n\n\n<p>There&#8217;s lots of ways to take part &#8211; discover this <a href=\"https://wptranslationday.org/blog/ways-to-participate/\">list of ideas</a>.</p>\n\n\n\n<p>You can also nominate <a href=\"https://wptranslationday.org/blog/call-for-nominations-polyglots-appreciation/\">translation contributors</a> to be featured in this year&#8217;s celebrations.</p>\n\n\n\n<h2>Help us spread the word about #WPTranslationDay</h2>\n\n\n\n<ul><li>Share what you are translating using the #WPTranslationDay hashtag on: <a href=\"https://www.facebook.com/WPTranslationDay/\">Facebook</a>,<a href=\"https://twitter.com/TranslateWP\"> Twitter</a>, <a href=\"https://www.instagram.com/wptranslationday/\">Instagram</a>, and <a href=\"https://www.linkedin.com/company/wptranslationday/\">LinkedIn</a>! </li><li>You can also find images and translator badges in our <a href=\"https://wptranslationday.org/wptd-2021/media-kit/\">Media Kit</a> to share during September.</li></ul>\n\n\n\n<p>For more information on the 2021 WordPress Translation Day celebrations, visit <a href=\"https://wptranslationday.org/\">the WordPress Translation Day website</a>.</p>\n\n\n\n<p></p>\n\n\n\n<p><em>Props to <a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>, <a href=\'https://profiles.wordpress.org/harishanker/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>harishanker</a>, <a href=\'https://profiles.wordpress.org/lmurillom/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>lmurillom</a>, <a href=\'https://profiles.wordpress.org/oglekler/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>oglekler</a>, <a href=\'https://profiles.wordpress.org/meher/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meher</a>, <a href=\'https://profiles.wordpress.org/nalininonstopnewsuk/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nalininonstopnewsuk</a>, <a href=\'https://profiles.wordpress.org/evarlese/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>evarlese</a></em> for contributing to this story.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"11215\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 5.8.1 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2021/09/wordpress-5-8-1-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Sep 2021 03:11:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11190\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:363:\"WordPress 5.8.1 is now available! This security and maintenance release features 60 bug fixes in addition to 3 security fixes. Because this is a security release, it is recommended that you update your sites immediately. All versions since WordPress 5.4 have also been updated. WordPress 5.8.1 is a short-cycle security and maintenance release. The next [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Jonathan Desrosiers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8900:\"\n<p>WordPress 5.8.1 is now available!</p>\n\n\n\n<p>This security and maintenance release features <a href=\"https://core.trac.wordpress.org/query?milestone=5.8.1&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">60 bug</a> <a href=\"https://github.com/WordPress/gutenberg/pull/34393\">fixes</a> in addition to 3 security fixes. Because this is a <strong>security release</strong>, it is recommended that you update your sites immediately. All versions since WordPress 5.4 have also been updated.</p>\n\n\n\n<p>WordPress 5.8.1 is a short-cycle security and maintenance release. The next major release will be version <a href=\"https://make.wordpress.org/core/5-9/\">5.9</a>.</p>\n\n\n\n<p>You can download WordPress 5.8.1 by downloading from WordPress.org, or visit your Dashboard → Updates and click Update Now.</p>\n\n\n\n<p>If you have sites that support automatic background updates, they’ve already started the update process.</p>\n\n\n\n<h3><strong>Security Updates</strong></h3>\n\n\n\n<p>3 security issues affect WordPress versions between 5.4 and 5.8. If you haven’t yet updated to 5.8, all WordPress versions since 5.4 have also been updated to fix the following security issues:</p>\n\n\n\n<ul><li>Props <a href=\'https://profiles.wordpress.org/mdawaffe/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mdawaffe</a>, member of the WordPress Security Team for their work fixing a data exposure vulnerability within the REST API.</li><li>Props to Michał Bentkowski of Securitum for reporting a XSS vulnerability in the block editor.</li><li>The Lodash library has been updated to version 4.17.21 in each branch to incorporate upstream security fixes.</li></ul>\n\n\n\n<p>In addition to these issues, the security team would like to thank the following people for reporting vulnerabilities during the WordPress 5.8 beta testing period, allowing them to be fixed prior to release:</p>\n\n\n\n<ul><li>Props <a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://evanricafort.com/\">Evan Ricafort</a>&nbsp;for reporting a XSS vulnerability in the block editor discovered during the 5.8 release’s beta period.</li><li>Props <a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://profiles.wordpress.org/stevehenty/\">Steve Henty</a>&nbsp;for reporting a privilege escalation issue in the block editor.</li></ul>\n\n\n\n<p>Thank you to all of the reporters for <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">privately disclosing the vulnerabilities</a>. This gave the WordPress security team time to fix the vulnerabilities before WordPress sites could be attacked.</p>\n\n\n\n<p>For more information, browse the <a href=\"https://core.trac.wordpress.org/query?milestone=5.8.1&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">full list of changes</a> on Trac, or check out the <a href=\"https://wordpress.org/support/wordpress-version/version-5-8-1/\">version 5.8.1 HelpHub documentation page</a>.</p>\n\n\n\n<h2>Thanks and props!</h2>\n\n\n\n<p>The 5.8.1 release was led by <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> and <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a>.</p>\n\n\n\n<p>In addition to the security researchers and release squad members mentioned above, thank you to everyone who helped make WordPress 5.8.1 happen:</p>\n\n\n\n<a href=\"https://profiles.wordpress.org/2linctools/\">2linctools</a>, <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zielinski</a>, <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a>, <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a>, <a href=\"https://profiles.wordpress.org/alexstine/\">alexstine</a>, <a href=\"https://profiles.wordpress.org/algala/\">AlGala</a>, <a href=\"https://profiles.wordpress.org/oandregal/\">André</a>, <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a>, <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a>, <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a>, <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a>, <a href=\"https://profiles.wordpress.org/ribaricplusplus/\">Bruno Ribaric</a>, <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/daisyo/\">Daisy Olsen</a>, <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a>, <a href=\"https://profiles.wordpress.org/dariak/\">Daria</a>, <a href=\"https://profiles.wordpress.org/davidanderson/\">David Anderson</a>, <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a>, <a href=\"https://profiles.wordpress.org/enchiridion/\">Enchiridion</a>, <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a>, <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a>, <a href=\"https://profiles.wordpress.org/ianmjones/\">ianmjones</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jblz/\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joen/\">Joen A.</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a>, <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a>, <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a>, <a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a>, <a href=\"https://profiles.wordpress.org/gwwar/\">Kerry Liu</a>, <a href=\"https://profiles.wordpress.org/kevinfodness/\">Kevin Fodness</a>, <a href=\"https://profiles.wordpress.org/mkaz/\">Marcus Kazmierczak</a>, <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a>, <a href=\"https://profiles.wordpress.org/mhuntdesign/\">Matt</a>, <a href=\"https://profiles.wordpress.org/mdawaffe/\">Michael Adams (mdawaffe)</a>, <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/moch11/\">moch11</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a>, <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/walbo/\">Petter Walbø Johnsgård</a>, <a href=\"https://profiles.wordpress.org/radixweb/\">Radixweb</a>, <a href=\"https://profiles.wordpress.org/rtm909/\">Rahul Mehta</a>, <a href=\"https://profiles.wordpress.org/ramonopoly/\">ramonopoly</a>, <a href=\"https://profiles.wordpress.org/ravipatel/\">ravipatel</a>, <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a>, <a href=\"https://profiles.wordpress.org/kreppar/\">Rodrigo Arias</a>, <a href=\"https://profiles.wordpress.org/sanketchodavadiya/\">Sanket Chodavadiya</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stevehenty/\">Steve Henty</a>, <a href=\"https://profiles.wordpress.org/terraling/\">terraling</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a>, <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a>, <a href=\"https://profiles.wordpress.org/hellofromTonya/\">Tonya Mork</a>, <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/vladytimy/\">Vlad T</a>, <a href=\"https://profiles.wordpress.org/wb1234/\">wb1234</a>, and <a href=\"https://profiles.wordpress.org/wfmattr/\">WFMattR</a>.\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"11190\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"The Month in WordPress: August 2021\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2021/09/the-month-in-wordpress-august-2021/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 03 Sep 2021 14:00:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:18:\"month in wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11176\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:338:\"I really believe in WordPress’ mission to democratize publishing. And I, for one, will never stop learning about what gives people more access to the software, and what makes the software more usable, and especially how we can combine usability with accessibility in a way that puts form and function on a level playing field. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Hari Shanker R\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:16142:\"\n<blockquote class=\"wp-block-quote\"><p>I really believe in WordPress’ mission to democratize publishing. And I, for one, will never stop learning about what gives people more access to the software, and what makes the software more usable, and especially how we can combine usability with accessibility in a way that puts form and function on a level playing field.<br></p></blockquote>\n\n\n\n<p>That was <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden</a> on the “<a href=\"https://wordpress.org/news/2021/08/episode-14-the-art-and-science-of-accessibility/\">The Art and Science of Accessibility</a>” episode of the <a href=\"https://wordpress.org/news/podcast/\">WP Briefing Podcast</a>, talking about accessibility and exploring how it applies to the WordPress open source software. You will find that many of our updates from August 2021 tie in closely with the core principles of access, accessibility, and usability. Read on to find out more!</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Join the 2021 WordPress Translation Day Celebrations in September</h2>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://wptranslationday.org/\" target=\"_blank\" rel=\"noopener\"><img loading=\"lazy\" width=\"632\" height=\"395\" src=\"https://i0.wp.com/wordpress.org/news/files/2021/09/image.jpeg?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C395&#038;ssl=1\" alt=\"WordPress Translation Day 2021 September 1 - 30, 2021\" class=\"wp-image-11177\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2021/09/image.jpeg?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C640&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2021/09/image.jpeg?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C188&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2021/09/image.jpeg?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C480&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2021/09/image.jpeg?w=1440&amp;ssl=1 1440w, https://i0.wp.com/wordpress.org/news/files/2021/09/image.jpeg?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></a></figure>\n\n\n\n<p>Join WordPress contributors around the world on <a href=\"https://wptranslationday.org/\">WordPress Translation Day celebrations</a> for the entire month of September! The sixth edition of #WPTranslationDay &#8211; which is a cross-team effort led by the Polyglots and Marketing Teams, has a host of fun programs aimed at helping WordPress speak all languages of the world. Want to join the fun? Here’s how.</p>\n\n\n\n<ul><li><a href=\"https://wptranslationday.org/wptd-2021/local-events/\">Join your local translation event</a> and collaborate on efforts to translate WordPress! Can’t find a <a href=\"https://wptranslationday.org/wptd-2021/local-events/\">local event in your area</a>? Why don’t you <a href=\"https://make.wordpress.org/polyglots/2021/08/11/call-for-local-event-organizers-wordpress-translation-day-2021/\">organize one on your own</a>?</li><li>Join <a href=\"https://wptranslationday.org/wptd-2021/global-events/\">one of our global events</a> from September 17-30!<em> </em>We have exciting sessions on <a href=\"https://wptranslationday.org/wptd-2021/global-events/\">polyglots tools and open source translation communities</a>, to name a few.</li><li>You can help<a href=\"https://translate.wordpress.org/\"> translate WordPress to your own language</a>, in your own time, this month! <a href=\"https://make.wordpress.org/polyglots/handbook/translating/first-steps/\">Here’s how!</a></li><li>Share what you are translating using the #WPTranslationDay hashtag on social media, to build excitement around the event! Don’t forget to amplify posts about the event on <a href=\"https://www.facebook.com/WPTranslationDay/\">Facebook</a>, <a href=\"https://twitter.com/TranslateWP\">Twitter</a>, <a href=\"https://www.instagram.com/wptranslationday/\">Instagram</a>, and <a href=\"https://www.linkedin.com/company/wptranslationday/\">LinkedIn</a>!</li></ul>\n\n\n\n<p>&nbsp;For more information, check out <a href=\"https://wptranslationday.org/\">the translation day website</a> and the <a href=\"https://make.wordpress.org/polylgots/tag/wptranslationday/\">Polyglots blog</a>.</p>\n\n\n\n<h2>WordPress Release Updates</h2>\n\n\n\n<p>The Core Team <a href=\"https://make.wordpress.org/core/2021/08/13/preliminary-road-to-5-9/\">commenced work</a> on the next major release &#8211; WordPress 5.9. The team aims to ship some cool features such as intrinsic web design to blocks, improved block patterns, navigation menus, better design tools, edit flows for block themes, and a new interface for theme.json. Check out the <a href=\"https://make.wordpress.org/core/5-9/\">WordPress 5.9 development cycle</a> to know more. This release is set to go out in December 2021. The team is also <a href=\"https://make.wordpress.org/core/2021/08/24/wordpress-5-8-x-release-team-and-5-8-1-schedule/\">working on shipping a minor release WordPress 5.8.1</a> –– its <a href=\"https://make.wordpress.org/core/2021/09/01/wordpress-5-8-1-rc-1/\">release candidate</a> is already out and the final release will launch on September 8.</p>\n\n\n\n<p>Want to contribute to WordPress core? Join the <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> channel, follow the <a href=\"https://make.wordpress.org/core/\">Core Team blog</a>, and check out the <a href=\"https://make.wordpress.org/core/handbook/\">team handbook</a>. Don’t miss the Core Team chats on Wednesdays at <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?hour=5&amp;min=00&amp;sec=0\">5 AM</a> and <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?hour=20&amp;min=00&amp;sec=0\">8 PM</a> UTC. You can also help <a href=\"https://translate.wordpress.org/\">translate WordPress</a> to your local language &#8211; and what better time to do it, than in September, <a href=\"https://wptranslationday.org/\">during the translation month celebrations</a>? Another fun way to contribute would be to <a href=\"https://make.wordpress.org/marketing/2021/08/11/share-about-wordpress-5-8-on-social-media/\">share about WordPress 5.8 on social media</a>!</p>\n\n\n\n<h2>Say Hello to Gutenberg Versions 11.2 and 11.3</h2>\n\n\n\n<p>We launched Gutenberg <a href=\"https://make.wordpress.org/core/2021/08/05/whats-new-in-gutenberg-11-2-0-4-august/\">version 11.2</a> and <a href=\"https://make.wordpress.org/core/2021/08/18/whats-new-in-gutenberg-11-3-18-august/\">version 11.3</a> this month. <a href=\"https://make.wordpress.org/core/2021/08/05/whats-new-in-gutenberg-11-2-0-4-august/\">Version 11.2</a> adds customizing/color options to the search block, a flex layout for the group block, and a new button for creating posts as part of the publishing flow. <a href=\"https://make.wordpress.org/core/2021/08/18/whats-new-in-gutenberg-11-3-18-august/\">Version 11.3</a> offers a new dimensions panel (replacing the spacing panel) with more styling options, dimensions control for the feature image block, and significant performance improvements for block inserters.<br></p>\n\n\n\n<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/\">the Core Team blog</a>, contribute to <a href=\"https://github.com/WordPress/gutenberg/\">Gutenberg on GitHub</a>, and join the <a href=\"https://wordpress.slack.com/archives/C02QB2JS7\">#core-editor</a> channel in the <a href=\"https://make.wordpress.org/chat/\">Make WordPress Slack</a>. The “<a href=\"https://make.wordpress.org/core/2021/07/21/whats-next-in-gutenberg-site-editing-status-check-late-july-august-2021/\">What’s next in Gutenberg</a>” post offers more details on the latest updates.&nbsp;</p>\n\n\n\n<h2>Get Excited about WordCamp US 2021</h2>\n\n\n\n<p>The biggest WordCamp in North America &#8211; <a href=\"https://us.wordcamp.org/2021/\">WordCamp US 2021-</a> is barely a month away. <a href=\"https://us.wordcamp.org/2021/tickets/\">Get your (free) tickets</a>, if you haven’t already! The organizing team has opened up calls for <a href=\"https://us.wordcamp.org/2021/calling-all-musicians/\">musicians</a>, <a href=\"https://us.wordcamp.org/2021/call-for-contributor-stories/\">contributor stories</a>, and <a href=\"https://us.wordcamp.org/2021/call-for-media-partners/\">media partners</a>. Check out <a href=\"https://us.wordcamp.org/2021/\">the event website</a> and follow the event on <a href=\"https://twitter.com/wordcampus\">Twitter</a>, <a href=\"https://www.instagram.com/wordcampus/\">Instagram</a>, and <a href=\"https://www.facebook.com/WordCampUSA\">Facebook</a> to stay updated on all that #WCUS news.</p>\n\n\n\n<h2>Important Announcements/Updates</h2>\n\n\n\n<ul><li>Support for the Classic Editor plugin <a href=\"https://wordpress.org/news/2021/08/an-update-on-the-classic-editor-plugin/\">will be extended for a full year until 2022</a>!</li><li>The Themes Team published a <a href=\"https://make.wordpress.org/themes/2021/08/06/summary-of-the-request-for-feedback-on-requirement-changes/\">feedback summary</a> on the <a href=\"https://make.wordpress.org/themes/2021/07/20/discussion-request-for-feedback-on-requirement-changes/\">proposed requirement changes for WordPress theme review</a>, and will soon be updating the handbook and review tools. You will find more context in their <a href=\"https://make.wordpress.org/themes/2021/08/10/meeting-notes-themes-team-and-theme-authors-regarding-requirements-change/\">meeting notes</a>.</li><li>The Plugins Team <a href=\"https://make.wordpress.org/plugins/2021/08/27/inaccurate-stats-have-been-corrected/\">corrected inaccurate plugin statistics</a> in the plugin directory.</li><li>Check out the <a href=\"https://make.wordpress.org/test/2021/08/17/fse-program-theme-design-survey-results/\">results of the FSE Theme Design (theme.json) survey</a>!</li></ul>\n\n\n\n<h2>Feedback/Testing Requests from Contributor Teams</h2>\n\n\n\n<ul><li>The Testing Team is requesting testing help for a <a href=\"https://make.wordpress.org/test/2021/08/30/week-in-test-30-aug-2021/\">few tickets and patches in WordPress</a>. The team is also looking for volunteers to <a href=\"https://make.wordpress.org/test/2021/08/20/call-for-volunteeers-audit-and-update-testing-instructions-across-the-make-sites/\">audit and update Core testing instructions </a>across different Make sites.</li><li>The Community Team shared a <a href=\"https://make.wordpress.org/community/2021/09/01/proposal-centralized-global-do_action-charity-hackathons/\">proposal on planning online-only recurring global do_action charity hackathons</a>. Share your feedback by September 24.</li><li>The Training Team is also exploring the possibility of adding <a href=\"https://make.wordpress.org/training/2021/08/10/proposal-learner-achievements-on-profiles/\">learner achievements (on learn.wordpress.org) on WP Profiles</a> and is requesting feedback from the community.</li><li>Help the Marketing Team’s outreach research by filling out <a href=\"https://forms.gle/4QFhX8fcNxKAfK8y5\">this 2 question survey</a> on how you search for WordPress release information. If you have any favorite features from the latest release (WordPress 5.8) let the team know by completing this <a href=\"https://docs.google.com/forms/d/e/1FAIpQLSd_2llymf79-h5sgTiprz7Kw4Gr4cbDHh-AAdAQfiArXlHksg/viewform\">short form</a>.</li><li>Version 18.1 of WordPress for <a href=\"https://make.wordpress.org/mobile/2021/08/23/call-for-testing-wordpress-for-ios-18-1/\">iOS</a> and <a href=\"https://make.wordpress.org/mobile/2021/08/23/call-for-testing-wordpress-for-android-18-1/\">Android</a> are now available for testing!</li></ul>\n\n\n\n<h2>WordPress Event Updates</h2>\n\n\n\n<ul><li><a href=\"https://floripa.wordcamp.org/2021/\">WordCamp Florianopolis 2021</a> was held on August 11-12, 2021. The event, which sold 390 tickets, had 11 speakers and 4 sponsors. Catch the <a href=\"https://www.youtube.com/channel/UCh1CeGfuDRH-o13xh7kpgUQ\">event recap on YouTube</a>!</li><li><a href=\"https://galicia.wordcamp.org/2021/\">WordCamp Galicia 2021</a> is being held from September 30 &#8211; October 2, 2021! </li><li><a href=\"https://doaction.org/event/karnataka-2021/\">do_action Karnataka 2021</a> was held from August 7-15, 2021. Check out <a href=\"https://wordpressfoundation.org/2021/do_action-karnataka-2021-a-report/\">the recap</a>!</li><li>The Core Team organized a <a href=\"https://make.wordpress.org/core/2021/08/25/hallway-hangout-summary-compare-and-contrast-the-navigation-screens/\">hallway hangout</a> to compare the ‘experimental’ Gutenberg navigation feature with the built-in core feature. The team decided to wait until feature parity with core nav menus, to move the feature from experiments to the main plugin.</li><li>The Diverse Speakers Training group (<a href=\"https://make.wordpress.org/community/tag/wpdiversity/\">#WPDiversity</a>) of the Community Team held their first “<a href=\"https://make.wordpress.org/community/2021/09/02/report-diverse-speaker-workshops-august-2021/\">Allyship for WordPress Event Organizers</a>” workshop on August 19, 2021. The event had 13 attendees from six countries who reported a 52{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9} increase in preparedness to help create inclusive WordPress events. <a href=\"https://make.wordpress.org/community/tag/wpdiversityworkshops/\">Stay tuned</a> for their next workshop in November!</li></ul>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading</h2>\n\n\n\n<ul><li>Don’t miss this blog post on <a href=\"https://wordpress.org/news/2021/08/widgets-in-wordpress-5-8-and-beyond/\">Widgets in WordPress 5.8 and beyond</a>!</li><li>The Full Site Editing (FSE) Outreach program wrapped up its ninth challenge –– <a href=\"https://make.wordpress.org/test/2021/08/11/fse-program-testing-call-9-handling-highered-headers/\">Handling HigherEd Headers</a>, on September 1. Keep an eye out for <a href=\"https://make.wordpress.org/test/tag/fse-outreach-program/\">test results and future testing call announcements</a>!</li><li>The Test Team is <a href=\"https://make.wordpress.org/test/2021/08/19/test-team-chat-summary-17-august-2021/\">attempting to modernize PHPUnit tests</a> for WordPress.</li><li>The Accessibility Team is testing the <a href=\"https://make.wordpress.org/accessibility/2021/08/20/accessibility-team-meeting-notes-august-20-2021/\">navigation block</a> for accessibility feedback.</li><li>The Docs Team <a href=\"https://make.wordpress.org/docs/2021/08/31/summary-of-docs-team-meeting-aug-24-2021/\">launched a new repository</a> for tracking issues with WordPress documentation: <a href=\"https://github.com/WordPress/Documentation-Issue-Tracker\">https://github.com/WordPress/Documentation-Issue-Tracker</a></li><li>The Training Team <a href=\"https://make.wordpress.org/training/2021/08/17/proposal-brand-guidelines-for-learn-wordpress-content/#comment-3130\">finalized</a> brand <a href=\"https://make.wordpress.org/training/2021/08/17/proposal-brand-guidelines-for-learn-wordpress-content/\">guidelines</a> for <a href=\"https://learn.wordpress.org\">learn.wordpress.org</a>. The team is also working on setting up <a href=\"https://make.wordpress.org/training/2021/08/12/wordpress-101-microcourses-proposal/\">Micro courses for Learn</a>.</li><li>The Openverse Team is <a href=\"https://make.wordpress.org/openverse/2021/08/16/multi-stage-docker-builds-in-the-openverse-api/\">exploring Multistage docker builds</a> as a solution to better set up waveforms for audio search results in the Openverse tool.&nbsp;</li></ul>\n\n\n\n<p><em>Have a story that we should include in the next “Month in WordPress” post? Please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it using this form</em></a><em>.&nbsp;</em></p>\n\n\n\n<p><em>The following folks contributed to August’s Month in WordPress:&nbsp; <a href=\'https://profiles.wordpress.org/evarlese/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>evarlese</a> <a href=\'https://profiles.wordpress.org/meher/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meher</a> <em><a href=\'https://profiles.wordpress.org/nao/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nao</a></em> <a href=\'https://profiles.wordpress.org/jillbinder/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jillbinder</a></em> <em><a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a></em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"11176\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"An Update on the Classic Editor Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://wordpress.org/news/2021/08/an-update-on-the-classic-editor-plugin/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 25 Aug 2021 16:51:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11149\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:333:\"Before the release of WordPress 5.0 in 2018, the Classic Editor plugin was published to help ease the transition to the new block editor. At the time, we promised to support the plugin through 2021 and adjust if needed as the deadline got closer. After discussing this with Matt, it&#8217;s clear that continuing to support [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1583:\"\n<p>Before the release of WordPress 5.0 in 2018, the <a href=\"https://wordpress.org/plugins/classic-editor/\">Classic Editor plugin</a> was published to help ease the transition to the new block editor. At the time, we promised to support the plugin through 2021 and adjust if needed as the deadline got closer. After discussing this with Matt, it&#8217;s clear that continuing to support the plugin through 2022 is the right call for the project as well as the community.</p>\n\n\n\n<p>Still, if you’ve been putting off using the block editor, this is an excellent time to give it another shot. Since it first appeared in 2018, hundreds of WordPress contributors have made a lot of updates based on user feedback. You will be pleasantly surprised at how far it’s come!</p>\n\n\n\n<p>Big thanks to everyone who has been working on WordPress, Gutenberg, and the Classic Editor plugin. And thank you to every WordPress user and tester who has provided the feedback we need to make the software even better.</p>\n\n\n\n<p>~ Josepha</p>\n\n\n\n<p><em>Returning to the block editor for the first time in a long time? You can give feedback early in the process by <a href=\"https://make.wordpress.org/test/handbook/full-site-editing-outreach-experiment/\">joining the outreach program</a>! Looking at it for the first time ever? <a href=\"https://learn.wordpress.org/workshops/?series=24&amp;topic=&amp;language=&amp;captions=\">Get your bearings with some workshops</a> or <a href=\"https://wordpress.org/support/article/wordpress-editor/#how-does-the-block-editor-work\">check out this demo</a>!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"11149\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:58:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"WP Briefing: Episode 15: A Very WordPress Blooper\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2021/08/episode-15-a-very-wordpress-blooper/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Aug 2021 22:14:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=11146\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:130:\"Ever wonder what it\'s like behind the scenes of WP Briefing? Listen in on this episode for a little levity and Josepha\'s bloopers.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:65:\"https://wordpress.org/news/files/2021/08/WP-Briefing-Bloopers.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chloe Bringmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8885:\"\n<p>Ever wonder what it&#8217;s like behind the scenes of WP Briefing? Listen in on this episode for a little levity and Josepha&#8217;s bloopers.</p>\n\n\n\n<p><em><strong>Have a question you’d like answered? You can submit them to&nbsp;<a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2>Credits</h2>\n\n\n\n<ul><li>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a></li><li>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li><li>Production:&nbsp;<a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a></li><li>Song: Fearless First by Kevin MacLeod</li></ul>\n\n\n\n<h2>Transcript</h2>\n\n\n\n<span id=\"more-11146\"></span>\n\n\n\n<p>[contemporary intro music]</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>00:10</p>\n\n\n\n<p>Hello, everyone, and welcome to a bonus briefing. Normally I talk to you about WordPress and stuff, but I figured that we all need a little levity in our lives right now. So today&#8217;s episode is actually just a series of bloopers and mistakes that I&#8217;ve made while recording. When I was preparing for this podcast, no one mentioned the deep weirdness of standing alone in your closet talking to yourself, nor did they realize just how lost I can get in the surpassingly, lovely lyricism of a lilting line, and then just have no idea what I&#8217;m supposed to be reading in the script that I wrote for myself. So, my dear friends, I hope these bring you a little laugh. And if we&#8217;ve got any luck at all, you may also hear me singing to myself, my computer, or about how terrible my talking just was. Here we go!</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>01:12</p>\n\n\n\n<p>Hello, everyone, and welcome to a bonus briefing. I know I wasn&#8217;t going to sit boop, boop.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>01:21</p>\n\n\n\n<p>I messed up the thing where I&#8217;m talking about how I mess up, of course. I&#8217;m going to do it one more time, and you can choose whatever is a reasonable thing there.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>01:33</p>\n\n\n\n<p>Because we had such a lengthy WP Briefing, WordPress, I’m going to just start that over again. Sorry, everyone.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>01:42</p>\n\n\n\n<p>My friends. Oh, no. I don&#8217;t know how I end my own show. How do I end my own show? There we go. Sorry.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>01:52</p>\n\n\n\n<p>That was a weird way to say that. I&#8217;m going to start over again from the transition. And then we&#8217;re just going to go straight through to the end. Maybe.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>02:03</p>\n\n\n\n<p>The names that&#8230; I sound weird. I sound like I don&#8217;t know what my words are. And I said I wrote the words. I said I was all going to go in one go, and I&#8217;m a liar today. Okay, here we go. For realsies!</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>02:16</p>\n\n\n\n<p>Final first last take. Here we go. Sorry, I made myself laugh.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>02:22</p>\n\n\n\n<p>Matt Mullenweg. And, and I, I&#8217;m also in that group. I don&#8217;t know why I said that like it was a surprise. I have me too. I&#8217;m also in there.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>02:33</p>\n\n\n\n<p>Ugh, I ran out of air. For reasons, it was a short sentence. I don&#8217;t know why I ran out of air.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>02:43</p>\n\n\n\n<p>Coming out on April 14. That&#8217;s not true. It&#8217;s April 13. Right?</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>02:50</p>\n\n\n\n<p>On the form below to share the. Pfft &#8211; what are the things!&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>02:58</p>\n\n\n\n<p>This is WP Briefing episode seven, no title because I don&#8217;t know what to call it because I gave it a title already. I gave it two titles, and then couldn&#8217;t remember why I gave it those titles. So I&#8217;ll come up with a title before we publish it. But I also have no idea what it is. I&#8217;m going to ask for help. </p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>03:17</p>\n\n\n\n<p>Testing project since I have too many commas, and I really believed in my comma when I said it. </p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>03:24</p>\n\n\n\n<p>Prior to Gutenberg&#8230; pfft. Open source software like WordPress. I was going to smash that sentence into half a sentence. I was going to say when you know what you&#8217;re workussing on you have a solution which is not my friends of thing. So, I am just going to say the sentence again. </p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>03:47</p>\n\n\n\n<p>I was sitting over here wringing my hands for some reason during that entire list. And so if you can hear me wringing my hands, which would be a whole new height of anxiety for anyone, you let me know, and I will rerecord that also.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>04:00</p>\n\n\n\n<p>Get a concept of. Nope, this is a lie. Get a concept of where to get your tickets is the silliest thing. I&#8217;m starting over from the small list of big things. Also, because I got too excited about how big my list is. I am going to get that excited again. But I will try not to shout about it.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>04:17</p>\n\n\n\n<p>&#8220;Humming intro song&#8221; Dun dun dun dun dun.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>04:23</p>\n\n\n\n<p>Sorry, I had to scroll up, and I try not to scroll up when I&#8217;m talking in case maybe my whole computer turns into a microphone. Sorry, I&#8217;m just going to keep going because this has been a fine take so far.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>04:34</p>\n\n\n\n<p>Mercy! I have words that I can say with my mouth. They aren&#8217;t these words today. It seems.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>04:45</p>\n\n\n\n<p>Build up to&#8230; Oh my goodness. My stomach grumbled, and this microphone, I know,&nbsp; picked it up. And so I&#8217;m going to redo bullet two so that we don&#8217;t just have a small monster under the bed in the middle of the podcast.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>05:03</p>\n\n\n\n<p>Also, like DEI, I feel s—Eh &#8211; maybe I should say, DEI, somewhere in there, so it&#8217;s clear for people cause I&#8217;m talking to people and not actually a screen. </p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>05:17</p>\n\n\n\n<p>Before I joined the WordPress project, the majority of my work with accessibility was in the context of the digital divide. Now, when talking about the digital divide, there are three concepts around quote-unquote, getting things to people. And those concepts are&#8230; I guess I could say the thing, hold on one second, I can do it. I feel like I&#8217;m chopping up my words like I&#8217;m not really breathing very well. So I apologize. But here we go again.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>05:58</p>\n\n\n\n<p>Don&#8217;t include that one. Sorry, I&#8217;m so nervous about this episode that, like, my mouth is getting dry, and I worry that you can hear it, and it drives me nuts every time I hear podcasters with a dry mouth, and you can just like hear it clicking and always stresses me out. I&#8217;m like, someone should give that poor thing a drink of water. And I just know I&#8217;m going to feel that way about myself later. And so I&#8217;m trying to stay hydrated, but it also means that I have to stop every two paragraphs and take a drink of water. I apologize for that interlude. I am about to start again, at my next section, which is like, halfway through.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>06:39</p>\n\n\n\n<p>Also, I learned that you can hear me swallowing my water with this microphone because it is a spectacular microphone. And so, I apologize for that as well. All right. Here I go. I&#8217;m going to do it all in one take. Watch me.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>06:56</p>\n\n\n\n<p>But I also have questions, especially about how to move everything forward. Mm-hmm. Whoops. I put especially in the wrong spot. But I also thought&#8230;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>07:10</p>\n\n\n\n<p> Ta da, we did it. Gosh, that&#8217;s a short one. </p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>07:16</p>\n\n\n\n<p>I did it. Where&#8217;s my where&#8217;s my turning offing button.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>07:22</p>\n\n\n\n<p>Tada! And scene and done.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"11146\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Widgets in WordPress 5.8 and Beyond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2021/08/widgets-in-wordpress-5-8-and-beyond/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Aug 2021 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Features\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11115\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:367:\"Copy and Design by @critterverse WordPress 5.8 brings the power of Gutenberg blocks to widget areas — which means the highly customizable layout and styling options bring you closer to a&#160;WYSIWYG editing experience. I made a test site based on the oldie-but-goodie Twenty Sixteen theme, with three separate widget areas. In this post, I’ll highlight [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:3:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2021/08/classic-widgets.mov\";s:6:\"length\";s:7:\"6475399\";s:4:\"type\";s:15:\"video/quicktime\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2021/08/block-widgets-1.mov\";s:6:\"length\";s:8:\"23931847\";s:4:\"type\";s:15:\"video/quicktime\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:58:\"https://wordpress.org/news/files/2021/08/custom-html-1.mov\";s:6:\"length\";s:8:\"13767042\";s:4:\"type\";s:15:\"video/quicktime\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chloe Bringmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7682:\"\n<p><strong><em>Copy and Design by <a href=\'https://profiles.wordpress.org/critterverse/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>critterverse</a> </em></strong></p>\n\n\n\n<p>WordPress 5.8 brings the power of Gutenberg blocks to widget areas — which means the highly customizable layout and styling options bring you closer to a&nbsp;WYSIWYG editing experience. I made a test site based on the oldie-but-goodie <a href=\"https://wordpress.org/themes/twentysixteen/\">Twenty Sixteen theme</a>, with three separate widget areas. In this post, I’ll highlight a few cool things that are now possible to do with your widgets and where things may be heading next.</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-full\"><a href=\"https://i0.wp.com/wordpress.org/news/files/2021/08/site-long-1x.png?ssl=1\"><img loading=\"lazy\" width=\"632\" height=\"1130\" src=\"https://i0.wp.com/wordpress.org/news/files/2021/08/site-long-1x.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C1130&#038;ssl=1\" alt=\"A zoomed-out view of a single post with one sidebar widget area and two footer widget areas. The site content is about Marine Park Salt Marsh. A List View of blocks floating next to each widget area shows how the design is constructed.\" class=\"wp-image-11116\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2021/08/site-long-1x.png?w=2183&amp;ssl=1 2183w, https://i0.wp.com/wordpress.org/news/files/2021/08/site-long-1x.png?resize=168{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C300&amp;ssl=1 168w, https://i0.wp.com/wordpress.org/news/files/2021/08/site-long-1x.png?resize=573{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C1024&amp;ssl=1 573w, https://i0.wp.com/wordpress.org/news/files/2021/08/site-long-1x.png?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C1373&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2021/08/site-long-1x.png?resize=859{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C1536&amp;ssl=1 859w, https://i0.wp.com/wordpress.org/news/files/2021/08/site-long-1x.png?resize=1145{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C2048&amp;ssl=1 1145w, https://i0.wp.com/wordpress.org/news/files/2021/08/site-long-1x.png?w=1264&amp;ssl=1 1264w, https://i0.wp.com/wordpress.org/news/files/2021/08/site-long-1x.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></a><figcaption><br><br><br><br></figcaption></figure></div>\n\n\n\n<h2>Create Interesting Visual Effects With Overlapping Layouts and Duotone Images</h2>\n\n\n\n<p>Appearance-wise, users have a lot more control over widget areas than ever before — especially through the use of blocks with customization options like the Cover and Image block. Here’s what I can create in the classic widgets editor (above) versus what I can create in the new block-based widget editor (below).</p>\n\n\n\n<figure class=\"wp-block-video aligncenter\"><video controls src=\"https://wordpress.org/news/files/2021/08/classic-widgets.mov\"></video></figure>\n\n\n\n<figure class=\"wp-block-video aligncenter\"><video controls src=\"https://wordpress.org/news/files/2021/08/block-widgets-1.mov\"></video></figure>\n\n\n\n<h2>Intersperse Widgets and Custom Code Throughout Your Visual Designs</h2>\n\n\n\n<p>Container blocks like Cover and Columns make it easy to weave dynamic or interactive elements into your designs. While this is a given for many widgets, the block versions of widgets can be easily wrapped and layered within container blocks to integrate them into your layout more fully.</p>\n\n\n\n<p>In the example below, I tried placing a Search block in front of a Cover block, which creates a nice layered effect. I also inserted Custom HTML blocks within a Columns block to display different messaging depending on the time of day. (<a href=\"https://stackoverflow.com/questions/31242051/show-content-based-on-time-of-day-timing-changes-on-different-days-of-the-week\">jQuery script</a>)</p>\n\n\n\n<figure class=\"wp-block-video aligncenter\"><video controls src=\"https://wordpress.org/news/files/2021/08/custom-html-1.mov\"></video></figure>\n\n\n\n<h2>Use Traditional Widget Layouts (Or Not) With Lots of Flexibility Over Title and Structure</h2>\n\n\n\n<p>Classic widgets have always had a lockup that includes a widget title. One cool thing about having blocks in widget areas is that you have complete flexibility over how titles appear. For example, you might choose to have a title over every widget, you might only want one title at the top of each widget area, or your design might not need titles at all.</p>\n\n\n\n<p>Note: Some themes, like <a href=\"https://wordpress.org/themes/twentytwentyone/\">Twenty Twenty-One</a>, are designed to flow content horizontally within widget areas. If you’re having trouble with a theme splitting your layout into columns, you could try keeping the lockup together by containing it within a Group block.</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-full\"><a href=\"https://i1.wp.com/wordpress.org/news/files/2021/08/grouped.jpg?ssl=1\"><img loading=\"lazy\" width=\"632\" height=\"381\" src=\"https://i1.wp.com/wordpress.org/news/files/2021/08/grouped.jpg?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C381&#038;ssl=1\" alt=\"Side-by-side comparison of List View of a Sidebar widget area with and without grouped/nested lockups.\" class=\"wp-image-11122\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2021/08/grouped.jpg?w=1760&amp;ssl=1 1760w, https://i1.wp.com/wordpress.org/news/files/2021/08/grouped.jpg?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C181&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2021/08/grouped.jpg?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C618&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2021/08/grouped.jpg?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C463&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2021/08/grouped.jpg?resize=1536{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C927&amp;ssl=1 1536w, https://i1.wp.com/wordpress.org/news/files/2021/08/grouped.jpg?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></a></figure></div>\n\n\n\n<h2>Copy &amp; Paste Existing Layouts From the WordPress Pattern Directory</h2>\n\n\n\n<p>While patterns haven’t been fully integrated into the widget editors yet, one thing you <em>can</em> do is copy and paste patterns from the game-changing new <a href=\"https://wordpress.org/patterns/\">WordPress Pattern Directory</a> into your site’s widget areas. I used this <a href=\"https://wordpress.org/patterns/pattern/horizontal-call-to-action/\">horizontal call to action</a> pattern from the directory almost exactly as is, with minor color and copy adjustments:</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-full\"><a href=\"https://i1.wp.com/wordpress.org/news/files/2021/08/footer.jpg?ssl=1\"><img loading=\"lazy\" width=\"632\" height=\"389\" src=\"https://i1.wp.com/wordpress.org/news/files/2021/08/footer.jpg?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C389&#038;ssl=1\" alt=\"Footer widget area with a black box that reads, “Become a monthly patron” with paragraph text and a “Join now” button in a separate column. A painted image of waves hitting rocks is directly below with no space between them.\n\" class=\"wp-image-11123\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2021/08/footer.jpg?w=1656&amp;ssl=1 1656w, https://i1.wp.com/wordpress.org/news/files/2021/08/footer.jpg?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C185&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2021/08/footer.jpg?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C630&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2021/08/footer.jpg?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C473&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2021/08/footer.jpg?resize=1536{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C945&amp;ssl=1 1536w, https://i1.wp.com/wordpress.org/news/files/2021/08/footer.jpg?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></a><figcaption><br></figcaption></figure></div>\n\n\n\n<p>FYI: Patterns have not been curated for or integrated into widget areas yet, so you may run into some unexpected behavior — consider this feature to be a preview of what’s coming next for widget editing!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"11115\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"The Month in WordPress: July 2021\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2021/08/the-month-in-wordpress-july-2021/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Aug 2021 13:53:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11107\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:334:\"WordPress is global in reach and open source in nature. And you would assume that what allows the software to be used by anyone would also enable it to be built by anyone. After all, your location doesn’t matter, and who employs you also doesn’t matter. And your relative social standing certainly shouldn’t matter. As [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Hari Shanker R\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:15260:\"\n<blockquote class=\"wp-block-quote\"><p>WordPress is global in reach and open source in nature. And you would assume that what allows the software to be used by anyone would also enable it to be built by anyone. After all, your location doesn’t matter, and who employs you also doesn’t matter. And your relative social standing certainly shouldn’t matter. As long as you can communicate with the others contributing to the project, there should be no obstacle to your participation.</p></blockquote>\n\n\n\n<p class=\"has-drop-cap\">That was <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden</a> on the “<a href=\"https://wordpress.org/news/2021/07/episode-13-cherishing-wordpress-diversity/\">Cherishing WordPress Diversity</a>” episode of the <a href=\"https://wordpress.org/news/podcast/\">WP Briefing Podcast</a>, speaking about the importance of diversity, equity, and inclusion within the fabric of the WordPress project. Her statement captures the spirit of the WordPress open source project, and we hope it resonates with you. Now, let&#8217;s dive in!</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Say hello to WordPress 5.8</h2>\n\n\n\n<p>WordPress <a href=\"https://wordpress.org/news/2021/07/tatum/\" target=\"_blank\" rel=\"noreferrer noopener\">version 5.8</a>, “Tatum,” came out on July 20. Version 5.8 is a major release that offers features like block-based widgets, a host of new blocks and patterns, a template editor, a duotone feature to stylize images, theme.json, and support for webP images, to name a few. Read more in the <a href=\"https://wordpress.org/news/2021/07/tatum/\">release post</a>, the <a href=\"https://make.wordpress.org/core/2021/07/03/wordpress-5-8-field-guide/\">field guide</a>, and the <a href=\"https://make.wordpress.org/community/2021/06/18/meetup-group-resources-talking-points-for-wordpress-5-8/\">talking points post for meetup groups</a>. </p>\n\n\n\n<p>Want to contribute to WordPress core?&nbsp;</p>\n\n\n\n<ul><li>Join the&nbsp; <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> channel, follow the <a href=\"https://make.wordpress.org/core/\">Core Team blog</a>, and check out the <a href=\"https://make.wordpress.org/core/handbook/\">team handbook</a>. Don’t miss the Core Team chats on Wednesdays at <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?hour=5&amp;min=00&amp;sec=0\">5 AM</a> and <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?hour=20&amp;min=00&amp;sec=0\">8 PM</a> UTC.</li><li><a href=\"https://translate.wordpress.org/\">Translate WordPress</a> to your local language &#8211; here’s the <a href=\"https://make.wordpress.org/polyglots/2021/07/09/wordpress-5-8-translation-status-july-9-2020/\">latest translation status</a>.</li><li>Contact the Marketing Team in the <a href=\"https://wordpress.slack.com/archives/C0GKJ7TFA\">#marketing</a> slack channel, if you wish to support <a href=\"https://make.wordpress.org/marketing/2021/07/21/social-media-pack-for-5-8-ongoing-collaborations/\">social media engagement around WordPress 5.8</a>.</li></ul>\n\n\n\n<h2>Gutenberg Version 11.0 is released</h2>\n\n\n\n<p>Contributor teams released the <a href=\"https://make.wordpress.org/core/2021/07/09/whats-new-in-gutenberg-11-0-0-9-july/\">11th version</a> of Gutenberg on July 9. <a href=\"https://make.wordpress.org/core/2021/07/09/whats-new-in-gutenberg-11-0-0-9-july/\">Version 11.0</a>, which focuses heavily on backports and bug fixes, showcases some cool features such as an editing overlay for template parts and reusable blocks, and support for CSS shorthand properties in theme.json and block attributes. <a href=\"https://make.wordpress.org/core/2021/07/21/whats-new-in-gutenberg-11-1-0-21-july/\">Version 11.1</a> was also shipped this month, on July 21. The release adds custom block borders as block supports and adds “drag and drop” to the list view.&nbsp;</p>\n\n\n\n<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/\">the Core Team blog</a>, contribute to <a href=\"https://github.com/WordPress/gutenberg/\">Gutenberg on GitHub</a>, and join the <a href=\"https://wordpress.slack.com/archives/C02QB2JS7\">#core-editor</a> channel in the <a href=\"https://make.wordpress.org/chat/\">Make WordPress Slack</a>. The “<a href=\"https://make.wordpress.org/core/2021/07/21/whats-next-in-gutenberg-site-editing-status-check-late-july-august-2021/\">What’s next in Gutenberg</a>” post offers more details on the latest updates.&nbsp;</p>\n\n\n\n<h2>Returning to in-person WordPress events</h2>\n\n\n\n<p>The Community Team kicked off work to bring back in-person WordPress events. The team <a href=\"https://make.wordpress.org/community/2021/07/01/in-person-meetup-events-for-vaccinated-community-members/#comment-29654\">recently announced</a> that in-person WordPress meetups can be organized in a region if the local public health authority allows in-person events and if the region passes the in-person<a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/2021-returning-to-in-person-meetups/in-person-meetup-decision-checklist/\"> safety checklist</a>. If the region does not meet guidelines on page one of the <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/2021-returning-to-in-person-meetups/in-person-meetup-decision-checklist/\">safety checklist</a>, organizers can plan events for fully vaccinated, recently tested (negative), or recently recovered community members. Subsequently, the team also <a href=\"https://make.wordpress.org/community/2021/07/27/proposal-how-to-return-to-safe-in-person-wordcamps/\">shared a proposal for the return to in-person WordCamps</a> in places that meet the <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/2021-returning-to-in-person-meetups/in-person-meetup-decision-checklist/\">safety guidelines and the vaccination/testing requirements</a>. Please share your feedback on the post if you have any thoughts. For more context, check out the “<a href=\"https://wordpress.org/news/2021/07/episode-12-wordpress-in-person/\">In Person!</a>” episode of the <a href=\"https://wordpress.org/news/podcast/\">WP Briefing Podcast</a>.&nbsp;</p>\n\n\n\n<p>Want to contribute to the Community Team? Follow the <a href=\"https://make.wordpress.org/community/\">Community Team</a> blog, or join them in the <a href=\"https://wordpress.slack.com/archives/C037W5S7X\">#community</a> channel in the Make WordPress Slack.&nbsp;</p>\n\n\n\n<h2>BuddyPress 9.0 is out</h2>\n\n\n\n<p>The BuddyPress team is busy! Within barely a month of their last major release (<a href=\"https://buddypress.org/2021/06/buddypress-8-0-0-alfano/\">version 8.0)</a>, the team shipped <a href=\"https://buddypress.org/2021/07/buddypress-9-0-0-mico/\">version 9.0</a> on July 19. Key features of the release include widget blocks and updates to the BP REST API.&nbsp; Download it from the <a href=\"https://wordpress.org/plugins/buddypress/\">WordPress.org plugin directory</a> or check it out from its <a href=\"https://buddypress.trac.wordpress.org/browser/branches/9.0\">subversion repository.</a> Want to help build BuddyPress? Follow their <a href=\"https://bpdevel.wordpress.com/\">developer relations blog</a>, check out their <a href=\"https://codex.buddypress.org/participate-and-contribute/contribute-with-code/\">handbook page</a>, or join them in the <a href=\"https://wordpress.slack.com/archives/C02RQBYUG\">#buddypress</a> channel in the Make WordPress Slack.</p>\n\n\n\n<h2>WordPress Event updates</h2>\n\n\n\n<ul><li>WordCamp US is coming back on October 1, 2021, <a href=\"https://us.wordcamp.org/2021/wordcamp-us-is-back/\">as a daylong online event</a>!</li><li>Free tickets for <a href=\"https://floripa.wordcamp.org/2021/inscricoes/\">WordCamp Florianopolis</a> (August 11-12) are now available.</li><li>The <a href=\"https://make.wordpress.org/community/tag/wpdiversity/\">Diverse Speaker Training group</a> of the Community Team announced <a href=\"https://make.wordpress.org/community/2021/07/26/announcement-and-call-for-volunteers-expanding-wpdiversity-to-three-programs/\">three new programs</a> for Meetup and WordCamp organizers. Sign up for the <a href=\"https://make.wordpress.org/community/2021/07/30/workshop-august-19-2021-allyship-for-wordpress-event-organizers-amer-emea/\">inaugural allyship program for event organizers</a> on August 19, 2021, at <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?iso=20210819T1700\">5:00</a> &#8211; <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?iso=20210819T1900\">7:00 pm</a> UTC!</li><li>The Polyglots Team is planning a <a href=\"https://make.wordpress.org/polyglots/tag/wptranslationday/\">month-long translation day celebration in September 2021</a>, with two weeks of “core events” from September 17 to 30. The team will announce more details on the event shortly, and you <a href=\"https://make.wordpress.org/polyglots/tag/wptranslationday/\">can follow all the latest updates on their P2</a>.&nbsp;</li><li>Stay updated on <a href=\"https://make.wordpress.org/community/events/online/\">online WordPress meetups</a> around the world by following the Marketing Team’s <a href=\"https://www.linkedin.com/company/make-wordpress-marketing-team/\">WordPress Meetup roundup</a> every Monday.&nbsp;</li><li><a href=\"https://santaclarita.wordcamp.org/2021/\">WordCamp Santa Clarita 2021</a> was held online on July 17-18, 2021. The highlight of the event, which had 41 speakers, 19 sponsors, and 672 attendees, was a <a href=\"https://santaclarita.wordcamp.org/2021/schedule/\">dedicated track for WordPress accessibility</a>. Videos of the event will soon be posted on WordPress.tv.</li><li>The Hosting Team organized <a href=\"https://www.meetup.com/wphosting/events/278295555\">their first meetup</a> in June. Check out the <a href=\"https://www.youtube.com/watch?v=V4UCc1Bze5E&amp;t=702s\">event recording</a>.</li></ul>\n\n\n\n<h2>Feedback requests from WordPress contributor teams</h2>\n\n\n\n<p>Please help these WordPress contributor teams by answering their research requests:</p>\n\n\n\n<ul><li>The Core Team has published a <a href=\"https://make.wordpress.org/core/2021/07/28/wordpress-5-8-tatum-retrospective/\">WordPress 5.8 release retrospective</a>. Share your release feedback as <a href=\"https://make.wordpress.org/core/2021/07/28/wordpress-5-8-tatum-retrospective/#respond\">comments on the post</a> or by <a href=\"https://docs.google.com/forms/d/e/1FAIpQLSei8fSLjV0um4hk_1JKwgu-8E6mpNwwxF3j43mInW7lnVOTDw/viewform?usp=sf_link\">filling out this form</a> before August 15. The team is also <a href=\"https://make.wordpress.org/core/2021/07/21/request-for-feedback-updater-proof-of-concept/\">requesting feedback</a> on a “proof of concept” for the new WordPress updater.&nbsp;</li><li>The Training Team wishes to <a href=\"https://make.wordpress.org/training/2021/07/30/learn-wordpress-user-survey-focus-groups/\">find what learners and potential learners would like to see</a> in the <a href=\"https://learn.wordpress.org\">learn.wordpress.org</a> platform. To contribute, please <a href=\"https://www.surveymonkey.com/r/LearnWordPress\">fill out an anonymous survey</a> (by August 13) OR <a href=\"https://forms.gle/jdk2qkkvGyszx1SG6\">join a short video call</a> to share feedback (on the week of August 2-6).</li><li>The Polyglots Team <a href=\"https://make.wordpress.org/polyglots/2021/07/19/polyglots-training-ready-for-testing/\">announced</a> that “Polyglots Training” (a course to help WordPress translators and communities) is now available for testing. <a href=\"https://make.wordpress.org/polyglots/2021/07/19/polyglots-training-ready-for-testing/\">Sign up now</a>!</li><li>The Test Team wants to<a href=\"https://make.wordpress.org/test/2021/07/30/help-shape-the-future-of-theme-design/\"> hear from theme authors</a> on how they use theme.json in order to shape its future. Help them by <a href=\"https://wordpressdotorg.survey.fm/block-theme-author-feedback\">filling out this survey</a> on or before August 13.</li><li>The Marketing Team is doing research on building engagement around WordPress releases. Please help the team by filling out <a href=\"https://forms.gle/4QFhX8fcNxKAfK8y5\">this quick, two-question survey</a> on how you search for release information. If you have any favorite features from the latest release (WordPress 5.8) let the team know by completing this <a href=\"https://docs.google.com/forms/d/e/1FAIpQLSd_2llymf79-h5sgTiprz7Kw4Gr4cbDHh-AAdAQfiArXlHksg/viewform\">short form</a>.</li></ul>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further reading</h2>\n\n\n\n<ul><li>The Meta Team launched the new <a href=\"https://make.wordpress.org/meta/2021/07/20/the-wordpress-pattern-directory-is-live/\">WordPress Pattern Directory</a> alongside the 5.8 release. The Design Team also contributed to this project, working with contributors on <a href=\"https://make.wordpress.org/design/2021/07/29/initial-patterns-for-the-patterns-directory-launched/\">launching around 85 block patterns in the directory</a>.</li><li>Check out the following blog posts from the Design Team: <a href=\"https://make.wordpress.org/design/2021/07/13/a-walk-around-the-search-block/\">A Walk Around: The Search Block</a> and <a href=\"https://make.wordpress.org/design/2021/07/27/widgets-in-wordpress-5-8-and-beyond/\">Widgets on 5.8 and beyond</a>. Join their <a href=\"https://make.wordpress.org/design/?s=show+and+tell\">Show and Tell meetings</a> on the last Wednesday of each month to learn about updates on their latest projects and new ideas.</li><li>Check out <a href=\"https://wordpress.org/news/2021/07/configuring-theme-design-with-theme-json/\">this blog post</a> to learn how to configure theme design with theme.json.&nbsp;</li><li>The Test Team has put out a <a href=\"https://make.wordpress.org/test/2021/07/20/test-team-reps-call-for-nominations/\">call for team-rep nominations</a>.</li><li>The Themes Team is in the process of discussing <a href=\"https://make.wordpress.org/themes/2021/07/20/discussion-request-for-feedback-on-requirement-changes/\">updated theme directory guidelines</a>.</li><li>Version 17.9 of WordPress for <a href=\"https://make.wordpress.org/mobile/2021/07/27/call-for-testing-wordpress-for-android-17-9/\">Android</a> and <a href=\"https://make.wordpress.org/mobile/2021/07/28/call-for-testing-wordpress-for-ios-17-9/\">iOS</a> are now available for testing.</li></ul>\n\n\n\n<p><em>Have a story that we should include in the next “Month in WordPress” post? Please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it using this form</em></a><em>.&nbsp;</em></p>\n\n\n\n<p><em>The following folks contributed to July’s Month in WordPress:&nbsp; <a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a> <a href=\'https://profiles.wordpress.org/chaion07/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chaion07</a> <a href=\'https://profiles.wordpress.org/jillbinder/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jillbinder</a> <a href=\'https://profiles.wordpress.org/lmurillom/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>lmurillom</a> <a href=\'https://profiles.wordpress.org/meher/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meher</a></em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"11107\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:58:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"WP Briefing: Episode 14: The Art and Science of Accessibility\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://wordpress.org/news/2021/08/episode-14-the-art-and-science-of-accessibility/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Aug 2021 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=11096\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:463:\"In this episode, Josepha Haden Chomphosy discusses the nuances of building accessible software, the differences between access, usability, and accessibility, and how this all applies to the WordPress project. Have a question you’d like answered? You can submit them to&#160;wpbriefing@wordpress.org, either written or as a voice recording. Credits Editor:&#160;Dustin Hartzler Logo:&#160;Beatriz Fialho Production:&#160;Chloé Bringmann Transcription: [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2021/07/WP-Briefing-014.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Nicholas Garofalo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9393:\"\n<p>In this episode, Josepha Haden Chomphosy discusses the nuances of building accessible software, the differences between access, usability, and accessibility, and how this all applies to the WordPress project.</p>\n\n\n\n<p><em><strong>Have a question you’d like answered? You can submit them to&nbsp;<a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2>Credits</h2>\n\n\n\n<ul><li>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a></li><li>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li><li>Production:&nbsp;<a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a></li><li>Transcription: <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a></li><li>Song: Fearless First by Kevin MacLeod</li></ul>\n\n\n\n<h2>References</h2>\n\n\n\n<ul><li><a href=\"https://wordpress.org/about/accessibility/\">About WordPress Accessibility</a></li><li><a href=\"https://make.wordpress.org/accessibility/\">Make WordPress Accessibility Team</a></li><li><a href=\"https://twitter.com/wpaccessibility\">WordPress Accessibility Team Twitter</a></li><li><a href=\"https://make.wordpress.org/accessibility/handbook/best-practices/\">WordPress Accessibility Handbook</a></li><li><a href=\"https://developer.wordpress.org/coding-standards/wordpress-coding-standards/accessibility/\">Accessibility Coding Standards</a></li><li><a href=\"https://www.w3.org/WAI/intro/wcag\">Web Content Accessibility Guidelines (WCAG)</a></li><li><a href=\"https://www.a11yproject.com/checklist/\">A11y Checklist</a></li><li><a href=\"https://en.wikipedia.org/wiki/Digital_divide\">The Digital Divide</a></li></ul>\n\n\n\n<h2>Transcript</h2>\n\n\n\n<span id=\"more-11096\"></span>\n\n\n\n<p>[contemporary intro music]</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy</strong> 0:10</p>\n\n\n\n<p>Hello, everyone, and welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. Here we go.</p>\n\n\n\n<p>[musical interlude]</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy</strong> 0:28</p>\n\n\n\n<p>This is the second of my big scary topics for this month. I&#8217;ll be talking about accessibility, which much like Diversity, Equity and Inclusion, or DEI in the last episode, is one of those areas where the work is never finished. Also, like DEI in last episode, I feel strongly about accessibility and the need for accessible experiences in the world, but I&#8217;m aware that this is an area where I&#8217;m still learning.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy</strong> 1:04</p>\n\n\n\n<p>WordPress has both an accessibility statement and team, which makes a lot of sense given that the software supports so many different people, and industries, and cultures. But if you&#8217;re not quite bought into the idea that software should be accessible, or that accessible software can&#8217;t also be usable, then this is the episode for you.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy</strong> 1:25</p>\n\n\n\n<p>Before I joined the WordPress project, the majority of my work with accessibility was in the context of the digital divide. Now, when talking about the digital divide, there are three concepts around quote-unquote, &#8220;getting things to people,&#8221; and those are access, usability, and accessibility. Sometimes these words seem interchangeable, but ultimately they have nuanced differences that address different problems. And I like to think of them this way.</p>\n\n\n\n<p>Access is making sure that someone can obtain something.</p>\n\n\n\n<p>Usability is making sure that the user experience is understandable or coherent.</p>\n\n\n\n<p>And accessibility is making sure that it&#8217;s usable by the largest number of people.</p>\n\n\n\n<p>I have always considered each as a subset of the one that came before it. So having something everyone can access is good, but easy to access and easy to use is better. Easy to use is good, but easy to use and easily accessible is better.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy</strong> 2:27</p>\n\n\n\n<p>After joining WordPress, I discovered that accessibility in the context of software building is well, substantially more complicated. There&#8217;s no such thing as perfect accessibility, or a site that is 100{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9} accessible, and many aspects are pretty open to interpretation. It turns out that accessibility, like so many things in WordPress, is a complicated intersection of art and science.</p>\n\n\n\n<p>As an example, there&#8217;s a rule that says, &#8220;Ensure that links are recognizable as links.&#8221; A fast shorthand to accomplish that, that we see all over the internet, is to underline all links or put that icon next to it that says, &#8220;This opens in a new tab.&#8221; You know that icon that&#8217;s a box with an arrow? That definitely has a name, that I definitely don&#8217;t know? That icon. [laughing] But those solutions don&#8217;t necessarily fit every context that you&#8217;ll find a link in, and that&#8217;s where we see that intersection between the art of communication and the science of necessity.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy</strong> 3:32</p>\n\n\n\n<p>If you came with me earlier on the idea that accessibility is a subset of usability, and it&#8217;s not a far leap to say that the choices around accessibility implementations should always include design and the overall user experience.</p>\n\n\n\n<p>I know that some of you are thinking, &#8220;But we have guidelines! Like, that&#8217;s why we have the guidelines, so that not everything has to be a gray area.&#8221; And on the one hand, yeah, that&#8217;s true. There are a lot of guidelines. There are guidelines for the code, and what the code produces, and the design elements. But I worry that when a solution is driven solely by rules, rather than reasons, we run the risk of throwing out the good along with the bad.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy</strong> 4:15</p>\n\n\n\n<p>Accessibility has been a consistent topic of debate in the project for as long as I can remember, and based on all of this, it&#8217;s really clear why. There are a few big picture questions that still deserve some sort of canonical answer for WordPress, and where possible I dig in and research the positions that everyone has taken in the past. But I also have questions about how to move everything forward, especially as the editing experience gets more and more standardized across the software, which reduces cognitive load, shortens the learning curve, etc.</p>\n\n\n\n<p>What is the future possibility for having a series of more niche admin interface options?</p>\n\n\n\n<p>What would it be like to be able to account for functional limitations in a way that lets site builders select what is needed for their clients or organization, or just individual situations they know their sites would be maintained under?</p>\n\n\n\n<p>What more could we do if part of the setup flow of WordPress was to select some bundle of potential add ons for neuro diversity, or colorblindness, or dyslexia, and more?</p>\n\n\n\n<p>It&#8217;s a really big question I have.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy</strong> 5:26</p>\n\n\n\n<p>And I have to be really transparent here and share that my foundational understanding of accessibility and usability is 10 plus years old, and I learned it in the context of people in education, not software. So a lot of my questions about the future of accessibility and WordPress is the result of old knowledge exploring new spaces, which means they are a little untested. And I&#8217;m so grateful for the contributors who point out what the current research and thinking is, in this incredibly complex field.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy</strong> 6:00</p>\n\n\n\n<p>I normally like to wrap up the briefing with a tidy takeaway, but this particular topic doesn&#8217;t really lend itself to that. So I&#8217;ll leave you with this. I really believe in WordPress&#8217; mission to democratize publishing. And I, for one, will never stop learning about what gives people more access to the software, and what makes the software more usable, and especially how we can combine usability with accessibility in a way that puts form and function on a level playing field.</p>\n\n\n\n<p>[musical interlude]</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy</strong> 6:40</p>\n\n\n\n<p>And now, that brings us to our small list of big things.</p>\n\n\n\n<p>Thing one, it&#8217;s that time of year where many of our community members take a short break to relax and refresh. I&#8217;ll be taking a bit of a break during the month of August, and so the WP Briefing will return again starting in September.</p>\n\n\n\n<p>And thing two, huge thanks to the production crew that helps me make this podcast every couple of weeks, but a special shout out to our editor Dustin Hartzler, who makes quick work of all of my rambling thoughts.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy</strong> 7:09</p>\n\n\n\n<p>And that is your small list of big things. Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphosy, and I&#8217;ll see you again in September.</p>\n\n\n\n<p>[contemporary outro music]</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"11096\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:66:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"Configuring Theme Design with theme.json\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wordpress.org/news/2021/07/configuring-theme-design-with-theme-json/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Jul 2021 22:26:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:6:\"Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:9:\"Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11060\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:368:\"Starting in WordPress 5.8, a new tool — “theme.json” — is available to use in your theme. Maybe you’re hearing about it for the first time, or maybe you’re testing and developing themes with it already. Either way, I&#8217;m glad you&#8217;re here because it&#8217;s an exciting time for WordPress themes. This post provides a quick introduction [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Jeff Ong\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:21957:\"\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" width=\"632\" height=\"356\" src=\"https://i2.wp.com/wordpress.org/news/files/2021/07/themejson-1.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C356&#038;ssl=1\" alt=\"\" class=\"wp-image-11082\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2021/07/themejson-1.png?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C576&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2021/07/themejson-1.png?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C169&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2021/07/themejson-1.png?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C432&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2021/07/themejson-1.png?resize=1536{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C864&amp;ssl=1 1536w, https://i2.wp.com/wordpress.org/news/files/2021/07/themejson-1.png?resize=2048{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C1152&amp;ssl=1 2048w, https://i2.wp.com/wordpress.org/news/files/2021/07/themejson-1.png?w=1264&amp;ssl=1 1264w, https://i2.wp.com/wordpress.org/news/files/2021/07/themejson-1.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Starting in <a href=\"https://wordpress.org/news/2021/07/tatum/\">WordPress 5.8</a>, a new tool — “theme.json” — is available to use in your theme. Maybe you’re hearing about it for the first time, or maybe you’re testing and developing themes with it already. Either way, I&#8217;m glad you&#8217;re here because it&#8217;s an exciting time for WordPress themes.</p>\n\n\n\n<p>This post provides a quick introduction to this new framework, and describes what’s possible by sharing a few practical tips and examples.</p>\n\n\n\n<h2>What’s theme.json?</h2>\n\n\n\n<p>Technically, theme.json is just a file that lives at the top-level of a theme’s directory.&nbsp;</p>\n\n\n\n<p>Conceptually, it’s a major shift in how themes can be developed. Theme authors now have a centralized mechanism to tailor the WordPress experience for site authors and visitors. Theme.json provides theme authors fine-grained control over global styles, block styles, and the block editor settings.</p>\n\n\n\n<p>By providing these settings and controls in a single file, theme.json provides a powerful framework that brings together many aspects of theme design and development. And as the block editor matures and adds more features, theme.json will shine as the backbone for themes and the editor to work <em>together</em> <img src=\"https://s.w.org/images/core/emoji/13.1.0/72x72/1f4aa.png\" alt=\"💪\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" />. </p>\n\n\n\n<h2>Why Use it?</h2>\n\n\n\n<p>It’s the future! But if you’re like me, you might need something more tangible to be convinced. Here are a few reasons why you might use theme.json today:</p>\n\n\n\n<ul><li>Control editor settings like color, typography, spacing, and layout, and consolidate where these settings are managed.</li><li>Guarantee that styles apply correctly to blocks and elements across your site.</li><li>Reduce the amount of boilerplate CSS a theme used to provide. Theme.json won&#8217;t replace your stylesheet completely — there will be instances where CSS is needed to give your theme that extra flare (transitions, animations, etc.). But it can greatly reduce the base CSS needed from the theme.</li></ul>\n\n\n\n<h2>How do I use it?</h2>\n\n\n\n<p>The rest of this post demonstrates a few theme.json configurations you can try out. The examples use the tt1-blocks<a href=\"https://github.com/WordPress/theme-experiments/blob/master/tt1-blocks/theme.json\"> theme.json</a> — <a href=\"https://wordpress.org/themes/tt1-blocks/\">the block-based version of this year’s default theme</a>. </p>\n\n\n\n<p>If you&#8217;re starting with an existing theme, you might try copying a theme.json from the <a href=\"https://github.com/WordPress/theme-experiments/\">WordPress/theme-experiments repository</a> (for example, <a href=\"https://github.com/WordPress/theme-experiments/blob/master/fse-tutorial/theme.json\">the fse-tutorial theme</a> by <a href=\"https://profiles.wordpress.org/poena/\">@poena</a>) and adding it to the root of your theme’s directory.</p>\n\n\n\n<h3><strong>Change the typography settings of your site globally</strong></h3>\n\n\n<div class=\"wp-block-syntaxhighlighter-code \"><pre class=\"brush: jscript; title: ; notranslate\">\n&quot;settings&quot;: {\n	&quot;typography&quot;: {\n		&quot;fontSize&quot;: &quot;30px&quot;,\n		...\n</pre></div>\n\n\n<p>Making the change above in theme.json would result in the following updates to your theme&#8217;s body typography styles (before and after): </p>\n\n\n\n<figure class=\"wp-block-gallery columns-2 is-cropped\"><ul class=\"blocks-gallery-grid\"><li class=\"blocks-gallery-item\"><figure><a href=\"https://i1.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.06.07-AM.png?ssl=1\"><img loading=\"lazy\" width=\"632\" height=\"398\" src=\"https://i1.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.06.07-AM.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C398&#038;ssl=1\" alt=\"\" data-id=\"11062\" data-full-url=\"https://wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.06.07-AM.png\" data-link=\"https://wordpress.org/news/?attachment_id=11062\" class=\"wp-image-11062\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.06.07-AM.png?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C645&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.06.07-AM.png?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C189&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.06.07-AM.png?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C484&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.06.07-AM.png?resize=1536{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C968&amp;ssl=1 1536w, https://i1.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.06.07-AM.png?resize=2048{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C1291&amp;ssl=1 2048w, https://i1.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.06.07-AM.png?w=1264&amp;ssl=1 1264w, https://i1.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.06.07-AM.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></a></figure></li><li class=\"blocks-gallery-item\"><figure><a href=\"https://i1.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.05.40-AM.png?ssl=1\"><img loading=\"lazy\" width=\"632\" height=\"398\" src=\"https://i1.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.05.40-AM.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C398&#038;ssl=1\" alt=\"\" data-id=\"11061\" data-full-url=\"https://wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.05.40-AM.png\" data-link=\"https://wordpress.org/news/?attachment_id=11061\" class=\"wp-image-11061\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.05.40-AM.png?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C645&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.05.40-AM.png?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C189&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.05.40-AM.png?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C484&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.05.40-AM.png?resize=1536{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C968&amp;ssl=1 1536w, https://i1.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.05.40-AM.png?resize=2048{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C1291&amp;ssl=1 2048w, https://i1.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.05.40-AM.png?w=1264&amp;ssl=1 1264w, https://i1.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.05.40-AM.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></a></figure></li></ul></figure>\n\n\n\n<h3><strong>Changing the base color settings of your site globally</strong></h3>\n\n\n<div class=\"wp-block-syntaxhighlighter-code \"><pre class=\"brush: jscript; title: ; notranslate\">\n&quot;styles&quot;: {\n	&quot;color&quot;: {\n		&quot;background&quot;: &quot;#ffc0cb&quot;,\n		&quot;text&quot;: &quot;#6A1515&quot;\n	},\n	...\n}\n</pre></div>\n\n\n<figure class=\"wp-block-gallery columns-2 is-cropped\"><ul class=\"blocks-gallery-grid\"><li class=\"blocks-gallery-item\"><figure><a href=\"https://i2.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.10.03-AM.png?ssl=1\"><img loading=\"lazy\" width=\"632\" height=\"398\" src=\"https://i2.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.10.03-AM.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C398&#038;ssl=1\" alt=\"\" data-id=\"11063\" data-full-url=\"https://wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.10.03-AM.png\" data-link=\"https://wordpress.org/news/?attachment_id=11063\" class=\"wp-image-11063\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.10.03-AM.png?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C645&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.10.03-AM.png?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C189&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.10.03-AM.png?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C484&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.10.03-AM.png?resize=1536{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C968&amp;ssl=1 1536w, https://i2.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.10.03-AM.png?resize=2048{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C1291&amp;ssl=1 2048w, https://i2.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.10.03-AM.png?w=1264&amp;ssl=1 1264w, https://i2.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.10.03-AM.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></a></figure></li><li class=\"blocks-gallery-item\"><figure><a href=\"https://i2.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.08.54-AM.png?ssl=1\"><img loading=\"lazy\" width=\"632\" height=\"398\" src=\"https://i2.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.08.54-AM.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C398&#038;ssl=1\" alt=\"\" data-id=\"11064\" data-full-url=\"https://wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.08.54-AM.png\" data-link=\"https://wordpress.org/news/?attachment_id=11064\" class=\"wp-image-11064\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.08.54-AM.png?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C645&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.08.54-AM.png?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C189&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.08.54-AM.png?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C484&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.08.54-AM.png?resize=1536{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C968&amp;ssl=1 1536w, https://i2.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.08.54-AM.png?resize=2048{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C1291&amp;ssl=1 2048w, https://i2.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.08.54-AM.png?w=1264&amp;ssl=1 1264w, https://i2.wp.com/wordpress.org/news/files/2021/07/Screen-Shot-2021-07-23-at-11.08.54-AM.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></a></figure></li></ul></figure>\n\n\n\n<h3><strong><strong>Changing spacing / padding settings on specific blocks</strong></strong></h3>\n\n\n<div class=\"wp-block-syntaxhighlighter-code \"><pre class=\"brush: jscript; title: ; notranslate\">\n&quot;styles&quot;: {\n	&quot;blocks&quot;: {\n		&quot;core/code&quot;: {\n			&quot;spacing&quot;: {\n				&quot;padding&quot;: {\n					&quot;top&quot;: &quot;3em&quot;,\n					&quot;bottom&quot;: &quot;3em&quot;,\n					&quot;left&quot;: &quot;3em&quot;,\n					&quot;right&quot;: &quot;3em&quot;\n				}\n			}\n		}\n	}\n}\n\n</pre></div>\n\n\n<figure class=\"wp-block-gallery columns-2 is-cropped\"><ul class=\"blocks-gallery-grid\"><li class=\"blocks-gallery-item\"><figure><a href=\"https://i2.wp.com/wordpress.org/news/files/2021/07/code-padding-original.png?ssl=1\"><img loading=\"lazy\" width=\"632\" height=\"356\" src=\"https://i2.wp.com/wordpress.org/news/files/2021/07/code-padding-original.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C356&#038;ssl=1\" alt=\"\" data-id=\"11065\" data-full-url=\"https://wordpress.org/news/files/2021/07/code-padding-original.png\" data-link=\"https://wordpress.org/news/?attachment_id=11065\" class=\"wp-image-11065\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2021/07/code-padding-original.png?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C576&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2021/07/code-padding-original.png?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C169&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2021/07/code-padding-original.png?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C432&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2021/07/code-padding-original.png?resize=1536{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C864&amp;ssl=1 1536w, https://i2.wp.com/wordpress.org/news/files/2021/07/code-padding-original.png?w=1600&amp;ssl=1 1600w, https://i2.wp.com/wordpress.org/news/files/2021/07/code-padding-original.png?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></a></figure></li><li class=\"blocks-gallery-item\"><figure><a href=\"https://i1.wp.com/wordpress.org/news/files/2021/07/code-padding-edited.png?ssl=1\"><img loading=\"lazy\" width=\"632\" height=\"356\" src=\"https://i0.wp.com/wordpress.org/news/files/2021/07/code-padding-edited-1024x576.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C356&#038;ssl=1\" alt=\"\" data-id=\"11066\" data-full-url=\"https://wordpress.org/news/files/2021/07/code-padding-edited.png\" data-link=\"https://wordpress.org/news/?attachment_id=11066\" class=\"wp-image-11066\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2021/07/code-padding-edited.png?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C576&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2021/07/code-padding-edited.png?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C169&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2021/07/code-padding-edited.png?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C432&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2021/07/code-padding-edited.png?resize=1536{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C864&amp;ssl=1 1536w, https://i1.wp.com/wordpress.org/news/files/2021/07/code-padding-edited.png?w=1600&amp;ssl=1 1600w, https://i1.wp.com/wordpress.org/news/files/2021/07/code-padding-edited.png?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></a></figure></li></ul></figure>\n\n\n\n<h3><strong><strong>Set a custom color palette in the editor for specific blocks like a button </strong></strong></h3>\n\n\n<div class=\"wp-block-syntaxhighlighter-code \"><pre class=\"brush: jscript; title: ; notranslate\">\n&quot;settings&quot;: {\n    &quot;blocks&quot;: {\n		&quot;core/button&quot;: {\n			&quot;color&quot;: {\n				&quot;palette&quot;: &#91; \n					{\n						&quot;name&quot;: &quot;Maroon&quot;,\n						&quot;color&quot;: &quot;#6A1515&quot;,\n						&quot;slug&quot;: &quot;maroon&quot;\n					},\n					{\n						&quot;name&quot;: &quot;Strawberry Ice Cream&quot;,\n						&quot;color&quot;: &quot;#FFC0CB&quot;,\n						&quot;slug&quot;: &quot;strawberry-ice-cream&quot;\n					}\n				]\n			}\n		}\n	}\n}\n</pre></div>\n\n\n<figure class=\"wp-block-gallery columns-2 is-cropped\"><ul class=\"blocks-gallery-grid\"><li class=\"blocks-gallery-item\"><figure><a href=\"https://i0.wp.com/wordpress.org/news/files/2021/07/button-all-colors.png?ssl=1\"><img loading=\"lazy\" width=\"632\" height=\"444\" src=\"https://i0.wp.com/wordpress.org/news/files/2021/07/button-all-colors.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C444&#038;ssl=1\" alt=\"\" data-id=\"11069\" data-full-url=\"https://wordpress.org/news/files/2021/07/button-all-colors.png\" data-link=\"https://wordpress.org/news/?attachment_id=11069\" class=\"wp-image-11069\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2021/07/button-all-colors.png?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C719&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2021/07/button-all-colors.png?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C211&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2021/07/button-all-colors.png?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C539&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2021/07/button-all-colors.png?resize=1536{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C1079&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2021/07/button-all-colors.png?resize=2048{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C1438&amp;ssl=1 2048w, https://i0.wp.com/wordpress.org/news/files/2021/07/button-all-colors.png?w=1264&amp;ssl=1 1264w, https://i0.wp.com/wordpress.org/news/files/2021/07/button-all-colors.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></a></figure></li><li class=\"blocks-gallery-item\"><figure><a href=\"https://i1.wp.com/wordpress.org/news/files/2021/07/buttons-custom-palette.png?ssl=1\"><img loading=\"lazy\" width=\"632\" height=\"444\" src=\"https://i1.wp.com/wordpress.org/news/files/2021/07/buttons-custom-palette.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C444&#038;ssl=1\" alt=\"\" data-id=\"11070\" data-full-url=\"https://wordpress.org/news/files/2021/07/buttons-custom-palette.png\" data-link=\"https://wordpress.org/news/?attachment_id=11070\" class=\"wp-image-11070\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2021/07/buttons-custom-palette.png?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C719&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2021/07/buttons-custom-palette.png?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C211&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2021/07/buttons-custom-palette.png?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C539&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2021/07/buttons-custom-palette.png?resize=1536{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C1079&amp;ssl=1 1536w, https://i1.wp.com/wordpress.org/news/files/2021/07/buttons-custom-palette.png?resize=2048{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C1438&amp;ssl=1 2048w, https://i1.wp.com/wordpress.org/news/files/2021/07/buttons-custom-palette.png?w=1264&amp;ssl=1 1264w, https://i1.wp.com/wordpress.org/news/files/2021/07/buttons-custom-palette.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></a></figure></li></ul></figure>\n\n\n\n<h3><strong><strong>Enable and disable typography controls</strong></strong></h3>\n\n\n\n<p>In the following example, the ability to supply a custom font size and line height for all heading blocks is disabled:</p>\n\n\n<div class=\"wp-block-syntaxhighlighter-code \"><pre class=\"brush: jscript; title: ; notranslate\">\n	&quot;settings&quot;: {\n		&quot;blocks&quot;: {\n			&quot;core/heading&quot;: {\n				&quot;typography&quot;: {\n					&quot;customFontSize&quot;: false,\n					&quot;customLineHeight&quot;: false\n				}\n			}\n		}\n	}\n</pre></div>\n\n\n<figure class=\"wp-block-gallery columns-2 is-cropped\"><ul class=\"blocks-gallery-grid\"><li class=\"blocks-gallery-item\"><figure><a href=\"https://i1.wp.com/wordpress.org/news/files/2021/07/heading-all-options.png?ssl=1\"><img loading=\"lazy\" width=\"632\" height=\"444\" src=\"https://i1.wp.com/wordpress.org/news/files/2021/07/heading-all-options.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C444&#038;ssl=1\" alt=\"\" data-id=\"11071\" data-full-url=\"https://wordpress.org/news/files/2021/07/heading-all-options.png\" data-link=\"https://wordpress.org/news/?attachment_id=11071\" class=\"wp-image-11071\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2021/07/heading-all-options.png?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C719&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2021/07/heading-all-options.png?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C211&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2021/07/heading-all-options.png?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C539&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2021/07/heading-all-options.png?resize=1536{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C1079&amp;ssl=1 1536w, https://i1.wp.com/wordpress.org/news/files/2021/07/heading-all-options.png?resize=2048{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C1438&amp;ssl=1 2048w, https://i1.wp.com/wordpress.org/news/files/2021/07/heading-all-options.png?w=1264&amp;ssl=1 1264w, https://i1.wp.com/wordpress.org/news/files/2021/07/heading-all-options.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></a></figure></li><li class=\"blocks-gallery-item\"><figure><a href=\"https://i2.wp.com/wordpress.org/news/files/2021/07/heading-no-line-height-custom-size.png?ssl=1\"><img loading=\"lazy\" width=\"632\" height=\"444\" src=\"https://i2.wp.com/wordpress.org/news/files/2021/07/heading-no-line-height-custom-size.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C444&#038;ssl=1\" alt=\"\" data-id=\"11072\" data-full-url=\"https://wordpress.org/news/files/2021/07/heading-no-line-height-custom-size.png\" data-link=\"https://wordpress.org/news/?attachment_id=11072\" class=\"wp-image-11072\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2021/07/heading-no-line-height-custom-size.png?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C719&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2021/07/heading-no-line-height-custom-size.png?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C211&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2021/07/heading-no-line-height-custom-size.png?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C539&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2021/07/heading-no-line-height-custom-size.png?resize=1536{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C1079&amp;ssl=1 1536w, https://i2.wp.com/wordpress.org/news/files/2021/07/heading-no-line-height-custom-size.png?resize=2048{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C1438&amp;ssl=1 2048w, https://i2.wp.com/wordpress.org/news/files/2021/07/heading-no-line-height-custom-size.png?w=1264&amp;ssl=1 1264w, https://i2.wp.com/wordpress.org/news/files/2021/07/heading-no-line-height-custom-size.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></a></figure></li></ul></figure>\n\n\n\n<h2>What&#8217;s Next?</h2>\n\n\n\n<p>I hope this gives you a sense of what&#8217;s possible and where themes are going. The above examples just scratch the surface of what kinds of theme design configurations are possible, and I’m very excited to see what theme authors create.</p>\n\n\n\n<p>If you&#8217;re interested in learning more, <a href=\"https://make.wordpress.org/core/2021/06/25/introducing-theme-json-in-wordpress-5-8/\">here&#8217;s the developer note on theme.json</a>, and <a href=\"https://developer.wordpress.org/block-editor/how-to-guides/themes/theme-json/\">here&#8217;s the documentation for theme.json</a> in the handbook.</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><em><strong>Thanks to <a href=\"https://profiles.wordpress.org/kjellr/\">@kjellr</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">@</a></strong></em><strong><em><a href=\"https://profiles.wordpress.org/chanthaboune/\">chanthaboune</a>, <a href=\"https://profiles.wordpress.org/priethor/\">@priethor</a>, <a href=\"https://profiles.wordpress.org/annezazu/\">@annezazu</a> for helping with and peer-reviewing this post.</em></strong></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"11060\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"WordPress 5.8 Tatum\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://wordpress.org/news/2021/07/tatum/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Jul 2021 17:43:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"5.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=10976\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:277:\"Introducing 5.8 “Tatum”, our latest and greatest release, named in honor of the legendary jazz pianist Art Tatum. This release includes an all new widget editor powered by blocks, major technical tools for building block themes, as well as newly streamlined workflow tools.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:55719:\"\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" width=\"632\" height=\"422\" src=\"https://i0.wp.com/wordpress.org/news/files/2021/07/5x8-Album-1.jpg?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C422&#038;ssl=1\" alt=\"\" class=\"wp-image-11042\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Introducing 5.8 “Tatum”, our latest and greatest release now available for&nbsp;<a href=\"https://wordpress.org/download/\">download</a>&nbsp;or update in your dashboard. Named in honor of Art Tatum, the legendary Jazz pianist. His formidable technique and willingness to push boundaries inspired musicians and changed what people thought could be done.&nbsp;</p>\n\n\n\n<p>So fire up your music service of choice and enjoy Tatum’s famous recordings of ‘Tea for Two’, ‘Tiger Rag’, ‘Begin the Beguine’, and ‘Night and Day’ as you read about what the latest WordPress version brings to you.</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<h2 class=\"has-text-align-center\">Three Essential Powerhouses</h2>\n\n\n\n<div style=\"height:16px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-gallery columns-2 is-cropped\"><ul class=\"blocks-gallery-grid\"><li class=\"blocks-gallery-item\"><figure><img loading=\"lazy\" width=\"632\" height=\"474\" src=\"https://i1.wp.com/wordpress.org/news/files/2021/07/about-widgets-blocks.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C474&#038;ssl=1\" alt=\"\" data-id=\"10985\" data-full-url=\"https://wordpress.org/news/files/2021/07/about-widgets-blocks.png\" data-link=\"https://wordpress.org/news/?attachment_id=10985\" class=\"wp-image-10985\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2021/07/about-widgets-blocks.png?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C768&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2021/07/about-widgets-blocks.png?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C225&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2021/07/about-widgets-blocks.png?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C576&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2021/07/about-widgets-blocks.png?w=1280&amp;ssl=1 1280w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure></li><li class=\"blocks-gallery-item\"><figure><img loading=\"lazy\" width=\"632\" height=\"501\" src=\"https://i2.wp.com/wordpress.org/news/files/2021/07/about-query-loop.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C501&#038;ssl=1\" alt=\"\" data-id=\"10986\" data-full-url=\"https://wordpress.org/news/files/2021/07/about-query-loop.png\" data-link=\"https://wordpress.org/news/?attachment_id=10986\" class=\"wp-image-10986\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2021/07/about-query-loop.png?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C811&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2021/07/about-query-loop.png?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C238&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2021/07/about-query-loop.png?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C608&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2021/07/about-query-loop.png?w=1280&amp;ssl=1 1280w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure></li><li class=\"blocks-gallery-item\"><figure><img loading=\"lazy\" width=\"632\" height=\"411\" src=\"https://i2.wp.com/wordpress.org/news/files/2021/07/about-template.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C411&#038;ssl=1\" alt=\"\" data-id=\"10987\" data-full-url=\"https://wordpress.org/news/files/2021/07/about-template.png\" data-link=\"https://wordpress.org/news/?attachment_id=10987\" class=\"wp-image-10987\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2021/07/about-template.png?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C666&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2021/07/about-template.png?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C195&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2021/07/about-template.png?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C499&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2021/07/about-template.png?w=1280&amp;ssl=1 1280w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure></li></ul></figure>\n\n\n\n<h3>Manage Widgets with Blocks</h3>\n\n\n\n<p>After months of hard work, the power of blocks has come to both the Block Widgets Editor and the Customizer. Now you can add blocks both in widget areas across your site and with live preview through the Customizer. This opens up new possibilities to create content: from no-code mini layouts to the vast library of core and third-party blocks. For our developers, you can find more details in the&nbsp;<a href=\"https://make.wordpress.org/core/2021/06/29/block-based-widgets-editor-in-wordpress-5-8/\">Widgets dev note</a>.</p>\n\n\n\n<h3>Display Posts with New Blocks and Patterns</h3>\n\n\n\n<p>The Query Loop Block makes it possible to display posts based on specified parameters; like a PHP loop without the code. Easily display posts from a specific category, to do things like create a portfolio or a page full of your favorite recipes. Think of it as a more complex and powerful Latest Posts Block! Plus, pattern suggestions make it easier than ever to create a list of posts with the design you want.</p>\n\n\n\n<h3>Edit the Templates Around Posts</h3>\n\n\n\n<p>You can use the familiar block editor to edit templates that hold your content—simply activate a block theme or a theme that has opted in for this feature. Switch from editing your posts to editing your pages and back again, all while using a familiar block editor. There are more than 20 new blocks available within compatible themes. Read more about this feature and how to experiment with it in the release notes.</p>\n\n\n\n<div style=\"height:32px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"has-text-align-center\">Three Workflow Helpers</h2>\n\n\n\n<div style=\"height:16px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-gallery columns-2 is-cropped\"><ul class=\"blocks-gallery-grid\"><li class=\"blocks-gallery-item\"><figure><img loading=\"lazy\" width=\"632\" height=\"496\" src=\"https://i1.wp.com/wordpress.org/news/files/2021/07/about-list-view.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C496&#038;ssl=1\" alt=\"\" data-id=\"10988\" data-full-url=\"https://wordpress.org/news/files/2021/07/about-list-view.png\" data-link=\"https://wordpress.org/news/?attachment_id=10988\" class=\"wp-image-10988\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2021/07/about-list-view.png?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C803&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2021/07/about-list-view.png?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C235&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2021/07/about-list-view.png?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C602&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2021/07/about-list-view.png?w=1280&amp;ssl=1 1280w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure></li><li class=\"blocks-gallery-item\"><figure><img loading=\"lazy\" width=\"632\" height=\"343\" src=\"https://i2.wp.com/wordpress.org/news/files/2021/07/about-pattern-suggestions.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C343&#038;ssl=1\" alt=\"\" data-id=\"10989\" data-full-url=\"https://wordpress.org/news/files/2021/07/about-pattern-suggestions.png\" data-link=\"https://wordpress.org/news/?attachment_id=10989\" class=\"wp-image-10989\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2021/07/about-pattern-suggestions.png?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C555&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2021/07/about-pattern-suggestions.png?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C163&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2021/07/about-pattern-suggestions.png?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C416&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2021/07/about-pattern-suggestions.png?w=1280&amp;ssl=1 1280w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure></li><li class=\"blocks-gallery-item\"><figure><img loading=\"lazy\" width=\"632\" height=\"517\" src=\"https://i0.wp.com/wordpress.org/news/files/2021/07/about-duotone.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C517&#038;ssl=1\" alt=\"\" data-id=\"10990\" data-full-url=\"https://wordpress.org/news/files/2021/07/about-duotone.png\" data-link=\"https://wordpress.org/news/?attachment_id=10990\" class=\"wp-image-10990\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2021/07/about-duotone.png?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C837&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2021/07/about-duotone.png?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C245&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2021/07/about-duotone.png?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C628&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2021/07/about-duotone.png?w=1280&amp;ssl=1 1280w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure></li></ul></figure>\n\n\n\n<h3>Overview of the Page Structure</h3>\n\n\n\n<p>Sometimes you need a simple landing page, but sometimes you need something a little more robust. As blocks increase, patterns emerge, and content creation gets easier, new solutions are needed to make complex content easy to navigate. List View is the best way to jump between layers of content and nested blocks. Since the List View gives you an overview of all the blocks in your content, you can now navigate quickly to the precise block you need. Ready to focus completely on your content? Toggle it on or off to suit your workflow.</p>\n\n\n\n<h3>Suggested Patterns for Blocks</h3>\n\n\n\n<p>Starting in this release the Pattern Transformations tool will suggest block patterns based on the block you are using. Right now, you can give it a try in the Query Block and Social Icon Block. As more patterns are added, you will be able to get inspiration for how to style your site without ever leaving the editor!</p>\n\n\n\n<h3>Style and Colorize Images</h3>\n\n\n\n<p>Colorize your image and cover blocks with duotone filters! Duotone can add a pop of color to your designs and style your images (or videos in the cover block) to integrate well with your themes. You can think of the duotone effect as a black and white filter, but instead of the shadows being black and the highlights being white, you pick your own colors for the shadows and highlights. There’s more to learn about how it works in the documentation.</p>\n\n\n\n<div style=\"height:32px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"has-text-align-center\">For Developers to Explore</h2>\n\n\n\n<div style=\"height:16px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" width=\"632\" height=\"378\" src=\"https://i1.wp.com/wordpress.org/news/files/2021/07/about-theme-json-2x.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C378&#038;ssl=1\" alt=\"\" class=\"wp-image-10992\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2021/07/about-theme-json-2x.png?resize=1024{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C613&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2021/07/about-theme-json-2x.png?resize=300{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C179&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2021/07/about-theme-json-2x.png?resize=768{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C459&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2021/07/about-theme-json-2x.png?resize=1536{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C919&amp;ssl=1 1536w, https://i1.wp.com/wordpress.org/news/files/2021/07/about-theme-json-2x.png?resize=2048{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C1225&amp;ssl=1 2048w, https://i1.wp.com/wordpress.org/news/files/2021/07/about-theme-json-2x.png?w=1264&amp;ssl=1 1264w, https://i1.wp.com/wordpress.org/news/files/2021/07/about-theme-json-2x.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<div style=\"height:16px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h3>Theme.json</h3>\n\n\n\n<p>Introducing the Global Styles and Global Settings APIs: control the editor settings, available customization tools, and style blocks using a theme.json file in the active theme. This configuration file enables or disables features and sets default styles for both a website and blocks. If you build themes, you can experiment with this early iteration of a useful new feature. For more about what is currently available and how it works,&nbsp;<a href=\"https://make.wordpress.org/core/2021/06/25/introducing-theme-json-in-wordpress-5-8/\">check out this dev note</a>.</p>\n\n\n\n<div style=\"height:16px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-columns\">\n<div class=\"wp-block-column\">\n<h3>Dropping support for IE11</h3>\n\n\n\n<p>Support for Internet Explorer 11 has been dropped as of this release. This means you may have issues managing your site that will not be fixed in the future. If you are currently using IE11, it is strongly recommended that you&nbsp;<a href=\"https://browsehappy.com/\">switch to a more modern browser</a>.</p>\n</div>\n\n\n\n<div class=\"wp-block-column\">\n<h3>Adding support for WebP</h3>\n\n\n\n<p>WebP is a modern image format that provides improved lossless and lossy compression for images on the web. WebP images are around 30{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9} smaller on average than their JPEG or PNG equivalents, resulting in sites that are faster and use less bandwidth.</p>\n</div>\n</div>\n\n\n\n<h3>Adding Additional Block Supports</h3>\n\n\n\n<p>Expanding on previously implemented block supports in WordPress&nbsp;<a href=\"https://make.wordpress.org/core/2020/11/18/block-supports-in-wordpress-5-6/\">5.6</a>&nbsp;and&nbsp;<a href=\"https://make.wordpress.org/core/2021/02/24/changes-to-block-editor-components-and-blocks/\">5.7</a>, WordPress 5.8 introduces several new block support flags and new options to customize your registered blocks. More information is available in the&nbsp;<a href=\"https://make.wordpress.org/core/2021/06/25/block-supports-api-updates-for-wordpress-5-8/\">block supports dev note</a>.</p>\n\n\n\n<div style=\"height:16px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h3>Check the Field Guide for more!</h3>\n\n\n\n<p>Check out the latest version of the WordPress Field Guide. It highlights developer notes for each change you may want to be aware of:&nbsp;<a href=\"https://make.wordpress.org/core/2021/07/03/wordpress-5-8-field-guide/\">WordPress 5.8 Field Guide.</a></p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<h2>The Squad</h2>\n\n\n\n<p>The WordPress 5.8 release was led by <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a>, and supported by this highly enthusiastic release squad:</p>\n\n\n\n<ul><li><strong>Release Co-Coordinator:</strong>&nbsp;Jeffrey Paul (<a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a>)</li><li><strong>Release Co-Coordinator:</strong>&nbsp;Jonathan Desrosiers (<a href=\'https://profiles.wordpress.org/desrosj/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>desrosj</a>)</li><li><strong>Editor Tech Lead:</strong>&nbsp;Riad Benguella (<a href=\'https://profiles.wordpress.org/youknowriad/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>youknowriad</a>)</li><li><strong>Marketing and Communications Lead:</strong> Josepha Haden Chomphosy (<a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>)</li><li><strong>Documentation Lead:</strong> Milana Cap (<a href=\'https://profiles.wordpress.org/milana_cap/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>milana_cap</a>)</li><li><strong>Test Lead:</strong>&nbsp;Piotrek Boniu (<a href=\'https://profiles.wordpress.org/boniu91/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>boniu91</a>)</li><li><strong>Support Lead:&nbsp;</strong>Mary Job (<a href=\'https://profiles.wordpress.org/mariaojob/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mariaojob</a>)</li></ul>\n\n\n\n<p>This release is the reflection of the hard work of 530 generous volunteer contributors. Collaboration occurred on over <a href=\"https://core.trac.wordpress.org/query?milestone=5.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">320 tickets on Trac</a> and over <a href=\"https://github.com/wordpress/gutenberg/compare/v10.0.0...v10.7.0\">1,500 pull requests on GitHub</a>.</p>\n\n\n\n<a href=\"https://profiles.wordpress.org/2linctools/\">2linctools</a>, <a href=\"https://profiles.wordpress.org/5ubliminal/\">5ubliminal</a>, <a href=\"https://profiles.wordpress.org/ninetyninew/\">99w</a>, <a href=\"https://profiles.wordpress.org/9primus/\">9primus</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a>, <a href=\"https://profiles.wordpress.org/abderrahman/\">abderrahman</a>, <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a>, <a href=\"https://profiles.wordpress.org/abhijitrakas/\">Abhijit Rakas</a>, <a href=\"https://profiles.wordpress.org/achbed/\">achbed</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zielinski</a>, <a href=\"https://profiles.wordpress.org/addiestavlo/\">Addie</a>, <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a>, <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a>, <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a>, <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a>, <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a>, <a href=\"https://profiles.wordpress.org/alanjacobmathew/\">Alan Jacob Mathew</a>, <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juh&#233; Lluveras</a>, <a href=\"https://profiles.wordpress.org/aleperez92/\">Alejandro Perez</a>, <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/akirk/\">Alex Kirk</a>, <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a>, <a href=\"https://profiles.wordpress.org/alexstine/\">alexstine</a>, <a href=\"https://profiles.wordpress.org/algala/\">AlGala</a>, <a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a>, <a href=\"https://profiles.wordpress.org/amandariu/\">Amanda Riu</a>, <a href=\"https://profiles.wordpress.org/amarinediary/\">amarinediary</a>, <a href=\"https://profiles.wordpress.org/gadgetroid/\">Amogh Harish</a>, <a href=\"https://profiles.wordpress.org/oandregal/\">Andr&#233;</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a>, <a href=\"https://profiles.wordpress.org/rarst/\">Andrey \"Rarst\" Savchenko</a>, <a href=\"https://profiles.wordpress.org/nosolosw/\">André Maneiro</a>, <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a>, <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a>, <a href=\"https://profiles.wordpress.org/andy/\">Andy Skelton</a>, <a href=\"https://profiles.wordpress.org/wpgurudev/\">Ankit Gade</a>, <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a>, <a href=\"https://profiles.wordpress.org/annalamprou/\">annalamprou</a>, <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a>, <a href=\"https://profiles.wordpress.org/anotherdave/\">anotherdave</a>, <a href=\"https://profiles.wordpress.org/anotia/\">anotia</a>, <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a>, <a href=\"https://profiles.wordpress.org/antonlukin/\">Anton Lukin</a>, <a href=\"https://profiles.wordpress.org/vanyukov/\">Anton Vanyukov</a>, <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a>, <a href=\"https://profiles.wordpress.org/antonisme/\">Antonis Lilis</a>, <a href=\"https://profiles.wordpress.org/apedog/\">apedog</a>, <a href=\"https://profiles.wordpress.org/apokalyptik/\">apokalyptik</a>, <a href=\"https://profiles.wordpress.org/arena/\">arena</a>, <a href=\"https://profiles.wordpress.org/lephleg/\">Argyris Margaritis</a>, <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a>, <a href=\"https://profiles.wordpress.org/ariskataoka/\">ariskataoka</a>, <a href=\"https://profiles.wordpress.org/arkrs/\">arkrs</a>, <a href=\"https://profiles.wordpress.org/aruphi/\">Armand</a>, <a href=\"https://profiles.wordpress.org/arnaudban/\">ArnaudBan</a>, <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a>, <a href=\"https://profiles.wordpress.org/arunsathiya/\">Arun</a>, <a href=\"https://profiles.wordpress.org/aspexi/\">Aspexi</a>, <a href=\"https://profiles.wordpress.org/atjn/\">atjn</a>, <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a>, <a href=\"https://profiles.wordpress.org/filosofo/\">Austin Matzko</a>, <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a>, <a href=\"https://profiles.wordpress.org/barry/\">Barry</a>, <a href=\"https://profiles.wordpress.org/bartkalisz/\">bartkalisz</a>, <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a>, <a href=\"https://profiles.wordpress.org/pixolin/\">Bego Mario Garde</a>, <a href=\"https://profiles.wordpress.org/utz119/\">Benachi</a>, <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a>, <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">Bernhard Reiter</a>, <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a>, <a href=\"https://profiles.wordpress.org/blobfolio/\">Blobfolio</a>, <a href=\"https://profiles.wordpress.org/bmcculley/\">bmcculley</a>, <a href=\"https://profiles.wordpress.org/boblinthorst/\">Bob Linthorst</a>, <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a>, <a href=\"https://profiles.wordpress.org/bogdanpreda/\">Bogdan Preda</a>, <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/bradt/\">Brad Touesnard</a>, <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/brechtvds/\">Brecht</a>, <a href=\"https://profiles.wordpress.org/brentswisher/\">Brent Swisher</a>, <a href=\"https://profiles.wordpress.org/brettshumaker/\">Brett Shumaker</a>, <a href=\"https://profiles.wordpress.org/ribaricplusplus/\">Bruno Ribaric</a>, <a href=\"https://profiles.wordpress.org/burhandodhy/\">Burhan Nasir</a>, <a href=\"https://profiles.wordpress.org/cameronjonesweb/\">Cameron Jones</a>, <a href=\"https://profiles.wordpress.org/cvoell/\">Cameron Voell</a>, <a href=\"https://profiles.wordpress.org/carike/\">Carike</a>, <a href=\"https://profiles.wordpress.org/carlalexander/\">Carl Alexander</a>, <a href=\"https://profiles.wordpress.org/carlomanf/\">carlomanf</a>, <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos Garcia Prim</a>, <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/caseymilne/\">Casey Milne</a>, <a href=\"https://profiles.wordpress.org/cenay/\">Cenay Nailor</a>, <a href=\"https://profiles.wordpress.org/ceyhun0/\">Ceyhun Ozugur</a>, <a href=\"https://profiles.wordpress.org/nhuja/\">Chandra M</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/chintan1896/\">Chintan hingrajiya</a>, <a href=\"https://profiles.wordpress.org/chipsnyder/\">Chip Snyder</a>, <a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a>, <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a>, <a href=\"https://profiles.wordpress.org/chrisvanpatten/\">Chris Van Patten</a>, <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a>, <a href=\"https://profiles.wordpress.org/vimes1984/\">Christopher Churchill</a>, <a href=\"https://profiles.wordpress.org/ryno267/\">Chuck Reynolds</a>, <a href=\"https://profiles.wordpress.org/claytoncollie/\">Clayton Collie</a>, <a href=\"https://profiles.wordpress.org/codeamp/\">Code Amp</a>, <a href=\"https://profiles.wordpress.org/design_dolphin/\">CodePoet</a>, <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a>, <a href=\"https://profiles.wordpress.org/collizo4sky/\">Collins Agbonghama</a>, <a href=\"https://profiles.wordpress.org/copons/\">Copons</a>, <a href=\"https://profiles.wordpress.org/coreymckrill/\">Corey McKrill</a>, <a href=\"https://profiles.wordpress.org/cr0ybot/\">Cory Hughart</a>, <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Engle Robertson</a>, <a href=\"https://profiles.wordpress.org/crazycoders/\">crazycoders</a>, <a href=\"https://profiles.wordpress.org/critterverse/\">critterverse</a>, <a href=\"https://profiles.wordpress.org/czapla/\">czapla</a>, <a href=\"https://profiles.wordpress.org/davidszabo/\">D&#225;vid Szab&#243;</a>, <a href=\"https://profiles.wordpress.org/daisyo/\">Daisy Olsen</a>, <a href=\"https://profiles.wordpress.org/damonganto/\">damonganto</a>, <a href=\"https://profiles.wordpress.org/danfarrow/\">Dan Farrow</a>, <a href=\"https://profiles.wordpress.org/diddledan/\">Dani Llewellyn</a>, <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a>, <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a>, <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a>, <a href=\"https://profiles.wordpress.org/vetyst/\">Danny</a>, <a href=\"https://profiles.wordpress.org/dariak/\">Daria</a>, <a href=\"https://profiles.wordpress.org/davilera/\">David Aguilera</a>, <a href=\"https://profiles.wordpress.org/davidanderson/\">David Anderson</a>, <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a>, <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/davidkryzaniak/\">David Kryzaniak</a>, <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>, <a href=\"https://profiles.wordpress.org/dekervit/\">dekervit</a>, <a href=\"https://profiles.wordpress.org/devle/\">devfle</a>, <a href=\"https://profiles.wordpress.org/devrekli/\">devrekli</a>, <a href=\"https://profiles.wordpress.org/dhruvkb/\">dhruvkb</a>, <a href=\"https://profiles.wordpress.org/dianeco/\">Diane Co</a>, <a href=\"https://profiles.wordpress.org/dingdang/\">dingdang</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/djbu/\">djbu</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/donmhico/\">donmhico</a>, <a href=\"https://profiles.wordpress.org/donnapep/\">Donna Peplinskie</a>, <a href=\"https://profiles.wordpress.org/dougwollison/\">Doug Wollison</a>, <a href=\"https://profiles.wordpress.org/dpik/\">dpik</a>, <a href=\"https://profiles.wordpress.org/dragongate/\">dragongate</a>, <a href=\"https://profiles.wordpress.org/drebbitsweb/\">Dreb Bits</a>, <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/eatsleepcode/\">eatsleepcode</a>, <a href=\"https://profiles.wordpress.org/metalandcoffee/\">Ebonie Butler</a>, <a href=\"https://profiles.wordpress.org/ediamin/\">Edi Amin</a>, <a href=\"https://profiles.wordpress.org/itsjusteileen/\">Eileen Violini</a>, <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a>, <a href=\"https://profiles.wordpress.org/aliveic/\">Emil E</a>, <a href=\"https://profiles.wordpress.org/emarticor/\">Emilio Martinez</a>, <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a>, <a href=\"https://profiles.wordpress.org/empatogen/\">empatogen</a>, <a href=\"https://profiles.wordpress.org/enchiridion/\">Enchiridion</a>, <a href=\"https://profiles.wordpress.org/enej/\">Enej Bajgorić</a>, <a href=\"https://profiles.wordpress.org/nrqsnchz/\">Enrique S&#225;nchez</a>, <a href=\"https://profiles.wordpress.org/epiqueras/\">epiqueras</a>, <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a>, <a href=\"https://profiles.wordpress.org/etoledom/\">etoledom</a>, <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a>, <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian K&#228;gy</a>, <a href=\"https://profiles.wordpress.org/fabianpimminger/\">Fabian Pimminger</a>, <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a>, <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/felixbaumgaertner/\">felixbaumgaertner</a>, <a href=\"https://profiles.wordpress.org/femkreations/\">Femy Praseeth</a>, <a href=\"https://profiles.wordpress.org/fijisunshine/\">fijisunshine</a>, <a href=\"https://profiles.wordpress.org/florianbrinkmann/\">Florian Brinkmann</a>, <a href=\"https://profiles.wordpress.org/mista-flo/\">Florian TIAR</a>, <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a>, <a href=\"https://profiles.wordpress.org/bueltge/\">Frank Bueltge</a>, <a href=\"https://profiles.wordpress.org/frosso1/\">frosso1 (a11n)</a>, <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">fullofcaffeine</a>, <a href=\"https://profiles.wordpress.org/gab81/\">gab81</a>, <a href=\"https://profiles.wordpress.org/galbaras/\">Gal Baras</a>, <a href=\"https://profiles.wordpress.org/kafleg/\">Ganga Kafle</a>, <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a>, <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/geekpress/\">GeekPress</a>, <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a>, <a href=\"https://profiles.wordpress.org/geoffrey1963/\">Geoffrey</a>, <a href=\"https://profiles.wordpress.org/revgeorge/\">George Hotelling</a>, <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/geriux/\">geriux</a>, <a href=\"https://profiles.wordpress.org/glendaviesnz/\">glendaviesnz</a>, <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a>, <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/gregorlove/\">gRegor Morrill</a>, <a href=\"https://profiles.wordpress.org/priethor/\">H&#233;ctor Prieto</a>, <a href=\"https://profiles.wordpress.org/hannahmalcolm/\">Hannah Malcolm</a>, <a href=\"https://profiles.wordpress.org/happiryu/\">happiryu</a>, <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh</a>, <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a>, <a href=\"https://profiles.wordpress.org/hedgefield/\">hedgefield</a>, <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandí</a>, <a href=\"https://profiles.wordpress.org/hermpheus/\">Herm Martini</a>, <a href=\"https://profiles.wordpress.org/herregroen/\">Herre Groen</a>, <a href=\"https://profiles.wordpress.org/herrvigg/\">herrvigg</a>, <a href=\"https://profiles.wordpress.org/htmgarcia/\">htmgarcia</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianmjones/\">ianmjones</a>, <a href=\"https://profiles.wordpress.org/icopydoc/\">icopydoc</a>, <a href=\"https://profiles.wordpress.org/ipstenu/\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a>, <a href=\"https://profiles.wordpress.org/dragunoff/\">Ivaylo Draganov</a>, <a href=\"https://profiles.wordpress.org/wphound/\">Ivete Tecedor</a>, <a href=\"https://profiles.wordpress.org/jdgrimes/\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jacklenox/\">Jack Lenox</a>, <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a>, <a href=\"https://profiles.wordpress.org/jamesbonham/\">James Bonham</a>, <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a>, <a href=\"https://profiles.wordpress.org/jnylen0/\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/pondermatic/\">James Richards</a>, <a href=\"https://profiles.wordpress.org/jamesros161/\">James Rosado</a>, <a href=\"https://profiles.wordpress.org/jamil95/\">jamil95</a>, <a href=\"https://profiles.wordpress.org/janak007/\">janak Kaneriya</a>, <a href=\"https://profiles.wordpress.org/janwoostendorp/\">janw.oostendorp</a>, <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a>, <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a>, <a href=\"https://profiles.wordpress.org/jaymanpandya/\">Jayman Pandya</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a>, <a href=\"https://profiles.wordpress.org/jblz/\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a>, <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a>, <a href=\"https://profiles.wordpress.org/jeffikus/\">Jeffrey Pearce</a>, <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a>, <a href=\"https://profiles.wordpress.org/jeremyyip/\">Jeremy Yip</a>, <a href=\"https://profiles.wordpress.org/jeremy80/\">jeremy80</a>, <a href=\"https://profiles.wordpress.org/jeroenreumkens/\">JeroenReumkens</a>, <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a>, <a href=\"https://profiles.wordpress.org/jillebehm/\">jillebehm</a>, <a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a>, <a href=\"https://profiles.wordpress.org/sephsekla/\">Joe Bailey-Roberts</a>, <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a>, <a href=\"https://profiles.wordpress.org/jonkastonka/\">Johan Jonk Stenstr&#246;m</a>, <a href=\"https://profiles.wordpress.org/goaroundagain/\">Johannes Kinast</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/bhwebworks/\">John Sundberg</a>, <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a>, <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/jonoaldersonwp/\">Jono Alderson</a>, <a href=\"https://profiles.wordpress.org/joostdevalk/\">Joost de Valk</a>, <a href=\"https://profiles.wordpress.org/koke/\">Jorge Bernal</a>, <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a>, <a href=\"https://profiles.wordpress.org/joseeyoast/\">Josee Wouters</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden</a>, <a href=\"https://profiles.wordpress.org/dkampdesign/\">JoshuaDoshua</a>, <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a>, <a href=\"https://profiles.wordpress.org/jsnajdr/\">jsnajdr</a>, <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a>, <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a>, <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a>, <a href=\"https://profiles.wordpress.org/juliobox/\">Julio Potier</a>, <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a>, <a href=\"https://profiles.wordpress.org/k3nsai/\">k3nsai</a>, <a href=\"https://profiles.wordpress.org/kaavyaiyer/\">kaavyaiyer</a>, <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a>, <a href=\"https://profiles.wordpress.org/akabarikalpesh/\">Kalpesh Akabari</a>, <a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a>, <a href=\"https://profiles.wordpress.org/vyskoczilova/\">Karolina Vyskocilova</a>, <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a>, <a href=\"https://profiles.wordpress.org/kellychoffman/\">Kelly Hoffman</a>, <a href=\"https://profiles.wordpress.org/gwwar/\">Kerry Liu</a>, <a href=\"https://profiles.wordpress.org/kevinfodness/\">Kevin Fodness</a>, <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a>, <a href=\"https://profiles.wordpress.org/ixkaito/\">Kite</a>, <a href=\"https://profiles.wordpress.org/kittmedia/\">KittMedia</a>, <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a>, <a href=\"https://profiles.wordpress.org/klevyke/\">klevyke</a>, <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a>, <a href=\"https://profiles.wordpress.org/vdwijngaert/\">Koen Van den Wijngaert</a>, <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a>, <a href=\"https://profiles.wordpress.org/devnel/\">Kyle Nel</a>, <a href=\"https://profiles.wordpress.org/lakrisgubben/\">lakrisgubben</a>, <a href=\"https://profiles.wordpress.org/notlaura/\">Lara Schenck</a>, <a href=\"https://profiles.wordpress.org/lmurillom/\">Larissa Murillo</a>, <a href=\"https://profiles.wordpress.org/laxman-prajapati/\">Laxman Prajapati</a>, <a href=\"https://profiles.wordpress.org/lewiscowles/\">LewisCowles</a>, <a href=\"https://profiles.wordpress.org/lifeforceinst/\">lifeforceinst</a>, <a href=\"https://profiles.wordpress.org/linux4me2/\">linux4me2</a>, <a href=\"https://profiles.wordpress.org/lovor/\">Lovro Hrust</a>, <a href=\"https://profiles.wordpress.org/displaynone/\">Luis Sacrist&#225;n</a>, <a href=\"https://profiles.wordpress.org/infolu/\">Luiz Ara&#250;jo</a>, <a href=\"https://profiles.wordpress.org/lukecarbis/\">Luke Carbis</a>, <a href=\"https://profiles.wordpress.org/m0ze/\">m0ze</a>, <a href=\"https://profiles.wordpress.org/maedahbatool/\">Maedah Batool</a>, <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a>, <a href=\"https://profiles.wordpress.org/travel_girl/\">Maja Benke</a>, <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a>, <a href=\"https://profiles.wordpress.org/mkaz/\">Marcus Kazmierczak</a>, <a href=\"https://profiles.wordpress.org/marekhrabe/\">Marek Hrabe</a>, <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/markparnell/\">Mark Parnell</a>, <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a>, <a href=\"https://profiles.wordpress.org/markoheijnen/\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/m-e-h/\">Marty Helmick</a>, <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a>, <a href=\"https://profiles.wordpress.org/mariaojob/\">Mary Job</a>, <a href=\"https://profiles.wordpress.org/marylauc/\">marylauc</a>, <a href=\"https://profiles.wordpress.org/imath/\">Mathieu Viet</a>, <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a>, <a href=\"https://profiles.wordpress.org/mhuntdesign/\">Matt</a>, <a href=\"https://profiles.wordpress.org/mattchowning/\">Matt Chowning</a>, <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a>, <a href=\"https://profiles.wordpress.org/mblach/\">mblach</a>, <a href=\"https://profiles.wordpress.org/immeet94/\">Meet Makadia</a>, <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a>, <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a>, <a href=\"https://profiles.wordpress.org/meloniq/\">meloniq</a>, <a href=\"https://profiles.wordpress.org/mensmaximus/\">mensmaximus</a>, <a href=\"https://profiles.wordpress.org/mdawaffe/\">Michael Adams (mdawaffe)</a>, <a href=\"https://profiles.wordpress.org/mbabker/\">Michael Babker</a>, <a href=\"https://profiles.wordpress.org/tw2113/\">Michael Beckwith</a>, <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a>, <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a>, <a href=\"https://profiles.wordpress.org/mikehansenme/\">Mike Hansen</a>, <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley</a>, <a href=\"https://profiles.wordpress.org/mike_cowobo/\">Mike Martel</a>, <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/mihdan/\">Mikhail Kobzarev</a>, <a href=\"https://profiles.wordpress.org/dimadin/\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a>, <a href=\"https://profiles.wordpress.org/mkdgs/\">mkdgs</a>, <a href=\"https://profiles.wordpress.org/mmuyskens/\">mmuyskens</a>, <a href=\"https://profiles.wordpress.org/mmxxi/\">mmxxi</a>, <a href=\"https://profiles.wordpress.org/moch11/\">moch11</a>, <a href=\"https://profiles.wordpress.org/daddou/\">Mohamed El Amine DADDOU</a>, <a href=\"https://profiles.wordpress.org/mohamedfaragallah/\">Mohammed Faragallah</a>, <a href=\"https://profiles.wordpress.org/monikarao/\">Monika Rao</a>, <a href=\"https://profiles.wordpress.org/mor10/\">Morten Rand-Hendriksen</a>, <a href=\"https://profiles.wordpress.org/mrjoeldean/\">mrjoeldean</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/munyagu/\">munyagu</a>, <a href=\"https://profiles.wordpress.org/m_uysl/\">Mustafa Uysal</a>, <a href=\"https://profiles.wordpress.org/mweichert/\">mweichert</a>, <a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir</a>, <a href=\"https://profiles.wordpress.org/nalininonstopnewsuk/\">Nalini Thakor</a>, <a href=\"https://profiles.wordpress.org/naoki0h/\">Naoki Ohashi</a>, <a href=\"https://profiles.wordpress.org/nao/\">Naoko Takano</a>, <a href=\"https://profiles.wordpress.org/nayanchamp7/\">Nazrul Islam Nayan</a>, <a href=\"https://profiles.wordpress.org/dway/\">nderambure</a>, <a href=\"https://profiles.wordpress.org/krstarica/\">net</a>, <a href=\"https://profiles.wordpress.org/nicegamer7/\">nicegamer7</a>, <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a>, <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a>, <a href=\"https://profiles.wordpress.org/ninanmnm/\">ninanmnm</a>, <a href=\"https://profiles.wordpress.org/pianist787/\">Noah Allen</a>, <a href=\"https://profiles.wordpress.org/nvartolomei/\">nvartolomei</a>, <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a>, <a href=\"https://profiles.wordpress.org/olafklejnstrupjensen/\">olafklejnstrupjensen</a>, <a href=\"https://profiles.wordpress.org/olgabulat/\">Olga Bulat</a>, <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>, <a href=\"https://profiles.wordpress.org/otshelnik-fm/\">Otshelnik-Fm</a>, <a href=\"https://profiles.wordpress.org/oxyrealm/\">oxyrealm</a>, <a href=\"https://profiles.wordpress.org/ozh/\">Ozh</a>, <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a>, <a href=\"https://profiles.wordpress.org/palmiak/\">palmiak</a>, <a href=\"https://profiles.wordpress.org/paaggeli/\">Panagiotis Angelidis</a>, <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/fantasy1125/\">Pascal Knecht</a>, <a href=\"https://profiles.wordpress.org/patkemper/\">Pat</a>, <a href=\"https://profiles.wordpress.org/patricklindsay/\">patricklindsay</a>, <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a>, <a href=\"https://profiles.wordpress.org/pabline/\">Paul Bunkham</a>, <a href=\"https://profiles.wordpress.org/paulschreiber/\">Paul Schreiber</a>, <a href=\"https://profiles.wordpress.org/paulstonier/\">Paul Stonier</a>, <a href=\"https://profiles.wordpress.org/pschrottky/\">Paul Von Schrottky</a>, <a href=\"https://profiles.wordpress.org/psrpinto/\">Paulo Pinto</a>, <a href=\"https://profiles.wordpress.org/pavelvisualcomposer/\">Pavel I</a>, <a href=\"https://profiles.wordpress.org/mrpauloen/\">Paweł</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/walbo/\">Petter Walbø Johnsgård</a>, <a href=\"https://profiles.wordpress.org/phena109/\">phena109</a>, <a href=\"https://profiles.wordpress.org/philipmjackson/\">Philip Jackson</a>, <a href=\"https://profiles.wordpress.org/strategio/\">Pierre SYLVESTRE</a>, <a href=\"https://profiles.wordpress.org/wppinar/\">Pinar</a>, <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a>, <a href=\"https://profiles.wordpress.org/mordauk/\">Pippin Williamson</a>, <a href=\"https://profiles.wordpress.org/ptahdunbar/\">Pirate Dunbar</a>, <a href=\"https://profiles.wordpress.org/promz/\">Pramod Jodhani</a>, <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a>, <a href=\"https://profiles.wordpress.org/psealock/\">psealock</a>, <a href=\"https://profiles.wordpress.org/pwallner/\">pwallner</a>, <a href=\"https://profiles.wordpress.org/pyronaur/\">pyronaur</a>, <a href=\"https://profiles.wordpress.org/itsjonq/\">Q</a>, <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/radixweb/\">Radixweb</a>, <a href=\"https://profiles.wordpress.org/rafaelgalani/\">Rafael Galani</a>, <a href=\"https://profiles.wordpress.org/rafhun/\">rafhun</a>, <a href=\"https://profiles.wordpress.org/rtm909/\">Rahul Mehta</a>, <a href=\"https://profiles.wordpress.org/rkradadiya/\">Rajesh Radadiya</a>, <a href=\"https://profiles.wordpress.org/ramiy/\">Rami Yushuvaev</a>, <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a>, <a href=\"https://profiles.wordpress.org/ramonopoly/\">ramonopoly</a>, <a href=\"https://profiles.wordpress.org/jontyravi/\">Ravi Vaghela</a>, <a href=\"https://profiles.wordpress.org/ravipatel/\">ravipatel</a>, <a href=\"https://profiles.wordpress.org/rellect/\">Refael Iliaguyev</a>, <a href=\"https://profiles.wordpress.org/renehermi/\">Rene Hermenau</a>, <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a>, <a href=\"https://profiles.wordpress.org/reynhartono/\">reynhartono</a>, <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/rianrietveld/\">Rian Rietveld</a>, <a href=\"https://profiles.wordpress.org/rima1889/\">Rima Prajapati</a>, <a href=\"https://profiles.wordpress.org/rinatkhaziev/\">Rinat</a>, <a href=\"https://profiles.wordpress.org/rnaby/\">Rnaby</a>, <a href=\"https://profiles.wordpress.org/robdxw/\">robdxw</a>, <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a>, <a href=\"https://profiles.wordpress.org/miqrogroove/\">Robert Chapin</a>, <a href=\"https://profiles.wordpress.org/kreppar/\">Rodrigo Arias</a>, <a href=\"https://profiles.wordpress.org/rogertheriault/\">Roger Theriault</a>, <a href=\"https://profiles.wordpress.org/rogerlos/\">rogerlos</a>, <a href=\"https://profiles.wordpress.org/roo2/\">roo2</a>, <a href=\"https://profiles.wordpress.org/lev0/\">Roy</a>, <a href=\"https://profiles.wordpress.org/geekstreetwp/\">Russell Aaron</a>, <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">S&#233;rgio Gomes</a>, <a href=\"https://profiles.wordpress.org/soean/\">S&#246;ren Wrede</a>, <a href=\"https://profiles.wordpress.org/stodorovic/\">Sa&#353;a</a>, <a href=\"https://profiles.wordpress.org/sabrinazeidan/\">Sabrina Zeidan</a>, <a href=\"https://profiles.wordpress.org/sahilmepani/\">Sahil Mepani</a>, <a href=\"https://profiles.wordpress.org/solarissmoke/\">Samir Shah</a>, <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a>, <a href=\"https://profiles.wordpress.org/sandipmondal/\">Sandip Mondal</a>, <a href=\"https://profiles.wordpress.org/sanketchodavadiya/\">Sanket Chodavadiya</a>, <a href=\"https://profiles.wordpress.org/sannevndrmeulen/\">Sanne van der Meulen</a>, <a href=\"https://profiles.wordpress.org/sarahricker/\">sarahricker</a>, <a href=\"https://profiles.wordpress.org/sarayourfriend/\">sarayourfriend</a>, <a href=\"https://profiles.wordpress.org/sasagar/\">SASAPIYO</a>, <a href=\"https://profiles.wordpress.org/satrancali/\">satrancali</a>, <a href=\"https://profiles.wordpress.org/savicmarko1985/\">savicmarko1985</a>, <a href=\"https://profiles.wordpress.org/gmagicscott/\">Scott Lesovic</a>, <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/scottconnerly/\">scottconnerly</a>, <a href=\"https://profiles.wordpress.org/scruffian/\">scruffian</a>, <a href=\"https://profiles.wordpress.org/sean212/\">Sean Fisher</a>, <a href=\"https://profiles.wordpress.org/seanchayes/\">Sean Hayes</a>, <a href=\"https://profiles.wordpress.org/sebbb/\">sebbb</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/yakimun/\">Sergey Yakimov</a>, <a href=\"https://profiles.wordpress.org/sergioestevao/\">SergioEstevao</a>, <a href=\"https://profiles.wordpress.org/shaunandrews/\">shaunandrews</a>, <a href=\"https://profiles.wordpress.org/shital-patel/\">Shital Marakana</a>, <a href=\"https://profiles.wordpress.org/silb3r/\">silb3r</a>, <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a>, <a href=\"https://profiles.wordpress.org/sirstuey/\">SirStuey</a>, <a href=\"https://profiles.wordpress.org/snapfractalpop/\">snapfractalpop</a>, <a href=\"https://profiles.wordpress.org/spikeuk1/\">spikeuk1</a>, <a href=\"https://profiles.wordpress.org/spytzo/\">spytzo</a>, <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a>, <a href=\"https://profiles.wordpress.org/khromov/\">Stanislav Khromov</a>, <a href=\"https://profiles.wordpress.org/deustron/\">Stefan H&#252;sges</a>, <a href=\"https://profiles.wordpress.org/stefanjoebstl/\">stefanjoebstl</a>, <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a>, <a href=\"https://profiles.wordpress.org/hypest/\">Stefanos Togoulidis</a>, <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/dufresnesteven/\">Steve Dufresne</a>, <a href=\"https://profiles.wordpress.org/stevegrunwell/\">Steve Grunwell</a>, <a href=\"https://profiles.wordpress.org/stevehenty/\">Steve Henty</a>, <a href=\"https://profiles.wordpress.org/stevenkword/\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a>, <a href=\"https://profiles.wordpress.org/sumaiyasiddika/\">Sumaiya Siddika</a>, <a href=\"https://profiles.wordpress.org/sumanm/\">Suman</a>, <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a>, <a href=\"https://profiles.wordpress.org/5um17/\">Sumit Singh</a>, <a href=\"https://profiles.wordpress.org/quadthemes/\">Sunny</a>, <a href=\"https://profiles.wordpress.org/sushmak/\">sushmak</a>, <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a>, <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a>, <a href=\"https://profiles.wordpress.org/szaqal21/\">szaqal21</a>, <a href=\"https://profiles.wordpress.org/tamlyn/\">tamlyn</a>, <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/tellyworth/\">Tellyworth</a>, <a href=\"https://profiles.wordpress.org/terraling/\">terraling</a>, <a href=\"https://profiles.wordpress.org/terriann/\">Terri Ann</a>, <a href=\"https://profiles.wordpress.org/wildworks/\">Tetsuaki Hamano</a>, <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a>, <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kr&#228;ftner</a>, <a href=\"https://profiles.wordpress.org/thomasplevy/\">Thomas Patrick Levy</a>, <a href=\"https://profiles.wordpress.org/thomas-vitale/\">Thomas Vitale</a>, <a href=\"https://profiles.wordpress.org/tigertech/\">tigertech</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/timotijhof/\">TimoTijhof</a>, <a href=\"https://profiles.wordpress.org/tkama/\">Tkama</a>, <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a>, <a href=\"https://profiles.wordpress.org/tmdk/\">tmdk</a>, <a href=\"https://profiles.wordpress.org/tz-media/\">Tobias Zimpel</a>, <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a>, <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a>, <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a>, <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemer&#246;</a>, <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a>, <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/torres126/\">torres126</a>, <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a>, <a href=\"https://profiles.wordpress.org/toru/\">Toru Miki</a>, <a href=\"https://profiles.wordpress.org/travisnorthcutt/\">Travis Northcutt</a>, <a href=\"https://profiles.wordpress.org/trejder/\">trejder</a>, <a href=\"https://profiles.wordpress.org/desaiuditd/\">Udit Desai</a>, <a href=\"https://profiles.wordpress.org/grapplerulrich/\">Ulrich</a>, <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a>, <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a>, <a href=\"https://profiles.wordpress.org/vipulc2/\">Vipul Chandel</a>, <a href=\"https://profiles.wordpress.org/vladytimy/\">Vlad T</a>, <a href=\"https://profiles.wordpress.org/wangql/\">wangql</a>, <a href=\"https://profiles.wordpress.org/wb1234/\">wb1234</a>, <a href=\"https://profiles.wordpress.org/webdragon/\">WebDragon</a>, <a href=\"https://profiles.wordpress.org/wendyjchen/\">Wendy Chen</a>, <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/wfmattr/\">WFMattR</a>, <a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a>, <a href=\"https://profiles.wordpress.org/xavivars/\">Xavi Ivars</a>, <a href=\"https://profiles.wordpress.org/tikifez/\">Xristopher Anderton</a>, <a href=\"https://profiles.wordpress.org/y_kolev/\">Y_Kolev</a>, <a href=\"https://profiles.wordpress.org/yansern/\">Yan Sern</a>, <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a>, <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a>, <a href=\"https://profiles.wordpress.org/yvettesonneveld/\">Yvette Sonneveld</a>, <a href=\"https://profiles.wordpress.org/zackkrida/\">Zack Krida</a>, <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a>, <a href=\"https://profiles.wordpress.org/zkancs/\">zkancs</a>, and <a href=\"https://profiles.wordpress.org/sunxiyuan/\">孙锡源</a>.\n\n\n\n<p></p>\n\n\n\n<p>In addition to these contributors, many thanks to all of the community volunteers who contribute in the&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://wordpress.org/support/\">support forums</a>. They answer questions from people across the world, whether they are using WordPress for the first time, or they’ve been around since the first release all the way back in 2003. These releases are as successful as they are because of their efforts!</p>\n\n\n\n<p>Finally, thanks to all the community translators who help make WordPress available in over 200 languages for every release. 80 languages have translated 80{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9} or more WordPress 5.8 and our community translators are hard at work ensuring more languages are on their way. If contributing to WordPress appeals to you, it’s easy to learn more. Check out&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://make.wordpress.org/\">Make WordPress</a>&nbsp;or the&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://make.wordpress.org/core/\">core development blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"10976\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:58:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"WP Briefing: Episode 13: Cherishing WordPress Diversity\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://wordpress.org/news/2021/07/episode-13-cherishing-wordpress-diversity/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 19 Jul 2021 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=10949\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:357:\"In this episode, Josepha Haden Chomphosy discusses the importance of Diversity, Equity, and Inclusion to the fabric of the WordPress project and how we can move from a place of welcoming it to cherishing it. Have a question you&#8217;d like answered? You can submit them to wpbriefing@wordpress.org, either written or as a voice recording. Credits [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2021/07/WP-Briefing-013.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chloe Bringmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:14890:\"\n<p>In this episode, Josepha Haden Chomphosy discusses the importance of Diversity, Equity, and Inclusion to the fabric of the WordPress project and how we can move from a place of welcoming it to cherishing it.</p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2>Credits</h2>\n\n\n\n<p>Editor: <a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a></p>\n\n\n\n<p>Logo: <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></p>\n\n\n\n<p>Production: <a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a></p>\n\n\n\n<p>Song: Fearless First by Kevin MacLeod</p>\n\n\n\n<h2>References</h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/diversity-speaker-training-workshop/\">Diverse Speaker Training Workshop</a></p>\n\n\n\n<p><a href=\"https://josepha.blog/2020/12/23/a-wordpress-dinner-party/\">A WordPress Dinner Party</a></p>\n\n\n\n<p><a href=\"https://josepha.blog/2018/11/06/the-burden-of-proof/\">The Burden of Proof</a></p>\n\n\n\n<p><a href=\"https://josepha.blog/2021/03/05/leading-at-any-level/\">Leadership At Any Level</a></p>\n\n\n\n<p><a href=\"https://josepha.blog/2019/03/02/building-a-culture-of-safety/\">Building a Culture of Safety</a></p>\n\n\n\n<p><a href=\"https://josepha.blog/2020/03/27/leadership-basics-ethics-in-communication/\">Leadership Basics: Ethics in Communication</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/support/wordpress-version/version-5-6/\">WordPress 5.6</a></p>\n\n\n\n<p>Bonus resource: <a href=\"https://allienimmons.com/how-to-be-a-wordpress-ally/\">How to Be a WordPress Ally</a></p>\n\n\n\n<h2>Transcript</h2>\n\n\n\n<span id=\"more-10949\"></span>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>00:10</p>\n\n\n\n<p>Hello, everyone, and welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. And before we get started, I have to be honest with you all, this episode and the next one have made me feel really anxious. This one is about Diversity, Equity, and Inclusion in open source, and especially in WordPress. And the next one is about accessibility in WordPress. And I feel like there&#8217;s just so much to do, and we don&#8217;t do enough, but we do what we can. And still, we will never be done with that work. And if you don&#8217;t know what I mean by Diversity, Equity, and Inclusion, you can kind of think of it this way. Diversity is bringing in people with different viewpoints and lived experiences. Equity is making sure everyone has what they need to get a fair chance of success, which is different from equality. And Inclusion is making sure that the environment is built to not only tolerate diverse groups but to celebrate them as well. So remember this as you listen to what I have to say here. We are never where we want to be in either of those spaces. But that shouldn&#8217;t stop us from looking at the things we have done to get us in the right direction. All right. Here we go.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>01:54</p>\n\n\n\n<p>I say a lot that we are a project that serves a majority collection of minority voices. WordPress is global in reach and open source in nature. And you would assume that what allows the software to be used by anyone would also enable it to be built by anyone. After all, your location doesn&#8217;t matter, and who employs you also doesn&#8217;t matter. And your relative social standing certainly shouldn&#8217;t matter. As long as you can communicate with the others contributing to the project, there should be no obstacle to your participation. The mission of the WordPress project is to democratize publishing, right? It&#8217;s to get the ability to have a website tap into passive income on your web presence. I mean, the job is to level the playing field for everyone. However, it&#8217;s my experience that bringing in new voices takes a lot of proactive work on behalf of leaders and contributors. It&#8217;s not enough to say, &#8220;Hey, I&#8217;m having a party,&#8221; you also have to say, &#8220;I&#8217;m having a party, and I&#8217;d like you to be there.&#8221; It&#8217;s not enough to think people will make their own space at this table. You have to make sure that you have table settings for everyone. And even beyond the basics of directing people to you.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>03:12</p>\n\n\n\n<p>And on toward the next steps, you have to be honest about the fact that open source contribution requires a fair amount of privilege. By privilege, I mean the luxury of extra time or extra funding or just an understanding employer. WordPress supports 41{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9} of the web. I think it&#8217;s 42{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9} of the web right now. But less than 1{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9} of people who use WordPress show up to help maintain it. And that 1{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9} that does show up skews toward people who already have a pretty high level of representation and technology. And so, when you look at who is building it versus who is using it, it doesn&#8217;t always match. And since what we build so frequently reflects who we are, sometimes what we build doesn&#8217;t match the needs of the people who are using what we have.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>04:10</p>\n\n\n\n<p>So what has WordPress done to be proactive on the question of Diversity, Equity, and Inclusion? There are quite a few unseen things that have gone into this over the years and a few pretty visible things. This is a very long list. And it has a whole lot of just reference material. And so the show notes today will come in handy for people, and there will be just a laundry list of linked resources for everyone.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>04:39</p>\n\n\n\n<p>But the first thing that WordPress has done is that we have accepted the burden of proof. I&#8217;m going to share a post about this in the show notes. That means we accept that it&#8217;s not the job of underrepresented folks to figure out if they are welcome. It&#8217;s up to us to make it clear that they are. So, there are three big little things that the community has done over the years. One is that many teams open their text-based meetings with an explanation of what is done in the meeting, who comes to the meetings, where to find help if you&#8217;re lost in the meeting, and for teams that have a specific type of requests that comes into those channels that aren&#8217;t handled in those channels. They also will share where people can go to get those requests taken care of. Many teams have also updated their team handbooks to have good beginner docs, limited use of inside jokes or jargon, and good first bugs. And also, there is a code of conduct in the community declaring that everyone is welcome and clarifies what to do if you see folks being unwelcoming.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>05:51</p>\n\n\n\n<p>A second big thing that folks in the WordPress community have done is written down what was unwritten. Having things clearly documented unlocks institutional knowledge that you&#8217;d otherwise have to know someone to get. Clarity and process and the structure help anyone engage with your organization, not just the people who have extra time to figure things out. What that looks like in the WordPress project is that many teams have documented their workflows and their working spaces and just their general team norms. Many teams have also started defining what it means to be a team rep and holding open processes to choose those team reps. Many other community leaders and I have written down countless unspoken rules, guidelines, and philosophical underpinnings so that people don&#8217;t have to guess what we&#8217;re doing or why we&#8217;re doing things, or where we want to do them.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>06:46</p>\n\n\n\n<p>And the more visible thing that the WordPress project has been doing is that we found ways to invite people in, and they&#8217;re not failsafe; they’re not foolproof, but it is certainly a step in the right direction. The first one is an ongoing, diverse speaker training initiative. And I&#8217;ll include a link to that in the show notes as well. It is run by Jill Binder and a fantastic group of contributors that collaborate with her. And I really have loved watching that particular program grow and flourish and help WordPress make a difference where we absolutely can.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>07:27</p>\n\n\n\n<p>The second thing that was pretty visible about how we invited people in was at the end of 2020, and we had an all-women and nonbinary release squad for our biggest release of the year; WordPress 5.6. I had a group of probably 70 women and nonbinary identifying folx who joined in the process and joined in learning more about the process. Some of them have continued in the project. Others have stepped away for various reasons. But all of them are welcome to return. And I encourage everyone to return to contribution when time and resources make that possible for you.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>08:09</p>\n\n\n\n<p>And then the third thing that we&#8217;ve done, which I have talked about a lot, is the revival of the testing and triage practices. That has been work that&#8217;s been ongoing for a number of years. And it happens across multiple teams. It is not always immediately clear to people why the testing work. And the triage work is identifiable for me as a way to invite people into this process. And so I&#8217;ll be briefly clear about it right now. So testing as a practice brings in the users that otherwise don&#8217;t have a lot of spare time and that extra privilege to like, figure out what&#8217;s going on with WordPress, and contribute their own fixes to problems. They can give back to this project by being co-developers with us, co-creators with our entire process of making WordPress real and usable for the largest number of people that we can because we now support 42{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9} of the web. And then, the triage practice invites in a diverse voice of people. Because you don&#8217;t necessarily always need to know everything about a project to help with triage. And when you&#8217;re helping with triage, you get active learning through participating in the process. But you also get passive learning from the people who already know huge amounts about the project and the process and everything that goes into it. And so it&#8217;s a low key low stress way to get your feet wet and start building that knowledge that sometimes is hard to come by unless you are actively working in it. So the testing practices, the triage practices, I really to the core of my being believe that those are active and ongoing ways for us to invite people who otherwise wouldn&#8217;t have a chance to get their voices heard in an open source project. And y&#8217;all, as I said at the start, y’all, there&#8217;s nothing about this list that I just shared, which makes me feel like our work on this is done. Just like any muscle, you don&#8217;t fight to peak fitness, and then hit the big stop button on time and say, &#8220;Now, I never have to work out again.&#8221; If we did, the world would be a very different place probably. But it does then lead us to the next steps for fostering a community culture that&#8217;s as broad as the people who use this software. If you believe in leadership at any level, as I do, there are a ton of things that you can do right now. But I&#8217;ll boil them down into three big chunks of things.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>10:54</p>\n\n\n\n<p>First, check your community area, or whatever community you want to apply this to, for things that need a little more proactive work. I will share a post called<em> Building A Culture of Safety</em> that will take you through a list of good first steps. And it is not as hard as it looks. When you say build a culture of safety, there are many really clear-cut minor changes that you can ask people to make and, in like, four or five different areas that can help your community be more welcoming and more open.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>11:30</p>\n\n\n\n<p>The second thing that you can do is know that small changes add up over time and commit to making those changes where you can. If you are elite at any level, you know that supporting people and processes is the responsibility of everyone in the group. And if you can make your own autonomous decisions and commit to making small changes that make a big difference over time, you will be part of that solution. And that is not specific to any one group that we have in our communities. You can be an ally for anyone, whether they look like you, whether they have your same experiences, or not. And sometimes, it&#8217;s as easy as just holding space for the people who haven&#8217;t had a chance to talk yet. And on the subject of holding space and the way that we communicate.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>12:22</p>\n\n\n\n<p>The third thing that I think is incredibly important is that you can take on as a foundational personal practice the concept of ethical communication. I&#8217;ll share a post about that as well in the show notes, but the core of it is that you have to know that what you say and don&#8217;t say what you do and don&#8217;t do has an impact on others and embrace that responsibility. All right, so you made it all the way through, and I am so proud of you. I&#8217;m sure you have questions about this. And I encourage you to share those. You can email them to me at wp briefing@wordpress.org.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>13:10</p>\n\n\n\n<p>This brings us to our small list of big things. I&#8217;ve got two things for you today. First and foremost, WordPress 5.8 gets released tomorrow. It&#8217;s a big release, and lots of people have been working on it. So get your update processes ready and keep an eye on wordpress.org/news for the announcement post. Second, and still pretty important, team reps have been working on their quarterly check-ins so that all other teams can get an idea of what&#8217;s happening around the WordPress office. Keep an eye out for that post on make.wordpress.org/updates. And that is your smallest of big things. Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host Joseph Hayden Chomphosy, and I&#8217;ll see you again in a couple of weeks.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"10949\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 5.8 Release Candidate 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2021/07/wordpress-5-8-release-candidate-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 14 Jul 2021 01:09:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"5.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=10933\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:303:\"The third release candidate for WordPress 5.8 is now available! WordPress 5.8 is slated for release on July 20, 2021, and we need your help to get there—if you have not tried 5.8 yet, now is the time! You can test the WordPress 5.8 release candidate 3 in any of these three ways: Install and [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Jeffrey Paul\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3233:\"\n<p>The third release candidate for <a href=\"https://make.wordpress.org/core/5-8/\">WordPress 5.8</a> is now available! </p>\n\n\n\n<p>WordPress 5.8 is slated for release on <strong>July 20, 2021</strong>, and we need <em>your</em> help to get there—if you have not tried 5.8 yet, now is the time!</p>\n\n\n\n<p>You can test the WordPress 5.8 release candidate 3 in any of these three ways:</p>\n\n\n\n<ul><li>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester plugin</a> (select the <code>Bleeding edge</code> channel and then <code>Beta/RC Only</code> stream)</li><li>Directly download the release candidate version <a href=\"https://wordpress.org/wordpress-5.8-RC3.zip\">(zip)</a></li><li>Use WP-CLI to test: <code>wp core update --version=5.8-RC3</code></li></ul>\n\n\n\n<p>Thank you to all of the contributors who tested the&nbsp;Beta/RC releases and gave feedback. Testing for bugs is a critical part of polishing every release and a great way to contribute to WordPress.</p>\n\n\n\n<h2>Plugin and Theme Developers</h2>\n\n\n\n<p>Please test your plugins and themes against WordPress 5.8 and update the&nbsp;<em>Tested up to</em>&nbsp;version in the <code>readme</code> file to 5.8.  If you find compatibility problems, please be sure to post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a>&nbsp;so we can work to solve them in time for the final release.</p>\n\n\n\n<p>For a more detailed breakdown of the changes included in WordPress 5.8, check out the <a href=\"https://wordpress.org/news/2021/06/wordpress-5-8-beta-1/\">WordPress 5.8 beta 1 post</a>.  The&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://make.wordpress.org/core/2021/07/03/wordpress-5-8-field-guide/\">WordPress 5.8 Field Guide</a>, which is particularly useful for developers, has all the info and further links to help you get comfortable with the major changes.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Can you speak and write in a language other than English? &nbsp;<a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n\n\n\n<p><em><strong>If you think you have found a bug</strong>, you can post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a>&nbsp;in the support forums. We would love to hear from you!  If you are comfortable writing a reproducible bug report,&nbsp;<a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>, where you can also find&nbsp;<a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</em></p>\n\n\n\n<p class=\"has-text-align-right\"><strong><em>Props to <a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a>, <a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>, and <a href=\'https://profiles.wordpress.org/marybaum/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marybaum</a> for peer-reviewing!</em></strong></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<p><em>Code is poetry<br>Jazz is improvisation<br>Both are forms of art<br><br></em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"10933\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 5.8 Release Candidate 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2021/07/wordpress-5-8-release-candidate-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Jul 2021 01:12:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"5.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=10912\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:305:\"The second release candidate for WordPress 5.8 is now available! 🎉 WordPress 5.8 is slated for release on July 20, 2021, and we need your help to get there—if you have not tried 5.8 yet, now is the time! You can test the WordPress 5.8 release candidate 2 in any of these three ways: Install [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Jeffrey Paul\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3376:\"\n<p>The second release candidate for <a href=\"https://make.wordpress.org/core/5-8/\">WordPress 5.8</a> is now available! <img src=\"https://s.w.org/images/core/emoji/13.1.0/72x72/1f389.png\" alt=\"🎉\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p>WordPress 5.8 is slated for release on <strong>July 20, 2021</strong>, and we need <em>your</em> help to get there—if you have not tried 5.8 yet, now is the time!</p>\n\n\n\n<p>You can test the WordPress 5.8 release candidate 2 in any of these three ways:</p>\n\n\n\n<ul><li>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester plugin</a> (select the <code>Bleeding edge</code> channel and then <code>Beta/RC Only</code> stream)</li><li>Directly download the release candidate version <a href=\"https://wordpress.org/wordpress-5.8-RC2.zip\">(zip)</a></li><li>Use WP-CLI to test: <code>wp core update --version=5.8-RC2</code></li></ul>\n\n\n\n<p>Thank you to all of the contributors who tested the&nbsp;Beta/RC releases and gave feedback.  Testing for bugs is a critical part of polishing every release and a great way to contribute to WordPress.</p>\n\n\n\n<h2>Plugin and Theme Developers</h2>\n\n\n\n<p>Please test your plugins and themes against WordPress 5.8 and update the&nbsp;<em>Tested up to</em>&nbsp;version in the <code>readme</code> file to 5.8.  If you find compatibility problems, please be sure to post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a>,&nbsp;so they can get ready for the final release.</p>\n\n\n\n<p>For a more detailed breakdown of the changes included in WordPress 5.8, check out the <a href=\"https://wordpress.org/news/2021/06/wordpress-5-8-beta-1/\">WordPress 5.8 beta 1 post</a>.  The&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://make.wordpress.org/core/2021/07/03/wordpress-5-8-field-guide/\">WordPress 5.8 Field Guide</a>, which is particularly useful for developers, has all the info and further links to help you get comfortable with the major changes.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Can you speak and write in a language other than English? &nbsp;<a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n\n\n\n<p><em><strong>If you think you have found a bug</strong>, you can post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a>&nbsp;in the support forums.  We would love to hear from you!  If you are comfortable writing a reproducible bug report,&nbsp;<a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>, where you can also find&nbsp;<a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</em></p>\n\n\n\n<p class=\"has-text-align-right\"><strong><em>Props to <a href=\'https://profiles.wordpress.org/lukecarbis/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>lukecarbis</a> for the haiku, <a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a> and <a href=\'https://profiles.wordpress.org/marybaum/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marybaum</a> for peer reviewing!</em></strong></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<p><em>Five-eight in two weeks<br>So test your plugins and themes<br>Update your readme</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"10912\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:58:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"WP Briefing: Episode 12: WordPress – In Person!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://wordpress.org/news/2021/07/episode-12-wordpress-in-person/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Jul 2021 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=10889\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:384:\"In this episode, Josepha Haden Chomphosy talks about WordPress &#8211; In Person! The WordPress events that provide the dark matter of connection that helps sustain the open source project. Have a question you&#8217;d like answered? You can submit them to wpbriefing@wordpress.org, either written or as a voice recording. Credits Editor: Dustin Hartzler Logo: Beatriz Fialho [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2021/07/WP-Briefing-012.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chloe Bringmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:13118:\"\n<p>In this episode, Josepha Haden Chomphosy talks about WordPress &#8211; In Person! The WordPress events that provide the dark matter of connection that helps sustain the open source project.</p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2>Credits</h2>\n\n\n\n<p>Editor:<a href=\"https://profiles.wordpress.org/dustinhartzler/\"> Dustin Hartzler</a></p>\n\n\n\n<p>Logo:<a href=\"https://profiles.wordpress.org/beafialho/\"> Beatriz Fialho</a></p>\n\n\n\n<p>Production:<a href=\"https://profiles.wordpress.org/mkaz/\"> </a><a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a></p>\n\n\n\n<p>Song: Fearless First by Kevin MacLeod</p>\n\n\n\n<h2>References</h2>\n\n\n\n<p><a href=\"https://en.wikipedia.org/wiki/Tragedy_of_the_commons\">The tragedy of the commons</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/news/2021/06/wordpress-5-8-release-candidate/\">WordPress 5.8 Release Candidate announcement </a></p>\n\n\n\n<h2>Transcript </h2>\n\n\n\n<span id=\"more-10889\"></span>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>00:11</p>\n\n\n\n<p>Hello, everyone, and welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. Here we go!</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>00:39</p>\n\n\n\n<p>Today we&#8217;re talking about one of my favorite parts of the project &#8211; WordPress events. The in-person component of the project is the dark matter that helps us build resilience and thrive as a group. A lot of what I&#8217;m going to share applies to every WordPress event, whether it&#8217;s a meetup or workshop, a contributor day, any other sort of format. But I&#8217;ll be focused on WordCamps. It&#8217;s been a while since we had any in-person WordCamps. Our last two were WordCamp Malaga in Spain and WordCamp Greenville in the US. But that hasn&#8217;t stopped anyone from gathering people together online. Which honestly makes a lot of sense for WordPress. Because there are many reasons we gather, the main three reasons are connecting, inspiring, and contributing. It&#8217;s true. It says so right in our documentation, &#8220;paper rustling.&#8221; All WordPress events should connect WordPress users, inspire people to do more with WordPress, and contribute to the WordPress project. As an aside, I&#8217;ll tell you that some groups also get to collaborate and educate in there, but connect, inspire, contribute. Those are the big three. And that&#8217;s what I&#8217;m talking about today. And if you subscribe to this podcast for the back office deep cuts, I&#8217;ll also have a few of those for you. </p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>01:57</p>\n\n\n\n<p>Alright, so first up, connect. WordCamps are generally annual-ish gatherings organized by local WordPress meetup groups. They&#8217;re not meant to be big or fancy. The definition of the minimum viable product for WordCamp is 50 people gathered all day to talk about WordPress. They are intentionally affordable to allow people from all walks of life to attend, meet, share and learn. This is made possible by donations and sponsorships from local businesses and larger businesses in the WordPress ecosystem. And this helps us get people connected to those in their community that works with or are sustained by WordPress. That connection feeds into the overall health of the global WordPress project. </p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>02:45</p>\n\n\n\n<p>Next up is inspire. WordCamps do not discriminate. They are open to any WordPress users, developers, designers, or other enthusiasts, regardless of their level of experience. And because of this, sessions generally span a variety of formats. So presentations or live demos to workshops or panels, any other format you can think of. But that also means that there are a variety of skill levels represented. There&#8217;s always content about how to use WordPress. That’s a given. But you can also count on content that inspires people to do more with their own dreams and aspirations. When I was still organizing WordCamps, my favorite thing was seeing people who came back year after year, putting into practice something that they learned the year before. It is that <em>Choose Your Own Adventure</em> aspect to WordCamps that lets people see the edge of their ideas and then expand that just a little bit further. </p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>03:42</p>\n\n\n\n<p>And finally, contribute. WordCamps often have a contribution component to them. Sometimes it&#8217;s just a talk telling you how you can get more involved in the WordPress project. But sometimes, it&#8217;s a whole contributor day. And those range in size from single focus, like everyone, will show up and learn how to review a theme or a focus from every team that we have, like at the big flagship events where we gather hundreds of people into a room just to contribute to WordPress and all of the teams that go with it. Getting started with contributing can be daunting, but it is also essential to avoid something called the Tragedy of the Commons, an economic concept. So I&#8217;ll share a link to that in the show notes below. But the most important thing, the most important thing to remember, is that WordPress is open source. And we asked people to help us keep this great tool running by giving back a little bit of their time if they have gotten any benefit from the WordPress project or CMS over the course of their careers.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>04:40</p>\n\n\n\n<p>So that&#8217;s it. The three big things you can get from a WordCamp. I know that I can&#8217;t wait to get back to them myself because while a lot of these things can still happen online and do, it&#8217;s really hard to replace the dark matter of in-person connections for open source projects. And since we&#8217;re talking dark matter anyway, let&#8217;s dig into it a little.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>05:01</p>\n\n\n\n<p>At the start of the section, I mentioned that WordCamps are local, locally organized, and people are encouraged to attend locally. But I am part of a group that ends up traveling to a lot of WordCamps. If you don&#8217;t know about the unseen work of WordPress, this raises eyebrows. So here is some clarification around the back office work that some of these traveling WordCampers often do. When I listed these out, there were about 20 different tasks, 20 different jobs, which was, frankly, a bit overwhelming when I listed them that way. So I&#8217;ve grouped them into kind of two genres, each with a group of current versus future types of work. So my two big buckets, big picture stuff, and then community stewardship.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>05:50</p>\n\n\n\n<p>The big picture stuff, our first big genre here, when you&#8217;re looking at current topics, current issues kind of information, when we&#8217;re working on big picture stuff, you get the clarification of the mission or vision of WordPress, the sharing of open source methods or processes that we use in the WordPress project, and also sometimes those goal-setting conversations that you have to have both because we have a bunch of teams and team reps, that have a lot of really great ideas about what can be done in their teams to help WordPress succeed. But then also, because when you are working, when you&#8217;re contributing to a single team in the project, it can sometimes be hard to know how your work relates to the overall goals and visions of WordPress. And so that&#8217;s part of the work that gets done that I do there.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>06:43</p>\n\n\n\n<p>And when you&#8217;re looking at future topics, future issues, the second part of this genre, that stuff like starting conversations or discussions around what the future holds for WordPress, and that&#8217;s the project as well as the technology or hearing from people about big things coming up for them. And any content that can support it, anything that I can provide to support those big things. It&#8217;s also a good time for me and others to identify trends based on what I see in presentations or what I hear from people at social functions. Really, it&#8217;s just a huge opportunity for information gathering to make sure that I know what everyone else in the project is trying to do and if they understand what the project is trying to do.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>07:32</p>\n\n\n\n<p>And then the second big genre of things that happen in that dark matter kind of work at WordCamps is what I call community stewardship—so taking care of the community itself for the project itself. And a lot of that work is actually incident response kind of work. So conflict resolution, mediation often happens at in-person events, but also uncovering the shared foundations, the shared understanding for upcoming changes. So a lot of really, in the weeds kind of change management work. And for me, it&#8217;s certainly doing my best as a cultural liaison when I do see that there has been some miscommunication or gathering context for the latest disagreement that people are having with me so that I can clarify anything that was misunderstood from what I said. And also a little bit of policy clarification, just explaining why we do things and the way we do them. So for community stewardship, that&#8217;s kind of the current stuff that we look at. And that I do when I&#8217;m traveling for WordCamps. </p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>08:36</p>\n\n\n\n<p>And then for the future tasks that we do with community stewardship in the project, that stuff like training, and that&#8217;s training team reps, community deputies, or new contributors like it&#8217;s, it&#8217;s not really one type of training, necessarily. But then also, all of the checking in with our organizers, team reps, volunteers, sponsors, everyone like that, to make sure that what we have in the project and what&#8217;s happening in the project, the tools that we have, the experience that contributors have while they are working here, and WordPress is good, and is what they need. We&#8217;ve got a lot of tools to get things done in WordPress, and we can always make them better. And so checking in with people to kind of see how those processes are, how the tools are making sure that I have an idea of where our holes are and what needs to be patched, and how we can patch them in the long run. So that&#8217;s all of the future planning kind of work and topic stuff, just you know, making sure that WordPress has what it needs to survive long into the future and long after I&#8217;m doing anything with it, and long after you&#8217;re doing anything with it either.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>09:56</p>\n\n\n\n<p>So, lots and lots of unseen work being done at our in-person events. But folks who keep a keen eye on the online global work of WordPress will probably recognize that a lot of that work is also done routinely on make.wordpress.org and within the making WordPress Slack. There’s just, I don&#8217;t know, there&#8217;s just something different about receiving information from a human being with a face rather than an avatar with a photo. So I guess at the end of the day, that means the dark matter that keeps open source together is really an issue of communication. And you&#8217;ll get no arguments for me there.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>10:44</p>\n\n\n\n<p>That brings us now to our small list of big things. And there&#8217;s really just one big thing. And that&#8217;s WordPress 5.8. We are about two weeks away from this big release; the community has been working tirelessly on it. And it&#8217;s shaping up to be one of the most tested releases that we&#8217;ve had in a long time. Myself, I&#8217;m grateful to see so much activity before the release. Since 5.8 and 5.9 releases represent such monumental shifts in our software, I&#8217;m incredibly grateful to see so much activity prior to the release, especially in the beta period. We&#8217;ve been testing everything for it feels like six or eight months, and we&#8217;re really starting to see the positive benefits of that. And I think that we, the WordPress community, should be really proud of everything that we&#8217;re going to ship in 2021. Okay, so that was less of a small list of big things and really like one big thing with a generous garnish of encouragement, but you deserve it. So thank you for tuning in today for the WordPress briefing. I&#8217;m your host, Josepha Haden Chomphosy, and I&#8217;ll see you again in a couple of weeks.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"10889\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"The Month in WordPress: June 2021\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2021/07/the-month-in-wordpress-june-2021/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 02 Jul 2021 15:11:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=10896\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:334:\"Once you step into contribution time, your main concern is the users of WordPress, or new contributors, or the health of the WordPress ecosystem as a whole or the WordPress project. So you get all this subject matter expertise from competitive forces, collaborating in a very “us versus the problem” way. And when you do [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Hari Shanker R\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11608:\"\n<blockquote class=\"wp-block-quote\"><p>Once you step into contribution time, your main concern is the users of WordPress, or new contributors, or the health of the WordPress ecosystem as a whole or the WordPress project. So you get all this subject matter expertise from competitive forces, collaborating in a very “us versus the problem” way. And when you do that, you’re always going to find a great solution.</p></blockquote>\n\n\n\n<p>In the “<a href=\"https://wordpress.org/news/2021/06/episode-11-wordcamp-europe-2021-in-review/#more-10837\">WordCamp Europe 2021 in Review</a>” episode of the WP Briefing podcast, <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden</a> talks about the importance of collaboration, which is vital in building WordPress. This edition of The Month in WordPress covers exciting updates that exemplify this philosophy.&nbsp;</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Updates on WordPress 5.8</h2>\n\n\n\n<p>Get excited, folks! The beta versions and the first release candidate of WordPress 5.8 are out. <a href=\"https://wordpress.org/news/2021/06/wordpress-5-8-beta-1/\">Beta 1</a> came out on June 9, followed by <a href=\"https://wordpress.org/news/2021/06/wordpress-5-8-beta-2/\">Beta 2</a> on June 15, <a href=\"https://wordpress.org/news/2021/06/wordpress-5-8-beta-3/\">Beta 3</a> on June 23, and <a href=\"https://wordpress.org/news/2021/06/wordpress-5-8-beta-4/\">Beta 4</a> on June 25. The <a href=\"https://wordpress.org/news/2021/06/wordpress-5-8-release-candidate/\">first release candidate</a> of WordPress 5.8 was published on June 30. You can test the beta versions and the release candidates by <a href=\"https://wordpress.org/download/releases/#betas\">downloading them from WordPress.org</a> or by using the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin. WordPress 5.8 <a href=\"https://make.wordpress.org/core/5-8/\">will be out by July 20, 2021</a>, and is also <a href=\"https://make.wordpress.org/polyglots/2021/06/28/wordpress-5-8-ready-to-be-translated/\">ready to be translated</a>.</p>\n\n\n\n<p>Want to contribute to WordPress core? Check out the <a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>. Don’t forget to join the WordPress <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> channel in the <a href=\"https://make.wordpress.org/chat/\">Make WordPress Slack</a> and follow the <a href=\"https://make.wordpress.org/core/\">Core Team blog</a>. The Core Team hosts weekly chats on Wednesdays at <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?hour=5&amp;min=00&amp;sec=0\">5 AM</a> and <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?hour=20&amp;min=00&amp;sec=0\">8 PM</a> UTC. Help us promote WordPress 5.8 by <a href=\"https://make.wordpress.org/community/2021/06/18/meetup-group-resources-talking-points-for-wordpress-5-8/\">organizing meetups about the release</a>, <a href=\"https://make.wordpress.org/marketing/2021/06/30/help-produce-social-media-materials-for-5-8-release/\">producing social media marketing materials for 5.8</a>, or <a href=\"https://make.wordpress.org/test/2021/06/30/help-test-wordpress-5-8s-fse-features/\">testing the release</a>.</p>\n\n\n\n<h2>Gutenberg versions 10.8 and 10.9 are out</h2>\n\n\n\n<p>We said hello to Gutenberg <a href=\"https://make.wordpress.org/core/2021/06/10/whats-new-in-gutenberg-10-8-9-june/\">version 10.8</a> and <a href=\"https://make.wordpress.org/core/2021/06/24/whats-new-in-gutenberg-10-9-23-june/\">version 10.9</a> this month. <a href=\"https://make.wordpress.org/core/2021/06/10/whats-new-in-gutenberg-10-8-9-june/\">Version 10.8</a> adds rich URL previews, enhancements to the list view, and an updated block manager. <a href=\"https://make.wordpress.org/core/2021/06/24/whats-new-in-gutenberg-10-9-23-june/\">Version 10.9</a> offers several performance enhancements, along with more block design tools and template editor enhancements.</p>\n\n\n\n<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/\">the Core Team blog</a>, contribute to <a href=\"https://github.com/WordPress/gutenberg/\">Gutenberg on GitHub</a>, and join the <a href=\"https://wordpress.slack.com/archives/C02QB2JS7\">#core-editor</a> channel in the <a href=\"https://make.wordpress.org/chat/\">Make WordPress Slack</a>. The “<a href=\"https://make.wordpress.org/core/2021/06/04/whats-next-in-gutenberg-june-2021/\">What’s next in Gutenberg</a>” post offers more details on the latest updates.&nbsp;</p>\n\n\n\n<h2>WordCamp Europe 2021 concludes</h2>\n\n\n\n<p>One of the biggest and most exciting WordPress events, <a href=\"https://europe.wordcamp.org/2021/\">WordCamp Europe 2021</a>, was held from June 7-9, 2021. A team of 40 members organized the event, which had 3200+ registrations, 42 speakers, and 43 sponsors. What a success! You will find more details <a href=\"https://europe.wordcamp.org/2021/a-recap-on-wceu-2021/\">in the event recap</a>. One highlight was a <a href=\"https://wordpress.org/news/2021/06/gutenberg-highlights/\">Gutenberg demo</a> hosted by <a href=\"https://profiles.wordpress.org/matveb/\">Matías Ventura</a> and <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a>. You can <a href=\"https://www.youtube.com/channel/UCaYQGYDpXpU4A17kxN-AgJQ/featured\">watch the event recording on the WordCamp Europe YouTube channel</a>, and videos <a href=\"https://wordpress.tv/event/wordcamp-europe-2021/\">are now available on WordPress.tv</a> as well. The team has announced <a href=\"https://europe.wordcamp.org/2022/\">WordCamp Europe 2022</a>, which is being planned as an in-person event in Porto, Portugal. Want to be a part of the 2022 WCEU organizing team? Their <a href=\"https://europe.wordcamp.org/2022/call-for-organisers/\">call for organizers is now open</a>. Apply now!</p>\n\n\n\n<h2>Full Site Editing updates</h2>\n\n\n\n<p>Don’t miss the <a href=\"https://make.wordpress.org/test/2021/06/24/call-for-testing-thrive-with-theme-json/\">latest Full Site Editing (FSE) Outreach program testing call: &#8220;Thrive with theme.json&#8221;</a>, which is aimed at a developer-centric audience. The deadline is July 14. Also don’t miss a <a href=\"https://make.wordpress.org/test/2021/06/24/call-for-testing-thrive-with-theme-json/\" data-type=\"URL\" data-id=\"https://make.wordpress.org/test/2021/06/24/call-for-testing-thrive-with-theme-json/\">hallway hangout on testing theme.json on July 7 at 5 PM UTC</a>. The team has published a <a href=\"https://make.wordpress.org/test/2021/06/24/fse-program-polished-portfolios-summary/\">recap of the Published Portfolios testing call</a>, which shares some interesting results.&nbsp;</p>\n\n\n\n<h2>BuddyPress 8.0 is out!</h2>\n\n\n\n<p>The first major BuddyPress release of 2021, <a href=\"https://buddypress.org/2021/06/buddypress-8-0-0-alfano/\">version 8.0</a> “Alfano,” came out on June 6. The short-cycle release offers features such as the ability to recruit new members, an improved registration experience, and profile field types. Download it from the <a href=\"https://wordpress.org/plugins/buddypress/\">WordPress.org plugin directory</a> or check it out from its <a href=\"https://buddypress.trac.wordpress.org/browser/branches/8.0\">Subversion repository.</a></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further reading</h2>\n\n\n\n<ul><li><a href=\"https://japan.wordcamp.org/2021/\">WordCamp Japan 2021</a> was held from June 20- 26. The weeklong event, which had two session days followed by five contributor days, sold 1300+ tickets, with 45 speakers and 23 sponsors. Catch the <a href=\"https://www.youtube.com/c/wordcampjapan\">event recording on YouTube</a>!</li><li>Josepha Haden <a href=\"https://make.wordpress.org/updates/2021/06/03/announcing-make-wordpress-org-project/\">announced</a> a new Make site — <a href=\"https://make.wordpress.org/project\">make.wordpress.org/project</a> — for project-wide announcements, which will no longer be posted to Make/Updates. Check out the latest post on that site on <a href=\"https://make.wordpress.org/project/2021/06/17/the-metrics-of-contributions/\">the metrics of contributions</a>.</li><li>The Community Team announced that <a href=\"https://make.wordpress.org/community/2021/07/01/in-person-meetup-events-for-vaccinated-community-members/\">in-person meetups can be organized for fully vaccinated people</a>, in places where vaccines are freely available.</li><li>The Core Team added<a href=\"https://make.wordpress.org/core/2021/06/21/bundled-themes-changes-in-wordpress-5-8/\"> block patterns and improvements</a> to all legacy default themes. The team also shared a <a href=\"https://make.wordpress.org/core/2021/06/22/extending-the-site-health-interface-in-wordpress-5-8/\">feature request</a> that will allow developers to modify and extend the Site Health feature in Core.</li><li>The Design Team shared an update on the <a href=\"https://make.wordpress.org/design/2021/06/23/update-initial-patterns-for-the-patterns-directory/\">block pattern directory</a>; the team is continuing to review suggestions and has offered some guidelines in this post.</li><li>The Design Team is also <a href=\"https://wordpress.org/news/2021/06/a-new-design-is-coming-to-wordpress-news/\">working on redesigning this blog</a> (wordpress.org/news). Catch a sneak peek of the blog&#8217;s new look <a href=\"https://make.wordpress.org/design/2021/06/03/redesign-of-wordpress-org-news/\">in this Make/Design blog post</a>.</li><li>The Accessibility Team shared the <a href=\"https://developer.wordpress.org/coding-standards/wordpress-coding-standards/accessibility/\">updated WordPress Accessibility coding standards</a>.</li><li>The Polyglots Team proposed a <a href=\"https://make.wordpress.org/polyglots/2021/06/03/proposal-month-long-translation-day-2021-celebration/\">monthlong translation day celebration in September</a>.</li><li><span style=\"color: initial;, sans-serif\">The Support Team </span><a style=\", sans-serif\" href=\"https://make.wordpress.org/support/2021/06/new-irc-server-for-support/\">moved their IRC chat server from Freenode to Libera</a><span style=\"color: initial;, sans-serif\">.</span></li><li>The Documentation Team is<a href=\"https://make.wordpress.org/docs/2021/06/06/writing-documentation-for-wordpress-release/\"> working hard on updating our docs</a> for WordPress 5.8.&nbsp;</li><li>The Themes Team has decided to <a href=\"https://make.wordpress.org/docs/2021/06/06/writing-documentation-for-wordpress-release/\">automatically set theme updates live for old themes</a> instead of routing them through the review queue.</li><li>The <a href=\"https://github.com/WordPress/Requests\">WordPress Requests library</a> has a new release: <a href=\"https://github.com/WordPress/Requests/releases/tag/v1.8.1\">version 1.8.1</a>.&nbsp;</li><li><a href=\"https://en.wikipedia.org/wiki/Ujwal_Thapa\">Ujwal Thapa</a> &#8211; co-founder of the Nepal WordPress community <a href=\"https://wptavern.com/ujwal-thapa-co-founder-of-the-wordpress-nepal-community-passes-away\">passed away due to COVID-19</a>. Our community deeply mourns his loss and is thankful for his contributions.</li><li>The latest edition of “<a href=\"https://wordpress.org/news/category/heropress/\">People of WordPress</a>” features <a href=\"https://wordpress.org/news/2021/06/people-of-wordpress-tijana-andrejic/\">Tijana Andrejic from Serbia.</a></li></ul>\n\n\n\n<p><em>Have a story that we should include in the next “Month in WordPress” post? Please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it using this form</em></a><em>.&nbsp;</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"10896\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 13 Oct 2021 08:49:04 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Tue, 05 Oct 2021 20:05:52 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";s:14:\"20201017025008\";}',	'no'),
(138,	'_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3',	'1634158144',	'no'),
(139,	'_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3',	'1634114944',	'no'),
(140,	'can_compress_scripts',	'1',	'no'),
(141,	'_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9',	'1634158145',	'no'),
(142,	'_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9',	'a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WPTavern: WordPress Global Community Sponsorship Program Will Not Include WordCamps for 2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=124018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:209:\"https://wptavern.com/wordpress-global-sponsorship-program-will-not-include-wordcamps-for-2022?utm_source=rss&utm_medium=rss&utm_campaign=wordpress-global-sponsorship-program-will-not-include-wordcamps-for-2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4603:\"<p>The <a href=\"https://make.wordpress.org/community/2021/10/08/proposal-2022-global-community-sponsorship-program/\">proposal</a> for the 2022 Global Community Sponsorship program will not include funding for WordCamps again this year, due to the unpredictability of hosting in-person events. The pandemic continues to make conditions unfavorable in many areas of the world where WordCamp and meetup organizers have opted to continue with virtual events. </p>\n\n\n\n<p>In the past, the Global Community Sponsorship program has offered multiple tiers of funding in support of official, volunteer-organized WordPress community events. In 2020, before the program was <a href=\"https://make.wordpress.org/community/2020/07/23/moving-forward-with-online-events/\">suspended</a>, global sponsorship tiers ranged from $40,000 &ndash; $160,000.</p>\n\n\n\n<div class=\"wp-block-image\"><img /></div>\n\n\n\n<p>The updated proposal knocks sponsorships back to a single annual package, billed at $10,000 USD per quarter. Sponsor benefits are similar to those offered in 2021. While the base package does not include WordCamp sponsorship, program participants can offer it by electing to pay an add-on, which is also billed quarterly. </p>\n\n\n\n<p>&ldquo;The proposed change for 2022 is that Global Sponsors who add on sponsorship for WordCamps will support&nbsp;<em>all</em>&nbsp;WordCamps (as opposed to choosing which WordCamps to sponsor a la carte), at the camp&rsquo;s top published level,&rdquo; WordPress.org community organizer Courtney Patubo Kranzke said.</p>\n\n\n\n<p>&ldquo;In short, there would not be a community grant as we&rsquo;ve had in the past, but WordCamps will get credited global sponsorship funds at the top local level.&rdquo;</p>\n\n\n\n<p>Patubo Kranzke said that volunteer engagement is currently low and the single package ensures sponsors have a centralized point of contact, as opposed to trying to coordinate with multiple teams of volunteer event organizers. </p>\n\n\n\n<p>Despite the potential availability of add-on funds, the <a href=\"https://make.wordpress.org/community/2021/09/13/announcement-updated-guidelines-for-in-person-wordcamps/\">updated guidelines for in-person WordCamps</a> state that organizers must be prepared to raise 100{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9} of the expenses for their events. They are encouraged to keep their camps&rsquo; budgets lean with free or low cost venues that are fully refundable just in case. </p>\n\n\n\n<p>&ldquo;The expectation is in-person camps have to be able to cover all costs,&rdquo; Community team contributor Kevin Cristiano said. &ldquo;The global program will bring some relief to local organizers, but more so create a safety net for the entire program. What do I mean a safety net? We are navigating a world with risks on events like never before and we simply cannot afford another round of cancellations and lost deposits. It is our hope that once finalized the Global program can help bring stability and mitigate risks so we can have WordCamps begin in person again while being financially responsible.&rdquo;</p>\n\n\n\n<p>WordPress community events have been cut back significantly over the past two years. In 2019, local communities hosted 140 WordCamps and 805 WordPress meetup groups met more than 5,900 times. After the pandemic hit in 2020, the community hosted 31 WordCamps, most of which were held online. Meetup groups fell to 745 and met over 4,900 times. At the time of publishing in 2021, there have been just 14 WordCamps (all online) and 755 meetup groups met 2,400+ times. </p>\n\n\n\n<p>Despite the community team <a href=\"https://wptavern.com/wordpress-opens-applications-for-in-person-wordcamps\">re-opening applications for in-person WordCamps,</a> all the remaining WordCamps on the books for 2021 have been scheduled as online events. </p>\n\n\n\n<div class=\"wp-block-image\"><img /></div>\n\n\n\n<p>In anticipation of returning to in-person events, WordPress Community Support has added a &ldquo;communicable disease liability coverage&rdquo; policy to its event insurance. Any in-person WordCamp that proceeds to the ticketing stage will have <a href=\"https://make.wordpress.org/community/2021/10/11/legal-protections-for-organizers/\">a disclaimer on the purchase page</a>, aimed at protecting organizers against claims related to COVID-19.</p>\n\n\n\n<p>The <a href=\"https://make.wordpress.org/community/2021/10/08/proposal-2022-global-community-sponsorship-program/\">proposal</a> for the 2022 Global Community Sponsorship program is still under discussion until October 15, and will be finalized by October 28, so WordPress can recruit sponsors by the end of the year.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 13 Oct 2021 03:10:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: Dynamic Social Images for Plugins, Themes, and Patterns? Yes, Please\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=124175\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:193:\"https://wptavern.com/dynamic-social-images-for-plugins-themes-and-patterns-yes-please?utm_source=rss&utm_medium=rss&utm_campaign=dynamic-social-images-for-plugins-themes-and-patterns-yes-please\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4307:\"<p class=\"has-drop-cap\">Things move fast on social media. You get mere seconds to impress those who happen upon your posts promoting your latest project. You must also pack a lot of information into a small window that would potentially draw in an array of different users.</p>\n\n\n\n<p>WordPress has not been doing any favors for plugin and theme authors who share links to their directory-hosted extensions. Social cards for them include a simple image, title, and description. Instead, WordPress.org could dynamically generate the social images by populating them with other data, such as ratings, active installs, and more.</p>\n\n\n\n<p>That is just what GiveWP co-founder Matt Cromwell <a href=\"https://meta.trac.wordpress.org/ticket/5926\">proposed today in a new ticket</a>. &ldquo;When plugin/theme/block/pattern authors want to share their work on social platforms, they want to link directly to their product on .org and have it look nice,&rdquo; he said.</p>\n\n\n\n<p>He shared an image of an <a href=\"https://twitter.com/GiveWP/status/1447964733747908622\">earlier tweet</a> from the GiveWP Twitter account today:</p>\n\n\n\n<img />\n\n\n\n<p>The goal is to piggyback off the concept that GitHub put in motion over the summer. In June, the platform launched a new <a href=\"https://github.blog/2021-06-22-framework-building-open-graph-images/\">framework for building Open Graph images</a>. The system generates an on-the-fly image with data specific to a repository, issue, pull request, and more.</p>\n\n\n\n<p>In the context of WordPress plugins, themes, and patterns, there are bits of information that could help highlight the projects:</p>\n\n\n\n<ul><li>Contributors (plugins only)</li><li>Locales/Translations</li><li>Rating</li><li>Installs</li></ul>\n\n\n\n<p>This data is readily available on WordPress.org. All that would really be required is the code for generating the social images with it.</p>\n\n\n\n<p>Cromwell shared a mockup of what this might look like for a plugin, which is also available through the <a href=\"https://www.figma.com/file/ZAggnVZ5bk0W27ihzQGdWt/Untitled?node-id=0{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}3A1\">Figma project</a> he created:</p>\n\n\n\n<img />Mockup for a plugin&rsquo;s generated social image.\n\n\n\n<p>He also has an annotated version:</p>\n\n\n\n<img />Annotated version of social image mockup.\n\n\n\n<p>Thus far, the feedback has been positive in the ticket. This is probably one of those easy wins that most people in the community could get behind.</p>\n\n\n\n<p>&ldquo;I&rsquo;d only add that I&rsquo;d love this to be automatically translated,&rdquo; said Jean-Baptiste Audras <a href=\"https://meta.trac.wordpress.org/ticket/5926#comment:4\">in the ticket</a>. &ldquo;Which seems doable given the language/locale is provided by the URL.&rdquo;</p>\n\n\n\n<p>The idea is to use the translated text for the generated image if the shared link is from one of the many locale-specific subdomains on WordPress.org. So, a Spanish URL would use the existing Spanish translation.</p>\n\n\n\n<p>We could even apply this concept to other pages on WordPress.org, particularly those that might not have an image associated with them. This is a treatment that Courtney Engle Robertson, Web Design and Developer Advocate at GoDaddy, <a href=\"https://www.facebook.com/mathetos/posts/10223954958280286?comment_id=10223955011961628\">requested on Cromwell&rsquo;s Facebook post</a> about the idea. Workshops on the Learn section of the site, for example, could display the number of languages or length, so potential visitors have more information before clicking a link.</p>\n\n\n\n<p>The best thing about this idea is that the WordPress community likely already has the foundational code to make this happen. <a href=\"https://wptavern.com/automattic-acquires-social-image-generator-plugin-plans-to-integrate-with-jetpack\">Automattic purchased</a> Daniel Post&rsquo;s Social Image Generator plugin last month. The plan is to bundle the feature in Jetpack as part of its social media tools.</p>\n\n\n\n<img />Generated image using dynamic data.\n\n\n\n<p>With a bit of custom code, it is not a stretch to think we could have better social images in short order. The plugin was already built with customization in mind when I <a href=\"https://wptavern.com/create-per-post-social-media-images-with-the-social-image-generator-wordpress-plugin\">reviewed it in June</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Oct 2021 23:52:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: WordPress.org Profiles Now Show Activity for Contributions Made on GitHub\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=124100\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:211:\"https://wptavern.com/wordpress-org-profiles-now-show-activity-for-contributions-made-on-github?utm_source=rss&utm_medium=rss&utm_campaign=wordpress-org-profiles-now-show-activity-for-contributions-made-on-github\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3263:\"<p>WordPress.org profiles got an <a href=\"https://make.wordpress.org/meta/2021/10/11/wordpress-org-profiles-now-show-github-activity/\">update</a> over the weekend that will make them a better reflection of contributors&rsquo; efforts on GitHub. Users can now authorize GitHub to detect their activity on the WordPress GitHub organization and display it on their profiles.</p>\n\n\n\n<div class=\"wp-block-image\"><img /></div>\n\n\n\n<p><br />&ldquo;Currently we&rsquo;re tracking New Issues submitted (by you), Closed Issues (by you), Pull requests submitted (by you), Pull requests merged (by you, and additionally the PR submitter gets a &lsquo;PR Merged&rsquo; event), and finally Pushes to default branches,&rdquo; WordPress lead developer Dion Hulse said. </p>\n\n\n\n<p>There are a few reasons why one&rsquo;s contributions might not be visible after linking accounts. The meta team has not built an importer for all previous issues and pull requests, so WordPress.org only has data from last Friday and onwards. Early adopters who linked their accounts when the feature was first being tested may need to re-authenticate since the earlier version had <a href=\"https://make.wordpress.org/core/2021/05/03/expired-github-and-wordpress-org-profile-connections/\">expired connections</a>.</p>\n\n\n\n<p>Linking accounts will help make it easier for the WordPress project to track contributions across multiple locations.</p>\n\n\n\n<p>&ldquo;In recent releases, the process of collecting props for non-WordPress.org contributions (namely&nbsp;Gutenberg) has been highly manual and error prone, occasionally resulting in contributors not receiving proper credit,&rdquo; Jonathan Desrosiers said when rolling out the first version of the app in March 2020. &ldquo;Connecting your WordPress.org and GitHub accounts will allow automatic tooling to be built which reduces the burden on release teams to maintain a credit list.&rdquo;</p>\n\n\n\n<p>Users who want to have their profiles include GitHub activity can navigate to the <a href=\"https://profiles.wordpress.org/profile/edit/group/1\">Edit Profile page on WordPress.org</a>, launch the app, and authorize their accounts with one click. </p>\n\n\n\n<p>Hulse is collecting feedback regarding adding more events (i.e. commenting on issues/PRs), combining events (i.e. Submitted &amp; Merged), and anything else that might improve the quality of activity tracked. Riad Benguella suggested adding a selector to filter the timeline by activity type. Hulse responded that the way profiles are currently set up, querying specific activities cannot currently be done in a performant way but that there are meta trac tickets (<a href=\"https://meta.trac.wordpress.org/ticket/479\">#479</a>&nbsp;and&nbsp;<a href=\"https://meta.trac.wordpress.org/ticket/518\">#518</a>) where they are discussing a broader overhaul for profiles.</p>\n\n\n\n<p>With a great deal more activity coming in from GitHub, the ability to filter these activities might make WordPress.org a more comprehensive tool for assessing job candidates or verifying Five for the Future contributions. If you have more ideas for the feature, you can <a href=\"https://make.wordpress.org/meta/2021/10/11/wordpress-org-profiles-now-show-github-activity/\">leave feedback on the announcement.</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Oct 2021 01:26:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: Proposal for Themes To Highlight Block Patterns From the Directory\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=124111\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:197:\"https://wptavern.com/proposal-for-themes-to-highlight-block-patterns-from-the-directory?utm_source=rss&utm_medium=rss&utm_campaign=proposal-for-themes-to-highlight-block-patterns-from-the-directory\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5275:\"<p class=\"has-drop-cap\">Should developers bundle block patterns with their themes or submit them to the <a href=\"https://wordpress.org/patterns/\">WordPress.org directory</a>? That is the question that some will likely need to answer in the future.</p>\n\n\n\n<p>Currently, submissions are not open for the block pattern directory. However, that will change as the contributors eventually wrap up the pattern creation process. <a href=\"https://github.com/WordPress/pattern-directory/milestone/3\">The milestone</a> for this is set to October 15, but it is sitting at 25{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9} completion at the moment.</p>\n\n\n\n<p>There are 146 themes in the directory with block patterns. Thus far, developers who have wanted to implement them have had no other choice but to bundle them. However, that may all change.</p>\n\n\n\n<p>Core contributor Kjell Reigstad recently <a href=\"https://github.com/WordPress/gutenberg/issues/35364\">proposed an alternative method</a>. &ldquo;With the launch of the pattern directory (and the upcoming ability for folks to submit their own patterns to it), we should consider building a route through which themes can highlight specific patterns to their users,&rdquo; he said.</p>\n\n\n\n<p>Reigstad proposed using the standard <code>theme.json</code> file to allow theme authors to surface or give special attention to patterns best suited to the theme&rsquo;s design.</p>\n\n\n\n<p>He listed four primary benefits such a system would bring:</p>\n\n\n\n<ol><li>It would cut back on theme code, creating a side benefit of simplifying the review process for the Themes Team.</li><li>Patterns could be updated, tested, and reviewed separately.</li><li>More patterns would be accessible for all users if theme authors jumped on board.</li><li>Multiple themes could make use of the same patterns, reducing redundancy in the pattern directory.</li></ol>\n\n\n\n<p>The idea would be an additional step to this sort of utopian future where users can mix and match various elements and have them <em>just work</em> with whatever theme they are using. I am excited about it, but we still have a long way to go. When all of the core blocks support a full suite of design options, this will be far easier to accomplish, particularly when it comes to layouts.</p>\n\n\n\n<p>The idea is built on the premise that themes have begun to create their own <em>de facto</em> standard of putting all of their patterns into a single category titled &ldquo;Theme Name.&rdquo; This is the part where the concept breaks down. The truth is that not many themes are bundling dozens of patterns yet, but I have no doubts that they will.</p>\n\n\n\n<p>Tove, a <a href=\"https://wptavern.com/tove-a-block-based-wordpress-theme-by-anders-noren\">recently-released block theme</a> by Anders Nor&eacute;n, includes over 40 patterns under seven custom categories. If the developer had put all of them into a single group, it would have been a poor user experience.</p>\n\n\n\n<img />Tove patterns and categories.\n\n\n\n<p>I expect dozens of patterns will be common as they become a more vital piece of the theme development experience. If we build a system that encourages themers to highlight those from .ORG, it should be created with that reality in mind.</p>\n\n\n\n<p>Reigstad did mention another idea that might work better if themes are highlighting dozens of patterns. He proposed bubbling them to the top of the list and giving them a special badge of some sort. This method would keep theme authors from overfilling the &ldquo;theme category&rdquo; with dozens or hundreds of patterns.</p>\n\n\n\n<p>If democratizing the site design process is the ultimate goal, this feature should help further it. The more pathways we can enable for end-users to build the sites they want, the better.</p>\n\n\n\n<p>There is no reason for every theme to bundle a custom-made hero banner with a heading, paragraph, and button. Narrowing that down to a set of options that work everywhere gives users more power. They might also not feel locked out of a favored design element if they switch themes down the road.</p>\n\n\n\n<p>It would give theme developers more flexibility too. When someone else has already created several of the patterns they wanted to bundle, they can simply highlight them and not write any code to, essentially, make them a part of the theme itself.</p>\n\n\n\n<p>The biggest holdup for patterns is the existing interface for finding and inserting them. The experience is sub-par at best when you move beyond a couple of dozen.</p>\n\n\n\n<p>I am still in favor of an overlay with tiled patterns that are easily explorable. An earlier concept by Shaun Andrews was <a href=\"https://github.com/WordPress/gutenberg/pull/35006#issuecomment-929605688\">shared in a recent draft ticket</a> for a new patterns explorer.</p>\n\n\n\n<img />Potential block patterns overlay.\n\n\n\n<p>When we get an interface that is fleshed out like this, other ideas around patterns should feel like a natural part of WordPress.</p>\n\n\n\n<p>There will likely always be a place for developers to build and bundle their own patterns. Some make use of specific styles or other design elements that are only present within the theme itself.</p>\n\n\n\n<p>For now, I am looking forward to a time when I can mix and match patterns from different community designers on a single site.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 11 Oct 2021 23:48:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"Gutenberg Times: How can we make building blocks easier,  New 2022 Theme, Persistent User preferences and more – Weekend Edition 188\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=19226\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"https://gutenbergtimes.com/how-can-we-make-building-blocks-easier-new-2022-theme-presistent-user-preferences-and-more-weekend-edition-188/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:18850:\"<p>Howdy, </p>\n\n\n\n<p>I am so thrilled that I now have more time to work on community outreach, organize Live Q &amp; As and learn more about Gutenberg development. There is also a lot going on in the WordPress community. People are sharing plenty. Last week, the edition had more a theme related focus, this week, we have a developer focus, it seems, despite we just had our Live Q &amp; A on block-based theme. See for yourself! </p>\n\n\n\n<p>Did you see the <a href=\"https://wppodcasts.com/\">WPPodcasts.com</a> site by the team around the HeroPress network, Topher and Cate DeRosia! All WordPress podcasts in one spot! All because of RSS feeds. A standard published in 1999, now hardly mentioned anymore. </p>\n\n\n\n<p><a href=\"https://twitter.com/alexhern/status/1445130867073032195\">The six-hour shutdown of Facebook</a>, helped many of us yet again to appreciate the open web, and the people who keep it that way. And yes, that&#8217;s all of you, dear readers, the theme, and plugins developers, site builders, content creators and site owners using WordPress.  </p>\n\n\n\n<p>Keep it up and keep creating! </p>\n\n\n\n<p>Yours, 💕<br />Birgit</p>\n\n\n\n\n<p><strong>Table of content</strong></p>\n\n\n\n<div class=\"wp-block-sortabrilliant-guidepost\"><ul><li><a href=\"https://gutenbergtimes.com/feed/#3-using-gutenberg-for-content-creators-and-site-builders\">Using Gutenberg for Content Creators and site builders</a></li><li><a href=\"https://gutenbergtimes.com/feed/#0-theme-development-in-for-full-site-editing\">Theme development in for Full-Site Editing</a><ul><li><a href=\"https://gutenbergtimes.com/feed/#1-the-future-of-theme-switching\">The Future of Theme Switching </a></li></ul></li><li><a href=\"https://gutenbergtimes.com/feed/#2-custom-blocks-development\">Custom Blocks Development</a><ul><li><a href=\"https://gutenbergtimes.com/feed/#4-using-create-block-script\">Using create-block script to build blocks</a></li></ul></li><li><a href=\"https://gutenbergtimes.com/feed/#4-w\">WordPress Events</a><ul><li><a href=\"https://gutenbergtimes.com/feed/#pagebuilder\">Page Builder Summit</a></li></ul></li></ul></div>\n\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2021&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test and Meta team from Jan. 2021 on. Updated by yours truly.  </p>\n\n\n\n\n<h2 id=\"3-using-gutenberg-for-content-creators-and-site-builders\">Using Gutenberg for Content Creators and site builders</h2>\n\n\n\n<p><strong>Anne McCarthy</strong> collaborated with the Gutenberg developers and designers to describe the <strong><a href=\"https://make.wordpress.org/core/2021/10/06/core-editor-improvement-continued-progress-on-accessibility/\">continued progress on accessibility</a></strong> in using the block editor for existing and future features. She has details on the Navigation block&#8217;s accessibility as well as for the Gallery Block Refactor.  You&#8217;ll also find an asorted list of high impact improvements. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>In his post on the Torque Magazine, <strong>Will Morris</strong> shows you <strong><a href=\"https://torquemag.io/2021/09/use-wordpress-block-pattern-directory/\">how you can use the WordPress Pattern Directory</a></strong>. He explains first what Block patterns are and what the Directory entails. Then he walks you through how to make a block pattern from the directory usable on your site by copy/paste. Another way is adding a block pattern from the Inserter panel. Both variations are explained in a step-by-step way and should get a WordPress newbie or just someone who just switched from classic editor to the block editor, started. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/ClorithMJ\">Marius Jensen</a></strong> updated his <a href=\"https://wordpress.org/plugins/blockeditor-fullscreen-mode-control/\"><strong>Persistent Block Editor Settings plugin</strong></a> He added support for the following user settings: </p>\n\n\n\n<ul><li>&#8211; Block breadcrumbs </li><li>&#8211; Most used blocks </li><li>&#8211; Caret positioning </li></ul>\n\n\n\n<p>All settings are stored with the individual user profile information, and persist in between computer or browser changes. </p>\n\n\n\n<h2 id=\"0-theme-development-in-for-full-site-editing\">Theme development in for Full-Site Editing</h2>\n\n\n\n<p><strong>Ben Dwyer</strong> described in his post the role <a href=\"https://themeshaper.com/2021/10/06/universal-themes/\"><strong>Universal Themes</strong></a> will play in WordPress ecosystem. He defined the term Universal Theme as a theme that works like a classic theme for a site that has not enabled Full-site editing, and act like a block-based Theme for those sites that do.  He shares code-snippets for templates. Dwyer also stipulates, that Universal Themes are a temporary measure, as their need will diminish with Site Editor&#8217;s improvements further down the line.</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>Kjell Reigstad</strong> just <strong><a href=\"https://make.wordpress.org/core/2021/10/06/introducing-twenty-twenty-two/\">introduced the new Twenty-Twenty-Two</a></strong> theme. It&#8217;s bird themed, and I truly loved the backstory of this inspiration. Reigstad tells the story that an array of birds joined his family every morning for breakfast at their bird feeder, and the theme is a mediation over what he saw. My husband and I had a similar breakfast with wildlife experience. Our birds were a bit larger: a white duck, herons, ibises, and Limpkins. </p>\n\n\n\n<p>The theme will be a pure block-based theme geared towards the Full-site editing with difference color palettes exposed to the Global Styles interface and interesting block-patterns. In the post, the images are mock-ups. The Themes still needs to be built. Reigstad teamed up with <strong>Jeff Ong</strong> for the development. </p>\n\n\n\n<p><strong>WPTavern</strong> published two posts about it, too</p>\n\n\n\n<ul><li><a href=\"https://wptavern.com/default-theme-releases-may-become-more-frequent-following-wordpress-5-9\">Default Theme Releases May Become More Frequent Following WordPress 5.9</a> by Sarah Gooding</li><li><a href=\"https://wptavern.com/first-look-at-wordpress-upcoming-twenty-twenty-two-default-theme-the-most-flexible-default-theme-ever-created-for-wordpress\">First Look at WordPress’ Upcoming Twenty Twenty-Two Default Theme</a> by Justin Tadlock</li></ul>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>This week&#8217;s Live Q &amp; A recording &#8211;  <a href=\"https://www.youtube.com/watch?v=eiIhJdFfamA\"><strong>Going from classic to block-based Theme</strong></a> with <strong>Ellen Bauer, Anders Noren</strong> and <strong>Carolina Nymark</strong> &#8211;  is now available on <a href=\"https://www.youtube.com/watch?v=eiIhJdFfamA\">YouTube</a>. The blog post with resources and transcript will follow next week.  </p>\n\n\n\n<a href=\"https://www.youtube.com/watch?v=eiIhJdFfamA\"><img /></a>\n\n\n\n<p>&#8220;Creating a scaled and fluid type system takes a bit of creativity, especially in the context of WordPress block themes, but <a href=\"https://richtabor.com/fluid-type-scale-theme-json/\">here&#8217;s what I&#8217;ve explored</a>.&#8221; <strong><a href=\"https://twitter.com/richard_tabor\">Rich Tabor</a></strong> tweeted. <strong><a href=\"https://richtabor.com/fluid-type-scale-theme-json/\">Using a Fluid Type Scale in WordPress Block Themes with Theme.json</a></strong></p>\n\n\n\n<h3 id=\"1-the-future-of-theme-switching\">The Future of Theme Switching </h3>\n\n\n\n<p><strong>Anne McCarthy </strong>published the <a href=\"https://make.wordpress.org/test/2021/10/05/fse-program-block-theme-switching-summary/\"><strong>Summary from the Theme Switching Exploration</strong></a> in context of the FSE-outreach program and the 10th call for testing. It had some interesting insights, like the expectation that user created templates are thethered to the theme and don&#8217;t stay around after switching a theme. Or that custom block styles, font-color and type choices survive after the theme is changed. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>In her post <a href=\"https://make.wordpress.org/design/2021/10/08/adventures-in-block-theme-switching/\"><strong>Adventures in Block Theme Switching</strong></a>, <strong><a href=\"https://twitter.com/critterverse\">Channing Ritter</a></strong>, team member on the WordPress design team, used the comments from contributors as inspiration for three different approaches on the entrance for theme management: </p>\n\n\n\n<ol><li>The first idea envisions a redesing of the <strong>Theme Live Preview </strong>to allow for switching theme after a preview with a way to apply existing styles and templates. </li><li>The second idea makes theme management available via <strong>Global Styles</strong> sidebar of the the Site Editor. </li><li>The third idea takes the idea of shipping more then one color schemes  from the Twenty-Twenty-Two Theme and envisions a way to actually use <strong>template parts from all installed themes</strong> on a site. </li></ol>\n\n\n\n<p>It definitely is easier to understand when you watch the video and here longer explanations for each idea. Share your ideas and comment on the once before us! This is the moment you can influence where the team is taking the next phase of development. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<h2 id=\"2-custom-blocks-development\">Custom Blocks Development</h2>\n\n\n\n<p><a href=\"https://us02web.zoom.us/webinar/register/3316333825196/WN__4hq3dHuR5uT3ZSG7BnOqA\">Join us next week, Thursday, October 14th, 2021</a>, for a Discussion with <strong>Helen Hou-Sandi, Mark Jaquith and Riad Benguella</strong> on <strong><strong><a href=\"https://us02web.zoom.us/webinar/register/3316333825196/WN__4hq3dHuR5uT3ZSG7BnOqA\">How can we make building blocks easier?</a></strong></strong> It&#8217;s a continuation of a discussion started by Jaquith a few weeks ago: </p>\n\n\n\n<p><a href=\"https://twitter.com/markjaquith/status/1432461667187765251\">The tweet</a> about an exploration from Jaquith, inspired by Hou-Sandi&#8217;s blog post, spurred a flurry of conversation around custom block development. The premise? <em>“What if building custom blocks for the Block Editor was as easy as supplying attributes and a block of HTML? What if this produced React editing code and PHP rendering code without a build step?”</em>  All three panelists are long-time WordPress contributors who have been different approaches on tackling these ideas. We will have more links and resource for you on the Live Stream. </p>\n\n\n\n<a href=\"https://us02web.zoom.us/webinar/register/3316333825196/WN__4hq3dHuR5uT3ZSG7BnOqA\"><img /></a>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>This week, I published a proposal for a new event series on the Make Core Blog: <a href=\"https://make.wordpress.org/core/2021/10/07/proposal-gutenberg-developer-hours-series-of-events/\"><strong>Proposal: Gutenberg Developer Hours series of events</strong>.</a> It would be great if you could comment on this idea and let me know if you are interested in being part of the panel. It&#8217;s meant to be a low-effort way to help out other developers, without getting into all the administrative part of organizing those sessions. That&#8217;s what I will do. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/leeshadle\">Lee Shadle</a></strong> was a guest on the WPTavern Jukebox podcast on <a href=\"https://wptavern.com/podcast/8-lee-shadle-on-how-blocks-create-new-opportunities\"><strong>How Blocks Create New Opportunities.</strong></a> Podcast host, <strong>Nathan Wrigley</strong> discussed with Shadle the world of Gutenberg blocks and the new world of WordPress product business. It worth listening to the show undistracted. Shadle and Wrigley go deep into change mangement and how business owners might be able to approach building for WordPress in the classic way and slowly move into the block-based way without jeopardizing their revenue or the time they spend with their families. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p id=\"4-a-href-https-us-02-web-zoom-us-webinar-register-1016333846354-wn-v-e-xlr-fa-rcab-gz-78-jgj-8-ca-converting-classic-widgets-to-blocks-a\"><a href=\"https://us02web.zoom.us/webinar/register/1016333846354/WN_v-EXlrFaRcabGz78jgj8CA\">Join us on October 28th at 12 pm EDT / 16:00 UTC</a> <strong>Gutenberg Times Live Q &amp; A: <a href=\"https://us02web.zoom.us/webinar/register/1016333846354/WN_v-EXlrFaRcabGz78jgj8CA\">Converting classic widgets to blocks</a> </strong>Learn from the BuddyPress team members, <strong>Mathieu Viet</strong>, <strong>David Cavins</strong>, <strong>Varun Dubey</strong>.</p>\n\n\n\n<a href=\"https://us02web.zoom.us/webinar/register/1016333846354/WN_v-EXlrFaRcabGz78jgj8CA\"><img /></a>\n\n\n\n<h3 id=\"4-using-create-block-script\">Using create-block script to build blocks</h3>\n\n\n\n<p><strong><a href=\"https://twitter.com/dgwyer\">David Gwyer</a></strong> started a new site on the domain <a href=\"https://innerblocks.com/\">Innerblocks.com</a> to share his experience developing for Gutenberg in tutorials and resources. The first tutorial is titled:  <a href=\"https://innerblocks.com/creating-a-new-block-for-the-gutenberg-editor/\"><strong>Creating a New Block for the Gutenberg Editor</strong></a>. </p>\n\n\n\n<p>Gwyer also curates <a href=\"https://github.com/dgwyer/gutenberg-development-resources\">Gutenberg Developer Resources</a> on GitHub. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/phil_sola123\">Phil Sola</a></strong> has experimented with the WordPress <a href=\"https://developer.wordpress.org/block-editor/reference-guides/packages/packages-create-block/\">create-block script</a> and found a way to use it also for a multi-block plugin. He published the code on GitHub: <strong><a href=\"https://github.com/phil-sola/multi-block-plugin\">Multi blocks plugin</a></strong>.</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>In this Thursday-Twitch-Stream, <strong><a href=\"https://twitter.com/ryanwelcher\">Ryan Welcher</a></strong> also covered <strong><a href=\"https://www.twitch.tv/videos/1169960035\">using create-block for a multi-block plugin</a></strong> in a step-by-step video tutorial. <a href=\"http://Creating a plugin with @wordpress/create-blocks that has multiple blocks\">The GitHub repo is available here</a>. </p>\n\n\n\n<p>For this I only got to listened for the first 10 minutes and learned about the <em>Dependency Extraction Plugin</em> for webpack that replaces references to external packages to reference to WordPress global script that are already available in any WordPress instance. Because of that all your plugin doesn&#8217;t need to bundle all the packages, and be kept really small.  </p>\n\n\n\n<p>In previous Twitch Streams Welcher covered: </p>\n\n\n\n<ul><li><a href=\"https://www.twitch.tv/videos/1163471262\">Converting a shortcode to a custom block</a></li><li><a href=\"https://www.twitch.tv/videos/1156915530\">Updating the block examples </a></li><li><a href=\"https://www.twitch.tv/ryanwelchercodes/clip/UgliestTalentedBeaverOSsloth-t7djXmqOz2ObzwO1\">First steam! Let&#8217;s mess with some custom blocks</a></li></ul>\n\n\n\n<p>Welcher holds regular <a href=\"https://www.twitch.tv/ryanwelchercodes\">Live Twitch streams on Thursdays 10:30 am EDT / 14:30 UTC</a>. Follow him and you will be notified when he goes live. </p>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s main (trunk) branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total\" /></p>\n\n\n\n\n<h2 id=\"4-w\">WordPress Events</h2>\n\n\n\n<h3 id=\"pagebuilder\">Page Builder Summit</h3>\n\n\n\n<p><strong><a href=\"https://pagebuildersummit.com/\">Page Builder Summit</a></strong> is coming back and will be happening <strong>October 18 &#8211; 22, 2021. </strong>Nathan Wrigley and Anchen Le Roux <a href=\"https://pagebuildersummit.com/schedule/\"><strong>just published the schedule</strong></a></p>\n\n\n\n<p>Here is the list of Gutenberg / Block-editor presentations </p>\n\n\n\n<ul><li><strong>Forging the Future with Full Site Editing</strong> with Anne McCarthy (10/18 &#8211; 9am EDT)</li><li><strong>The Future of Building WordPress Websites </strong>with Brian Gardner (10/18 &#8211; 12pm EDT)</li><li><strong>What does Full Site Editing Mean for Page Builders?</strong> with Joe Casabona (10/19/ 9am EDT)</li><li><strong>Customizing WordPress Block Editor for Client Projects </strong>with Birgit Pauli-Haack (10/19/ &#8211; 10 am EDT)</li><li><strong>Mastering modern WordPress with Full-site Editing &amp; Custom Blocks</strong> with Rob Stinson (10/20/ &#8211; 5am EDT)</li><li><strong>How to Build Any Page Layout Using Kadence Blocks</strong> with Jake Pfohl (10/20/ &#8211; 12pm EDT)</li><li><strong>Building a Custom Blog Archive with Blocks</strong> with Mike Oliver (10/21/ 11am EDT)</li><li><strong>RIP Page Builders</strong> with Chris Lubkert (10/19 &#8211; 1pm EDT)</li></ul>\n\n\n\n<p>The schedule is not out yet. <a href=\"https://pagebuildersummit.com/\"><strong>Sign-up for the waitlist</strong></a> to receive notifications.</p>\n\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p class=\"has-text-align-center\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\">Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 09 Oct 2021 05:47:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"WPTavern: WPCloudDeploy Brings Site and Server Management to the WordPress Admin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=123646\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:205:\"https://wptavern.com/wpclouddeploy-brings-site-and-server-management-to-the-wordpress-admin?utm_source=rss&utm_medium=rss&utm_campaign=wpclouddeploy-brings-site-and-server-management-to-the-wordpress-admin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8512:\"<p class=\"has-drop-cap\">WPCloudDeploy recently <a href=\"https://wpclouddeploy.com/whats-new-in-wpclouddeploy-4-10-5/\">launched version 4.10.5</a> of its rapidly-maturing <a href=\"https://wpclouddeploy.com/\">WordPress plugin</a> of the same name. The project is a WordPress-native replacement for SaaS services like Cloudways, Ploi, SpinupWP, and others.</p>\n\n\n\n<p>Customers still need to hook up to a cloud server provider, such as Digital Ocean, Linode, AWS, or elsewhere. However, the project seeks to cut out the middleman for developers and agencies running multiple sites. They are specifically targeting those who would routinely manage 20 or more.</p>\n\n\n\n<p>&ldquo;It&rsquo;s a true plugin where everything you need runs on your own site (except, of course, the other servers you are provisioning and managing which reside at their respective cloud server providers),&rdquo; said WPCloudDeploy owner Nigel Bahadur.</p>\n\n\n\n<img />Server list screen.\n\n\n\n<p>Technically, WPCloudDeploy opened to the public in March 2020, but Bahadur was not ready to aggressively start letting the community know about it. He said the team is now at a point where they have a core group of users who are happy with the plugin. They have been rolling out new functionality every month for a year and a half and feel like it goes above and beyond alternatives.</p>\n\n\n\n<p>&ldquo;We were basically in stealth mode for most of that time &mdash; we did enough marketing to get a core group of users and then tried to make those users happy,&rdquo; he said. &ldquo;We even offered a heavily discounted lifetime license last year during the Black Friday sales period &ndash;- the folks that purchased then are very happy right now.&rdquo;</p>\n\n\n\n<p>With a mature project, it is time to branch out into the larger WordPress developer and agency market.</p>\n\n\n\n<p>The plugin promises its customers that they can deploy unlimited WordPress-optimized servers and sites to any cloud or bare-metal server. It has direct integration with 10 of the most popular cloud server providers.</p>\n\n\n\n<img />Server status and overview screen.\n\n\n\n<p>However, provider integration is limited to which <a href=\"https://wpclouddeploy.com/pricing/\">pricing plan</a> the customer decides on. The core tier, which costs $199 per year, only works with Digital Ocean. The business tier runs $499 and adds Linode, Vultr, and UpCloud to the mix. For the full range of providers, customers must upgrade to the all-access plan for $799. Both of the top tiers also have a lifetime purchase option.</p>\n\n\n\n<p>Each tier of the plan is not merely limited to integration with more providers. For example, agencies can sell site and server subscriptions via WooCommerce through the business or all-access packages. White label and teams features are available at all levels.</p>\n\n\n\n<h2>Selling Subscriptions through WooCommerce</h2>\n\n\n\n<p class=\"has-drop-cap\">WPCloudDeploy allows agencies to sell subscriptions to cloud servers or WordPress sites through WooCommerce. Because of the feature&rsquo;s recent interest, Bahadur said it will likely be a focus area next year for more enhancements.</p>\n\n\n\n<p>&ldquo;For servers, you can create subscription products where the user gets to choose the provider and location,&rdquo; he said. &ldquo;Or you can create them where each product represents a single provider (useful if you want to price your AWS servers differently from your DigitalOcean servers).&rdquo;</p>\n\n\n\n<p>They have their own separate service that builds on top of this called <a href=\"https://wpcloudpanel.com/\">WPCloudPanel</a>. The team created it with Beaver Builder, WooCommerce, WooCommerce Subscriptions, and Ninja Tables. The entire site required no additional custom code.</p>\n\n\n\n<img />WooCommerce-integrated sales page.\n\n\n\n<p>&ldquo;For sites, you can create subscriptions where the site is automatically placed on a particular server in a particular region,&rdquo; said Bahadur. &ldquo;Or you can create them where the site is placed on any available server from an admin-defined list of servers. It&rsquo;s a great way to get a highly customizable end-user purchasing experience using a toolset you already know.&rdquo;</p>\n\n\n\n<p>Developers and agencies are not necessarily limited to WooCommerce. Instead, they can take the team&rsquo;s code and port it to other eCommerce or membership plugins. One such customer is currently working on a MemberPress solution.</p>\n\n\n\n<p>&ldquo;Since the WPCloudDeploy code is just hooking into various WooCommerce actions and filters, it&rsquo;s basically just finding a similar hook in their favorite membership plugin, copying the relevant parts of our WooCommerce integration code, and then ripping out and replacing the WooCommerce-specific function calls,&rdquo; said Bahadur.</p>\n\n\n\n<h2>From Inception to the Future</h2>\n\n\n\n<p class=\"has-drop-cap\">Bahadur said his team started the project to meet their own needs. &ldquo;We really liked the idea of being able to use our own servers for WordPress sites. But at the time, there were still a lot of security questions and other usability and support issues that we were running into from the usual pool of SaaS providers.&rdquo;</p>\n\n\n\n<p>He then decided that his team would build something themselves. Jokingly, he said he completely underestimated the project and how far he would take it.</p>\n\n\n\n<p>&ldquo;I can&rsquo;t say that, back in 2019, I looked too far beyond the WP ecosystem because what I wanted was WP-specific functionality,&rdquo; he said. &ldquo;Cloudways was one of a number of providers I was using at the time, and they offered other services beyond WP. But the overall concept was the same whether it was WP or a server that was suitable for another ecosystem. I think I looked at every WP option there was at the time, including command-line services like WordOps.&rdquo;</p>\n\n\n\n<p>He said he was not necessarily sure it was important to have such a project in the WordPress space.</p>\n\n\n\n<p>&ldquo;I think what is important is to constantly remind folks of how much WordPress can do, how powerful it is, and to keep battling against the perception that WordPress is less secure than other options,&rdquo; said Bahadur. &ldquo;If you can use a WordPress plugin to run and manage all your servers and sites and/or even act as a hosting service, then we&rsquo;ve pushed the WP boundaries far beyond what anyone thought of doing two years ago.&rdquo;</p>\n\n\n\n<p>He thinks it is even more important that WordPress professionals to be able to build products that compete against the feature depth and &ldquo;sexiness&rdquo; of SaaS services.</p>\n\n\n\n<p>&ldquo;Think about how much more capital would stay within the WP ecosystem if you had a project management plugin that was as good as, say Clickup.com or Monday.com,&rdquo; said Bahadur. &ldquo;Or a CRM plugin that was as good as Hubspot. But to build plugins with that level of polish requires lots and lots of capital in the first place. Even though WP is a billion-dollar ecosystem, somehow we still don&rsquo;t have the ability to finance the build-out of world-class functional components with a world-class UX experience, and I think that&rsquo;s a shame &mdash; and a major opportunity for VCs.&rdquo;</p>\n\n\n\n<p>He does not think WPCloudDeploy has quite met the smoother UIs of SaaS services yet. However, he believes it can prove that it rivals or exceeds such competitors in terms of functionality.</p>\n\n\n\n<p>&ldquo;So the next time someone asks, &lsquo;can you really build that on WP?&rsquo;, maybe they can point to WPCD and say, &lsquo;Hey, if you can build this on WP, then, hell yeah, we can build that thingamajig that you want&hellip;,&rdquo; said Bahadur.</p>\n\n\n\n<p>The team maintains a Trello board with a <a href=\"https://trello.com/b/pYl53rvM/wpcloud-deploy-public-roadmap\">public roadmap</a>. The most-requested feature right now is support for OpenLiteSpeed, an open-source web server.</p>\n\n\n\n<p>However, Bahadur said the most tantalizing possibilities for the long term come from working with the REST API.</p>\n\n\n\n<p>&ldquo;Unlike SaaS tools, you&rsquo;ll be able to customize it using our built-in ones as a template,&rdquo; he said. &ldquo;Ambitious agencies will be able to add their own plugin to extend our REST API without waiting for us to add new endpoints that meet their needs.&rdquo;</p>\n\n\n\n<p>Eventually, the core plugin will be available on GitHub. Developers will be able to contribute new endpoints to the core product via pull requests.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 09 Oct 2021 00:26:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"WPTavern: Hacktoberfest Adds GitLab Support, Updates Participation Requirements to Combat Open Source Project Spam\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=123630\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:271:\"https://wptavern.com/hacktoberfest-adds-gitlab-support-updates-participation-requirements-to-combat-open-source-project-spam?utm_source=rss&utm_medium=rss&utm_campaign=hacktoberfest-adds-gitlab-support-updates-participation-requirements-to-combat-open-source-project-spam\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4410:\"<p>The <a href=\"https://www.digitalocean.com/blog/hacktoberfest-is-back-2021/\">8th annual Hacktoberfest</a> is underway with a few important changes this year. <a href=\"https://hacktoberfest.digitalocean.com/\">Hacktoberfest</a>, a virtual event sponsored by DigitalOcean and community partners, has traditionally encouraged open source contribution during the month of October by rewarding participants with a t-shirt for submitting pull requests. The initiative has added support for participation on GitLab this year, a highly requested expansion that will include more open source projects that aren&rsquo;t hosted on GitHub.  </p>\n\n\n\n<p>Participation has grown from 676 people the first year to over 150,000 in recent years. In 2021, the program has been changed to be only applicable to opt-in repositories after being linked to an <a href=\"https://twitter.com/jennericthunk/status/1311564600853241858\">influx</a> of <a href=\"https://twitter.com/henrylim96/status/1311357290486722560\">spam</a> for open source maintainers in previous years. Maintainers of popular projects were getting frustrated by wasting their time handling nonsense PR&rsquo;s and marking them as spam during Hacktoberfest. </p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Ugh, oh no, October is starting. Prepare for a month of spam pull requests&hellip; whatwg/html has already been hit hard, at 5 in the last 3 hours.<a href=\"https://twitter.com/hacktoberfest?ref_src=twsrc{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5Etfw\">@hacktoberfest</a>, please please stop this annual tradition of wasting maintainers\' time. You are a net negative for the world.</p>&mdash; Domenic Denicola (@domenic) <a href=\"https://twitter.com/domenic/status/1311355857465225218?ref_src=twsrc{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5Etfw\">September 30, 2020</a></blockquote>\n</div>\n\n\n\n<p>Starting this year, pull requests will only count towards participation if they are in a repository with the &lsquo;<em>hacktoberfest</em>&lsquo; topic and once they have been merged and approved by a maintainer or labeled as &lsquo;<em>hacktoberfest-accepted</em>.&rsquo; Participants must contribute four accepted PR&rsquo;s to an opted-in repo in order to qualify for the free, limited-edition Hacktoberfest t-shirt.</p>\n\n\n\n<p>&ldquo;Maintainers are the backbone of the open-source community and this year, we&rsquo;re focused more than ever on ensuring maintainers are receiving the love they deserve,&rdquo; DigitalOcean Senior Community Relations Manager Phoebe Quincy said. &ldquo;Our maintainer-friendly rules include allowing repos to opt-in to Hacktoberfest, ensuring only accepted pull requests count towards participants&rsquo; Hacktoberfest goals, and for the first time ever, enabling maintainers to receive a Hacktoberfest t-shirt without having to submit pull requests.&rdquo;</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/hacktoberfest?ref_src=twsrc{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5Etfw\">@hacktoberfest</a> is here! Contribute to your favorite open source projects and get awesome swag! What could be better? Since we know <a href=\"https://twitter.com/hashtag/ElasticPress?src=hash&ref_src=twsrc{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5Etfw\">#ElasticPress</a> is your favorite project &#128521;, here\'s a handy link to our Hacktoberfest issues <a href=\"https://t.co/U11660zNAU\">https://t.co/U11660zNAU</a> <a href=\"https://twitter.com/hashtag/WordPress?src=hash&ref_src=twsrc{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5Etfw\">#WordPress</a></p>&mdash; ElasticPressIO (@ElasticPressIO) <a href=\"https://twitter.com/ElasticPressIO/status/1443263706020732928?ref_src=twsrc{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5Etfw\">September 29, 2021</a></blockquote>\n</div>\n\n\n\n<p>Open source maintainers and contributors can join anytime during the month until October 31st. If you maintain a WordPress-related open source project, you can <a href=\"https://hacktoberfest.digitalocean.com/resources/maintainers\">get your project ready</a> to receive contributions by adding the &lsquo;Hacktoberfest&rsquo; topic to your repository, tagging issues with the &lsquo;Hacktoberfest&rsquo; label, and adding a CONTRIBUTING.md file. Maintainers are also encouraged to select issues that have a well-defined scope and are self-contained. Merging PR&rsquo;s, adding the&nbsp;&lsquo;hacktoberfest-accepted&rsquo;&nbsp;label, and marking &lsquo;invalid&rsquo; or &lsquo;spam&rsquo; contributions will all count towards engaged maintenership participation.</p>\n\n\n\n<p> </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 09 Oct 2021 00:20:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"Post Status: Post Status Excerpt (No. 27) — CaboPress and Owning Your Own Content (For Some)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=87584\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://poststatus.com/excerpt/27/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3978:\"<h2>&#8220;While WordPress <em>does</em> democratize publishing there are people today that don’t or (perhaps worse) can\'t take advantage of it.&#8221;</h2>\n\n\n\n<p class=\"has-drop-cap\">In this episode of Post Status Excerpt, Cory comes back freshly tanned from <strong>CaboPress</strong> to share his experiences and one big takeaway point that everyone can appreciate. David brings up how Facebook\'s outage this week made him start to give pause before quipping on Twitter about &#8220;owning your own content.&#8221; He asks if or how WordPress and the open web can help the people for whom Facebook <em>is</em> the internet.</p>\n\n\n\n<p><strong>Also covered in this episode: </strong>A shout out to <strong>WordCamp US 2021</strong> which was held virtually for the first time on October 1st — a fine virtual event after only eight weeks of planning!</p>\n\n\n\n\n\n\n\n<p class=\"has-background\">Every week <strong><a href=\"https://poststatus.com/podcast/the-excerpt/\">Post Status Excerpt</a></strong> will brief you on important WordPress news — in about 15 minutes or less! Learn what\'s new in WordPress in a flash. <img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/26a1.png\" alt=\"⚡\" class=\"wp-smiley\" /><br /><br />You can listen to <a href=\"https://poststatus.com/podcast/the-excerpt/\">past episodes</a> of <strong>The Excerpt</strong>, <a href=\"https://poststatus.com/category/post-status-podcasts/\">browse all our podcasts</a>, and don’t forget to subscribe on <a href=\"https://open.spotify.com/show/1m3xwXbe0MG5BzFVPtB0A7\">Spotify</a>, Amazon Music, <a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5zaW1wbGVjYXN0LmNvbS8ySkU5c2M4UA\">Google Podcasts</a>, <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">iTunes</a>, <a href=\"https://castro.fm/podcast/c53552c6-1ee0-4fc4-9de4-08ed6bf1ee4d\">Castro</a>, <a href=\"https://www.youtube.com/c/PostStatus\">YouTube</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, <a href=\"https://player.fm/series/wordpress-post-status-podcasts\">Player.fm</a>, <a href=\"https://pca.st/05rR\">Pocket Casts</a>, <a href=\"https://wordpress-post-status-draft-podcast.simplecast.com/\">Simplecast</a>, or by <a href=\"https://feeds.simplecast.com/2JE9sc8P\">RSS</a>. <img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /></p>\n\n\n\n<h3 id=\"h-mentioned-in-the-show\"><img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/1f517.png\" alt=\"🔗\" class=\"wp-smiley\" /> Mentioned in the show:</h3>\n\n\n\n<ul><li><a href=\"https://twitter.com/search?q={bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}23CaboPress\">#CaboPress on Twitter</a></li><li><a href=\"https://cabopress.com/\">CaboPress.com</a></li><li><a href=\"https://poststatus.com/wordcamp-us-2021-summary/\">WordCamp US 2021 Summary (Post Status)</a></li><li><a href=\"https://poststatus.com/think-first-before-saying-own-your-own-content/\">Thinking First Before Saying &#8220;Own Your Own Content!&#8221;</a></li><li><a href=\"https://twitter.com/dimensionmedia\" target=\"_blank\" rel=\"noreferrer noopener\">David Bisset (Twitter)</a></li><li><a href=\"https://twitter.com/corymiller303\" target=\"_blank\" rel=\"noreferrer noopener\">Cory Miller (Twitter)</a></li><li><a href=\"https://twitter.com/post_status\" target=\"_blank\" rel=\"noreferrer noopener\">Post Status (Twitter)</a></li></ul>\n\n\n\n<h3><img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> Sponsor: <a href=\"https://poststat.us/ithemes\" target=\"_blank\" rel=\"noreferrer noopener sponsored nofollow\">iThemes</a></h3>\n\n\n\n<p>Take the guesswork out of building, maintaining, and securing WordPress websites. Professional plugins and training from <strong>iThemes</strong> help you create and manage your sites. Secure, back up, and manage them quickly and easily. Master leading-edge WordPress skills to grow your business and make more money. Learn and grow with the experts at <strong>iThemes</strong>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 08 Oct 2021 03:59:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"David Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: Contextually Display Content With the Block Injector Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=123057\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:183:\"https://wptavern.com/contextually-display-content-with-the-block-injector-plugin?utm_source=rss&utm_medium=rss&utm_campaign=contextually-display-content-with-the-block-injector-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5265:\"<p class=\"has-drop-cap\">Jamie Marsland, the founder of Pootlepress, reached out a few weeks ago, asking for feedback on a beta version of <a href=\"https://www.pootlepress.com/block-injector/\">Block Injector</a>.  It was a commercial plugin his team at Pootlepress was gearing up to launch. Earlier this week, they released an updated version that he said he was happy with as an initial release. For a first outing, it has proved to be a handy plugin.</p>\n\n\n\n<p>The concept is not new. Plugins for dynamically injecting content in various places have long existed. In the past, these plugins have allowed users to create content through settings panels, widgets, or even the customizer. Some themes provide such options too. However, Block Injector is the first I have seen that takes this concept and moves it into the block arena.</p>\n\n\n\n<p>The plugin creates a new post type for creating injectable content. Essentially, users can add any blocks they want via the editor and display them at a custom location on the front end.</p>\n\n\n\n<img />Adding a coupon to show at the top of a specific post.\n\n\n\n<p>The plugin has four different conditional rulesets that users can define:</p>\n\n\n\n<ul><li><strong>Location:</strong> Which pages of the site the content appears on.</li><li><strong>Position:</strong> Where on the page the content should display.</li><li><strong>Exceptions:</strong> Post IDs to exclude.</li><li><strong>Schedule:</strong> Date and time-based start and end dates.</li></ul>\n\n\n\n<p>Marsland published a six-minute video that breaks down how it all works:</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>After <a href=\"https://wptavern.com/from-ecommerce-integration-to-location-based-controls-block-visibility-pro-expands-upon-its-free-version\">using Block Visibility</a>, a dedicated plugin for contextually displaying blocks, it is hard not to see anything else as inferior. Its location-based logic provides more flexibility than most will ever need. I have become accustomed to its granular controls. Block Injector&rsquo;s rules are limited in comparison but should work well for the majority of use cases.  I almost want to merge them to see what I can create.</p>\n\n\n\n<p>Block Injector really shines when paired with WooCommerce. The development team added several shop-specific location options.  They also expanded on the positioning rules to utilize a range of WooCommerce hooks. This can create a powerful set of tools for store owners, particularly for seasonal sales. For example, users can display a coupon for the month leading up to Christmas.</p>\n\n\n\n<img />Adding a coupon to show on the WooCommerce shop page.\n\n\n\n<p>One area where I hit a snag was with themes that had grid layouts on the homepage. When injecting content at the top or bottom, it would often get sucked into the post grid.</p>\n\n\n\n<p>This issue is evident in the following screenshot when using the <a href=\"https://wordpress.org/themes/flock\">Flock</a> theme:</p>\n\n\n\n<img />\n\n\n\n<p>My expectation was that it would have spanned the area above the posts. However, I am not sure how easy this would be to fix from the plugin&rsquo;s end because there are only specific places where it is possible to hook into the front-end output. Attempting to correct this via CSS for all grid themes would be futile. However, as we continue to move toward 100{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9} block themes in the future, it may open some alternative routes for injecting such content.</p>\n\n\n\n<p>On the whole, I like the direction I am seeing from this first version. Having run theme and general WordPress support for over a decade, I had an untold number of users ask for similar solutions. I doubt there was a week that went by where I did not field such a question. Block Injector should save many a lot of time.</p>\n\n\n\n<p>I would call the plugin <em>necessary</em> more so than particularly groundbreaking. The community needed someone to step up and build it for the block era.</p>\n\n\n\n<p>Also, Marsland created a fake marketing video for the plugin if you are looking for a quick laugh:</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Amazing to get this testimonial from Korean supergroup ELAST for our Block Injector plugin <a href=\"https://twitter.com/hashtag/wpfakes?src=hash&ref_src=twsrc{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5Etfw\">#wpfakes</a> <a href=\"https://twitter.com/hashtag/gutenberg?src=hash&ref_src=twsrc{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5Etfw\">#gutenberg</a> <a href=\"https://t.co/7kFdq3CzYY\">pic.twitter.com/7kFdq3CzYY</a></p>&mdash; Pootlepress &ndash; busy building Gutenberg Blocks (@pootlepress) <a href=\"https://twitter.com/pootlepress/status/1444301141551026182?ref_src=twsrc{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5Etfw\">October 2, 2021</a></blockquote>\n</div>\n\n\n\n<p>That tweet is just one in a series of videos under the <a href=\"https://twitter.com/hashtag/wpfakes\">#WPFakes hashtag</a>, one of my favorite things on the internet right now.</p>\n\n\n\n<p>Version 1.0.1, the copy I am currently testing, does have a few PHP errors when WooCommerce is not active in specific scenarios. These are trivial to fix, and I have passed along the details to the team. However, I did want to note this to readers who might consider purchasing this for use without WooCommerce. I expect the problems will be fixed in the next release.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 08 Oct 2021 00:39:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: Default Theme Releases May Become More Frequent Following WordPress 5.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=123925\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:207:\"https://wptavern.com/default-theme-releases-may-become-more-frequent-following-wordpress-5-9?utm_source=rss&utm_medium=rss&utm_campaign=default-theme-releases-may-become-more-frequent-following-wordpress-5-9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3240:\"<img />photo credit: <a href=\"https://stocksnap.io/photo/birds-flying-MGGKWIS8CP\">Matt Bango</a>\n\n\n\n<p>The new <a href=\"https://wptavern.com/first-look-at-wordpress-upcoming-twenty-twenty-two-default-theme-the-most-flexible-default-theme-ever-created-for-wordpress\">Twenty Twenty-Two default theme</a> coming in 5.9 hasn&rsquo;t even been fully built yet but many WordPress enthusiasts who saw yesterday&rsquo;s design reveal are already eager to use it on their sites. Contributors have just 40 days before the <a href=\"https://make.wordpress.org/core/5-9/\">scheduled Beta 1 release</a> on November 16 to get the theme ready. While that seems like an impossibly tight deadline, more frequent default theme releases may be ahead on the horizon.</p>\n\n\n\n<p>In a couple of short paragraphs tucked into the end of the announcement, Kjell Reigstad commented on the future of default theme release frequency:</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>The community has produced a dozen best-in-class themes together, and we&rsquo;ve come to look forward to a new one arriving at the close of each year. That said, themes are in a transition period today, and it seems like this may be a reasonable time to step back and to re-evaluate the annual cadence with which we build default themes.&nbsp;</p><p>Innovations like theme.json, block templates, and block patterns are making theme development far simpler, and are providing new ways for users to customize their sites. There&rsquo;s reason to believe that the community can leverage all this to build more frequent and diverse theme and customization solutions for our users in the coming years.&nbsp;</p></blockquote>\n\n\n\n<p>It wasn&rsquo;t clear whether Reigstad meant that the cadence of default theme releases would be slowing down or speeding up. I asked him for clarification and he confirmed that the idea is to consider the possibility of speeding up.</p>\n\n\n\n<p>&ldquo;I hope these new tools allow us to create and release more frequently than we&rsquo;ve been able to in the past,&rdquo; Reigstad said.</p>\n\n\n\n<p>&ldquo;The general idea came up as part of the ideation process for the default theme this year, and that part of the post is meant to give it a wider platform for conversation in the community. I&rsquo;m excited to hear what other folks think since this idea is in its very early days! I really think there&rsquo;s a lot of opportunity here.&rdquo;</p>\n\n\n\n<p>&nbsp;The ideation process he referenced, which varies from year to year, included early conversations with project leadership to plan and make sure the theme is aligned with the future of WordPress. </p>\n\n\n\n<p>Before the discussion officially kicks off regarding increasing default theme release frequency, contributors are focused on getting Twenty Twenty-Two out the door. Reigstad said people can jump in on testing now, as the general structure is already in place. This includes fonts, colors, and basic templates, although details like spacing and specific block styles are still in progress along with block patterns. If you want to contribute to making Twenty Twenty-Two the best it can be, check out the <a href=\"https://github.com/wordpress/twentytwentytwo\">development happening on GitHub</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 07 Oct 2021 20:14:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: The HeroPress Network Launches as a Multi-Project Portal\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=123904\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:177:\"https://wptavern.com/the-heropress-network-launches-as-a-multi-project-portal?utm_source=rss&utm_medium=rss&utm_campaign=the-heropress-network-launches-as-a-multi-project-portal\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5911:\"<p class=\"has-drop-cap\">Husband-and-wife duo Topher and Cate DeRosia announced the <a href=\"https://heropressnetwork.com/heropress-expands-into-the-heropress-network/\">launch of the The HeroPress Network</a> earlier today. It is a collection of content from various sites they are working on in a centralized location.</p>\n\n\n\n<p>&ldquo;Its overarching goal is to be a hub,&rdquo; said Cate DeRosia. &ldquo;It will display the newest items from around the HeroPress Network, as well as news from the community (to be added in shortly). We can also post information that we think is helpful or educational.&rdquo;</p>\n\n\n\n<p>The &ldquo;hub&rdquo; will incorporate content from at least eight projects:</p>\n\n\n\n<ul><li><a href=\"https://heropressnetwork.com/\">The HeroPress Network</a></li><li><a href=\"https://heropress.com/\">HeroPress</a></li><li><a href=\"http://www.hallwaychats.com/\">Hallway Chats</a></li><li><a href=\"https://wppodcasts.com/\">WP Podcasts</a></li><li><a href=\"http://www.finditwp.com/\">Find It WP</a></li><li>Slack group</li><li>+2 additional projects in production</li></ul>\n\n\n\n<p>The team launched WP Podcasts two weeks ago, making over 7,000 current episodes from dozens of WordPress shows available in one place. Find It WP is currently in beta and will be the next project to launch on or before October 19.  They will soon launch the public Slack group with dedicated channels for different types of professionals.</p>\n\n\n\n<img />The HeroPress Network homepage.\n\n\n\n<p>&ldquo;You could say it&rsquo;s like the portals of yesteryear,&rdquo; said DeRosia. &ldquo;With HeroPress expanding into 8+ or more entities, we wanted one place for people to go and get the most current glimpse of what&rsquo;s happening.&rdquo;</p>\n\n\n\n<p>She also teased the idea of expanding their educational offerings in the announcement post. However, news on that will have to wait until they build out the projects currently underway.</p>\n\n\n\n<p>The team will open funding options on October 24.  The HeroPress Network is a for-profit company, but its goal is to make all of its content available for free to the community as a whole.</p>\n\n\n\n<p>The original HeroPress.com website <a href=\"https://wptavern.com/heropress-fails-to-attract-backers-cancels-kickstarter-campaign-ahead-of-deadline\">did not hit its funding goal</a> in 2015. It attracted 33 backers who pledged $21,855 of its $60,000 AUD goal on Kickstarter. There was <a href=\"https://wptavern.com/heropress-launches-kickstarter-campaign-to-highlight-wordpress-developers\">some early pushback</a>, particularly from WordPress lead developer Andrew Nacin <a href=\"https://twitter.com/nacin/status/558347928977145856?ref_src=twsrc{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5Etfw{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}7Ctwcamp{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5Etweetembed{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}7Ctwterm{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5E558347928977145856{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}7Ctwgr{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5E{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}7Ctwcon{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5Es1_&ref_url=https{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}3A{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2F{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2Fwptavern.com{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2Fheropress-launches-kickstarter-campaign-to-highlight-wordpress-developers\">who cited</a> its &ldquo;unambiguous hero worship&rdquo; and the initial male-only lineup of speakers as problems. However, much has changed in the six years since the fundraiser.</p>\n\n\n\n<p>DeRosia called the first fundraising event a test to see how the community would receive it. The project has never been funded financially since then. Hosting and resources have been provided for the project, and a few other companies have occasionally donated toward their time and tools.</p>\n\n\n\n<p>Despite failing to raise their initial funds, the project continued onward. Today, HeroPress has been a success by simply providing a platform for people to share their journeys in the WordPress world.</p>\n\n\n\n<p>Andrey &ldquo;Rarst&rdquo; Savchenko wrote the <a href=\"https://heropress.com/essays/finding-your-place/\">first essay</a> in March 2015. Since then, the site has published over 200 others.</p>\n\n\n\n<p>&ldquo;It&rsquo;s always been a challenge to figure out how to fund the project,&rdquo; said DeRosia. &ldquo;When the pandemic hit and sponsors had money they couldn&rsquo;t use on WordCamps, they started some conversations with us. We&rsquo;ve been kicking around ideas since then and feel The HeroPress Network gives us the best resource for reasonable funding. We want to be giving value back to both the community and supporters, and the diversity of what makes up the Network provides more options.&rdquo;</p>\n\n\n\n<p>If everything falls into place, DeRosia herself or one of their daughters could have a salaried position for the project. Her background is in English and journalism, and she described it as a &ldquo;dream job.&rdquo;</p>\n\n\n\n<p>I asked DeRosia why she was personally vested in this project. What was it that got her up every morning to build it?</p>\n\n\n\n<p>&ldquo;Topher and I both grew up rural poor here in the US,&rdquo; she said. &ldquo;We come from communities dying because there aren&rsquo;t jobs. WordPress has always been such an excellent answer to this.</p>\n\n\n\n<p>&ldquo;With HeroPress.com we&rsquo;re able to provide a stage where people can tell their stories of how they&rsquo;ve built their lives regardless of where they lived or what circumstances they were living in. That&rsquo;s great, but it only goes so far.</p>\n\n\n\n<p>&ldquo;Now with The HeroPress Network, we can provide simplified, searchable access to practical tools that anyone can use to craft the life they want using the WordPress platform. We can also demonstrate how community and business can work together to get the best for both.</p>\n\n\n\n<p>&ldquo;If the option for something better is out there, I want to help people find it. Helping new people get started in WordPress brings a richness to the community that it needs to thrive. Helping established businesses connect with people and resources continues the growth.</p>\n\n\n\n<p>&ldquo;It&rsquo;s just so incredible to have the privilege to see people build relationships that allow them to flourish. And who wouldn&rsquo;t get out of bed every morning to do that?&rdquo;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Oct 2021 23:44:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:143:\"WPTavern: First Look at WordPress’ Upcoming Twenty Twenty-Two Default Theme: “The Most Flexible Default Theme Ever Created for WordPress”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=123061\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:311:\"https://wptavern.com/first-look-at-wordpress-upcoming-twenty-twenty-two-default-theme-the-most-flexible-default-theme-ever-created-for-wordpress?utm_source=rss&utm_medium=rss&utm_campaign=first-look-at-wordpress-upcoming-twenty-twenty-two-default-theme-the-most-flexible-default-theme-ever-created-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4220:\"<p><a href=\"https://make.wordpress.org/core/2021/10/06/introducing-twenty-twenty-two/\">Twenty Twenty-Two</a>, the new default theme coming in WordPress 5.9, was unveiled today on WordPress.org. The design goes full steam ahead in support of full site editing and new customization capabilities.</p>\n\n\n\n<p>Like its predecessor, <a href=\"https://make.wordpress.org/core/2020/09/23/introducing-twenty-twenty-one/\">Twenty Twenty-One</a>, the new default theme makes some bold design choices wrapped around a central theme. In this case it&rsquo;s bird illustrations, complemented by <a href=\"https://adobe-fonts.github.io/source-serif\">Source Serif Pro</a>&nbsp;for headlines, and a <a href=\"https://make.wordpress.org/core/files/2021/10/Example-Layouts-scaled.jpg\">delicious array of patterns</a> for limitless combinations.</p>\n\n\n\n<img />Image Credit: <a href=\"https://make.wordpress.org/core/2021/10/06/introducing-twenty-twenty-two/\">Introducing Twenty Twenty-Two</a>\n\n\n\n<p>The theme will be <a href=\"https://github.com/wordpress/twentytwentytwo\">developed on GitHub</a> until it&rsquo;s ready to be merged into core. Kjell Reigstad, an Automattic sponsored full-time design contributor to WordPress.org, is leading the design with Jeff Ong leading development. In the announcement he sets expectations high for users to be able to make the theme their own.</p>\n\n\n\n<p>&ldquo;With the advent of Full Site Editing and Global Styles, themes are changing structurally and functionally to enable far more avenues for customization than users have come to expect in the past,&rdquo; Reigstad said. &ldquo;To take advantage of these new abilities, <strong>Twenty Twenty-Two has been designed to be the most flexible default theme ever created for WordPress.</strong>&rdquo;&nbsp;&nbsp;</p>\n\n\n\n<p>In addition to the wide variety of patterns expected to ship with this theme, Twenty Twenty-Two will offer a lively selection of six pre-designed color palettes. Reigstad shared a video preview of how they instantly change the character of the theme. (see below) Combine this with the promise of being able to manipulate every aspect of the theme&rsquo;s appearance through global styles, and users are in for a treat with WordPress 5.9.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>&ldquo;Twenty Twenty-Two will take advantage of a wide&nbsp;network&nbsp;of page templates, headers, footers, and other patterns so that users can easily make the theme their own,&rdquo; Reigstad said. &ldquo;In another nod to the behavior of birds everywhere, these will offer a balance between fun and utility: some are irregular and unpredictable, while others are straightforward and traditional. Together, these patterns will act as a window into all of the possibilities that the theme enables.&rdquo;</p>\n\n\n\n<p>The design preview for Twenty Twenty-Two has received overwhelming positive <a href=\"https://twitter.com/search?q=https{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}3A{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2F{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2Fmake.wordpress.org{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2Fcore{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2F2021{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2F10{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2F06{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2Fintroducing-twenty-twenty-two{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2F&src=typed_query\">feedback on Twitter</a> and in the comments of the <a href=\"https://make.wordpress.org/core/2021/10/06/introducing-twenty-twenty-two/\">announcement</a>. Many users were excited to see a default theme that can be quickly transformed for so many applications. Too many default themes have only been applicable to a narrow set of use cases. In the past, users had little hope of being able to change things around to make the design work for their needs. Unrelenting progress on the block editor and full site editing has made it possible for Twenty Twenty-Two to become the most user-empowering default theme in WordPress&rsquo; history.</p>\n\n\n\n<p>Reigstad said the theme will be &ldquo;built for Full Site Editing first,&rdquo; with as little CSS as possible, and all theme styles configurable through theme.json wherever possible, so users can edit them through Global Styles.</p>\n\n\n\n<p>&ldquo;Twenty Twenty-Two is designed with the acknowledgement that its default appearance is not most people&rsquo;s endpoint,&rdquo; Reigstad said. &ldquo;Everyone deserves a truly unique website, built on a solid, well-designed foundation, and Twenty Twenty-Two aims to help them achieve that.&rdquo;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Oct 2021 20:59:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"HeroPress: What’s Next For HeroPress?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://heropress.com/?p=4162\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"https://heropress.com/whats-next-for-heropress/#utm_source=rss&utm_medium=rss&utm_campaign=whats-next-for-heropress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4748:\"<img width=\"1024\" height=\"685\" src=\"https://heropress.com/wp-content/uploads/2022/10/nikola-jovanovic-OBok3F8buKY-unsplash-1024x685.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Closeup of a woman\'s hands holding a double handful of dirt with a green plant growing out of it.\" /><p>For years now people have been asking me &#8220;So what&#8217;s next for HeroPress?&#8221; and I didn&#8217;t have a good answer. I was content to let it just be inspirational essays forever. But as the years went by, I began to feel more and more that I wanted to go one step further, and start providing resources to those newly inspired people. Some direction, now that they&#8217;re convinced they that too can Do It.</p>\n<p>About a year ago my wife <a href=\"https://twitter.com/mysweetcate\">Cate</a> asked, &#8220;What if we were able to fund this, so I could take on the HeroPress work as my full time job? Then, we could start doing a lot more.&#8221; And thus began a series of conversations that still hasn&#8217;t ended.</p>\n<p>We didn&#8217;t want to ask people to help financially without offering them something more in return, so we started brain storming about what we could make that people would value. We came up with MANY ideas which we didn&#8217;t follow up on, but we also came up with some GREAT ones that we <em>did</em> do.</p>\n<h3>Great Ideas We&#8217;ve Acted On</h3>\n<p>Last week we released <a href=\"https://wppodcasts.com\">WP Podcasts</a>, which aggregates all the episodes from all the WordPress podcasts we can find, so you can search by keyword or tag and find individual episodes across all of them.  For playback and subscription we direct you back to the original site, driving traffic back to the podcaster.</p>\n<p>You probably already know about <a href=\"https://hallwaychats.com\">Hallway Chats</a>, and then there&#8217;s <a href=\"https://heropress.com/\">this site</a> (HeroPress.com).</p>\n<p>Soon we’ll be releasing Find It WP (think Yahoo for WordPress), a curated listing of everything in WordPress. A curated listing of everything in WordPress.  Every podcast, every email newsletter, every dev agency, every theme shop, and on forever. If it&#8217;s WordPress, it&#8217;ll be in there, assuming they choose to sign up. There are a couple more sites in the hopper as well, but I&#8217;ll tell you more about them another day.</p>\n<h3>Today&#8217;s Announcement</h3>\n<p>TODAY I&#8217;m excited to announce the next new thing for HeroPress: <a href=\"https://heropressnetwork.com\">The HeroPress Network</a>. This is a site that serves several purposes.</p>\n<ul>\n<li>To aggregate everything from all of the HeroPress properties into one site, the latest essay, Hallway Chat, WordPress Podcast episode, new thing on Find It WP, etc.</li>\n<li>A community news blog. Think People magazine, but less smarmy.</li>\n<li>A platform for video and text tutorials and training produced by the HeroPress team. You can go <a href=\"https://heropressnetwork.com/video/saving-a-wordpress-search-as-rss/\">see the first WordPress Tip Of The Week right here</a>!</li>\n</ul>\n<h3>Future Needs</h3>\n<p>As you can see, with what we have going on now plus what we have planned, we have MORE than enough work for a full time employee.</p>\n<p>For this reason, on October 24th 2021 we&#8217;re going to open up funding opportunities.</p>\n<p>This isn&#8217;t an Event with a goal and a thermometer to track funds received, or balloons and a band. This is going to be more like a Patreon, where we&#8217;re looking for people who are willing to support the project long term. Don&#8217;t get me wrong, we won&#8217;t turn down one-time help, but if this is going to grow it needs long term support.</p>\n<p>On the technical side of funding, we&#8217;re choosing to use <a href=\"https://givewp.com\">GiveWP</a> instead of Patreon for a few important reasons.</p>\n<ol>\n<li>We&#8217;re all in on the WordPress ecosystem. We want to show that it can be done, and done well, in WordPress.</li>\n<li>Another is the old story of owning your platform. We don&#8217;t want to depend on other sites if we don&#8217;t have to. We&#8217;re going to have to write some code to make GiveWP work like Patreon, but that just means we&#8217;ll have one more thing to give back to the community.</li>\n</ol>\n<p>It&#8217;s been nearly seven years since HeroPress started, and I&#8217;m excited to see it blossom into something even greater.</p>\n<p><span class=\"_1K5LX _1ByhS\">Photo by <a href=\"https://unsplash.com/@danteov_seen?utm_source=unsplash&utm_medium=referral&utm_content=creditCopyText\">Nikola Jovanovic</a> on <a href=\"https://unsplash.com/s/photos/growing?utm_source=unsplash&utm_medium=referral&utm_content=creditCopyText\">Unsplash</a> </span></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Oct 2021 20:07:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WPTavern: WordCamp US 2021 Draws More Than 3600 Attendees\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=123714\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:159:\"https://wptavern.com/wordcamp-us-2021-draws-more-than-3600-attendees?utm_source=rss&utm_medium=rss&utm_campaign=wordcamp-us-2021-draws-more-than-3600-attendees\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4687:\"<p><a href=\"https://us.wordcamp.org/2021/\">WordCamp US</a> took place online last Friday. Organizers pulled off a successful one-day event with an engaging group of speakers who highlighted timely and important topics. There were 3,608 people registered for the event and the livestream had as many as 400 concurrent viewers at a time.</p>\n\n\n\n<p>&ldquo;Online events are notoriously difficult to get attendee stats for, particularly an event like WCUS 2021 where the audience is global and spans so many time zones,&rdquo; WCUS organizer Cate DeRosia said. &ldquo;Many people will watch what they can and catch the rest in their own time.</p>\n\n\n\n<p>&ldquo;We really love this as it makes for not only a more accessible event, but a more educational experience as it&rsquo;s so easy to rewatch a session as many times as an individual needs.&rdquo;</p>\n\n\n\n<p>When <a href=\"https://twitter.com/jati/status/1443978800010711045\">asked on Twitter</a> why the event&rsquo;s organizers didn&rsquo;t opt to use a more interactive event platform like Hopin or Veertly, organizer Jen Swisher said some of the platforms they looked into had accessibility issues or prohibitive costs. </p>\n\n\n\n<p>As part of the leadership trio for WCUS, Swisher said the team had three issues they focused on when choosing a virtual venue: cost, accessibility, and time for implementation.</p>\n\n\n\n<p>&ldquo;We had a $30K budget,&rdquo; Swisher said. &ldquo;To use one of these platforms would have doubled it minimum. There was also a strong chance we would have faced additional costs from our production company for our resources through them to learn this new platform and connect it with their equipment.</p>\n\n\n\n<p>&ldquo;This would have resulted in additional time and resources spent on fundraising or increasing the costs of our sponsor packages. This would have forced the volunteers on the sponsors team to do twice as much work to get the sponsorship necessary to fund other platforms.&rdquo;</p>\n\n\n\n<p>Even with the simple setup of two YouTube livestreams, organizers provided a high energy, welcoming reception to attendees. They managed to bring some levity during these challenging times apart from one another. Swisher highlighted a few deliberate choices organizers made to give this year&rsquo;s event a more lightweight feeling:</p>\n\n\n\n<p>&ldquo;We didn&rsquo;t try to replicate the in person experience,&rdquo; she said. &ldquo;Making the choice to actively recognize that this isn&rsquo;t like in person events in any way gave everyone permission to think about this event differently. By throwing out &lsquo;the book,&rsquo; and starting from scratch, we were able to really &lsquo;dream&rsquo; for the event, instead of what it could have been.&rdquo;</p>\n\n\n\n<p>Instead of planning a big multi-day event, organizers opted for a single day focusing on a smaller subset of topics. They also selected chat moderators and emcees that would bring enthusiasm to the event and gave them the autonomy to make decisions on the fly.</p>\n\n\n\n<p>&ldquo;The team agreed that a big event with multiple days and large numbers of tracks would be exhausting to plan and exhausting for attendees to sit through,&rdquo; Swisher said. </p>\n\n\n\n<p>After <a href=\"https://wptavern.com/wordcamp-us-2020-canceled-due-to-pandemic-stress-and-online-event-fatigue\">WordCamp US 2020 was cancelled</a> due to pandemic stress and online event fatigue, the organizing team needed to make some changes to avoid the pitfalls of the previous year. Organizers were drained, spread thin, and frustrated by delayed tasks and external stressors. The WCUS 2021 team turned this around to make it a more healthy culture for volunteers. </p>\n\n\n\n<p>&ldquo;We fostered an atmosphere where stepping back to take care of yourself was strongly encouraged,&rdquo; Swisher said. &ldquo;This resulted in a team of folks that was well rested and able to handle the extra responsibility that comes with planning a WordCamp.&rdquo;</p>\n\n\n\n<p>&ldquo;We gave the teams the autonomy necessary to get their work done. Decision making was done democratically, but decisions that didn&rsquo;t impact the whole team didn&rsquo;t involve the whole team, making it possible to move more agilely.&rdquo;</p>\n\n\n\n<p>The speaker selection was outstanding this year and the recorded sessions will soon be available on <a href=\"https://wordpress.tv/\">WordPress.tv</a> after the production team finishes uploading them. In the meantime, if you are eager to watch or re-watch sessions now, one attendee, Marcus Burnette, has published a post with <a href=\"https://mburnette.com/blog/wordcamp-us-2021/\">direct links to session recordings</a> from the livestream.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Oct 2021 15:29:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: #8 – Lee Shadle on How Blocks Create New Opportunities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=123863\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:175:\"https://wptavern.com/podcast/8-lee-shadle-on-how-blocks-create-new-opportunities?utm_source=rss&utm_medium=rss&utm_campaign=8-lee-shadle-on-how-blocks-create-new-opportunities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54420:\"<h2>About this episode.</h2>\n\n\n\n<p>On the podcast today we have <a href=\"https://profiles.wordpress.org/leeshadle/\">Lee Shadle</a>.</p>\n\n\n\n<p>Lee is a WordPress developer at <a href=\"https://wpdraft.com/\">WP Draft</a>, and by his own admission is obsessed with building block based themes, plugins and websites. He&rsquo;s been using WordPress for many years and as soon as the Gutenberg project was announced, he decided he was going to explore it and learn how it worked.</p>\n\n\n\n<p>He runs a small agency building sites with blocks as well as with 3rd party page builders.</p>\n\n\n\n<p>I first saw Lee when he presented at WordCamp Europe earlier in 2021, and his passion for working with blocks and React was obvious. It&rsquo;s pretty clear that, right from the start, he&rsquo;s embraced the possibilities that blocks offer, both now and in the future.</p>\n\n\n\n<p>At the time of recording this podcast, many are still unsure about what blocks are for, and what they will be able to do down the road, but Lee has thrown himself into figuring out what&rsquo;s possible, and it might come as a surprise just how powerful they are.</p>\n\n\n\n<p>We start our conversation by addressing whether Gutenberg was something that the WordPress project actually needed. Was it necessary to build a new tool which would require people to learn new skills and new techniques?</p>\n\n\n\n<p>We then get into some concrete examples of how blocks will add new capabilities to websites. Some of the examples show that complex operations can be handled within single blocks. These possibilities were once the domain of plugins and shortcodes, and now they can be deployed and configured by anyone who edits content.</p>\n\n\n\n<p>We talk about the obstacles which Lee encountered whilst learning how to build blocks. In his case, he worked on projects which he knew he would enjoy. We also touch upon some resources he used to assist in his learning.</p>\n\n\n\n<p>There&rsquo;s also a discussion about the commercial landscape for block developers and how blocks might become a new way of generating revenue. Although we&rsquo;re not there yet, it might well be that in the future, WordPress users will be on the lookout to purchase blocks in the same way that they now buy plugins and themes. Perhaps there&rsquo;s even scope for a market of inexpensive blocks which have limited functionality.</p>\n\n\n\n<p>As you&rsquo;ll hear, Lee is very optimistic about the future of WordPress, with blocks at it&rsquo;s core.</p>\n\n\n\n<h2>Useful links.</h2>\n\n\n\n<p><a href=\"https://twitter.com/leeshadle\">Lee&rsquo;s Twitter account</a></p>\n\n\n\n<p><a href=\"https://stimulusbenefits.com/\">Stimulus Benefits</a> &ndash; Lee&rsquo;s calculator block</p>\n\n\n\n<p><a href=\"https://wpaino.com/\">Aino</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/block-visibility/\">Block Visibility</a></p>\n\n\n\n<p><a href=\"https://newsletterglue.com/\">Newsletter Glue</a></p>\n\n\n\n<p><a href=\"https://reactforbeginners.com/\">React for beginners</a></p>\n\n\n\n<p><a href=\"https://generateblocks.com/\">GenerateBlocks</a></p>\n\n\n\n<p><a href=\"https://www.nickdiego.com/\">Nick Diego</a></p>\n\n\n\n<p><a href=\"https://mikeoliver.me/\">Mike Oliver</a></p>\n\n\n\n<p><a href=\"https://briangardner.com/\">Brian Gardner</a></p>\n\n\nTranscript<div><div class=\"chat-transcript\"><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:00:00]</div> <div class=\"chat-text\"><p>Welcome to the eighth edition of the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley. Jukebox is a podcast which is dedicated to all things WordPress, the people, the events, the plugins, the themes, and the blocks. Every month, we&rsquo;re bringing you someone from that community to discuss a topic of current interest.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"> <div class=\"chat-text\"><p>If you like the podcast, please share it with your friends. And you might also like to think about subscribing, so that you can get all of the episodes in your podcast player automatically. You can do that by searching for WP Tavern in your podcast player, or by going to WP tavern dot com forward slash feed forward slash podcast.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"> <div class=\"chat-text\"><p>You can also play the podcast episodes on the WP Tavern website, if you prefer that approach. If you have any thoughts about this podcast, perhaps suggestion of a guest or an interesting subject, then do head over to WP tavern dot com forward slash contact forward slash jukebox and use the form there. And we would certainly welcome your input.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"> <div class=\"chat-text\"><p>Okay, so on the podcast today, we have Lee Shadle. Lee is a WordPress developer at WP Draft, and by his own admission is obsessed with building block-based themes, plugins, and websites. He&rsquo;s been using WordPress for many years, and as soon as the Gutenberg project was announced, he decided he was going to explore it and learn how it worked.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"> <div class=\"chat-text\"><p>He runs a small agency building sites with blocks, as well as third party page builders. I first saw Lee when he presented at WordCamp Europe earlier in 2021. And his passion for working with blocks and react was obvious. It was pretty clear, right from the start, he&rsquo;s embraced the possibilities that blocks offer both now and in the future. At the time of recording this podcast, many are still unsure about what blocks are for and what they will be able to do down the road. But Lee has thrown himself into figuring out what&rsquo;s possible and it might come as a surprise to you just how powerful.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"> <div class=\"chat-text\"><p>We start our conversation by addressing whether Gutenberg was something that the WordPress project actually needed. Was it necessary to build a new tool, which would require people to learn new skills and new techniques.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"> <div class=\"chat-text\"><p>We then get into some concrete examples of how blocks will add new capabilities to websites. Some of the examples show that complex operations can be handled within single blocks. These possibilities were once the domain of plugins and shortcodes, and now they can be deployed and configured by anyone who edits content.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"> <div class=\"chat-text\"><p>We talk about the obstacles which Lee encountered whilst learning how to build blocks. In his case, he worked on projects, which he knew that he would enjoy. We also touch upon some resources, used to assist him in his learning.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"> <div class=\"chat-text\"><p>There&rsquo;s also a discussion about the commercial landscape for block developers and how blocks might become a new way of generating revenue. Although we&rsquo;re not there yet, it might well be that in the future, WordPress users will be on the lookout to purchase blocks in the same way that they now buy plugins and themes. Perhaps there&rsquo;s even scope for a market of inexpensive blocks, which have limited functionality.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"> <div class=\"chat-text\"><p>As you&rsquo;ll hear Lee is very optimistic about the future of WordPress with blocks at its core.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"> <div class=\"chat-text\"><p>If any of the points raised in this podcast, resonate with you, be sure to head over and find the post at wptavern dot com forward slash podcast, and perhaps leave us a comment there.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"> <div class=\"chat-text\"><p>And so without further delay, I bring. Lee Shadle.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"> <div class=\"chat-text\"><p>I am joined on the podcast today by Lee Shadle. Hello Lee.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:04:16]</div> <div class=\"chat-text\"><p>Hey Nathan.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:04:17]</div> <div class=\"chat-text\"><p>It&rsquo;s lovely to have you on the podcast today. Before we get stuck into it, I&rsquo;ll ask the traditional set of mandatory questions at the start. Would you mind telling us a little bit about yourself, your background in WordPress, technology? You can go back as far as you feel necessary. Probably limit it to the WordPress side of things.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:04:35]</div> <div class=\"chat-text\"><p>Okay. So I was born in Columbus, Ohio, but I shouldn&rsquo;t go back to Ohio days. Huh? I shouldn&rsquo;t go back all the way back to my birth. So I am a self-taught developer, mostly front end developer, and I&rsquo;ve been doing it for about 10 years. I started building custom client sites and I made my way to WordPress about five years ago. And really, the thing that actually really drew me in was when Gutenberg launched, because it really used all my skillsets of JavaScript, React, CSS. And so since then, I&rsquo;ve been really the last five years or so been focused on building blocks. I kind of nonstop, but kind of had an insane obsession with it. You could ask my wife, all I do is talk about blocks and building blocks. So to pay the bills, I&rsquo;ve been building client sites and I&rsquo;ve been trying to build tools with blocks to help streamline my processes of the client work. So that&rsquo;s what brings me here today. Is that black building obsession.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:05:39]</div> <div class=\"chat-text\"><p>Very nice. Well, we will get thoroughly immersed in all of that in a little while. Just before that, I wanted to know what your thoughts are on whether or not WordPress needed to put this into core, the ability to build your website now let&rsquo;s say, but initially, to create your content around blocks. Did you feel at the time, obviously subsequently you&rsquo;ve gotten into it and been enjoying what it has brought to the table, but I&rsquo;m wondering if you can cast your mind back to that time when it did come in. Was there a light that went off and you thought, actually this is tremendously interesting or were you like many people were, and to some extent still are kind of reluctant to use it and keen to have the old editor back or move away to some sort of proprietary page builder?</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:06:25]</div> <div class=\"chat-text\"><p>Being a front end developer, when I started hearing about React being in WordPress, that really got me going, because to me, it really opens up a bunch of possibilities that can really allow you to build, you know, really snappy interfaces and really fun products and stuff that you couldn&rsquo;t build before.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"> <div class=\"chat-text\"><p>You can almost, I know there&rsquo;s been talk about WordPress being the OS of the internet. And I think it really opens up that possibility. I started dipping my toes into WordPress right before Gutenberg launched. And I did a deep dive into building themes and plugins the old way. And then right about a year into me learning how to do that, I started diving deep into Gutenberg. And, I definitely think it was a good move. Although all change, you know, change can sometimes be painful and there&rsquo;s definitely a steep learning curve, but I think the pain is going to be worth it in the long run.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:07:29]</div> <div class=\"chat-text\"><p>I feel that at the moment, there is a lot of pain being experienced by a variety of different people. And some people like yourself have decided to absorb that pain and go with it. Other people have found it very difficult and there&rsquo;s been politics, shall we say has crept into WordPress in a way that I&rsquo;ve not really seen too much of before, and people wishing that it hadn&rsquo;t have been put into core and that it had of been a plugin instead. Other people obviously just wished that the entire thing would go away and ended up forking WordPress and creating this ClassicPress version of WordPress. So it has really divided the community. I feel that maybe talks like this, will address that a little bit because you&rsquo;ve obviously been exploring it and you&rsquo;ve probably got some great ideas about things that it will enable that perhaps the rest of us haven&rsquo;t really foreseen.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"> <div class=\"chat-text\"><p>I know for my part, I&rsquo;ve seen a few videos of things that people are building. Products that are either just about to come out or have already come out and you just think, okay, that&rsquo;s interesting because that&rsquo;s totally wedded to the idea of a block and without the block methodology, that exact thing could not have been done, possibly even as a plugin. So I&rsquo;m just curious if you&rsquo;ve got any thoughts about what can be done with blocks that we could not have done before.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:08:44]</div> <div class=\"chat-text\"><p>I&rsquo;m going to go as a bold as to say, I think, think of every traditional plugin or theme business in WordPress. I believe with the advent of Gutenberg, everything is ripe for disruption.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"> <div class=\"chat-text\"><p>I think every single aspect, like think about forms or think about pop-ups or think about payments. Really any facet of the WordPress economy that you can think of, that people are making a living on, I think it could be disrupted with Gutenberg.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:09:15]</div> <div class=\"chat-text\"><p>Yeah. I think you&rsquo;re probably right. We&rsquo;ve certainly seen some . Of those things. I&rsquo;ve seen some projects certainly around the forms space where, you know, you just think, oh, well the interface of Gutenberg really does lend itself to creating sort of drag and drop form builder. It&rsquo;s really remarkable for that. Aside from those sort of more general ideas, do you have any concrete examples of things that you&rsquo;ve gotten yourself into and projects that you&rsquo;ve created, or been party to where there&rsquo;s been an end result that we could all identify with and understand why you&rsquo;re so excited about it.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:09:46]</div> <div class=\"chat-text\"><p>I&rsquo;ve been building blocks, all kinds of different types of blocks, trying to uncover. I run a small agency, so my workflow and system of building a site for client is super important to me. And I know there are a ton of tools with the classic way of building WordPress built around optimizing that workflow. But that&rsquo;s really been my focus is how do we leverage the system to really like streamline the workflow of building sites for clients? I build a lot of sites for fun for myself. Really. I&rsquo;m all about building quickly.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"> <div class=\"chat-text\"><p>I don&rsquo;t know if I told you this Nathan, but when I was in my previous life, I used to own a restaurant and I came up with, you know, the menu and the food, and imagine it was an Italian version of Chipotle at the early days of Chipotle, and, you know, I ran it for a couple years and it just failed miserably. I lost, I kind of lost everything in that. But I learned a lot of great lessons and one of those lessons was I want to be able to keep stepping up to the plate. And in order to do that, to keep trying, I needed to come up with systems and processes that allow me to do that in a way that it isn&rsquo;t heavy handed. And I can just hack away at an idea in a day. And I kinda think that is the essence of WordPress. And I think that Gutenberg is kind of taken us back to that essence of, okay, what can I hack away at? I think we&rsquo;re just starting to hit the point of stability with Gutenberg and with full site editing coming out and block-based themes where you&rsquo;re going to be able to build full blown prototypes and mock-ups of, you know, not just like static sites, but some pretty complex stuff pretty quickly. Imagine launching, you know, I don&rsquo;t know if you saw Flip WP, they&rsquo;re launching a marketplace for selling WordPress plugins and themes and WordPress businesses. I think something like that is going to become a lot easier to do. Like iterating on an idea like Flip WP, like say I want to try it, test the waters of building a marketplace for buying and selling WordPress businesses. I think, being able to build startups and more complex businesses is going to become a lot easier to do with Gutenberg</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:12:10]</div> <div class=\"chat-text\"><p>When you&rsquo;ve been creating your blocks at the beginning, I&rsquo;m just curious as to how obviously you fell into it and you&rsquo;re now enjoying it. Were there any significant obstacles along the way that you encountered? So as an example, was there enough documentation? Was it fairly easy to get yourself up to speed with how to create your own blocks? Was there a lot of support around? Were there some channels or books that you perhaps ended up relying upon? I&rsquo;m just trying to get to the idea of how easy or difficult it was, or perhaps still is.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:12:39]</div> <div class=\"chat-text\"><p>I&rsquo;ll be honest with you. It&rsquo;s been a challenge. It&rsquo;s been a frustrating journey. There&rsquo;s been documentation and there&rsquo;s been the Gutenberg GitHub repo has been a great resource for, learning as well. Just seeing how they&rsquo;re doing things, but it hasn&rsquo;t been easy. I actually, you know, a tool. I think you actually heard me talking about it at wpplugin dot com where you can quickly generate a block plugin. And the idea behind that is there&rsquo;s all these different mental models of building a block. I think the hardest part is learning, what can you do with a block? How can you do it? And shaping that mental model has really been a challenge. Honestly, I&rsquo;ve been very self driven and if it wasn&rsquo;t for that, that really has kept me going. I&rsquo;ve had a long-term view of where everything&rsquo;s going and from the place I&rsquo;m coming from being a front end developer, it&rsquo;s really made it, it has made it easier for me. I do think, if somebody really wants to learn blocks, they need to learn React. And I think something like taking like Wes Bos&rsquo;s React for beginners course, I took that course and it&rsquo;s a great resource for learning React. Just getting kind of the nuts and bolts of, you know, the underpinnings of Gutenberg.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:14:00]</div> <div class=\"chat-text\"><p>Would you say that, obviously it was fairly difficult as you&rsquo;ve described, but were you able to begin to see a glimmer of light at the end of the tunnel fairly quickly? Or was it one of these learning journeys where it&rsquo;s more of a cliff climb until finally you reach the pinnacle? You&rsquo;ve acquired enough knowledge that suddenly it becomes, oh, I can do it all now. This is fabulous. Or were you able to get something out from your limited learning?</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:14:24]</div> <div class=\"chat-text\"><p>I feel like I&rsquo;m there now. I&rsquo;m at that place. I mean, I&rsquo;m still learning, but I feel like I&rsquo;m at a point now where I can kind of shape the editor to what my vision is. But it has been a lot of hard work, but I&rsquo;ve, I feel like I&rsquo;ve kind of seen the vision for where WordPress wants to go for a long time. It really resonated with me and I can really get behind where they ultimately want to go. I think that all of this, it&rsquo;s going to be worthwhile taking the time to really dig in and learn. And I don&rsquo;t know if you&rsquo;ve seen it, there&rsquo;s been some talk about creating. I know there&rsquo;s like Advanced Custom Fields has a block builder. There&rsquo;s been some talk about creating some PHP based tools for building blocks. I&rsquo;m not sure it might be a third-party. It&rsquo;s just a, some conversation I saw on Twitter there quite an extensive conversation about people testing out ways to build blocks from a more PHP standpoint, where the PHP would kind of generate the React for you. And so like this layer between, okay, we have Advanced Custom Fields for doing 80{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9} of what you want to do. And then this other PHP solution potentially being like a similar tool that gets you most of the way there. If you really want to dive deep and do some more complex stuff, take you the rest of the 20{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9} of the way, then you&rsquo;d really need to learn React and how it works in the editor.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:15:46]</div> <div class=\"chat-text\"><p>I feel maybe this is the point at which people who are struggling with the way things are going in WordPress at the moment. Maybe this is the point of contention, it was introduced and suddenly all of the skills and the techniques and, the years and years of expertise that they built up, it kind of felt like it was crumbling before their eyes. And they may be in a position where they&rsquo;re managing to carry on their business, whatever it is, something to do with WordPress, their agency, or what have you. And simply don&rsquo;t have the time to upskill and to learn new things. And maybe that&rsquo;s the problem is that there&rsquo;s a lot of people out there who simply don&rsquo;t have the time. They don&rsquo;t have the energy anymore. They don&rsquo;t have the desire. And they want to just sort of keep going with the same tools that they&rsquo;ve been using for a such a long time. Obviously it sounds like you, fairly driven, able to allocate enough time to do all of that and obviously fit it in around your business. But maybe there&rsquo;s, maybe there&rsquo;s some people for whom that is just too much of a stretch?</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:16:41]</div> <div class=\"chat-text\"><p>You know, I can understand if all of a sudden Gutenberg was pulled out from under me, I think I&rsquo;d throw my hands up right now. Uh, I&rsquo;ve had a business, I was working on, pulled out from under me and I, it hurts. And it&rsquo;s like, ah, dude, you know, do I want to do I want to keep going? But, but here&rsquo;s the thing is I think Gutenberg is getting to the point where, we&rsquo;re hitting a stability that could be used in production for like client sites. I think we&rsquo;re hitting that point right now. Once Full Site Editing, I think after the next release. I&rsquo;ve started building, I&rsquo;ve kind of been doing both the old way of doing things for some clients and the new way of doing things. I&rsquo;ve been doing it simultaneously to see, okay, how stable are we for using this stuff in production versus using something like Elementor page builder or Beaver Builder or something like that?</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"> <div class=\"chat-text\"><p>I think we&rsquo;re coming up on that point where people can start making the switch and dipping their toes in. And I don&rsquo;t think you have to focus a hundred percent of your time or focus a big chunk of your time to start diving into that. The new block-based themes, it uses this thing called a theme bot json file and that really sets up. You just fill out this file, like basically a data structure with what you want and you have a full flesh theme in the block editor. I think that the tools and the tooling and WordPress and Gutenberg itself are all getting to this point where we can start using it, and it&rsquo;s not going to be a ton of time. And then once you start using these tools, You&rsquo;re going to want to start doing more and more with them, and you can start easing your way into building blocks with ACF or from scratch or whatever.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:18:33]</div> <div class=\"chat-text\"><p>It seems to me that it might be the case that many people who have not really dabbled too much in the block editor have gone in there at some point, installed vanilla version of WordPress, made sure that it was all up and running and what have you, and then when in, started typing and found that experience fairly decent, certainly from my part, it&rsquo;s much better for simply typing things than the classic editor ever was. Just for the ability to move paragraphs and things around. And then of course you notice this sort of curious sidebar, which is full of these blocks that you can put on to the page, and so, a paragraph is a block. A button is a block. A heading is a block. And so it kind of feels a bit like this text interface where the blocks are a bit like, okay, obviously I&rsquo;m using paragraphs now. That&rsquo;s fine. I can understand that. But then you sort of notice that there&rsquo;s a lot of stuff attached to the block and the block brings along with it, all these different settings. And so you can modify that one paragraph in its entirety, all in one, go by clicking some buttons, you know, that might be the color or what have you. And all of a sudden, your mind starts getting taken over with, oh, so the block has got settings with it. Oh, that&rsquo;s interesting. Okay. So what I&rsquo;m trying to say there is if you&rsquo;ve not been back into the block editor for a long time, and you&rsquo;ve just really seen it as a conduit to creating content, it is much more than that. And it&rsquo;s hard to express how much more it is unless you&rsquo;ve actually configured or played with a block that does a lot more than you could ever have done inside the classic editor. So I&rsquo;m wondering if you&rsquo;ve got any nice concrete examples of things that you&rsquo;ve achieved, the things that you&rsquo;ve been able to do inside of a block where people might go, oh, that&rsquo;s curious. I didn&rsquo;t realize that blocks could even do that kind of thing.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:20:25]</div> <div class=\"chat-text\"><p>Actually, my brother is an accountant and, he does a lot of work with startups and when COVID first hit and they started doing the PVP loans and everything, I actually built a calculator for him, for his business to share with his clients. And I built it all in blocks and the calculator would, it would generate, you know, you would just put in whatever your income is and how many employees and it would generate. You can actually see it in the wild. If you go to stimulus benefits dot com, I have a calculator in there. That&rsquo;s it&rsquo;s a block. All this is all built in WordPress. You&rsquo;ll probably notice this theme. I think this was the 2020 theme. And honestly, it&rsquo;s pretty cool. It&rsquo;s pretty snappy. And this is just like something that I built for fun for my brother, you know? So if you want it to build, imagine, you&rsquo;re in the real estate business and you wanted to build out a full fledged mortgage calculator. I know there&rsquo;s a ton of realtors, real estate agents, real estate businesses that use mortgage calculators in their business to direct their clients to. I mean, you could absolutely do that. Very quickly and easily.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:21:36]</div> <div class=\"chat-text\"><p>The principle there is that your brother then has a block inside of his WordPress installed, which he can then just with the click of a button throw on to any post or page, uh, it&rsquo;s not a weird shortcode thing where he&rsquo;s got a plugin installed over there and he&rsquo;s got to go and find the right shortcode and then copy and paste it into the right part. It&rsquo;s just all of that functionality. The logic behind the calculator is all contained inside of a block. And so for him as the end user, presumably it&rsquo;s just really easy to deploy that.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:22:06]</div> <div class=\"chat-text\"><p>It&rsquo;s a custom plugin. He could add it to any, you know, any site anywhere and what you see on the front end, of the site is what you also see in the editor. And then in the editor, you can change things like the background color, the border radius, the font color, the text. I mean, all the texts editable, which was really important because, everything was always changing. The rules of the game were changing. So he needed to be able to go in and edit the content of the calculator. So to me, it&rsquo;s like, it&rsquo;s super exciting that here&rsquo;s this thing that, like you&rsquo;re saying it would have been a short code. You throw the short code in and then say you go to the customizer. If you want to change the background color, you know, the fonts and add some custom CSS. This no, you you stay in the block editor and you just click a button. Okay. If you look at the calculator now it&rsquo;s got a black background. It&rsquo;d be really easy to change it to a white background with black text and then change out the font. And really you can kind of go as far as you want to go with this, I could see endless just calculators alone. I could see endless business opportunity.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:23:13]</div> <div class=\"chat-text\"><p>In a way, the idea of blocks, just being a conduit for putting content on the website. Yes. But it&rsquo;s also in a sense it&rsquo;s like a mini it&rsquo;s like a mini little application it&rsquo;s as you said, you created a plugin and what have you, but the complexity really has no limits. It&rsquo;s only the limits of what you&rsquo;re capable of coming up with and whatever it is that you&rsquo;ve built with all of its amazing, difficult capabilities could just be dropped in ad infinitum all over the place. And the sky, as you say, is the limit. And I feel like we&rsquo;re just turning a bit of a corner and some of the ideas are starting to come into the marketplace. Now, some really curious ideas about a whole different functionalities that are being wrapped up into blocks that we simply couldn&rsquo;t have done before.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:23:55]</div> <div class=\"chat-text\"><p>I&rsquo;m super excited because the fact that I could just create a calculator and drop it into a hundred sites, and then imagine I build a block base theme, say I build a block-based seam for like realtors, for example, I add this mortgage calculator, it&rsquo;s baked into it. I just can see all kinds of different, you know, additional tools like you&rsquo;re saying that you can get as complex as you want, but I also think blocks also offer this, a perfect canvas for constraint as well. You can go as complex as you want, but you also do want to make it easy for people to make changes to these little mini applications that we&rsquo;re building.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:24:35]</div> <div class=\"chat-text\"><p>I think one of the concerns that I have, amongst many other people, I&rsquo;m sure is. It&rsquo;s just this notion of people getting a bit click happy when installing blocks. The idea that there&rsquo;s a plugin for that in WordPress could easily be flipped to, well, there&rsquo;s a block for that. Non-technical users going out and looking through the block repository and installing things, and then kind of having to scratch their head and say, Hmm. My site really does seem to be very slow and then ultimately blaming WordPress for that, because that&rsquo;s the software it&rsquo;s built upon. I think you&rsquo;re right. Is it a good point to raise the one of constraint? Just because something exists, it doesn&rsquo;t mean you should install 50 of them and use them all at the same time.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:25:13]</div> <div class=\"chat-text\"><p>I do think that a certain level of constraint does breed creativity. So I think that, you know, the more we can focus on making it really easy for people. Make it as easy as possible to do something, the better. So I think like patterns, the block patterns for example, are going to be a huge boon to making it easy. Try multiple homepages or contact pages about pages or pricing tables or any part of a site that you can think of. It&rsquo;s going to be really easy to add that to your site.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:25:44]</div> <div class=\"chat-text\"><p>Have you been playing with block patterns a lot? And if so, are you pleased with where the system is right now for making all of that and surfacing them in the UI for you?</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:25:55]</div> <div class=\"chat-text\"><p>I am super excited about where block patterns are going. I think they open up a ton of possibilities. If I were going to be dipping my toes right now, say I haven&rsquo;t started building blocks. That&rsquo;s where I would start honestly, is start building out some patterns because it&rsquo;s really cool to go into the editor and create this pattern and then be able to just move it from site to site seamlessly, and have it just work.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:26:23]</div> <div class=\"chat-text\"><p>Do you feel there&rsquo;s a new marketplace, a new job, if you like, emerging? We&rsquo;ve traditionally in WordPress, we&rsquo;ve had lots of people employed building websites, that&rsquo;s one niche, if you like, and then had other people working within agencies, possibly building bigger websites and on the code side, if you like, we&rsquo;ve had people creating plugins and themes and making commercial products out of those. Do you see blocks in that way that there&rsquo;s going to be a nice commercial interest in people going out and finding affordable blocks that do the one or two simple things that they need?</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:26:59]</div> <div class=\"chat-text\"><p>I do think there will be. I just, I don&rsquo;t know if those are out there quite yet to find. What I&rsquo;m seeing a lot of though, is these ecosystems popping up around a set of custom blocks, and then patterns to use with those blocks and core blocks and then multiple themes. And so I see the business evolving into more of these like mini ecosystems and that&rsquo;s where I&rsquo;ve been building is focused on here&rsquo;s a set of custom blocks, custom patterns and themes for different types of use cases to get you quickly up and running.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:27:39]</div> <div class=\"chat-text\"><p>One of the things that I&rsquo;ve noticed is I&rsquo;ve seen that there are quite a few people at the moment trying to make a living out of this, and it seems, the most common way to do it at the moment is to come out with these block packs. And we&rsquo;re just going to use that phrase. I don&rsquo;t know if that&rsquo;s what these companies go by, but they release a suite of 5, 10, 15, 20 or so on, blocks that hopefully will cover almost every aspect.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"> <div class=\"chat-text\"><p>Do you get yourself involved in any of those? Do you use any of the things which are available on the market at the moment, or are you all about just if I need it, I&rsquo;m going to make it myself?</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:28:09]</div> <div class=\"chat-text\"><p>I definitely do. I love to see, and use what&rsquo;s out there. I&rsquo;ve used a bunch of different block collections on different projects, such as CoBlocks. And I don&rsquo;t know if you&rsquo;ve seen Stackable, WP Stackable? I know we were just talking about the GenerateBlocks and I see a lot of chatter on Twitter about people using GenerateBlocks. I don&rsquo;t know if you&rsquo;ve seen another one, that I just think is it&rsquo;s just beautiful called Aino Blocks, A, I, N, O, WP Aino dot com. Ellen Bauer has put together. I used to buy her WordPress themes and her and her co-founder put together a set of blocks, a limited set of custom blocks and then patterns. And they&rsquo;re going to be creating themes as well. Right now it&rsquo;s free to start using I&rsquo;m sure there&rsquo;s going to be, you know, some way of them monetizing that product.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:29:03]</div> <div class=\"chat-text\"><p>I&rsquo;m pretty sure that there&rsquo;s going to be more people dipping their toes into the commercial waters as time goes on, because it does feel as if this is the future for WordPress. And one thing that I&rsquo;m quite interested to see is, there&rsquo;ll be like an, almost like little micro blocks that just do one thing, but do it really well and go into some sort of different pricing structure. So as an example, on the PC or the Mac, if you buy an app, it&rsquo;s usually there&rsquo;s a reasonable amount of dollars expended on purchasing that app. I mean, if you go onto the iOS or the Android side, something much more slim is available and it costs significantly less, just a few dollars. And I&rsquo;m curious to see if this business model emerges, where we get an innovative block, which just does one small thing, but does it really well, I can&rsquo;t actually conjure anything up at the moment out of my head that may fulfill that bill, but I&rsquo;m really interested to see if those kinds of things start to emerge.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:30:03]</div> <div class=\"chat-text\"><p>I definitely think there will. I personally, I would love to focus just on building those, but I feel like I almost feel like it&rsquo;s got a, it feels like things need to go broad first and then narrow down to the specific use cases. But I have seen one really cool niche plugin is block visibility by Nick Diego. If you, if you&rsquo;re not following Nick on Twitter, you should. His plugin makes it really easy to show and hide blocks depending on different use cases, even. For example, he has an integration with WooCommerce and Easy Digital Downloads. And you can set visibility based on a schedule and if a customer purchased a product or not. So say you bought a product and two weeks ago, and then you can have a block pop up two weeks later and say, Hey, how&rsquo;s it going? Would love your feedback if you&rsquo;re enjoying using our plugin, leave us a review. So I do think that we&rsquo;re starting to see those and that is, you know, one of the best examples that I&rsquo;ve seen out there.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:31:11]</div> <div class=\"chat-text\"><p>It&rsquo;s like a little application just inside of a block. There&rsquo;s a lot of heavy lifting going on there. Isn&rsquo;t that, you know, if it&rsquo;s checking, the conditions to be right to, to make itself visible. You can imagine all sorts of permutations for the usefulness of that. Certainly in terms of marketing or perhaps hiding content that you want to be invisible to people who aren&rsquo;t members of your subscriber base or whatever it might be.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"> <div class=\"chat-text\"><p>And that&rsquo;s kind of the point for me is that blocks bring all of this, as yet un thought-out, potential. Whereas previously, there was just essentially text on a page with a bit of formatting and some shortcodes thrown in if you wanted to add extra functionality. And now the functionality is all within the block. And so are the settings and it&rsquo;s all in one simple, hopefully, user interface. Speaking of the user interface, just staying on the block editor. So we&rsquo;re recording this kind of near to the middle of 2021. And I&rsquo;m just conscious that there&rsquo;s a lot of comparisons made all the time between what the commercial page builders can do and what the block editor can do, and I&rsquo;m always curious to know what people&rsquo;s opinions are about how easy it is to put things together, put complicated block layouts together and create things which are beautiful because, I certainly still experience moments where I&rsquo;m really not sure if what I&rsquo;m looking at in the block editor is going to look how I expect it to when I finally publish it and check it out on the front end. So just wondered if you had any thoughts about its utility as a sort of what you see is what you get, or if there&rsquo;s still a ways to go?</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:32:43]</div> <div class=\"chat-text\"><p>I think that ultimately that is going to come down to the themes and then any supporting block plugins that ship with those themes. With any page builder, any like major commercial page builder, there&rsquo;s a learning curve and yeah, what you see, what is, what you get out of the box with Elementor, but if you want to change something, if you&rsquo;re just getting started, it can feel daunting to dive into all those settings. I do think the responsibility falls more to the theme builders in and the plugin builders to make sure that that experience happens. Myself, I&rsquo;m working on what I&rsquo;m calling a minimalis page builder that I&rsquo;m hoping to shorten that learning curve. And to also, I want to take responsibility for making sure that what you see in the editor is what you see on the front end.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"> <div class=\"chat-text\"><p>So, you know, I do. It&rsquo;s up to me and everyone else that is building out these experiences to make that happen. Off the shelf, if you used, you know, a core WordPress theme, you get your experience in the editor and on the front end is pretty seamless. There may be minor differences, but I mean, you&rsquo;re, you&rsquo;re pretty much seeing what you&rsquo;re getting on the frontend.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:33:59]</div> <div class=\"chat-text\"><p>Just curious because you dropped a few names earlier and I thought that was quite interesting because some of the people that you&rsquo;d mentioned I&rsquo;d heard of, and some of them, I hadn&rsquo;t. So I&rsquo;m wondering if you wouldn&rsquo;t mind just rattling off a couple of projects that you have seen and you thought that was good. And if you can attach some names to those as well, we&rsquo;ll try and make sure they go in the show notes along with this, on the WP Tavern website. So yeah, just a list of block projects that you think are worth keeping an eye on either because they&rsquo;re already fully fledged or they just seem like they&rsquo;re onto the cusp of doing something great. And some names to go with that.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:34:31]</div> <div class=\"chat-text\"><p>Nick Diego, his block visibility, plugin block visibility wp dot com. And then I follow Nick on Twitter too. He&rsquo;s always sharing updates. And if you&rsquo;re into building blocks, valuable content there, Ellen Bauer with WP Aino A I N O dot com has some beautiful block patterns and custom blocks that you can start using right away. GenerateBlocks, of course, we mentioned Mike Oliver. He just released a new set of block patterns that, a beautiful set of block patterns that you can start using. And then I know you and I mentioned Brian Gardner&rsquo;s launching Frost WP. He&rsquo;s going to be launching a set, I think it&rsquo;s already launched actually at frostwp dot com.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"> <div class=\"chat-text\"><p>So I can&rsquo;t go without saying too that Rich Tabor, he is the creator of CoBlocks and he, I think he sold that to GoDaddy. He&rsquo;s always working on something interesting and sharing cutting edge stuff with regards to building blocks block-based themes and plugins. So he&rsquo;d be worth taking a look at.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:35:38]</div> <div class=\"chat-text\"><p>That&rsquo;s very nice. I will be sure to mention those. One which I&rsquo;ll drop in, which I think is quite an interesting block-based, well, it is literally like a little application within WordPress. There&rsquo;s something called Newsletter Glue. Don&rsquo;t know if you&rsquo;ve come across this, but&hellip;</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:35:52]</div> <div class=\"chat-text\"><p>Lesley, how could I forget Lesley?</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:35:56]</div> <div class=\"chat-text\"><p>Lesley Sim and her colleague, her co-founder have created a mechanism whereby you can repurpose your blog posts and they will instantly become newsletters, which sounds like the sort of thing you&rsquo;ve been able to do by scraping an RSS feed or something like that. But there&rsquo;s a lot more to it. For example, you can drag in a block, which will only be visible inside the post or alternatively, you could make it only visible inside the newsletter. And it does a lot more than that, but just that one simple little thing that you can do means that you can create a newsletter and have it look completely different in the newsletter than it does on your, the front end of your website. It&rsquo;s really interesting for me, it demonstrates perfectly why the block editor is going to be so useful in the future, because this was unimaginable without the context of blocks. It couldn&rsquo;t have been made in what we used to use in WordPress.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:36:49]</div> <div class=\"chat-text\"><p>To think about making a newsletter you generally have to, I would think go off site. And I use Newsletter Glue in a lot of my clients sites and it really makes it effortless to put together a newsletter and send it out. When you hit that send button. So like, did that really just send that this from WordPress, this is crazy!</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:37:07]</div> <div class=\"chat-text\"><p>But just the level of complexity going on there, the fact that it&rsquo;s doing a lot of heavy lifting, it&rsquo;s reaching out to third-party services and doing things, but only at the moment that you click publish and it&rsquo;s sending over HTML and telling the websites over there, right, go on, publish it right away to this list or that list. It&rsquo;s really remarkable. And it&rsquo;s, for me makes me feel that in the future, there&rsquo;ll be a lot more interoperability with SaaS platforms and other things like that built inside of blocks. So that I don&rsquo;t know, maybe your content management system, WordPress can reach out and have interactions with blocks with your CRM in some way, who knows?</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"> <div class=\"chat-text\"><p>This is what I&rsquo;m finding exciting is that we&rsquo;re at the point where the technology is now available, but we don&rsquo;t yet have the history of developers trying out all their ideas. We did that with plugins. There must&rsquo;ve been a similar moment with plugins where it was a lovely idea. Look, we can extend WordPress, but there wasn&rsquo;t really so much out there yet. So plugins felt a bit like, well, it&rsquo;s a thing, but you know, I&rsquo;m not that bothered, but then look what happened. There really was a boom in plugins and they became&hellip; you know, you couldn&rsquo;t really have a functioning WordPress website without a few plugins here and there. And I feel the same will be true in the near future with blocks.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:38:19]</div> <div class=\"chat-text\"><p>I really hope we can make building blocks easier because I think we&rsquo;re just starting to see, like you&rsquo;re saying some of these really neat things come out and you really could build anything you wanted in WordPress, if you know what you&rsquo;re doing. So excited for what the future holds.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:38:34]</div> <div class=\"chat-text\"><p>Indeed, that feels like a perfect place to jump off this train. But before we do that, or before I do that, I always want to know where people can contact you. What&rsquo;s the best place for you to be reached. It could be an email address or a Twitter handle, whatever you&rsquo;re comfortable with..</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:38:49]</div> <div class=\"chat-text\"><p>Twitter, it would be the best twitter dot com slash leeshadle. That would be the best place to reach me.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-1\"><div class=\"chat-author chat-author-nathanwrigley vcard\"><cite class=\"fn\">Nathan Wrigley</cite> [00:38:55]</div> <div class=\"chat-text\"><p>I will make a hundred percent sure to put that into the show notes and all that remains for me to say is Lee, thank you so much for joining us today and telling us a bit about your journey and your excitement about blocks.</p>\n</div></div><div class=\"chat-stanza chat-row chat-speaker-2\"><div class=\"chat-author chat-author-leeshadle vcard\"><cite class=\"fn\">Lee Shadle</cite> [00:39:06]</div> <div class=\"chat-text\"><p>Thank you Nathan, it&rsquo;s been so fun to talk to you today. I really appreciate you having me on the show.</p>\n</div></div></div></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Oct 2021 13:23:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"Post Status: WordCamp US 2021 Summary\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=87474\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://poststatus.com/wordcamp-us-2021-summary/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:11498:\"<p class=\"has-drop-cap\">After deciding not to hold the event in 2020, WordCamp US 2021 returned for a single day on October 1st. The entire event was planned in eight weeks — which was not widely known until mentioned by lead organizer Jen Swifter during closing remarks. This marks the first WordCamp US without Matt Mullenweg’s “State of the Word,” although due to the event being virtual it’s presumed Matt will be holding the SotW as a separate virtual “event” closer to the end of the year — similar to last year.</p>\n\n\n\n<p>The two track event still brought fresh content and had what could be argued as one of the most diverse speaker lineups for a single day at WordCamp US — at least when it comes to “new to WCUS” speakers. New faces — even on screens rather than a stage — are welcome to see.</p>\n\n\n\n<p>The event sold over 3000 tickets, which for a WordCamp US and a virtual event with limited marketing time is quite good. Of course not everyone might have showed up but I could easily get the feeling that this was a large event from the activity in the online chat and from Twitter.</p>\n\n\n\n<p class=\"has-background\"><strong>Update:</strong> WordCamp US released an official response when asked about registered and attending members.<br /><br />&#8220;<em>We had 3608 people register for the event and had as many as 400 concurrent viewers at one time.<br /><br />Online events are notoriously difficult to get attendee stats for, particularly an event like WCUS 2021 where the audience is global and spans so many time zones. Many people will watch what they can and catch the rest in their own time.<br /><br />We really love this as it makes for not only a more accessible event, but a more educational experience as it’s so easy to rewatch a session as many times as an individual needs.</em>&#8220;</p>\n\n\n\n<p>It is difficult to give highlights of the talks since I was part of the programming team that helped add these talks to the program. I decided not to watch pre-recorded presentations prior to the day of WordCamp US to make the experience as similar to a regular attendee’s experience as possible. For that reason, I couldn’t cover all the talks live, and there are still a few talks I need to go back and watch. But I can cover some highlights and point out some notable presentations.</p>\n\n\n\n<p class=\"has-background\"><strong>Note:</strong> Until WCUS talks are published on WordPress.tv, you can use <a href=\"https://mburnette.com/blog/wordcamp-us-2021/\">this guide</a> to view them timestamped in the live stream on YouTube thanks to Marcus Burnette.</p>\n\n\n\n<p>Bet Hannon’s talk on accessibility was well received by the audience at the start of the event. Bet noted that “25{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9} of all adults in the US have a permanent or temporary disability,” so the subject material should apply to many site builders. Jill Binder came afterwards to give an inspirational story about her journey to being a diversity team leader for a team that in 2020 exists in 71 cities across 17 countries.</p>\n\n\n\n<p>Meanwhile, Cory Webb and Rich Tabor delivered what could be caled the “introduction” and “showcase” talks related to the block editor. Most talks in this particular track had some connection to the block editor or the latest major enhancements in WordPress.</p>\n\n\n\n<p>There were lightning talks after a <em>very</em> entertaining “musical break” — or what would be considered lunch for an in-person event. I wasn’t able to fully digest them all, but many of these performers featured rarely seen or new faces in the WordPress community:</p>\n\n\n\n<p><a href=\"https://us.wordcamp.org/2021/speaker/sienna-svob/\">Sienna Svob</a> covered sustainability, recommending that WordPress designers use fewer resources when possible and lean on hosts that use renewable energy.&nbsp;</p>\n\n\n\n<p><a href=\"https://us.wordcamp.org/2021/speaker/lesley-sim/\">Lesley Sim</a> of Newsletter Glue offered a no-slide presentation on how to make friends with early customers, and she reminded product builders to “create the expectation you’re helpful and easy to reach.” Lesley also reminded us that “anything you do for the first time [in business and marketing] is going to be awkward.”&nbsp;</p>\n\n\n\n<p>If you are running an ecommerce site, <a href=\"https://us.wordcamp.org/2021/speaker/lax-mariappan/\">Lax Mariappan</a>’s talk is a good one to watch. In a similar vein, if you are running a community or are a WordCamp / Meetup organizer I would recommend <a href=\"https://us.wordcamp.org/2021/speaker/shusei-toda/\">Shusei Toda</a>‘s talk on lessons learned from WordCamp Tokyo 2021.</p>\n\n\n\n<p>Another presentation for designers and theme developers would be Tammie Lister’s “Let Themes Be Themes” talk which will likely find a special place in the heart of those yearning for inspiration as we head into the next-generation of WordPress themes with full site editing and the block editor.</p>\n\n\n\n<p>For entertainment, <a href=\"https://us.wordcamp.org/2021/speaker/taco-verdonschot/\">Taco Verdonschot</a> scored some points for using his own green screen in his talk on recharging your social batteries. This was a timely talk when many of us still work almost completely remotely via Zoom and Slack.</p>\n\n\n\n<p>The second half of WordCamp US seemed to go by quickly. Two key talks about WordPress.org contributions were featured in one track. The first by members of the WordPress Training team focused on the Learn.WordPress.org resource. Support for Leearn will make a big impact in the coming days — we’ll do a deeper dive into this subject in the future — and I do agree that one day visiting a WordPress.org profile might be key part of the hiring process by companies looking for WordPress professionals.</p>\n\n\n\n<p>The other key talk was given by <a href=\"https://us.wordcamp.org/2021/speaker/amyjune-hineline/\">AmyJune Hineline</a> who covered how many ways you can contribute and reviewed all the available groups at make.wordpress.org.</p>\n\n\n\n<p>Developers got a treat when <a href=\"https://us.wordcamp.org/2021/speaker/helen-hou-sandi/\">Helen Hou-Sandi</a> showed how the new White House site was built in six weeks with WordPress and over a dozen custom blocks.&nbsp;</p>\n\n\n\n<p>“[10up] did 12 weeks work of hours in 6. Q&A; as we went. People were trusted to Q&A; their own work, no additional layers. We did have external help and always kept moving.&#8221;&nbsp;</p>\n\n\n\n<p>While mostly inspirational, she did show off some React code and revealed the entire talk including the live coding was done in the browser (thanks in part to Github’s Codespaces). Another treat was seeing the experiments that <a href=\"https://us.wordcamp.org/2021/speaker/kjell-reigstad/\">Kjell Reigstad</a> showcased in his talk about block styles.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile has-background\"><img width=\"250\" height=\"250\" src=\"https://i0.wp.com/poststatus.com/wp-content/uploads/2021/09/RtpKYzps_400x400.png?resize=250{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C250&ssl=1\" alt=\"Get Hired\" class=\"wp-image-85823 size-full\" /><div class=\"wp-block-media-text__content\">\n<p class=\"has-text-align-left has-normal-font-size\" id=\"h-get-ready-for-remote-work\"><strong>Get started today!</strong> Build your career in WordPress.</p>\n\n\n\n<p class=\"has-text-align-left has-small-font-size\"><strong>Build your network. Learn with others. Find your next job.</strong> Read the <strong>Get Hired</strong> <a href=\"https://poststatus.com/get-hired/#{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}f0{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}9f{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}93{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}a7-subscribe-to-the-get-hired-newsletter\">newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/2709.png\" alt=\"✉\" class=\"wp-smiley\" /> Listen to the <strong>Get Hired</strong> <a href=\"https://poststatus.com/podcast/get-hired/\">podcast</a>. <img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /> Follow <a href=\"https://twitter.com/gethiredwp\">@GetHiredWP</a>. <img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /></p>\n</div></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<p><a href=\"https://us.wordcamp.org/2021/speaker/josepha-haden-chomphosy/\">Josepha Haden Chomphosy</a> closed out the conference with a brief talk on “finding your own voice” with a fireside chat with Michelle Fran. Some tidbits:</p>\n\n\n\n<ul><li><strong>On acquisitions in the WordPress space: </strong>Josepha overall favors them and sees acquisitions as part of a maturing market ,but it’s not all about the money: “Sometimes companies being acquired need guidance. Large companies can provide advice and funds for the smaller company to get further. Mergers and acquisitions shouldn’t be looked at something that decreases the diversity in the ecosystem.&#8221;</li><li><strong>On diversity:</strong> “WordPress can be used by anybody ,so it should be able to be built by anybody.” However, Jospeha acknowledges that ventures similar to the all-womens release team (which took almost 2 years to plan) might not be happening anytime soon so it doesn’t turn into a “gimmick” and can be used more effectively to attract more diverse audiences to contribute.&nbsp;</li><li><strong>On individual vs. corporate contributions: </strong>“Always important to me in terms of volume, we aim for 2/3 contribution from individuals and 1/3 that are corporately sponsored,” although right now the numbers are closer to 50/50.</li><li><strong>On increasing openness and transparency:</strong> For decision making in WordPress and the posts on make.wordpress.org (including her updates), Josepha said: “Even if people aren’t reading what goes into the decisions of WordPress, it’s just as important for people to go back and read that content than it is to read more traditional documentation.”</li></ul>\n\n\n\n<p>I’m biased, but I think overall the event was well done. Apart from Matt’s absence, it seemed to have a flavor of a WordCamp US throughout, complete with conversations happening on YouTube chat, Post Status Slack, and Twitter.</p>\n\n\n\n<h2 id=\"h-get-involved-in-wordpress\">Get Involved in WordPress!</h2>\n\n\n\n<div class=\"wp-block-columns\">\n<div class=\"wp-block-column grey-message\">\n<ul><li>Have you thought about what you can do that might lead to speaking at a WordCamp or local meetup yourself? <strong>Abha Thankor</strong> has <a href=\"https://us.wordcamp.org/2021/how-to-get-involved-in-the-wordpress-community-after-attending-a-wordcamp/\">some suggestions</a> for you.</li><li>Jobs in WordPress involve a lot of 21st century skills in digital literacy and digital citizenship. <a href=\"https://wordpress.org/news/2021/10/episode-17-wordpressing-your-way-to-digital-literacy/\">In the latest <strong>WP Briefing</strong> podcast</a>, WordPress executive director <strong>Josepha Haden Chomphosy</strong> reflects on her WordCamp US keynote talk and discusses how participating in open source projects can help you learn these skills.</li><li>Get involved in <strong>Learn WordPress</strong>! Over at <a href=\"http://learn.wordpress.org\">learn.wordpress.org</a> there’s <a href=\"https://make.wordpress.org/training/2021/08/08/who-can-learn-help/\">a lot of change going on</a>, and you can be part of it. Learn is for everyone, so no matter where you are in your life and career, you can benefit from and contribute to these educational materials that support the community project known as WordPress.</li></ul>\n</div>\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Oct 2021 03:32:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"David Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WPTavern: GiveWP Launches Peer-to-Peer Fundraising Add-On\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=123231\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:159:\"https://wptavern.com/givewp-launches-peer-to-peer-fundraising-add-on?utm_source=rss&utm_medium=rss&utm_campaign=givewp-launches-peer-to-peer-fundraising-add-on\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4415:\"<p class=\"has-drop-cap\">The GiveWP team announced an extension of its flagship donation plugin for allowing <a href=\"https://givewp.com/announcing-the-givewp-peer-to-peer-fundraising-suite/\">peer-to-peer (P2P) fundraising</a> in late September. The solution should make the project even more appealing than before for those looking to break from third-party donation services and go the self-hosted route. The first version rolls out individual and team fundraising pages, leaderboards, campaign sponsor support, and more.</p>\n\n\n\n<p>In the past, GiveWP offered a simple solution for setting up donations on a website. People could use it for everything from nonprofit organizations to fundraising smalltown baseball team jerseys. However, any efforts to raise money fell squarely on the site owner&rsquo;s shoulders.</p>\n\n\n\n<p>The <a href=\"https://givewp.com/addons/peer-to-peer/\">Peer-to-Peer add-on</a> changes that by allowing people who support a particular cause to be both an evangelist and a fundraiser for the project.</p>\n\n\n\n<p>&ldquo;Peer-to-Peer is a unique form of fundraising,&rdquo; said GiveWP co-founder Matt Cromwell. &ldquo;To date, GiveWP has been focused primarily on the single donation form. But Peer-to-Peer is about grouping individual fundraisers into teams, each with their own form and campaign goal.&rdquo;</p>\n\n\n\n<img />Campaign fundraising page.\n\n\n\n<p>The extension allows site owners to create an overarching campaign while breaking it down into smaller individual or team-led sub-goals. For example, a campaign can have a donation goal of $100,00, but teams can reach for smaller chunks of that, such as $10,000. Ultimately, all donations are pooled together into the campaign total.</p>\n\n\n\n<p>&ldquo;This is a type of fundraiser that nonprofits use to raise significant funds,&rdquo; said Cromwell. &ldquo;These aren&rsquo;t one-off simple fundraisers typically.&rdquo;</p>\n\n\n\n<p>The extension adds a bit of gamification to fundraising campaigns. Individuals and teams are both added to separate leaderboards, showing their rank among their peers.</p>\n\n\n\n<img />Campaign leaderboards.\n\n\n\n<p>Individuals and teams can do more than just compete for the top rank on a campaign. They can customize their own fundraising page. It is this social element that helps bring a bit more humanity to a project.</p>\n\n\n\n<p>&ldquo;Examples of this type of fundraising are the Susan G Komen &lsquo;Race for the Cure&rsquo; or the Boston Marathon,&rdquo; said Cromwell. &ldquo;Individuals sign up to be team captains, they recruit team members. Members have goals that lead to the team goal. All teams together go toward the total campaign goal.&rdquo;</p>\n\n\n\n<p>There are times when some fundraising efforts can feel a bit faceless, almost corporate-like entities asking for donations. When you start adding people from outside an organization to do some legwork, they may feel like part of something bigger.</p>\n\n\n\n<img />Custom team page.\n\n\n\n<p>&ldquo;Of course, we consulted with our customers, we held a Town Hall to get their input and feedback,&rdquo; said Cromwell. &ldquo;Our customers have been asking to do this type of fundraising for years. We have a lot of input on this in our feedback system. The human element is part and parcel to the success of this popular form of fundraising.&rdquo;</p>\n\n\n\n<p>A P2P solution was the <a href=\"https://feedback.givewp.com/feature-requests/p/peer-to-peer-fundraising\">top-voted feature request</a> through the GiveWP feedback system. As for the future of the add-on plugin, it is easy to see what the GiveWP&rsquo;s users are asking for through its own <a href=\"https://feedback.givewp.com/give-peer-to-peer\">feedback channel</a>. Currently, there is no shortage of ideas.</p>\n\n\n\n<p>&ldquo;We are dedicating at least two developers per development cycle over the next few cycles to continue to improve and enhance P2P based on the ongoing feedback we get from our users,&rdquo; said Cromwell.</p>\n\n\n\n<p>He did not give any specific details about other projects the GiveWP team is working on. However, he did note that they are excited about providing more solutions for nonprofits.</p>\n\n\n\n<p>&ldquo;We&rsquo;d love to see our team providing more solutions outside of only the donation form side of things,&rdquo; he said. &ldquo;Nonprofits need stable, beautiful, and performant websites, and we think we can help on that front now too.&rdquo;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Oct 2021 00:42:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"WordPress.org blog: The Month in WordPress: September 2021\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11327\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wordpress.org/news/2021/10/the-month-in-wordpress-september-2021/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:16048:\"<blockquote class=\"wp-block-quote\"><p>There’s a lot of tolerance in open source software for shipping slightly imperfect work. And that’s good. When we ship software that’s a little bit imperfect, it makes it clear how everyone can participate, how everyone could participate, if they could find this WordPress community that supports the CMS.</p></blockquote>\n\n\n\n<p class=\"has-drop-cap\">That was <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden</a> on the “<a href=\"https://wordpress.org/news/2021/09/episode-16-a-sneak-peek-at-wordpress-5-9/\">A Sneak Peek at WordPress 5.9</a>” episode of the <a href=\"https://wordpress.org/news/podcast/\">WP Briefing Podcast</a>, talking about what goes into a WordPress release like version 5.9. Read on to find out more about updates on the latest release and the latest WordPress news from September 2021.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>WordPress Translation Day 2021 Celebrations ran for 30 days</h2>\n\n\n\n<img width=\"632\" height=\"332\" src=\"https://i2.wp.com/wordpress.org/news/files/2021/10/image.png?resize=632{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C332&ssl=1\" alt=\"WP Translation Day Matt Mullenweg Quote. Quote text: “Translation is so magical because it multiplies the work of all the other contributors of WordPress. If you care about freedom and the future of the internet, translating WordPress is one of the best things you can do for people who speak your language.”\" class=\"wp-image-11328\" />\n\n\n\n<p>WordPress Contributor teams, led by the Polyglots and Marketing teams, organized <a href=\"https://wptranslationday.org/\">WordPress Translation Day celebrations</a> for the entire month of September. Contributors from across the world joined the celebrations by translating WordPress into their own languages. Additionally, the team organized a host of <a href=\"https://wptranslationday.org/wptd-2021/global-events/\">global</a> and <a href=\"https://wptranslationday.org/wptd-2021/local-events/\">local events</a>. Translation sprints were organized by the <a href=\"https://make.wordpress.org/community/2021/09/20/kicking-off-the-community-documentation-translation-sprint-from-september-20-to-24/\">Community</a> and <a href=\"https://make.wordpress.org/training/2021/09/30/wptranslationday-subtitling-videos-on-learn/\">Training</a> teams, as well as local groups.</p>\n\n\n\n<p>As part of the celebrations, nominations were invited for contributors who had made a significant impact on the translation of WordPress and its availability in so many languages worldwide. <a href=\"https://wptranslationday.org/blog/call-for-nominations-polyglots-appreciation/\">More than 30 notable polyglot contributors were nominated for their contributions</a>. They will be featured in the coming month on the <a href=\"https://wptranslationday.org/\">WP Translation Day website, together with event recaps and more news.</a></p>\n\n\n\n<p>Read the latest <a href=\"https://wordpress.org/news/2021/09/people-of-wordpress-yordan-soares/\">People of WordPress feature on polyglots contributor Yordan Soares</a>, from South America.</p>\n\n\n\n<h2>WordPress Release updates</h2>\n\n\n\n<ul><li>WordPress security and maintenance release – <a href=\"https://wordpress.org/news/2021/09/wordpress-5-8-1-security-and-maintenance-release/\">Version 5.8.1</a> came out on September 9, 2021. The release fixes three major issues and includes 60 bug fixes. You can update to the latest version directly from your WordPress dashboard or by <a href=\"https://wordpress.org/download/\">downloading</a> it from WordPress.org. The <a href=\"https://make.wordpress.org/core/2021/10/04/wordpress-5-8-2-deferred/\">5.8.2 release has been deferred</a> and if needed a minor release will be added before 5.9.&nbsp;</li><li>Work is progressing towards WordPress 5.9, and the team released a <a href=\"https://make.wordpress.org/core/2021/09/03/wordpress-5-9-planning-roundup/\">planning round-up</a> along with a <a href=\"https://make.wordpress.org/core/2021/09/03/wordpress-5-9-planning-roundup/\">call for release leads</a>. October 14 is the go/no-go date of the release, which is planned to be <a href=\"https://make.wordpress.org/core/2021/09/03/wordpress-5-9-planning-roundup/\">launched on December 14, 2021</a>.</li></ul>\n\n\n\n<p>Want to contribute to WordPress core? Join the <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> channel, follow the <a href=\"https://make.wordpress.org/core/\">Core Team blog</a>, and check out the <a href=\"https://make.wordpress.org/core/handbook/\">team handbook</a>. Don’t miss the Core Team chats on Wednesdays at <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?hour=5&min=00&sec=0\">5 AM</a> and <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?hour=20&min=00&sec=0\">8 PM</a> UTC.&nbsp;</p>\n\n\n\n<h2>Say hi to Gutenberg Versions 11.4 and 11.5</h2>\n\n\n\n<p>We launched Gutenberg <a href=\"https://make.wordpress.org/core/2021/09/01/whats-new-in-gutenberg-11-4-1-september/\">version 11.4</a> and <a href=\"https://make.wordpress.org/core/2021/09/17/whats-new-in-gutenberg-11-5-16-september/\">version 11.5</a> this month. <a href=\"https://make.wordpress.org/core/2021/09/01/whats-new-in-gutenberg-11-4-1-september/\">Version 11.4</a> adds image blocks to the gallery block, duotone filters for featured images, and padding support for Button Blocks. <a href=\"https://make.wordpress.org/core/2021/09/17/whats-new-in-gutenberg-11-5-16-september/\">Version 11.5</a> adds flex layout support to the group and social icon blocks along with <a href=\"https://make.wordpress.org/core/2021/09/22/core-editor-improvement-introducing-the-widget-group-block/\">widget group blocks</a>. It will support the addition of a site logo or title directly into menus.</p>\n\n\n\n<p>Want to get involved in developing Gutenberg? Follow <a href=\"https://make.wordpress.org/core/\">the Core Team blog</a>, contribute to <a href=\"https://github.com/WordPress/gutenberg/\">Gutenberg on GitHub</a>, and join the <a href=\"https://wordpress.slack.com/archives/C02QB2JS7\">#core-editor</a> channel in the <a href=\"https://make.wordpress.org/chat/\">Make WordPress Slack</a>. The <a href=\"https://make.wordpress.org/core/2021/09/17/whats-next-in-gutenberg-mid-september-2021/\">What’s next in Gutenberg</a> post gives details on the latest updates.</p>\n\n\n\n<h2>New Guidelines for in-person WordCamps</h2>\n\n\n\n<p>The Community Team <a href=\"https://make.wordpress.org/community/2021/09/13/announcement-updated-guidelines-for-in-person-wordcamps/\">published new guidelines</a> for returning to in-person WordCamps in regions where in-person events are allowed by the local public health authorities.&nbsp;</p>\n\n\n\n<p>Community members can now organize in-person WordCamps for fully vaccinated, recently tested negative, or recently recovered folks (in the last three months) — provided their region passes the in-person <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/2021-returning-to-in-person-meetups/in-person-meetup-decision-checklist/\">safety checklist</a> OR if vaccines and/or COVID testing are accessible to all. Organizers can continue to plan online WordCamps if their region does not meet the guideline.&nbsp;</p>\n\n\n\n<p>New guidelines are also available on the <a href=\"https://make.wordpress.org/community/2021/09/27/announcement-returning-to-in-person-do_action-charity-hackathons/\">return of in-person do_action hackathons</a>.</p>\n\n\n\n<p>Want to get involved in the Community Team and help bring back in-person WordPress events? <a href=\"https://make.wordpress.org/community/\">Follow the Community Team blog</a> and join the <a href=\"https://wordpress.slack.com/archives/C02RQC7RN\">#community-events</a> channel in <a href=\"https://make.wordpress.org/chat/\">the Make WordPress Slack</a>! Check out the following <a href=\"https://central.wordcamp.org/\">upcoming WordCamps</a> and <a href=\"https://make.wordpress.org/community/events/\">meetups</a>.</p>\n\n\n\n<h2>Important Team announcements/updates</h2>\n\n\n\n<ul><li>The Polyglots Team <a href=\"https://make.wordpress.org/polyglots/2021/09/27/sign-up-for-the-new-polyglots-monthly-newsletter/\">opened sign-ups</a> for their new monthly newsletter. The first edition goes out on October 15!</li><li>The<a href=\"https://make.wordpress.org/project/2021/09/10/suggested-iterations-for-the-five-for-the-future-program-and-tool/\"> Five for the Future program is being revisited</a> to identify opportunities for growth.&nbsp;</li><li>The Docs Team formally <a href=\"https://make.wordpress.org/docs/2021/09/15/announcement-new-workflow-for-reporting-documentation-issues/\">launched a new repository</a> for tracking issues with WordPress documentation: <a href=\"https://github.com/WordPress/Documentation-Issue-Tracker\">https://github.com/WordPress/Documentation-Issue-Tracker</a></li><li>The Plugins Team <a href=\"https://make.wordpress.org/plugins/2021/09/20/change-to-how-long-active-reviews-remain-open/\">reduced the time period to complete active review requests for plugins</a> from six to three months.</li><li>The Community Team started work on the <a href=\"https://make.wordpress.org/community/2021/09/10/2022-global-sponsorship-working-group/\">2022 Global Sponsorship program</a>.</li><li>The Design Team is <a href=\"https://make.wordpress.org/design/2021/09/16/document-status-and-visibility/\">working on a redesign proposal of the Inspector sidebar</a> in the WordPress post/page editor.</li><li>The Themes Team announced the results of the <a href=\"https://make.wordpress.org/themes/2021/09/13/theme-upload-survey-results-next-steps/\">six-week Theme author survey</a>.</li><li>The Training Team also shared <a href=\"https://make.wordpress.org/training/2021/09/14/learn-wordpress-needs-assessment-results/\">results of a third-party needs assessment exercise for Learn WordPress</a> which offers some excellent insights.&nbsp;</li></ul>\n\n\n\n<h2>Feedback/Testing requests from Contributor Teams</h2>\n\n\n\n<ul><li>Version 18.3 of WordPress for <a href=\"https://make.wordpress.org/mobile/2021/09/20/call-for-testing-wordpress-for-ios-18-3/\">iOS</a> and <a href=\"https://make.wordpress.org/mobile/2021/09/21/call-for-testing-wordpress-for-android-18-3/\">Android</a> are now available for testing!</li><li>Join the <a href=\"https://make.wordpress.org/test/2021/09/29/fse-program-testing-call-10-pattern-party/\">10th challenge</a> of the <a href=\"https://make.wordpress.org/core/2020/12/11/the-fse-outreach-program-is-officially-starting/\">Full Site Editing (FSE) Outreach program</a> &#8211; “<a href=\"https://make.wordpress.org/test/2021/09/29/fse-program-testing-call-10-pattern-party/\">Pattern Party</a>”. Check out the <a href=\"https://make.wordpress.org/test/2021/09/29/fse-program-testing-call-10-pattern-party/\">announcement post</a> for testing instructions and join the fun in the <a href=\"https://wordpress.slack.com/archives/C015GUFFC00\">#fse-outreach-experiment</a> Slack channel. Deadline: October 13, 2021</li><li>The Training Team is requesting feedback on:<ul><li><a href=\"https://make.wordpress.org/training/2021/09/27/proposal-ensuring-high-quality-video-contributions-to-learn-wordpress/\">Strategies to ensure high-quality video contributions for Learn WordPress</a>. Deadline: October 6, 2021</li><li><a href=\"https://make.wordpress.org/training/2021/08/10/proposal-learner-achievements-on-profiles/\">Learner achievements on profiles</a>: no current deadline</li></ul></li><li>Help the Test Team <a href=\"https://make.wordpress.org/test/2021/10/01/test-team-chat-summary-28-september-2021/\">reach out to extenders to check if their test suites are compatible with the modernization of the WordPress Core PHP Test Suites</a>. Information on what the changes mean and step-by-step instructions are available over in the following post: <a href=\"https://make.wordpress.org/core/2021/09/27/changes-to-the-wordpress-core-php-test-suite/\">Changes to the WordPress Core PHP Test Suite</a>.</li><li>The Polyglots Team is <a href=\"https://make.wordpress.org/polyglots/2021/09/19/how-to-handle-block-pattern-translations/\">exploring two different mechanisms on translating user-submitted block patterns</a>: GlotPress v/s forking patterns to locales and is requesting feedback from community members.</li></ul>\n\n\n\n<h2>WordPress Events updates</h2>\n\n\n\n<ul><li><a href=\"https://galicia.wordcamp.org/2021/\">WordCamp Galicia 2021</a> was held from September 30 &#8211; October 2, 2021 and <a href=\"https://us.wordcamp.org/2021/\">WordCamp US 2021</a> ran on October 1.</li><li>Don’t miss these upcoming WordCamps: <a href=\"https://nicaragua.wordcamp.org/2021/\">WordCamp Nicaragua 2021</a> (October 8-9, 2021) and <a href=\"https://italia.wordcamp.org/2021/\">WordCamp Italia 2021</a> (October 22-23, 2021) </li><li>The Diverse Speakers Training group (<a href=\"https://make.wordpress.org/community/tag/wpdiversity/\">#WPDiversity</a>) of the Community Team organized an <a href=\"https://make.wordpress.org/community/2021/09/15/wpdiversity-events-in-september-attention-india/\">allyship workshop, along with dedicated workshops focused on India in September</a>.</li><li>The Test Team organized a <a href=\"https://make.wordpress.org/test/2021/09/17/hallway-hangout-discussion-on-adoption-pathways-for-full-site-editing-16-september/\">Hallway Hangout on adoption pathways for Full Site Editing</a> where attendees mentioned how they use FSE and shared ideas for improvement. </li></ul>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further reading</h2>\n\n\n\n<ul><li>The Hosting Team recommended that all web hosts <a href=\"https://make.wordpress.org/hosting/2021/09/15/wordpress-5-8-1-security-release-is-time-sensitive/\">test and push the WordPress 5.8.1 security update through to their users</a> as soon as possible.</li><li>The Training Team <a href=\"https://make.wordpress.org/training/2021/09/21/should-learn-wordpress-contributors-be-gpl-compliant/\">clarified GPL compliance guidelines</a> for Learn WordPress contributions, and the <a href=\"https://learn.wordpress.org/meta/handbook/workshops/eligibility-of-workshop-presenters/\">guidelines for workshop presenters are available in the handbook</a>.</li><li>The codebase for Openverse, a search engine for openly-licensed media,&nbsp; i<a href=\"https://make.wordpress.org/openverse/2021/09/03/call-for-translations-i18n-in-openverse/\">s now available for translation</a>.</li><li>The Core Team implemented a <a href=\"https://make.wordpress.org/core/2021/09/28/implementing-a-webfonts-api-in-wordpress-core/\">Webfonts API in WordPress core</a> for simplifying the process of enqueuing external fonts on WordPress sites.&nbsp;</li><li>The Test Team rescheduled <a href=\"https://make.wordpress.org/test/2021/09/23/5-9-end-to-end-e2e-working-strategy-session-agenda-for-29-sep-2021/\">the End-to-End (e2e) Test working strategy session</a> to October 6. More details <a href=\"https://make.wordpress.org/test/2021/09/23/5-9-end-to-end-e2e-working-strategy-session-agenda-for-29-sep-2021/\">in the announcement post</a>.</li></ul>\n\n\n\n<p><em>Have a story that we could include in the next ‘Month in WordPress’ post? Please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it using this form</em></a><em>.&nbsp;</em></p>\n\n\n\n<p><em>The following folks contributed to September’s Month in WordPress: <a href=\"https://profiles.wordpress.org/webcommsat/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>webcommsat</a>, <a href=\"https://profiles.wordpress.org/chaion07/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>chaion07</a>, <a href=\"https://profiles.wordpress.org/dansoschin/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>dansoschin</a>, <a href=\"https://profiles.wordpress.org/harishanker/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>harishanker</a>, <a href=\"https://profiles.wordpress.org/meher/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>meher</a>, and <a href=\"https://profiles.wordpress.org/tobifjellner/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>tobifjellner</a></em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 05 Oct 2021 20:01:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Hari Shanker R\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"WPTavern: Facebook Outage Rekindles Push for a Free and Open Web\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=123719\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:173:\"https://wptavern.com/facebook-outage-rekindles-push-for-a-free-and-open-web?utm_source=rss&utm_medium=rss&utm_campaign=facebook-outage-rekindles-push-for-a-free-and-open-web\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5825:\"<p>Facebook, Workplace, Instagram, and WhatsApp went down today for roughly six hours due to a Border Gateway Protocol (BGP) configuration error. Cloudflare describes BGP as &ldquo;<a href=\"https://www.cloudflare.com/learning/security/glossary/what-is-bgp/\">the postal service of the Internet</a>.&rdquo; It is responsible for routing Facebook&rsquo;s traffic and making all of its domains accessible to visitors.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">To be more precise (and Geek Factor 5) the BGP routes serving Facebook\'s authoritative DNS were withdrawn, rendering all Facebook domains inaccessible. That\'s per <a href=\"https://twitter.com/DougMadory?ref_src=twsrc{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5Etfw\">@DougMadory</a> , who knows a few things about BGP/DNS.</p>&mdash; briankrebs (@briankrebs) <a href=\"https://twitter.com/briankrebs/status/1445081561536339970?ref_src=twsrc{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5Etfw\">October 4, 2021</a></blockquote>\n</div>\n\n\n\n<p>At first glance, the outage appeared to be a malicious attack following a Facebook whistleblower&rsquo;s revelations on 60 Minutes Sunday evening. BGP routing can be hijacked, but so far there is no evidence to suggest that it&rsquo;s anything other than an ill-timed configuration error. </p>\n\n\n\n<p>&ldquo;The thing I saw at Facebook over and over again was there were conflicts of interest between what was good for the public and what was good for Facebook, and Facebook over and over again chose to optimize for its own interests, like making more money,&rdquo;&nbsp; former Facebook product manager Frances Haugen told <a href=\"https://www.cbsnews.com/news/facebook-whistleblower-frances-haugen-misinformation-public-60-minutes-2021-10-03/\">60 Minutes</a>. </p>\n\n\n\n<p>Haugen copied tens of thousands of documents of internal research before leaving, one which stated: &ldquo;We have evidence from a variety of sources that hate speech, divisive political speech and misinformation on Facebook and the family of apps are affecting societies around the world.&rdquo;</p>\n\n\n\n<p>Haugen&rsquo;s interview with 60 Minutes had already made Facebook&rsquo;s lack of ethical compass a hot topic at media outlets before all of its web properties went down earlier today. This outage is one of the most severe in the company&rsquo;s 17-year history, due to the cascading effects of Facebook&rsquo;s infrastructure being tied into so many aspects of every day life. According to <a href=\"https://www.independent.co.uk/life-style/gadgets-and-tech/verizon-down-tmobile-ee-internet-b1932198.html\">The Independent</a>, reports of problems at internet and phone companies started rolling in, as Facebook and its related apps are often confused with the internet. </p>\n\n\n\n<p>The whistleblower&rsquo;s evidence of the pernicious nature of Facebook&rsquo;s algorithms, combined with the widespread outage of the company&rsquo;s network of services, has sparked a renewed call for people and businesses to return to the open web. </p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Seems like a good time to remind every business owner that you do not own your audience on social media. Whether you have 10 followers or 10,000,000, they can be gone in an instant. Build your email list and create content on your own website.</p>&mdash; Quincy Zikmund (@quincyzikmund) <a href=\"https://twitter.com/quincyzikmund/status/1445075850320359426?ref_src=twsrc{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5Etfw\">October 4, 2021</a></blockquote>\n</div>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Now is an excellent time to email your local authorities, school, camp, church, soccer league, whatever &ndash; and tell them: <br /><br />\"Please stop posting your updates on Facebook and Instagram, which are liable to disappear. Instead, use a website on the open web, and email updates.\"</p>&mdash; Mark Hurst (@markhurst) <a href=\"https://twitter.com/markhurst/status/1445135780171636736?ref_src=twsrc{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5Etfw\">October 4, 2021</a></blockquote>\n</div>\n\n\n\n<p>These kinds of outages disrupt those who have built their communications and commerce on top of Facebook&rsquo;s products. Businesses put themselves in a vulnerable place when they rely on a walled garden to deliver audience engagement, especially when that garden&rsquo;s algorithms promote divisive discourse and misinformation. Business owners should take recent events as a wakeup call and revoke all the permissions given to unaccountable platforms for short-term gains. It&rsquo;s time to invest in the long-term health of your online presence by building on the open web. </p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">While we\'re at it: if you don\'t have a Web site of your own and you\'ve been blogging and creating content on third-party platforms, now might be a good time to reconsider creating one and owning your own little corner of the internet. &#128273;</p>&mdash; Sara Soueidan (@SaraSoueidan) <a href=\"https://twitter.com/SaraSoueidan/status/1445107375006945282?ref_src=twsrc{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5Etfw\">October 4, 2021</a></blockquote>\n</div>\n\n\n\n<p>As good people work to expose the inner workings of companies that have abandoned principles in pursuit of profit, I am hopeful the web will right itself and applications will become more open and adept at helping people navigate these turbulent times. For those today who are remembering what it&rsquo;s like to have <a href=\"https://wptavern.com/automattic-takes-on-facebook-with-a-meditation-on-the-open-web\">a breath of fresh air</a> in Facebook&rsquo;s absence, challenge yourself to start creating content on your own site. Make your website the original source of your work and distribute it out to social networks where you want to extend your reach. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 05 Oct 2021 02:45:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: The Next Web Publishes Storyblok-Sponsored Hit Piece on WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=123712\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:195:\"https://wptavern.com/the-next-web-publishes-storyblok-sponsored-hit-piece-on-wordpress?utm_source=rss&utm_medium=rss&utm_campaign=the-next-web-publishes-storyblok-sponsored-hit-piece-on-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6366:\"<p class=\"has-drop-cap\">Last week, under its news section, The Next Web published what could only be described as a hit piece: <a href=\"https://thenextweb.com/news/developers-hate-wordpress-so-should-marketers\">Developers hate WordPress &mdash; and so should marketers</a>. The claim was that, despite its current 40{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9} market share, folks should start looking at alternatives for a better experience.</p>\n\n\n\n<p>The first developer interviewed for this piece was the CEO of Storyblok, Dominik Angerer. Storyblok is a headless CMS, a competitor to WordPress.</p>\n\n\n\n<p>The second person interviewed for the article was Doeke Leeuwis, the founder and technical director for Story of AMS. The agency focuses on headless eCommerce. <em>What is one of the three platforms it uses?</em> If you guessed Storyblok, you would have gotten it right. Bonus points if you predicted it was listed first of the three in their marketing material.</p>\n\n\n\n<p>The third developer interviewed was Mitchel van Bever, who also works for Story of AMS. The company has been featured multiple times on the Storyblok blog and is a featured case study.</p>\n\n\n\n<p><em>Are you starting to see a pattern yet?</em></p>\n\n\n\n<p>If you read through the rest of the article, you will note that the post was sponsored by Storyblok. At least they were honest about it.</p>\n\n\n\n<img />\n\n\n\n<p>Somehow I believe most readers would have skipped the article if that was posted before the content.</p>\n\n\n\n<p>It is easy to find developers who dislike WordPress. But, you lose credibility when writing a piece that features interviewees who are either directly sponsoring or benefitting from the story.</p>\n\n\n\n<p>The centerpiece for the entire story hinged on the <a href=\"https://insights.stackoverflow.com/survey/2019\">2019</a> and <a href=\"https://insights.stackoverflow.com/survey/2020\">2020</a> Stack Overflow annual developer survey. There is a lot to glean from the data provided by over 65,000 workers in the field. However, the article merely focused on a single point: WordPress was voted the most dreaded language or technology at 67{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9} in the last year. Everything else centered on what those with a vested interest in Storyblok had to say.</p>\n\n\n\n<p>We could talk about scalability, but with WordPress.com as a prime example of running the WordPress software at scale, do we really need to?</p>\n\n\n\n<p>We could talk about flexibility, but when WordPress has more free third-party plugins (59,000+) than Storyblok has in total live websites (<a href=\"https://trends.builtwith.com/cms/Storyblok\">500+ according to BuiltWith</a>), is it really worth diving into?</p>\n\n\n\n<p>As a writer in the WordPress sphere, you may think I am entirely biased. That is at least partially true. However, I have worked with multiple systems. Laravel is one of my favorites, but its beautiful architecture does not always translate to quickly getting a job done in the same way as WordPress. I have helped friends and family launch projects on several non-WordPress services. It all depends on what the best tool for the job is.</p>\n\n\n\n<p>I have even created my own custom CMS for my personal blog. I felt like WordPress was overkill for what I needed. It is OK to use another tool even when you typically prefer working with something else. My custom blogging system was built just for me, but it now runs on two websites. I had another developer friend crazy enough to try it.</p>\n\n\n\n<p>My love for WordPress is not absolute. It is not unconditional.</p>\n\n\n\n<p>But I still love it. There are 1,000s of others who love working with it too, and these developers are more likely to tell you what the <em>actual</em> issues with the platform are. We can criticize it honestly because we are down in the trenches, working with the platform every day. We know it is not always the ideal programming experience. We know it has some legacy baggage. Despite its warts, we have built something that most others only dream of doing. We have created a vast community.</p>\n\n\n\n<p>If you thought it was all about who had the shiniest code, you would be wrong.</p>\n\n\n\n<p>It is about business competitors willing to communicate and even help others in their space.</p>\n\n\n\n<p>It is about <a href=\"https://wordpress.org/five-for-the-future/\">Five for the Future</a>, a program where WordPress-related companies contribute to free software.</p>\n\n\n\n<p>It is about <a href=\"https://wordpress.org/support/\">support forum</a> volunteers lending a helping hand.</p>\n\n\n\n<p>It is about the 100s of folks on the <a href=\"https://make.wordpress.org/\">Make WordPress</a> teams who contribute to various aspects of the project, everything from code reviews to translations.</p>\n\n\n\n<p>It is about sharing a drink with a years-long friend you just met IRL for the first time at a <a href=\"https://central.wordcamp.org/\">WordCamp</a>, albeit mostly virtual for the last couple of years.</p>\n\n\n\n<p>It is about the <a href=\"https://wppodcasts.com/\">podcasts</a> that people produce for the love of the platform and its surrounding projects.</p>\n\n\n\n<p>It is about quitting your nine-to-five to launch a new business as a plugin developer.</p>\n\n\n\n<p>It is about taking part in a movement that has allowed millions to publish on the web.</p>\n\n\n\n<p>No, not every developer who participates in the annual Stack Overflow survey loves WordPress. Most of them may dread working with the platform, and that trend may very well continue. What we have is bigger. WordPress is its community.</p>\n\n\n\n<p>This smells like just another hit piece from a WordPress <em>competitor</em> <a href=\"https://wptavern.com/wixs-negative-advertising-campaign-falls-flat-with-wordpress-developers-and-professionals\">like we have seen before</a>. At least some of the Wix videos were funny (<em>come on, you know you laughed at at least one or two of them</em>), and folks <a href=\"https://wptavern.com/wix-takes-a-jab-at-wordpress-with-bewildering-new-marketing-campaign\">got free headphones from the deal</a>. This Storyblok-sponsored post just leaves a sour taste.</p>\n\n\n\n<p>Like my grandma &mdash; probably everyone&rsquo;s grandma &mdash; used to say, &ldquo;You catch more flies with honey.&rdquo; This was an opportunity to sell potential users on Storyblok&rsquo;s features. Maybe bashing competitors brings traffic, but I doubt it brings any goodwill or long-lasting benefits.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 04 Oct 2021 22:32:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WordPress.org blog: WP Briefing: Episode 17: WordPressing Your Way to Digital Literacy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=11316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://wordpress.org/news/2021/10/episode-17-wordpressing-your-way-to-digital-literacy/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:29419:\"<p>In episode 17 of the WordPress Briefing, Josepha Haden Chomphosy reflects on her WordCamp US keynote and digs into how participating in open source projects can help you learn 21st Century Skills.&nbsp;</p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2>Credits</h2>\n\n\n\n<ul><li>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a></li><li>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li><li>Production:&nbsp;<a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a></li><li>Song: Fearless First by Kevin MacLeod</li></ul>\n\n\n\n<h2>References </h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2021/09/03/wordpress-5-9-planning-roundup/\">WordPress 5.9 Planning</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2021/08/13/preliminary-road-to-5-9/\">5.9 Target Features</a></p>\n\n\n\n<p><a href=\"https://us.wordcamp.org/2021/\">WordCamp US 2021</a></p>\n\n\n\n<h2>Transcript</h2>\n\n\n\n<span id=\"more-11316\"></span>\n\n\n\n<p>Hello, everyone, and welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. See, here we go!</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>00:42</p>\n\n\n\n<p>Today I want to talk to you a little bit about the digital divide, where it is, maybe a bit of where it&#8217;s headed, and which parts of the WordPress open source project and CMS can help. This is a focused look, though, so I won&#8217;t touch on some of the hurdles that everyone is aware of when you get outside of in-person environments, things like parental modeling or supervision, education on the relevance of technology, etc. This is a follow-up to the conversation that I had at WordCamp US last week—and so doing a little bit of a deeper dive here. And we&#8217;re gonna start with what exactly is the digital divide.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>01:23</p>\n\n\n\n<p>So the digital divide is considered those who benefit from the digital age versus those who don&#8217;t; that feels like a really big concept. And the current discussion is primarily about access, or for years that has been about access anyway, especially physical access. So those who have computers versus those who do not have internet in their homes versus those who do not. But I don&#8217;t necessarily agree with that particular, really focused definition of the problem.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>01:59</p>\n\n\n\n<p>If the only problem we see is access, then the solution becomes to get cheap devices and internet to everyone, which certainly has led to more people being connected than ever before.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>02:12</p>\n\n\n\n<p>With this proliferation of devices that are considered both smart and mobile (mobile in this context, meaning handheld or pocket-sized), the discussion over the last few years has been shifting. It’s been shifting into more of a discussion around the education around the relevance of internet access, discussions around the quality of access to the Internet, and also discussions around Wi-Fi and dial-up and the surprising cost of data.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>02:42</p>\n\n\n\n<p>But from my perspective, there are a number of really dangerous assumptions that we make when we boil it all the way down to who has access and the quality of that kind of access.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>02:54</p>\n\n\n\n<p>The first dangerous assumption is that we run the risk of conflating being tech-savvy with being digitally literate, and they&#8217;re not really the same things. The second assumption that we run the risk of is assuming that access to cellular data equals access to the internet through any other means. And also assuming that cost is always the determining factor.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>03:19</p>\n\n\n\n<p>And the final fairly dangerous assumption that we&#8217;re making there is that we allow ourselves the ability to mark the digital divide is fixed in our minds. Once we get enough access to everyone, we&#8217;re just done. There is no more divide. But as a way of illustration, if you think about access, not in the context of technology, like high technology, digital technology, and in the context of like writing, you probably own a writing utensil, and you probably have access to paper of some sort, which is great. But just because you have like a pencil and a piece of paper doesn&#8217;t mean that I can send you home right now &#8211; I guess most of you are listening at home.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>04:07</p>\n\n\n\n<p>It doesn&#8217;t mean that I can send you to your desk right now. And consider you prepared to write a best-selling novel, right? Because giving you physical tools no more makes you a novelist than handing me a computer when I was a teen made me digitally literate.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>04:24</p>\n\n\n\n<p>So let&#8217;s talk about what it takes to be digitally literate. I&#8217;ve lumped the following skills into three groups. It&#8217;s broadly defined as 21st-century skills, but the groups that I have them in is not a comprehensive list of those 21st-century skills.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>04:41</p>\n\n\n\n<p>The first group that is a large component of digital literacy is critical thinking skills. So computational thinking and problem-solving. That particular one is not new, exactly. But the computational thinking part certainly is. Not all problems are solved with code, but the basis for thinking through things procedurally is increasingly important.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>05:04</p>\n\n\n\n<p>The second one in that set is communication through multiple media, consuming communications or content through Twitter, Instagram, Snapchat, or any other format, but also creating the things that communicate—writing blogs, creating videos, both calls and standalone, and forums, things like that.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>05:27</p>\n\n\n\n<p>The third set in that group of critical thinking skills is around collaboration, which some people will say is more about communication. But I find that collaboration both online and in-person is a skill set all to its own. Communication only gets you so far when you&#8217;re learning to cook to collaborate with people that you don&#8217;t normally work with. And so, I have lumped that into critical thinking skills.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>05:54</p>\n\n\n\n<p>The second big bucket for digital literacy is actually literally digital literacy. So I have three, three things in here as well. Evaluating information is obviously incredibly important in the environment that we&#8217;re in right now, for just information’s sake. But then things like understanding the differences between copyright versus copyleft licenses, understanding the difference between an .org ending URL and a .com ending URL, and evaluating the general veracity of sources that you&#8217;re finding on the web.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>06:32</p>\n\n\n\n<p>The second part of that group is media use and creation, understanding the difference between folks who consume and folks who create the content we have, how to find information online, and the most sensible places to keep information online. And the third area of digital literacy that I find to be vitally important is the ethics of licenses both around use and access. So again, things like copyright vs. Copy, copyleft. And specifically for WordPress, that means understanding things like the Creative Commons licenses, GPL, MIT, but then also copyright is its own complicated question unto itself. But the other things that show up for us for WordPress that show up for us with technology are also things like open access versus proprietary information and sources. And things like plagiarism versus sampling.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>07:33</p>\n\n\n\n<p>And our third big bucket, which has become increasingly complex, but the third big bucket for digital literacy to my mind is actually considered something that I call life skills. So things like self-direction, knowing what you want to do next, and how to get it done. Time management is also in there, knowing how much time something will take and being able to make sure that you are getting things done over time, as opposed to trying to accomplish everything at the last second.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>08:03</p>\n\n\n\n<p>A big part of these life skills is cross-cultural and social communication. The internet is tricky, right? Because it&#8217;s simultaneously incredibly insular and increasingly global. Like you can if you wanted only ever read things that already confirm your existing biases. But the very nature of the internet, the very nature of the web, means that the world is much smaller. We have more ready access faster to everyone everywhere in the world than we used to have. This means, of course, that cultural awareness is an absolute must now more than ever. This is for what it&#8217;s worth the time of year when I give this talk. And that&#8217;s because of this last part of the life skills section, which is digital citizenship.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>08:54</p>\n\n\n\n<p>Digital citizenship generally is the second week of October 2 or the third week of October. And it&#8217;s one of my favorite weeks because it is something that comes up all the time in our ecosystem. It comes up all the time and open source in general, but certainly for WordPress. So those are our three big buckets of digital literacy, a subset of 21st-century skills as a whole.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>09:22</p>\n\n\n\n<p>That&#8217;s a lot of stuff, I know. And it&#8217;s also really hard to figure out how you can learn any of those skills, and from my experience, I really believe that WordPress as an open source project can help people learn those things.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>09:43</p>\n\n\n\n<p>Once upon a time, ages and ages ago, my mother told me that in order for me to become a better writer, I would have to read and in order to become a better communicator, it would probably help if I spent a little bit more time writing, and I have always felt that the same must be true for all the things that we learn, you find a positive example and study it to become better. Or, depending on what you&#8217;re learning and how you&#8217;re trying to learn it, you find a passive example of something that you want to be able to do better from an active standpoint and participate in that so that your active production of the other part is better.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>10:24</p>\n\n\n\n<p>Here are a few parts of the WordPress project and WordPress itself that can help with this.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>10:31</p>\n\n\n\n<p>So there are first a few really specific teams; if you&#8217;re contributing to a team like Themes, or Plugins, or Core, the three areas of those digital literacy skills that you have an opportunity to learn there. For critical thinking, you&#8217;re going to run into problem-solving and computational thinking. You’re also going to run into distributed collaboration, which was really important as just a concept when I first wrote this talk. And now it is currently really important as a reality because we have a bunch of companies that are going to either remote work or partially distributed or fully distributed. And that&#8217;s the way that WordPress has worked for a pretty long time.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>11:19</p>\n\n\n\n<p>So I&#8217;ve always felt like it was important because it was important to WordPress, but it&#8217;s also becoming increasingly an important part of just how to exist in the world at the moment. For those three teams, the things that you can really tap into and practice for the life skill section are digital literacy, nope, digital citizenship, self-direction, and time management obviously comes up in any open source project because you are volunteering your time and it is up to you to kind of decide how much you can commit or not various other parts of time management and directing one&#8217;s own project. Now, but you also get the opportunity to test and practice your cross-cultural communication, social communication and learning what it means to collaborate across cultures in that way.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>12:15</p>\n\n\n\n<p>On the digital literacy side, you also get a little bit of that information evaluation and synthesis for what it&#8217;s worth. And then obviously get to learn more about the ethics of various types of licenses and how use and access relate to those things.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>12:35</p>\n\n\n\n<p>We also have a team or two; these are not really teams or twos. These are things that you can do that are either solo activities or group activities. One is working or checking out the support forums, and the other is blogging. We’ll start with support forums.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>12:52</p>\n\n\n\n<p>If you&#8217;re doing this as a group activity, there are a couple of extra things that that you can practice here. But suppose you&#8217;re doing it as a solo, just way to give back to the project sort of thing or way to learn some of these skills sort of thing. In that case, you can get almost all of these digital literacy skills woven into working in the support forums, depending on what&#8217;s happening in the moment and the questions people have brought up. But for critical thinking, obviously, you get some problem solving in there, not as much the computational thinking as the procedural thinking part. But you certainly also get to tap into communication with multiple types of media, collaboration in person and online, depending on whether you&#8217;re doing this as a solo effort or a group effort. And then, of course, research, which I didn&#8217;t really bring up in any of those groupings for digital literacy, is certainly a very important part of it.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>13:49</p>\n\n\n\n<p>For the digital literacy grouping of skills related to digital literacy, you get to work on evaluating information and, depending on how complicated an answer might be. You can also get that opportunity to practice synthesizing complex information and research, a digital literacy skill. And then, once people have responded to a topic you&#8217;ve answered, you also get to tap into that life skill section. You get to be you get the opportunity to practice digital citizenship related to synchronous or asynchronous conversation. You also get to see more about how cross-cultural communication and collaboration works and social communication across those various boundaries that naturally show up when we&#8217;re working across cultures that way. And as I mentioned previously, information synthesis, as well.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>14:53</p>\n\n\n\n<p>The second one that I have mentioned can be like a solo effort or a group effort, depending on what you do. Blogging, for most people who use WordPress, is probably the most common application of how WordPress can help you do stuff. So I often see it as the most relevant and the most immediately accessible to anyone. But you know, you got to meet people where they are. So, I would strongly believe that this is our best way to help people learn these things.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>15:30</p>\n\n\n\n<p>So blogging for the critical thinking sorts of things, you have an opportunity to practice communication across mediums. You will probably get an opportunity to practice your research skills, chances are, you&#8217;re going to get the opportunity to practice some problem solving, and honestly, like if you&#8217;re hosting your site, problem-solving is going to come up when using WordPress as soon as you add in plugins and themes, because you sometimes kind of have to figure out what&#8217;s working and what&#8217;s not, and what&#8217;s playing nicely with other things and what&#8217;s not. It&#8217;s possible that with blogging, you&#8217;re also going to have an opportunity to get to practice some distributed collaboration. But that&#8217;s probably going to depend on what you&#8217;re doing with your site as well.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>16:30</p>\n\n\n\n<p>Licenses and how they apply to the thing that you&#8217;re using feel a bit different when you are the one who&#8217;s creating. And so learning about how those things work and don&#8217;t work and how they can best suit what you&#8217;re trying to do. Blogging is absolutely an excellent opportunity to dig into that a bit and learn a bit more about that. As far as your life skills go,</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>16:56</p>\n\n\n\n<p>that&#8217;s where you, again, get to practice some digital citizenship by figuring out who your audiences are and also when you have to communicate with them via the comments or any other way that you have built up a feedback mechanism there.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>17:11</p>\n\n\n\n<p>Self-direction obviously will come into this, maybe time management if you are blogging on, I was gonna say on a paid basis, but that&#8217;s not really I don&#8217;t know, on a project basis, like some of us are students and have to write things based on deadlines. And so, you know, self-direction, potentially time management, always cross-cultural communication, social communication, research, all of these things show up in there.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>17:41</p>\n\n\n\n<p>And, you know, I really believe in this concept of how blogging and bringing people into maintaining a website can teach you all of these skills. Because when I was younger, I was a bad communicator. And now, I am across the board known for my effective communication and my ability to work across cultures. And so the defining moment, which was like a four-year moment, and so not necessarily a moment, but the thing that really made all the difference was when my mom challenged me to write every single day. She had noted that I was not necessarily great at getting from one point to the next. I wasn&#8217;t necessarily great at building my arguments when I had to explain something to people. And she suggested that writing every day would help me tap into this big thing about communication and working with other people collaboration, all of that. And as an adult on the other side of it. Like, I thought she was super wrong when I was younger, because don&#8217;t we all think our parents are wrong when we&#8217;re younger. But as an adult on the other side of it, not only was that an opportunity for me to literally learn how to communicate better. But it also, when I look at it, gave me access to opportunities to practice all sorts of 21st-century skills and digital literacy skills in an environment that was relatively safe. And so, I am a big proponent of this particular one.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>19:26</p>\n\n\n\n<p>Another team that helps us tap into and practice a lot of our digital literacy skills is the Documentation team. I recommend that you let this be a supervised activity if you&#8217;re doing this with students because, you know, it&#8217;s a wiki. You can put weird things in there on accident or just inaccurate things. So for critical thinking, the primary skill that you&#8217;re going to be able to practice if you&#8217;re working on documentation is collaboration. You would think that it was also like information synthesis and information evaluation. But for a lot of the work that we&#8217;re doing, the documentation exists. And what we&#8217;re looking at is trying to figure out where it no longer matches what is currently in the CMS, or currently in the project or currently in the team, whatever it is that you&#8217;re working on at that moment. And so, it&#8217;s a strong collaborative effort in the WordPress project. You have to have done the general work to figure out what needs to be changed in the documentation. But a lot of times, you need to figure out who has access to make the changes, what has prevented us from making changes in the past, and things like that. And so I say, collaboration is the only one to learn and critical thinking, but it&#8217;s actually a really big one and can take a fair amount of effort in this particular context.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>20:49</p>\n\n\n\n<p>From the digital literacy aspect, of course, there is evaluating information. But this particular type of information evaluation is a little different for documentation. And this actually is true for the Documentation team, for the Training team, and also for the new Learn team. This question is true for all of them. There is a huge difference between presentation versus application of information. The way you present information for people who already know it and just need confirmation of something or are using it for reference material is really different from when people are looking at a piece of documentation that should be telling them how to accomplish something. And they try to apply it either to their own processes at the moment or apply it to teaching other people. And so evaluating information to make sure that what is presented can be applied, and all of the ways that that very complicated journey with managing information can kind of work or not, depending on how things are going in your section of the open source project at the moment.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>21:59</p>\n\n\n\n<p>The third group of skills that you can really dig into in those teams, again, is digital citizenship, basically, everything is digital citizenship in WordPress because we&#8217;re just people online.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>22:24</p>\n\n\n\n<p>And this final grouping that we have this final team and group of skills. So the Community team is a substantial and far-ranging team; they have many things that fall into their area of expertise. And so this has traditionally kind of functioned as a linchpin around education and ensuring that that was all relevant for users and attendees of events. The Community team will remain pivotal to so many things that we do now. But now that we have really awakened the Learn team and re-enlivened that Training team, this will shift a little over time. But yes, so that grain of salt that depending on when you listen to this, if you listen to it in 2050, maybe it&#8217;s not accurate anymore. Hopefully, most of what I say is not accurate in 2050. But you know, still.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>23:27</p>\n\n\n\n<p>&nbsp;Anyway! Critical thinking that&#8217;s where we were. So the critical thinking group of skills inside the Community team, you are going to have an opportunity to practice problem-solving. And frequently also procedural thinking, depending on what you&#8217;re working on in that team. Multimedia communication is absolutely true. And that&#8217;s true, whether you contribute to the team itself and make sure that the team is functioning and doing their basic tasks. Or if you are organizing an entire event, whether it&#8217;s online or offline or however that is being accomplished.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>24:07</p>\n\n\n\n<p>Multimedia communication for this particular team is constant for all of their work and something that everyone who works on there gets to practice all the time. For digital literacy, this comes up a lot if what you&#8217;re doing is working through any sort of like programming plans, making sure that what we have in place for events is really excellent. It&#8217;s a really excellent opportunity for practicing the evaluation of information, learning more about media use and creation, and then naturally, everything to do with licenses copyright copyleft, not only for everything that we produce but then also for everyone in the ecosystem.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>24:55</p>\n\n\n\n<p>This team helps so many plugins, authors and theme developers, and other groups who participate in the ecosystem understand the nuances of the GPL and why it matters so much to WordPress. And then in the life skill section, there&#8217;s the obvious life skill section, life skills that have come up for all of them—so digital citizenship, cross-cultural and social communication. But also you have the opportunity to tap into that self-direction and time management practice, which probably should also be considered in all of these teams. But, you know, things change as we go.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>25:45</p>\n\n\n\n<p>Those are the most likely digital literacy skills that you would end up practicing in the Community team, depending on how you are participating in the Community team at that moment.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>25:59</p>\n\n\n\n<p>So I said that we would talk a little bit about where this is all headed and what to do next. And like I just said, when I got lost in my own reverie, they&#8217;re like, hopefully, everything that I&#8217;ve shared here is out of date by 2050. Like, if we can come back to this particular podcast, or this presentation, or anything I&#8217;ve ever said, about digital literacy over my time with WordPress. And if we could come back to that in 2050, or, you know, I was going to say, 20 years from now, 2041 feels really close. But, you know, come back to it in the future, and say, that was all really excellent information to know at the moment. And we did do those things. And now, WordPress has proven that open source contribution and collaboration can teach all of the necessary 21st-century skills that anyone would need to survive in the world. And we did do it, that would be really cool. But I don&#8217;t think that that&#8217;s where we&#8217;re headed. Not because I don&#8217;t think people believe in what I&#8217;m saying or care about what I&#8217;m saying. But because it&#8217;s very easy to kind of let these things go at some point.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>27:20</p>\n\n\n\n<p>Even if you at some point, were proficient in all of what is considered 21st-century skills, sometimes our skills don&#8217;t get used very much. And so we lose track of them. And we don&#8217;t know, or we don&#8217;t know how to teach them to other people and various ways to do that. So I hope that when we revisit this in the time capsule of the internet 20 years from now, we can say that was a great explanation. And we learned so much. And we made so many changes in such progress that now we need a new version of this. That&#8217;s really all we can do, always striving to leave the world in a better position than when we found it.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>28:07</p>\n\n\n\n<p>All right, that brings us to our small list of big things. I don&#8217;t have a ton to share with you today. But what I do have to share with you is a really big deal. So we are about a week away from the Go/No-Go point of WordPress 5.9. That is the final release of the year. And as soon as we know what is a go or a no go from that meeting on October 12th,&nbsp; everyone is going just to hit the ground running. And so, if you are interested in contributing to that release, either by being a participant in the release squad or leading some part of the release squad. Absolutely. Drop by and let me know because I am interested to know who wants to learn more about doing that. And this is actually something that has gone by. I mentioned at the top that I spoke at WordCamp US.&nbsp; That is still true; I did do it. And so did a bunch of other really excellent presenters. If you missed WordCamp US on Friday, for whatever reason, because you know, life is complicated. Pretty soon, we will have the videos. We&#8217;ll have all the videos up with captions quickly and have those available for everyone to watch and learn more from as their schedule allows and as their attention allows. And that is your small list of big things. Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphos, and I&#8217;ll see you again in a couple of weeks.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 04 Oct 2021 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chloe Bringmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"Gutenberg Times: A Block Pattern Party in more ways than one – Weekend Edition 187\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=19137\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://gutenbergtimes.com/a-block-pattern-party-in-more-ways-than-one-weekend-edition-187/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:17739:\"<p>Howdy! </p>\n\n\n\n<p>Did you get to watch the fantastic presentations about the block-editor at WordCamp US? No? I am sure they will be posted on WordPress TV in no time. I&#8217;ll keep and eye out. The best presentations from my perspective? </p>\n\n\n\n<ul><li><strong>Helen Hou-Sandi</strong> talked about the adventure building WhiteHouse.gov site within 6 weeks. Her look behind the scenes and the thoughts behind the front page header block build, was a great case study, why to use blocks and not ACF. <a href=\"https://youtu.be/_6-yAZRXY8k?t=19298\">(Recording on YouTube)</a></li><li><strong>Kjell Reigstad</strong> showed some wonderful creative examples how you could use Block Styles for some funky and new way to display blocks. Most with no JavaScript, all in CSS. <a href=\"https://youtu.be/_6-yAZRXY8k?t=23716\">(Recording on YouTube)</a></li><li><strong>Rich Tabor </strong>did a phenomenal job diving into the seven realms of Full-Site Editing and Theme building, with an <a href=\"https://www.figma.com/proto/HAvCFREaCsvXAO1X71RDID/WCUS{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}3A-Building-Modern-WordPress-Websites?page-id=217{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}3A148&node-id=235{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}3A354&viewport=241{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C48{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C0.1&scaling=contain&starting-point-node-id=233{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}3A136\">exponentially spruced up slide deck</a> and a very soothing voice.  We were all more relaxed about the huge changes to come.  <a href=\"https://youtu.be/_6-yAZRXY8k?t=6725\">(Recording on YouTube)</a></li></ul>\n\n\n\n<p>That was only one day, yesterday, but more things happened in Gutenberg land. What have you been working on? I want to know. Hit reply and tell me:-) </p>\n\n\n\n<p>We have some great posts and videos for you. Did I miss one or two? Let me know that too. </p>\n\n\n\n<p>I&#8217;m excited to see you next week at our <a href=\"https://us02web.zoom.us/webinar/register/4216223029678/WN_TShtABQnRYKrHN6ffMFpaA\">Live Q &amp; A on theme building</a>.</p>\n\n\n\n<p>If you are not a theme builder, maybe you are interested in our upcoming <a href=\"https://us02web.zoom.us/webinar/register/4016325801172/WN_v-EXlrFaRcabGz78jgj8CA\">Live Q &amp; A on block building with members of the BuddyPress team.</a> </p>\n\n\n\n<p>Be well, 💕</p>\n\n\n\n<p>Birgit</p>\n\n\n\n<p>PS: Huge Thank you to <strong>Rob Cairns</strong> for a conversation among friends about my start at Automattic, the beginning of the Gutenberg Times and catch-up  on&nbsp;Full Site Editing. Listen to <a href=\"https://the-sdm-show.castos.com/episodes/episode-154-talking-all-things-gutenberg-with-birgit-pauli-haack?mc_cid=00a6b66a45&mc_eid=09df171d7b\"><strong>Episode #154 of The SDM Show</strong></a> by <a href=\"https://stunningdigitalmarketing.com/\"><em>Stunning Digital Marketing.</em></a></p>\n\n\n\n<p>PPS: Monday, 10/4 at 9am EDT / 2pm UK Time, I&#8217;ll join Nathan Wrigley, Michelle Frechette and Rob Cairns on the <strong>WPBuilds</strong>&#8216; <strong>This Week in WordPress Show</strong>. <a href=\"https://www.youtube.com/watch?v=g9odrdX6dZA\">It will be live streamed on YouTube.</a></p>\n\n\n\n<p>PPS: Don&#8217;t miss the fantastic <strong>Page Builder Summit! Oct 18 &#8211; 22, 2021</strong> &#8211; Schedule below.  </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<h2>Gutenberg Development and Team updates </h2>\n\n\n\n<p><strong>Gutenberg 11.6 </strong>was released. Now you can lock certain blocks, edit the site logo image file within the Site Logo block (yay!) and child themes have now basic support for full-site editing and Global Styles. <strong>Nik Tsekouras</strong> has the details for you in his release post: <a href=\"https://make.wordpress.org/core/2021/10/01/whats-new-in-gutenberg-11-6-29-september/\"><strong>What’s new in Gutenberg 11.6 (29 September)</strong></a>. </p>\n\n\n\n<ul><li>Justin Tadlock gave the new version a spin for his article <strong><a href=\"https://wptavern.com/gutenberg-11-6-improves-the-global-styles-ui-adds-child-theme-support\">Gutenberg 11.6 Improves the Global Styles UI, Adds Child Theme Support</a>.</strong> </li><li>Sarah Gooding expanded on the <a href=\"https://wptavern.com/gutenberg-11-6-introduces-new-api-for-locking-blocks\"><strong>New API for Locking Blocks</strong></a>. </li></ul>\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2021&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test and Meta team from Jan. 2021 on. Updated by yours truly.  </p>\n\n\n\n\n<p><strong>Kelly Hoffman</strong> posted about the <a href=\"https://wordpress.org/news/2021/09/upcoming-gallery-block-improvements/\"><strong>upcoming improvements to the Gallery block.</strong></a> The silent video loops through many variations of how you can now configure the images in the gallery block. The total revamped Gallery Block is built from individual image blocks, that bring their features into the gallery: you can style each image differently, link each single image to a different URL, apply different duotone filters per image and crop images to fit into a pattern and more. </p>\n\n\n\n<p>You can enable this Gallery block from the <em>Gutenberg plugin&#8217;s Experiments page. </em>If you want to see what happens when your existing gallery change into the new Gallery Block, you click on <a href=\"https://github.com/WordPress/gutenberg/pull/34606\">“Update” button</a> of the the Block&#8217;s Toolbar <em>(new in 11.6)</em>.</p>\n\n\n\n<p>The refactored Gallery block is slated to come to WordPress with the 5.9 release. If you are a plugin or theme developer, <a href=\"https://make.wordpress.org/core/2021/08/20/gallery-block-refactor-dev-note/\">Glen Davies published a Dev Note last month. </a></p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>Maggie Cabrera</strong> publish the <strong><a href=\"https://make.wordpress.org/themes/2021/10/01/gutenberg-themes-week-of-september-27-2021/\">67th Gutenberg + Themes Round-up</a></strong> post from the Themes team with a list of ongoing discussions on Full-Site Editing, Global Styles, and Design Tools. Just as examples: </p>\n\n\n\n<ul><li>A discussion on <a href=\"https://github.com/WordPress/gutenberg/issues/34717\">Implicit Text, Hover, Focus Colors as Part of Color Palette</a>, or </li><li><a href=\"https://github.com/WordPress/gutenberg/issues/35114\">Whether to allow targeting&nbsp;<code>settings</code>&nbsp;that are specific to the block in theme.json file</a>. </li><li>You can also <a href=\"https://github.com/WordPress/gutenberg/issues/34574\">follow along the progress of the <strong>Global Style Interface</strong></a> via this overview issues. </li></ul>\n\n\n\n<p>There are quite a few more aspects listed, and they all could use your thoughts and ideas. It&#8217;s the place to be part of the discussion and influence development and designs. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>Shaun Andrews</strong> posted the recording and summary of the <a href=\"https://make.wordpress.org/design/2021/09/30/sept-2021-show-tell-recording/\"><strong>Design team&#8217;s Show &amp; Tell meeting.</strong></a> The meeting is mostly meant to catch up all design contributors on various stages of their work. </p>\n\n\n\n<p>In this meeting </p>\n\n\n\n<ul><li><strong>Tammie Lister</strong> talked about Block Support and how it is handled for individual blocks, in theme.json and block.json</li><li><strong>Javier Arce</strong> shared his designs for editing background in an image block images, and </li><li><strong>Channing Ritter</strong> discussed her exploration around Theme switching in the Site Editor. </li></ul>\n\n\n\n<h2>Full Site Editing and Themes </h2>\n\n\n\n<p>There are now many conversations about Full-Site Editing and how can site builders, agencies, designers and freelancers get a handle on the various pieces, that make up Full-Site Editing. <strong>Anne McCarthy</strong> published a longer post on <a href=\"https://nomad.blog/2021/09/29/sharing-approaches-for-fse-feature-adoption/\"><strong>Sharing Approaches for Adoption of Full-Site Editing</strong></a> in the WordPress ecosystem. She suggested a gradual adoption with increasing levels of complexity and maturity”. Quite an interesting read. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>Andres Noren</strong> published and <strong><a href=\"https://andersnoren.se/introducing-tove/\">introduction to his new block-based Theme &#8220;Tove&#8221;</a></strong> in which he lets you look behind the scenes. I found remarkable the comparison of this new theme with his latest classic theme: </p>\n\n\n\n<p>&#8220;Tove contains a theme.json file that specifies supported settings and styles, HTML template files and template parts used by the Site Editor, a couple of stylesheets, placeholder image assets, a folder with block patterns, and a functions.php file to enqueue assets and register block patterns and styles. That’s Tove. <em>Not a single line of JavaScript, and other than the functions.php file and a empty index.php file, no PHP either.</em></p>\n\n\n\n<p>Compare that to&nbsp;<a href=\"https://andersnoren.se/teman/eksell-wordpress-theme/\">Eksell</a>, my latest (and probably last?) free classic theme. Eksell has 1 700 lines of PHP in its functions.php and template-tags.php files, five PHP classes in five files, and over 1 000 lines of JavaScript (not counting the CSS variables ponyfill).&nbsp;“</p>\n\n\n\n<p class=\"has-secondary-color has-light-background-background-color has-text-color has-background\"><em>You will get an opportunity to connect with Anders Noren on Thursday together with Ellen Bauer and Carolina Nymark when we discuss going <a href=\"https://us02web.zoom.us/webinar/register/4216223029678/WN_TShtABQnRYKrHN6ffMFpaA\"><strong>from classic themes to Block-based Themes on our Live Q &amp; A.</strong></a> Get your seat <a href=\"https://us02web.zoom.us/webinar/register/4216223029678/WN_TShtABQnRYKrHN6ffMFpaA\">now!</a> </em></p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://wpblockpatterns.com/\">WPBlockPatterns.com</a></strong> is a site where you can compare, how the Patterns available in the WordPress.org directory perform with each Full Site Editing theme. On the first page of the site, you see the list of the block patterns from the directory. Once you click on  the <em>name of the pattern</em> a new window opens, and you can then select the theme from a drop-down box on the top right. </p>\n\n\n\n<img />\n\n\n\n<p><strong>Andrew Starr</strong>, owner of UX Themes and author of the <a href=\"https://wordpress.org/themes/hansen/\">Hansen theme</a>, created the site and <strong>Justin Tadlock</strong> connected with him for more details: <strong><a href=\"https://wptavern.com/preview-wordpress-block-pattern-and-theme-combinations-via-new-site\">Preview WordPress Block Pattern and Theme Combinations via New Site</a></strong>.</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>Tammie Lister </strong>started a new project: <strong><a href=\"https://ephemeralthemes.com/2021/10/01/a-block-pattern-a-day/\">A Block Pattern a Day</a></strong>. On her new site, <a href=\"http://patternspiration.com/\">Patternspiration</a>, she will publish a new pattern every day to explore all the possibilities with Block Patterns, and to get an idea on what tooling would be needed around it. Definitely a place to watch. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>Anne McCarthy</strong> published the <a href=\"https://make.wordpress.org/test/2021/09/29/fse-program-testing-call-10-pattern-party/\">10th call for testing</a> out of the Full-site editing outreach program and calls you to <strong><a href=\"https://make.wordpress.org/test/2021/09/29/fse-program-testing-call-10-pattern-party/\">join the Pattern Party</a></strong>, too! You are invited to test all the Theme Blocks, some already in WordPress 5.8 and some to come in WordPress 5.9 and create patterns with them. <em>&#8220;This test is focused on pushing these lovely Theme Blocks to their limits to better determine what to prioritize and what features might remain to be documented. &#8220;</em> McCarthy wrote. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://us02web.zoom.us/webinar/register/WN_peXesSoYRIOZUEd9eK0l-g\">Developing for the new wave of WordPress experience</a></strong> On&nbsp;<a href=\"https://us02web.zoom.us/webinar/register/WN_peXesSoYRIOZUEd9eK0l-g\" target=\"_blank\" rel=\"noreferrer noopener\">Tuesday, Oct 5 at 01:30 PM CST</a>, join <strong>Post Status </strong>CEO,&nbsp;<strong>Cory Miller</strong>, as he interviews&nbsp;<strong>Rich Tabor</strong>, Head of Product at&nbsp;Extendify, about the future of publishing with WordPress. Definitely a show worth watching! </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>WordPress Meetup London</strong> met this week, and during their 2nd hour they held a <strong><a href=\"https://youtu.be/k3HGkySWESk?t=4269\">Roundtable on Full-Site Editing</a></strong> hosted by Dan Maby guest Paul Lacey, Diane Wallace and Anne McCarthy.</p>\n\n\n\n<a href=\"https://youtu.be/k3HGkySWESk?t=4269\"><img /></a>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s main (trunk) branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total\" /></p>\n\n\n\n\n<h2>Using Gutenberg as Content Creator</h2>\n\n\n\n<p><strong>Istiak Rayhan</strong> shared with you the <a href=\"https://bloggingwizard.com/gutenberg-features/\"><strong>10 Interesting Gutenberg Features You May Not Know About</strong></a>. Rayhan pointed out most of my favorite features of the Block editor. He is also one of the authors of the Ultimate Blocks plugins, so it&#8217;s not a surprise to see it listed. </p>\n\n\n\n<p>Instead of the Document information page, I would pick the <strong><a href=\"https://make.wordpress.org/core/2021/06/09/core-editor-improvement-improve-your-workflow-with-list-view/\">List View</a></strong> next to it as the more useful tool for your workflow. You can identify blocks from their nested view and drag and drop them at a different spot of your post. </p>\n\n\n\n<p>Rayhan followed up with a <a href=\"https://bloggingwizard.com/gutenberg-block-editor/\"><strong>Beginner&#8217;s Guide for Gutenberg.</strong></a> I bookmarked his post to share it with others looking to get started with the block-editor. </p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h3 id=\"pagebuilder\">Page Builder Summit</h3>\n\n\n\n<p><strong><a href=\"https://pagebuildersummit.com/\">Page Builder Summit</a></strong> is coming back and will be happening <strong>October 18 &#8211; 22, 2021. </strong>Nathan Wrigley and Anchen Le Roux <a href=\"https://pagebuildersummit.com/schedule/\"><strong>just published the schedule</strong></a></p>\n\n\n\n<p>Here is the list of Gutenberg / Block-editor presentations </p>\n\n\n\n<ul><li><strong>Forging the Future with Full Site Editing</strong> with Anne McCarthy (10/18 &#8211; 9am EDT)</li><li><strong>The Future of Building WordPress Websites </strong>with Brian Gardner (10/18 &#8211; 12pm EDT)</li><li><strong>What does Full Site Editing Mean for Page Builders?</strong> with Joe Casabona (10/19/ 9am EDT)</li><li><strong>Customizing WordPress Block Editor for Client Projects </strong>with Birgit Pauli-Haack (10/19/ &#8211; 10 am EDT)</li><li><strong>Mastering modern WordPress with Full-site Editing &amp; Custom Blocks</strong> with Rob Stinson (10/20/ &#8211; 5am EDT)</li><li><strong>How to Build Any Page Layout Using Kadence Blocks</strong> with Jake Pfohl (10/20/ &#8211; 12pm EDT)</li><li><strong>Building a Custom Blog Archive with Blocks</strong> with Mike Oliver (10/21/ 11am EDT)</li><li><strong>RIP Page Builders</strong> with Chris Lubkert (10/19 &#8211; 1pm EDT)</li></ul>\n\n\n\n<p>The schedule is not out yet. <a href=\"https://pagebuildersummit.com/\"><strong>Sign-up for the waitlist</strong></a> to receive notifications.</p>\n\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p class=\"has-text-align-center\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\">Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n\n\n<p>Featured image: <a href=\"https://www.flickr.com/photos/10104201@N00/4672495978\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Fire wood&#8221;</a>&nbsp;by&nbsp;<a href=\"https://www.flickr.com/photos/10104201@N00\" target=\"_blank\" rel=\"noreferrer noopener\">rossbelmont</a>&nbsp;is licensed under&nbsp;<a target=\"_blank\" rel=\"noreferrer noopener\">CC BY-NC-SA 2.0</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 02 Oct 2021 15:40:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"WPTavern: Logtivity: A WordPress Activity Log Service With Customizable Charts, Alerts, and CSV Exports\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=122600\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:245:\"https://wptavern.com/logtivity-a-wordpress-activity-log-service-with-customizable-charts-alerts-and-csv-exports?utm_source=rss&utm_medium=rss&utm_campaign=logtivity-a-wordpress-activity-log-service-with-customizable-charts-alerts-and-csv-exports\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6238:\"<p class=\"has-drop-cap\">Launched by Ralph Morris and Steve Burge in June this year, <a href=\"https://logtivity.io/\">Logtivity</a> is a plugin and service that allows site owners to track everything that happens on their WordPress installs. The duo has made continual updates to the plugin since. In the past couple of months, they have added deep integration with Easy Digital Downloads. They are also planning to build around more eCommerce-related plugins.</p>\n\n\n\n<p>Burge mentioned that using the Logtivity service allows site owners to track and log activity at scale. While small sites could get by with an on-site solution, it can be harder to do while growing. &ldquo;This offers a strong alternative to using a plugin because you don&rsquo;t need to store huge amounts of data on your own server,&rdquo; he said.</p>\n\n\n\n<p>The service provides graphs so that end-users can visualize their data, but they can also dive directly into the logs and look at specific actions. Users can also set up unlimited alert notifications through email or Slack and download reports as CSV files.</p>\n\n\n\n<img />Site dashboard showing different chart types.\n\n\n\n<p>The <a href=\"https://wordpress.org/plugins/logtivity/\">Logitivity WordPress plugin</a> is free to download and install, but it merely serves as a bridge to the commercial service. The <a href=\"https://logtivity.io/pricing/\">pricing page</a> has three tiers that start at $9.50/month and run to $49.50. The rates primarily differ on the number of logs generated, user access, and length of data retention. However, each tier can be used on an unlimited number of sites.</p>\n\n\n\n<p>I have been running the service on WP Tavern for a couple of weeks. There are not many things I would want to track specific to this site other than posts published and commenting numbers. The short-term data has not told me much that I did not know already. However, I could see how these logs could come in handy over months or years. If we were running an eCommerce website, the information could be invaluable.</p>\n\n\n\n<img />Viewing a specific set of logs based on an action.\n\n\n\n<p>Users can create reports of specific logs and display them as either bar or line charts. These can be generated based on an action, such as &ldquo;Post Published&rdquo; or &ldquo;Comment Created.&rdquo; Users can also add a specific context, such as a post ID. For example, a user could display a chart for each product file download through the plugin&rsquo;s deep integration with Easy Digital Downloads.</p>\n\n\n\n<p>This is the type of thing that the team has in mind at the moment. The primary use case since launch has been logging eCommerce activity.</p>\n\n\n\n<p>&ldquo;People who run eCommerce sites need to track registrations, subscription changes, file downloads, license key activations, login activity, and more,&rdquo; said Burge. &ldquo;eCommerce site owners need this for customer support and also to deal with refund requests and chargebacks.&rdquo;</p>\n\n\n\n<p>Currently, each of the service&rsquo;s features is handled via the Logtivity site. The team has plans to bring them into the WordPress admin interface. However, it could be late 2021 or early 2022 before the integration happens.</p>\n\n\n\n<p>&ldquo;We&rsquo;d love to bring Logtivity data directly into WordPress,&rdquo; said Burge. &ldquo;And because there&rsquo;s no need to worry about Logtivity slowing down your site, we have some interesting ideas for how and where user activity can be displayed in the WordPress admin area.&rdquo;</p>\n\n\n\n<h2>How It Started and Where It Is Going</h2>\n\n\n\n<p class=\"has-drop-cap\">Burge serves as the marketing brains behind the project. His primary WordPress-related business is <a href=\"https://publishpress.com/\">PublishPress</a>, but his customers had asked for a project like Logitivity for several years.</p>\n\n\n\n<p>&ldquo;Ralph Morris started Logtivity for a customer at the web dev agency he works at,&rdquo; said Burge. &ldquo;The customer&rsquo;s site has around 100,000 users and gets a great deal of activity every day, from new registrations and subscriptions to resources being downloaded and cancellations. They were using a WordPress plugin to track customer activity, but as the number of logs grew, this process took longer and longer and became more clunky to perform. The final straw was when they were unable to perform the CSV exports, as it would keep timing out. Ralph scratched the itch and built a little MVP. After a few weeks, he showed it to his colleagues and got permission from his boss to offer it to the client to be the first user, and a little while later, the first paying customer.&rdquo;</p>\n\n\n\n<p>He said the two connected thanks to Iain Poulson, who recently <a href=\"https://wptavern.com/alex-denning-and-iain-poulson-launch-flipwp-an-acquisitions-marketplace-for-wordpress-companies\">co-launched the acquisitions marketplace FlipWP.</a></p>\n\n\n\n<p>&ldquo;Ralph lives really close to where I grew up in Hampshire, England,&rdquo; said Burge. &ldquo;We got our heads together and decided on a partnership: Ralph as the developer and myself as the marketer.&rdquo;</p>\n\n\n\n<p>Outside of integrating more directly with the WordPress admin, the Logtivity team has a roadmap that will keep them busy for a while. Topping that list are more integrations with third-party plugins.</p>\n\n\n\n<p>&ldquo;Our primary use-case is eCommerce sites, so WooCommerce is central to our plans,&rdquo; said Burge. &ldquo;But we also plan deeper integrations with more plugins that WordPress eCommerce sites use, including LearnDash, MemberPress, Paid Memberships Pro, and more.&rdquo;</p>\n\n\n\n<p>Several players in the space are moving toward broad integrations across the ecosystem. Chris Lema talked about it being a vital strategy for business growth with StellarWP&rsquo;s recent <a href=\"https://wptavern.com/stellarwp-acquires-learning-management-system-learndash\">acquisition of LearnDash</a>.</p>\n\n\n\n<p>Burge also noted that his team plans to continue improving the service&rsquo;s alert system. &ldquo;In future versions of Logtivity, you&rsquo;ll be able to send more flexible alerts to more channels. We also plan to provide SMS alerts for your most important notifications.&rdquo;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 01 Oct 2021 21:49:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Akismet: Version 4.2.1 of the Akismet WordPress Plugin is Now Available\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://blog.akismet.com/?p=2130\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://blog.akismet.com/2021/10/01/version-4-2-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:559:\"<p>Version 4.2.1 of <a href=\"http://wordpress.org/plugins/akismet/\">the Akismet plugin for WordPress</a> is now available.</p>\n<p>This update contains a fix for a bug in version 4.2 that could cause AMP validation errors on some sites, depending on the template they were using.</p>\n<p>To upgrade, visit the Updates page of your WordPress dashboard and follow the instructions. If you need to download the plugin zip file directly, links to all versions are available in <a href=\"http://wordpress.org/plugins/akismet/\">the WordPress plugins directory</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 01 Oct 2021 18:31:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Christopher Finke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: Gutenberg 11.6 Introduces New API for Locking Blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=123600\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:169:\"https://wptavern.com/gutenberg-11-6-introduces-new-api-for-locking-blocks?utm_source=rss&utm_medium=rss&utm_campaign=gutenberg-11-6-introduces-new-api-for-locking-blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3311:\"<p><a href=\"https://wptavern.com/gutenberg-11-6-improves-the-global-styles-ui-adds-child-theme-support\">Gutenberg 11.6</a> was released this week with a <a href=\"https://github.com/WordPress/gutenberg/pull/32457\">new API for managing lock control at the block-type level</a>. When defining a block, developers can now use the lock attribute to designate whether a block can be moved or removed. The PR introduces parts of the locking support mechanisms proposed by Matias Ventura in a separate <a href=\"https://github.com/WordPress/gutenberg/issues/29864\">issue</a> earlier this year.</p>\n\n\n\n<p>Ventura explained that while the editor already has template locking support to prevent inserting or moving blocks (i.e. for custom post type templates), it doesn&rsquo;t yet offer much granular control or a UI for the different locking states. He identified block themes as an important use case for establishing a new block-level API for representing&nbsp;<code>lock</code>&nbsp;status. Block themes may necessitate the ability to lock down key elements, such as preventing the removal of the post-content for a single post template. If you have ever played around with the template editor then you have likely discovered how easy it is to remove important elements by accident. </p>\n\n\n\n<div class=\"wp-block-image\"><img /><a href=\"https://github.com/WordPress/gutenberg/issues/29864\">Block locking UI mockup</a></div>\n\n\n\n<p>&ldquo;Another use case that we&rsquo;re building for is having a Checkout Block with different blocks that act as fundamental steps,&rdquo; WooCommerce and Gutenberg engineer Seghir Nadir said. &ldquo;We don&rsquo;t want people to delete or move those steps since they&rsquo;re fundamental and their order is also important, but we want to allow people to select them, access settings, and insert blocks in between them.&rdquo;</p>\n\n\n\n<p>During this week&rsquo;s <a href=\"https://make.wordpress.org/core/2021/09/30/editor-chat-summary-29th-september-2021/\">core editor chat</a>, Paal Joachim Romdahl highlighted the need for a locking mechanism for Reusable blocks.</p>\n\n\n\n<p>&ldquo;At the moment it is too easy to make an accidental change to a Reusable block,&rdquo; Romdahl said. &ldquo;I worry that only having the hover overlay and the initial click [to] select the parent Reusable block is just not good enough, that we soon should get a lock mechanism in place. There is a lot of feedback from users who have accidentally deleted the inner contents of the blocks and wondered what happened.&rdquo;</p>\n\n\n\n<p>Romdahl has created several <a href=\"https://github.com/WordPress/gutenberg/issues/32461\">issues</a> about to the possibility of <a href=\"https://github.com/WordPress/gutenberg/issues/31163\">adding a locking mechanism to the inline toolbar for reusable blocks</a>, where users would need to unlock to edit the contents.</p>\n\n\n\n<p>Now that the foundational infrastructure is in place for managing lock control at the block-type level, contributors can begin building a UI to control it, as outlined in the <a href=\"https://github.com/WordPress/gutenberg/issues/29864\">Locking and TemplateLocking</a> issue. Ventura said future iterations should include a UI that indicates which blocks are user-editable and also display block status in the list view and block inspector.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 01 Oct 2021 05:00:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"WPTavern: Gutenberg 11.6 Improves the Global Styles UI, Adds Child Theme Support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=123580\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:203:\"https://wptavern.com/gutenberg-11-6-improves-the-global-styles-ui-adds-child-theme-support?utm_source=rss&utm_medium=rss&utm_campaign=gutenberg-11-6-improves-the-global-styles-ui-adds-child-theme-support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6450:\"<p class=\"has-drop-cap\">Gutenberg 11.6 <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v11.6.0\">landed yesterday</a>. Contributors added dozens of enhancements and bug fixes. Admittedly, there was not a whole lot that excited me as a user about this release.</p>\n\n\n\n<p><a href=\"https://github.com/WordPress/gutenberg/pull/31623\">Typography options</a> for the Post Title block. <em>Nice.</em></p>\n\n\n\n<p><a href=\"https://github.com/WordPress/gutenberg/pull/31607\">Cropping</a> for the Site Logo. <em>A necessary addition.</em></p>\n\n\n\n<p>Toolbar button for <a href=\"https://github.com/WordPress/gutenberg/pull/34606\">converting old Gallery blocks</a> to the new &mdash; still experimental &mdash; format. <em>Sweet.</em></p>\n\n\n\n<p>For the most part, the release felt like a slew of routine enhancements that have been in the pipeline for those of us closely following the plugin&rsquo;s development. Almost boring. And that is not a bad thing at all. Less excitement and smaller doses of iterative improvements can be healthy for the project and its developers. We do not always need to feel like we are chasing the next big thing. This is a well-rounded release that polishes many areas, from navigation to widgets to general block enhancements.</p>\n\n\n\n<p>There were two features that I am happy to see movement on. That is the site editor&rsquo;s Global Styles system and child theme support.</p>\n\n\n\n<h2>Global Styles Updates</h2>\n\n\n\n<img />Default site editor look with Global Styles panel open.\n\n\n\n<p class=\"has-drop-cap\">Global Styles is the system that will truly connect end-users to theme developers and vice versa for the first time in WordPress history. We have made some attempts at this, such as the customizer. However, this feature will handle it on top of the standardized block system.</p>\n\n\n\n<p>Essentially, themes will <em>talk</em> to WordPress through their <code>theme.json</code> files, and users will speak the same language through the Global Styles panel.</p>\n\n\n\n<p>For example, imagine a theme author sets up the default text color as black and the background as white. This will appear on the front end of the site but also be reflected in the site editor. The Global Styles interface allows users to change those two colors to something they prefer.  They can also see of a <a href=\"https://github.com/WordPress/gutenberg/pull/34991\">preview of their color and typography styles</a> in the box at the top of the panel.</p>\n\n\n\n<img />Updating colors, preview shown in editor and at top of panel.\n\n\n\n<p>And, it does not stop at a couple of simple colors. Users can modify all sorts of design aspects like typography and spacing at the root and block levels.</p>\n\n\n\n<p>Gutenberg 11.6 adds a <a href=\"https://github.com/WordPress/gutenberg/pull/34885\">navigation component</a> to the Global Styles sidebar. Overall, it feels much smoother working through the top and sub-levels while editing my theme&rsquo;s styles.</p>\n\n\n\n<img />Updating the global padding for the Code block.\n\n\n\n<p>This is sort of a small but vital step toward <a href=\"https://github.com/WordPress/gutenberg/issues/34574\">overhauling the overall Global Styles interface</a>. There is still much work to be done, but I am eager to see where the Gutenberg contributors take this component in the coming weeks and months.</p>\n\n\n\n<p>I did run into one snag. Clicking on the Typography tab at the root level produces an error. However, it works at the block level.</p>\n\n\n\n<p>Contributors also updated the old &ldquo;Aa&rdquo; icon representing the Global Styles panel with a <a href=\"https://github.com/WordPress/gutenberg/pull/34871\">half-dark-half-light circle button</a>. My immediate reaction was that it was for switching between light and dark modes.</p>\n\n\n\n<p>This was a <a href=\"https://github.com/WordPress/gutenberg/issues/20873#issuecomment-923241684\">sentiment shared</a> by a user (from a now-deleted account) in the GitHub ticket.</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>Global Styles is not a new system disconnected from styles and themes, indeed is an improvement to the current themes system. If we were to consider the strength of WordPress&rsquo; past and present, we would perceive that on the dashboard, indeed a brush icon has been developed for years in people&rsquo;s memory as an association with appearance, themes, styles, personalization. Therefore, the icon that would be most comprehensible in people&rsquo;s memory regarding the new Customizer remains a brush. I say new and better Customizer, because this is how common people manifest what they understand about Global Styles. Departing from a pencil brush to yin-yang, moon, or water drop, I have not tested yet with public, but from past experience I assure you people are going to find this new icon unrelated and confusing.</p></blockquote>\n\n\n\n<h2>Block Child Theme Support</h2>\n\n\n\n<p class=\"has-drop-cap\">As one of the pioneers of child theming in WordPress, using them long before they were officially supported, this is something near and dear to my heart. I created my first theme shop on this foundation. I have loads of ideas about how the block paradigm can reshape the theme space, and child themes are at the center of many of them.</p>\n\n\n\n<p>However, all of the components of Full Site Editing have not entirely supported child themes until now. There are still a few pieces left to fit into the puzzle, but the system should work, mostly.</p>\n\n\n\n<p>Templates, template parts, and <code>theme.json</code> files from a child theme should now completely <a href=\"https://github.com/WordPress/gutenberg/pull/34354\">overrule those from the parent</a>. These changes work on both the front end and in the site editor.</p>\n\n\n\n<p>Some open questions are being worked through in a <a href=\"https://github.com/WordPress/gutenberg/issues/25612\">related GitHub ticket</a>. The most crucial development is still to come, which will handle merging values between the parent and child <code>theme.json</code> files. For example, it makes sense that child themes should be able to overwrite colors and typography while skipping definitions for layout-related values, falling back to the parent.</p>\n\n\n\n<p>Once that is in place, designers will have an easy-yet-powerful way to realize the original vision behind <a href=\"http://www.csszengarden.com/\">CSS Zen Garden</a>, a project that at least partially inspired child theming&rsquo;s adoption by WordPress.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 01 Oct 2021 01:45:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"Akismet: Version 4.2 of the Akismet WordPress Plugin is Now Available\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://blog.akismet.com/?p=2126\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://blog.akismet.com/2021/09/30/version-4-2-of-the-akismet-wordpress-plugin-is-now-available/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:735:\"<p>Version 4.2 of <a href=\"http://wordpress.org/plugins/akismet/\">the Akismet plugin for WordPress</a> is now available. It contains the following changes:</p>\n<ul>\n<li>Improved compatibility with the most popular contact form plugins, which should lead to improved accuracy.</li>\n<li>Added links to additional information on API usage notifications.</li>\n<li>Reduced the number of network requests required on a comment page when running Akismet.</li>\n</ul>\n<p>To upgrade, visit the Updates page of your WordPress dashboard and follow the instructions. If you need to download the plugin zip file directly, links to all versions are available in <a href=\"http://wordpress.org/plugins/akismet/\">the WordPress plugins directory</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Sep 2021 18:55:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Christopher Finke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:128:\"Gutenberg Times: Releases Galore in WordPress open-source projects, Business Case of Gutenberg and more — Weekend Edition #179\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=18564\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:133:\"https://gutenbergtimes.com/releases-galore-in-wordpress-open-source-projects-business-case-of-gutenberg-and-more-weekend-edition-179/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:15404:\"<p>Howdy, friend! </p>\n\n\n\n<p>Today&#8217;s weekend edition is a double-feature, so to speak. I&#8217;ll skip next week because of traveling overseas. First trip in 20 months. I am so excited and also busy to get ready. I will be back into your inbox on August 7th, 2021. </p>\n\n\n\n<p>This week was an exciting week for the WordPress open-source project and its many hundreds of contributors. One release after another! Just wow! Let&#8217;s dive right in. </p>\n\n\n\n<p>Stay well and keep safe! </p>\n\n\n\n<p>Yours, 💕<br />Birgit</p>\n\n\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<h2>WordPress open-source project Releases in July 2021</h2>\n\n\n\n<h3>WordPress 5.8</h3>\n\n\n\n<p>Five hundred thirty awesome contributors worked on <strong><a href=\"https://wordpress.org/news/2021/07/tatum/\">WordPress 5.8</a> </strong>and the release team let it loose on Tuesday as Tatum, after Art Tatum, a renown American jazz pianist. </p>\n\n\n\n<p>Need to catch up on all the features in this new version? </p>\n\n\n\n<ul><li><strong>Milana Cap</strong> assembled all the Developer Notes into the <a href=\"https://make.wordpress.org/core/2021/07/03/wordpress-5-8-field-guide/\">WordPress 5.8 Field Guide</a></li><li><a href=\"https://kinsta.com/blog/wordpress-5-8/\">Carlo Daniele published a comprehensive run down on Kinsta</a>, </li><li><a href=\"https://www.godaddy.com/garage/what-wordpress-5-8-means-for-your-clients-websites/\">Courtney Robertson on GoDaddy</a> wrote about what the release means for your clients&#8217; sites. </li></ul>\n\n\n\n<h3>BuddyPress 9.0</h3>\n\n\n\n<p>In time for the block-based widget editor, the <strong><a href=\"https://buddypress.org/2021/07/buddypress-9-0-0-mico/\">BuddyPress</a></strong> team released their block widgets in their 9.0 version this week.  The new BP Widget Blocks are Legacy Widgets, rebuilt as BP Blocks.  You can also access them in the Block Editor for use in your posts or pages!</p>\n\n\n\n<ul><li><a href=\"https://wptavern.com/buddypress-9-0-scheduled-for-short-development-cycle-to-ship-block-based-widgets-ahead-of-wordpress-5-8\">Sarah Gooding has the background on the planning of this update</a>. </li><li>Gooding also wrote <a href=\"https://wptavern.com/buddypress-9-0-0-transforms-legacy-widgets-into-blocks\">BuddyPress 9.0.0 Transforms Legacy Widgets Into Blocks</a></li></ul>\n\n\n\n<h3>WordPress Pattern Directory</h3>\n\n\n\n<p>The Meta Team has been collaborating with the Design team and designers in the community on the first version of the <strong><a href=\"https://wordpress.org/patterns/\">WordPress Pattern Directory</a></strong>.  They <a href=\"https://make.wordpress.org/meta/2021/07/20/the-wordpress-pattern-directory-is-live/\">released it officially</a> on Tuesday night. <a href=\"https://wptavern.com/the-wordpress-org-block-pattern-directory-now-live\">Justin Tadlock has the skinny</a>.</p>\n\n\n\n<p>I found a few to add to my favorites.  What are your favorite block patterns?  These initial 80+ patterns are also a great inspiration for theme builders who look to include themes styled patterns in their themes. </p>\n\n\n\n<p>If you are interested in creating block patterns from scratch, browse through <a href=\"https://gutenbergtimes.com/the-wordpress-block-patterns-resource-list/\">this list of resources around block patterns.</a></p>\n\n\n\n<h3>Gutenberg Plugin Version 11.1</h3>\n\n\n\n<p>The Gutenberg Team released another version of the <a href=\"https://make.wordpress.org/core/2021/07/21/whats-new-in-gutenberg-11-1-0-21-july/\"><strong>Gutenberg plugin, version 11.1.</strong></a> </p>\n\n\n\n<p>Grzegorz Ziolkowski and I discussed its many of the changes on <a href=\"https://gutenbergtimes.com/podcast/changelog-48-wordpress-pattern-directory-gutenberg-11-1/\">48th episode of the Gutenberg Changelog</a> </p>\n\n\n\n<p>Justin Tadlock wrote: <a href=\"https://wptavern.com/gutenberg-11-1-adds-drag-and-drop-support-for-list-view-and-upgrades-block-borders\">Gutenberg 11.1 Adds Drag-and-Drop Support for List View and Upgrades Block Borders</a></p>\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2021&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test and Meta team from Jan. 2021 on. Updated by yours truly.  <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\"><em>The index 2020 is here</em></a></p>\n\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<h2>Theme building for Full-Site Editing</h2>\n\n\n\n<p><a href=\"https://twitter.com/karmatosed\"><strong>Tammie Lister</strong></a> shares here theme design journey on the site Ephemeral Themes. This week, she posted <a href=\"https://ephemeralthemes.com/2021/07/19/tips-for-creating-in-the-site-editor/\">&#8220;Tips for creating a theme in the site editor&#8221;</a> and explained <a href=\"https://ephemeralthemes.com/2021/07/23/the-importance-of-testing-early-and-often/\">the importance of testing early and often</a>. Well worth your time! </p>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s main (trunk) branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n<p></p>\n\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>Kjell Reigstad</strong> has the <a href=\"https://make.wordpress.org/themes/2021/07/23/gutenberg-themes-week-of-july-19-2021/\">weekly round-up of issues, updates and discussions around <strong>Gutenberg and Themes</strong></a> for you. In this post Reigstad covered the most recent PR on FSE Blocks, General theme building and Global Styles. The list of overview issues is a great start if you need to catch up on the overall concepts and ideas. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>Carolina Nymark</strong>, team rep on the Theme Review Team, ask for your comments on the newly proposed <a href=\"https://make.wordpress.org/themes/2021/07/20/discussion-request-for-feedback-on-requirement-changes/\"><strong>Theme requirements for inclusion into the Theme directory on WordPress.org</strong></a>. You can also read them in more details on <a href=\"https://github.com/WPTT/Theme-Requirements/issues/12\">GitHub issue #12 </a>on the Theme Requirements repository of the Theme Review team. </p>\n\n\n\n<p>Deadline for the first round of comments is July 26th, 2021. </p>\n\n\n\n<p>On July 28th, 2pm CET. The team will conduct a Zoom interview with theme authors about the requirements. Spots are already full. Hopefully, the interviews will be recorded to educate more than a few theme developers about the requirements. </p>\n\n\n\n<p><strong>Justin Tadlock </strong>provides background and more context as to the initiative via his post <strong><a href=\"https://wptavern.com/next-phase-of-the-wordpress-theme-review-overhaul-open-meeting-and-call-for-feedback\">Next Phase of the WordPress Theme Review Overhaul</a>. </strong></p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>Rich Tabor</strong> published <a href=\"https://richtabor.com/gutenberg-block-templates/\"><strong>The Ultimate Guide to WordPress Block Templates in Gutenberg</strong></a> and provides a comprehensive tutorial on how block-based theme template fit into WordPress template hierarchy and how they help WordPress users controls their site. Tabor also provided details instructions on how to build block-based templates and leverage them in your theme. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>In his post <a href=\"https://themeshaper.com/2021/07/12/universal-themes-customization/\"><strong>Universal Themes: Customization</strong></a> on ThemeShaper, <strong><a href=\"https://twitter.com/scruffian\">Ben Dwyer</a></strong> explored about how to make Global Styles and the Customizer work together. Dwyer looks at how to use classic WordPress tools (in this case the Customizer) to customize a block theme, while saving these changes in Global Styles – making a universal theme!</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<h2>Developing Blocks and Plugins for the block editor</h2>\n\n\n\n<p>Last month, <strong><a href=\"https://twitter.com/dmtrmrv\">Dmitry Mayorov</a></strong>, Senior Front-End Engineer at 10up, published <a href=\"https://css-tricks.com/a-crash-course-in-wordpress-block-filters/\"><strong>a crash-course in WordPress Block Filters</strong></a>. Mayorov shows you how to extend core blocks with filters. He also helps you with the decision between extending a core or build a custom block instead. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><a href=\"https://twitter.com/laroymike\"><strong>Michael LaRoy</strong></a> wrote a <a href=\"https://mikelaroy.ca/blog/wordpress-blocks-advanced-custom-fields\"><strong>tutorial on creating blocks with Advanced Custom Fields.</strong></a> He wrote: &#8220;By providing a PHP solution to block creation, a developer already familiar with ACF can efficiently create new custom blocks without writing any JavaScript.&#8221;</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/BillErickson\">Bill Erickson</a></strong> has a tutorial on <a href=\"https://www.billerickson.net/innerblocks-with-acf-blocks/\"><strong>how to use Inner Blocks with ACF Blocks</strong></a>, to expand on the usefulness of the plugin for more complex layouts. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><a href=\"https://twitter.com/AlexStandiford\"><strong>Alex Standiford</strong></a> explained in his post <a href=\"https://www.wpdev.academy/concepts/how-gutenberg-blocks-work/\"><strong>&#8220;How Gutenberg Blocks Work</strong></a> the basic concepts of how the block-editor stores content, why HTML comments and how is it rendered. </p>\n\n\n\n<h2>Business Case for Gutenberg</h2>\n\n\n\n<p><strong><a href=\"https://twitter.com/ArturGrabo\">Artur Grabowski</a></strong>, co-founder of <strong>Extendify</strong>, a Gutenberg first product start-up, was <strong>Joe Howard</strong>&#8216;s guest on episode 153 of WPMRR Podcast: <a href=\"https://wpmrr.com/podcast/artur-grabowski-extendify/\"><strong>Going Big by Solving WordPress’ Biggest Roadblock</strong></a>.  Grabowski, like many other business development people in the WordPress space, regards the missing new user onboarding experience as the biggest roadblock for even bigger growth of the WordPress ecosystem. Howard and Grabowski had an honest and nuanced conversation about the business case for Gutenberg First approach to WordPress products. </p>\n\n\n\n<p>Grabowski took a historic view to the ongoing debate about Gutenberg being the right path for WordPress. Back in 2016, while working with Adobe and its product Spark, Grabowski became aware of many innovative web building tools. They were all block-based. It is only a fairly new concept for WordPress. “There is a lot less unknown here about the end state than some people realize.” If you are interested in the WordPress product space, I recommend you follow the link and dive into the details of things. </p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>The future is here. It’s just not evenly distributed.</p><cite>Artur Grabowski</cite></blockquote>\n\n\n\n<p>Incidentally, <strong>Cory Miller</strong>, Post Status partner and <strong>Jeff Meziere</strong> talked to <strong><a href=\"https://twitter.com/chrislubkert\">Chris Lubkert</a></strong>, also co-founder of Extendify, on their Webinar for the Business Value Academy. <a href=\"https://businessvalueacademy.com/webinar-mergers-acquisitions-with-chris-lubkert/\"><strong>Webinar: Mergers &amp; Acquisitions with Chris Lubkert</strong></a></p>\n\n\n\n<p><em>Before co-founding Extendify, Chris Lubkert and Artur Grabowski worked in the Merger &amp; Aquisitions department of Automattic. <strong><a href=\"https://twitter.com/karmatosed\">Tammie Lister</a></strong> also joined Extendify as their head of design.</em> <em><a href=\"https://twitter.com/extendifyinc\"><strong>Extendify</strong></a> is the new home for a series of block-editor plugins and tools:  <a href=\"https://wordpress.org/plugins/editorplus/\">Editor Plus</a>, <a href=\"https://wordpress.org/plugins/redux-framework/\">Redux Framework</a>, <a href=\"https://wordpress.org/plugins/block-options/\">Editors Kit</a>, <a href=\"https://gutenberghub.com/\">Gutenberg Hub</a>, <a href=\"https://wordpress.org/plugins/forms-gutenberg/\">Gutenberg Forms</a>, <a href=\"https://wordpress.org/plugins/acf-blocks/\">ACF Blocks</a>, and <a href=\"https://wordpress.org/plugins/block-slider/\">Block Slider</a> to name a few. </em></p>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/podcast/changelog-48-wordpress-pattern-directory-gutenberg-11-1/\">Episode #48 is now available</a> with transcript. <br />Next recording August 6th, 2021 </strong></p>\n\n\n\n<p> <strong>Subscribe to the&nbsp;<a href=\"https://gutenbergtimes.com/podcast/\">Gutenberg Changelog</a>&nbsp;podcast </strong><br />🎙️&nbsp;<a href=\"https://open.spotify.com/show/620NwVKQJGdTupy36zYxvg?mc_cid=4b6c9f88fe\">Spotify</a>&nbsp;|&nbsp;<a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9ndXRlbmJlcmd0aW1lcy5jb20vZmVlZC9wb2RjYXN0\">Google</a>&nbsp;|&nbsp;<a href=\"https://podcasts.apple.com/us/podcast/gutenberg-changelog/id1469294475\">iTunes</a>&nbsp;|&nbsp;<a href=\"https://pca.st/podcast/f8445ec0-7508-0137-f267-1d245fc5f9cf\">PocketCasts</a>&nbsp;|&nbsp;<a href=\"https://www.stitcher.com/show/gutenberg-changelog\">Stitcher</a>&nbsp;|<br />🎙️&nbsp;<a href=\"https://www.podbean.com/podcast-detail/chi7j-9904a/Gutenberg-Changelog-Podcast\">Pod Bean</a>&nbsp;|&nbsp;<a href=\"https://castbox.fm/channel/Gutenberg-Changelog-id2173375\">CastBox</a>&nbsp;|&nbsp;<a href=\"https://www.podchaser.com/podcasts/gutenberg-changelog-878239/\">Podchaser</a>&nbsp;|&nbsp;<a href=\"https://gutenbergtimes.com/feed/podcast\">RSS Feed</a>&nbsp;</p>\n\n\n\n<img />\n\n\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p class=\"has-text-align-center\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\">Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Sep 2021 18:15:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"Gutenberg Times: List of WordPress Themes for Full-Site Editing and Resources\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=18502\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://gutenbergtimes.com/list-of-wordpress-themes-for-full-site-editing-and-resources/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8014:\"<p>A few people ask about WordPress Themes that are already working with the Full-Site Editing system and the new Site Editor. Here is a List as of July 2021.  </p>\n\n\n\n<p>The Themes are all built while Full-Site Editing is under active development and many features are experimental. Do not use in production or live site. Expect the themes to be wonky at times, until developers have a chance to update the themes for new Gutenberg plugin version. In short: There will be Dragons! 🐉</p>\n\n\n\n<p>Oh, yes. You also need to <a href=\"https://wordPress.org/plugins/gutenberg\">install the Gutenberg plugin</a>. </p>\n\n\n\n<p>For the lastest updates pre-release, use the <a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Gutenberg Nightly</a></p>\n\n\n\n<h2>Themes for Full-Site Editing in the WordPress repository</h2>\n\n\n\n<p>I only used TT1 Blocks Theme for FSE-Testing. I rely mostly on Justin Tadlock  or others to provide more insights on the various themes. The articles are linked with the theme header. </p>\n\n\n\n<h3><strong><a href=\"https://wordpress.org/themes/armando/\">Armando</a>&nbsp;by Carolyn Newmark</strong></h3>\n\n\n\n<p><a href=\"https://wptavern.com/armando-wordpress-theme-provides-insight-into-the-current-state-of-full-site-editing\">Armando WordPress Theme Provides Insight Into the Current State of Full Site Editing</a></p>\n\n\n\n<h3><a href=\"https://wordpress.org/themes/blockbase/\">Block Base</a>&nbsp;by Automattic</h3>\n\n\n\n<p><a href=\"https://themeshaper.com/2021/06/07/using-blockbase-for-a-theme-experiment/\">Using Blockbase for a theme&nbsp;experiment</a> (ThemeShaper) by Kjell Reigstad</p>\n\n\n\n<p><a href=\"https://wptavern.com/the-automattic-theme-team-announces-blockbase-its-new-block-parent-theme\">The Automattic Theme Team Announces Blockbase, Its New Block Parent Theme</a> (WordPress Tavern) by Justin Tadlock</p>\n\n\n\n<p><a href=\"https://themeshaper.com/2021/05/27/blockbase-a-parent-theme-for-block-themes/\">Blockbase: A parent theme for block&nbsp;themes</a> (ThemeShaper) by Ben Dwyer</p>\n\n\n\n<h4>Child themes of Block Base </h4>\n\n\n\n<p><a href=\"https://wordpress.org/themes/mayland-blocks/\">Mayland Blocks</a> by Automattic </p>\n\n\n\n<p><a href=\"https://wordpress.org/themes/seedlet-blocks/\">Seedlet Blocks</a> by Automattic</p>\n\n\n\n<p><a href=\"https://wptavern.com/automattic-launches-mayland-blocks-its-second-fse-theme-on-wordpress-org\">Automattic Launches Mayland Blocks, Its Second FSE Theme on WordPress.org</a></p>\n\n\n\n<h3><a href=\"https://wordpress.org/themes/block-based-bosco/\">Block-Based Bosco</a>&nbsp;by Fränk Klein</h3>\n\n\n\n<p><a href=\"https://wpdevelopment.courses/articles/full-site-editing-theme-learnings/\">What I Learned Building a Full-Site Editing Theme</a></p>\n\n\n\n<p><a href=\"https://wpdevelopment.courses/articles/global-styles-in-block-based-bosco/\">Implementing Global Styles in Block-Based Bosco</a></p>\n\n\n\n<p><a href=\"https://wptavern.com/block-based-bosco-second-full-site-editing-theme-lands-in-the-wordpress-directory\">Block-Based Bosco, Second Full-Site Editing Theme Lands in the WordPress Directory</a></p>\n\n\n\n<h3><a href=\"https://wordpress.org/themes/clove/\">Clove </a>by Anariel Design</h3>\n\n\n\n<p><a href=\"https://wptavern.com/clove-a-showcase-of-block-patterns-by-anariel-design\">Clove: A Showcase of Block Patterns by Anariel Design</a> (WPTavern)</p>\n\n\n\n<h3><a href=\"https://wordpress.org/themes/hansen/\">Hansen</a>&nbsp;by Uxl Themes</h3>\n\n\n\n<p><a href=\"https://wptavern.com/build-a-full-wordpress-site-via-block-patterns-with-the-hansen-theme\">Build a Full WordPress Site via Block Patterns With the Hansen Theme</a></p>\n\n\n\n<h3><a href=\"https://wordpress.org/themes/naledi/\">Naledi&nbsp;</a>by Anariel Design</h3>\n\n\n\n<p><a href=\"https://wptavern.com/anariel-design-launches-naledi-a-block-based-wordpress-theme\">Anariel Design Launches Naledi, a Block-Based WordPress Theme</a> (WordPress Tavern)</p>\n\n\n\n<h3><a href=\"https://wordpress.org/themes/q/\">Q&nbsp;</a>by Ari Stathopoulos</h3>\n\n\n\n<p><a href=\"https://wptavern.com/exploring-full-site-editing-with-the-q-wordpress-theme\">Exploring Full-Site Editing With the Q WordPress Theme</a></p>\n\n\n\n<h3><a href=\"https://wordpress.org/themes/rick/\">Rick</a> by WPEntire </h3>\n\n\n\n<h3><a href=\"https://wordpress.org/themes/tt1-blocks/\">TT1 Blocks</a>&nbsp;by WordPress contributors</h3>\n\n\n\n<p>This is the FSE sibling of the Twenty-Twenty-One Theme</p>\n\n\n\n<p><em>If you find any theme missing in this list, <a href=\"mailto:pauli@gutenbergtimes.com\">let me know.</a></em></p>\n\n\n\n<h2>WordPress Themes team resources</h2>\n\n\n\n<p>The themes team <a href=\"https://github.com/WordPress/theme-experiments\">share their experiments on GitHub</a>. Some listed themes made it as stand-alone theme into the repository listed above. </p>\n\n\n\n<p>Contributors also included a script to <strong>generate a theme</strong> with the minimum necessary to build your own block theme: <code>php new-empty-theme.php</code>.</p>\n\n\n\n<p>Every other week, the <strong>themes team meets discussion Block-based themes</strong>: 2nd and 4th Tuesday at 15:00 UTC (11am EDT) wp-slack channel #themereview</p>\n\n\n\n<p>Every week, the <a href=\"https://make.wordpress.org/themes/tags/gutenberg-themes-roundup/\">Themes team published a <strong>roundup post </strong></a>about newly merged changes, and what is discussed on the GitHub repo for Gutenberg. The post also has a few overview issues so you can always catch up on what is in the works. <em>Follow the #gutenberg-themes-roundup tag on the make-blog/themes</em></p>\n\n\n\n<p><strong>Anne McCarthy</strong>, developer relations and program manage for the FSE outreach published a post on ThemeShaper with more <a href=\"https://themeshaper.com/2021/07/13/resources-for-block-theme-development/\">Resources for block theme&nbsp;development</a></p>\n\n\n\n<h2>DevNotes for WordPress 5.8 </h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/core/2021/06/25/introducing-theme-json-in-wordpress-5-8/\">Introducing theme.json in WordPress 5.8</a></li><li><a href=\"https://make.wordpress.org/core/2021/06/29/on-layout-and-content-width-in-wordpress-5-8/\">On layout and content width in WordPress 5.8</a></li><li><a href=\"https://make.wordpress.org/core/2021/06/16/introducing-the-template-editor-in-wordpress-5-8/\">Introducing the template editor in WordPress 5.8</a></li><li><a href=\"https://make.wordpress.org/core/2021/07/01/block-styles-loading-enhancements-in-wordpress-5-8/\">Block-styles loading enhancements in WordPress 5.8</a></li><li><a href=\"https://make.wordpress.org/core/2021/06/29/blocks-in-an-iframed-template-editor/\">Blocks in an iframed (template) editor</a></li><li><a href=\"https://make.wordpress.org/core/2021/06/21/bundled-themes-changes-in-wordpress-5-8/\">Bundled themes changes in WordPress 5.8</a></li></ul>\n\n\n\n<h2>Developer Documentation </h2>\n\n\n\n<ul><li><a href=\"https://developer.wordpress.org/block-editor/how-to-guides/themes/block-theme-overview/\">Block Theme Overview</a></li><li><a href=\"https://developer.wordpress.org/block-editor/how-to-guides/themes/create-block-theme/\">Create a Block Theme</a></li><li><a href=\"https://developer.wordpress.org/block-editor/how-to-guides/themes/theme-json/\">Global Settings (theme.json)</a></li><li><a href=\"https://developer.wordpress.org/block-editor/how-to-guides/themes/theme-support/\">Theme Support</a></li></ul>\n\n\n\n<h2>Courses and Tutorials</h2>\n\n\n\n<ul><li>Caroline Nymark: <a href=\"https://fullsiteediting.com/courses/full-site-editing-for-theme-developers/\">Full-site editing For Developers</a></li><li>Fränk Klein: <a href=\"https://wpdevelopment.courses/courses/building-block-based-themes/\">Building Block-Based Themes</a></li><li>Tammie Lister: <a href=\"https://ephemeralthemes.com/2021/07/17/creating-a-theme/\">Creating a Theme</a></li><li>Rich Tabor: <a href=\"https://richtabor.com/gutenberg-block-templates/\">The Ultimate Guide to WordPress Block Templates in Gutenberg</a></li></ul>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>U<em>pdated 7/21 to add Rich Tabor&#8217;s article on Block Templates </em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Sep 2021 18:15:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"Gutenberg Times: Theme creation, Block plugin development and the Future of WordPress – Weekend Edition #178\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=18531\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"https://gutenbergtimes.com/theme-creation-block-plugin-development-and-the-future-of-wordpress-weekend-edition-17/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:12172:\"<p>Howdy, my friends! </p>\n\n\n\n\n\n<p>WordPress 5.8 will be release next week. Are you ready? Well, if you didn&#8217;t get any chance to test things, you should still be alright. If you know your customers will be fiddling with their site&#8217;s widget section, do yourself a favor and <a href=\"https://wordpress.org/plugins/classic-widgets/\">install the Classic Widget plugin</a>, so there are no surprises. </p>\n\n\n\n<p>For last-minute testing, use the <a href=\"https://make.wordpress.org/core/2021/07/15/wordpress-5-8-release-candidate-4/\">Release Candidate number 4</a>. The final release is scheduled for Tuesday, July 20, 2021. The <a href=\"https://make.wordpress.org/core/2021/07/03/wordpress-5-8-field-guide/\">Field Guide </a>covers all changes. </p>\n\n\n\n<p>Wishing you all the best for the upgrade! Holler if you need any help! </p>\n\n\n\n<p>Yours, 💕<br />Birgit</p>\n\n\n\n<h2>Gutenberg and the Future of WordPress</h2>\n\n\n\n<p>In this week&#8217;s Jukebox episode, host <strong>Nathan Wrigley</strong> discussed with <strong>Robert Jacobi</strong> the Future of WordPress in the era of Gutenberg. <strong><a href=\"https://wptavern.com/podcast/5-robert-jacobi-on-why-hes-putting-gutenberg-first\">Jacobi explained why he is persuing a Gutenberg first approach.</a> </strong>You can listen on WordPress Tavern or your favorite podcast app. </p>\n\n\n\n<p><em>From the section “Neither Gutenberg nor WordPress News&#8221;: I am excited about the <a href=\"https://www.theverge.com/2021/7/16/22580023/automattic-pocket-casts-podcast-app-tumble-wordpress\">acquisition of Pocket Casts by Automattic</a>. I tested many other podcast apps, but Pocket Casts has been my favorite for many, many years.</em>  </p>\n\n\n\n<p><strong>Nathan da Silva</strong>, founder of Silva Web Designs, wrote about <a href=\"https://silvawebdesigns.com/the-future-of-wordpress-page-builders/\">the Future of Page Builders</a> and concludes, there are still pieces missing before Gutenberg makes 3rd Party page builders obsolete. Da Silva mentions, Full-Site Editing is not there yet and there are not as many add-on available as Elementor or Beaver Builder provide for their site builders workflow. </p>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/podcast/changelog-47-developing-block-plugins-wordpress-5-8/\">Episode #47 is now available</a> with transcript. <br />Next recording July 23, 2021 </strong></p>\n\n\n\n<p> <strong>Subscribe to the&nbsp;<a href=\"https://gutenbergtimes.com/podcast/\">Gutenberg Changelog</a>&nbsp;podcast </strong><br />🎙️&nbsp;<a href=\"https://open.spotify.com/show/620NwVKQJGdTupy36zYxvg?mc_cid=4b6c9f88fe\">Spotify</a>&nbsp;|&nbsp;<a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9ndXRlbmJlcmd0aW1lcy5jb20vZmVlZC9wb2RjYXN0\">Google</a>&nbsp;|&nbsp;<a href=\"https://podcasts.apple.com/us/podcast/gutenberg-changelog/id1469294475\">iTunes</a>&nbsp;|&nbsp;<a href=\"https://pca.st/podcast/f8445ec0-7508-0137-f267-1d245fc5f9cf\">PocketCasts</a>&nbsp;|&nbsp;<a href=\"https://www.stitcher.com/show/gutenberg-changelog\">Stitcher</a>&nbsp;|<br />🎙️&nbsp;<a href=\"https://www.podbean.com/podcast-detail/chi7j-9904a/Gutenberg-Changelog-Podcast\">Pod Bean</a>&nbsp;|&nbsp;<a href=\"https://castbox.fm/channel/Gutenberg-Changelog-id2173375\">CastBox</a>&nbsp;|&nbsp;<a href=\"https://www.podchaser.com/podcasts/gutenberg-changelog-878239/\">Podchaser</a>&nbsp;|&nbsp;<a href=\"https://gutenbergtimes.com/feed/podcast\">RSS Feed</a>&nbsp;</p>\n\n\n\n<img />\n\n\n\n\n<h2>Block-editor for Content Creators</h2>\n\n\n\n<p>On July 29th, 10 a.m. PT / 1 p.m. ET / 5 p.m. UTC. <strong>WordPress VIP</strong> will hold  a webinar with the title <a href=\"https://wpvip.com/resource/gutenberg-full-site-editing-webinar/\"><strong>Gutenberg Full-Site Editing: Unlocking Agility for Enterprise WordPress</strong></a>. James Proctor will share lessons from the cutting edge of implementation. “By taking Gutenberg blocks beyond the post editor, these new features allow content creators unprecedented agility and control over the entire site experience.&nbsp;“ Any site owner and agency will be able to take advantage of the knowledge shared at scale.</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/redcrew\">Deborah Edwards-Onoro</a></strong> posted a great tutorial on how to <a href=\"https://www.lireo.com/quick-tip-manage-your-wordpress-block-editor-preferences/\">Manage your Block Editor preferences</a> and increase productivity and comfort. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>WordPress 5.8 brings Duotone Filters to images of the block editor. <strong>Justin Tadlock </strong>takes you on a tour of this fabulous new feature: <a href=\"https://wptavern.com/duotone-filters-wordpress-5-8-puts-a-powerful-image-editing-tool-into-users-hands\">Duotone Filters: WordPress 5.8 Puts a Powerful Image-Editing Tool Into Users’ Hands</a>&#8216;.</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<h2>Developing Plugins for the Block Editor</h2>\n\n\n\n<p>After the <a href=\"https://richtabor.com/gutenberg-block-plugins/\">Primer</a> last week, <strong><a href=\"https://twitter.com/richard_tabor\">Rich Tabor</a></strong> posted <strong><a href=\"https://richtabor.com/build-publish-gutenberg-block-plugins/\">How to Build &amp; Publish Gutenberg Block Plugins to the WordPress Block Directory.</a></strong> Tabor guides you through the process from <code>create block</code> scaffolding and running the block plugin checker to uploading your block to WordPress repository and get it approved for the Block Directory. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/mkaz\">Marcus Kazmierczak</a></strong> wrote a series of posts on how to <a href=\"https://mkaz.blog/wordpress/conditionally-load-block-assets/\"><strong>Conditionally Load Block Assets</strong></a> when building block plugins. There are quite a few different ways to skin that proverbial cat. <a href=\"https://mkaz.blog/wordpress/conditionally-load-block-assets-part-3/\">Start at the latest post</a>, explaining the new WordPress 5.8 way to handle this. Kazmierczak also provides a video walk through. </p>\n\n\n\n<p>This helped me to understand the feature <strong>Ari Stathopoulos</strong> worked on and described in his Dev Note: <a href=\"https://make.wordpress.org/core/2021/07/01/block-styles-loading-enhancements-in-wordpress-5-8/\">Block-styles loading enhancements in WordPress 5.8</a></p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/riadbenguella\">Riad Benguella</a></strong> has a few more<strong> <a href=\"https://make.wordpress.org/core/2021/07/12/miscellaneous-block-editor-api-additions-in-wordpress-5-8/\">Miscellaneous block editor API additions in WordPress 5.8</a> &#8211; it covers: </strong></p>\n\n\n\n<ul><li>Contextual patterns for easier creation and block transformations</li><li>Pattern Registration API</li><li>BlockControls group prop</li></ul>\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2021&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test and Meta team from Jan. 2021 on. Updated by yours truly.  <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\"><em>The index 2020 is here</em></a></p>\n\n\n\n\n<h2>Gutenberg and Themes</h2>\n\n\n\n<p><strong><a href=\"https://twitter.com/jcristpbking\">Jason Crist</a> </strong>published this week&#8217;s <a href=\"https://make.wordpress.org/themes/2021/07/16/gutenberg-themes-week-of-july-16-2021/\"><strong>Gutenberg + Themes</strong></a> roundup. Two issues caught my eye:  </p>\n\n\n\n<ul><li>Should it be possible to <a href=\"https://github.com/WordPress/gutenberg/issues/33367\">overwrite properties via PHP </a>or should the properties in the theme.json come after PHP properties are set. What do you think?</li><li><a href=\"https://github.com/WordPress/gutenberg/issues/32939\">Is there a case for dynamic template parts?</a> Discuss! </li></ul>\n\n\n\n<p>There is of course, much more going on. Another great round-up post from the Theme Team! </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>Anne McCarthy</strong> shared <a href=\"https://themeshaper.com/2021/07/13/resources-for-block-theme-development/\"><strong>Resources for block theme&nbsp;development</strong></a> on ThemeShaper. She wrote: &#8220;Whether you’re just starting out or already deep in the block theme world, the following resources should help you be aware of what’s to come and how to get involved in shaping the future.&#8221;</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/karmatosed\">Tammie Lister</a></strong> published here process on <a href=\"https://ephemeralthemes.com/2021/07/17/creating-a-theme/\"><strong>how to create a theme</strong></a> and what she encountered. She wrote: &#8220;I am still like many discovering how I create themes using site editing, but I wanted to share my current process and some observations I’ve made along the way.&nbsp;&#8220;</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><a href=\"https://twitter.com/nickmdiego\"><strong>Nick Diego</strong> </a>collected three small fixes to his theme to  change the breakpoint for the column block to become responsive, how to change the order of the mobile columns and how to disable responsive columns completely. For the latter, Diego uses a solution by Andy Serong, that is already merged to Gutenberg and will be released with the plugin version 11.2 on July 21st, 2021. Details in <a href=\"https://nickdiego.com/disable-responsive-columns-in-gutenberg-and-other-tips/\"><strong>Disable Responsive Columns in Gutenberg and Other Tips</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/rob_stino\">Rob Stinson</a></strong> posted about <strong><a href=\"https://studiopress.blog/wordpress-5-8-widgets-changes-and-how-they-impact-the-genesis-framework/\">WordPress 5.8 Widgets Changes and How they Impact the Genesis Framework</a>.</strong> He wrote: &#8220;To help navigate this for the 100,000’s of sites that run on the Genesis Framework we have implemented an&nbsp;<em>opt-in</em>&nbsp;experience in version 3.3.4 for whenever anyone updates to WordPress 5.8.&#8221;</p>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s main (trunk) branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n<p></p>\n\n\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p class=\"has-text-align-center\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\">Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Sep 2021 18:15:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"Gutenberg Times: Block Building, Query Loop block and more – Weekend Edition #177\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=18471\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://gutenbergtimes.com/block-building-query-loop-block-and-more-weekend-edition-177/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:15136:\"<p>Howdy, </p>\n\n\n\n<p>For a few days, we enjoyed non-humid weather in Florida as Hurricane Elsa sucked all the moisture out of the air and took it with it. Sorry, Northern friends. </p>\n\n\n\n<p>For some fun summer reading, I can highly recommend the <a href=\"https://make.wordpress.org/core/5-8/\"><strong>WordPress 5.8 </strong></a>DevNotes, all handily assembled into a <a href=\"https://make.wordpress.org/core/2021/07/03/wordpress-5-8-field-guide/\"><strong>massive Field Guide</strong></a> by Milana Cap. </p>\n\n\n\n<p>After the publishing rush around the WordPress 5.8 release last week, this week is certainly a lot calmer. Although I know that behind the scenes, contributors are working hard on getting Block Editor End-User documentation ready, too. 🐝</p>\n\n\n\n<p>Hopefully, you have been busy testing plugins and themes for compatibility with the new widget block-editor. July 20th is only 10 days away. <a href=\"https://wordpress.org/news/2021/07/wordpress-5-8-release-candidate-2/\"><strong>WordPress 5.8 RC 2</strong></a> is out and could use your eagle eyes to spot last-minute bugs and quirks. </p>\n\n\n\n<p>What else has happened in the WordPress Gutenberg space last week? I have a few more links for you. As always, you don&#8217;t have to consume them all in one sitting, you can always come back during the week. </p>\n\n\n\n<p>Wishing you a wonderful weekend and start into your next week!</p>\n\n\n\n<p>Yours, 💕<br />Birgit</p>\n\n\n\n<h2>Gutenberg Development</h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2021/07/09/whats-new-in-gutenberg-11-0-0-9-july/\"><strong>Gutenberg 11.0 was released</strong></a> and <strong><a href=\"https://twitter.com/get_dave\">Dave Smith</a></strong> compiled the release notes for the team. This time in the release cycle of the next WordPress release, it&#8217;s all about bug fixing. <strong>Justin Tadlock</strong> highlights a few enhancements <strong><a href=\"https://wptavern.com/gutenberg-11-0-includes-over-70-bug-fixes-continues-improving-with-wordpress-5-8-just-two-weeks-away\">in his post</a></strong>. <strong>Grzegorz Ziolkowski </strong>and I recorded the <a href=\"https://gutenbergtimes.com/podcast/changelog-47-developing-block-plugins-wordpress-5-8/\">47th episode of the Gutenberg Changelog </a>on Friday. Listen in and get a few more ideas of what&#8217;s in this Gutenberg 11.0  release. the audio should be available over the weekend. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>Matias Ventura</strong> <a href=\"https://github.com/WordPress/gutenberg/issues/33094\"><strong>updated scope for site editing projects</strong></a> to help the team and the community to track upcoming tasks around the main site editing projects. There are a few separate tracking issues for covering some general improvements and then some broader projects. It covers some general UI features that need to be iterated on, mentioned a Browse mode for the site editor, and lists Infrastructure, Patterns, Styling and the Navigation Block. </p>\n\n\n\n<h2>Gutenberg and Themes</h2>\n\n\n\n<p><strong><a href=\"https://twitter.com/carolinapoena\">Carolina Nymark</a></strong> summarized <a href=\"https://make.wordpress.org/themes/2021/07/08/summary-theme-features-in-wordpress-5-8/\"><strong>all the Theme </strong></a><strong><a href=\"https://make.wordpress.org/themes/2021/07/08/summary-theme-features-in-wordpress-5-8/\">features</a> </strong>that will come to a WordPress instance near you with WordPress 5.8. It&#8217;s the Cliff Notes with actionable code snippets for opt-in and opt-out decisions. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>Daisy Olson</strong> posted a summary and the recording of this week&#8217;s <strong><a href=\"https://make.wordpress.org/test/2021/07/09/hallway-hangout-discussion-on-theme-json-7-july/\">Hallway Hangout Discussion the Theme.json</a>. </strong></p>\n\n\n\n<p>The <a href=\"https://make.wordpress.org/test/2021/06/24/call-for-testing-thrive-with-theme-json/\"><strong>Theme.json Call for testing </strong></a>is still open until July 14, 2021. It has instructions for beginners, Intermediate and advanced WordPress theme developers.  It&#8217;s a fabulous way to learn and share your feedback.</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>Maggie Cabrera</strong> created an <a href=\"https://make.wordpress.org/themes/2021/07/09/gutenberg-themes-week-of-july-9-2021/\"><strong>outstanding weekly round-up (#56)</strong></a> post with theme related recently merged PRs, what is discussed and again a great list of overview git hub issues that are waiting for your comments and ideas! </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>A couple of weeks ago, we had <strong><a href=\"https://gutenbergtimes.com/theme-json-for-wordpress-theme-authors-demo-and-live-q-a-w-daisy-olson-tammie-lister-and-jeff-ong/\">Daisy Olsen, Tammie Lister and Jeff Ong on a Live Q &amp; A.</a></strong> First we have a short introduction demo on how to work with theme.json and a discussion on how this new way to organize the settings and styles for your theme change how themes work in WordPress. We also answered interesting questions from the audience. If you haven&#8217;t seen it yet, <a href=\"https://gutenbergtimes.com/theme-json-for-wordpress-theme-authors-demo-and-live-q-a-w-daisy-olson-tammie-lister-and-jeff-ong/\">you can watch it here with transcript and resources. </a></p>\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2021&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test and Meta team from Jan. 2021 on. Updated by yours truly.  <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\"><em>The index 2020 is here</em></a></p>\n\n\n\n\n<h2>Block Editor for Content creators</h2>\n\n\n\n<p><strong>This is a first in the almost three-year history of the Block editor!</strong> 🙌 🎉<br />Thanks to the indefatigable <strong>Anne McCarthy</strong>, content creators can review End-user documentation for the new features <strong>before </strong>they are released. </p>\n\n\n\n<ul><li><a href=\"https://wordpress.org/support/article/list-view/\">How to use the List View</a> (former Block Navigator)</li><li><a href=\"https://wordpress.org/support/article/query-loop-block/\">The Query Loop Block </a></li><li><a href=\"https://wordpress.org/support/article/block-based-widgets-editor/\">Block-Based Widget Editor</a></li><li><a href=\"https://wordpress.org/support/article/template-editor/\">Template Editor</a> </li></ul>\n\n\n\n<p>Now it&#8217;s all still a work in progress and there is still time until July 20th.</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>Anne McCarthy</strong>&#8216;s <strong><a href=\"https://wordpress.tv/2021/07/07/anne-mccarthy-block-based-widget-editor-demo/\">Block-based Widget Editor&nbsp;Demo</a></strong> is now available on WordPress TV. Check it out to seen what&#8217;s coming to WordPress 5.8. <br /><em>Yep, as Grzegorz Ziolkowski said yesterday, Anne McCarthy is everywhere! </em></p>\n\n\n\n<h3>Query Loop Block</h3>\n\n\n\n<p>Even if you are not familiar with the developer term Query Loop, once you look at the examples you&#8217;ll instantly realize that this is about the layout of a list of posts you might want to include on your pages, templates or posts. You can change the layout for post title, featured image, excerpt and link.  An early version of this was the Latest Post Block. </p>\n\n\n\n<p>The design team also implemented a series of Block Patterns of a few nice variations to display a post list on templates, post and pages. It&#8217;s a fun feature, and it has taken quite a long time to build. The wait was definitely worth it. </p>\n\n\n\n<p>It is mighty and could be the most powerful feature in 5.8 as <strong>Justin Tadlock</strong> headlined his post <a href=\"https://wptavern.com/query-loop-the-ins-and-outs-of-one-of-wordpress-5-8s-most-powerful-features\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>Query Loop: The Ins and Outs</strong></a>.</p>\n\n\n\n<p><strong>Allison Rivers</strong> over the Torque Magazine also published an article <a href=\"https://torquemag.io/2021/07/what-is-wordpress-5-8s-query-loop-block/\"><strong>What is the Query Loop Block?</strong></a> with lots of great insights and examples. Rivers also has a list of plugins that implemented some advanced features the WordPress version is still missing with its first iteration. </p>\n\n\n\n<h2>Block Building and Plugins</h2>\n\n\n\n<p>Reading throught the release notes for Gutenberg 11, I found great gem posted by <strong>Riad Benguella</strong>. It&#8217;s a flow graphic that<a href=\"https://github.com/WordPress/gutenberg/pull/32921\"> <strong>explains the relationship between the packages that make the post editor</strong></a>. </p>\n\n\n\n<img /><a href=\"https://github.com/WordPress/gutenberg/pull/32921\">Partial view of Riad Benguella&#8217;s schema</a>\n\n\n\n<p>I find this very helpful to keep in mind when to use which package at which stage or the user interactions. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/richard_tabor\">Rich Tabor</a></strong>, Senior Product Manager, WordPress Experience GoDaddy published <a href=\"https://richtabor.com/gutenberg-block-plugins/\">A Primer on Gutenberg Block Plugins for the WordPress Block Directory</a> in which  he walks you through the process of submit your plugin to the WordPress Directory, as he went through when submitting his <a href=\"https://wordpress.org/plugins/markdown-comment-block/\">Markdown Comment block</a> to the repository. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>In the same space, <strong><a href=\"https://twitter.com/ellatrx\">Ella van Durpe</a></strong> published a plugin for private note-taking in WordPress called <strong><a href=\"https://wordpress.org/plugins/hypernotes/\">Hypernotes</a>.</strong> Justin Tadlock <a href=\"https://wptavern.com/private-note-taking-and-journaling-with-the-hypernotes-wordpress-plugin\">reviewed it</a> for the WordPress Tavern. Van Durpe explain  <a href=\"https://wptavern.com/private-note-taking-and-journaling-with-the-hypernotes-wordpress-plugin#comment-386210\">her comment </a>to the article&#8217;s, that the plugin uses some  <a href=\"https://github.com/WordPress/gutenberg/pull/33102\">experimental PWA capabilities</a> she introduced to the Gutenberg plugin for WP-Admin. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><a href=\"https://twitter.com/AlexStandiford\"><strong>Alex Standiford</strong>,</a> developer&nbsp;at <a href=\"https://sandhillsdev.com/\">Sandhills Development </a>(makers of the EDD plugin) published a tutorial about <a href=\"https://www.wpdev.academy/concepts/api-fetch-the-wordpress-library-you-didnt-know-you-needed/?utm_source=Online+Course+Notification&utm_campaign=fb2a5a9d83-RSS_EMAIL_CAMPAIGN&utm_medium=email&utm_term=0_8cc90959c2-fb2a5a9d83-477961602\"><strong>API Fetch – The WordPress Library You Didn’t Know You Needed</strong></a> with code snippets and plenty of theory to with them, too. </p>\n\n\n\n<p>Standiford also started the <strong>WPAcademy</strong> with the course <a href=\"https://www.wpdev.academy/course/beer-lister-plugin/\"><strong>WordPress Plugin Development Course</strong></a>, with 37 videos teaching you how to make a beer custom post type, customize the Gutenberg editor, create a new block, and create WP-CLI commands to make testing fast and easy.</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>Justin Tadlock</strong> shared his experience in <a href=\"https://wptavern.com/taking-the-leap-building-my-first-wordpress-block-plugin\"><strong>Taking the Leap: Building My First WordPress Block Plugin</strong></a>. He built a breadcrumbs block as a dynamic block that&#8217;s rendered server side. </p>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s main (trunk) branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n<p></p>\n\n\n\n\n<h2>Upcoming WordPress Events</h2>\n\n\n\n<p><strong>July 17 + 18th, 2021</strong><br /><strong><a href=\"https://santaclarita.wordcamp.org/2021/\">WordCamp Santa Clarita</a></strong></p>\n\n\n\n<ul><li>1pm PT / 4pm ET / 20 UTC &#8211; FSE: <strong>What’s Coming to 5.8 &amp; the Story of the Outreach Program</strong> w/ Anne McCarthy</li><li>2pm PT / 5pm ET / 21 UTC &#8211; <strong>How Theme Developers Should Approach Full Site Editing</strong> w/ Joe Casabona</li><li>3pm PT / 6pm ET / 22 UTC &#8211; <strong>Rapid Landing Page Creation With the WordPress Block Editor</strong> w/ Daisy Olsen</li></ul>\n\n\n\n<p><strong>July 23, 2021</strong><br /><a href=\"https://www.wordfest.live/\"><strong>WordFest Live </strong></a>&#8211; <em>The&nbsp;</em>festival of WordPress</p>\n\n\n\n<ul><li>July 22 &#8211;  10 PM EDT / 2 UTC  &#8211; <strong>Learn to Build Blocks with Advanced Custom Fields</strong> w/ Cameron Jones</li><li>July 23 &#8211; 3:20 pm EDT / 19:20 UTC <strong>How to Create a Fast Loading Stylish Homepage with Blocks &amp; CSS</strong> w/  Davinder Singh Kainth</li></ul>\n\n\n\n<p>A<strong>ugust 6 + 7, 2021</strong><br /><a href=\"https://nicaragua.wordcamp.org/2021/\"><strong>WordCamp Nicaragua</strong></a></p>\n\n\n\n<p><strong>September 21 + 22, 2021</strong><br /><a href=\"https://2021.wpcampus.org/\"><strong>WPCampus 2021 Online</strong></a><br />&#8220;A free online conference for web accessibility and WordPress in higher education.&#8221;</p>\n\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p class=\"has-text-align-center\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\">Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Sep 2021 18:15:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"Gutenberg Times: Block-Based Widget Screen and DevNotes Galore for WordPress 5.8 – Weekend Edition #176\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=18404\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://gutenbergtimes.com/block-based-widget-screen-weekend-edition-176/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:19897:\"<p>Howdy, </p>\n\n\n\n<p>July is the month celebrating North American Independence (for white people) and the start of the French Revolution. </p>\n\n\n\n<p>Happy 154th Birthday, Canada 🇨🇦  (July 1st). <br />Happy 245th Birthday, USA 🇺🇸 (July 4th) <br />Happy 232nd Bastille Day, France 🇫🇷  (July 14th) </p>\n\n\n\n<p>There are many more countries celebrating Independence Day in July, though. <a href=\"https://www.infoplease.com/culture-entertainment/holidays/national-holidays-around-world\">Here is the list. Take a look! </a> 🌐</p>\n\n\n\n<p><strong>July 20th</strong>, WordPress 5.8 will be released and there are a ton of block editor related dev notes for themes and plugin developers. <a href=\"https://wordpress.org/news/2021/06/wordpress-5-8-release-candidate/\">Use this week&#8217;s RC 1 version </a>to test your sites, plugins and themes! </p>\n\n\n\n<p>Be well! Have a great weekend, wherever you are located! </p>\n\n\n\n<p>Yours, 💕<br />Birgit</p>\n\n\n\n\n\n<p></p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<h2>WordPress 5.8 Dev Notes for Block editor features</h2>\n\n\n\n<p class=\"has-drop-cap\">This week was also the deadline to published Developer Notes around the upcoming WordPress 5.8 release. </p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2021/07/01/block-styles-loading-enhancements-in-wordpress-5-8/\"><strong>Block-styles loading enhancements</strong> </a> by <strong><a href=\"https://twitter.com/aristath\">Ari Stathopoulos</a></strong> &#8211; Ari has the details on how the two new features &#8211; <em>Load styles only for rendered blocks</em>  and  <em>Inline small styles</em> &#8211; work and how theme developers and block builders can tap into it. </p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2021/06/29/blocks-in-an-iframed-template-editor/\"><strong>Blocks in an iframed (template) editor</strong></a> by <strong><a href=\"https://twitter.com/ellatrx\">Ella van Durpe</a></strong> &#8211; The new Template editor is the first block editor loaded in an iframe and isolate it from the rest of the admin screen. Ella has the benefits for you as well as the details on how to adjust your blocks if you rely on <code>document</code> or <code>window</code> and provides code fixes for your ReactJS blocks. There is more. Definitely worth a read if you are deep in plugin development. Ella&#8217;s post compliments Grzegorz Ziolkowski&#8217;s post: <a href=\"https://make.wordpress.org/core/2021/06/16/block-editor-api-changes-to-support-multiple-admin-screens-in-wp-5-8/\"><strong>Block Editor API Changes to Support Multiple Admin Screens</strong></a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2021/06/29/on-layout-and-content-width-in-wordpress-5-8/\"><strong>On layout and content width</strong></a> by <strong><a href=\"https://twitter.com/riadbenguella\">Riad Benguella</a></strong> &#8211; This is a shorter post, introducing the Settings for layout and content width and how you can adjust your theme to take advantage of them. </p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2021/06/29/block-based-widgets-editor-in-wordpress-5-8/\"><strong>Block-based Widgets Editor</strong></a> by <strong><a href=\"https://twitter.com/noisysocks\">Robert Anderson</a></strong>. He wrote: &#8220;WordPress 5.8 introduces a new&nbsp;block-based widgets editor to the Widgets screen (<code>Appearance → Widgets</code>) and&nbsp;Customizer&nbsp;(<code>Appearance → Customize → Widgets</code>).&#8221; and continues to explain the <strong>three methods</strong> (including the <a href=\"https://wordpress.org/plugins/classic-widgets/\">Classic Widget plugin</a>)  of opting out. You might find interesting to learn how the Legacy Widget block helps with the backward compatibility for existing widgets and widget areas.  </p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2021/06/29/block-editor-api-removals-58/\"><strong>Various Block Editor API removals</strong></a> by <strong><a href=\"https://twitter.com/riadbenguella\">Riad Benguella</a></strong> has the details  on the removal of <code>EditorGlobalKeyboardShortcuts</code>, <code>hasUploadPermissions</code> and their alternatives. Also, the block &#8220;Subheading&#8221; has been removed, too. </p>\n\n\n\n<p><strong><a href=\"https://twitter.com/TimothyBJacobs\">Timothy Jacobs</a>&#8216;</strong> post lists all the <a href=\"https://make.wordpress.org/core/2021/06/29/rest-api-changes-in-wordpress-5-8/\"><strong>REST API Changes</strong></a> necessary for the Widget Block Editor. He also shows how to adjust Legacy widgets, so they are seen and handled by it. Timothy illustrates the changes with extensive code snippets, that should help you get up to speed fast. </p>\n\n\n\n<p>And if that isn&#8217;t enough already, <strong>Milana Cap</strong> lists <a href=\"https://make.wordpress.org/core/2021/06/28/miscellaneous-developer-focused-changes-in-wordpress-5-8/\"><strong>Miscellaneous developer focused changes</strong></a> in her dev note. The team removed support for IE 11 from build and test tools and gives you more control and consistency for the document title. WordPress 5.8 also brings a consistent type for integer properties of WP_Post, WP_Term, WP_User and a bookmark object and better caching of post/page IDs for subsequent request. There are quite a few more goodies in this upcoming release. Take a look! </p>\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2021&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test and Meta team from Jan. 2021 on. Updated by yours truly.  <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\"><em>The index 2020 is here</em></a></p>\n\n\n\n\n<h2>User-facing changes in WordPress 5.8</h2>\n\n\n\n<p><a href=\"https://twitter.com/TimothyBJacobs\"><strong>Timothy Jacobs</strong></a> gave a detailed preview of <strong><a href=\"https://www.youtube.com/watch?v=uQgQ4ZeOE0g&t=31s\">What&#8217;s coming to the Block editor in WordPress 5.8</a></strong> to the members of the WordPress NYC meetup. You can see a demo of Duotone for image &amp; cover, Single Column color and spacing settings, Table block updates, and reusable block changes. He spent a few more minutes on the new Widget Screen as well as the Post Template Editor and the new Query Block. </p>\n\n\n\n<p><a href=\"https://twitter.com/courtneyengle\"><strong>Courtney Robertson</strong></a> wrote in <a href=\"https://www.godaddy.com/garage/what-wordpress-5-8-means-for-your-clients-websites/\"><strong>What WordPress 5.8 means for your clients&#8217; websites</strong></a> &#8220;This release expands the role of the block editor to include nearly every area of WordPress. You’ll want to check out all the updates to discover what WordPress 5.8, Full Site Editing, and Block-Based Themes mean for your clients’ websites.&#8221;. The post is a fabulous comprehensive list of what is new in WordPress 5.8 with short videos and the relevant details. </p>\n\n\n\n<h2>Block-Based Widget in WP Admin and Customizer</h2>\n\n\n\n<p class=\"has-drop-cap\">You can also watch <strong>Anne McCarthy</strong> <a href=\"https://www.youtube.com/watch?v=x4P5P_L9og4\"><strong>Exploring the Block Widgets Editor</strong></a> in WP Admin and Customizer&nbsp;on YouTube. She wrote in the description: &#8220;This video seeks to give an initial look at this feature and answer some top questions people might have. Shout out to <a href=\"https://twitter.com/critterverse\"><strong>Channing Ritter</strong> </a> who put together the demo portion!&#8221;.</p>\n\n\n\n<p><strong><a href=\"https://twitter.com/karks88\">Eric Karkovack</a></strong> also did a deep dive into the block-based Widget Screen for you: <a href=\"https://speckyboy.com/wordpress-widgets-screen/\"><strong>The WordPress Widgets Screen Joins the Gutenberg Era</strong></a> and provides you with a great tutorial on how to use the new screens with screenshot and all. </p>\n\n\n\n<p><a href=\"https://wptavern.com/diving-into-wordpress-5-8s-new-widgets-screen\"><strong>Diving Into WordPress 5.8’s New Widgets Screen</strong></a> by <strong><a href=\"https://twitter.com/justintadlock\">Justin Tadlock</a></strong>. He is a fan of the new feature and glad it made it into the WordPress core for this upcoming release. While the WPAdmin Widget screen feels like a good block editor, he wrote about the block widgets in the Customizer: &#8220;Customizer support for block widgets is light years ahead of where it was just a few short months ago. However, it feels awkward at best. There is a deep feeling of not belonging. While it was a remarkable programming feat to make the two features work together, the user experiences are nearly a decade apart.&#8221;  </p>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s main (trunk) branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n<p></p>\n\n\n\n\n<h2>Plugins for the Block Editor</h2>\n\n\n\n<p>This week, I found quite a few people sharing their experiences with block editor plugins. </p>\n\n\n\n<p><strong><a href=\"https://twitter.com/chrislema\">Chris Lema</a> </strong>compared in his post <a href=\"https://chrislema.com/content-visibility-for-gutenberg/\"><strong>Content Visibility for Gutenberg</strong></a> three plugins that allow you to control the visibility of single blocks on your page or posts. We mentioned two of them here multiple times. Chris tested the pro version for his purposes:</p>\n\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/changelog-46-devnotes-for-wordpress-5-8/\"><strong>Episode #4</strong>6 is now available</a> with transcript. <br />Next recording July 9th, 2021</p>\n\n\n\n<p>Send questions, comments or news to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<p> <strong>Subscribe to the&nbsp;<a href=\"https://gutenbergtimes.com/podcast/\">Gutenberg Changelog</a>&nbsp;podcast </strong><br />🎙️&nbsp;<a href=\"https://open.spotify.com/show/620NwVKQJGdTupy36zYxvg?mc_cid=4b6c9f88fe\">Spotify</a>&nbsp;|&nbsp;<a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9ndXRlbmJlcmd0aW1lcy5jb20vZmVlZC9wb2RjYXN0\">Google</a>&nbsp;|&nbsp;<a href=\"https://podcasts.apple.com/us/podcast/gutenberg-changelog/id1469294475\">iTunes</a>&nbsp;|&nbsp;<a href=\"https://pca.st/podcast/f8445ec0-7508-0137-f267-1d245fc5f9cf\">PocketCasts</a>&nbsp;|&nbsp;<a href=\"https://www.stitcher.com/show/gutenberg-changelog\">Stitcher</a>&nbsp;|<br />🎙️&nbsp;<a href=\"https://www.podbean.com/podcast-detail/chi7j-9904a/Gutenberg-Changelog-Podcast\">Pod Bean</a>&nbsp;|&nbsp;<a href=\"https://castbox.fm/channel/Gutenberg-Changelog-id2173375\">CastBox</a>&nbsp;|&nbsp;<a href=\"https://www.podchaser.com/podcasts/gutenberg-changelog-878239/\">Podchaser</a>&nbsp;|&nbsp;<a href=\"https://gutenbergtimes.com/feed/podcast\">RSS Feed</a>&nbsp;</p>\n\n\n\n<img />\n\n\n\n\n<ul><li><a href=\"https://www.blockvisibilitywp.com/pro/\">Block Visibility</a> by Nick Diego</li><li><a href=\"https://conditionalblocks.com/\">Conditional Blocks Pro</a> by Morgan Hvidt</li><li><a href=\"https://wordpress.org/plugins/content-visibility/\">Content Visibility</a> by Rich Tape</li></ul>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>Rich Tabor</strong> released <a href=\"https://wordpress.org/plugins/markdown-comment-block/\"><strong>Markdown Comment Block</strong></a> in the WordPress plugin repository. He wrote in his description: &#8220;Having the ability to add, and keep, any relevant editing comments within my posts, without rendering them on the front-end, means that I am freed up to mentally jot any idea down without thinking about it. It is simply natural and convenient.&#8221;  <strong>Justin Tadlock</strong> gave it a review in <a href=\"https://wptavern.com/add-editor-only-notes-via-the-markdown-comment-block-wordpress-plugin\">Add Editor-Only Notes via the Markdown Comment Block WordPress Plugin</a></p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>Thanks to <a href=\"https://twitter.com/remkusdevries\"><strong>Remkus De Vries&#8217;</strong></a> new newsletter &#8220;<a href=\"https://remkus.devries.frl/subscribe/\">Remkus Ramblings</a>&#8220;, I learned about two more plugins for the block editor: </p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/highlight-and-share/\"><strong>Highlight and Share</strong> </a>by <strong>Ronald Huereca</strong> &#8211; &#8220;It&#8217;s a social sharing plugin that allows you to highlight text and and share among several social networks including Twitter, Facebook, LinkedIn and more,&#8221; Remkus said. I wished I had this plugin when I ran a social media marketing agency&#8230;. </p>\n\n\n\n<p>The second one is <a href=\"https://wordpress.org/plugins/block-editor-colors/\"><strong>Block Editor Colors</strong></a> by MotoPress &#8211; Remkus wrote: &#8220;(&#8230;)which allows you to edit default Gutenberg block editor colors or the ones registered in a theme, as well as add your colors!&#8221;</p>\n\n\n\n<p><em><a href=\"https://remkus.devries.frl/about/\">Remkus de Vries</a>, Head of Partner &amp; Customer Relationship at <a href=\"https://twitter.com/servebolt\">ServeBolt</a>, started his newsletter last month, and he uses  &#8211; you probably guessed it &#8211; my favorite newsletter plugin: <a href=\"https://newsletterglue.com/\">Newsletter Glue</a>. 👋 Waving at Lesley Sim </em></p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p class=\"has-drop-cap\">I got quite excited when I learned about Automattic&#8217;s <a href=\"https://wordpress.org/plugins/sketch/\">Sketch plugin</a>,  a plugin that allows its users to sketch within the editor and show it immediately on the front end. Based on <a href=\"https://www.npmjs.com/package/perfect-freehand\">perfect-hand </a>library, it is the product of a collaboration between  Matias Ventura, Pablo Honey and Oscar Lopez. It&#8217;s one of Automattic&#8217;s <a href=\"https://github.com/Automattic/block-experiments/tree/master/blocks\">Block Experiments</a>.</p>\n\n\n\n<ul><li><a href=\"https://twitter.com/pootlepress\"><strong>Jamie Marsland</strong></a> of PootlePress <a href=\"https://www.pootlepress.com/2021/07/the-sketch-block-for-gutenberg/\">created a video</a> to share some thoughts on how you can use it creatively on your site and he also has a few suggestions for version 2 of the Sketch block. </li><li><a href=\"https://wptavern.com/automattic-releases-sketch-block-for-drawing-in-the-wordpress-editor\"><strong>Justin Tadlock</strong>,</a> also took it out for a spin and <a href=\"https://wptavern.com/automattic-releases-sketch-block-for-drawing-in-the-wordpress-editor\">shared his experience</a> on the WordPress Tavern. </li></ul>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<h2>Building Blocks</h2>\n\n\n\n<p><a href=\"https://twitter.com/binarymoon/\"><strong>Ben Gillbanks</strong></a> shows you  <a href=\"https://www.binarymoon.co.uk/2021/06/how-to-get-a-list-of-all-wordpress-blocks-in-the-editor/\"><strong>how to get a list of all blocks in the editor</strong></a> of a post or page. He wrote: &#8220;It’s particularly handy for WordPress plugin developers, but will also be useful when setting properties in&nbsp;<code>theme.json</code>&nbsp;a new feature that is part of the upcoming Full Site Editing functionality of WordPress.&#8221;</p>\n\n\n\n<p><a href=\"https://twitter.com/fabiankaegy\"><strong>Fabian Kägy</strong></a>&#8216;s WordCamp Europe presentation <a href=\"https://wordpress.tv/2021/06/28/fabian-kagy-building-great-experiences-in-the-new-editor/\"><strong>Building great experiences in the new&nbsp;editor</strong></a> is now available on WordPress TV. He wrote in his session description &#8220;Starting out building blocks or experiences for the WordPress block editor can be a bit daunting. Where do I start? Custom blocks, block patterns or just styling core blocks. In this talk, I will walk through the different options and share the benefits and downsides of each while talking about overall good practices for building great editorial experiences.&#8221;</p>\n\n\n\n<p><em>If you are looking for other talks, you might have missed, 23 <a href=\"https://wordpress.tv/event/wordcamp-europe-2021/\">WordCamp Europe 2021 talks</a> are now available on WordPress TV </em></p>\n\n\n\n<h2>Upcoming WordPress Event</h2>\n\n\n\n<p><strong>July 7th, 2021 -1pm EDT / 17:00 UTC</strong><br /><strong><a href=\"https://make.wordpress.org/test/2021/06/24/call-for-testing-thrive-with-theme-json/\">Hallway Hangout: FSE Testing call #8 theme.json</a></strong> with Daisy Olson</p>\n\n\n\n<p><strong>July 17 + 18th, 2021</strong><br /><strong><a href=\"https://santaclarita.wordcamp.org/2021/\">WordCamp Santa Clarita</a></strong></p>\n\n\n\n<ul><li>1pm PT / 4pm ET / 20 UTC &#8211; FSE: <strong>What’s Coming to 5.8 &amp; the Story of the Outreach Program</strong> w/ Anne McCarthy</li><li>2pm PT / 5pm ET / 21 UTC &#8211; <strong>How Theme Developers Should Approach Full Site Editing</strong> w/ Joe Casabona</li><li>3pm PT / 6pm ET / 22 UTC &#8211; <strong>Rapid Landing Page Creation With the WordPress Block Editor</strong> w/ Daisy Olsen</li></ul>\n\n\n\n<p><strong>July 23, 2021</strong><br /><a href=\"https://www.wordfest.live/\"><strong>WordFest Live </strong></a>&#8211; <em>The&nbsp;</em>festival of WordPress</p>\n\n\n\n<ul><li>July 22 &#8211;  10 PM EDT / 2 UTC  &#8211; <strong>Learn to Build Blocks with Advanced Custom Fields</strong> w/ Cameron Jones</li><li>July 23 &#8211; 3:20 pm EDT / 19:20 UTC <strong>How to Create a Fast Loading Stylish Homepage with Blocks &amp; CSS</strong> w/  Davinder Singh Kainth</li></ul>\n\n\n\n<p>A<strong>ugust 6 + 7, 2021</strong><br /><a href=\"https://nicaragua.wordcamp.org/2021/\"><strong>WordCamp Nicaragua</strong></a></p>\n\n\n\n<p><strong>September 21 + 22, 2021</strong><br /><a href=\"https://2021.wpcampus.org/\"><strong>WPCampus 2021 Online</strong></a><br />&#8220;A free online conference for web accessibility and WordPress in higher education.&#8221;</p>\n\n\n\n<hr class=\"wp-block-separator is-style-left-aligned\" />\n\n\n\n<p id=\"block-8c56f083-3d78-42e0-84ec-62ea90a2afa5\">On the<a href=\"https://wpcalendar.io/online/\"> <strong>Calendar for WordPress Online Events</strong> </a>you can browse a list of the upcoming WordPress Meetups, around the world, including WooCommerce, Elementor, Divi Builder and Beaver Builder meetups.</p>\n\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p class=\"has-text-align-center\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\">Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Sep 2021 18:15:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"Gutenberg Times: Theme.json Resources, Block Patterns and WordPress 5.8 – Weekend Edition #175\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=18320\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://gutenbergtimes.com/theme-json-resources-block-patterns-and-wordpress-5-8-weekend-edition-175/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:13004:\"<p>Howdy, </p>\n\n\n\n<p>We enjoy cooling off at the community pool after our lunch walks. It&#8217;s the simple things, right? </p>\n\n\n\n<p>I learned so much in this week&#8217;s Live Q &amp; A! You might too. Jeff prepared a insightful demo of the basics. Thank you to all those watching and asking great questions! It was a pleasure and honor to have Daisy Olson, Tammie Lister and Jeff Ong on the show. <a href=\"https://gutenbergtimes.com/theme-json-for-wordpress-theme-authors-demo-and-live-q-a-w-daisy-olson-tammie-lister-and-jeff-ong/\">The recording is available here.</a> So are the links to the shared resources and the transcript. </p>\n\n\n\n<p>What else happened this week in WordPress? Amazingly plenty. Get yourself your favorite beverage and start reading and watching. </p>\n\n\n\n\n\n<p>Yours, 💕<br />Birgit</p>\n\n\n\n\n\n<h2>Release week at WordPress</h2>\n\n\n\n<p>WordPress is such a fantastic open-source project. I admire the team and the people in it so much! </p>\n\n\n\n<p>The <a href=\"https://wordpress.slack.com/archives/C01VACX5E2W\">public Slack channel of the release squad</a> helped me understand more of the complexities behind making software that is used by many millions of people all over the world. If you ever get a chance to spend a few minutes scrolling through the discussions on slack, on trac or GitHub, do it. Meet the people, who bring the work of hundreds of contributors over the finish line. Meet the contributors. </p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/5-8/\">WordPress 5.8 Beta 4</a> is out and ready for your testing. WordPress 5.8 RC 1 is scheduled for June 29th, 2021. That comes with a hard string freeze, and the Polyglot teams get into high gear with translations. It&#8217;s also the deadline for DevNotes of the more significant changes coming  with this release. </p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2021/06/24/whats-new-in-gutenberg-10-9-23-june/\">Gutenberg 10.9 and 10.9.1</a> were released. Some bug fixes will be ported back to be included in the WordPress 5.8. Grzegorz Ziolkowski and I recorded the Gutenberg Changelog #46 yesterday, and it will be published on Monday. Our editor, Sandy, is on a well-deserved break over the weekend.  <a href=\"https://wptavern.com/gutenberg-10-9-renames-the-query-block-adds-collapsible-list-view-items-and-rolls-out-rich-url-previews\"><strong>Justin Tadlock </strong>took 10.9 </a>for a spin at the WPTavern. </p>\n\n\n\n<p>&#8212; <a href=\"https://gutenbergtimes.com/podcast/changelog-46-devnotes-for-wordpress-5-8/\">Gutenberg Changelog #46 is now available</a> &#8212; 6/27</p>\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2021&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test and Meta team from Jan. 2021 on. Updated by yours truly.  <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">The index 2020 is here</a></p>\n\n\n\n\n<h2>Theme.json Resources</h2>\n\n\n\n<p>You can read an&nbsp;<a href=\"https://make.wordpress.org/core/2021/06/25/introducing-theme-json-in-wordpress-5-8/\"><strong>Introducing theme.json in WordPress 5.8</strong></a>&nbsp;by&nbsp;<strong><a href=\"https://twitter.com/nosolosw\">Andre Maneiro</a></strong>&nbsp;on the Core Make blog.</p>\n\n\n\n<p>You can read up on the details specifications in the Block Editor Handbook:&nbsp;<strong><a href=\"https://developer.wordpress.org/block-editor/how-to-guides/themes/theme-json/\">Global Settings &amp; Styles (theme.json)</a>.</strong></p>\n\n\n\n<p>Another fantastic way to get your feet wet is to heed the&nbsp;<a href=\"https://make.wordpress.org/test/2021/06/24/call-for-testing-thrive-with-theme-json/\"><strong>Call for Testing #8</strong></a>&nbsp;out of the FSE outreach program. <strong>Anne McCarthy</strong> has some interesting tasks for you. <a href=\"https://wptavern.com/fse-outreach-round-8-a-developer-centric-call-for-testing-theme-json-configuration\"><strong>Justin Tadlock </strong></a> has more for you on the <em>WordPress Tavern</em> </p>\n\n\n\n<p><strong>Tammie Lister</strong>&nbsp;started a new project <a href=\"https://ephemeralthemes.com/\">&#8220;Ephemeral Themes&#8221;</a> and shared her thoughts on theme.json and why she is excited again for theme development.&nbsp;<a href=\"https://ephemeralthemes.com/2021/06/20/theme-json-inspires/\"><strong>Theme.json inspires</strong></a></p>\n\n\n\n<p>The Gutenberg team is in ongoing discussion about various topics. Two were raised during the <a href=\"https://gutenbergtimes.com/theme-json-for-wordpress-theme-authors-demo-and-live-q-a-w-daisy-olson-tammie-lister-and-jeff-ong/\">Live Q &amp; A</a>. Both could use your opinion and ideas.</p>\n\n\n\n<ul><li><a href=\"https://github.com/WordPress/gutenberg/issues/29568\">Default Colors, Theme Colors, and Custom Colors</a></li><li><a href=\"https://github.com/WordPress/gutenberg/issues/20244\">Responsive Global Styles as a work in progress</a></li></ul>\n\n\n\n<p>A good way to get started and see the configuration in action is to study the themes available in the&nbsp;<a href=\"https://github.com/WordPress/theme-experiments/\"><strong>Theme Experiments repository</strong></a>&nbsp;on GitHub.</p>\n\n\n\n<h2>Full Site Editing </h2>\n\n\n\n<p>Another theme by <strong>Ana Segota,</strong>  built for the Site editor will come to the WordPress directory. Justin Tadlock took it for a spin. <a href=\"https://wptavern.com/clove-a-showcase-of-block-patterns-by-anariel-design\"><strong>Clove: A Showcase of Block Patterns by Anariel Design</strong></a>.</p>\n\n\n\n<p><strong>Anne McCarthy </strong>published <a href=\"https://make.wordpress.org/test/2021/06/24/fse-program-polished-portfolios-summary/\"><strong>FSE Program Polished Portfolios Summary</strong></a> with the updated feedback from a great group of participants. </p>\n\n\n\n<p>On her personal blog, <strong>Anne McCarthy</strong> also published <a href=\"https://nomad.blog/2021/06/11/on-future-outreach-program-models-in-the-wordpress-community/\"><strong>On Future Outreach Program Models in the WordPress Community</strong></a>. She shared some of her learn lessons on running the FSE outreach program and what needs to happen to make this a permanent contributor activity within WordPress. </p>\n\n\n\n<p>Here is the <a href=\"https://make.wordpress.org/test/2021/06/09/upcoming-fse-outreach-program-schedule-june-july/\">Upcoming FSE Outreach Program Schedule</a></p>\n\n\n\n<p><a href=\"https://twitter.com/scruffian\"><strong>Ben Dwyer</strong> </a>on ThemeShaper posted <strong><a href=\"https://themeshaper.com/2021/06/23/universal-themes-some-ideas/\">Some Ideas for Universal Themes</a>.</strong> He wrote: &#8220;A universal theme would work in both editing modes.&nbsp; A user should be able to build a site in classic mode and switch to FSE mode when the Site Editor is more mature or when they are ready to try all the extra tools that Full Site Editing will bring. Changes to a theme in classic mode should be reflected when I enable the Site Editor.&#8221; and goes into more details on how that could work. At Automattic, they experiment with the <a href=\"https://github.com/Automattic/themes/tree/trunk/quadrat\">Quadrat theme</a>. </p>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s main (trunk) branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n<p></p>\n\n\n\n\n<h2>Block Patterns</h2>\n\n\n\n<p>About 80 Patterns have been published in the Pattern Directory on WordPress.org, <strong>Kjell Reigstad</strong> reported in his <strong><a href=\"https://make.wordpress.org/design/2021/06/23/update-initial-patterns-for-the-patterns-directory/\">Update: Initial Patterns for the Patterns Directory</a> </strong>over the last two weeks, Kjell, Mel Choyce and Beatriz Fialho were fielding community submissions and working with the designers. There are wonderful and useful patterns, you can use for your site.</p>\n\n\n\n<p>The discussion about <strong>Block Patterns</strong> on the WordPress Tavern has readers ruminating about <strong><a href=\"https://wptavern.com/wordpress-theme-lock-in-silos-and-the-block-system\">Theme Lock-In, Silos, and the Block System</a>.</strong> In a Post Status discussion, <strong>Tammie Lister </strong>thought the opposite is true. &#8220;it&#8217;s going to be easier, not harder, to switch with the newer set up.&#8221; And then she continues: &#8220;Try swapping between themes now. It&#8217;s not a picnic. It&#8217;s often a sad rained on picnic with soggy sandwiches of sadness, even with the best hope.&#8221; 🌧️ I might steal that metaphor from Tammie 💕</p>\n\n\n\n<p>Speaking of Block Patterns, the design team also brought Block Patterns to all WordPress Twenty themes, all the way back to Twenty-Ten. They will be released with WordPress 5.8. <strong>Milana Cap</strong> published about these <strong><a href=\"https://make.wordpress.org/core/2021/06/21/bundled-themes-changes-in-wordpress-5-8/\">Bundled themes changes in WordPress 5.8</a>.</strong> They are a great inspiration for designer on what can be possible with Block Patterns now. Justin Tadlock at the WordPress Tavern also <a href=\"https://wptavern.com/a-throwback-to-the-past-refreshing-old-twenty-wordpress-themes-with-block-patterns\">took the new patterns out for a spin.</a></p>\n\n\n\n<p>In <strong><a href=\"https://themeshaper.com/2021/06/25/theme-patterns-for-the-site-editor/\">Theme patterns for the Site&nbsp;Editor</a> </strong> <strong>Kjell Reigstad</strong> show off a new UI to handle the display of different patterns for a header. It is an expansion of the block pattern display for Query Loop for various Post list layouts. He also shared his code and a short tutorial. Kjell also used the Quadrat theme from the Automattic repository </p>\n\n\n\n\nHeader Patterns in Quadrat Theme / Automattic\n\n\n\n\n<h2>Block Development and Plugins</h2>\n\n\n\n<p>For block builders, the Core-editor team published two DevNotes this week. </p>\n\n\n\n<p><strong><a href=\"https://make.wordpress.org/core/2021/06/23/block-api-enhancements-in-wordpress-5-8/\">Block API Enhancements in WordPress 5.8</a> </strong>by <strong>Grzegorz Ziolkowski</strong>, encouraging plugins developers to using the block.json metadata file. He lists under the benefits: </p>\n\n\n\n<ul><li>code sharing between JavaScript and PHP and other languages, </li><li>optimized enqueuing of assets on the frontend to support performance increases.</li><li>Allows listing of the block on the Block Type REST API endpoint </li><li>It&#8217;s a requirement for blocks to be included in the WordPress Plugin Directory  </li></ul>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2021/06/25/block-supports-api-updates-for-wordpress-5-8/\"><strong>Block supports API updates for WordPress 5.8</strong></a>&nbsp; by <strong>Daisy Olsen</strong>, which outlines and additional support options for color, duotone, fontSize, lineHeight, spacing options for blocks and themes. </p>\n\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p class=\"has-text-align-center\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\">Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n\n<p>Featured Image: <a target=\"_blank\" rel=\"noreferrer noopener\" href=\"https://commons.wikimedia.org/w/index.php?curid=6068229\">&#8220;File:Lego Color Bricks.jpg&#8221;</a>&nbsp;by&nbsp;<a href=\"https://www.flickr.com/people/13403905@N03\" target=\"_blank\" rel=\"noreferrer noopener\">Alan Chia</a>&nbsp;is licensed under&nbsp;<a href=\"https://creativecommons.org/licenses/by-sa/2.0?ref=ccsearch&atype=rich\" target=\"_blank\" rel=\"noreferrer noopener\">CC BY-SA 2.0</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Sep 2021 18:15:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"Gutenberg Times: Theme.json for WordPress Theme Authors – demo and  Live Q &amp; A w/ Daisy Olson, Tammie Lister and Jeff Ong\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=18324\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"https://gutenbergtimes.com/theme-json-for-wordpress-theme-authors-demo-and-live-q-a-w-daisy-olson-tammie-lister-and-jeff-ong/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:56956:\"<p>On June 24th, we hosted Gutenberg Times Live Q &amp; A on the topic  <strong>&#8220;Theme.json for Theme Authors &#8211; Getting started with theme development for Full-site Editing&#8221;</strong> It was a great pleasure and privilege to have <a href=\"https://twitter.com/DaisyOlsen\">Daisy Olson</a>, developer advocate at Automattic, <a href=\"https://twitter.com/karmatosed\">Tammie Lister</a>, design lead at Extendify and <a href=\"https://twitter.com/jffng\">Jeff Ong</a>, code wrangler at Automattic on the show. </p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<div class=\"toolbelt-video-wrapper\"></div>\n</div>\n\n\n\n<p>Jeff Ong prepared <a href=\"https://youtu.be/dBwhHKKblhU?t=831\">a demo</a> for us, and then attendees had some interesting questions our panelists answered. You can read the transcript below.</p>\n\n\n\n<p>WordPress 5.8 will come with the infrastructure and foundation to control the block editor and theme settings via the configuration file theme.json. JSON is a universal data format that is readable to PHP and JavaScript alike.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-style-large\"><p>Themes no longer have to pretend that they&#8217;re plugins.</p><cite>Tammie Lister</cite></blockquote>\n\n\n\n<div class=\"wp-block-sortabrilliant-guidepost\"><ul><li><a href=\"https://gutenbergtimes.com/feed/#0-resources-about-theme-json-and-themes-for-full-site-editing\">Resources about theme.json and themes for Full-site editing</a></li><li><a href=\"https://gutenbergtimes.com/feed/#1-themes-for-full-site-editing-in-the-word-press-org-repository\">Themes for Full-site Editing in the WordPress.org repository</a></li><li><a href=\"https://gutenbergtimes.com/feed/#2-strong-what-will-change-most-for-the-theme-developers-when-building-themes-for-full-site-editing-strong\">What will change most for the theme developers when building themes for full-site editing?</a></li><li><a href=\"https://gutenbergtimes.com/feed/#3-demo-configuring-the-block-editor-with-theme-json-file\">Demo: Configuring the block editor with theme.json file</a></li><li><a href=\"https://gutenbergtimes.com/feed/#3-meta-charset-utf-8-why-do-we-want-to-rewrite-css-in-json\">Why do we want to rewrite CSS in JSON</a></li><li><a href=\"https://gutenbergtimes.com/feed/#4-what-happens-when-you-update-the-color-palette-will-saved-blocks-have-the-new-colors\">What happens when you update the color palette? Will saved blocks have the new colors?</a></li></ul></div>\n\n\n\n<h2 id=\"0-resources-about-theme-json-and-themes-for-full-site-editing\">Resources about theme.json and themes for Full-site editing</h2>\n\n\n\n<p>During the show, we mentioned a few places where you can dive in and learn more about theme.json.</p>\n\n\n\n<p>You can read an <a href=\"https://make.wordpress.org/core/2021/06/25/introducing-theme-json-in-wordpress-5-8/\"><strong>Introducing theme.json in WordPress 5.8</strong></a> by <strong>Andre Maneiro</strong> on the Core Make blog. </p>\n\n\n\n<p>You can read up on the details specifications in the Block Editor Handbook: <strong><a href=\"https://developer.wordpress.org/block-editor/how-to-guides/themes/theme-json/\">Global Settings &amp; Styles (theme.json)</a>. </strong></p>\n\n\n\n<p>A good way to get started and see the configuration in action is to study the themes available in the <a href=\"https://github.com/WordPress/theme-experiments/\"><strong>Theme Experiments repository</strong></a> on GitHub. </p>\n\n\n\n<p>Another fantastic way to get your feet wet is to heed the <a href=\"https://make.wordpress.org/test/2021/06/24/call-for-testing-thrive-with-theme-json/\"><strong>Call for Testing #8</strong></a> out of the FSE outreach program. Anne McCarthy has some interesting tasks for you. </p>\n\n\n\n<p><strong>Tammie Lister</strong> started a new blog and shared her thoughts on theme.json and why she is excited again for theme development. <a href=\"https://ephemeralthemes.com/2021/06/20/theme-json-inspires/\"><strong>Theme.json inspires</strong></a></p>\n\n\n\n<p>The Gutenberg team is in ongoing discussion about various topics. Two were raised during the Live Q &amp; A. Both could use your opinion and ideas. </p>\n\n\n\n<ul><li><a href=\"https://github.com/WordPress/gutenberg/issues/29568\">Default Colors, Theme Colors, and Custom Colors</a></li><li><a href=\"https://github.com/WordPress/gutenberg/issues/20244\">Responsive Global Styles as a work in progress</a></li></ul>\n\n\n\n<h2 id=\"1-themes-for-full-site-editing-in-the-word-press-org-repository\">Themes for Full-site Editing in the WordPress.org repository</h2>\n\n\n\n<ul><li><a href=\"https://wordpress.org/themes/blockbase/\">Block Base</a> by Automattic</li><li><a href=\"https://wordpress.org/themes/naledi/\">Naledi </a>by Anariel Design</li><li><a href=\"https://wordpress.org/themes/tt1-blocks/\">TT1 Blocks</a> by WordPress contributors, the FSE sibling of the Twenty-Twenty-One Theme</li><li><a href=\"https://wordpress.org/themes/block-based-bosco/\">Block-Based Bosco</a> by Fränk Klein</li><li><a href=\"https://wordpress.org/themes/armando/\">Armando</a> by Carolyn Newmark</li><li><a href=\"https://wordpress.org/themes/q/\">Q </a>by Ari Stathopoulos</li><li><a href=\"https://wordpress.org/themes/hansen/\">Hansen</a> by Uxl Themes</li></ul>\n\n\n\n<p class=\"has-larger-font-size\" id=\"transcript\"><strong>Transcript</strong></p>\n\n\n\n<p class=\"has-text-align-center\" id=\"transcript\"><em><span class=\"has-inline-color has-accent-color\">This transcript is still a work in progress</span></em><strong><span class=\"has-inline-color has-accent-color\"> </span></strong>&#8211; Birgit</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Well, and then we can start the webinar here. The webinar is now live and welcome to our 28th Gutenberg live Q and A on this June 24th. My name is Birgit Pauli-Haack and I am your host for today&#8217;s discussion. Thank you all for watching, and it&#8217;s great to have you. And while you all come in, use the chat window to tell us where you are and where you&#8217;re watching from.&nbsp;</p>\n\n\n\n<p>And today we will discuss a new way to configure themes, that is black themes, with global styles and settings file theme.json. And it will enable theme developers to centralize all the block-based settings, color palettes, font sizes, and other block-based customizations. This way you will also control which of the other block features the theme supports or does not support.&nbsp;</p>\n\n\n\n<p>So that&#8217;s my simple mind&#8217;s description of the new features and I&#8217;m so thrilled to have three experts on the show to go beyond this simple explanation and help theme developers to get started. I&#8217;m extremely honored to have Daisy Olsen, developer advocate at Automatic and WordPress contributor. Hey, good to have you. Also Jeff Ong, code wrangler at Automatic.</p>\n\n\n\n<p><em>Jeff Ong: </em>Hello.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Thanks for being here. And at last but not at least Tammie Lister, design lead at Extendify.</p>\n\n\n\n<p><em>Tammie Lister:</em> Hello.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> We&#8217;ll do some proper introduction in less than a minute. I just have a few housekeeping notes. So after the introduction, we&#8217;ll have a first round robin question and then we see a demo. Jeff was working really hard on it and I think he was the only one repairing hard for this live Q and A. And then we&#8217;ll discuss the different angles and how they get started. And then, of course, answer your question.</p>\n\n\n\n<p>Speaking of questions, how do you pose your questions? There&#8217;s a Q and A on the bottom of the screen, a kind of icon. You click on that and write your question. And for those watching on YouTube use the chat window next to the video player. And so saying hi. Hi, Victor. From Buenos Aires in Argentina. Awesome. Thank you for being here. All right. When you do comments and questions, so please be kind even if you disagree.&nbsp;</p>\n\n\n\n<p>This is a family endeavor. All right. Well, I&#8217;m thrilled you all agreed dear panelists to come on the show and I get an hour to talk with you about your work. So, Daisy, tell us a little bit about you, where are you&#8217;re located and what is it that you do as developer advocate on the purpose project and at Automatic?</p>\n\n\n\n<p><em>Daisy Olsen: </em>Yeah. I&#8217;m Daisy Olsen and I live in New Hampshire in the United States. It&#8217;s a beautiful day here right now unlike some parts of this country that are really hot. We got the cool weather over here this week. So as a developer advocate, I talk about WordPress a lot.</p>\n\n\n\n<p>I get out and do workshops, teach classes, write documentation and just stay involved and close to the projects development so that I know what&#8217;s going on theoretically and can share that out particularly with plugin and theme developers as well as agencies and freelancers and things like that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Awesome. So glad you&#8217;re here. Thank you. So, Tammie, thank you for coming back to the show. It&#8217;s been over three years. The last time you were on the show was just after Gutenberg was merged into Core and you were one of the three leads with Matias Ventura and Joen Asmussen. </p>\n\n\n\n<p>And you shared a lot about the journey of Gutenberg and the philosophy behind it. So I will put the link to the show into the show notes for you who have been coming later to Gutenberg. But this year you joined the WordPress product company Extendify. So what do you do there?</p>\n\n\n\n<p><em>Tammie Lister:</em> First of all, has it been three years? That goodness. Time flies. So in Extendify I focus on design. So our solutions extend the editor. And then the aim is to make it even more usable for people&#8217;s purpose that they want to use it for. And I&#8217;m really, really excited about that.</p>\n\n\n\n<p>So it means that people can have the best experience from the content they&#8217;re creating, to the layout, the patterns, the styles, whatever that the editor enables, that&#8217;s really what I&#8217;m focusing on. So it&#8217;s a interesting new challenge to do. And you have blew my brain with that time span. You really have. That&#8217;s awesome.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Well, it&#8217;s also over three years that Gutenberg times us. So I&#8217;ve been part of that journey so for so long.</p>\n\n\n\n<p><em>Tammie Lister:</em> Congrats.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Nothing really held my attention for so long. And normally I get really bored. Well, I&#8217;m also really happy that Extendify took over <a href=\"https://wordpress.org/plugins/editorplus/\">Editor Plus</a> from Munir Kumal and the <a href=\"https://wordpress.org/plugins/block-options/\">EditorsKit</a> from Jeffrey Carandang. So, those have a more sustainable way now to access because both Munir and Jeffrey seem to have&#8230; Munir joined you, but Jeffrey moved on to be a consultant at , I think, 10up.</p>\n\n\n\n<p><em>Tammie Lister:</em> It&#8217;s so really exciting.&nbsp;</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. I imagine. So thank you also to Jeff Ong for joining us today as well. You&#8217;re a code wrangler in Automatic and what have you been working on lately except for the demo. I know about that.</p>\n\n\n\n<p><em>Jeff Ong</em>: Well, first, thank you for having me and hosting this. Awesome to be here. I feel very honored to be with three on-time contributors. So super cool. At Automattic, I&#8217;ve been working on theme development, pretty solely focused on that for the last year. And my background is not in WordPress. </p>\n\n\n\n<p>So it&#8217;s kind of been an interesting journey to transition and learn about the ecosystem and really coming at a transitory time figuring out how do we kind of move into this new block-based paradigm? How do we make themes that work with the block editor really well and can hopefully unlock more creativity for just really great design. And I can tell you what sites again. Well, making new themes and figuring out how to do that with the latest version of Gutenberg, which turns out every day.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> So the viewers follow Jeff Ong, he&#8217;s going to teach you how to do things with the Block Editor. And we will soon see a little demo of that. It&#8217;s what Daisy said, &#8220;What you did in five minutes, I taught a course on that in three hours.&#8221; So it&#8217;s going to be a little fast paced today.&nbsp;</p>\n\n\n\n<h2 id=\"2-strong-what-will-change-most-for-the-theme-developers-when-building-themes-for-full-site-editing-strong\">What will change most for the theme developers when building themes for full-site editing?</h2>\n\n\n\n<p>But before we head into media&#8217;s raised, I would like to ask each of you, so what do you think will change most for the theme developers when building themes? These are for agency building custom themes for the clients or for theme shops rolling out new themes to sell. Do you want to start, Tammie?</p>\n\n\n\n<p><em>Tammie Lister:</em> Yeah. That&#8217;s interesting because I think perhaps it&#8217;s a change if you wanted to be a change. Because lots of this is an opt-in, as is the way. WordPress, the best way to opt-in. I go back to a lot of times that this is a freeing of things and I think it brings an opportunity that has pros and cons, ups and downs with opportunities.</p>\n\n\n\n<p>But plug-ins themes no longer have to pretend that they&#8217;re plugins and they no longer have to be everything and have to be things that they weren&#8217;t intended to be in the first. So I think that that is a challenge in itself because there&#8217;s a certain way that you maybe thought you had to do things and now you don&#8217;t have to work around things. We often have to work around things in WordPress.&nbsp;</p>\n\n\n\n<p>And if you don&#8217;t have to work around it, it can feel a little bit peculiar, but once you realize you don&#8217;t have to do that, it&#8217;s actually really awesome. But you have to realize you don&#8217;t have to and that WordPress was getting in the way. I also think as a result there&#8217;s going to be a space for more creativity, and this can also be really to challenging because maybe you were limited to what you could do creativity wise because of just the confinements of the space and the confinements of what you could do before.&nbsp;</p>\n\n\n\n<p>And it&#8217;s going to open things again to a lot more people. And a lot more people who maybe didn&#8217;t have access to a theme developer with experience who knew the exact ins and outs of it. So I think that&#8217;s a challenge because new people in this space, new creativity. But honestly I think it&#8217;s a good thing. It&#8217;s just if you want to and you&#8217;re open to it and you can kind of explore those new ways, but I don&#8217;t think it&#8217;s a change that you have to make. I think that&#8217;s the thing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Awesome. Thank you. Daisy, what do you think?</p>\n\n\n\n<p><em>Daisy Olsen: </em>So I think I would agree with Tammie that the barrier of entry for a new theme designer. And I think that&#8217;s one of the key things is it&#8217;s bringing the design back to theming. Theming over time became very functional. We had a lot of theme companies that were trying to make their themes as flexible, powerful and feature-ful as possible to reach a wide variety of people.</p>\n\n\n\n<p>And I think that we can see some opportunity for vertically oriented designs coming out where you have a theme that is geared towards a restaurant or geared towards, I don&#8217;t know, a salon or a certain kind of a business or even a personal site.</p>\n\n\n\n<p>And I think that there&#8217;s a lot of opportunity to be able to have a lot of variety out there in the marketplace so that when someone asks you inevitable question, because this was probably the most common question when I was working for a thing company is which theme is best for this?&nbsp;</p>\n\n\n\n<p>I&#8217;m doing this kind of a site, which themes should I use. And it could make it so, well, here are five that are really geared towards what you&#8217;re trying to do instead of, oh, you can use any of them. You just have to do all this work to get it to look bright.</p>\n\n\n\n<p>Birgit Pauli-Haack: Yeah. That&#8217;s a good point. Thank you. Jeff?.</p>\n\n\n\n<p><em>Jeff Ong:</em> Definitely, from a design perspective, it&#8217;s super exciting. I want to highlight maybe a little bit more from the development side. This seems like the biggest opportunity or clearest opportunity to ensure that your theme is integrated with the editor. That the things that you&#8217;re doing with the editor and your ability to customize it to control what presets and options are available there to the users of the theme, this is the theme [inaudible 00:12:27].</p>\n\n\n\n<p>It&#8217;s a unifying kind of idea and single point of truth. Talking about theme.json and even just this whole concept of how do we bring the experience together. I think we have an opportunity to do that and that&#8217;s going to change even in some small level. Even if your theme.json cloud just as a few settings. You can take it slow like Tammie was saying. Incorporate parts of it because to me you have this new contract now that can really unify things and bring things together from a lot of disparate parts and pieces.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Lots to think about. And I agree with all of you. I had this pleasure last year that I took over themes from agencies and they were so powerful and all the things that normally a plug-in will do, custom post types and rigid and all that. It&#8217;s all in one place and we won&#8217;t be able to change a theme at all. </p>\n\n\n\n<p>So now this is definitely going to make life a lot easier for site owners as well So lots to think about and listening to you is quite inspiring to kind of think, oh, well how many direction can my brain go now? But, Jeff, are you ready for your demo? I think it would be helpful for all the people here on the call to see what it&#8217;s all about and how it kind of gets started.</p>\n\n\n\n<p><em>Jeff Ong:</em> Yes. We have 10 minutes roughly. Yes. Can you see my screen? </p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> We can see your screen. Yes.</p>\n\n\n\n<h2 id=\"3-demo-configuring-the-block-editor-with-theme-json-file\">Demo: Configuring the block editor with theme.json file</h2>\n\n\n\n<p><a href=\"https://www.youtube.com/watch?v=dBwhHKKblhU&t=18s\">14.02</a></p>\n\n\n\n<p>Jeff Ong: So we have a blank theme here and I just want to kind of go over some, not going to cover everything, but some of the key parts of that theme.json introduces and show how that impacts a blank theme and also the editor. So hopping over to my code editor. I have my theme.JSON here. This is a really basic, simple theme and nothing going on yet.&nbsp;</p>\n\n\n\n<p>In here I&#8217;m going to go ahead and the first thing I want to talk about are the settings of your theme.JSON. Settings are kind of what control or give you the ability to configure the editor and what kind of customization options are present to a user and the theme. The only thing I have right now is the layout, which we&#8217;ll get to in a second. But let&#8217;s say I want to add some color options here.</p>\n\n\n\n<p>Previously it would be done in the functions PHP. I have kind of a few sheets over here. Sorry. I need to hide these meeting control. I&#8217;m going to copy a color palette from this. I&#8217;m going to set a palette that&#8217;s going to become available to me in my theme. I go to edit the same post. In here I see my cornso, my orange, red, and color blue that&#8217;s become available to me.&nbsp;</p>\n\n\n\n<p>What&#8217;s pretty interesting about this is before you would have had to kind of go into functions at this whole palette and then also define the class name, something like this to actually apply those styles. Let&#8217;s say I want this heading to be orange, update it. Show it here. I get all this cool stuff for free. This class was generated for me by Gutenberg using this preset and that I have defined meeting controls defined here in my palette options.&nbsp;</p>\n\n\n\n<p>Another cool thing or interesting about the possibility here is within the same configuration. Let&#8217;s say I&#8217;m the theme designer. I have the option right now to change the color to kind of anything I want. The powerful thing about theme.json at this time is it can actually turn something like this off. I actually don&#8217;t want people or my users to be able to change anything, change the color palette.</p>\n\n\n\n<p>But let&#8217;s go ahead and reset this back here. Turned off custom colors within theme.json. And then back here you&#8217;ll see that option has disappeared. So inaccessible color combinations or just color combinations that you don&#8217;t want to be available. You can turn that off. This is just one of the options that are available. Color is just one of the options that you can customize.</p>\n\n\n\n<p>You can also take a look at something like typography. I think I can find some font sizes here. Refresh. I can see now that those presets were available, are now available to me. I can do the same thing again here too. Say I don&#8217;t actually want people to be able to change all sides here. As a designer I know it&#8217;s best and I don&#8217;t want people putting in random font sizes.&nbsp;</p>\n\n\n\n<p>So disable that and now only my presets are available too. Oh, by the way, this content is just kind of some standard block-based content. Again, I&#8217;m getting all of this kind of for free or for free in a way by just applying some preset values here. Well, I think the next thing that I wanted to cover is going into the last thing. I&#8217;ll cover it within the settings because you can actually change these per block.&nbsp;</p>\n\n\n\n<p>Remember we were looking at color before. I could add a color key to the paragraph block and actually say, just kidding. I want to allow you to be able to change the color of paragraph blocks. Just the paragraph blocks. I can open up the whole thing. So within here now I can see, oh, I can actually change just for paragraph blocks. I go up to my heading. This custom color is not available. This color option is not available.&nbsp;</p>\n\n\n\n<p>If you want to I could also supply a custom palette. I&#8217;m not going to do that, but could say if you wanted a specific palette that&#8217;s just applied for paragraph blocks. That would be how you do it. So I think that&#8217;s it for settings. I&#8217;m going to go ahead and collapse this now and move on to the styles key of our theme.json. And now within here I can start to define some files.&nbsp;</p>\n\n\n\n<p>Remember our colors from up here from the palette. I can go ahead and because I know that WordPress is generating CSS variables based on these palettes, I can go ahead and start to use those within the styles application of the style section of my theme.json. So with the preset color, put orange red. See what else do. These are going to apply at the top level. So this is going to apply to everything.</p>\n\n\n\n<p>Say I only wanted, for instance, my headings to be&#8230; Let&#8217;s make this. Do the same thing in here and say, ah, I just want, actually, let&#8217;s just make my paragraph colors black. So, again, what I&#8217;ve done here is I&#8217;ve set my global kind of text color to this orange red was preset, which was provided by WordPress and generated here to the entire text. And then actually I can go in and target specific block, set the settings for that as well.&nbsp;</p>\n\n\n\n<p>I think we are close. I just want to show, well, if you&#8217;re editing this, something that&#8217;s also probably going to happen and mess this up. It should throw some kind of an error here yet. Notice there when decoding theme.json. So that&#8217;ll let you know there&#8217;s something going on because it&#8217;s pretty easy tip something up here.&nbsp;</p>\n\n\n\n<p>And I think that&#8217;s just a small note is we&#8217;ll likely encounter that if you&#8217;re configuring keys and nested objects trying to figure out how each of those apply. You pause here for a second. I guess the last thing I want to cover too is the concept of elements. So within here, any h2 that I have is going to be applied a specific style here. So I have the same because [inaudible 00:24:24] can appear outside of blocks or links, for example.</p>\n\n\n\n<p>These are restricted to a specific set at the moment. So let&#8217;s just say text. So, again, because this is not actually rendered as a pocket and an element and that can appear anywhere. That&#8217;s something that I can target with this kind of top level elements select here. Everything else here you can target with the name of the block.&nbsp;</p>\n\n\n\n<p>That is most of what I wanted to cover pretty fast, but again all of the settings that you can find here or that I&#8217;m going over, there&#8217;s way more than just color. There&#8217;s spacing, typography and all of that can be found in documentation that Birgit, I think she shared it here. So that I want to open it up. And I guess there are questions. If there are specific parts that anyone would want to go into in a little more detail. Happy to do that.</p>\n\n\n\n<p><em>Daisy Olsen: </em>Thank you, Jeff. </p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Thank you, Jeff. This was awesome. Do you want to just say something?</p>\n\n\n\n<p><em>Daisy Olsen: </em>Yeah. I just wanted to say that maybe we could just talk about layout real quick because I think that&#8217;s going to be a big one for 5.8.</p>\n\n\n\n<p><em>Jeff Ong:</em> Yeah. And I kind of skipped over. It was the first thing that was in here. Yes. Layout key is a way for you to quickly define the default, the width of your content within WordPress or within here. So if you see here, if I don&#8217;t define this layout, a lot of my content is just going to be full width by default. </p>\n\n\n\n<p>You can supply two values here. Content size, it&#8217;s just going to be the default width. You can also define, I think it&#8217;s, what is it? Wide size. Wide width. Nothing happened there because I hadn&#8217;t provided it. Maybe there&#8217;s a better way to show that with cover block.&nbsp;</p>\n\n\n\n<p>Birgit Pauli-Haack: Nice. I like it.&nbsp;</p>\n\n\n\n<p><em>Jeff Ong:</em> Pretty cool. You can, I mean, alignment coming together and within a unified system reliably layout content with starting here is pretty powerful stuff I&#8217;d say.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Awesome. So I shared in the chat window, if you haven&#8217;t seen it, the documentation link where you can read up about the theme.json as a whole. When you say, Daisy, that that&#8217;s the layout will be important for 5.8, which part of it would be, where does it come into play?</p>\n\n\n\n<p><em>Daisy Olsen:</em> So with 5.8 with the custom template functionality that&#8217;s coming where you can basically create a custom template for an entire page or a post that would cover your header as well as your content. If you need to have these setting set for the width, especially the content size for it but preferably also wide so that your site knows how wide it should be. </p>\n\n\n\n<p>Otherwise you get kind of the facts that Jeff showed where it was the full width of the page. It didn&#8217;t have anything to contain it down to the width that you want. So for any theme that wants to use the template editor would benefit from having a theme.json file that even if it only has the one thing in it, it would be good way to take advantage of it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. It&#8217;s an excellent tip. Thank you, Daisy. You heard it here first. So we already got some questions in our Q and A, but I just wanted to have one question for Jeff before. That&#8217;s my prerogative as a host, I get the first question. So if I understood it correctly, so until now, theme.json comes into play I had to create many different places or touch many different places to make a color palette work.</p>\n\n\n\n<p>So, I had to put it in my functions.php and then I also have to put it in my style sheet. Is [inaudible 00:30:04] that I don&#8217;t have to do this anymore, or do I still have to put it into my style sheet, or is it automatically created with when I put the color palette in the theme.json?</p>\n\n\n\n<p><em>Jeff Ong:</em> It is wonderful question. It is automatically created. This is all that that style sheet looks like since this is one of the big very exciting aspects of a theme.json. It&#8217;s that it&#8217;s managing this for you. And then also I think more down the line by providing colors and styles in this way. And then also by applying the styles here you can guarantee that those blocks are going to integrate properly.</p>\n\n\n\n<p>It&#8217;s like the styles for those blocks are going to be more closely tied and actually in how the block is implemented. So no more writing styles that are overwriting that we&#8217;re having to target specific nested blocks. And so there&#8217;s tons of complications to this and there&#8217;s a lot more room to mature and develop, but I think that&#8217;s one of the parts I&#8217;m most excited about. To your point, there&#8217;s one place now where I can define my palette and show how it should be applied. I don&#8217;t have to go into two different places to do it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> All right. Well, let&#8217;s go to the questions. Victor Kane, from the beginning of the show has already put them in and he&#8217;s particular interested in finding out about the workflow using them theme.json. So one is the best editing alternative for VS Code formatting, and then the second one was the possibility for exporting interactive selections to clipboard and code. I&#8217;m not quite sure I understand the question. Maybe you understand it, Jeff Daisy, Tammie.</p>\n\n\n\n<p><em>Tammie Lister:</em> Personally. So I think this is a personal choice. I&#8217;m going to start with an answer and then go to&#8230; I use VS Code, so I may not be able to give the right answer there. I would be curious to know what you don&#8217;t want in VS Code, and I think that that&#8217;s the thing. This opens up personal&#8230; I&#8217;m going to be really bad at reading the response in chat whilst talking. So I&#8217;m going to be a little bit pertinent and kind of speak first. I&#8217;m sorry, I&#8217;ll get back to it.</p>\n\n\n\n<p>It&#8217;s your personal choice how you write and then you can kind of go back to it. So the thing that I did, this was my workflow, it has been my workflow so far, and I think this is the thing, we&#8217;re all finding our own new workflows with these new toys that we&#8217;re playing with. So what I&#8217;ve been doing is I&#8217;ve been using theme.json.&nbsp;</p>\n\n\n\n<p>I&#8217;ve actually been setting up variables using SAS that have been then pulling in root variables into my theme.json so that I can pull them through. That&#8217;s a weird way to do it. That&#8217;s strange, but the reason being, it means I can reuse and keep things separately. But I&#8217;m sure that everybody on this call has their own little workflows that they are kind of working from.</p>\n\n\n\n<p><em>Daisy Olsen:</em> My approach to that was actually the opposite that I was using my theme.json to set all of my variables so that I didn&#8217;t need SAS, which I think for those that never quite got their head wrapped around preprocessed CSS, it might be a way to simplify things for those that prefer it that way.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Awesome. </p>\n\n\n\n<p><em>Tammie Lister: </em>I think it&#8217;s what you&#8217;re cozy with, right? And I think that&#8217;s the thing. This can adapt to what was your cozy blanket of coding, and you don&#8217;t have to lose that yet, I think.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> All right. So Victor commented on that. If I get the results, I want interactively with the global settings panel on the right-hand side of the editor, can I export that to a theme.json format?</p>\n\n\n\n<p><em>Daisy Olsen: </em>The answer is not right now. I think there&#8217;s discussion in the teams about maybe building it, but it hasn&#8217;t been the highest priority because everything needs to work first before we start working on an exporter. But there are other parts of that can be exported in that full site editing experience that can be exported. So I think it would be a natural progression to add the ability to do a theme.json export.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yes. Definitely there will be.</p>\n\n\n\n<p><em>Tammie Lister:</em> From the very beginning, there were designs in global style. Sorry. The reason I know is that was one thing I did partake on. There was exporting. So I have a feeling if we all wanted to play some little happy bets, there will be exploiting at some point.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. But if we all bet on the same thing, it&#8217;s not really bet, right? Victor, as always, you&#8217;re a little bit ahead of the time. So and from Jan Horna, from the Czech Republic, it&#8217;s very hot by now there. </p>\n\n\n\n<p>He has two questions as a theme developer, one, is the theme.json supposed to include all the styling, formatting definitions and replaced the CSS style? And I think we&#8217;d take it one at a time. So we talked a little bit about it from my question, but would it replace? You could still do all those styling in the style sheets as you want, right?</p>\n\n\n\n<p><em>Daisy Olsen:</em> And I think there are some things that will remain in other styling, but you could use the variables that you set or the properties that you set in your theme.json in your CSS. So they can work together. But I don&#8217;t think that theme.json, at least right now, will not completely replace an entire site&#8217;s design, especially if you have a very complex design.</p>\n\n\n\n<h2 id=\"3-meta-charset-utf-8-why-do-we-want-to-rewrite-css-in-json\">Why do we want to rewrite CSS in JSON</h2>\n\n\n\n<p><em>Jeff Ong:</em> Yeah. And this was one of my first questions and honestly, skepticism early on of the proposal around this, is CSS is great. Why do we want to rewrite CSS in JSON. And then it slowly, I mean, other people are obviously smarter than me understood this quickly. It&#8217;s not about rewriting all of CSS. There&#8217;s definitely going to be aspects of your site, especially if you have taking, like you&#8217;re saying, more complicated designs that will remain in CSS. </p>\n\n\n\n<p>But this is about creating, I think, more of the foundational elements and understanding how the blocks will interact with your styles and having that single point of contact, I think is most important. So I think for me, at least it&#8217;s more about the foundational elements that are going to be placed and managed this way than replacing your entirety of your styles. Because this great.&nbsp;</p>\n\n\n\n<p>Things like animations and transformation, and this is all really powerful stuff that I don&#8217;t imagine, really, at least in the super near future, having a big part of theme.json. To the question about, will you be able to save an export a theme.json from global styles? I think this is a really important thing to keep in mind is what I just showed you is kind of unnatural. I don&#8217;t imagine a future necessarily where theme developers are writing raw JSON.</p>\n\n\n\n<p>It&#8217;s really, there&#8217;s not a great experience for it. It&#8217;s a configuration file. And so the more, to points that have already been raised, it&#8217;s about we&#8217;re in this phase now because we need to kind of identify and get it to work, and then we can kind of build an ecosystem around what would a really cool UI look like to generate one of these files? Is it native directly to global styles? How do we start to imagine those interfaces so the theme developers or theme designers can really get to the core of this experience too?</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> All right. Well, thank you. Good point. You wanted to say something.</p>\n\n\n\n<p><em>Tammie Lister: </em>Yeah. I was just going to say over time, CSS has gained so much. So I didn&#8217;t know about anyone else, but I had a block.css file that was getting bigger and bigger of supporting blocks and doing things. And something I&#8217;ve noticed that I can do is throw that file away, and I couldn&#8217;t be happier because what I can do now is lean into these defaults. I&#8217;m still going to have some lines of CSS, the output by whatever, a preprocessor, whatever, my happy little whatever. </p>\n\n\n\n<p>Because everyone has got their own way and we should have our own way of doing it. But it&#8217;s a foundation, and it means that we&#8217;re not having to work around the editor or find different ways of doing it. I set up naturally a hack file for the editor out of habit. I haven&#8217;t filled it with anything yet in the latest theme I&#8217;ve been working on.&nbsp;</p>\n\n\n\n<p>I&#8217;m delighted if I never fill that up with anything on the next theme, because it means that the new way we&#8217;re doing things hasn&#8217;t had me to work around that. I can just use the foundation and create a really awesome experience on top of it. And that&#8217;s what we should be doing. We should be working with the editor, not having to work around it, or using not important like it was going out of fashion to go over control of it. It was this awkward middle ground we were working in trying to make things fit that paradigm.&nbsp;</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And I think that fits right into the next question from Jan Horna again, and he says so as a block theme developer, should I focus from a strategic point of view on theme.json block styles, or block patterns. In other words, how do I differentiate? It&#8217;s kind of a high-level question there.</p>\n\n\n\n<p>D<em>aisy Olsen: </em>I would say all of the above. They&#8217;re all important things. And your block styles are part of theme.json, I would say. But block patterns are really a powerful partner to the theme.json, that you can create building blocks for a site where you&#8217;ve got some really amazing very specific designed elements that could be used for different things on a site. So if you&#8217;re creating a commercial application that&#8217;s going to go out to a wide audience, they can be more generic. </p>\n\n\n\n<p>But if you have a client and you&#8217;re working as a freelancer or in an agency where you have a site that needs to have access to these things that they&#8217;re going to use more than once, patterns are a fantastic way to do that, where most of the work is done for them. They don&#8217;t have to reconfigure everything from the ground up every time they want to create something similar to what they&#8217;ve done before.</p>\n\n\n\n<h2 id=\"4-what-happens-when-you-update-the-color-palette-will-saved-blocks-have-the-new-colors\">What happens when you update the color palette? Will saved blocks have the new colors?</h2>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Thank you. And Spencer McCormick in the chat had a question. So what happens when you update the color palette or similar, for example, if you have a primary and secondary colors, when you update and change the palette colors, will saved blocks have the new colors? That&#8217;s an interesting question. Thank you, Spenser.</p>\n\n\n\n<p><em>Daisy Olsen:</em> I can answer that to some extent. If you think of your palette as named colors, if you give the different hex code to the same name, it should apply to the site. But if you give it a new name, then that&#8217;s a new element, and it won&#8217;t apply to anything that already had an old name attached to it.</p>\n\n\n\n<p><em>Jeff Ong:</em> There is a hefty discussion related to this question on the naming of colors in the way that Gutenberg wants to supply a default palette or a default set of named colors so that you could reliably&#8230; What we&#8217;re seeing I think is that I think patterns have been wanting to rely on specific colors across kind of, so you can guarantee oh, when corn flour shows up it&#8217;s always going to be corn flour. </p>\n\n\n\n<p>It&#8217;s always going to be available. There&#8217;s a lot of complication and nuance around it. But if, I think today, to answer your question, like Daisy is saying, today, if I were to supply a value or a named value here and then change it or take it out of my palette, then that would break the experience or it would no longer be applied to that.</p>\n\n\n\n<p>And that&#8217;s part of the challenge, how do we reliably solve for that? How do we give theme office the tools to figure that out. But now if they set a custom color, if you set a custom color on an element or a block, then that will remain because it&#8217;s a specific X value, but the class names will go away though, if they&#8217;re supplied by the theme.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> So great discussions. And I&#8217;m probably going to share, and if it&#8217;s one issue where that discuss the theme team every week kind of shares all the things that are discussed and that need input from the community or other theme developers on their make blog. </p>\n\n\n\n<p>So that is definitely a place to go to chime in and we&#8217;ll find all the discussions that are happening. And then chime in in the ones that you find important and that you are worried about. So Tim Bowen has the question, how does the theme.json handle responsive sizes for font sizes especially. Responsive sizes.</p>\n\n\n\n<p><em>Daisy Olsen: </em>By default, I&#8217;m not sure.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> You&#8217;ve stomped the panelists. Yes, we did it.</p>\n\n\n\n<p><em>Tammie Lister:</em> I mean, you can use not just pixel values for your fonts, so-</p>\n\n\n\n<p><em>Daisy Olsen:</em> That&#8217;s what I was going to say. </p>\n\n\n\n<p>Tammie Lister: &#8230; that helps. And I think it&#8217;s a work in progress. So things like responsive and breakpoints. But the now answer is you don&#8217;t have to just use pixels. And Jeff just gave a great leak.</p>\n\n\n\n<p>Je<em>ff Ong: </em>I just dropped the issue in that has not seen a lot of activity around it, but the idea of media. So the first part of your question on font sizes, there are ways of calculating this where they&#8217;re not pixel values tied to specific viewports. You could supply a calculated value, for example, in your small&#8230; that is based on a viewport size. </p>\n\n\n\n<p>So it&#8217;s kind of a paradigm shift or design paradigm shift of getting away from you must be 12 pixels under below 600 pixel viewport width, to more of are we okay with kind of a fluid typography kind of system? That being said, there are instances where you need media queries, and that is not currently&#8230; I don&#8217;t know how actively that&#8217;s being worked on right now. But a wonderful thing open to contributors.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> So Patty has a comment and a question after that, Patty O&#8217;Hara, I most often develop custom themes for clients and hand them off for the clients to update the content. And playing around with new tools, I&#8217;m excited to start using them, but don&#8217;t want to give access to global standards to anyone with admin access. Will the granularity of permissions changes so that I can block access to changing fonts and colors from within the admin?</p>\n\n\n\n<p><em>Tammie Lister:</em> I think this amazing thing happens in where also Jeff showed some of the control you can do. So in the demo, there was some control that you can do. But my process is a history of configurability and being able to do that be it in code, or be it in a plugin. But I honestly think we need to be a little bit cautious. This is my personal opinion here, and we need to maybe embrace allowing people to do styling. </p>\n\n\n\n<p>You can set boundaries, you can set branding boundaries, you can set pallets, you can set topography. But we need to move away a little bit from having such pixel fixated control in that sense and think about safely within boundaries, expression of these tools. And that people can create really amazing things, and you can maintain branding that way, and it can empower someone.&nbsp;</p>\n\n\n\n<p>These themes are becoming style guides, and that&#8217;s something that is known in the corporate world and used within that space as well. It&#8217;s a term, but it&#8217;s kind of democratizing design in that sense in giving people all these tools to play with, and I think it&#8217;s a huge change in the way that we&#8217;ve done things, but I think it&#8217;s really, really important and really, really empowering to the people that are using our themes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>That&#8217;s a good advocacy for set it free. Thank you.</p>\n\n\n\n<p><em>Tammie Lister:</em> But you&#8217;re allowed to have boundaries. I think you can set it free, but be comfortable about some boundaries. I think sometimes when we say set it free, it can be scary because we don&#8217;t say you&#8217;re allowed to have some boundaries, but with pallets and with these style guides, that&#8217;s what you&#8217;re saying. You&#8217;re saying I&#8217;m making these good decisions for you and you can choose from this platform of good decisions. And that&#8217;s kind of awesome. I think,</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. I like the plea for block patterns that Daisy just a couple of minutes had that block patterns also give you the possibility or the option to actually provide different facets of how a section can be organized or styled within the style design system that you build with the block add on. </p>\n\n\n\n<p>And so I think that there is a lot of creativity that will come from that as well. So Tim Bowen is brave and contemplating, is it safe to use the theme.json now for a project launching in August? Would we just activate the Gutenberg plugin and add JSON file? Or is there more to it? I would love to move away from our functions in Editor.js method probably as soon as possible. So what would we say to Tim?</p>\n\n\n\n<p><em>Daisy Olsen:</em> The theme is not a block theme, as in it doesn&#8217;t use HTML templates, then I probably wouldn&#8217;t put the Gutenberg plugin on a production website, unless you are ready to deal with unexpected things happening. But placing your theme.json file in your classic theme on the 5.8 beta or release candidate that will be coming, I would start testing there and see if the things that you&#8217;re putting in your theme.json file work with 5.8 on a classic theme. That&#8217;d be my suggestion.</p>\n\n\n\n<p><em>Tammie Lister:</em> I think if it&#8217;s launching in August, that means 5.8 should be out. She tries to check her mental calendar. So I think tests. I, personally, am okay. I would consider it if it was going into a site, but I would also want to know how many users were using it, what their levels was, what they were doing, what they were going to create, and how they were going to do it. So it&#8217;s a&#8230; this is not legal advice. I feel that there should be [inaudible 00:50:36] advice that I can be. </p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Don&#8217;t try this at home. </p>\n\n\n\n<p><em>Tammie Lister:</em> But by then, 5.8 should be out.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. 5.8 comes out July 20th, that&#8217;s at least the schedule for that. So we ran out of questions right now one the Q and A sessions here. Well, you&#8217;re welcome, Tim. Good luck with that, and let us know. Is there more to the setting it up besides just activating the plugin or adding the JSON file. Well, back to kind of using it and editing. </p>\n\n\n\n<p>When there are already themes available in the theme repository that use the full set up for full site editing and use all the template parts and templates with the blocks, and header blocks, and photo blocks, and all that. But I&#8217;m not quite sure of that yet. Be careful about the using the Gutenberg plugin in production. It always has a few hiccups there.</p>\n\n\n\n<p>So it wasn&#8217;t the first time ever that I retreated to the last version when I had one and had to wait till one, two, or three point releases to come out. So I&#8217;m hesitant to say do it in production. Test it as much as possible. So I have a lot of things on my screen, but not the right thing. Here, so it is. Oh, Ryan, we are pretty good time wise. </p>\n\n\n\n<p>So, I don&#8217;t have an additional&#8230; So, when we say how to get started, what was the first thing most difficult part for you for learning, or was there a mind shift until it clicked? Just to kind of get away from a fear of learning something new, and was there something when you go back ages on the theme.json thing.</p>\n\n\n\n<p><strong><em>Tammie Lister: </em></strong>So for me, it was realizing it wasn&#8217;t as hard as I maybe mentally thought it was. It was just the same with learning anything. You always think it&#8217;s going to be super hard, or at least with me, I read like dev doc and I&#8217;m like&#8230; My brain makes that noise. And then I just letting my theme be lighter. Letting it take the weight of that, giving up control, which as someone that&#8217;s maybe a bit of an old themer, giving up control of things, that&#8217;s an interesting process to go through. </p>\n\n\n\n<p>But it&#8217;s really important embracing those foundations. And when you do, there&#8217;s that mind shift of creating in the editor. That was the moment that&#8230; And I&#8217;m still going through the process. I think it&#8217;s a process, and it&#8217;s a process as these tools are evolving. We&#8217;re talking about be gentle, they&#8217;re in production. These tools are still evolving and working.&nbsp;</p>\n\n\n\n<p>If you are using these tools now before it&#8217;s released, then you&#8217;re going to hit bugs and report them. But that&#8217;s the thing. This theme.json also&#8230; the moment I kind of, the Jenga box, the blocks fell in my brain was I stopped seeing it as global stars. And I knew it wasn&#8217;t just global stars, but I felt it wasn&#8217;t just global stars and this felt like it could be the backbone of my theme, and it felt like it wasn&#8217;t everything in my theme, but it felt like it could be the backbone, is the best way I can describe it.&nbsp;</p>\n\n\n\n<p>And I could hang my theme from it. And we&#8217;ve hung our theme from functions.php wrongly, I think. So it was just that change from PHP to doing it all in the editor and creating and seeing that JSON. It just was free, and it&#8217;s more in line with how things are made outside WordPress, which I think is delightful.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Any comments from you that you want to add, Daisy?</p>\n\n\n\n<p><em>Daisy Olsen: </em>So when I first started working with a theme.json file, I found that I had to&#8230; So there&#8217;s a whole section called styles, and I had to realign my thinking about what that meant, because what it&#8217;s saying is there are style settings in your blocks or for your site level depending on how it&#8217;s being applied, and what you&#8217;re doing is configuring the defaults for it. </p>\n\n\n\n<p>So if I think of the theme.json file as a default file, then it helped me frame it so that I&#8217;m not necessarily replacing my CSS depending on&#8230; I mean, I&#8217;m letting theme.json do the heavy lifting, kind of like Tammie said, but then I can take it further if I feel like I need to, or I want to. So I like thinking of it as a configuration file or a defaults file.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> That&#8217;s a good point. Jeff, do you have any stories how I came about?</p>\n\n\n\n<p>Jeff Ong: It&#8217;s been really helpful to pair on it with people, to work on a theme with someone. I think if my team at Automattic. It&#8217;s a very culture of collaboration, and if you have the opportunity to say, &#8220;I&#8217;m having trouble with this. Would you want to work on this?&#8221; With someone like that, because this definitely can be a head bashing kind of why is this not being applied? </p>\n\n\n\n<p>I literally just wrote color green. Why is it not green? It can be so frustrating dealing with that. So to have someone just to look at your code and be like &#8220;Oh, you missed a comma or actually you need an extra key there&#8221; is really, really helpful for something like this.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Oh yeah. So well, I think we&#8217;re coming to the end of our show. This has been very interesting and inspiring. So thank you all so much. And for those who want to dive into at a guided kind of testing session, Anne McCarthy, who, as you might know, runs the Full Site Editing Outreach program, she&#8217;s about to post the eighth call for testing, and it will all be about the theme.json file.</p>\n\n\n\n<p>So as soon as it&#8217;s out, I will share a link in the show notes. And of course, also if you subscribed to our Gutenberg Times newsletter, you will definitely be informed about that. So at this point, I only have two more questions for our panelists. So do you have any announcements that you couldn&#8217;t get out before and you want the people to keep in mind? And if people want to get in touch with you, what would be the best way. Tammie, you want to start?</p>\n\n\n\n<p><em>Tammie Lister:</em> Yeah. So I&#8217;m comatose in all the things. I&#8217;m pretty easy to find in a good way. And I love chatting to people. So please do. I think my thing to say would be remember all of what happening now you can help shape. Just because we&#8217;ve sat here talking about it doesn&#8217;t mean we know anything more than you? It just means we&#8217;ve poked it and we&#8217;ve played around with the code. </p>\n\n\n\n<p>So do that. Start exploring it. And it&#8217;s a lot more accessible than it ever was. It&#8217;s starting to be more accessible. There&#8217;s more documentation than there ever was coming out. And if you care about what happens with themes or you ever cared about what happens to themes, and maybe you could have that reignited, start to join the conversation. And I guess my final point would be, I think my hope is to see this experimentation come back to themes.&nbsp;</p>\n\n\n\n<p>I think we forgot about that a little bit and we need to have some fun again in these. We used to have so much fun in WordPress themes, and I look forward to not just themes to have a purpose, but just themes that are art, themes that are just wacky experiments, and start enjoying theming and make some art. I&#8217;m really excited to see what things people create and use them just for one day even. That&#8217;d be amazing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. So Jeff, anything you want to have people keep in mind, and how to get in contact with you.</p>\n\n\n\n<p><em>Jeff Ong:</em> Yeah. Contact at J-F-F-N-G. And I guess keeping in mind, I&#8217;m just building on the last thing Tammie said, perhaps find a way to have fun with it and get curious about it, and try it. There&#8217;s really to me, a fundamental tendance of learning about something or you just have, how do I get curious about this thing? How do I play with it and have fun? And that&#8217;s going to be the most important thing to keep in at the center.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Thank you, Jeff, and thank you so much for the audio work on the demo. Daisy.</p>\n\n\n\n<p><em>Daisy Olsen:</em> I&#8217;m Daisy Olsen on most things, Olsen with an E, and I would say that as far as what you can do as the next step if you&#8217;re interested in learning more about this, is go to&#8230; I&#8217;m pretty sure that Birgit has a link to this somewhere, the <a href=\"https://github.com/WordPress/theme-experiments/\">theme experiments repository on GitHub</a> in the WordPress space has things that other people have done or are working on. </p>\n\n\n\n<p>So I love to see examples of something in action to help me learn more about it and to see what other people have done. So I would say go check out something.json files in there and see what people have come up with.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Awesome. Thank you so much. So big thank you to Daisy, Jeff, and Tammie to come today and make your time. A big thank you also for the viewers with all your great questions. I think we got a great array of it. And if you have more questions, you can always send them to me via email to <a href=\"mailto:pauli@gutenbergtimes.com\">pauli@gutenbergtimes.com</a>, and I&#8217;ll get you the answers.</p>\n\n\n\n<p>And the recording of the show will be available in a few minutes on our YouTube channel. And I&#8217;ll share all the links then also in the video description. And within a few days, we will have also a transcript that we will publish on the Gutenbergtimes.com. So be well, good-bye, and good luck. That was fun. Thank you.</p>\n\n\n\n<p>Jeff Ong: Thank you, everyone.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Sep 2021 18:15:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"Gutenberg Times: Block-based Template Editor is coming to WordPress 5.8 and a new Widget Editor – Weekend Edition #174\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=18214\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"https://gutenbergtimes.com/block-based-template-editor-is-coming-to-wordpress-5-8-and-a-new-widget-editor-weekend-edition-174/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14651:\"<p>Howdy, </p>\n\n\n\n<p>Lots happening in the larger WordPress space! More aquisitions and a new service for WordPress plugin business, flippantly named <a href=\"https://flipwp.co/\">FlipWP</a>. </p>\n\n\n\n<p><a href=\"https://wordpress.org/news/2021/06/wordpress-5-8-beta-2/\">WordPress 5.8 Beta 2</a>, <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v10.9.0-rc.1\">Gutenberg 10.9 RC</a> released and the first dev notes dropped for the upcoming release. More on that below. </p>\n\n\n\n<p>Don&#8217;t miss next week&#8217;s <strong>Live Q &amp; A on June 24, 2021, at 11am EDT / 15:00 UTC</strong> on theme.json for Theme Authors with our panelists Daisy Olson, Tammie Lister and Jeff Ong. Learn and discuss <a href=\"https://us02web.zoom.us/webinar/register/4216223029678/WN_gyOVb1h4S4iO_UZi1GMQaA\">How to get started with building themes for Full-site editing.</a></p>\n\n\n\n\n\n<p>What are you working on?  Creativity is mushrooming around the WordPress ecosystem and I want to learn from you! Hit reply and let me know! I loved your notes in my inbox! Thank you. </p>\n\n\n\n<p>Yours, 💕<br />Birgit </p>\n\n\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>WordPress 5.8 DevNotes and more</h2>\n\n\n\n<p><strong>Grzegorz Ziolkowski</strong> posted the article <strong><a href=\"https://make.wordpress.org/core/2021/06/16/block-editor-api-changes-to-support-multiple-admin-screens-in-wp-5-8/\">Block Editor API Changes to Support Multiple Admin Screens</a>.</strong> &#8220;WordPress 5.8 is the first&nbsp;core&nbsp;release where the post editor is no longer the only&nbsp;admin&nbsp;screen that uses the&nbsp;block&nbsp;editor. The updated widgets editor screen will also support blocks.&#8221;, he wrote. It&#8217;s quite technical and developers will appreciate it as it opens the doors to use the bock editor on other admin screen, for instance for plugin dashboards and features. It makes my long time wish possible:  replace the &#8220;Quick Draft&#8221; widget with an instance of the block editor and have writers start writing immediately after login, instead of having to open yet another screen. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>Riad Benguella</strong> introduces us to the <a href=\"https://make.wordpress.org/core/2021/06/16/introducing-the-template-editor-in-wordpress-5-8/\"><strong>Template Editor coming to WordPress</strong></a> in its 5.8 release. It comes with a series of new blocks to accommodate Site-wide information, like Site Title or Site Logo as well as post parts for the Query Block, like Post Title, Post Excerpt, Feature Image. In total, 13 Blocks that replace some template parts in conventional themes.  Some blocks will be made <a href=\"https://github.com/WordPress/gutenberg/issues/28744\">available also for classic Themes </a>to accommodate <a href=\"https://github.com/WordPress/gutenberg/issues/29024\">hybrid themes</a> and to support the gradual adoption of block-based themes. </p>\n\n\n\n<p><strong>Justin Tadlock</strong> wrote <a href=\"https://wptavern.com/getting-to-know-the-upcoming-wordpress-5-8-template-editor\">about it on the WPTavern</a>, too. </p>\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2021&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test and Meta team from Jan. 2021 on. Updated by yours truly.  <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">The index 2020 is here</a></p>\n\n\n\n\n<h2>For Site owners and Content Creators</h2>\n\n\n\n<p><strong><a href=\"https://twitter.com/HariShanker\">Hari Shanker</a></strong> from the community team published <a href=\"https://make.wordpress.org/community/2021/06/18/meetup-group-resources-talking-points-for-wordpress-5-8/\"><strong>Talking points for WordPress 5.8</strong></a> of Meetup organizer, that also helps agency owners and freelancers to quickly get an overview of what is coming in the new version. Hari clusters the upcoming changes per WordPress stakeholders. You&#8217;ll find a section for Publishers and users, and another one for site builders and developers. <strong>If you want to read just one article, this would be it. </strong>🚀</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/chrislema\">Chris Lema</a></strong> makes a strong case for  <a href=\"https://chrislema.com/embracing-gutenberg-completely/\"><strong>Embracing Gutenberg Completely</strong></a>. Out of necessity, he decided to rebuild his site with Gutenberg blocks. All site metrics tools suggested reducing the DOM size of his Landing pages build with 3rd party page builders. With this switch, Chris realized, what he needs and doesn&#8217;t need for a highly performing website. His five observations put a few things in perspective for him as a daily writer, he came to appreciate the tools and blocks that come with the block editor. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>The team at <strong>PublishPress</strong> posted a short tutorial on <strong><a href=\"https://publishpress.com/blog/gutenberg/nested-blocks-gutenberg-editor/\">How to Use Nested Blocks in the Gutenberg Editor</a>,</strong> as it&#8217;s still a little confusing for content creators to navigate, especially Column blocks. The persistent list view coming to WordPress 5.8 will help with this, though. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/javier\">Javier Acre</a></strong> from the WordPress design team published a <a href=\"https://make.wordpress.org/design/2021/06/15/a-walk-around-the-table-block/\"><strong>Walk through of possible enhancements for the Table Block</strong></a>. He showcases update to the placeholder state, multicell selection, the sidebar, the toolbar and icon improvements. You&#8217;ll see mock-ups for each. It&#8217;s quite exciting to see, as we probably can all agree that the Table block needs so TLC, 🙂 You can leave your thoughts and ideas in the comments of the post. </p>\n\n\n\n<img />Mockup of Toolbor for the Table block \n\n\n\n<h2>Theme builders</h2>\n\n\n\n<p><strong>Dave Smith</strong> has notes on <a href=\"https://aheadcreative.co.uk/articles/testing-the-gutenberg-widgets-editor-for-wordpress-5-8\"><strong>how to test the new Widget Editor that will come with WordPress 5.8</strong></a>. He followed <a href=\"https://make.wordpress.org/core/2021/05/12/help-test-the-widgets-editor-for-wordpress-5-8/\">Andrei Draganescu call for testing</a> and logged his experience. To test for backwards compatibility for your existing widgets, you can first create some with the new widget editor disabled using the <a href=\"https://wordpress.org/plugins/classic-widgets/\">Classic Widget plugin,</a> and then deactivate the plugins and try to manage and edit the widgets with the block-based editor. You have only a month to make sure your sites won&#8217;t run into trouble. WordPress 5.8 will be released on July 20th, 2021. </p>\n\n\n\n<div class=\"wp-container-61660729d0e5a wp-block-group has-primary-color has-light-background-background-color has-text-color has-background\"><div class=\"wp-block-group__inner-container\">\n<p class=\"has-normal-font-size\"><strong><a href=\"https://us02web.zoom.us/webinar/register/8816229019893/WN_gyOVb1h4S4iO_UZi1GMQaA\">Join us for our next Live Q &amp; A</a> </strong>on <strong>June 24, 2021, at 11am EDT / 15:00 UTC</strong></p>\n\n\n\n<a href=\"https://us02web.zoom.us/webinar/register/8816229019893/WN_gyOVb1h4S4iO_UZi1GMQaA\"><img /></a>\n\n\n\n<p><strong><a href=\"https://us02web.zoom.us/webinar/register/8816229019893/WN_gyOVb1h4S4iO_UZi1GMQaA\">Theme.json for Theme Authors or building themes for full-site editing in WordPress.</a></strong><br /><strong>Host</strong>: Birgit Pauli-Haack<br /><strong>Panel:</strong>&nbsp;Daily Olsen, Tammie Lister and Jeff Ong           <span class=\"has-inline-color\"><strong><a href=\"https://us02web.zoom.us/webinar/register/8816229019893/WN_gyOVb1h4S4iO_UZi1GMQaA\">Register Now</a></strong></span></p>\n</div></div>\n\n\n\n<p><br /><a href=\"https://twitter.com/one_maggie\"><strong>Maggie Cabrera</strong></a> posted the <strong><a href=\"https://make.wordpress.org/themes/2021/06/18/gutenberg-themes-week-of-june-18-2021/\">Gutenberg + Themes: Week of June 18, 2021,</a> </strong>roundup of relevant discussions, issue and PRs for Theme builders. She covered Full-Site Editing, Global Styles and block-based Themes. Chime on on the discussion and test the new releases. If you are a theme developer trying to catch up with what&#8217;s happening with Gutenberg, the Overview / Tracking issues section should get you started. You&#8217;ll find links to documentation and tutorials as well. </p>\n\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/changelog-45-wordpress-5-8-upcoming-live-qa-and-gutenberg-10-7-and-10-8/\"><strong>Episode #45</strong> is now available</a> with transcript. <br />Next recording June 25th, 2021</p>\n\n\n\n<p> <strong>Subscribe to the&nbsp;<a href=\"https://gutenbergtimes.com/podcast/\">Gutenberg Changelog</a>&nbsp;podcast </strong><br />🎙️&nbsp;<a href=\"https://open.spotify.com/show/620NwVKQJGdTupy36zYxvg?mc_cid=4b6c9f88fe\">Spotify</a>&nbsp;|&nbsp;<a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9ndXRlbmJlcmd0aW1lcy5jb20vZmVlZC9wb2RjYXN0\">Google</a>&nbsp;|&nbsp;<a href=\"https://podcasts.apple.com/us/podcast/gutenberg-changelog/id1469294475\">iTunes</a>&nbsp;|&nbsp;<a href=\"https://pca.st/podcast/f8445ec0-7508-0137-f267-1d245fc5f9cf\">PocketCasts</a>&nbsp;|&nbsp;<a href=\"https://www.stitcher.com/show/gutenberg-changelog\">Stitcher</a>&nbsp;|<br />🎙️&nbsp;<a href=\"https://www.podbean.com/podcast-detail/chi7j-9904a/Gutenberg-Changelog-Podcast\">Pod Bean</a>&nbsp;|&nbsp;<a href=\"https://castbox.fm/channel/Gutenberg-Changelog-id2173375\">CastBox</a>&nbsp;|&nbsp;<a href=\"https://www.podchaser.com/podcasts/gutenberg-changelog-878239/\">Podchaser</a>&nbsp;|&nbsp;<a href=\"https://gutenbergtimes.com/feed/podcast\">RSS Feed</a>&nbsp;</p>\n\n\n\n<img />\n\n\n\n\n<h2>Plugin Developers</h2>\n\n\n\n<p><strong>Dave Smith</strong> published a tutorial on <a href=\"https://aheadcreative.co.uk/articles/mocking-wordpress-api-fetch-in-gutenberg-unit-tests/\"><strong>Mocking @wordpress/api-fetch in Gutenberg unit tests</strong></a>. During development you don&#8217;t want to hit an external API everytime you run a unit test, these instructions show you how to mock data coming from an API call in your block or site. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><a href=\"https://wordpress.org/plugins/genesis-custom-blocks/\">Genesis Custom Blocks</a>, (former Block Lab plugin) are a nifty tool to create blocks without going through the pain of learning modern JavaScript. You use the UI to create Field Groups and then add the PHP display code to your theme template. But what if you want to separate the newly create blocks from the theme? Then you could install it on multiple sites, and it would survive a site owners decision to switch themes without loosing content. <strong><a href=\"https://twitter.com/rob_stino\">Rob Stinson</a></strong> has a two-part tutorial for you on <a href=\"https://studiopress.blog/how-to-package-up-your-custom-blocks-in-a-plugin-part-1/\"><strong>How to package up your custom blocks in a plugin</strong></a>. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>Jeffery Carandang</strong>, a Gutenberg adopter of the first hour, <a href=\"https://jeffreycarandang.com/extendify-is-taking-over-the-editorskit-plugin-and-add-ons-shareablock-and-other-tools/\">found a new home for his Gutenberg entities</a>: <strong>Extendify. </strong> Jeffery has been pushing the envelope on what is possible with Gutenberg since it first came out in 2017. <a href=\"https://wordpress.org/plugins/coblocks/\"><strong>CoBlocks</strong></a>, co-authored with Rich Tabor and later sold to GoDaddy, was a favorite block plugin for additional blocks. <strong>EditorsKit</strong> extended blocks with additional tools. We mentioned his <a href=\"https://shareablock.com/\">Share a Block</a> directory on multiple episodes of the podcast. After starting at 10up, he didn&#8217;t find much time anymore for his love projects, especially the very useful <a href=\"https://wordpress.org/plugins/block-options/\">EditorsKit plugin</a> hasn&#8217;t seen updates for the last nine months. It now found a home at Extendify.  <br />See also: </p>\n\n\n\n<ul><li>Arthor Grabowski: <a href=\"https://extendify.com/extendify-is-adopting-the-editorskit-plugin/\">Extendify is Adopting the EditorsKit plugin</a></li><li>Justin Tadlock: <a href=\"https://wptavern.com/extendify-adopts-editorskit-increasing-its-block-plugin-collection\">Extendify Adopts EditorsKit, Increasing Its Block Plugin Collection</a></li></ul>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s main (trunk) branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n<p></p>\n\n\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p class=\"has-text-align-center\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\">Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n\n<p>Featured Image: Miami at Night by Birgit Pauli-Haack</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Sep 2021 18:15:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"Gutenberg Times: Over 50 Patterns in the  Pattern Directory, Learn Full-site editing, WordCamp Europe – Weekend Edition #173\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=18121\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"https://gutenbergtimes.com/over-50-patterns-in-the-pattern-directory-learn-full-site-editing-wordcamp-europe-weekend-edition-173/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:19249:\"<p>Howdy, </p>\n\n\n\n<p>After three and a half years, it was time to replace the WordPress theme on the Gutenberg Times. The trigger: I wrote about <a href=\"https://web.dev/measure/\">Core Web Vitals</a> for a different project and used the Gutenberg Times as a test project, using <a href=\"https://developers.google.com/web/tools/lighthouse\">Google&#8217;s Lighthouse</a> via an incognito browser window. The desktop version performed very well, all circles in the green range, but the mobile version really crawled over the Internet, ranking in the low 40ties. </p>\n\n\n\n<p><a href=\"https://searchengineland.com/google-postpones-page-experience-update-rollout-347862\">Google announced</a> earlier this year that they start rolling out new page experience update in this month, and start using Web Vitals as another ranking factor for organic search results. I also noticed that GT had a very high number of visitors via the desktop, but not many on mobile, which I found odd. Now I know why. </p>\n\n\n\n<p><a href=\"https://andersnoren.se/introducing-eksell/\">Anders Noren&#8217;s Eksell</a> is our new theme. I love the typography, the clean design. and its graphics. I just started exploring it. Nothing gets things done faster than working on the live site. 😊</p>\n\n\n\n<p>The content mostly converted well, except there are no widget areas, so I would need to add the widget via the Legacy widget block. It was hit-and-miss. This exercise turned out to be a great test for the new block-based Widget screen, which will come to a WordPress instance near you in the 5.8 release on July 20th, 2021. </p>\n\n\n\n<p>From the discussions, I learned that the Gutenberg team is leaning towards an opt-out rather than an opt-in implementation. Testing sites with this week&#8217;s <a href=\"https://wordpress.org/news/2021/06/wordpress-5-8-beta-1/\">WordPress 5.8 Beta 1</a>, is definitely recommended. If you don&#8217;t have time to test all the site you are working on, rest easy, there is a <a href=\"https://wordpress.org/plugins/classic-widgets/\">Classic Widget plugin</a> you can install to keep the old Widget screen.  </p>\n\n\n\n<p>What else happened this week? <strong>WordCamp Europe! </strong>It was a great virtual conference. Kudos to the organizers, speakers, sponsors and attendees! If you missed it, you can watch the <a href=\"https://www.youtube.com/channel/UCaYQGYDpXpU4A17kxN-AgJQ\">recordings on YouTube.</a></p>\n\n\n\n<p>The video with the <a href=\"https://wordpress.org/news/2021/06/gutenberg-highlights/\"><strong>Gutenberg Highlights</strong></a> is available for those of use who missed the Conversation with Matt Mullenweg. <strong>Matias Ventura</strong> wrote: &#8220;The video is wonderfully narrated by&nbsp;<strong>Beatriz Fialho</strong>, and it was a great opportunity to celebrate all the incredible work that contributors are doing around the globe to improve the editing and customization experience of WordPress&#8221;. I will <a href=\"https://gutenbergtimes.com/wordcamp-europe-2021-starts-monday/\">update my earlier WCEU post </a>with links to videos and resources over the course of next week. </p>\n\n\n\n<p>As always, I am so glad you are here, reading the eNews every week. Thank you! </p>\n\n\n\n<p>Yours, 💕<br />Birgit</p>\n\n\n\n\n\n<div class=\"wp-container-61660729d9344 wp-block-group has-primary-color has-light-background-background-color has-text-color has-background\"><div class=\"wp-block-group__inner-container\">\n<p class=\"has-normal-font-size\"><strong><a href=\"https://us02web.zoom.us/webinar/register/8816229019893/WN_gyOVb1h4S4iO_UZi1GMQaA\">Join us for our next Live Q &amp; A</a> </strong>on <strong>June 24, 2021, at 11am EDT / 15:00 UTC</strong></p>\n\n\n\n<a href=\"https://us02web.zoom.us/webinar/register/8816229019893/WN_gyOVb1h4S4iO_UZi1GMQaA\"><img /></a>\n\n\n\n<p><strong><a href=\"https://us02web.zoom.us/webinar/register/8816229019893/WN_gyOVb1h4S4iO_UZi1GMQaA\">Theme.json for Theme Authors or building themes for full-site editing in WordPress.</a></strong><br /><strong>Host</strong>: Birgit Pauli-Haack<br /><strong>Panel:</strong>&nbsp;Daily Olson, Tammie Lister and Jeff Ong           <span class=\"has-inline-color\"><strong><a href=\"https://us02web.zoom.us/webinar/register/8816229019893/WN_gyOVb1h4S4iO_UZi1GMQaA\">Register Now</a></strong></span></p>\n</div></div>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<h2>WordPress 5.8 Release Cycle</h2>\n\n\n\n<p><a href=\"https://wordpress.org/news/2021/06/wordpress-5-8-beta-1/\">WordPress 5.8 Beta 1</a> was release on Tuesday. You can use the official  <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">Beta Tester Plugin </a>to test this version. If you haven&#8217;t used it before, the Core Team share information and <a href=\"https://make.wordpress.org/core/handbook/testing/beta-testing/\">instructions in their handbook</a>.</p>\n\n\n\n<p>You can read more about the <a href=\"https://make.wordpress.org/core/5-8/\">development cycle of WordPress 5.8 here</a>. Feature Freeze for this upcoming version was May 25. We are right now in the beta phase of the cycle. It will be used for testing and to fix bugs. That is to last until June 29, 2021, when the first Release Candidate will be released.  That&#8217;s also the deadline for Dev Notes and Field Guide. It also comes with a hard-string freeze. That&#8217;s the moment the Polyglots team starts with translations. </p>\n\n\n\n<h3>Features and updates for WordPress 5.8</h3>\n\n\n\n<p>Speaking of <strong>DevNotes</strong>, the Gutenberg team tracks their progress on the  DevNotes via <a href=\"https://github.com/WordPress/gutenberg/issues/32365\">this GitHub issue.</a>  You can get a head start on <a href=\"https://gist.github.com/gziolo/cbea77500316a243e445d509ced3c231\"><strong>&#8220;Block API Enhancements&#8221;</strong></a> by <strong>Grzegorz Ziolkowski</strong> or <strong><a href=\"https://github.com/WordPress/gutenberg/issues/32365#issuecomment-853726663\">&#8220;Contextual patterns for easier creation and block transformations&#8221;</a> </strong>by <strong>Nik Tsekouras</strong> before they are published on the Make Core blog. </p>\n\n\n\n<p><strong>Anne McCarthy</strong> posted about other <strong>Block Editor Enhancements:</strong> </p>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/core/2021/05/20/core-editor-improvement-contextual-patterns-for-easier-creation/\">Contextual patterns for easier creation</a>  and </li><li>How to <a href=\"https://make.wordpress.org/core/2021/06/09/core-editor-improvement-improve-your-workflow-with-list-view/\">improve your workflow with List View</a>, the former Block Navigator feature. </li></ul>\n\n\n\n<p>On the WordPress News Blog, you found earlier: <a href=\"https://wordpress.org/news/2021/05/coloring-your-images-with-duotone-filters/\"><strong>Coloring Your Images With Duotone Filters</strong></a> by <strong>Alex Lende</strong>. Yes, I am in love with it, that&#8217;s why I mentioned it again. Gutenberg 10.7 also brought the methods to <strong>disable  duotone </strong>via the theme.json file. <a href=\"https://github.com/WordPress/gutenberg/pull/32002\">The details are in this Lende&#8217;s PR</a>. </p>\n\n\n\n<p><strong>Adam Silverstein</strong> published <a href=\"https://make.wordpress.org/core/2021/06/07/wordpress-5-8-adds-webp-support/\">WordPress 5.8 adds WebP support</a> dev note. It&#8217;s not directly a block editor update but crucial for content creators and developers alike, especially in context of the Core Web Vitals when speed is becomes of the essence. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<h2>Gutenberg Changelog</h2>\n\n\n\n<p>It&#8217;s been two years since Mark Uraine and I started the <a href=\"https://gutenbergtimes.com/podcast\">Gutenberg Changelog</a> podcast, and he was my co-host for the first 40 episodes. Grzegorz Ziolkowski joined me as co-host with episode 41. In February 2021, we celebrated the first 10,000 downloads. Now four months later, we passed the 26,000 mark of downloads. For such a narrow niche show, these are mind-boggling numbers.  It is very humbling.  We are very grateful for our faithful listeners! Thank you all very much. </p>\n\n\n\n<p><strong>Grzegorz Ziolkowski</strong> is back from vacation, and we recorded episode 45. We covered Gutenberg 10.7 and 10.8 releases, WordCamp Europe and WordPress 5.8.  It will be published later this weekend. The similar t-shirts? Mere coincidence! </p>\n\n\n\n<img />\n\n\n\n<h2>Gutenberg 10.8</h2>\n\n\n\n<p><strong>Gutenberg 10.8</strong> was released this week. It had quite a few enhancements, and a ton of bug fixes and underlying code change for quality and tooling. <strong>Sandip Mondal</strong> work on his first release and published the release notes: <a href=\"https://make.wordpress.org/core/2021/06/10/whats-new-in-gutenberg-10-8-9-june/\"><strong>What’s new in Gutenberg 10.8? (9 June)</strong></a>. </p>\n\n\n\n<p>Justin Tadlock has more details <strong><a href=\"https://wptavern.com/gutenberg-10-8-adds-new-typography-controls-and-block-previews\">Gutenberg 10.8 Adds New Typography Controls and Block Previews</a></strong></p>\n\n\n\n<p>The enhancements for full-site editing and theme design controls are already for the next WordPress release (5.9) in December and require more testing before they are available for WordPress Core. </p>\n\n\n\n<h2>Block Patterns</h2>\n\n\n\n<p><strong>Kjell Reigstad</strong> posted an invitation for the WordPress community to submit Block Patterns to the official WordPress directory. In his post <a href=\"https://make.wordpress.org/design/2021/06/08/initial-patterns-for-the-wordpress-org-patterns-directory/\"><strong>Initial Patterns for the WordPress.org Patterns Directory</strong></a>, he explained the details of the submission process.  </p>\n\n\n\n<p><strong>Justin Tadlock</strong>, a big fan of block patterns, wrote about the invitation on the <a href=\"https://wptavern.com/open-invitation-to-contribute-to-the-wordpress-block-pattern-directory\">WordPress Tavern </a>and showcased some of his creations. <strong>Ana Segota, </strong>co-founder of <a href=\"https://www.anarieldesign.com/\">Anariel Design</a> shared <a href=\"https://twitter.com/Ana_Segota/status/1402688373421187080\">her submissions via Twitter.</a> </p>\n\n\n\n<p>You can <a href=\"https://github.com/WordPress/pattern-directory/issues?q=is{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}3Aissue+label{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}3A{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}22{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5BType{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5D+Pattern+Submission{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}22+is{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}3Aclosed\"><strong>review the list of submissions on GitHub</strong></a> and learn from the comments on by the design team. Brian Gardner, Tammie Lister, Mel Choyce, Kjell Reigstad and Beatriz Fialho also contributed patterns to the directory. </p>\n\n\n\n<a href=\"https://wordpress.org/patterns\"><img /></a><a href=\"https://wordpress.org/patterns\">Block Patterns on WordPress.org</a> submitted by members of the design team and from the WordPress community. \n\n\n\n<p class=\"is-style-default\">In total, I counted 54 block patterns available to WordPress users. What a great start! </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<h2>Full Site Editing</h2>\n\n\n\n<p>At WordCamp Europe 2021, the Panelist <strong>Danielle Zarcaro, Grzegorz Ziółkowski, Koen Van den Wijngaert and Milana Cap</strong> discussed Full Site editing and what it means for the broader WordPress community. <a href=\"https://gutenbergtimes.com/wordcamp-europe-full-site-editing-panel-discussion/\"><strong>We have the recording and the transcript for you</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<p>We added the Blockbase Theme to the list of<a href=\"https://gutenbergtimes.com/themes-for-full-site-editing-and-getting-ready-for-wordpress-5-8-weekend-edition-172/#fsethemes\"> available FSE themes</a> last week. <strong>Kjell Reigstad</strong> published <a href=\"https://themeshaper.com/2021/06/07/using-blockbase-for-a-theme-experiment/\">Using Blockbase for a theme&nbsp;experiment</a> on the ThemeShaper blog and take you on a journey on creating a child theme of Blockbase. He wrote &#8220;Overall, I found that the benefit to using Blockbase was peace of mind. Compared to starting fresh or using&nbsp;<code>emptytheme</code>, Blockbase ensured that I had a fully functional block theme immediately.&#8221; Kjell also shared his code on GitHub.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<p>The <strong>WPMarmite Team</strong> publish the results of their <a href=\"https://wpmarmite.com/en/fse-study/\"><strong>Full Site Editing Study: Will WordPress theme shops embrace this new paradigm?</strong></a> They studied the involvement in the current FSE development of 127 Theme shops.  </p>\n\n\n\n<p>At first glance, these seemed to be a little premature, considering that only architecture for themes supporting FSE is coming to WordPress at the end of July. It certainly sets the base numbers to see what will happen until December. These are the numbers to watch changing in the next half year, and it will answer the original questions. </p>\n\n\n\n<ul><li><strong>57{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}</strong>&nbsp;of theme shops&nbsp;<strong>feature their Gutenberg compatibility</strong>.</li><li>Only&nbsp;<strong>17{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}</strong>&nbsp;of theme shops&nbsp;<strong>offer custom Gutenberg blocks</strong>.</li><li><strong>3{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}</strong>&nbsp;of theme shops&nbsp;<strong>provide block patterns</strong>.</li></ul>\n\n\n\n<p>The team also talked to 22 theme shops about their intentions regards full-site editing.  <a href=\"https://wpmarmite.com/en/fse-study/\">You need to read the article to learn more</a>.  </p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<p><strong>Fränk Klein</strong> at WPDeveloper Courses, released his new course: <a href=\"https://wpdevelopment.courses/courses/building-block-based-themes/\"><strong>Building Block-Based Themes</strong></a>. If you want to learn how to build a real-life example theme and all the ins and outs for a theme using the full-site editing capabilities and theme.json.  </p>\n\n\n\n<p>On Fullsiteediting.com, <strong>Carolina Nymark</strong> has been offering her <a href=\"https://fullsiteediting.com/courses/full-site-editing-for-theme-developers/\">Full Site editing course</a> for free, but that might change soon. </p>\n\n\n\n<p><strong>Joe Casabona</strong> at <a href=\"https://creatorcourses.com/\">CreatorCourses </a>is also working on an update of his Gutenberg Theme course. </p>\n\n\n\n<p>My take-away from the acquisitions of Atomic Blocks, Co Blocks etc. is that early adopters found it quite worth their while to deal with the ever-moving goal posts while developing along site Gutenberg developers.  The future is yours! </p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2 id=\"events\">Upcoming WordPress Events</h2>\n\n\n\n<p><strong>June 6, 2021</strong> <strong>7:00 pm EDT / 23:00 UTC</strong><br /><strong><a href=\"https://www.meetup.com/Philadelphia-WordPress-Meetup-Group/events/278507419/\">WordPress Meetup Philadelphia</a></strong><br />Full Site Editing Review and Test-a-thon</p>\n\n\n\n<p><strong>June 7 &#8211; 9th, 2021</strong><br /><strong><a href=\"https://europe.wordcamp.org/2021/\">WordCamp Europe</a></strong><br />A virtual event and contributor day. <a href=\"https://europe.wordcamp.org/2021/call-for-sponsors/\">Call for sponsors is open.</a></p>\n\n\n\n<p><strong>🎉</strong>  Gutenberg Times is a media partner of WordCamp Europe 2021 </p>\n\n\n\n<p><strong>June 10th, 2021</strong><br /><strong><a href=\"https://www.meetup.com/SF-WordPress-Users/events/278491308\">WordPress &#8220;Mega Meetup&#8221;: Plugins That Keep Websites Running</a></strong></p>\n\n\n\n<p><strong>June 20 &#8211; 26, 2021</strong><br /><strong><a href=\"https://japan.wordcamp.org/2021/\">WordCamp Japan</a></strong><br /><em>The schedule has been posted. Most sessions will be in Japanese, with exceptions, I think&#8230; </em></p>\n\n\n\n<p><strong>June 24, 2021 </strong><br /><strong><a href=\"https://attend.wpengine.com/summit-us-2021/\">WPEngine Summit 2021</a></strong><br /><em>The digital breakthrough conference</em> <a href=\"https://events.wpengine.com/event/fd217870-fc78-46d2-8c5e-96c85e6e371c/websitePage:645d57e4-75eb-4769-b2c0-f201a0bfc6ce?environment=P2&tm=nSwmA1-ZyLXwe2wM80Vzve3wDjKBWeqKrHbJFivPV4o&locale=en-US\">released their schedule</a>. Personally, I am very much looking forward to the Keynote talk with <strong>Reshma Saujani</strong>, founder of Girls Who Code and Marshall Plan for Moms at 12:55 EDT / 16:55 UTC.  I also hope to see talks with Rob Stinson, Carrie Dils and Chris Wiegman. There are also deep dive talks listed into Headless WordPress. Enterprise WordPress is definitely heading down that route. </p>\n\n\n\n<p><strong>June 24 &#8211; 26, 2021</strong><br /><strong><a href=\"https://cochabamba.wordcamp.org/2021/\">WordCamp Cochabama</a></strong> (Colombia) </p>\n\n\n\n<p><strong>July 17 + 18th, 2021</strong><br /><strong><a href=\"https://santaclarita.wordcamp.org/2021/\">WordCamp Santa Clarita</a></strong><br />Calls for speakers ends TODAY! </p>\n\n\n\n<p><strong>July 23, 2021</strong><br /><a href=\"https://www.wordfest.live/\"><strong>WordFest Live </strong></a>&#8211; <em>The&nbsp;</em>festival of WordPress</p>\n\n\n\n<p>A<strong>ugust 6 + 7, 2021</strong><br /><a href=\"https://nicaragua.wordcamp.org/2021/\"><strong>WordCamp Nicaragua</strong></a></p>\n\n\n\n<p><strong>September 21 + 22, 2021</strong><br /><a href=\"https://2021.wpcampus.org/\"><strong>WPCampus 2021 Online</strong></a><br />&#8220;A free online conference for web accessibility and WordPress in higher education.&#8221;</p>\n\n\n\n<hr class=\"wp-block-separator\" id=\"block-ee0670b9-9b56-410a-a5c8-1febc106dca5\" />\n\n\n\n<p id=\"block-8c56f083-3d78-42e0-84ec-62ea90a2afa5\">On the<a href=\"https://wpcalendar.io/online/\"> <strong>Calendar for WordPress Online Events</strong> </a>you can browse a list of the upcoming WordPress Meetups, around the world, including WooCommerce, Elementor, Divi Builder and Beaver Builder meetups.</p>\n\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p class=\"has-text-align-center\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\">Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n\n<p>Featured Image: <a href=\"https://unsplash.com/@xavi_cabrera?utm_source=unsplash&utm_medium=referral&utm_content=creditCopyText\">Photo by&nbsp;</a><a href=\"https://unsplash.com/@pawel_czerwinski?utm_source=unsplash&utm_medium=referral&utm_content=creditCopyText\">Pawel Czerwinski</a>&nbsp;on&nbsp;<a href=\"https://unsplash.com/s/photos/blocks-of-flats?utm_source=unsplash&utm_medium=referral&utm_content=creditCopyText\">Unsplash</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Sep 2021 18:15:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Gutenberg Times: WordCamp Europe: Full-Site Editing Panel discussion\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=18145\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://gutenbergtimes.com/wordcamp-europe-full-site-editing-panel-discussion/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:43875:\"<p>It was announced as a discussion panel about the present and future of WordPress with Full Site Editing.</p>\n\n\n\n<p>The panelists, highly involved in this new feature, discussed many topics about FSE and how it is going to be a new revolution in the WordPress ecosystem.</p>\n\n\n\n<p>The Panelist were <a href=\"https://europe.wordcamp.org/2021/speaker/danielle-zarcaro/\">Danielle Zarcaro</a>, <a href=\"https://europe.wordcamp.org/2021/speaker/grzegorz-ziolkowsk/\">Grzegorz Ziółkowski</a>, <a href=\"https://europe.wordcamp.org/2021/speaker/koen-van-den-wijngaert/\">Koen Van den Wijngaert</a> and <a href=\"https://europe.wordcamp.org/2021/speaker/milana-cap/\">Milana Cap</a></p>\n\n\n\n<p>Jose Ramon Padron and Lesley Molecke moderated the discussion. </p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<div class=\"toolbelt-video-wrapper\"></div>\n</div>\n\n\n\n<p>Torque Magazine did an outstanding job live tweeting. </p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">\"With FSE a theme developer can develop with a more solid foundation. More of their time and energy can be spent building things that have more value for their customers\" <a href=\"https://twitter.com/vdwijngaert?ref_src=twsrc{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5Etfw\">@vdwijngaert</a></p>&mdash; Torque (@TheTorqueMag) <a href=\"https://twitter.com/TheTorqueMag/status/1401945858598338562?ref_src=twsrc{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}5Etfw\">June 7, 2021</a></blockquote>\n</div>\n\n\n\n<p class=\"has-large-font-size\" id=\"0-the-transcript-and-table-of-contents\"><strong>The transcript and table of contents</strong></p>\n\n\n\n<div class=\"wp-block-sortabrilliant-guidepost\"><ul><li><a href=\"https://gutenbergtimes.com/feed/#0-introduction-of-the-topic-and-the-panelists\">Introduction of the topic and the panelists</a></li><li><a href=\"https://gutenbergtimes.com/feed/#1-what-is-full-site-editing-and-where-did-it-come-from-nbsp\">What is full site editing and where did it come from?</a></li><li><a href=\"https://gutenbergtimes.com/feed/#2-what-problem-does-full-site-editing-solve\">What problem does Full-Site Editing solve?</a></li><li><a href=\"https://gutenbergtimes.com/feed/#3-what-happens-to-websites-that-are-live-in-production-when-word-press-5-8-is-released\">What happens to websites that are live (in production) when WordPress 5.8 is released?</a></li><li><a href=\"https://gutenbergtimes.com/feed/#4-what-does-full-site-editing-change-for-the-various-word-press-stakeholders\">What does Full Site Editing change for the various WordPress stakeholders </a></li><li><a href=\"https://gutenbergtimes.com/feed/#5-why\">Why will Full-Site Editing be in Core and not a plugin?</a></li><li><a href=\"https://gutenbergtimes.com/feed/#6-w\">What will be the role of existing page builders?</a></li><li><a href=\"https://gutenbergtimes.com/feed/#7-what-is-going-to-happen-with-the-rest-of-the-open-source-solutions-like-joomla-drupal\">What is going to happen with the rest of the open-source solutions like Joomla, Drupal?</a></li></ul></div>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><em>José Ramón Padron:</em> Hello, Lesley.</p>\n\n\n\n<p><em>Lesley Molecke:</em> Hey, Moncho.</p>\n\n\n\n<p><em>José Ramón Padron:</em> I&#8217;m laughing, because this is the moment my neighbor started to do this at home. I don&#8217;t know. I hope it doesn&#8217;t sound through the microphone, but I&#8217;m hearing a hammer quite hard on that building. I hope it&#8217;s not-</p>\n\n\n\n<p><em>Lesley Molecke:</em> I can&#8217;t hear anything, but listen, I&#8217;m ready for this next session. I can&#8217;t believe that we&#8217;re already here. It&#8217;s already the final session of the day, and it&#8217;s going to be a good one.&nbsp;</p>\n\n\n\n<h2 id=\"0-introduction-of-the-topic-and-the-panelists\">Introduction of the topic and the panelists</h2>\n\n\n\n<p><em>José Ramón Padron:</em> Yes, it&#8217;s true. It&#8217;s going to be a good one, because we have a lot of good people talking about a quite good and hot topic inside the WordPress community. One of the things we are going to have, really near in, I don&#8217;t know, in 5.8, in the next version of WordPress, full site editing?</p>\n\n\n\n<p><em>Lesley Molecke:</em> Yes. We would like to welcome our panelists. This is a panel presentation, so it should be a good conversation with a number of experts speaking. So they will join us here on stage in just a moment. Hello, hello. Hi, everybody.&nbsp;</p>\n\n\n\n<p><em>Grzegorz Ziółkowski:</em> Hello.</p>\n\n\n\n<p><em>Koen Van den Wijngaert:</em> Hello, there.&nbsp;</p>\n\n\n\n<p><em>Lesley Molecke:</em> Will you please introduce yourselves?&nbsp;</p>\n\n\n\n<p><em>Milana Cap:</em> Which order?</p>\n\n\n\n<p><em>Lesley Molecke:</em> As you wish.&nbsp;</p>\n\n\n\n<div class=\"wp-block-image is-style-rounded\"><img />Milana Cap</div>\n\n\n\n<p><em>José Ramón Padron:</em> So let&#8217;s start with Milana, just for talking.</p>\n\n\n\n<p><em>Milana Cap: </em>Because I&#8217;m the loudest. Well, you said expert. I&#8217;m here just for the cookies and to bribe contributors to come to documentation. Also, I&#8217;m here as documentation team co-rep. And I&#8217;m the docs focus lead for a new release, 5.8. I should be knowing what&#8217;s happening, hopefully soon. I&#8217;m Milana from Serbia.&nbsp;</p>\n\n\n\n<p><em>Lesley Molecke:</em> How about you, Danielle?</p>\n\n\n\n<p><em>José Ramón Padron:</em> Thank you so much.</p>\n\n\n\n<p><em>Danielle Zarcaro:</em> Sure. I&#8217;m having an issue too. I don&#8217;t know whether he&#8217;s blowing leaves or mowing the lawn? I don&#8217;t know what&#8217;s happening.&nbsp;</p>\n\n\n\n<div class=\"wp-block-image is-style-rounded\"><img />Danielle Zarcaro</div>\n\n\n\n<p><em>Lesley Molecke:</em> We can&#8217;t hear it, it&#8217;s okay.</p>\n\n\n\n<p><em>Danielle Zarcaro:</em> Good. I&#8217;m Danielle. I&#8217;m from the US. I am the head of paperback web development. We build custom WordPress websites and maintain them, and maintain existing websites, and all that that comes with. We just launched overnightwebsite.com. So that&#8217;s mostly what I deal with is the old and the new of WordPress. So it&#8217;s the whole range.</p>\n\n\n\n<p><em>José Ramón Padron:</em> Thanks, Danielle. Let&#8217;s go with Koen.</p>\n\n\n\n<div class=\"wp-block-image is-style-rounded\"><img /><em>Koen Van den Wijngaert</em></div>\n\n\n\n<p><em>Koen Van den Wijngaert:</em> Hey, hi, there. Is this thing on? Hey, Good evening. I&#8217;m Koen. I&#8217;m a WordCamp and meetup organizer from Belgium. I run my own company called NEOK IT, where I provide software consultancy, partly around WordPress. I&#8217;ve been working with WordPress for a few years now. I like to learn things, as well as challenge myself while doing it.&nbsp;</p>\n\n\n\n<p>So for a while now, I&#8217;ve been casually contributing to Gutenberg, as a way of giving back and mostly getting more accustomed to the ins and outs of the project. So that&#8217;s me.&nbsp;</p>\n\n\n\n<div class=\"wp-block-image is-style-rounded\"><img src=\"https://i1.wp.com/pbs.twimg.com/profile_images/1047874472403845121/ckX4uiBZ_400x400.jpg?resize=203{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}2C203&ssl=1\" alt=\"Image\" width=\"203\" height=\"203\" /><em>Grzegorz Ziółkowsk</em></div>\n\n\n\n<p><em>Grzegorz Ziółkowski:</em> It looks like it&#8217;s me now. So my name is Grzegorz Ziółkowski. I live in Oleśnica, Poland, and I work at Automatic, where I spend all time contributing to the WordPress core. My main focus is Gutenberg. I was helping to merge changes from the plugin, Gutenberg plugin to the WordPress core for the upcoming WordPress 5.8 release, which won&#8217;t contain all the necessary pieces of the full site editing. However, there is a lot of new goodies coming that will be ready to use on the site.&nbsp;</p>\n\n\n\n<p><em>Lesley Molecke:</em> Excellent. So Moncho and I have come up with a bunch of questions for you. They go from really basic, and then they work up and get more and more exciting and interesting. So we&#8217;re going to start with the first one, which is actually, this is my question, because I don&#8217;t know the answer to it yet and hopefully you will educate me. What is full site editing and where did it come from?&nbsp;</p>\n\n\n\n<h2 id=\"1-what-is-full-site-editing-and-where-did-it-come-from-nbsp\">What is full site editing and where did it come from?</h2>\n\n\n\n<p><em>Koen Van den Wijngaert:</em> Maybe if I can start, maybe the best thing to say at first is that full site editing is not just a big monolithic heap of a big function. It&#8217;s better to think of it as a collection of a lot of features that come with Gutenberg, as part of the second phase of the Gutenberg roadmap. Maybe someone else can pitch in now, so I don&#8217;t do a monologue.</p>\n\n\n\n<p><em>Grzegorz Ziółkowski:</em> If you don&#8217;t take a bigger picture, so full site editing is part of the Gutenberg project, there are four phases. And we are reaching this year, the end of phase two. The first one was introducing the building blocks for editing content. Now, we will be editing a full canvas of the sites. And the next two phases are collaborative editing. So to let people collaborate when they are changing websites or writing content. And the fourth one is multilingual support.</p>\n\n\n\n<p><em>Koen Van den Wijngaert:</em> What everyone is waiting for, I believe. That&#8217;s going to be a big one.&nbsp;</p>\n\n\n\n<h2 id=\"2-what-problem-does-full-site-editing-solve\">What problem does Full-Site Editing solve?</h2>\n\n\n\n<p><em>José Ramón Padron:</em> Anything else? Anything else? Because one of the things inside of Lesley&#8217;s question is, what problem does it solve? Which is, I think, very interesting. What do you think?</p>\n\n\n\n<p><em>Milana Cap:</em> I think that the problem it&#8217;s trying to solve is to give the user one unique workflow to edit everything. Because at this moment, you have post, you have page, and you go to block editor. Or if you are not brave enough, you&#8217;re still using classic editor and you edit your content there.&nbsp;</p>\n\n\n\n<p>But then you want to change your logo, then you have to go to customizer. But then you have some theme options. And it depends on theme from theme, what will you edit and where? I believe the idea is to release end user from need to know everything about the theme, you just go there and you just edit.&nbsp;</p>\n\n\n\n<p>And if you want to edit footer, and you&#8217;re on the post and you&#8217;re editing post, and then you realize the menu is not correct, you edit menu. You don&#8217;t need to know, because nobody cares is it customizer or whatever? People care to know where it is. And it&#8217;s a good thing that you can see how it looks on the front end, which I think was the initial idea for Gutenberg. But who knows? Maybe I&#8217;m wrong.</p>\n\n\n\n<p>I think that&#8217;s a huge problem that will be fixed, and solved with full site editing. For us who are building websites, I know that for every website, I have to create a ton of tutorials and everything, to show clients how to use it. And this will solve all that. So we will be out of job.</p>\n\n\n\n<p><em>Koen Van den Wijngaert:</em> I also like to think that it brings a lot of power and more freedom and flexibility to end users of a website. Because in the traditional way of doing things, there&#8217;s a few ways one can have a WordPress website. He can have an agency, have a website built for him. Or he could be using some sort of a theme builder, or he could have installed a theme from the theme directory or maybe it&#8217;s even a custom theme.</p>\n\n\n\n<p>But now end users are able to have so much more power about editing templates, and editing all sorts of aspects of their website. I think that&#8217;s really exciting to look forward to.&nbsp;</p>\n\n\n\n<p><em>Danielle Zarcaro:</em> I think it solves a couple of problems, to add to that. It takes away some of the ambiguity around how to edit each individual thing. So WordPress&#8217;s whole thing is to democratize publishing. There were areas of the websites that were just not available to edit to anyone who doesn&#8217;t know code.&nbsp;</p>\n\n\n\n<p>So there&#8217;s the ease of use gap that came about, that you can&#8217;t edit the 404 page, you can&#8217;t edit the header or footer, unless an option is available. Is the theme using the site logo that you upload in WordPress, or you&#8217;re going to upload the image and then theme isn&#8217;t going to show it. It gets rid of those, however the theme developer decided to do it that day, and it streamlines a lot of that process to do some expected behavior to make it easier for anyone to hop into a site and edit it, and it democratizes publishing on a whole new level.&nbsp;</p>\n\n\n\n<p><em>Koen Van den Wijngaert:</em> That&#8217;s a nice way of saying it. Yes. Because right now there&#8217;s this huge fragmented world of all different ways of themes that came up with our own way of editing site features and headers and customizing things. But there&#8217;s no real standard way of doing that. So it just makes it harder to step out of that particular ecosystem, I think. I&#8217;m looking forward to the standardized way of doing theming in WordPress.</p>\n\n\n\n<p><em>José Ramón Padron</em>: Grzegorz, I think you had something. Yes.</p>\n\n\n\n<p><em>Grzegorz Ziółkowski:</em> I wanted to add some more to it. Because I think it&#8217;s important to note that it&#8217;s not only about unifying everything, but it&#8217;s also to giving the power to users to change those little bits that annoy them, like the color of the header, or the font size.&nbsp;</p>\n\n\n\n<p>Before, you would have, or either learn CSS or learn HTML just to edit that. But now you will have tools that will allow that, and you won&#8217;t have to call your site administrator to do a simple change. So maybe you could tell that, remove the job from those people who maintain those sites, but on the other hand, they will have more time to work on expanding their offering and improving their own products or services, just to use the time.</p>\n\n\n\n<p>So this is something that sounds scary, but on the other hand, it opens a lot of possibilities. Because the idea of blocks also gives you the power that you can create your own blocks that you can use in several websites, and give additional functionality out of the box for your customers.</p>\n\n\n\n<h2 id=\"3-what-happens-to-websites-that-are-live-in-production-when-word-press-5-8-is-released\">What happens to websites that are live (in production) when WordPress 5.8 is released?</h2>\n\n\n\n<p><em>José Ramón Padron:</em> So regarding that this is something new, something is going to happen from 5.8, as far as I know, what happens to the WordPress websites that are already live and in production? Must they be rebuilt in order to use full site editing? Or they&#8217;re going to work in the way they are?&nbsp;</p>\n\n\n\n<p><em>Milana Cap:</em> They have to be rebuilt completely. It will crash. No, it won&#8217;t.</p>\n\n\n\n<p><em>Koen Van den Wijngaert</em>: It will just crash when you update.&nbsp;</p>\n\n\n\n<p><em>Milana Cap:</em> No, it won&#8217;t.</p>\n\n\n\n<p><em>Lesley Molecke:</em>That&#8217;s big news.&nbsp;</p>\n\n\n\n<p><em>Koen Van den Wijngaert:</em> Oh, we were not supposed to say that, sorry.</p>\n\n\n\n<p><em>Milana Cap:</em> No, they will not be crashed, they will not have to be rebuilt completely. As you all know, WordPress always build in mind with what is already out there, not to crash anything. And in 5.8, not everything will get in. So if I&#8217;m wrong, please correct me, but I think that in 5.8, you will have to install a Gutenberg plugin to actually use full site editing. So not everything will be there, but it will be foundation for the next releases when everything else will come in.&nbsp;</p>\n\n\n\n<p>But still, we will have some nice things coming in and nothing will break. You can go part by part and rebuilding it and adapting for a complete editing experience.&nbsp;</p>\n\n\n\n<p><em>José Ramón Padron:</em> Thanks, Milana. Anything to add ?</p>\n\n\n\n<p><em>Koen Van den Wijngaert:</em> Maybe Grzegorz can do it.&nbsp;</p>\n\n\n\n<p><em>Grzegorz Ziółkowski:</em> You can go.&nbsp;</p>\n\n\n\n<p><em>Koen Van den Wijngaert:</em> Okay, but you can just&#8230; Well, some of the full site editing features will be added to 5.8, I think, but Grzegorz will probably be able to say which one exactly. I&#8217;m hearing feedback.&nbsp;</p>\n\n\n\n<p><em>José Ramón Padron:</em> An echo. There is an echo.</p>\n\n\n\n<p><em>Koen Van den Wijngaert:</em> So it&#8217;s not some monolithic feature, like we said before, but it&#8217;s more like a collection of features and they won&#8217;t be turned off all at once by default, by just upgrading to WordPress 5.8. You do need to have a full site editing team to enable all features, but some of them will also be available for non-block based themes.&nbsp;</p>\n\n\n\n<p>Things like the template editor blocks, the site logo, the tagline, the query blocks, posts, posts related blocks, like post title, post [inaudible 00:14:45], they will all be made available in the post editor. And as well as that, I think it was also possible to also not edit, but with add new templates to a normal theme and edit those in the template editor. It&#8217;s pretty awesome.&nbsp;</p>\n\n\n\n<p><em>Grzegorz Ziółkowski:</em> So the first step is to allow people to change, use the block-based paradigm on a single page. So think about that, about previously you would have to create a PHP file to change a single page view. And now you will be able to do that to through UI, and that will create an override that you would be able to delete later. But as a user, so it&#8217;s more like empowering people who have access to the sites, rather that&#8217;s a feature for the team designer.</p>\n\n\n\n<p>So that&#8217;s one thing. And everything like that is optional, so there will be a flag to disable that. So site owners or theme authors we will say that, &#8220;I don&#8217;t want that,&#8221; and they can remove that.&nbsp;</p>\n\n\n\n<p>The one big change is that not necessarily related to full site editing, but is somehow in the same area is the widget editor, which will be&#8230; I don&#8217;t know what&#8217;s the final decision, but it will be depending on the feedback from the testing, either an opt-in or opt-out.</p>\n\n\n\n<p>So the idea would be that you will be able to use the same blogs you use in your content to use also in site, when you would previously use widgets. So that&#8217;s a nice change. If you have your own custom blocks, you would be able to put there as well, which will open those new possibilities, and also somehow unify the interface.&nbsp;</p>\n\n\n\n<p>But as you could hear, there is a lot of new blocks coming. But it&#8217;s just addition, it&#8217;s not something that you have to use. It&#8217;s just there if you want to try them out, that will be perfect time to do that after 5.8 is out. And there is a-</p>\n\n\n\n<p><em>Koen Van den Wijngaert:</em> That will be released tomorrow, by the way. So if you want to test it, please do so. It&#8217;s by a lot of users that can test and provide feedback on the new update that we can improve upon those things, and decide what can be added and what should be skipped. So go install it tomorrow.</p>\n\n\n\n<p><em>Lesley Molecke:</em>Yes, we should acknowledge that, that everyone here is actually working really hard right now to create the new release, while also attending WordCamp Europe and being here on this panel and contributing on track too, and y&#8217;all are everywhere. Thank you, thank you, thank you for your time.&nbsp;</p>\n\n\n\n<h2 id=\"4-what-does-full-site-editing-change-for-the-various-word-press-stakeholders\">What does Full Site Editing change for the various WordPress stakeholders </h2>\n\n\n\n<p>My next question has to do with stakeholders. So obviously, a big change like this to WordPress has multiple stakeholder groups. It has the end users, the users of WordPress websites down the road. It has the editors of WordPress websites. It has the companies who build themes and the companies who build plugins, and the people who contribute, all of these different groups.&nbsp;</p>\n\n\n\n<p>I&#8217;m interested in talking about the theme creators who currently primarily rely on offering block patterns with their own header and footer and sidebar management. So how does that work with full site editing?</p>\n\n\n\n<p><em>Danielle Zarcaro:</em> Well, it works the same way. You can offer whatever you want. I think it&#8217;s a misconception that by giving the users the ability to do what they want means that they&#8217;ll be able to do anything they want. If you are someone like me who&#8217;s creating custom sites, you can actually more easy put options and make it so that you don&#8217;t have to install a whole extra plugin to add a couple of extra options. You reserve that for the bigger projects that you&#8217;re doing.</p>\n\n\n\n<p>And it&#8217;s up to the theme creators, if they&#8217;re creating a theme on a wider scale, instead of just an individual client, that&#8217;s up to them to decide how they want it to work. They just opt into stuff, they add stuff, they add their custom options, but it&#8217;s all working within the same ecosystem, and we&#8217;re all speaking the same language now instead.</p>\n\n\n\n<p>So if you don&#8217;t want to make it so that your header and your footer and your sidebars are manageable in the block editor or in full site editing, then I guess you don&#8217;t have to. You can hard code whatever you want, you can do that now, you don&#8217;t have to make any options available.&nbsp;</p>\n\n\n\n<p>But then at some point, you&#8217;re going to start to fall behind, in terms of what you&#8217;re able to do. So it&#8217;s going to work the same way, just with more possibilities. That&#8217;s how I go about looking at it.&nbsp;</p>\n\n\n\n<p><em>Koen Van den Wijngaert:</em> You&#8217;ll be able to turn off or on, or even tweak some of the configuration options just by providing a single JSON file for those things. But also, I like to think that with full site editing, a theme developer or theme designer can benefit from a more solid foundation that is standardized and optimized for things like accessibility, usability and performance.&nbsp;</p>\n\n\n\n<p>That way more of their time and energy can be spent into building things that actually add value to their customers, all the while benefiting from the existing full site editing features and even tweaking them to their liking. So that&#8217;s a big plus, I think. So they don&#8217;t have to go and reinvent the wheel every time they build a new website.</p>\n\n\n\n<p><em>José Ramón Padron:</em> There is something related to the last major change we saw in WordPress, when Gutenberg appears, when Gutenberg finally was born in 5.0. And now you can see that there is a plugin that is the old editor. And at this moment, we this kind of legacy, we can call it legacy, but it&#8217;s still available there.&nbsp;</p>\n\n\n\n<h2 id=\"5-why\">Why will Full-Site Editing be in Core and not a plugin?</h2>\n\n\n\n<p>My question is about why there are things that can sit in the core, and a different one can be set as a plugin? For example, why put the full site editing in the core when it is something that the majority of users at this moment don&#8217;t know? And we hope all of them are going to use it, but as everything that comes new in WordPress, there is always a time for getting used to it.&nbsp;</p>\n\n\n\n<p>So what do you think is the main reason full site editing is in the core and not, for example, in a plugin and people can choose if they want it or not?</p>\n\n\n\n<p><em>Milana Cap:</em> I think that now that we have Gutenberg in core, and full site editing is obviously expansion of what we were using in core by now, I think it would be silly not to have it in core and have it as a plugin, when you can use&#8230; This is just a foundation to put all the blocks that you already have. So it&#8217;s not like the structure that you still don&#8217;t have, you have. There is Gutenberg and now you will just expand it to the whole website.</p>\n\n\n\n<p>And there is benefit in having everything standardized, especially for people who are using themes from our repository. So when you switch theme, you have all those available, things to edit, you know where it is, and you have all the blocks available.</p>\n\n\n\n<p><em>José Ramón Padron:</em> Makes sense.</p>\n\n\n\n<p><em>Milana Cap:</em> So that&#8217;s a huge benefit. I love that theme in wordpress.org is insisting on idea that people will change themes, and they cannot lose anything. I love that idea. I think this will really help having that.&nbsp;</p>\n\n\n\n<p>So when you have custom themes, and people have different ways of editing right now the header, the footer, or they don&#8217;t have it at all, so you&#8217;re afraid to change the theme. But with full site editing, you will have all that available.</p>\n\n\n\n<p>Now, as far as not knowing how to use it goes, we didn&#8217;t know many things, how to use. And the thing that we really need right now is, here comes my pitch, documentation. So we really, really need to document everything good, because when you don&#8217;t have documentation, people don&#8217;t know how to use it and then they don&#8217;t interact with it enough. They don&#8217;t find bugs, they don&#8217;t contribute. They don&#8217;t think ideas how to expand it, and you don&#8217;t have contributors, and there is no cycle for open source. So first, we need to do a good documentation.&nbsp;</p>\n\n\n\n<p>We did fail a bit with Gutenberg getting in, and we can still feel it. We can still feel developers who are frustrated and don&#8217;t know how to work with it and how to build on that. I&#8217;m asking everyone to come and help. While doing documentation, you will actually learn how to do it.&nbsp;</p>\n\n\n\n<p>I&#8217;m not afraid of new things. I don&#8217;t think anyone should be afraid, especially because this is not a really new thing, like Gutenberg was a new thing. We didn&#8217;t know what it was. Now we know, full site editing is what we already know, it&#8217;s new, but expanded, so it&#8217;s easier to learn. And if we do enough work, and we are doing&#8230; people make WordPress themes are doing great job.</p>\n\n\n\n<p>Just mentioning few, Anne is doing the testing, great job, and Carolina even have a website for full site editing where you can read everything. So it&#8217;s doing better, and we can learn and there are resources, so there&#8217;s no need to be afraid of it.&nbsp;</p>\n\n\n\n<p><em>Koen Van den Wijngaert:</em> And if I&#8217;m not mistaken, there&#8217;s even seven milestones added to the full site editing milestones. It&#8217;s called gradual adoption. So that it focuses solely on making sure that full site editing features are being adopted better and more gradual. And that work is being put into actually making sure that the documentation is on par, and that the dev notes are up to date, and all of that kind of thing. So that&#8217;s also important. That&#8217;s also part of the work that&#8217;s now being done after the feature freeze for the 5.8 features.&nbsp;</p>\n\n\n\n<p><em>Danielle Zarcaro:</em> I think from my perspective, as someone who&#8217;s working with it and working with people, no one&#8217;s going to use it if you make it optional. People are going to do what they&#8217;re going to do, if you let them.&nbsp;</p>\n\n\n\n<p>I think WordPress itself has never, it&#8217;s been very transparent about where it&#8217;s going. We&#8217;ve all been able to use Gutenberg for years now. We&#8217;ve been able to install the plugin, and then we&#8217;ve been able to use the block editor in core for years now. So it&#8217;s like we&#8217;ve had this getting used to period.</p>\n\n\n\n<p>So we&#8217;re just going in the direction that we said we&#8217;d go in, and people can still find ways to go backwards. They can still install the classic plugin for sites that need it, they can install the classic plugin for certain things. They cannot enable the block editor for custom post types. There&#8217;s all kinds of stuff that you can do to counteract some of that.&nbsp;</p>\n\n\n\n<p>But like I referenced before, and I&#8217;ve talked a lot about this in the past, at some point, you have to embrace the tool that you&#8217;re using. So you&#8217;re either going to embrace the fact that we&#8217;re all working towards the same goal, or you&#8217;re working against it and basically forking your own version and working on your own, which is fine. But then you can&#8217;t offer the latest stuff.&nbsp;</p>\n\n\n\n<p>I think it&#8217;s up to you as a developer to, on some level, work with things, and meet WordPress where it is. You have to give up. WordPress is open source. You have to allow yourself to go with the tide a little bit.&nbsp;</p>\n\n\n\n<p>And when you have new users who come into WordPress, who are installing things, they&#8217;re not going to know that there was an old WordPress. They&#8217;re not going to know that, oh, I have to install this other plugin to enable all of these awesome features. You have to think forward. So you have to allow these new users to start installing it, and use all the cool latest stuff.&nbsp;</p>\n\n\n\n<p>If someone wants to go backwards for a bit, then they can put the work in to do that.&nbsp;</p>\n\n\n\n<p><em>Grzegorz Ziółkowski: </em>It&#8217;s also worth mentioning that the full site editing, it&#8217;s soon to be included in the core, it&#8217;s always something that we wanted to have. It&#8217;s not something that came, because there was the 5.0 release and the block editor. It&#8217;s the other way around.</p>\n\n\n\n<p>So we took the smallest step possible to enable people to start using this block paradigm, start learning UI. We got a lot of feedback. And if you look at the iterations that worked, how the editor looked two and a half years ago and how it looks now, it&#8217;s a completely different product.</p>\n\n\n\n<p>And also the way, how we people started thinking about building content with blocks is different. It&#8217;s not longer, building small custom blocks, but rather combining a lot of existing blocks into block patterns, into having UIs, having ways to change a big portion of the page with solutions. Like now it&#8217;s coming to the query block that allows you to switch the list of blog posts will be displayed on the page.</p>\n\n\n\n<p>So we are constantly trying to make it easier for users to provide the infrastructure, also for plugin authors, for theme authors, so they can build upon that, and have the unified experience. So people, once they learn how to write a post, they will know how to change the template of the page, because it&#8217;s exactly the same paradigm.&nbsp;</p>\n\n\n\n<p>It&#8217;s even in the same UI interface. You just go from one page to another, without the page reload. Everything can happen, you can go back, you can revisit how it looks when you compose everything together. It&#8217;s no longer you need to go to the preview of the page and see another tab to see, oh, it looks good, but now something broke outside of the post content. I need to go find customizers and go to this template, or call the theme author on the support and change that for me.&nbsp;</p>\n\n\n\n<p>So this is a huge project, and has so many layers on top of that. We want to bring as much as possible, I would say, what makes sense to most of the users, but not all of them. Because there is always room for extenders to build their own solutions on top of that, and give this unique perspective and look and feel for the customers.</p>\n\n\n\n<h2 id=\"6-w\">What will be the role of existing page builders?</h2>\n\n\n\n<p><em>Lesley Molecke:</em> I feel like we&#8217;re tiptoeing closer and closer to this question. I&#8217;m just going to ask it, just get it out there on the table. What do you all feel is the big role for the online page builders, the Divi, the Elementor, these big guys, taking into account that we&#8217;re moving into full site editing, block patterns, all of these things that are being built into WordPress core? What is the role of these page builders that so many of us use?&nbsp;</p>\n\n\n\n<p><em>Danielle Zarcaro:</em> I think that&#8217;s up to them. I think ultimately, they were there to push the envelope. They were there to bring us to where we currently are. I think without them, we might not have had this extra push. Maybe it would have taken a few more years to put all this into core. These builders saw this hole and filled it.&nbsp;</p>\n\n\n\n<p>And ultimately, they&#8217;re going to have a different UI anyway. So they&#8217;re going to do have their fan base, they&#8217;re going to have their whatever preference to editing things, maybe certain things are dragging and dropping. Whatever they make available, they&#8217;re going to extend WordPress. So that&#8217;s up to them to decide how they&#8217;re going to go about it.&nbsp;</p>\n\n\n\n<p>So they&#8217;re all already currently working with the block editor, all the major ones anyway are. If they&#8217;re concerned at all about future proofing themselves, they&#8217;ve already looked into how to integrate themselves with the block editor. I think it&#8217;s only going to enhance everything to see how they go about integrating themselves into the new ecosystem.&nbsp;</p>\n\n\n\n<p>I really love, as a developer, I love the way Oxygen goes about it, where you can build stuff, and then go and edit it in Gutenberg. So that&#8217;s a really cool take on it. And so it&#8217;s just a new way to innovate, and they&#8217;re going to have their place.</p>\n\n\n\n<p>I think it&#8217;s cool that we now have these established things. We have these people to look to, to see where are the new holes in WordPress? Where can we go from here? And they&#8217;re going to continue to just push the envelope. I love the diversity that&#8217;s out there.&nbsp;</p>\n\n\n\n<p>When you talk about builders, there&#8217;s at least four that come to mind and that&#8217;s awesome. And I hope that it stays that way and grows. And that&#8217;s only going to help us. And so hopefully, it&#8217;ll take away some of that, Divi does this way and Elementor does this way. So some things are going to hopefully become uniform, and then they&#8217;ll branch out in other ways.&nbsp;</p>\n\n\n\n<p><em>Koen Van den Wijngaert:</em> Exactly. Because now, there&#8217;s a few big ones indeed, and they all seem to have their own ecosystem surrounding them, which is okay, because as you said, they all implement and provide their own stream of users to the WordPress platform. So it&#8217;s definitely interesting to look at, and observe how they will interact with WordPress and Gutenberg.</p>\n\n\n\n<p>I know most of them already have some sort of a way to either include a new template view or something as a block, or even toggle between Gutenberg and their own editor. But the thing I&#8217;m actually quite looking forward to is whether or not they will start using the new default way of doing things. So that they can actually merit from how it is now going to be supposed to be done, and add on top of that their own set of features and new value-adding stuff.&nbsp;</p>\n\n\n\n<p>Like the cadence theme, for example, is doing. In my eyes, it&#8217;s quite a nice way of implementing Gutenberg the right way. I&#8217;m very interested to see how they will be going to implement full site editing things in the near future, because now it&#8217;s all in the customizer, of course. So, interesting.&nbsp;</p>\n\n\n\n<h2 id=\"7-what-is-going-to-happen-with-the-rest-of-the-open-source-solutions-like-joomla-drupal\">What is going to happen with the rest of the open-source solutions like Joomla, Drupal?</h2>\n\n\n\n<p><em>José Ramón Padron:</em> We were talking about how full site editing can affect the own WordPress ecosystem, talking about for example, what happens with the builders, builders like Divi, Elementor, et cetera. But what do you think, taking account you are developers, designers, you are on the technical side, contributors, what do you think is going to happen with the rest of the open source solutions like Joomla, Drupal? How do you think it&#8217;s going to affect? So it&#8217;s going to make WordPress better than the rest, it&#8217;s going to be a real advantage in front of the rest, like Wix, like the other ones, not only in the open source reality, but outside WordPress? What do you think is going to happen with full site editing?</p>\n\n\n\n<p><em>Milana Cap: </em>They will all take Gutenberg. Drupal already do it.</p>\n\n\n\n<p><em>Koen Van den Wijngaert:</em> But Drupal also has a [crosstalk 00:37:15]. But there&#8217;s not like this CMS is better than the other one. They all serve different purposes. And it&#8217;s like using the right tool for the right job. And having more competition in the game is pretty good actually.</p>\n\n\n\n<p>I think the biggest reason that we, as WordPress, have the biggest market share to date in the CMS market is because of the low threshold to start building websites. And that&#8217;s partly thanks to all of those theme builders. I think it&#8217;s important to reach out and make sure that we all keep using WordPress and not just fork off their own version of WordPress, because it&#8217;s open source, they can do that.&nbsp;</p>\n\n\n\n<p>So if we all collaborate, we can build pretty nice things, I think.&nbsp;</p>\n\n\n\n<p><em>Milana Cap:</em> I think we already saw this many times in history, but let&#8217;s just take a look at Internet Explorer 6. It was so bad that we got this good Chrome and Firefox. And it was so difficult to create posts for some people in WordPress, that we got page builders. So this is happening. There is always this kind of competition between WordPress and Joomla and Drupal.&nbsp;</p>\n\n\n\n<p>But the truth is, they all have their share. Ours is a little bigger than theirs, but they will continue to exist, and I hope they will push, they will invent something new. And then we will be jealous, and we will do something better, because that&#8217;s how it works. Human mind compares. So that&#8217;s what we do.</p>\n\n\n\n<p>I&#8217;m proud that 12 years ago I have selected WordPress and now it&#8217;s 40{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}. I think I&#8217;m smart, because I did that. But I don&#8217;t like just one way of doing things. I like things messing up. I like people inventing new things. That makes us all better and everything makes better.&nbsp;</p>\n\n\n\n<p>I&#8217;m really looking forward to see what other CMSs will do, but also what will page builders do. I have never used page builder, as someone who builds website and some of you uses website. I cannot say anything.&nbsp;</p>\n\n\n\n<p>But I&#8217;m seeing in our WordPress Serbia Facebook group, I&#8217;m seeing people asking questions about it. I know what they are doing and how, and I really hope to see they invent something insane, so we will have to push Gutenberg again and just pushing forward.&nbsp;</p>\n\n\n\n<p><em>Koen Van den Wijngaert:</em> Even better.</p>\n\n\n\n<p><em>Danielle Zarcaro:</em> I think it&#8217;s going to blur the line a little bit. Because I just recently had to go into a Wix site and it is no longer Wix or Weebly. It is Wix or Webflow. Webflow popped up as an in between to Weebly and the GoDaddy builder and WordPress.</p>\n\n\n\n<p>I think it blurs the line a little bit, where you can now visually edit things and you can now edit those parts, like I said, the 404. All these other things, you can just do now. And so I think it blurs the line and WordPress can now fit into more categories as well.</p>\n\n\n\n<p>So maybe it&#8217;s not a Squarespace, which is a template machine that you stick a bunch of stuff in and it&#8217;s easy, but it does open it up to a whole nother market. Instead of just, oh, you got to have somebody on your side, it now opens the door for more people. And then now they&#8217;re ready to grow, and now they come to you and are familiar with WordPress.&nbsp;</p>\n\n\n\n<p>So there&#8217;s the three or four other markets that&#8217;ll pop up as well. So it blurs a little bit and makes it a little more accessible.&nbsp;</p>\n\n\n\n<p><em>Grzegorz Ziółkowski:</em> There&#8217;s also one thing that I&#8217;m looking forward to, is the blog patterns directory, which should enable a quicker creation of websites, instead of going, changing everything yourself. If you don&#8217;t have, like me, skills for designing, you just pick something that someone crafted very carefully. And maybe pay some fee for that and have unique experience for all the use cases you have.</p>\n\n\n\n<p>It&#8217;s no longer you need to use one theme, and hope that it has all the solutions you need. Instead, you can combine from different sources and build the best experience you need. So that&#8217;s one thing.</p>\n\n\n\n<p>One thing that I&#8217;m looking forward to is how I&#8217;m seeing the growth of headless. It&#8217;s getting a lot of attention at the conferences in the WordPress community. And that interaction with full site editing, I&#8217;m looking forward how that will evolve. Because at the moment, if you want to use headless solutions you need to build from scratch the front end side.</p>\n\n\n\n<p>However, if you combine that with what Gutenberg can produce and reach that, that will open a new set of possibilities. And that will bring big companies looking at WordPress, because now they will be able to build completely custom solutions, and also use whatever WordPress provides in its core, rather treating it as a source of the content only.</p>\n\n\n\n<p><em>José Ramón Padron:</em> I&#8217;m glad to read that question.&nbsp;</p>\n\n\n\n<p><em>Lesley Molecke:</em> Koen, you have one final thing to add, before we sign off?</p>\n\n\n\n<p><em>Koen Van den Wijngaert:</em> I was going to say that one obstacle might be that a lot of back end developers have mostly skills in writing PHP and stuff. But most of the new features, you really do benefit more if you have a JavaScript back end. I think we should also focus on helping those developers transition into more and more adopting JavaScript and active development to develop even better new solutions.</p>\n\n\n\n<p><em>Milana Cap: </em>And documentation.&nbsp;</p>\n\n\n\n<p><em>Koen Van den Wijngaert:</em> Most importantly, of course.&nbsp;</p>\n\n\n\n<p><em>Lesley Molecke: </em>Yes. Well, thank you, thank you, thank you all for this really interesting conversation. I now know more about full site editing than I do before, thanks to you. But also, I think our audience does as well, which is fantastic.</p>\n\n\n\n<p>And again, thank you for taking the time to join us, even though you&#8217;re also so, so busy working on the new release, and working on this massive change to WordPress. We&#8217;re really grateful to you and your time. Enjoy the rest of the conference. We will see you later and thank you.&nbsp;</p>\n\n\n\n<p>Will you be heading over to the Q&amp;A room to talk with the audience? Does that sound like a familiar thing to you? All right.&nbsp;</p>\n\n\n\n<p><em>Milana Cap:</em> We can, if there are questions.</p>\n\n\n\n<p><em>José Ramón Padron:</em> There will be.</p>\n\n\n\n<p><em>Lesley Molecke:</em> People can also make meetings with you and see you in other rooms and things.</p>\n\n\n\n<p><em>José Ramón Padron:</em> There will be more content related full site editing during WordCamp Europe, in each day, I think, or also in the number two track. So this is not the last time we are going to talk about full site editing.&nbsp;</p>\n\n\n\n<p>Another thing is to say thank you for accepting our invitation, more or less in the last minute. Thank you. Thank you so much.</p>\n\n\n\n<p><em>Lesley Molecke:</em>Thank you all.</p>\n\n\n\n<p><em>Milana Cap:</em> Thank you, bye.&nbsp;</p>\n\n\n\n<p><em>Grzegorz Ziółkowski:</em> Thank you.</p>\n\n\n\n<p><em>Koen Van den Wijngaert:</em> Thank you. Very nice to being here.&nbsp;</p>\n\n\n\n<p><em>José Ramón Padron:</em> See you around. Ta-ta.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Sep 2021 18:15:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"Gutenberg Times: Themes for Full-Site Editing and Getting ready for WordPress 5.8 – Weekend Edition #172\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=18038\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"https://gutenbergtimes.com/themes-for-full-site-editing-and-getting-ready-for-wordpress-5-8-weekend-edition-172/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:19490:\"<p>Howdy, </p>\n\n\n\n<p>It&#8217;s the eve of the second virtual <a href=\"https://europe.wordcamp.org/2021/\"><strong>WordCamp Europe</strong></a>. Tickets are still available for another awesome three days with talks, workshops and contributor events. This year, the organizer decide to sprinkle contributor event into the rest of the schedule and have for all three days, a mix between techtalk, business talks and contributor presentation and discussions. There are quite a few events around the Block editor, Full-site-editing and block-based themes. <a href=\"https://gutenbergtimes.com/wordcamp-europe-2021-starts-monday/\">I compiled a list for you.</a> And just because I am so focused on Gutenberg, doesn&#8217;t mean you have to. 😎 <a href=\"https://europe.wordcamp.org/2021/schedule/\">Check out the schedule</a> and <a href=\"https://europe.wordcamp.org/2021/registration/\">get your tickets now</a>. </p>\n\n\n\n<p>Hopefully, it will be the last virtual conference and we will see each other at an in-person WordCamp Europe in 2022. I am still hoping for Porto, Portugal.  At this state of withdrawal from meeting WordPress friends in person, it doesn&#8217;t matter where it will take place, thought. It&#8217;ll be a Hug-Fest. </p>\n\n\n\n<p>Last week, I mentioned the next<a href=\"https://us02web.zoom.us/webinar/register/4216223029678/WN_gyOVb1h4S4iO_UZi1GMQaA\"> <strong>Gutenberg Times Live Q &amp; A</strong></a> in the subscribers-only section of this newsletter. Now we have a full panel. <a href=\"https://us02web.zoom.us/webinar/register/4216223029678/WN_gyOVb1h4S4iO_UZi1GMQaA\">Registration is officially open</a>. I am thrileed to host Daisy Olsen, Jeff Ong and Tammie Lister for our show on <strong>How to get started on Theme building for Full-site Editing and using the Theme.json file</strong> to configure your theme, and its interaction with the block editor. The Theme.json file will be introduced with the release of WordPress 5.8 in July 2021. <a href=\"https://us02web.zoom.us/webinar/register/4216223029678/WN_gyOVb1h4S4iO_UZi1GMQaA\">Get a head start and join us!</a></p>\n\n\n\n<p><strong>Grzegorz (Greg) Ziolkowski</strong> will be back from vaction next week and we will record our next <strong>Changelog </strong>episode on Friday 11, 2021. I am so excited and can&#8217;t wait until Grzegorz is back!  If you have questions or suggestions or news, you want us to consider, hit reply or send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. We now have consitently 500 &#8211; 800 downloads per week. It&#8217;s humbling, mind-boggling and inspiring.  And if YOU are a listener, Thank You!  If you have a minute or two, <a href=\"https://lovethepodcast.com/gutenbergchangelog\">consider writing a review of the podcast</a>. We&#8217;d be grateful and might read it out loud on the next show. </p>\n\n\n\n<p>Alright, that&#8217;s the news around Gutenberg Times. Below you&#8217;ll find what else happened in the Gutenberg universe. Enjoy! </p>\n\n\n\n<p>Yours, 💕<br />Birgit</p>\n\n\n\n<p><em>PS: Hope to see you at WordCamp Europe. Don&#8217;t forget to join the #WCEU channel on WordPress Slack and meet speaker, sponsors, organizer and attendees like you and me. </em></p>\n\n\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<h2>Full-Site-Editing &amp; Themes</h2>\n\n\n\n<p><strong>Anne McCarthy</strong> published the <a href=\"https://make.wordpress.org/test/2021/06/02/fse-program-stick-the-landing-pages-summary/\"><strong>Stick the landing (pages) Summary</strong></a>. This post is a summary of the sixth call for testing for the experimental FSE outreach program, which also was translated into Italian to reach more of the non-English audience. Earlier calls were also translated into Japanese. The group of FSE testers is much bigger now, thanks to the persistent efforts by Anne to reach out to the community and stay on top of all the issues around the template editor. </p>\n\n\n\n<p>A reminder: You can still join the the seventh call for testing:<a href=\"https://make.wordpress.org/test/2021/05/26/fse-program-testing-call-7-polished-portfolios/\"> </a><strong><a href=\"https://make.wordpress.org/test/2021/05/26/fse-program-testing-call-7-polished-portfolios/\">Polished Portfolios</a> </strong>&#8211; The deadline for your feedback was extended to June 16th, 2021. </p>\n\n\n\n<p>If you read this before Sunday night, you can participate in the <a href=\"https://www.meetup.com/Philadelphia-WordPress-Meetup-Group/events/278507419/\"><strong>Full Site Editing Review and Test-a-thon </strong></a>Sunday, June 6th at  7 &#8211; 8:30 pm with the <strong>WordPress Meetup </strong>group in Philadelphia. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>Reading through the summary,  I am stuck on trying to understand the difference between a template built by the site-owner and a theme template. What will happen with their templates when the site-owner decides to change the overall theme of their site? There is still plenty to be figured out. <strong><a href=\"https://github.com/WordPress/gutenberg/pull/31971\">How edited block templates are linked to themes</a></strong> is topic of the discussion on GitHub. The Gutenberg team would appreciate some thoughts from folks familiar with these APIs (theme mods, performance, database).</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>Kjell Reigstad</strong> posted again acomprehensive list of issues and discussions regarding block-based themes and Full-Site Editing: <a href=\"https://make.wordpress.org/themes/2021/06/04/gutenberg-themes-week-of-may-31-2021/\"><strong>Gutenberg + Themes: Week of May 31, 2021</strong></a>. Any of the listed items are worth checking out and consider commenting. The more the team knows the better the next iteration of Full-Site editing and block-based themes becomes. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<h2>WordPress 5.8 release preparations</h2>\n\n\n\n<p>From the <a href=\"https://make.wordpress.org/core/2021/06/05/devchat-meeting-summary-june-2-2021/\">meeting notes of this week&#8217;s Dev Chat</a>: &#8220;Docs needs the most help with end user documentation. For block editor in particular. Some changes from 5.6 and 5.7 are still not published and we had a significant drop in number of contributors due to pandemic situation. Anyone interested in getting involved please&nbsp;ping <strong><a href=\"https://twitter.com/DjevaLoperka\">Milana Cap</a></strong>&nbsp;&nbsp;(<strong>zzap</strong>&nbsp;on&nbsp;Slack).&nbsp;</p>\n\n\n\n<p>The summary of needed <strong><a href=\"https://github.com/WordPress/gutenberg/issues/32365\">DevNotes for new features in WordPress 5.8</a></strong> is available on GitHub and could use contributors. There is also a <a href=\"https://github.com/WordPress/gutenberg/pulls?q=is{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}3Apr+is{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}3Amerged+label{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}3A{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}22Needs+Dev+Note{bbackup_94402fb9ba80f392e0976ece85f92b2b876bfcaed8d83250cc06083f7139c7d9}22\">&#8220;needs dev note&#8221; label for pull requests</a>. </p>\n\n\n\n<p>The widget screen could use some more testing. As a reminder, please read<strong> <a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://make.wordpress.org/core/2021/05/12/help-test-the-widgets-editor-for-wordpress-5-8/\">Help Test the Widgets Editor for WordPress 5.8</a></strong> by <a href=\"https://twitter.com/andraganescu\"><strong>Andre Draganescu</strong></a></p>\n\n\n\n<h2>Block Patterns</h2>\n\n\n\n<p><strong>Hector Pietro</strong> wrote in his post <a href=\"https://make.wordpress.org/core/2021/06/04/whats-next-in-gutenberg-june-2021/\"><strong>What’s next in Gutenberg? (June 2021)</strong></a>: </p>\n\n\n\n<p>&#8220;Since&nbsp;<a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/core/2021/05/27/whats-new-in-gutenberg-10-7-26-may/\" target=\"_blank\">Gutenberg 10.7</a>, block patterns displayed in the inserter are fetched from the&nbsp;<a rel=\"noreferrer noopener\" href=\"https://wordpress.org/patterns/\" target=\"_blank\">WordPress.org Pattern Directory</a>. This opens the door to having a big amount of wonderful patterns available in the inserter, which will require&nbsp;<a rel=\"noreferrer noopener\" href=\"https://github.com/WordPress/gutenberg/issues/31153\" target=\"_blank\">iterating on the pattern insertion experience</a>. </p>\n\n\n\n<p>For more updates on the Pattern Directory, stay tuned for&nbsp;<a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/meta/2021/04/28/block-pattern-directory-update/\" target=\"_blank\">Block Pattern Directory updates</a>&nbsp;and check the most recent&nbsp;<a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/design/tag/patterns-directory/\" target=\"_blank\">design iterations for the Pattern Directory</a>.&#8221;. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<h2>Plugins for the Block Editor</h2>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/feature-box/\"><strong>Featured Box Plugin</strong></a> with this plugin &#8220;you can highlight a image with your key features&#8221; wrote <strong>Sumaiya Siddika</strong> on WordPress.org. <a href=\"https://wptavern.com/building-featured-boxes-with-the-wordpress-block-editor?utm_source=dlvr.it&utm_medium=twitter&utm_campaign=building-featured-boxes-with-the-wordpress-block-editor\">Justin Tadlock took it for a spin.</a></p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://wordpress.org/plugins/jetformbuilder/\">JetFormBuilder — Form Builder plugin for Gutenberg</a></strong> from the plugins stable at CrocoBlock. The developers <a href=\"https://profiles.wordpress.org/mjhead/\">Andrey Shevchenko</a> and <a href=\"https://profiles.wordpress.org/hugreed/\">Oleksandr Ivanenko</a> also added an extensive Post action hook system that allows you to daisy chain actions and integrated with 3rd party systems. I haven&#8217;t tested it yet, but it looks promising. Crocoblock has been building plugins and tools for Elementor and has now started supporing Gutenberg with their products as well. </p>\n\n\n\n<p>Another new plugin is the <a href=\"https://crocoblock.com/plugins/jetengine-gutenberg/\"><strong>JetEngine for Gutenberg</strong></a>  a dynamic content plugin that lets you build a complex websites fast and cost-effectively.</p>\n\n\n\n<h2 id=\"fsethemes\">Themes for Full-Site Editing</h2>\n\n\n\n<p>A few people ask about Themes that are already working with the Full-Site Editing system and Site Editor. So I put a list together of those I know about. Now before you use them, you need to be aware that they are all built while Full-Site Editing is still under active development, hasn&#8217;t been released yet and ergo many features are still experimental. Do not use in production or live site. </p>\n\n\n\n<ul><li><a href=\"https://wordpress.org/themes/blockbase/\">Block Base</a> by Automattic</li><li><a href=\"https://wordpress.org/themes/naledi/\">Naledi </a>by Anariel Design </li><li><a href=\"https://wordpress.org/themes/tt1-blocks/\">TT1 Blocks</a> by WordPress contributors, the FSE sibling of the Twenty-Twenty-One Theme</li><li><a href=\"https://wordpress.org/themes/block-based-bosco/\">Block-Based Bosco</a> by Fränk Klein</li><li><a href=\"https://wordpress.org/themes/armando/\">Armando</a> by Carolyn Newmark</li><li><a href=\"https://wordpress.org/themes/q/\">Q </a>by Ari Stathopoulos</li><li><a href=\"https://wordpress.org/themes/hansen/\">Hansen</a> by Uxl Themes</li></ul>\n\n\n\n<p>If you find any missing, let me know.</p>\n\n\n\n<h2>Gutenberg related Business Updates</h2>\n\n\n\n<p>This week&#8217;s big WordPress business news is the aquisition of <strong><a href=\"https://twitter.com/elliotcondon\">Eliots Condon</a></strong>&#8216;s plugin <strong><a href=\"https://www.advancedcustomfields.com/\">Advanced Custom Fields</a></strong> (ACF)  by Delicious Brains. With over more then 1 million active installs ACF is one of the widest used plugins. Thousands for developers depened on it in the <a href=\"https://www.advancedcustomfields.com/blog/10-years-of-acf-a-truly-wonderful-time/\">last ten years</a> to build complex WordPress sites. </p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>Stepping away from ACF has not been an easy decision to make. The reasoning behind it comes from a place of humility. As the number of installs have grown from thousands to millions, the needs of the product have outgrown my ability to develop solutions. The last thing I want to do to this amazing community is unintentionally hold back the project, so something needed to change.</p><cite><a href=\"https://www.advancedcustomfields.com/blog/10-years-of-acf-a-truly-wonderful-time/\">Elliot Condon, ACF </a></cite></blockquote>\n\n\n\n<p>Early on into the development of the block editor, Candon was also developing a<strong> <a href=\"https://wptavern.com/block-building-without-javascript-testing-acf-block-lab-and-lazy-blocks\">php way to build blocks</a></strong> and integrated it into Advanced Custom Fields Pro starting with the version 5.8. This effort certainly helped developers even more. Now they could use their existing tools and offer their users Gutenberg compatible sites withouth learning ES6 JavaScript or ReactJS. </p>\n\n\n\n<p><strong><a href=\"https://deliciousbrains.com/\">Delicious Brains</a></strong> also caters to WordPress Developers with products like  <a href=\"https://spinupwp.com/\">SpinupWP</a> (💕), WP Migrate DB and more. Their team seems to be the right fit to pick up the torch and put ACF on an even stronger path for future growth. </p>\n\n\n\n<p>You can learn more about the aquisition via </p>\n\n\n\n<ul><li><a href=\"https://wptavern.com/delicious-brains-acquires-advanced-custom-fields-plugin\">WPTavern (Sarah Gooding)</a>, </li><li><a href=\"https://poststatus.com/excerpt/12/\">Post Status Excerpt</a> (Cory Miller &amp; David Bisset) , </li><li><a href=\"https://deliciousbrains.com/epic-wordpress-announcement/\">A WordPress Announcement of Epic&nbsp;Proportions</a> (Delicious Brain) </li><li><a href=\"https://www.advancedcustomfields.com/blog/10-years-of-acf-a-truly-wonderful-time/\">10 Years of ACF – A truly wonderful time </a></li></ul>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n\n<div class=\"wp-block-media-text alignfull is-stacked-on-mobile is-vertically-aligned-top is-image-fill has-background\"><a href=\"https://us02web.zoom.us/webinar/register/8816229019893/WN_gyOVb1h4S4iO_UZi1GMQaA\"><img /></a><div class=\"wp-block-media-text__content\">\n<p class=\"has-normal-font-size\"><strong><a href=\"https://us02web.zoom.us/webinar/register/8816229019893/WN_gyOVb1h4S4iO_UZi1GMQaA\">Join us for our next Live Q &amp; A</a> </strong><br />on June 24, 2021 at 11am EDT / 15:00 UTC</p>\n\n\n\n<p><strong>Theme.json for Theme Authors or building themes for full-site editing in WordPress.</strong><br /><strong>Host</strong>: Birgit Pauli-Haack<br /><strong>Panel:</strong>&nbsp;Daily Olson, Tammie Lister and Jeff Ong           <span class=\"has-inline-color\"><strong><a href=\"https://us02web.zoom.us/webinar/register/8816229019893/WN_gyOVb1h4S4iO_UZi1GMQaA\">Register Now</a></strong></span></p>\n</div></div>\n\n\n\n\n<h2 id=\"events\">Upcoming WordPress Events</h2>\n\n\n\n<p><strong>June 6, 2021</strong> <strong>7:00 pm EDT / 23:00 UTC</strong><br /><strong><a href=\"https://www.meetup.com/Philadelphia-WordPress-Meetup-Group/events/278507419/\">WordPress Meetup Philadelphia</a></strong><br />Full Site Editing Review and Test-a-thon</p>\n\n\n\n<p><strong>June 7 &#8211; 9th, 2021</strong><br /><strong><a href=\"https://europe.wordcamp.org/2021/\">WordCamp Europe</a></strong><br />A virtual event and contributor day. <a href=\"https://europe.wordcamp.org/2021/call-for-sponsors/\">Call for sponsors is open.</a></p>\n\n\n\n<p><strong>🎉</strong>  Gutenberg Times is a media partner of WordCamp Europe 2021 </p>\n\n\n\n<p><strong>June 10th, 2021</strong><br /><strong><a href=\"https://www.meetup.com/SF-WordPress-Users/events/278491308\">WordPress &#8220;Mega Meetup&#8221;: Plugins That Keep Websites Running</a></strong></p>\n\n\n\n<p><strong>June 20 &#8211; 26, 2021</strong><br /><strong><a href=\"https://japan.wordcamp.org/2021/\">WordCamp Japan</a></strong><br /><em>The schedule has been posted. Most sessions will be in Japanese, with exceptions, I think&#8230; </em></p>\n\n\n\n<p><strong>June 24, 2021 </strong><br /><strong><a href=\"https://attend.wpengine.com/summit-us-2021/\">WPEngine Summit 2021</a></strong><br /><em>The digital breakthrough conference</em> <a href=\"https://events.wpengine.com/event/fd217870-fc78-46d2-8c5e-96c85e6e371c/websitePage:645d57e4-75eb-4769-b2c0-f201a0bfc6ce?environment=P2&tm=nSwmA1-ZyLXwe2wM80Vzve3wDjKBWeqKrHbJFivPV4o&locale=en-US\">just released their schedule</a>. Personally, I am very much looking forward to the Keynote talk with <strong>Reshma Saujani</strong>, founder of Girls Who Code and Marchall Plan for Moms at 12:55 EDT / 16:55 UTC.  I also hope to see talks with Rob Stinston, Carrie Dils and Chris Wiegman. There are also deep dive talks listed into Headless WordPress. Enterprise WordPress is definitely heading down that route. </p>\n\n\n\n<p><strong>June 24 &#8211; 26, 2021</strong><br /><strong><a href=\"https://cochabamba.wordcamp.org/2021/\">WordCamp Cochabama</a></strong> (Colombia) </p>\n\n\n\n<p><strong>July 17 + 18th, 2021</strong><br /><strong><a href=\"https://santaclarita.wordcamp.org/2021/\">WordCamp Santa Clarita</a></strong><br />Calls for speakers ends TODAY! </p>\n\n\n\n<p><strong>July 23, 2021</strong><br /><a href=\"https://www.wordfest.live/\"><strong>WordFest Live </strong></a>&#8211; <em>The&nbsp;</em>festival of WordPress</p>\n\n\n\n<p>A<strong>ugust 6 + 7, 2021</strong><br /><a href=\"https://nicaragua.wordcamp.org/2021/\"><strong>WordCamp Nicaragua</strong></a></p>\n\n\n\n<p><strong>September 21 + 22, 2021</strong><br /><a href=\"https://2021.wpcampus.org/\"><strong>WPCampus 2021 Online</strong></a><br />&#8220;A free online conference for web accessibility and WordPress in higher education.&#8221;</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>On the<a href=\"https://wpcalendar.io/online/\"> <strong>Calendar for WordPress Online Events</strong> </a>you can browse a list of the upcoming WordPress Meetups, around the world, including WooCommerce, Elementor, Divi Builder and Beaver Builder meetups. </p>\n\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p class=\"has-text-align-center\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\">Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n\n<p>Featured Image: Photo by&nbsp;<a href=\"https://unsplash.com/@xavi_cabrera?utm_source=unsplash&utm_medium=referral&utm_content=creditCopyText\">Xavi Cabrera</a>&nbsp;on&nbsp;<a href=\"https://unsplash.com/s/photos/lego?utm_source=unsplash&utm_medium=referral&utm_content=creditCopyText\">Unsplash</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Sep 2021 18:15:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"Gutenberg Times: WordCamp Europe 2021 starts Monday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=17964\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\